# This file was automatically generated by bifcl from /opt/local/var/macports/build/zeek-c10ab06c/work/zeek-8.0.4/src/analyzer/protocol/dns/events.bif (plugin mode).

export {
## Generated for all DNS messages.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## is_orig:  True if the message was sent by the originator of the connection.
##
## msg: The parsed DNS message header.
##
## len: The length of the message's raw representation (i.e., the DNS payload).
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid  dns_query_reply dns_rejected
##    dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_message: event(c: connection , is_orig: bool , msg: dns_msg , len: count );


## Generated for DNS requests. For requests with multiple queries, this event
## is raised once for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## query: The queried name (normalized to all lowercase).
##
## qtype: The queried resource record type.
##
## qclass: The queried resource record class.
##
## original_query: The queried name, with the original case kept intact
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_request: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count , original_query: string );

global dns_request: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count );


## Generated for DNS replies that reject a query. This event is raised if a DNS
## reply indicates failure because it does not pass on any
## answers to a query. Note that all of the event's parameters are parsed out of
## the reply; there's no stateful correlation with the query.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## query: The queried name (normalized to all lowercase).
##
## qtype: The queried resource record type.
##
## qclass: The queried resource record class.
##
## original_query: The queried name, with the original case kept intact
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_rejected: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count , original_query: string );

global dns_rejected: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count );


## Generated for each entry in the Question section of a DNS reply.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## query: The queried name.
##
## qtype: The queried resource record type.
##
## qclass: The queried resource record class.
##
## original_query: The queried name, with the original case kept intact
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_rejected
##    dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_query_reply: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count , original_query: string );

global dns_query_reply: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count );


## Generated for DNS replies of type *A*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## a: The address returned by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A6_reply dns_CNAME_reply dns_EDNS_addl dns_HINFO_reply
##    dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_A_reply: event(c: connection , msg: dns_msg , ans: dns_answer , a: addr );


## Generated for DNS replies of type *AAAA*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## a: The address returned by the reply.
##
## .. zeek:see::  dns_A_reply dns_A6_reply dns_CNAME_reply dns_EDNS_addl dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_AAAA_reply: event(c: connection , msg: dns_msg , ans: dns_answer , a: addr );


## Generated for DNS replies of type *A6*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## a: The address returned by the reply.
##
## .. zeek:see::  dns_A_reply dns_AAAA_reply dns_CNAME_reply dns_EDNS_addl dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_A6_reply: event(c: connection , msg: dns_msg , ans: dns_answer , a: addr );


## Generated for DNS replies of type *NS*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply  dns_PTR_reply dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_NS_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string );


## Generated for DNS replies of type *CNAME*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply  dns_EDNS_addl dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_CNAME_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string );


## Generated for DNS replies of type *PTR*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply  dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_PTR_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string );


## Generated for DNS replies of type *CNAME*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## soa: The parsed SOA value.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_SOA_reply: event(c: connection , msg: dns_msg , ans: dns_answer , soa: dns_soa );


## Generated for DNS replies of type *WKS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_SPF_reply  dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_WKS_reply: event(c: connection , msg: dns_msg , ans: dns_answer );


## Generated for DNS replies of type *HINFO*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_HINFO_reply: event(c: connection , msg: dns_msg , ans: dns_answer , cpu: string , os: string );


## Generated for DNS replies of type *MX*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## preference: The preference for *name* specified by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply  dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_MX_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string , preference: count );


## Generated for DNS replies of type *TXT*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## strs: The textual information returned by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl  dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_TXT_reply: event(c: connection , msg: dns_msg , ans: dns_answer , strs: string_vec );


## Generated for DNS replies of type *SPF*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## strs: The textual information returned by the reply.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl  dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_SPF_reply: event(c: connection , msg: dns_msg , ans: dns_answer , strs: string_vec );


## Generated for DNS replies of type *CAA* (Certification Authority Authorization).
## For replies with multiple answers, an individual event of the corresponding type
## is raised for each.
## See `RFC 6844 <https://tools.ietf.org/html/rfc6844>`__ for more details.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## flags: The flags byte of the CAA reply.
##
## tag: The property identifier of the CAA reply.
##
## value: The property value of the CAA reply.
global dns_CAA_reply: event(c: connection , msg: dns_msg , ans: dns_answer , flags: count , tag: string , value: string );


## Generated for DNS replies of type *SRV*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## target: Target of the SRV response -- the canonical hostname of the
##         machine providing the service, ending in a dot.
##
## priority: Priority of the SRV response -- the priority of the target
##           host, lower value means more preferred.
##
## weight: Weight of the SRV response -- a relative weight for records
##         with the same priority, higher value means more preferred.
##
## p: Port of the SRV response -- the TCP or UDP port on which the
##    service is to be found.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_SRV_reply: event(c: connection , msg: dns_msg , ans: dns_answer , target: string , priority: count , weight: count , p: count );


## Generated for DNS replies of type *NAPTR*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## naptr: The parsed RDATA of NAPTR type record.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_SRV_reply dns_end
global dns_NAPTR_reply: event(c: connection , msg: dns_msg , ans: dns_answer , naptr: dns_naptr_rr );


## Generated on DNS reply resource records when the type of record is not one
## that Zeek knows how to parse and generate another more specific event.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_SRV_reply dns_end
global dns_unknown_reply: event(c: connection , msg: dns_msg , ans: dns_answer );


## Generated for DNS replies of type *EDNS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The parsed EDNS reply.
##
## .. note::
##
##      Note that this event will only be raised if :zeek:see:`dns_skip_all_addl`
##      is set to false.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_EDNS_addl: event(c: connection , msg: dns_msg , ans: dns_edns_additional );


## Generated for DNS replies of type *EDNS*. For replies with multiple options,
## an individual event is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## opt: The parsed EDNS option.
##
## .. note::
##
##      Note that this event will only be raised if :zeek:see:`dns_skip_all_addl`
##      is set to false.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_EDNS_ecs: event(c: connection , msg: dns_msg , opt: dns_edns_ecs );


## Generated for DNS replies of type *EDNS*, and an option field in this *EDNS* record has
## an opt-type of 11. For replies with multiple option fields, an individual event is
## raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. See `RFC7828 <https://tools.ietf.org/html/rfc7828>`__ for
## more information about EDNS0 TCP keepalive. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## opt: The parsed EDNS Keepalive option.
##
## .. note::
##
##      Note that this event will only be raised if :zeek:see:`dns_skip_all_addl`
##      is set to false.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_EDNS_tcp_keepalive: event(c: connection , msg: dns_msg , opt: dns_edns_tcp_keepalive );


## Generated for DNS replies of type *EDNS*, and an option field in this *EDNS* record has
## an opt-type of 10. For replies with multiple options fields, an individual event
## is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. See `RFC7873 <https://tools.ietf.org/html/rfc7873>`__ for
## more information about EDNS0 cookie. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## opt: The parsed EDNS Cookie option.
##
## .. note::
##
##      Note that this event will only be raised if :zeek:see:`dns_skip_all_addl`
##      is set to false.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_EDNS_cookie: event(c: connection , msg: dns_msg , opt: dns_edns_cookie );


## Generated for DNS replies of type *TKEY*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. See `RFC2930 <https://tools.ietf.org/html/rfc2930>`__
## for more information about TKEY. Zeek analyzes both UDP and TCP DNS sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The parsed TKEY reply.
##
## .. note::
##
##      Note that ``ans`` will only be populated if :zeek:see:`dns_skip_all_addl`
##      is set to false.
##
## .. zeek:see:: dns_TSIG_addl
global dns_TKEY: event(c: connection , msg: dns_msg , ans: dns_tkey );


## Generated for DNS replies of type *TSIG*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The parsed TSIG reply.
##
## .. note::
##
##      Note that this event will only be raised if :zeek:see:`dns_skip_all_addl`
##      is set to false.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply  dns_TXT_reply dns_SPF_reply dns_WKS_reply dns_end
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_TSIG_addl: event(c: connection , msg: dns_msg , ans: dns_tsig_additional );


## Generated for DNS replies of type *RRSIG*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## rrsig: The parsed RRSIG record.
global dns_RRSIG: event(c: connection , msg: dns_msg , ans: dns_answer , rrsig: dns_rrsig_rr );


## Generated for DNS replies of type *DNSKEY*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## dnskey: The parsed DNSKEY record.
global dns_DNSKEY: event(c: connection , msg: dns_msg , ans: dns_answer , dnskey: dns_dnskey_rr );


## Generated for DNS replies of type *NSEC*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## next_name: The parsed next secure domain name.
##
## bitmaps: vector of strings in hex for the bit maps present.
global dns_NSEC: event(c: connection , msg: dns_msg , ans: dns_answer , next_name: string , bitmaps: string_vec );


## Generated for DNS replies of type *NSEC3*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## nsec3: The parsed RDATA of Nsec3 record.
global dns_NSEC3: event(c: connection , msg: dns_msg , ans: dns_answer , nsec3: dns_nsec3_rr );


## Generated for DNS replies of type *NSEC3PARAM*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## nsec3param: The parsed RDATA of NSEC3PARAM record.
global dns_NSEC3PARAM: event(c: connection , msg: dns_msg , ans: dns_answer , nsec3param: dns_nsec3param_rr );


## Generated for DNS replies of type *DS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## ds: The parsed RDATA of DS record.
global dns_DS: event(c: connection , msg: dns_msg , ans: dns_answer , ds: dns_ds_rr );


## Generated for DNS replies of type *BINDS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## binds: The parsed RDATA of BIND-Signing state record.
global dns_BINDS: event(c: connection , msg: dns_msg , ans: dns_answer , binds: dns_binds_rr );


## Generated for DNS replies of type *BINDS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## binds: The parsed RDATA of BIND-Signing state record.
global dns_SSHFP: event(c: connection , msg: dns_msg , ans: dns_answer , algo: count , fptype: count , fingerprint: string );


## Generated for DNS replies of type *LOC*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## loc: The parsed RDATA of LOC type record.
global dns_LOC: event(c: connection , msg: dns_msg , ans: dns_answer , loc: dns_loc_rr );


## Generated for DNS replies of type *SVCB* (General Purpose Service Endpoints).
## See `RFC draft for DNS SVCB/HTTPS <https://datatracker.ietf.org/doc/html/draft-ietf-dnsop-svcb-https-07>`__
## for more information about DNS SVCB/HTTPS resource records.
## For replies with multiple answers, an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## svcb: The parsed RDATA of SVCB type record.
global dns_SVCB: event(c: connection , msg: dns_msg , ans: dns_answer , svcb: dns_svcb_rr );


## Generated for DNS replies of type *HTTPS* (HTTPS Specific Service Endpoints).
## See `RFC draft for DNS SVCB/HTTPS <https://datatracker.ietf.org/doc/html/draft-ietf-dnsop-svcb-https-07>`__
## for more information about DNS SVCB/HTTPS resource records.
## Since SVCB and HTTPS records share the same wire format layout, the argument https is dns_svcb_rr.
## For replies with multiple answers, an individual event of the corresponding type is raised for each.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## https: The parsed RDATA of HTTPS type record.
global dns_HTTPS: event(c: connection , msg: dns_msg , ans: dns_answer , https: dns_svcb_rr );


## Generated at the end of processing a DNS packet. This event is the last
## ``dns_*`` event that will be raised for a DNS query/reply and signals that
## all resource records have been passed on.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Zeek analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## .. zeek:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_SPF_reply dns_WKS_reply
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_end: event(c: connection , msg: dns_msg );

} # end of export section
module GLOBAL;
