/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "shi" locale.
 */
public class LocalizedNamesImpl_shi extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AQ",
        "AX",
        "BL",
        "BQ",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DG",
        "EA",
        "EH",
        "EU",
        "EZ",
        "FO",
        "GG",
        "GS",
        "HK",
        "HM",
        "IC",
        "IM",
        "JE",
        "ME",
        "MF",
        "MO",
        "QO",
        "RS",
        "SJ",
        "SS",
        "SX",
        "TA",
        "TF",
        "UM",
        "UN",
        "XA",
        "XB",
        "XK",
        "PS",
        "AZ",
        "GI",
        "ZA",
        "AF",
        "AL",
        "DE",
        "AI",
        "AO",
        "ID",
        "AD",
        "AG",
        "AR",
        "AM",
        "AW",
        "VA",
        "PG",
        "PK",
        "BS",
        "PW",
        "PA",
        "BD",
        "PY",
        "BB",
        "BT",
        "BH",
        "BY",
        "BZ",
        "BJ",
        "PE",
        "PN",
        "BE",
        "BG",
        "BO",
        "PF",
        "PL",
        "BF",
        "BI",
        "PR",
        "BA",
        "BW",
        "BR",
        "BM",
        "BN",
        "PT",
        "GA",
        "GM",
        "GL",
        "GP",
        "GU",
        "GT",
        "GY",
        "GF",
        "DK",
        "DJ",
        "DM",
        "DZ",
        "VU",
        "FJ",
        "PH",
        "FI",
        "VE",
        "VN",
        "FR",
        "NC",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "CU",
        "CO",
        "CG",
        "KR",
        "KP",
        "CR",
        "CI",
        "HR",
        "HT",
        "HU",
        "NL",
        "HN",
        "OM",
        "QA",
        "CY",
        "KM",
        "EC",
        "IR",
        "ER",
        "IE",
        "IS",
        "IL",
        "EE",
        "ET",
        "IT",
        "US",
        "JM",
        "GE",
        "LV",
        "LA",
        "KW",
        "IN",
        "IQ",
        "LR",
        "LY",
        "LI",
        "AE",
        "LS",
        "LT",
        "MA",
        "LB",
        "LU",
        "JO",
        "JP",
        "GR",
        "MG",
        "MW",
        "MV",
        "ML",
        "MY",
        "MT",
        "MQ",
        "MK",
        "YT",
        "FM",
        "MX",
        "EG",
        "MN",
        "MD",
        "MC",
        "MS",
        "MU",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NG",
        "NU",
        "NE",
        "AT",
        "NO",
        "NZ",
        "UA",
        "UY",
        "UG",
        "AU",
        "UZ",
        "RE",
        "RO",
        "RU",
        "RW",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GD",
        "SV",
        "WS",
        "AS",
        "PM",
        "VC",
        "KN",
        "SM",
        "SH",
        "LC",
        "ST",
        "ES",
        "SK",
        "SI",
        "SG",
        "SR",
        "SY",
        "LK",
        "SA",
        "SN",
        "SL",
        "SC",
        "SD",
        "SE",
        "SZ",
        "CH",
        "SO",
        "CL",
        "CN",
        "CD",
        "DO",
        "CF",
        "CZ",
        "GB",
        "TJ",
        "IO",
        "CV",
        "KY",
        "CK",
        "FK",
        "MH",
        "MP",
        "NF",
        "SB",
        "TC",
        "VI",
        "VG",
        "TL",
        "TV",
        "TN",
        "TM",
        "TR",
        "TT",
        "TD",
        "TZ",
        "TH",
        "TW",
        "TG",
        "TK",
        "TO",
        "WF",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "ⴰⵏⴷⵓⵔⴰ");
    namesMap.put("AE", "ⵍⵉⵎⴰⵔⴰⵜ");
    namesMap.put("AF", "ⴰⴼⵖⴰⵏⵉⵙⵜⴰⵏ");
    namesMap.put("AG", "ⴰⵏⵜⵉⴳⴰ ⴷ ⴱⵔⴱⵓⴷⴰ");
    namesMap.put("AI", "ⴰⵏⴳⵉⵍⴰ");
    namesMap.put("AL", "ⴰⵍⴱⴰⵏⵢⴰ");
    namesMap.put("AM", "ⴰⵔⵎⵉⵏⵢⴰ");
    namesMap.put("AO", "ⴰⵏⴳⵓⵍⴰ");
    namesMap.put("AR", "ⴰⵔⵊⴰⵏⵜⵉⵏ");
    namesMap.put("AS", "ⵙⴰⵎⵡⴰ ⵜⴰⵎⵉⵔⵉⴽⴰⵏⵉⵜ");
    namesMap.put("AT", "ⵏⵏⵎⵙⴰ");
    namesMap.put("AU", "ⵓⵙⵜⵔⴰⵍⵢⴰ");
    namesMap.put("AW", "ⴰⵔⵓⴱⴰ");
    namesMap.put("AZ", "ⴰⴷⵔⴰⴱⵉⵊⴰⵏ");
    namesMap.put("BA", "ⴱⵓⵙⵏⴰ ⴷ ⵀⵉⵔⵙⵉⴽ");
    namesMap.put("BB", "ⴱⴰⵔⴱⴰⴷ");
    namesMap.put("BD", "ⴱⴰⵏⴳⵍⴰⴷⵉⵛ");
    namesMap.put("BE", "ⴱⵍⵊⵉⴽⴰ");
    namesMap.put("BF", "ⴱⵓⵔⴽⵉⵏⴰ ⴼⴰⵙⵓ");
    namesMap.put("BG", "ⴱⵍⵖⴰⵔⵢⴰ");
    namesMap.put("BH", "ⴱⵃⵔⴰⵢⵏ");
    namesMap.put("BI", "ⴱⵓⵔⵓⵏⴷⵉ");
    namesMap.put("BJ", "ⴱⵉⵏⵉⵏ");
    namesMap.put("BM", "ⴱⵔⵎⵓⴷⴰ");
    namesMap.put("BN", "ⴱⵔⵓⵏⵉ");
    namesMap.put("BO", "ⴱⵓⵍⵉⴼⵢⴰ");
    namesMap.put("BR", "ⴱⵔⴰⵣⵉⵍ");
    namesMap.put("BS", "ⴱⴰⵀⴰⵎⴰⵙ");
    namesMap.put("BT", "ⴱⵀⵓⵜⴰⵏ");
    namesMap.put("BW", "ⴱⵓⵜⵙⵡⴰⵏⴰ");
    namesMap.put("BY", "ⴱⵉⵍⴰⵔⵓⵙⵢⴰ");
    namesMap.put("BZ", "ⴱⵉⵍⵉⵣ");
    namesMap.put("CA", "ⴽⴰⵏⴰⴷⴰ");
    namesMap.put("CD", "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⴷⵉⵎⵓⵇⵔⴰⵜⵉⵜ ⵏ ⴽⵓⵏⴳⵓ");
    namesMap.put("CF", "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⵏⴰⵎⵎⴰⵙⵜ ⵏ ⵉⴼⵔⵉⵇⵢⴰ");
    namesMap.put("CG", "ⴽⵓⵏⴳⵓ");
    namesMap.put("CH", "ⵙⵡⵉⵙⵔⴰ");
    namesMap.put("CI", "ⴽⵓⵜ ⴷⵉⴼⵡⴰⵔ");
    namesMap.put("CK", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⵓⴽ");
    namesMap.put("CL", "ⵛⵛⵉⵍⵉ");
    namesMap.put("CM", "ⴽⴰⵎⵉⵔⵓⵏ");
    namesMap.put("CN", "ⵛⵛⵉⵏⵡⴰ");
    namesMap.put("CO", "ⴽⵓⵍⵓⵎⴱⵢⴰ");
    namesMap.put("CR", "ⴽⵓⵙⵜⴰ ⵔⵉⴽⴰ");
    namesMap.put("CU", "ⴽⵓⴱⴰ");
    namesMap.put("CV", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⴰⴱⴱⵉⵔⴷⵉ");
    namesMap.put("CY", "ⵇⵓⴱⵔⵓⵙ");
    namesMap.put("CZ", "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⵜⵛⵉⴽⵉⵜ");
    namesMap.put("DE", "ⴰⵍⵎⴰⵏⵢⴰ");
    namesMap.put("DJ", "ⴷⵊⵉⴱⵓⵜⵉ");
    namesMap.put("DK", "ⴷⴰⵏⵎⴰⵔⴽ");
    namesMap.put("DM", "ⴷⵓⵎⵉⵏⵉⴽ");
    namesMap.put("DO", "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⴷⵓⵎⵉⵏⵉⴽⵜ");
    namesMap.put("DZ", "ⴷⵣⴰⵢⵔ");
    namesMap.put("EC", "ⵉⴽⵡⴰⴷⵓⵔ");
    namesMap.put("EE", "ⵉⵙⵜⵓⵏⵢⴰ");
    namesMap.put("EG", "ⵎⵉⵚⵕ");
    namesMap.put("ER", "ⵉⵔⵉⵜⵉⵔⵢⴰ");
    namesMap.put("ES", "ⵙⴱⴰⵏⵢⴰ");
    namesMap.put("ET", "ⵉⵜⵢⵓⴱⵢⴰ");
    namesMap.put("FI", "ⴼⵉⵍⵍⴰⵏⴷⴰ");
    namesMap.put("FJ", "ⴼⵉⴷⵊⵉ");
    namesMap.put("FK", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵍⴰⵡⵉ");
    namesMap.put("FM", "ⵎⵉⴽⵔⵓⵏⵉⵣⵢⴰ");
    namesMap.put("FR", "ⴼⵔⴰⵏⵙⴰ");
    namesMap.put("GA", "ⴳⴰⴱⵓⵏ");
    namesMap.put("GB", "ⵜⴰⴳⵍⴷⵉⵜ ⵉⵎⵓⵏⵏ");
    namesMap.put("GD", "ⵖⵔⵏⴰⵟⴰ");
    namesMap.put("GE", "ⵊⵓⵔⵊⵢⴰ");
    namesMap.put("GF", "ⴳⵡⵉⵢⴰⵏ ⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜ");
    namesMap.put("GH", "ⵖⴰⵏⴰ");
    namesMap.put("GI", "ⴰⴷⵔⴰⵔ ⵏ ⵟⴰⵕⵉⵇ");
    namesMap.put("GL", "ⴳⵔⵉⵍⴰⵏⴷ");
    namesMap.put("GM", "ⴳⴰⵎⴱⵢⴰ");
    namesMap.put("GN", "ⵖⵉⵏⵢⴰ");
    namesMap.put("GP", "ⴳⵡⴰⴷⴰⵍⵓⴱ");
    namesMap.put("GQ", "ⵖⵉⵏⵢⴰ ⵏ ⵉⴽⵡⴰⴷⵓⵔ");
    namesMap.put("GR", "ⵍⵢⵓⵏⴰⵏ");
    namesMap.put("GT", "ⴳⵡⴰⵜⵉⵎⴰⵍⴰ");
    namesMap.put("GU", "ⴳⵡⴰⵎ");
    namesMap.put("GW", "ⵖⵉⵏⵢⴰ ⴱⵉⵙⴰⵡ");
    namesMap.put("GY", "ⴳⵡⵉⵢⴰⵏⴰ");
    namesMap.put("HN", "ⵀⵓⵏⴷⵓⵔⴰⵙ");
    namesMap.put("HR", "ⴽⵔⵡⴰⵜⵢⴰ");
    namesMap.put("HT", "ⵀⴰⵢⵜⵉ");
    namesMap.put("HU", "ⵀⵏⵖⴰⵔⵢⴰ");
    namesMap.put("ID", "ⴰⵏⴷⵓⵏⵉⵙⵢⴰ");
    namesMap.put("IE", "ⵉⵔⵍⴰⵏⴷⴰ");
    namesMap.put("IL", "ⵉⵙⵔⴰⵢⵉⵍ");
    namesMap.put("IN", "ⵍⵀⵉⵏⴷ");
    namesMap.put("IO", "ⵜⴰⵎⵏⴰⴹⵜ ⵜⴰⵏⴳⵍⵉⵣⵉⵜ ⵏ ⵓⴳⴰⵔⵓ ⴰⵀⵉⵏⴷⵉ");
    namesMap.put("IQ", "ⵍⵄⵉⵔⴰⵇ");
    namesMap.put("IR", "ⵉⵔⴰⵏ");
    namesMap.put("IS", "ⵉⵙⵍⴰⵏⴷ");
    namesMap.put("IT", "ⵉⵟⴰⵍⵢⴰ");
    namesMap.put("JM", "ⵊⴰⵎⴰⵢⴽⴰ");
    namesMap.put("JO", "ⵍⵓⵔⴷⵓⵏ");
    namesMap.put("JP", "ⵍⵢⴰⴱⴰⵏ");
    namesMap.put("KE", "ⴽⵉⵏⵢⴰ");
    namesMap.put("KG", "ⴽⵉⵔⵖⵉⵣⵉⵙⵜⴰⵏ");
    namesMap.put("KH", "ⴽⴰⵎⴱⵓⴷⵢⴰ");
    namesMap.put("KI", "ⴽⵉⵔⵉⴱⴰⵜⵉ");
    namesMap.put("KM", "ⵇⵓⵎⵓⵔ");
    namesMap.put("KN", "ⵙⴰⵏⴽⵔⵉⵙ ⴷ ⵏⵉⴼⵉⵙ");
    namesMap.put("KP", "ⴽⵓⵔⵢⴰ ⵏ ⵉⵥⵥⵍⵎⴹ");
    namesMap.put("KR", "ⴽⵓⵔⵢⴰ ⵏ ⵉⴼⴼⵓⵙ");
    namesMap.put("KW", "ⵍⴽⵡⵉⵜ");
    namesMap.put("KY", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⴰⵢⵎⴰⵏ");
    namesMap.put("KZ", "ⴽⴰⵣⴰⵅⵙⵜⴰⵏ");
    namesMap.put("LA", "ⵍⴰⵡⵙ");
    namesMap.put("LB", "ⵍⵓⴱⵏⴰⵏ");
    namesMap.put("LC", "ⵙⴰⵏⵜⵍⵓⵙⵉ");
    namesMap.put("LI", "ⵍⵉⴽⵉⵏⵛⵜⴰⵢⵏ");
    namesMap.put("LK", "ⵙⵔⵉⵍⴰⵏⴽⴰ");
    namesMap.put("LR", "ⵍⵉⴱⵉⵔⵢⴰ");
    namesMap.put("LS", "ⵍⵉⵚⵓⵟⵓ");
    namesMap.put("LT", "ⵍⵉⵜⵡⴰⵏⵢⴰ");
    namesMap.put("LU", "ⵍⵓⴽⵙⴰⵏⴱⵓⵔⴳ");
    namesMap.put("LV", "ⵍⴰⵜⴼⵢⴰ");
    namesMap.put("LY", "ⵍⵉⴱⵢⴰ");
    namesMap.put("MA", "ⵍⵎⵖⵔⵉⴱ");
    namesMap.put("MC", "ⵎⵓⵏⴰⴽⵓ");
    namesMap.put("MD", "ⵎⵓⵍⴷⵓⴼⵢⴰ");
    namesMap.put("MG", "ⵎⴰⴷⴰⵖⴰⵛⵇⴰⵔ");
    namesMap.put("MH", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵔⵛⴰⵍ");
    namesMap.put("MK", "ⵎⴰⵙⵉⴷⵓⵏⵢⴰ");
    namesMap.put("ML", "ⵎⴰⵍⵉ");
    namesMap.put("MM", "ⵎⵢⴰⵏⵎⴰⵔ");
    namesMap.put("MN", "ⵎⵏⵖⵓⵍⵢⴰ");
    namesMap.put("MP", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵔⵢⴰⵏ ⵏ ⵉⵥⵥⵍⵎⴹ");
    namesMap.put("MQ", "ⵎⴰⵔⵜⵉⵏⵉⴽ");
    namesMap.put("MR", "ⵎⵓⵕⵉⵟⴰⵏⵢⴰ");
    namesMap.put("MS", "ⵎⵓⵏⵙⵉⵔⴰⵜ");
    namesMap.put("MT", "ⵎⴰⵍⵟⴰ");
    namesMap.put("MU", "ⵎⵓⵔⵉⵙ");
    namesMap.put("MV", "ⵎⴰⵍⴷⵉⴼ");
    namesMap.put("MW", "ⵎⴰⵍⴰⵡⵉ");
    namesMap.put("MX", "ⵎⵉⴽⵙⵉⴽ");
    namesMap.put("MY", "ⵎⴰⵍⵉⵣⵢⴰ");
    namesMap.put("MZ", "ⵎⵓⵣⵏⴱⵉⵇ");
    namesMap.put("NA", "ⵏⴰⵎⵉⴱⵢⴰ");
    namesMap.put("NC", "ⴽⴰⵍⵉⴷⵓⵏⵢⴰ ⵜⴰⵎⴰⵢⵏⵓⵜ");
    namesMap.put("NE", "ⵏⵏⵉⵊⵉⵔ");
    namesMap.put("NF", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵏⵓⵔⴼⵓⵍⴽ");
    namesMap.put("NG", "ⵏⵉⵊⵉⵔⵢⴰ");
    namesMap.put("NI", "ⵏⵉⴽⴰⵔⴰⴳⵡⴰ");
    namesMap.put("NL", "ⵀⵓⵍⴰⵏⴷⴰ");
    namesMap.put("NO", "ⵏⵏⵔⵡⵉⵊ");
    namesMap.put("NP", "ⵏⵉⴱⴰⵍ");
    namesMap.put("NR", "ⵏⴰⵡⵔⵓ");
    namesMap.put("NU", "ⵏⵉⵡⵉ");
    namesMap.put("NZ", "ⵏⵢⵓⵣⵉⵍⴰⵏⴷⴰ");
    namesMap.put("OM", "ⵄⵓⵎⴰⵏ");
    namesMap.put("PA", "ⴱⴰⵏⴰⵎⴰ");
    namesMap.put("PE", "ⴱⵉⵔⵓ");
    namesMap.put("PF", "ⴱⵓⵍⵉⵏⵉⵣⵢⴰ ⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜ");
    namesMap.put("PG", "ⴱⴰⴱⵡⴰ ⵖⵉⵏⵢⴰ ⵜⴰⵎⴰⵢⵏⵓⵜ");
    namesMap.put("PH", "ⴼⵉⵍⵉⴱⴱⵉⵏ");
    namesMap.put("PK", "ⴱⴰⴽⵉⵙⵜⴰⵏ");
    namesMap.put("PL", "ⴱⵓⵍⵓⵏⵢⴰ");
    namesMap.put("PM", "ⵙⴰⵏⴱⵢⵉⵔ ⴷ ⵎⵉⴽⵍⵓⵏ");
    namesMap.put("PN", "ⴱⵉⵜⴽⴰⵢⵔⵏ");
    namesMap.put("PR", "ⴱⵓⵔⵜⵓ ⵔⵉⴽⵓ");
    namesMap.put("PS", "ⴰⴳⵎⵎⴰⴹ ⵏ ⵜⴰⴳⵓⵜ ⴷ ⵖⵣⵣⴰ");
    namesMap.put("PT", "ⴱⵕⵟⵇⵉⵣ");
    namesMap.put("PW", "ⴱⴰⵍⴰⵡ");
    namesMap.put("PY", "ⴱⴰⵔⴰⴳⵡⴰⵢ");
    namesMap.put("QA", "ⵇⴰⵜⴰⵔ");
    namesMap.put("RE", "ⵔⵉⵢⵓⵏⵢⵓⵏ");
    namesMap.put("RO", "ⵔⵓⵎⴰⵏⵢⴰ");
    namesMap.put("RU", "ⵔⵓⵙⵢⴰ");
    namesMap.put("RW", "ⵔⵡⴰⵏⴷⴰ");
    namesMap.put("SA", "ⵙⵙⴰⵄⵓⴷⵉⵢⴰ");
    namesMap.put("SB", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵙⴰⵍⵓⵎⴰⵏ");
    namesMap.put("SC", "ⵙⵙⵉⵛⵉⵍ");
    namesMap.put("SD", "ⵙⵙⵓⴷⴰⵏ");
    namesMap.put("SE", "ⵙⵙⵡⵉⴷ");
    namesMap.put("SG", "ⵙⵏⵖⴰⴼⵓⵔⴰ");
    namesMap.put("SH", "ⵙⴰⵏⵜⵉⵍⵉⵏ");
    namesMap.put("SI", "ⵙⵍⵓⴼⵉⵏⵢⴰ");
    namesMap.put("SK", "ⵙⵍⵓⴼⴰⴽⵢⴰ");
    namesMap.put("SL", "ⵙⵙⵉⵔⴰⵍⵢⵓⵏ");
    namesMap.put("SM", "ⵙⴰⵏⵎⴰⵔⵉⵏⵓ");
    namesMap.put("SN", "ⵙⵙⵉⵏⵉⴳⴰⵍ");
    namesMap.put("SO", "ⵚⵚⵓⵎⴰⵍ");
    namesMap.put("SR", "ⵙⵓⵔⵉⵏⴰⵎ");
    namesMap.put("ST", "ⵙⴰⵡⵟⵓⵎⵉ ⴷ ⴱⵔⴰⵏⵙⵉⴱ");
    namesMap.put("SV", "ⵙⴰⵍⴼⴰⴷⵓⵔ");
    namesMap.put("SY", "ⵙⵓⵔⵢⴰ");
    namesMap.put("SZ", "ⵙⵡⴰⵣⵉⵍⴰⵏⴷⴰ");
    namesMap.put("TC", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵜⵓⵔⴽⵢⴰ ⴷ ⴽⴰⵢⴽ");
    namesMap.put("TD", "ⵜⵛⴰⴷ");
    namesMap.put("TG", "ⵟⵓⴳⵓ");
    namesMap.put("TH", "ⵟⴰⵢⵍⴰⵏⴷ");
    namesMap.put("TJ", "ⵜⴰⴷⵊⴰⴽⵉⵙⵜⴰⵏ");
    namesMap.put("TK", "ⵟⵓⴽⵍⴰⵡ");
    namesMap.put("TL", "ⵜⵉⵎⵓⵔ ⵏ ⵍⵇⴱⵍⵜ");
    namesMap.put("TM", "ⵜⵓⵔⴽⵎⴰⵏⵙⵜⴰⵏ");
    namesMap.put("TN", "ⵜⵓⵏⵙ");
    namesMap.put("TO", "ⵟⵓⵏⴳⴰ");
    namesMap.put("TR", "ⵜⵓⵔⴽⵢⴰ");
    namesMap.put("TT", "ⵜⵔⵉⵏⵉⴷⴰⴷ ⴷ ⵟⵓⴱⴰⴳⵓ");
    namesMap.put("TV", "ⵜⵓⴼⴰⵍⵓ");
    namesMap.put("TW", "ⵟⴰⵢⵡⴰⵏ");
    namesMap.put("TZ", "ⵟⴰⵏⵥⴰⵏⵢⴰ");
    namesMap.put("UA", "ⵓⴽⵔⴰⵏⵢⴰ");
    namesMap.put("UG", "ⵓⵖⴰⵏⴷⴰ");
    namesMap.put("US", "ⵉⵡⵓⵏⴰⴽ ⵎⵓⵏⵏⵉⵏ ⵏ ⵎⵉⵔⵉⴽⴰⵏ");
    namesMap.put("UY", "ⵓⵔⵓⴳⵡⴰⵢ");
    namesMap.put("UZ", "ⵓⵣⴱⴰⴽⵉⵙⵜⴰⵏ");
    namesMap.put("VA", "ⴰⵡⴰⵏⴽ ⵏ ⴼⴰⵜⵉⴽⴰⵏ");
    namesMap.put("VC", "ⵙⴰⵏⴼⴰⵏⵙⴰⵏ ⴷ ⴳⵔⵉⵏⴰⴷⵉⵏ");
    namesMap.put("VE", "ⴼⵉⵏⵣⵡⵉⵍⴰ");
    namesMap.put("VG", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵜⵉⵎⴳⴰⴷ ⵏ ⵏⵏⴳⵍⵉⵣ");
    namesMap.put("VI", "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵜⵉⵎⴳⴰⴷ ⵏ ⵉⵡⵓⵏⴰⴽ ⵎⵓⵏⵏⵉⵏ");
    namesMap.put("VN", "ⴼⵉⵜⵏⴰⵎ");
    namesMap.put("VU", "ⴼⴰⵏⵡⴰⵟⵓ");
    namesMap.put("WF", "ⵡⴰⵍⵉⵙ ⴷ ⴼⵓⵜⵓⵏⴰ");
    namesMap.put("WS", "ⵙⴰⵎⵡⴰ");
    namesMap.put("YE", "ⵢⴰⵎⴰⵏ");
    namesMap.put("YT", "ⵎⴰⵢⵓⵟ");
    namesMap.put("ZA", "ⴰⴼⵔⵉⵇⵢⴰ ⵏ ⵉⴼⴼⵓⵙ");
    namesMap.put("ZM", "ⵣⴰⵎⴱⵢⴰ");
    namesMap.put("ZW", "ⵣⵉⵎⴱⴰⴱⵡⵉ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "ⴰⵏⴷⵓⵔⴰ",
        "AE": "ⵍⵉⵎⴰⵔⴰⵜ",
        "AF": "ⴰⴼⵖⴰⵏⵉⵙⵜⴰⵏ",
        "AG": "ⴰⵏⵜⵉⴳⴰ ⴷ ⴱⵔⴱⵓⴷⴰ",
        "AI": "ⴰⵏⴳⵉⵍⴰ",
        "AL": "ⴰⵍⴱⴰⵏⵢⴰ",
        "AM": "ⴰⵔⵎⵉⵏⵢⴰ",
        "AO": "ⴰⵏⴳⵓⵍⴰ",
        "AR": "ⴰⵔⵊⴰⵏⵜⵉⵏ",
        "AS": "ⵙⴰⵎⵡⴰ ⵜⴰⵎⵉⵔⵉⴽⴰⵏⵉⵜ",
        "AT": "ⵏⵏⵎⵙⴰ",
        "AU": "ⵓⵙⵜⵔⴰⵍⵢⴰ",
        "AW": "ⴰⵔⵓⴱⴰ",
        "AZ": "ⴰⴷⵔⴰⴱⵉⵊⴰⵏ",
        "BA": "ⴱⵓⵙⵏⴰ ⴷ ⵀⵉⵔⵙⵉⴽ",
        "BB": "ⴱⴰⵔⴱⴰⴷ",
        "BD": "ⴱⴰⵏⴳⵍⴰⴷⵉⵛ",
        "BE": "ⴱⵍⵊⵉⴽⴰ",
        "BF": "ⴱⵓⵔⴽⵉⵏⴰ ⴼⴰⵙⵓ",
        "BG": "ⴱⵍⵖⴰⵔⵢⴰ",
        "BH": "ⴱⵃⵔⴰⵢⵏ",
        "BI": "ⴱⵓⵔⵓⵏⴷⵉ",
        "BJ": "ⴱⵉⵏⵉⵏ",
        "BM": "ⴱⵔⵎⵓⴷⴰ",
        "BN": "ⴱⵔⵓⵏⵉ",
        "BO": "ⴱⵓⵍⵉⴼⵢⴰ",
        "BR": "ⴱⵔⴰⵣⵉⵍ",
        "BS": "ⴱⴰⵀⴰⵎⴰⵙ",
        "BT": "ⴱⵀⵓⵜⴰⵏ",
        "BW": "ⴱⵓⵜⵙⵡⴰⵏⴰ",
        "BY": "ⴱⵉⵍⴰⵔⵓⵙⵢⴰ",
        "BZ": "ⴱⵉⵍⵉⵣ",
        "CA": "ⴽⴰⵏⴰⴷⴰ",
        "CD": "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⴷⵉⵎⵓⵇⵔⴰⵜⵉⵜ ⵏ ⴽⵓⵏⴳⵓ",
        "CF": "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⵏⴰⵎⵎⴰⵙⵜ ⵏ ⵉⴼⵔⵉⵇⵢⴰ",
        "CG": "ⴽⵓⵏⴳⵓ",
        "CH": "ⵙⵡⵉⵙⵔⴰ",
        "CI": "ⴽⵓⵜ ⴷⵉⴼⵡⴰⵔ",
        "CK": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⵓⴽ",
        "CL": "ⵛⵛⵉⵍⵉ",
        "CM": "ⴽⴰⵎⵉⵔⵓⵏ",
        "CN": "ⵛⵛⵉⵏⵡⴰ",
        "CO": "ⴽⵓⵍⵓⵎⴱⵢⴰ",
        "CR": "ⴽⵓⵙⵜⴰ ⵔⵉⴽⴰ",
        "CU": "ⴽⵓⴱⴰ",
        "CV": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⴰⴱⴱⵉⵔⴷⵉ",
        "CY": "ⵇⵓⴱⵔⵓⵙ",
        "CZ": "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⵜⵛⵉⴽⵉⵜ",
        "DE": "ⴰⵍⵎⴰⵏⵢⴰ",
        "DJ": "ⴷⵊⵉⴱⵓⵜⵉ",
        "DK": "ⴷⴰⵏⵎⴰⵔⴽ",
        "DM": "ⴷⵓⵎⵉⵏⵉⴽ",
        "DO": "ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⴷⵓⵎⵉⵏⵉⴽⵜ",
        "DZ": "ⴷⵣⴰⵢⵔ",
        "EC": "ⵉⴽⵡⴰⴷⵓⵔ",
        "EE": "ⵉⵙⵜⵓⵏⵢⴰ",
        "EG": "ⵎⵉⵚⵕ",
        "ER": "ⵉⵔⵉⵜⵉⵔⵢⴰ",
        "ES": "ⵙⴱⴰⵏⵢⴰ",
        "ET": "ⵉⵜⵢⵓⴱⵢⴰ",
        "FI": "ⴼⵉⵍⵍⴰⵏⴷⴰ",
        "FJ": "ⴼⵉⴷⵊⵉ",
        "FK": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵍⴰⵡⵉ",
        "FM": "ⵎⵉⴽⵔⵓⵏⵉⵣⵢⴰ",
        "FR": "ⴼⵔⴰⵏⵙⴰ",
        "GA": "ⴳⴰⴱⵓⵏ",
        "GB": "ⵜⴰⴳⵍⴷⵉⵜ ⵉⵎⵓⵏⵏ",
        "GD": "ⵖⵔⵏⴰⵟⴰ",
        "GE": "ⵊⵓⵔⵊⵢⴰ",
        "GF": "ⴳⵡⵉⵢⴰⵏ ⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜ",
        "GH": "ⵖⴰⵏⴰ",
        "GI": "ⴰⴷⵔⴰⵔ ⵏ ⵟⴰⵕⵉⵇ",
        "GL": "ⴳⵔⵉⵍⴰⵏⴷ",
        "GM": "ⴳⴰⵎⴱⵢⴰ",
        "GN": "ⵖⵉⵏⵢⴰ",
        "GP": "ⴳⵡⴰⴷⴰⵍⵓⴱ",
        "GQ": "ⵖⵉⵏⵢⴰ ⵏ ⵉⴽⵡⴰⴷⵓⵔ",
        "GR": "ⵍⵢⵓⵏⴰⵏ",
        "GT": "ⴳⵡⴰⵜⵉⵎⴰⵍⴰ",
        "GU": "ⴳⵡⴰⵎ",
        "GW": "ⵖⵉⵏⵢⴰ ⴱⵉⵙⴰⵡ",
        "GY": "ⴳⵡⵉⵢⴰⵏⴰ",
        "HN": "ⵀⵓⵏⴷⵓⵔⴰⵙ",
        "HR": "ⴽⵔⵡⴰⵜⵢⴰ",
        "HT": "ⵀⴰⵢⵜⵉ",
        "HU": "ⵀⵏⵖⴰⵔⵢⴰ",
        "ID": "ⴰⵏⴷⵓⵏⵉⵙⵢⴰ",
        "IE": "ⵉⵔⵍⴰⵏⴷⴰ",
        "IL": "ⵉⵙⵔⴰⵢⵉⵍ",
        "IN": "ⵍⵀⵉⵏⴷ",
        "IO": "ⵜⴰⵎⵏⴰⴹⵜ ⵜⴰⵏⴳⵍⵉⵣⵉⵜ ⵏ ⵓⴳⴰⵔⵓ ⴰⵀⵉⵏⴷⵉ",
        "IQ": "ⵍⵄⵉⵔⴰⵇ",
        "IR": "ⵉⵔⴰⵏ",
        "IS": "ⵉⵙⵍⴰⵏⴷ",
        "IT": "ⵉⵟⴰⵍⵢⴰ",
        "JM": "ⵊⴰⵎⴰⵢⴽⴰ",
        "JO": "ⵍⵓⵔⴷⵓⵏ",
        "JP": "ⵍⵢⴰⴱⴰⵏ",
        "KE": "ⴽⵉⵏⵢⴰ",
        "KG": "ⴽⵉⵔⵖⵉⵣⵉⵙⵜⴰⵏ",
        "KH": "ⴽⴰⵎⴱⵓⴷⵢⴰ",
        "KI": "ⴽⵉⵔⵉⴱⴰⵜⵉ",
        "KM": "ⵇⵓⵎⵓⵔ",
        "KN": "ⵙⴰⵏⴽⵔⵉⵙ ⴷ ⵏⵉⴼⵉⵙ",
        "KP": "ⴽⵓⵔⵢⴰ ⵏ ⵉⵥⵥⵍⵎⴹ",
        "KR": "ⴽⵓⵔⵢⴰ ⵏ ⵉⴼⴼⵓⵙ",
        "KW": "ⵍⴽⵡⵉⵜ",
        "KY": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⴰⵢⵎⴰⵏ",
        "KZ": "ⴽⴰⵣⴰⵅⵙⵜⴰⵏ",
        "LA": "ⵍⴰⵡⵙ",
        "LB": "ⵍⵓⴱⵏⴰⵏ",
        "LC": "ⵙⴰⵏⵜⵍⵓⵙⵉ",
        "LI": "ⵍⵉⴽⵉⵏⵛⵜⴰⵢⵏ",
        "LK": "ⵙⵔⵉⵍⴰⵏⴽⴰ",
        "LR": "ⵍⵉⴱⵉⵔⵢⴰ",
        "LS": "ⵍⵉⵚⵓⵟⵓ",
        "LT": "ⵍⵉⵜⵡⴰⵏⵢⴰ",
        "LU": "ⵍⵓⴽⵙⴰⵏⴱⵓⵔⴳ",
        "LV": "ⵍⴰⵜⴼⵢⴰ",
        "LY": "ⵍⵉⴱⵢⴰ",
        "MA": "ⵍⵎⵖⵔⵉⴱ",
        "MC": "ⵎⵓⵏⴰⴽⵓ",
        "MD": "ⵎⵓⵍⴷⵓⴼⵢⴰ",
        "MG": "ⵎⴰⴷⴰⵖⴰⵛⵇⴰⵔ",
        "MH": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵔⵛⴰⵍ",
        "MK": "ⵎⴰⵙⵉⴷⵓⵏⵢⴰ",
        "ML": "ⵎⴰⵍⵉ",
        "MM": "ⵎⵢⴰⵏⵎⴰⵔ",
        "MN": "ⵎⵏⵖⵓⵍⵢⴰ",
        "MP": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵔⵢⴰⵏ ⵏ ⵉⵥⵥⵍⵎⴹ",
        "MQ": "ⵎⴰⵔⵜⵉⵏⵉⴽ",
        "MR": "ⵎⵓⵕⵉⵟⴰⵏⵢⴰ",
        "MS": "ⵎⵓⵏⵙⵉⵔⴰⵜ",
        "MT": "ⵎⴰⵍⵟⴰ",
        "MU": "ⵎⵓⵔⵉⵙ",
        "MV": "ⵎⴰⵍⴷⵉⴼ",
        "MW": "ⵎⴰⵍⴰⵡⵉ",
        "MX": "ⵎⵉⴽⵙⵉⴽ",
        "MY": "ⵎⴰⵍⵉⵣⵢⴰ",
        "MZ": "ⵎⵓⵣⵏⴱⵉⵇ",
        "NA": "ⵏⴰⵎⵉⴱⵢⴰ",
        "NC": "ⴽⴰⵍⵉⴷⵓⵏⵢⴰ ⵜⴰⵎⴰⵢⵏⵓⵜ",
        "NE": "ⵏⵏⵉⵊⵉⵔ",
        "NF": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵏⵓⵔⴼⵓⵍⴽ",
        "NG": "ⵏⵉⵊⵉⵔⵢⴰ",
        "NI": "ⵏⵉⴽⴰⵔⴰⴳⵡⴰ",
        "NL": "ⵀⵓⵍⴰⵏⴷⴰ",
        "NO": "ⵏⵏⵔⵡⵉⵊ",
        "NP": "ⵏⵉⴱⴰⵍ",
        "NR": "ⵏⴰⵡⵔⵓ",
        "NU": "ⵏⵉⵡⵉ",
        "NZ": "ⵏⵢⵓⵣⵉⵍⴰⵏⴷⴰ",
        "OM": "ⵄⵓⵎⴰⵏ",
        "PA": "ⴱⴰⵏⴰⵎⴰ",
        "PE": "ⴱⵉⵔⵓ",
        "PF": "ⴱⵓⵍⵉⵏⵉⵣⵢⴰ ⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜ",
        "PG": "ⴱⴰⴱⵡⴰ ⵖⵉⵏⵢⴰ ⵜⴰⵎⴰⵢⵏⵓⵜ",
        "PH": "ⴼⵉⵍⵉⴱⴱⵉⵏ",
        "PK": "ⴱⴰⴽⵉⵙⵜⴰⵏ",
        "PL": "ⴱⵓⵍⵓⵏⵢⴰ",
        "PM": "ⵙⴰⵏⴱⵢⵉⵔ ⴷ ⵎⵉⴽⵍⵓⵏ",
        "PN": "ⴱⵉⵜⴽⴰⵢⵔⵏ",
        "PR": "ⴱⵓⵔⵜⵓ ⵔⵉⴽⵓ",
        "PS": "ⴰⴳⵎⵎⴰⴹ ⵏ ⵜⴰⴳⵓⵜ ⴷ ⵖⵣⵣⴰ",
        "PT": "ⴱⵕⵟⵇⵉⵣ",
        "PW": "ⴱⴰⵍⴰⵡ",
        "PY": "ⴱⴰⵔⴰⴳⵡⴰⵢ",
        "QA": "ⵇⴰⵜⴰⵔ",
        "RE": "ⵔⵉⵢⵓⵏⵢⵓⵏ",
        "RO": "ⵔⵓⵎⴰⵏⵢⴰ",
        "RU": "ⵔⵓⵙⵢⴰ",
        "RW": "ⵔⵡⴰⵏⴷⴰ",
        "SA": "ⵙⵙⴰⵄⵓⴷⵉⵢⴰ",
        "SB": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵙⴰⵍⵓⵎⴰⵏ",
        "SC": "ⵙⵙⵉⵛⵉⵍ",
        "SD": "ⵙⵙⵓⴷⴰⵏ",
        "SE": "ⵙⵙⵡⵉⴷ",
        "SG": "ⵙⵏⵖⴰⴼⵓⵔⴰ",
        "SH": "ⵙⴰⵏⵜⵉⵍⵉⵏ",
        "SI": "ⵙⵍⵓⴼⵉⵏⵢⴰ",
        "SK": "ⵙⵍⵓⴼⴰⴽⵢⴰ",
        "SL": "ⵙⵙⵉⵔⴰⵍⵢⵓⵏ",
        "SM": "ⵙⴰⵏⵎⴰⵔⵉⵏⵓ",
        "SN": "ⵙⵙⵉⵏⵉⴳⴰⵍ",
        "SO": "ⵚⵚⵓⵎⴰⵍ",
        "SR": "ⵙⵓⵔⵉⵏⴰⵎ",
        "ST": "ⵙⴰⵡⵟⵓⵎⵉ ⴷ ⴱⵔⴰⵏⵙⵉⴱ",
        "SV": "ⵙⴰⵍⴼⴰⴷⵓⵔ",
        "SY": "ⵙⵓⵔⵢⴰ",
        "SZ": "ⵙⵡⴰⵣⵉⵍⴰⵏⴷⴰ",
        "TC": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵜⵓⵔⴽⵢⴰ ⴷ ⴽⴰⵢⴽ",
        "TD": "ⵜⵛⴰⴷ",
        "TG": "ⵟⵓⴳⵓ",
        "TH": "ⵟⴰⵢⵍⴰⵏⴷ",
        "TJ": "ⵜⴰⴷⵊⴰⴽⵉⵙⵜⴰⵏ",
        "TK": "ⵟⵓⴽⵍⴰⵡ",
        "TL": "ⵜⵉⵎⵓⵔ ⵏ ⵍⵇⴱⵍⵜ",
        "TM": "ⵜⵓⵔⴽⵎⴰⵏⵙⵜⴰⵏ",
        "TN": "ⵜⵓⵏⵙ",
        "TO": "ⵟⵓⵏⴳⴰ",
        "TR": "ⵜⵓⵔⴽⵢⴰ",
        "TT": "ⵜⵔⵉⵏⵉⴷⴰⴷ ⴷ ⵟⵓⴱⴰⴳⵓ",
        "TV": "ⵜⵓⴼⴰⵍⵓ",
        "TW": "ⵟⴰⵢⵡⴰⵏ",
        "TZ": "ⵟⴰⵏⵥⴰⵏⵢⴰ",
        "UA": "ⵓⴽⵔⴰⵏⵢⴰ",
        "UG": "ⵓⵖⴰⵏⴷⴰ",
        "US": "ⵉⵡⵓⵏⴰⴽ ⵎⵓⵏⵏⵉⵏ ⵏ ⵎⵉⵔⵉⴽⴰⵏ",
        "UY": "ⵓⵔⵓⴳⵡⴰⵢ",
        "UZ": "ⵓⵣⴱⴰⴽⵉⵙⵜⴰⵏ",
        "VA": "ⴰⵡⴰⵏⴽ ⵏ ⴼⴰⵜⵉⴽⴰⵏ",
        "VC": "ⵙⴰⵏⴼⴰⵏⵙⴰⵏ ⴷ ⴳⵔⵉⵏⴰⴷⵉⵏ",
        "VE": "ⴼⵉⵏⵣⵡⵉⵍⴰ",
        "VG": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵜⵉⵎⴳⴰⴷ ⵏ ⵏⵏⴳⵍⵉⵣ",
        "VI": "ⵜⵉⴳⵣⵉⵔⵉⵏ ⵜⵉⵎⴳⴰⴷ ⵏ ⵉⵡⵓⵏⴰⴽ ⵎⵓⵏⵏⵉⵏ",
        "VN": "ⴼⵉⵜⵏⴰⵎ",
        "VU": "ⴼⴰⵏⵡⴰⵟⵓ",
        "WF": "ⵡⴰⵍⵉⵙ ⴷ ⴼⵓⵜⵓⵏⴰ",
        "WS": "ⵙⴰⵎⵡⴰ",
        "YE": "ⵢⴰⵎⴰⵏ",
        "YT": "ⵎⴰⵢⵓⵟ",
        "ZA": "ⴰⴼⵔⵉⵇⵢⴰ ⵏ ⵉⴼⴼⵓⵙ",
        "ZM": "ⵣⴰⵎⴱⵢⴰ",
        "ZW": "ⵣⵉⵎⴱⴰⴱⵡⵉ"
    };
  }-*/;
}
