//@ui5-bundle sap/tnt/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/IllustratedMessageType", ["sap/ui/base/DataType"],function(t){"use strict";var n={Avatar:"tnt-Avatar",Calculator:"tnt-Calculator",ChartArea:"tnt-ChartArea",ChartArea2:"tnt-ChartArea2",ChartBar:"tnt-ChartBar",ChartBPMNFlow:"tnt-ChartBPMNFlow",ChartBullet:"tnt-ChartBullet",ChartDoughnut:"tnt-ChartDoughnut",ChartFlow:"tnt-ChartFlow",ChartGantt:"tnt-ChartGantt",ChartOrg:"tnt-ChartOrg",ChartPie:"tnt-ChartPie",CodePlaceholder:"tnt-CodePlaceholder",Company:"tnt-Company",Compass:"tnt-Compass",Components:"tnt-Components",Dialog:"tnt-Dialog",ExternalLink:"tnt-ExternalLink",FaceID:"tnt-FaceID",Fingerprint:"tnt-Fingerprint",Handshake:"tnt-Handshake",Help:"tnt-Help",Lock:"tnt-Lock",Mission:"tnt-Mission",MissionFailed:"tnt-MissionFailed",NoApplications:"tnt-NoApplications",NoFlows:"tnt-NoFlows",NoUsers:"tnt-NoUsers",Radar:"tnt-Radar",RoadMap:"tnt-RoadMap",Secrets:"tnt-Secrets",Services:"tnt-Services",SessionExpired:"tnt-SessionExpired",SessionExpiring:"tnt-SessionExpiring",Settings:"tnt-Settings",Success:"tnt-Success",SuccessfulAuth:"tnt-SuccessfulAuth",Systems:"tnt-Systems",Teams:"tnt-Teams",Tools:"tnt-Tools",Tutorials:"tnt-Tutorials",UnableToLoad:"tnt-UnableToLoad",Unlock:"tnt-Unlock",UnsuccessfulAuth:"tnt-UnsuccessfulAuth",User2:"tnt-User2"};t.registerEnum("sap.tnt.IllustratedMessageType",n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/InfoLabel", ["./library","sap/ui/core/ControlBehavior","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Control","./InfoLabelRenderer"],function(e,t,r,a,o,i){"use strict";var n=e.RenderMode;var p=a.TextDirection;var u=o.extend("sap.tnt.InfoLabel",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.tnt",properties:{text:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"},renderMode:{type:"sap.tnt.RenderMode",defaultValue:n.Loose,group:"Appearance"},colorScheme:{type:"int",group:"Misc",defaultValue:7},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:p.Inherit},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""}}},renderer:i});u.prototype.init=function(){if(t.isAccessibilityEnabled()&&!i._sAriaText){var e=r.getResourceBundleFor("sap.tnt");i._sAriaText=e.getText("INFOLABEL_DEFAULT");i._sAriaTextEmpty=e.getText("INFOLABEL_EMPTY")}};u.prototype.getFormDoNotAdjustWidth=function(){return true};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/InfoLabelRenderer", ["./library","sap/ui/core/library","sap/base/Log","sap/ui/core/IconPool"],function(e,t,n,a){"use strict";var o=e.RenderMode;var s=t.TextDirection;var i={apiVersion:2};i.render=function(e,t){var r=t.getColorScheme(),l=t.getText(),c=t.getTextDirection(),p=t.getWidth(),f=t.getTooltip(),d=t.getIcon();if(r<1||r>10){r=7;n.warning("sap.tnt.InfoLabel: colorScheme value is set to the default value of 7. Provided value should be between 1 and 10")}e.openStart("div",t).class("sapTntInfoLabel");if(t.getRenderMode()===o.Narrow){e.class("sapTntInfoLabelRenderModeNarrow")}if(t.getDisplayOnly()){e.class("sapTntInfoLabelDisplayOnly")}if(l===""){e.class("sapTntInfoLabelNoText")}if(p){e.style("width",p)}if(d){e.class("sapTntInfoLabelWithIcon")}if(f){e.attr("title",f)}e.class("backgroundColor"+r).openEnd();e.openStart("span").class("sapTntInfoLabelInner");if(c!==s.Inherit){e.attr("dir",c.toLowerCase())}e.openEnd();if(d){if(l&&d){e.icon(d,[],{title:""})}else{e.icon(d)}}e.openStart("span").class("sapTntInfoLabelText").openEnd();e.text(l);e.close("span");e.close("span");if(i._sAriaText){e.openStart("span").class("sapUiPseudoInvisibleText").openEnd();if(l){e.text(i._sAriaText)}else if(!d){e.text(i._sAriaTextEmpty)}else{if(f){e.text(f+" "+i._sAriaText)}else if(a.getIconInfo(t.getIcon()).text){e.text(a.getIconInfo(t.getIcon()).text+" "+i._sAriaText)}else{e.text(a.getIconInfo(t.getIcon()).name+" "+i._sAriaText)}}e.close("span")}e.close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationList", ["./library","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/Popup","sap/m/Popover","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","./NavigationListItem","./NavigationListMenuItem","./NavigationListRenderer","sap/m/Menu","sap/m/MenuItem","sap/base/Log"],function(e,t,i,o,s,n,a,r,l,p,d,c,g,m,u,f){"use strict";const h=s.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItemBase",multiple:true,singularName:"item"},_overflowItem:{type:"sap.tnt.NavigationListItem",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:g});h.prototype.init=function(){this._oItemNavigation=new l;this._oItemNavigation.setCycling(false).setPageSize(10).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._handleThemeAppliedBound=this._handleThemeApplied.bind(this)};h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}this._deregisterResizeHandler();i.detachApplied(this._handleThemeAppliedBound)};h.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();const e=this.getSelectedKey();this.setSelectedKey(e)};h.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());this._updateNavItems();if(this.getExpanded()){return}this.getDomRef().scrollTop=0;this._sResizeListenerId=n.register(this.getDomRef().parentNode,this._resize.bind(this));i.attachApplied(this._handleThemeAppliedBound)};h.prototype._deregisterResizeHandler=function(){if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};h.prototype._handleThemeApplied=function(){i.detachApplied(this._handleThemeAppliedBound);this._updateOverflowItems()};h.prototype._resize=function(){this._updateOverflowItems()};h.prototype._updateOverflowItems=function(){var e=this.getDomRef();if(this.getExpanded()||!e){return}const t=e.querySelector(".sapTntNLOverflow");if(!t){return}t.classList.add("sapTntNLIHidden");const i=[...e.querySelectorAll("ul > :not(.sapTntNLOverflow)")];let o=i.reduce((e,t)=>{t.classList.remove("sapTntNLIHidden");return e+t.offsetHeight},0);const{paddingTop:s,paddingBottom:n}=window.getComputedStyle(e);const a=e.offsetHeight-parseFloat(s)-parseFloat(n);if(a>=o){return}t.classList.remove("sapTntNLIHidden");o=t.offsetHeight;let r=e.querySelector(".sapTntNLISelected");if(r){r=r.parentNode;const{marginTop:e,marginBottom:t}=window.getComputedStyle(r);o+=r.offsetHeight+parseFloat(e)+parseFloat(t)}i.forEach(e=>{if(e===r){return}const{marginTop:t,marginBottom:i}=window.getComputedStyle(e);o+=e.offsetHeight+parseFloat(t)+parseFloat(i);if(o>=a){e.classList.add("sapTntNLIHidden")}})};h.prototype._getOverflowItem=function(){let e=this.getAggregation("_overflowItem");if(!e){e=new d({text:t.getResourceBundleFor("sap.tnt").getText("NAVIGATION_LIST_NAVIGATION_OVERFLOW"),icon:"sap-icon://overflow",selectable:false,select:this._overflowPress.bind(this)});e._isOverflow=true;this.setAggregation("_overflowItem",e)}return e};h.prototype._overflowPress=function(e){const t=e.getSource();t.getDomRef().querySelector(".sapTntNLI").classList.add("sapTntNLIActive");const i=this._createOverflowMenu(t);i.openBy(t,false,a.Dock.EndCenter)};h.prototype._createOverflowMenu=function(e){const t=new m({items:this._createNavigationMenuItems(),itemSelected:e=>{const i=e.getParameter("item");this._selectItem({item:i._navItem});const o=this.getDomRef().querySelector(".sapTntNLISelected [tabindex]");o?.focus();t.close();t.destroy()},closed:function(){e.getDomRef().querySelector(".sapTntNLI").classList.remove("sapTntNLIActive")}});t.addStyleClass("sapTntNLMenu");t._handleMenuItemSelect=function(e){const t=e.getParameter("item");if(!t){return}const i=this._findMenuItemByUnfdMenuItem(t);if(i){this.fireItemSelected({item:i})}}.bind(t);t._createVisualMenuItemFromItem=function(e){var t=this._generateUnifiedMenuItemId(e.getId()),i=o.getElementById(t),s=e.getCustomData(),n;if(i){return i}i=new c({id:t,icon:e.getIcon(),text:e.getText(),startsSection:e.getStartsSection(),tooltip:e.getTooltip(),visible:e.getVisible(),enabled:e.getEnabled(),href:e._navItem.getHref(),target:e._navItem.getTarget()});for(n=0;n<s.length;n++){e._addCustomData(i,s[n])}e.aDelegates.forEach(function(e){i.addEventDelegate(e.oDelegate,e.vThis)});return i}.bind(t);this.addDependent(t);return t};h.prototype._createNavigationMenuItems=function(){var e=[],t=[];this.getItems().forEach(t=>{if(t.isA("sap.tnt.NavigationListGroup")){e.push(...t.getItems())}else{e.push(t)}});e.forEach(function(e){if(!e.getVisible()||!e.getDomRef().classList.contains("sapTntNLIHidden")){return}var i=new u({icon:e.getIcon(),text:e.getText(),enabled:e.getEnabled()});i._navItem=e;e.getItems().forEach(function(e){var t=new u({icon:e.getIcon(),text:e.getText(),enabled:e.getEnabled()});t._navItem=e;i.addItem(t)});t.push(i)});return t};h.prototype._updateNavItems=function(){const e=this._getFocusDomRefs();this._oItemNavigation.setItemDomRefs(e)};h.prototype._getFocusDomRefs=function(){const e=this.getItems().flatMap(e=>e._getFocusDomRefs()),t=this._getOverflowItem().getDomRef("a");if(!this.getExpanded()&&t){e.push(t)}return e};h.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=8;this._offsets=["0 -8","8 0","0 8","-8 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"]}};h.prototype._selectItem=function(e){this.fireItemSelect(e);this.setSelectedItem(e.item)};h.prototype._findItemByKey=function(e){const t=this.findAggregatedObjects(true,e=>e.isA("sap.tnt.NavigationListItem"));return t.find(t=>t._getUniqueKey()===e)};h.prototype.setSelectedKey=function(e){const t=this._findItemByKey(e);this.setSelectedItem(t);return this.setProperty("selectedKey",e,true)};h.prototype.getSelectedItem=function(){return o.getElementById(this.getAssociation("selectedItem"))||null};h.prototype.setSelectedItem=function(e){let t;if(this._selectedItem){this._selectedItem._toggle(false)}if(!e){this._selectedItem=null}const i=e&&e.isA&&e.isA("sap.tnt.NavigationListItem");if(typeof e!="string"&&!i){this.setAssociation("selectedItem",null,true);this._updateOverflowItems();e=null}this.setAssociation("selectedItem",e,true);if(typeof e=="string"){t=o.getElementById(e)}else if(i){t=e}else{f.warning("Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.");return this}this.setProperty("selectedKey",t._getUniqueKey(),true);t._toggle(true);this._selectedItem=t;this._updateOverflowItems();return this};h.prototype._openPopover=function(e,t){const i=e.getDomRef().querySelector(".sapTntNLI");i.classList.add("sapTntNLIActive");let o=t.getSelectedItem();if(o&&t.isGroupSelected){o=null}this._oPopover=new r({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:o,afterClose:()=>{if(this._oPopover){this._oPopover.destroy();this._oPopover=null;i.classList.remove("sapTntNLIActive")}},content:t,ariaLabelledBy:p.getStaticId("sap.tnt","NAVIGATION_LIST_DIALOG_TITLE")}).addStyleClass("sapContrast sapContrastPlus sapTntNLPopover");this._oPopover._adaptPositionParams=this._adaptPopoverPositionParams;this._oPopover.openBy(e.getDomRef("a"))};h.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close()}};h.prototype._containsIcon=function(){const e=this.findAggregatedObjects(true,e=>e.isA("sap.tnt.NavigationListItem")&&!e._isOverflow&&e.getProperty("icon"));return!!e.length};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListGroup", ["./library","./NavigationListItemBase"],function(t,e){"use strict";const n=e.extend("sap.tnt.NavigationListGroup",{metadata:{library:"sap.tnt",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},defaultAggregation:"items"}});n.prototype.render=function(t,e,n){if(!this.getVisible()||!e){return}const s=this.getItems(),a=this.getEnabled();if(n){this._renderSeparator(t)}if(!e.getExpanded()){s.forEach(n=>{if(!a){n.setEnabled(false)}n.render(t,e)});this._renderSeparator(t);return}t.openStart("li",this).attr("role","none").openEnd();t.openStart("div").class("sapTntNLI").class("sapTntNLGroup");if(!a){t.class("sapTntNLIDisabled")}const r=`${this.getId()}-subtree`;if(a){t.attr("tabindex","-1").accessibilityState({role:"treeitem",owns:r,expanded:e.getExpanded()&&this.getExpanded()?"true":"false"})}t.openEnd();t.openStart("span").class("sapTntNLGroupText").openEnd().text(this.getText()).close("span");t.renderControl(this._getExpandIconControl());t.close("div");t.openStart("ul",r).class("sapTntNLIItemsContainer").accessibilityState({role:"group",label:this.getText()});if(!this.getExpanded()){t.class("sapTntNLIItemsContainerHidden")}t.openEnd();s.forEach(n=>{n.render(t,e)});t.close("ul").close("li");this._renderSeparator(t)};n.prototype._renderSeparator=function(t){t.openStart("li").class("sapTntNLSeparator").attr("role","none").openEnd().close("li")};n.prototype._getFocusDomRefs=function(){const t=this.getFocusDomRef(),e=this.getItems().flatMap(t=>t._getFocusDomRefs());if(!this.getEnabled()||!this.getVisible()){return[]}if(this._isListExpanded()){e.unshift(t)}return e};n.prototype._getAccessibilityRef=function(){return this.getDomRef().querySelector(".sapTntNLGroup")};n.prototype._getExpandIconStyleClass=function(){return"sapTntNLGroupIcon"};n.prototype._getExpanderActivationTarget=function(){return".sapTntNLGroup"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListItem", ["./library","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/library","sap/ui/util/openWindow","sap/ui/util/defaultLinkTypes","./NavigationListItemBase"],function(t,e,i,s,n,o,r,a,l){"use strict";var p=o.TextAlign;var c=o.TextDirection;const g="sap-icon://navigation-right-arrow";const d="sap-icon://navigation-down-arrow";const h="sap-icon://circle-task-2";const f=l.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Appearance",defaultValue:true},selectable:{type:"boolean",group:"Behavior",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});f._getInvisibleText=function(){if(!this._invisibleText){this._invisibleText=(new i).toStatic()}return this._invisibleText};f.prototype.createListForPopup=function(){const t=this.getItems(),e=this.getNavigationList(),i=e.getSelectedItem();let s;const n=t.filter(t=>t.getVisible()).map(t=>{const e=new f({key:t.getId(),text:t.getText(),textDirection:t.getTextDirection(),enabled:t.getEnabled(),selectable:t.getSelectable(),href:t.getHref(),target:t.getTarget(),tooltip:t.getTooltip()});if(i===t){s=e}return e});const o=new f({expanded:true,hasExpander:false,selectable:this.getSelectable(),key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),tooltip:this.getTooltip(),items:n});const r=e.getMetadata().getClass().prototype.constructor;const a=new r({itemSelect:this.onPopupItemSelect.bind(this),items:o}).addStyleClass("sapTntNLPopup");if(i==this){s=o;a.isGroupSelected=true}a.setSelectedItem(s);return a};f.prototype.onPopupItemSelect=function(t){const i=t.getParameter("item"),s=e.getElementById(i.getKey());s._selectItem()};f.prototype._selectItem=function(){const t={item:this};this.fireSelect(t);if(this.getSelectable()){this.getNavigationList()._selectItem(t)}this._openUrl()};f.prototype._openUrl=function(){const t=this.getHref();if(t){r(t,this.getTarget()||"_self")}};f.prototype._getAccessibilityRef=function(){return this.getDomRef().querySelector(".sapTntNLIFirstLevel")};f.prototype.ontap=function(t){if(l.prototype.ontap.apply(this,arguments)){return}t.preventDefault();if(this.getLevel()>0){if(this.getEnabled()&&this.getAllParentsEnabled()){this._selectItem()}return}const e=this.getNavigationList();if(e.getExpanded()||!this.getItems().length){this._selectItem()}else{const t=this.createListForPopup();e._openPopover(this,t)}};f.prototype.onsapenter=f.prototype.ontap;f.prototype.onsapspace=f.prototype.ontap;f.prototype.render=function(t,e){if(!this.getVisible()){return}if(this.getLevel()===0){this.renderFirstLevelNavItem(t,e)}else{this.renderSecondLevelNavItem(t,e)}};f.prototype.renderFirstLevelNavItem=function(t,e){const i=this._getVisibleItems(this),s=this._isListExpanded(),n=this.getEnabled()||this.getAllParentsEnabled();t.openStart("li",this).attr("role","none");if(!s){if(i.length&&n){t.class("sapTntNLINotExpandedTriangle")}if(this._isOverflow){t.class("sapTntNLOverflow").class("sapTntNLIHidden")}}t.openEnd();const o=`${this.getId()}-subtree`;this.renderMainElement(t,e,o);if(s&&i.length){t.openStart("ul",o).class("sapTntNLIItemsContainer").accessibilityState({role:"group",label:this.getText()});if(!this.getExpanded()){t.class("sapTntNLIItemsContainerHidden")}t.openEnd();i.forEach(i=>i.render(t,e));t.close("ul")}t.close("li")};f.prototype._renderExternalLinkIcon=function(t){if(!(this.getHref()&&this.getTarget()==="_blank")){return}const e=this._getExternalIcon();t.renderControl(e)};f.prototype.renderMainElement=function(t,e,i){const s=this._isListExpanded(),n=this._getVisibleItems(this),o=!this.getEnabled()||!this.getAllParentsEnabled(),r=this.getExpanded(),a=this.getSelectable(),l=!!n.length&&this.getHasExpander();t.openStart("div").class("sapTntNLI").class("sapTntNLIFirstLevel");if(o){t.class("sapTntNLIDisabled")}let p=false;if(a&&e._selectedItem===this){t.class("sapTntNLISelected");p=true}if(!s&&n.includes(e._selectedItem)){t.class("sapTntNLISelected");p=true}if(l){t.class("sapTntNLIWithExpander")}const c={};if(!s){c.role=a?"menuitemradio":"menuitem";if(n.length){c.haspopup="tree"}if(this._isOverflow){c.haspopup="menu"}if(a){c.checked=e._selectedItem===this}c.roledescription=this._resourceBundleTnt.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")}else{c.role="treeitem";if(p){c.current="page"}if(n.length){c.owns=i;c.expanded=r}}t.openEnd();this._renderStartLink(t,c,o);this._renderIcon(t);this._renderText(t);this._renderExternalLinkIcon(t);if(s){t.icon(h,["sapTntNLISelectionIndicator"]);const e=this._getExpandIconControl();e.setVisible(l).setSrc(r?d:g).setTooltip(this._getExpandIconTooltip(!r));t.renderControl(e)}if(!s&&this.getItems().length){const e=this._getExpandIconControl().setSrc(g);t.renderControl(e)}this._renderCloseLink(t);t.close("div")};f.prototype.renderSecondLevelNavItem=function(t,e){const i=!this.getEnabled()||!this.getAllParentsEnabled();t.openStart("li",this).class("sapTntNLI").class("sapTntNLISecondLevel").attr("role","none");let s=false;if(this.getSelectable()&&e._selectedItem===this){t.class("sapTntNLISelected");s=true}if(i){t.class("sapTntNLIDisabled")}t.openEnd();const n={role:"treeitem",current:this._isListExpanded()&&s?"page":undefined};this._renderStartLink(t,n,i);this._renderIcon(t);this._renderText(t);t.icon(h,["sapTntNLISelectionIndicator"]);this._renderExternalLinkIcon(t);this._renderCloseLink(t);t.close("li")};f.prototype._renderStartLink=function(t,e,i){const s=this.getHref(),n=this.getTarget();t.openStart("a",`${this.getId()}-a`).accessibilityState(this,{...e});const o=this.getTooltip_AsString()||this.getText();if(o){t.attr("title",o)}if(!i){t.attr("tabindex","-1")}if(s){t.attr("href",s)}if(n){t.attr("target",n).attr("rel",a("",n))}t.openEnd()};f.prototype._renderCloseLink=function(t){t.close("a")};f.prototype._renderIcon=function(t){const e=this.getIcon(),i=n.getIconInfo(e);t.openStart("span").class("sapUiIcon").class("sapTntNLIIcon").attr("aria-hidden","true");if(e){if(i&&!i.suppressMirroring){t.class("sapUiIconMirrorInRTL")}if(i){t.attr("data-sap-ui-icon-content",i.content).style("font-family",`'${i.fontFamily}'`)}}t.openEnd().close("span")};f.prototype._renderText=function(t){t.openStart("span").class("sapMText").class("sapTntNLIText").class("sapMTextNoWrap");const e=this.getTextDirection();if(e!==c.Inherit){t.attr("dir",e.toLowerCase())}const i=s.getTextAlign(p.Begin,e);if(i){t.style("text-align",i)}t.openEnd().text(this.getText()).close("span")};f.prototype._toggle=function(t){const e=this.getNavigationList(),i=this._isListExpanded();if(!e||!e.getDomRef()){return}const s=this.getDomRef();if(this.getLevel()===0){const e=s?.querySelector(".sapTntNLIFirstLevel");e?.classList.toggle("sapTntNLISelected",t)}if(this.getLevel()!==0){if(i){s?.classList.toggle("sapTntNLISelected",t)}else{const e=this.getParent().getDomRef()?.querySelector(".sapTntNLIFirstLevel");e?.classList.toggle("sapTntNLISelected",t);if(t){e?.classList.toggle("sapTntNLINoHoverEffect",t)}}}this._syncAriaAttributes(this.getFocusDomRef(),t,i);e._closePopover()};f.prototype._syncAriaAttributes=function(t,e,i){if(!t){return}if(i){if(e){t.setAttribute("aria-current","page")}else{t.removeAttribute("aria-current")}}else{t.setAttribute("aria-checked",e?"true":"false")}};f.prototype._getFocusDomRefs=function(){const t=[];if(!this.getEnabled()||!this.getVisible()){return t}t.push(this.getDomRef("a"));if(this._isListExpanded()&&this.getExpanded()){t.push(...this.getDomRef().querySelectorAll(".sapTntNLISecondLevel:not(.sapTntNLIDisabled) a"))}return t};f.prototype._getVisibleItems=function(t){return t.getItems().filter(t=>t.getVisible())};f.prototype.onclick=function(t){if(this.getHref()){t.preventDefault()}};f.prototype.onmousedown=function(t){if(this.getHref()){t.preventDefault()}};f.prototype.onfocusout=function(){var t=this.getDomRef()?.querySelector(".sapTntNLIFirstLevel");if(t){t.classList.remove("sapTntNLINoHoverEffect")}};f.prototype.onmouseout=function(){const t=this.getDomRef()?.querySelector(".sapTntNLIFirstLevel");const e=this.getNavigationList();const i=this.getItems().find(t=>t===e.getSelectedItem());if(t&&(this===e.getSelectedItem()||i)){t.classList.add("sapTntNLINoHoverEffect")}};f.prototype.onmouseover=f.prototype.onfocusout;return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListItemBase", ["./library","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/events/KeyCodes","sap/base/i18n/Localization"],function(t,e,n,i,s,o){"use strict";const r="sap-icon://navigation-right-arrow";const a="sap-icon://navigation-down-arrow";const p="sap-icon://arrow-right";const l=e.extend("sap.tnt.NavigationListItemBase",{metadata:{library:"sap.tnt",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_externalLinkIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});l.prototype.init=function(){this._resourceBundleCore=i.getResourceBundleFor("sap.ui.core");this._resourceBundleTnt=i.getResourceBundleFor("sap.tnt")};l.prototype.exit=function(){this._resourceBundleCore=null;this._resourceBundleTnt=null};l.prototype.getLevel=function(){const t=0;const e=this.getParent();if(e&&e.isA("sap.tnt.NavigationListItem")){return e.getLevel()+1}return t};l.prototype.getNavigationList=function(){let t=this.getParent();while(t&&!t.isA("sap.tnt.NavigationList")){t=t.getParent()}return t};l.prototype.getAllParentsEnabled=function(){let t=this.getParent();while(t&&!t.isA("sap.tnt.NavigationList")){if(!t.getEnabled()){return false}t=t.getParent()}return true};l.prototype._isListExpanded=function(){const t=this.getNavigationList();if(!t){return false}return t.getExpanded()||t.hasStyleClass("sapTntNLPopup")};l.prototype._getUniqueKey=function(){const t=this.getKey();return t?t:this.getId()};l.prototype._getFocusDomRefs=function(){};l.prototype._getAccessibilityRef=function(){};l.prototype._getExpandIconControl=function(){let t=this.getAggregation("_expandIconControl");if(!t){const e=this.getExpanded();t=new n({src:e?a:r,visible:!!this.getItems()?.length&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!e)}).addStyleClass(`sapTntNLIExpandIcon ${this._getExpandIconStyleClass()}`);this.setAggregation("_expandIconControl",t,true)}return t};l.prototype._getExternalIcon=function(){var t=this.getAggregation("_externalLinkIconControl");if(!t){t=new n({src:p}).addStyleClass(`sapTntNLIExternalLinkIcon`);this.setAggregation("_externalLinkIconControl",t)}return t};l.prototype._getExpandIconStyleClass=function(){return""};l.prototype._getExpandIconTooltip=function(t){if(!this.getEnabled()||!this.getAllParentsEnabled()){return""}const e=t?"Icon.expand":"Icon.collapse";return this._resourceBundleCore.getText(e)};l.prototype.getFocusDomRef=function(){const t=this.getDomRef()?.querySelector("[tabindex]");if(!t){return null}return t};l.prototype.onkeydown=function(t){if(!this._isListExpanded()){return}if(t.isMarked("subItem")){return}t.setMarked("subItem");if(this.getLevel()!==0){return}const e=o.getRTL();if(t.shiftKey&&t.which==189||t.which==s.NUMPAD_MINUS||t.which==s.ARROW_RIGHT&&e||t.which==s.ARROW_LEFT&&!e){if(this.collapse()){t.preventDefault();t.stopPropagation()}}else if(t.which==s.NUMPAD_PLUS||t.shiftKey&&t.which==s.PLUS||t.which==s.ARROW_LEFT&&e||t.which==s.ARROW_RIGHT&&!e){if(this.expand()){t.preventDefault();t.stopPropagation()}}};l.prototype.ontap=function(t){if(t.isMarked("subItem")){return true}t.setMarked("subItem");if(!this.getEnabled()||!this.getAllParentsEnabled()){return true}if(this._handleExpanderClick(t)){return true}return false};l.prototype._handleExpanderClick=function(t){const e=this._getExpanderActivationTarget(),n=t.target.closest(e);if(!this._isListExpanded()||this.getLevel()!==0||!n){return false}if(this.getExpanded()){this.collapse()}else{this.expand()}return true};l.prototype._getExpanderActivationTarget=function(){return".sapTntNLIExpandIcon"};l.prototype.expand=function(){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()!==0){return false}this.setProperty("expanded",true,true);this._getExpandIconControl().setSrc(a).setTooltip(this._getExpandIconTooltip(false));this._getAccessibilityRef().setAttribute("aria-expanded","true");const t=this.$().find(".sapTntNLIItemsContainer").first();t.stop(true,true).slideDown("fast",()=>{const t=this.getDomRef()?.querySelector(".sapTntNLIItemsContainer");if(t){t.classList.toggle("sapTntNLIItemsContainerHidden")}this.getNavigationList()?._updateNavItems()});return true};l.prototype.collapse=function(){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()!==0){return false}this.setProperty("expanded",false,true);this._getExpandIconControl().setSrc(r).setTooltip(this._getExpandIconTooltip(true));this._getAccessibilityRef().setAttribute("aria-expanded","false");const t=this.$().find(".sapTntNLIItemsContainer").first();t.stop(true,true).slideUp("fast",()=>{const t=this.getDomRef()?.querySelector(".sapTntNLIItemsContainer");if(t){t.classList.toggle("sapTntNLIItemsContainerHidden")}this.getNavigationList()?._updateNavItems()});return true};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListMenuItem", ["sap/ui/core/IconPool","sap/ui/unified/MenuItem","sap/ui/unified/library","sap/ui/core/library","sap/ui/core/Icon","sap/ui/util/defaultLinkTypes","sap/ui/util/openWindow","sap/ui/events/KeyCodes"],function(t,e,i,n,s,a,o,r){"use strict";const p="sap-icon://arrow-right";var l=e.extend("sap.tnt.NavigationListMenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{_externalLinkIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});t.insertFontFaceStyle();l.prototype.render=function(t,e,i,s){var a=t,o=e.getSubmenu(),r=e.getEnabled(),p,l=this.getHref()&&this.getTarget()==="_blank";a.openStart("li",e);if(this.getHref()){a.class("sapUiMnuItmExternalLink")}if(e.getVisible()){a.attr("tabindex","0")}a.class("sapUiMnuItm");if(s.iItemNo==1){a.class("sapUiMnuItmFirst")}else if(s.iItemNo==s.iTotalItems){a.class("sapUiMnuItmLast")}if(!i.checkEnabled(e)){a.class("sapUiMnuItmDsbl")}if(e.getStartsSection()){a.class("sapUiMnuItmSepBefore")}if(e.getTooltip_AsString()){a.attr("title",e.getTooltip_AsString())}if(s.bAccessible){a.accessibilityState(e,{role:"menuitem",disabled:!r,posinset:s.iItemNo,setsize:s.iTotalItems,labelledby:{value:this.getId()+"-txt",append:true}});if(o){a.attr("aria-haspopup",n.aria.HasPopup.Menu.toLowerCase());a.attr("aria-owns",o.getId())}}a.openEnd();if(this.getHref()){this._renderLinkTag(a)}if(e.getIcon()&&e._getIcon){a.openStart("div");a.class("sapUiMnuItmIco");a.openEnd();p=e._getIcon(e);a.renderControl(p);a.close("div")}a.openStart("div",this.getId()+"-txt");a.class("sapUiMnuItmTxt");a.openEnd();a.text(e.getText());a.close("div");a.openStart("div",this.getId()+"-scuttxt");a.class("sapUiMnuItmSCut");a.openEnd();a.close("div");a.openStart("div");a.class("sapUiMnuItmSbMnu");a.openEnd();if(o){a.openStart("div");a.class("sapUiIconMirrorInRTL");a.openEnd();a.close("div")}a.close("div");if(l){const t=this._getExternalLinkIcon();a.renderControl(t)}if(this.getHref()){a.close("a")}a.close("li")};l.prototype.hover=function(t,e){this.$().toggleClass("sapUiMnuItmHov",t)};l.prototype.focus=function(t){if(this.getVisible()){this.$().trigger("focus")}else{t.focus()}};l.prototype.onclick=function(t){t.preventDefault();this._openUrl()};l.prototype.onkeyup=function(t){if(t.which===r.SPACE||t.which===r.ENTER){this._openUrl()}};l.prototype._openUrl=function(){const t=this.getHref();if(t){o(t,this.getTarget()||"_self")}};l.prototype._getExternalLinkIcon=function(){var t=this.getAggregation("_externalLinkIcon");if(!t){t=new s({src:p}).addStyleClass(`sapTntNLIExternalLinkIcon`);this.setAggregation("_externalLinkIcon",t)}return t};l.prototype._renderLinkTag=function(t){const e=this.getHref(),i=this.getTarget(),n=this.getEnabled();t.openStart("a",`${this.getId()}-a`);const s=this.getTooltip_AsString()||this.getText();if(s){t.attr("title",s)}if(!n){t.attr("tabindex","-1")}if(e){t.attr("href",e)}if(i){t.attr("target",i).attr("rel",a("",i))}t.openEnd()};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListRenderer", ["sap/ui/core/Lib"],function(e){"use strict";const t={apiVersion:2};t.render=function(t,n){const s=n.getExpanded(),i=n._containsIcon(),a=n.getItems().filter(e=>e.getVisible());t.openStart("ul",n).class("sapTntNL");if(!s){t.class("sapTntNLCollapsed")}if(!i){t.class("sapTntNLNoIcons")}var r=n.getWidth();if(r&&s){t.style("width",r)}const o=!s&&!n.hasStyleClass("sapTntNLPopup")?"menubar":"tree";t.accessibilityState(n,{role:o,orientation:o==="menubar"?"vertical":undefined,roledescription:e.getResourceBundleFor("sap.tnt").getText(o==="menubar"?"NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUBAR":"NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE")});t.openEnd();const c=a.find(e=>e.isA("sap.tnt.NavigationListGroup"));a.forEach(e=>{e.render(t,n,e===c)});if(!s){n._getOverflowItem().render(t,n)}t.close("ul")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/SideNavigation", ["./library","sap/ui/core/Control","sap/ui/core/Element","./SideNavigationRenderer"],function(e,t,i,s){"use strict";const n=t.extend("sap.tnt.SideNavigation",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"item",aggregations:{item:{type:"sap.tnt.NavigationList",multiple:false,bindable:"bindable"},fixedItem:{type:"sap.tnt.NavigationList",multiple:false},footer:{type:"sap.tnt.NavigationList",multiple:false}},associations:{selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:s});n.prototype.setAggregation=function(e,i){if(i&&i.attachItemSelect){i.attachItemSelect(this._itemSelectionHandler.bind(this))}return t.prototype.setAggregation.apply(this,arguments)};n.prototype.setExpanded=function(e){if(this.getExpanded()===e){return this}this.setProperty("expanded",e);e=this.getExpanded();const t=this.getItem(),i=this.getFixedItem();if(t){t.setExpanded(e)}if(i){i.setExpanded(e)}return this};n.prototype.onBeforeRendering=function(){const e=this.getSelectedItem(),t=this.getSelectedKey(),i=this.getItem(),s=this.getFixedItem(),n=this.getExpanded();if(t){this.setSelectedKey(t)}else if(e){this.setSelectedItem(e)}if(!n&&i){i.setExpanded(false)}if(!n&&s){s.setExpanded(false)}};n.prototype.setSelectedKey=function(e){const t=this.getItem(),i=this.getFixedItem();let s;if(e&&t){s=t._findItemByKey(e);if(!s&&i){s=i._findItemByKey(e)}}if(s){this.setSelectedItem(s)}this.setProperty("selectedKey",e,true);return this};n.prototype.setSelectedItem=function(e){const t=this.getItem(),s=this.getFixedItem();if(!e){t?.setSelectedItem(null);s?.setSelectedItem(null)}let n;if(typeof e=="string"){n=i.getElementById(e)}else{n=e}const a=n?n._getUniqueKey():"";this.setProperty("selectedKey",a,true);const l=n?.getNavigationList&&n.getNavigationList()===t,o=n?.getNavigationList&&n.getNavigationList()===s;if(l){t.setSelectedItem(n);s?.setSelectedKey(null)}if(o){s.setSelectedItem(n);t?.setSelectedKey(null)}return this.setAssociation("selectedItem",n,true)};n.prototype._itemSelectionHandler=function(e){const t=e.getParameter("item");this.setSelectedItem(t);this.fireItemSelect({item:t})};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/SideNavigationRenderer", ["sap/ui/core/Lib"],function(e){"use strict";const t={apiVersion:2};const i=e.getResourceBundleFor("sap.tnt");t.render=function(e,t){this.startSideNavigation(e,t);this.renderFlexibleList(e,t);this.renderFixedList(e,t);this.renderFooter(e,t);this.endSideNavigation(e)};t.startSideNavigation=function(e,t){const n=t.getExpanded(),a=t.getAriaLabel();e.openStart("nav",t).class("sapTntSideNavigation").class("sapContrast").class("sapContrastPlus").accessibilityState(t,{roledescription:i.getText("SIDENAVIGATION_ROLE_DESCRIPTION")}).attr("data-sap-ui-fastnavgroup","true");if(a){e.accessibilityState(t,{label:a})}if(!n){e.class("sapTntSideNavigationNotExpanded").class("sapTntSideNavigationNotExpandedWidth")}const o=t.getWidth();if(o&&n){e.style("width",o)}e.openEnd()};t.endSideNavigation=function(e){e.close("nav")};t.renderFlexibleList=function(e,t){var i=t.getItem();e.openStart("div",`${t.getId()}-Flexible`).class("sapTntSideNavigationFlexible").openEnd();e.openStart("div",`${t.getId()}-Flexible-Content`).class("sapTntSideNavigationFlexibleContent").openEnd();e.renderControl(i);e.close("div").close("div")};t.renderFixedList=function(e,t){var n=t.getFixedItem();if(!n){return}e.openStart("div").class("sapTntSideNavigationSeparator").accessibilityState({role:"separator",roledescription:i.getText("SIDENAVIGATION_ROLE_DESCRIPTION_SEPARATOR"),orientation:"horizontal"}).openEnd().close("div");e.openStart("div").class("sapTntSideNavigationFixed").openEnd();e.renderControl(n);e.close("div")};t.renderFooter=function(e,t){const i=t.getAggregation("footer");if(!i){return}e.openStart("footer").class("sapTntSideNavigationFooter").openEnd().renderControl(i).close("footer")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeader", ["./library","sap/m/OverflowToolbar","sap/m/OverflowToolbarAssociativePopover","./ToolHeaderRenderer","sap/ui/Device","sap/m/library"],function(e,t,o,a,r,s){"use strict";var p=s.PlacementType;var n=t.extend("sap.tnt.ToolHeader",{metadata:{interfaces:["sap.tnt.IToolHeader"],library:"sap.tnt",properties:{},aggregations:{}},renderer:a});n.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapTntToolHeader sapContrast sapContrastPlus")};n.prototype._getPopover=function(){var e=this.getAggregation("_popover");if(!e){e=new o(this.getId()+"-popover",{showHeader:false,showArrow:r.system.phone?false:true,modal:false,horizontalScrolling:r.system.phone?false:true,contentWidth:r.system.phone?"100%":"auto"}).addStyleClass("sapTntToolHeaderPopover sapContrast sapContrastPlus");if(r.system.phone){e.attachBeforeOpen(this._shiftPopupShadow,this);e.attachAfterOpen(this._shiftPopupShadow,this)}e.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",e,true)}return e};n.prototype._getBestActionSheetPlacement=function(){return p.Bottom};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeaderRenderer", ["sap/m/library","sap/ui/core/Renderer","sap/m/OverflowToolbarRenderer","sap/m/BarInPageEnabler"],function(e,r,t,n){"use strict";var o=e.OverflowToolbarPriority;var i=r.extend(t);i.apiVersion=2;i.renderBarContent=function(e,r){var t=false,i=null,l;if(r.getActive()){e.renderControl(r._getActiveButton())}r._getVisibleContent().forEach(function(a){n.addChildClassTo(a,r);l=a.isA("sap.tnt.ToolHeaderUtilitySeparator");if(l&&!t){this._renderOverflowButton(e,r);t=true}if(r._getControlPriority(a)!==o.AlwaysOverflow){if(!i&&a.getVisible()){a.addStyleClass("sapMBarChildFirstChild");i=a}else{a.removeStyleClass("sapMBarChildFirstChild")}e.renderControl(a)}}.bind(this));if(t){return}this._renderOverflowButton(e,r)};i._renderOverflowButton=function(e,r){var n=r.getContent().some(function(e){return e.getVisible()&&r._getControlPriority(e)===o.AlwaysOverflow}),i=r.getContent().some(function(e){return e.getVisible()});if(n||r._getOverflowButtonNeeded()){t.renderOverflowButton(e,r)}if(i){t.renderOverflowButtonClone(e,r)}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeaderUtilitySeparator", ["./library","sap/ui/core/Control"],function(r,e){"use strict";var t=e.extend("sap.tnt.ToolHeaderUtilitySeparator",{metadata:{library:"sap.tnt",properties:{}},renderer:{apiVersion:2,render:function(){}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolPage", ["./library","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","./ToolPageRenderer"],function(e,t,i,n,r,s,o){"use strict";var a=t.PageBackgroundDesign;var d=n.extend("sap.tnt.ToolPage",{metadata:{library:"sap.tnt",properties:{sideExpanded:{type:"boolean",group:"Misc",defaultValue:true},contentBackgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:a.Standard}},aggregations:{header:{type:"sap.tnt.IToolHeader",multiple:false},subHeader:{type:"sap.tnt.IToolHeader",multiple:false},sideContent:{type:"sap.tnt.SideNavigation",multiple:false},mainContents:{type:"sap.ui.core.Control",multiple:true,singularName:"mainContent"}},events:{}},renderer:o});d.prototype.init=function(){this._oContentObserver=new i(this._onContentChange.bind(this));this._oContentObserver.observe(this,{aggregations:["subHeader","sideContent"]});this._oContentVisibilityObserver=new i(this._onContentVisibilityChange.bind(this));this._deregisterControl()};d.prototype.exit=function(){this._deregisterControl();if(this._oContentObserver){this._oContentObserver.disconnect();this._oContentObserver=null}if(this._oContentVisibilityObserver){this._oContentVisibilityObserver.disconnect();this._oContentVisibilityObserver=null}};d.prototype.onBeforeRendering=function(){this._deregisterControl()};d.prototype.onAfterRendering=function(){this._ResizeHandler=s.register(this.getDomRef(),this._mediaQueryHandler.bind(this));this._updateLastMediaQuery()};d.prototype.toggleSideContentMode=function(){return this.setSideExpanded(!this.getSideExpanded())};d.prototype.setSideExpanded=function(e){this.setProperty("sideExpanded",e,true);var t=this.getSideContent();if(t){var i=r.system.phone?true:e;t.setExpanded(i)}else{return this}var n=this.getDomRef();if(!n){return this}if(e){n.querySelector(".sapTntToolPageContentWrapper").classList.remove("sapTntToolPageAsideCollapsed")}else{n.querySelector(".sapTntToolPageContentWrapper").classList.add("sapTntToolPageAsideCollapsed")}return this};d.prototype._deregisterControl=function(){if(this._ResizeHandler){s.deregister(this._ResizeHandler);this._ResizeHandler=null}};d.prototype._mediaQueryHandler=function(){var e=this.getSideContent();if(e===null){return}this._currentMediaQuery=this._getDeviceAsString();if(this._getLastMediaQuery()===this._currentMediaQuery){return}switch(this._currentMediaQuery){case"Combi":this.setSideExpanded(true);break;case"Tablet":this.setSideExpanded(false);break;case"Phone":this.setSideExpanded(false);e.setExpanded(true);break;default:this.setSideExpanded(true)}this._updateLastMediaQuery()};d.prototype._getLastMediaQuery=function(){return this._lastMediaQuery};d.prototype._updateLastMediaQuery=function(){this._lastMediaQuery=this._getDeviceAsString();return this};d.prototype._getDeviceAsString=function(){if(r.system.combi){return"Combi"}if(r.system.phone){return"Phone"}if(r.system.tablet){return"Tablet"}return"Desktop"};d.prototype._onContentChange=function(e){switch(e.mutation){case"insert":this._oContentVisibilityObserver.observe(e.child,{properties:["visible"]});break;case"remove":this._oContentVisibilityObserver.unobserve(e.child,{properties:["visible"]});break}};d.prototype._onContentVisibilityChange=function(e){this.invalidate()};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolPageRenderer", ["sap/ui/Device"],function(e){"use strict";var n={apiVersion:2};n.render=function(e,n){e.openStart("div",n).class("sapTntToolPage").openEnd();this.renderHeader(e,n);this.renderContent(e,n);e.close("div")};n.renderHeader=function(e,n){var t=n.getHeader(),a=n.getSubHeader();if(t||a){e.openStart("div").class("sapTntToolPageHeaderWrapper");if(t&&a&&a.getVisible()){e.class("sapTntToolPageHeaderWithSubHeaderWrapper")}e.openEnd();e.openStart("header").openEnd()}if(t){e.openStart("div",n.getId()+"-header").class("sapTntToolPageHeader").openEnd();e.renderControl(t);e.close("div")}if(a&&a.getVisible()){e.openStart("div",n.getId()+"-subHeader").class("sapTntToolPageHeader").openEnd();e.renderControl(a);e.close("div")}if(t||a){e.close("header");e.close("div")}};n.renderContent=function(n,t){n.openStart("div").class("sapTntToolPageContentWrapper");if(!e.system.desktop||!t.getSideExpanded()){n.class("sapTntToolPageAsideCollapsed")}n.openEnd();this.renderAsideContent(n,t);this.renderMainContent(n,t);n.close("div")};n.renderAsideContent=function(n,t){var a=t.getSideContent();if(!a||!a.getVisible()){return}n.openStart("aside",t.getId()+"-aside").class("sapTntToolPageAside").openEnd();n.openStart("div").class("sapTntToolPageAsideContent").openEnd();var o=t.getSideExpanded();if(a&&a.getExpanded()!==o){a.setExpanded(o)}if(!e.system.desktop){t.setSideExpanded(false)}n.renderControl(a);n.close("div");n.close("aside")};n.renderMainContent=function(e,n){var t=n.getMainContents();if(!t){return}e.openStart("div",n.getId()+"-main").class("sapTntToolPageMain").class("sapTntToolPageMainBackground-"+n.getContentBackgroundDesign()).openEnd();e.openStart("div").class("sapTntToolPageMainContent").openEnd();e.openStart("div").class("sapTntToolPageMainContentWrapper").openEnd();t.forEach(e.renderControl,e);e.close("div");e.close("div");e.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationList.flexibility", [],function(){"use strict";return{moveControls:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationListGroup.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XTIT"}),unhideControl:"default",moveControls:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationListItem.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XTIT"}),unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/library", ["./IllustratedMessageType","sap/ui/base/DataType","sap/ui/core/Lib","sap/ui/core/library","sap/m/library"],function(t,e,a){"use strict";var i=a.init({apiVersion:2,name:"sap.tnt",version:"1.128.0",dependencies:["sap.ui.core","sap.m"],designtime:"sap/tnt/designtime/library.designtime",types:["sap.tnt.IllustratedMessageType","sap.tnt.RenderMode"],interfaces:["sap.tnt.IToolHeader"],controls:["sap.tnt.NavigationList","sap.tnt.ToolHeaderUtilitySeparator","sap.tnt.ToolHeader","sap.tnt.SideNavigation","sap.tnt.ToolPage","sap.tnt.InfoLabel"],elements:["sap.tnt.NavigationListItem","sap.tnt.NavigationListGroup"],extensions:{flChangeHandlers:{"sap.tnt.NavigationList":"sap/tnt/flexibility/NavigationList","sap.tnt.NavigationListItem":"sap/tnt/flexibility/NavigationListItem","sap.tnt.NavigationListGroup":"sap/tnt/flexibility/NavigationListGroup"}}});i.IllustratedMessageType=t;i.RenderMode={Narrow:"Narrow",Loose:"Loose"};e.registerEnum("sap.tnt.RenderMode",i.RenderMode);return i});
sap.ui.require.preload({
	"sap/tnt/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.tnt","type":"library","embeds":[],"applicationVersion":{"version":"1.128.0"},"title":"SAPUI5 library with responsive controls.","description":"SAPUI5 library with responsive controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.128","libs":{"sap.ui.core":{"minVersion":"1.128.0"},"sap.m":{"minVersion":"1.128.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.tnt.NavigationList","sap.tnt.ToolHeaderUtilitySeparator","sap.tnt.ToolHeader","sap.tnt.SideNavigation","sap.tnt.ToolPage","sap.tnt.InfoLabel"],"elements":["sap.tnt.NavigationListItem","sap.tnt.NavigationListGroup"],"types":["sap.tnt.IllustratedMessageType","sap.tnt.RenderMode"],"interfaces":["sap.tnt.IToolHeader"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
