{"srotm"=>
  {"summary"=>
    ["   APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX",
     "   (SX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF SX ARE IN",
     "   (SX**T)",
     "   SX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE",
     "   LX = (-INCX)*N, AND SIMILARLY FOR SY USING USING LY AND INCY.",
     "   WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..",
     "   SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0",
     "     (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)",
     "   H=(          )    (          )    (          )    (          )",
     "     (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).",
     "   SEE  SROTMG FOR A DESCRIPTION OF DATA STORAGE IN SPARAM."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "        number of elements in input vector(s)"],
     "SX"=>
      ["[in,out]",
       "         SX is REAL array, dimension N",
       "        double precision vector with N elements"],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "        storage spacing between elements of SX"],
     "SY"=>
      ["[in,out]",
       "         SY is REAL array, dimension N",
       "        double precision vector with N elements"],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "        storage spacing between elements of SY"],
     "SPARAM"=>
      ["[in,out]",
       "         SPARAM is REAL array, dimension 5",
       "    SPARAM(1)=SFLAG",
       "    SPARAM(2)=SH11",
       "    SPARAM(3)=SH21",
       "    SPARAM(4)=SH12",
       "    SPARAM(5)=SH22"]}},
 "ssbmv"=>
  {"summary"=>
    ["SSBMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric band matrix, with k super-diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the band matrix A is being supplied as",
       "          follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 being supplied.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 being supplied."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry, K specifies the number of super-diagonals of the",
       "          matrix A. K must satisfy  0 .le. K."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the symmetric matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer the upper",
       "          triangular part of a symmetric band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the symmetric matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer the lower",
       "          triangular part of a symmetric band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in]",
       "         X is REAL array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "cgemm"=>
  {"summary"=>
    ["CGEMM  performs one of the matrix-matrix operations",
     "   C := alpha*op( A )*op( B ) + beta*C,",
     "where  op( X ) is one of",
     "   op( X ) = X   or   op( X ) = X**T   or   op( X ) = X**H,",
     "alpha and beta are scalars, and A, B and C are matrices, with op( A )",
     "an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix."],
   "param"=>
    {"TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n',  op( A ) = A.",
       "             TRANSA = 'T' or 't',  op( A ) = A**T.",
       "             TRANSA = 'C' or 'c',  op( A ) = A**H."],
     "TRANSB"=>
      ["[in]",
       "         TRANSB is CHARACTER*1",
       "          On entry, TRANSB specifies the form of op( B ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSB = 'N' or 'n',  op( B ) = B.",
       "             TRANSB = 'T' or 't',  op( B ) = B**T.",
       "             TRANSB = 'C' or 'c',  op( B ) = B**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies  the number  of rows  of the  matrix",
       "          op( A )  and of the  matrix  C.  M  must  be at least  zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N  specifies the number  of columns of the matrix",
       "          op( B ) and the number of columns of the matrix C. N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry,  K  specifies  the number of columns of the matrix",
       "          op( A ) and the number of rows of the matrix op( B ). K must",
       "          be at least  zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.",
       "          Before entry with  TRANSA = 'N' or 'n',  the leading  m by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by m  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. When  TRANSA = 'N' or 'n' then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX array of DIMENSION ( LDB, kb ), where kb is",
       "          n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.",
       "          Before entry with  TRANSB = 'N' or 'n',  the leading  k by n",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  n by k  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in the calling (sub) program. When  TRANSB = 'N' or 'n' then",
       "          LDB must be at least  max( 1, k ), otherwise  LDB must be at",
       "          least  max( 1, n )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n  matrix",
       "          ( alpha*op( A )*op( B ) + beta*C )."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "csymm"=>
  {"summary"=>
    ["CSYMM  performs one of the matrix-matrix operations",
     "   C := alpha*A*B + beta*C,",
     "or",
     "   C := alpha*B*A + beta*C,",
     "where  alpha and beta are scalars, A is a symmetric matrix and  B and",
     "C are m by n matrices."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE  specifies whether  the  symmetric matrix  A",
       "          appears on the  left or right  in the  operation as follows:",
       "             SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,",
       "             SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of  the  symmetric  matrix   A  is  to  be",
       "          referenced as follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of the",
       "                                 symmetric matrix is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of the",
       "                                 symmetric matrix is to be referenced."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies the number of rows of the matrix  C.",
       "          M  must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix C.",
       "          N  must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          m  when  SIDE = 'L' or 'l'  and is n  otherwise.",
       "          Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading m by m upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  m by m  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading n by n upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  n by n  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the  calling (sub) program. When  SIDE = 'L' or 'l'  then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX array of DIMENSION ( LDB, n ).",
       "          Before entry, the leading  m by n part of the array  B  must",
       "          contain the matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n updated",
       "          matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "csyrk"=>
  {"summary"=>
    ["CSYRK  performs one of the symmetric rank k operations",
     "   C := alpha*A*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*A + beta*C,",
     "where  alpha and beta  are scalars,  C is an  n by n symmetric matrix",
     "and  A  is an  n by k  matrix in the first case and a  k by n  matrix",
     "in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*A**T + beta*C.",
       "             TRANS = 'T' or 't'   C := alpha*A**T*A + beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns   of  the   matrix   A,   and  on   entry   with",
       "          TRANS = 'T' or 't',  K  specifies  the number of rows of the",
       "          matrix A.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "ssymv"=>
  {"summary"=>
    ["SSYMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "cher2"=>
  {"summary"=>
    ["CHER2  performs the hermitian rank 2 operation",
     "   A := alpha*x*y**H + conjg( alpha )*y*x**H + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an n",
     "by n hermitian matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the hermitian matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the hermitian matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "dtrmv"=>
  {"summary"=>
    ["DTRMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**T*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "srotmg"=>
  {"summary"=>
    ["   CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS",
     "   THE SECOND COMPONENT OF THE 2-VECTOR  (SQRT(SD1)*SX1,SQRT(SD2)*>    SY2)**T.",
     "   WITH SPARAM(1)=SFLAG, H HAS ONE OF THE FOLLOWING FORMS..",
     "   SFLAG=-1.E0     SFLAG=0.E0        SFLAG=1.E0     SFLAG=-2.E0",
     "     (SH11  SH12)    (1.E0  SH12)    (SH11  1.E0)    (1.E0  0.E0)",
     "   H=(          )    (          )    (          )    (          )",
     "     (SH21  SH22),   (SH21  1.E0),   (-1.E0 SH22),   (0.E0  1.E0).",
     "   LOCATIONS 2-4 OF SPARAM CONTAIN SH11,SH21,SH12, AND SH22",
     "   RESPECTIVELY. (VALUES OF 1.E0, -1.E0, OR 0.E0 IMPLIED BY THE",
     "   VALUE OF SPARAM(1) ARE NOT STORED IN SPARAM.)",
     "   THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE",
     "   INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE",
     "   OF SD1 AND SD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM."],
   "param"=>
    {"SD1"=>["[in,out]", "         SD1 is REAL"],
     "SD2"=>["[in,out]", "         SD2 is REAL"],
     "SX1"=>["[in,out]", "         SX1 is REAL"],
     "SY1"=>["[in]", "         SY1 is REAL"],
     "SPARAM"=>
      ["[in,out]",
       "         SPARAM is REAL array, dimension 5",
       "    SPARAM(1)=SFLAG",
       "    SPARAM(2)=SH11",
       "    SPARAM(3)=SH21",
       "    SPARAM(4)=SH12",
       "    SPARAM(5)=SH22"]}},
 "zsyrk"=>
  {"summary"=>
    ["ZSYRK  performs one of the symmetric rank k operations",
     "   C := alpha*A*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*A + beta*C,",
     "where  alpha and beta  are scalars,  C is an  n by n symmetric matrix",
     "and  A  is an  n by k  matrix in the first case and a  k by n  matrix",
     "in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*A**T + beta*C.",
       "             TRANS = 'T' or 't'   C := alpha*A**T*A + beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns   of  the   matrix   A,   and  on   entry   with",
       "          TRANS = 'T' or 't',  K  specifies  the number of rows of the",
       "          matrix A.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "zher2k"=>
  {"summary"=>
    ["ZHER2K  performs one of the hermitian rank 2k operations",
     "   C := alpha*A*B**H + conjg( alpha )*B*A**H + beta*C,",
     "or",
     "   C := alpha*A**H*B + conjg( alpha )*B**H*A + beta*C,",
     "where  alpha and beta  are scalars with  beta  real,  C is an  n by n",
     "hermitian matrix and  A and B  are  n by k matrices in the first case",
     "and  k by n  matrices in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'    C := alpha*A*B**H          +",
       "                                        conjg( alpha )*B*A**H +",
       "                                        beta*C.",
       "             TRANS = 'C' or 'c'    C := alpha*A**H*B          +",
       "                                        conjg( alpha )*B**H*A +",
       "                                        beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns  of the  matrices  A and B,  and on  entry  with",
       "          TRANS = 'C' or 'c',  K  specifies  the number of rows of the",
       "          matrices  A and B.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16 .",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array of DIMENSION ( LDB, kb ), where kb is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  k by n  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDB must be at least  max( 1, n ), otherwise  LDB must",
       "          be at least  max( 1, k ).",
       "          Unchanged on exit."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION .",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set,  they are assumed to be zero,  and on exit they",
       "          are set to zero."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "sgemm"=>
  {"summary"=>
    ["SGEMM  performs one of the matrix-matrix operations",
     "   C := alpha*op( A )*op( B ) + beta*C,",
     "where  op( X ) is one of",
     "   op( X ) = X   or   op( X ) = X**T,",
     "alpha and beta are scalars, and A, B and C are matrices, with op( A )",
     "an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix."],
   "param"=>
    {"TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n',  op( A ) = A.",
       "             TRANSA = 'T' or 't',  op( A ) = A**T.",
       "             TRANSA = 'C' or 'c',  op( A ) = A**T."],
     "TRANSB"=>
      ["[in]",
       "         TRANSB is CHARACTER*1",
       "          On entry, TRANSB specifies the form of op( B ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSB = 'N' or 'n',  op( B ) = B.",
       "             TRANSB = 'T' or 't',  op( B ) = B**T.",
       "             TRANSB = 'C' or 'c',  op( B ) = B**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies  the number  of rows  of the  matrix",
       "          op( A )  and of the  matrix  C.  M  must  be at least  zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N  specifies the number  of columns of the matrix",
       "          op( B ) and the number of columns of the matrix C. N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry,  K  specifies  the number of columns of the matrix",
       "          op( A ) and the number of rows of the matrix op( B ). K must",
       "          be at least  zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.",
       "          Before entry with  TRANSA = 'N' or 'n',  the leading  m by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by m  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. When  TRANSA = 'N' or 'n' then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is REAL array of DIMENSION ( LDB, kb ), where kb is",
       "          n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.",
       "          Before entry with  TRANSB = 'N' or 'n',  the leading  k by n",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  n by k  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in the calling (sub) program. When  TRANSB = 'N' or 'n' then",
       "          LDB must be at least  max( 1, k ), otherwise  LDB must be at",
       "          least  max( 1, n )."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is REAL array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n  matrix",
       "          ( alpha*op( A )*op( B ) + beta*C )."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "zgerc"=>
  {"summary"=>
    ["ZGERC  performs the rank 1 operation",
     "   A := alpha*x*y**H + A,",
     "where alpha is a scalar, x is an m element vector, y is an n element",
     "vector and A is an m by n matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the m",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients. On exit, A is",
       "          overwritten by the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."]}},
 "dznrm2"=>
  {"summary"=>
    ["DZNRM2 returns the euclidean norm of a vector via the function",
     "name, so that",
     "   DZNRM2 := sqrt( x**H*x )"],
   "param"=>nil},
 "ztrsv"=>
  {"summary"=>
    ["ZTRSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,   or   A**H*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**H*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zhpmv"=>
  {"summary"=>
    ["ZHPMV  performs the matrix-vector operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n hermitian matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX*16 array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set and are assumed to be zero."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "ddot"=>
  {"summary"=>
    ["   DDOT forms the dot product of two vectors.",
     "   uses unrolled loops for increments equal to one."],
   "param"=>nil},
 "idamax"=>
  {"summary"=>
    ["   IDAMAX finds the index of the first element having maximum absolute value."],
   "param"=>nil},
 "zdrot"=>
  {"summary"=>
    ["Applies a plane rotation, where the cos and sin (c and s) are real",
     "and the vectors cx and cy are complex.",
     "jack dongarra, linpack, 3/11/78."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the vectors cx and cy.",
       "          N must be at least zero."],
     "CX"=>
      ["[in,out]",
       "         CX is COMPLEX*16 array, dimension at least",
       "          ( 1 + ( N - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array CX must contain the n",
       "          element vector cx. On exit, CX is overwritten by the updated",
       "          vector cx."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          CX. INCX must not be zero."],
     "CY"=>
      ["[in,out]",
       "         CY is COMPLEX*16 array, dimension at least",
       "          ( 1 + ( N - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array CY must contain the n",
       "          element vector cy. On exit, CY is overwritten by the updated",
       "          vector cy."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          CY. INCY must not be zero."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION",
       "          On entry, C specifies the cosine, cos."],
     "S"=>
      ["[in]",
       "         S is DOUBLE PRECISION",
       "          On entry, S specifies the sine, sin."]}},
 "ztbmv"=>
  {"summary"=>
    ["ZTBMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,   or   x := A**H*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular band matrix, with ( k + 1 ) diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**H*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in]",
       "         X is (input/output) COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dsbmv"=>
  {"summary"=>
    ["DSBMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric band matrix, with k super-diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the band matrix A is being supplied as",
       "          follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 being supplied.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 being supplied."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry, K specifies the number of super-diagonals of the",
       "          matrix A. K must satisfy  0 .le. K."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the symmetric matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer the upper",
       "          triangular part of a symmetric band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the symmetric matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer the lower",
       "          triangular part of a symmetric band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "cgbmv"=>
  {"summary"=>
    ["CGBMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,   or",
     "   y := alpha*A**H*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n band matrix, with kl sub-diagonals and ku super-diagonals."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**H*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "          On entry, KL specifies the number of sub-diagonals of the",
       "          matrix A. KL must satisfy  0 .le. KL."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "          On entry, KU specifies the number of super-diagonals of the",
       "          matrix A. KU must satisfy  0 .le. KU."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading ( kl + ku + 1 ) by n part of the",
       "          array A must contain the matrix of coefficients, supplied",
       "          column by column, with the leading diagonal of the matrix in",
       "          row ( ku + 1 ) of the array, the first super-diagonal",
       "          starting at position 2 in row ku, the first sub-diagonal",
       "          starting at position 1 in row ( ku + 2 ), and so on.",
       "          Elements in the array A that do not correspond to elements",
       "          in the band matrix (such as the top left ku by ku triangle)",
       "          are not referenced.",
       "          The following program segment will transfer a band matrix",
       "          from conventional full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   K = KU + 1 - J",
       "                   DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )",
       "                      A( K + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( kl + ku + 1 )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "csrot"=>
  {"summary"=>
    ["CSROT applies a plane rotation, where the cos and sin (c and s) are real",
     "and the vectors cx and cy are complex.",
     "jack dongarra, linpack, 3/11/78."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the vectors cx and cy.",
       "          N must be at least zero."],
     "CX"=>
      ["[in,out]",
       "         CX is COMPLEX array, dimension at least",
       "          ( 1 + ( N - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array CX must contain the n",
       "          element vector cx. On exit, CX is overwritten by the updated",
       "          vector cx."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          CX. INCX must not be zero."],
     "CY"=>
      ["[in,out]",
       "         CY is COMPLEX array, dimension at least",
       "          ( 1 + ( N - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array CY must contain the n",
       "          element vector cy. On exit, CY is overwritten by the updated",
       "          vector cy."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          CY. INCY must not be zero."],
     "C"=>
      ["[in]",
       "         C is REAL",
       "          On entry, C specifies the cosine, cos."],
     "S"=>
      ["[in]",
       "         S is REAL",
       "          On entry, S specifies the sine, sin."]}},
 "sspmv"=>
  {"summary"=>
    ["SSPMV  performs the matrix-vector operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "AP"=>
      ["[in]",
       "         AP is REAL array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "izamax"=>
  {"summary"=>
    ["   IZAMAX finds the index of the first element having maximum |Re(.)| + |Im(.)|"],
   "param"=>nil},
 "snrm2"=>
  {"summary"=>
    ["SNRM2 returns the euclidean norm of a vector via the function",
     "name, so that",
     "   SNRM2 := sqrt( x'*x )."],
   "param"=>nil},
 "chpr2"=>
  {"summary"=>
    ["CHPR2  performs the hermitian rank 2 operation",
     "   A := alpha*x*y**H + conjg( alpha )*y*x**H + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an",
     "n by n hermitian matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."]}},
 "dcopy"=>
  {"summary"=>
    ["   DCOPY copies a vector, x, to a vector, y.",
     "   uses unrolled loops for increments equal to one."],
   "param"=>nil},
 "ctrmv"=>
  {"summary"=>
    ["CTRMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,   or   x := A**H*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**H*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dsyr2k"=>
  {"summary"=>
    ["DSYR2K  performs one of the symmetric rank 2k operations",
     "   C := alpha*A*B**T + alpha*B*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*B + alpha*B**T*A + beta*C,",
     "where  alpha and beta  are scalars, C is an  n by n  symmetric matrix",
     "and  A and B  are  n by k  matrices  in the  first  case  and  k by n",
     "matrices in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*B**T + alpha*B*A**T +",
       "                                       beta*C.",
       "             TRANS = 'T' or 't'   C := alpha*A**T*B + alpha*B**T*A +",
       "                                       beta*C.",
       "             TRANS = 'C' or 'c'   C := alpha*A**T*B + alpha*B**T*A +",
       "                                       beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns  of the  matrices  A and B,  and on  entry  with",
       "          TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number",
       "          of rows of the matrices  A and B.  K must be at least  zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  k by n  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDB must be at least  max( 1, n ), otherwise  LDB must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "cgeru"=>
  {"summary"=>
    ["CGERU  performs the rank 1 operation",
     "   A := alpha*x*y**T + A,",
     "where alpha is a scalar, x is an m element vector, y is an n element",
     "vector and A is an m by n matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the m",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients. On exit, A is",
       "          overwritten by the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."]}},
 "sscal"=>
  {"summary"=>
    ["   scales a vector by a constant.",
     "   uses unrolled loops for increment equal to 1."],
   "param"=>nil},
 "sswap"=>
  {"summary"=>
    ["   interchanges two vectors.",
     "   uses unrolled loops for increments equal to 1."],
   "param"=>nil},
 "ztrmm"=>
  {"summary"=>
    ["ZTRMM  performs one of the matrix-matrix operations",
     "   B := alpha*op( A )*B,   or   B := alpha*B*op( A )",
     "where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T   or   op( A ) = A**H."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE specifies whether  op( A ) multiplies B from",
       "          the left or right as follows:",
       "             SIDE = 'L' or 'l'   B := alpha*op( A )*B.",
       "             SIDE = 'R' or 'r'   B := alpha*B*op( A )."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**H."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, k ), where k is m",
       "          when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is (input/output) COMPLEX*16 array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain the matrix  B,  and  on exit  is overwritten  by the",
       "          transformed matrix."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "zrotg"=>
  {"summary"=>["   ZROTG determines a double complex Givens rotation."],
   "param"=>nil},
 "zscal"=>
  {"summary"=>["   ZSCAL scales a vector by a constant."], "param"=>nil},
 "ssyr2"=>
  {"summary"=>
    ["SSYR2  performs the symmetric rank 2 operation",
     "   A := alpha*x*y**T + alpha*y*x**T + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an n",
     "by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "icamax"=>
  {"summary"=>
    ["   ICAMAX finds the index of the first element having maximum |Re(.)| + |Im(.)|"],
   "param"=>nil},
 "cscal"=>
  {"summary"=>["   CSCAL scales a vector by a constant."], "param"=>nil},
 "ztpmv"=>
  {"summary"=>
    ["ZTPMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,   or   x := A**H*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**H*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX*16 array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in]",
       "         X is (input/output) COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zdotu"=>
  {"summary"=>
    ["ZDOTU forms the dot product of two complex vectors",
     "     ZDOTU = X^T * Y"],
   "param"=>nil},
 "xerbla_array"=>
  {"summary"=>
    ["XERBLA_ARRAY assists other languages in calling XERBLA, the LAPACK",
     "and BLAS error handler.  Rather than taking a Fortran string argument",
     "as the function's name, XERBLA_ARRAY takes an array of single",
     "characters along with the array's length.  XERBLA_ARRAY then copies",
     "up to 32 characters of that array into a Fortran string and passes",
     "that to XERBLA.  If called with a non-positive SRNAME_LEN,",
     "XERBLA_ARRAY will call XERBLA with a string of all blank characters.",
     "Say some macro or other device makes XERBLA_ARRAY available to C99",
     "by a name lapack_xerbla and with a common Fortran calling convention.",
     "Then a C99 program could invoke XERBLA via:",
     "   {",
     "     int flen = strlen(__func__);",
     "     lapack_xerbla(__func__, &flen, &info);",
     "   }",
     "Providing XERBLA_ARRAY is not necessary for intercepting LAPACK",
     "errors.  XERBLA_ARRAY calls XERBLA."],
   "param"=>
    {"SRNAME_ARRAY"=>
      ["[in]",
       "         SRNAME_ARRAY is CHARACTER(1) array, dimension (SRNAME_LEN)",
       "         The name of the routine which called XERBLA_ARRAY."],
     "SRNAME_LEN"=>
      ["[in]",
       "         SRNAME_LEN is INTEGER",
       "         The length of the name in SRNAME_ARRAY."],
     "INFO"=>
      ["[in]",
       "         INFO is INTEGER",
       "         The position of the invalid parameter in the parameter list",
       "         of the calling routine."]}},
 "dtrsv"=>
  {"summary"=>
    ["DTRSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**T*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero.",
       " Level 2 Blas routine.",
       " -- Written on 22-October-1986.",
       "    Jack Dongarra, Argonne National Lab.",
       "    Jeremy Du Croz, Nag Central Office.",
       "    Sven Hammarling, Nag Central Office.",
       "    Richard Hanson, Sandia National Labs."]}},
 "ctrsm"=>
  {"summary"=>
    ["CTRSM  solves one of the matrix equations",
     "   op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,",
     "where alpha is a scalar, X and B are m by n matrices, A is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T   or   op( A ) = A**H.",
     "The matrix X is overwritten on B."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry, SIDE specifies whether op( A ) appears on the left",
       "          or right of X as follows:",
       "             SIDE = 'L' or 'l'   op( A )*X = alpha*B.",
       "             SIDE = 'R' or 'r'   X*op( A ) = alpha*B."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**H."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, k ),",
       "          where k is m when SIDE = 'L' or 'l'",
       "            and k is n when SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain  the  right-hand  side  matrix  B,  and  on exit  is",
       "          overwritten by the solution matrix  X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "zher2"=>
  {"summary"=>
    ["ZHER2  performs the hermitian rank 2 operation",
     "   A := alpha*x*y**H + conjg( alpha )*y*x**H + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an n",
     "by n hermitian matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the hermitian matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the hermitian matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "xerbla"=>
  {"summary"=>
    ["XERBLA  is an error handler for the LAPACK routines.",
     "It is called by an LAPACK routine if an input parameter has an",
     "invalid value.  A message is printed and execution stops.",
     "Installers may consider modifying the STOP statement in order to",
     "call system-specific exception-handling facilities."],
   "param"=>
    {"SRNAME"=>
      ["[in]",
       "         SRNAME is CHARACTER*(*)",
       "         The name of the routine which called XERBLA."],
     "INFO"=>
      ["[in]",
       "         INFO is INTEGER",
       "         The position of the invalid parameter in the parameter list",
       "         of the calling routine."]}},
 "ctrmm"=>
  {"summary"=>
    ["CTRMM  performs one of the matrix-matrix operations",
     "   B := alpha*op( A )*B,   or   B := alpha*B*op( A )",
     "where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T   or   op( A ) = A**H."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE specifies whether  op( A ) multiplies B from",
       "          the left or right as follows:",
       "             SIDE = 'L' or 'l'   B := alpha*op( A )*B.",
       "             SIDE = 'R' or 'r'   B := alpha*B*op( A )."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**H."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, k ), where k is m",
       "          when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain the matrix  B,  and  on exit  is overwritten  by the",
       "          transformed matrix."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "cgerc"=>
  {"summary"=>
    ["CGERC  performs the rank 1 operation",
     "   A := alpha*x*y**H + A,",
     "where alpha is a scalar, x is an m element vector, y is an n element",
     "vector and A is an m by n matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the m",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients. On exit, A is",
       "          overwritten by the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."]}},
 "crotg"=>
  {"summary"=>["CROTG determines a complex Givens rotation."], "param"=>nil},
 "drotm"=>
  {"summary"=>
    ["   APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX",
     "   (DX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF DX ARE IN",
     "   (DY**T)",
     "   DX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE",
     "   LX = (-INCX)*N, AND SIMILARLY FOR SY USING LY AND INCY.",
     "   WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..",
     "   DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0",
     "     (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)",
     "   H=(          )    (          )    (          )    (          )",
     "     (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).",
     "   SEE DROTMG FOR A DESCRIPTION OF DATA STORAGE IN DPARAM."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "        number of elements in input vector(s)"],
     "DX"=>
      ["[in,out]",
       "         DX is DOUBLE PRECISION array, dimension N",
       "        double precision vector with N elements"],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "        storage spacing between elements of DX"],
     "DY"=>
      ["[in,out]",
       "         DY is DOUBLE PRECISION array, dimension N",
       "        double precision vector with N elements"],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "        storage spacing between elements of DY"],
     "DPARAM"=>
      ["[in,out]",
       "         DPARAM is DOUBLE PRECISION array, dimension 5",
       "    DPARAM(1)=DFLAG",
       "    DPARAM(2)=DH11",
       "    DPARAM(3)=DH21",
       "    DPARAM(4)=DH12",
       "    DPARAM(5)=DH22"]}},
 "scabs1"=>
  {"summary"=>["SCABS1 computes |Re(.)| + |Im(.)| of a complex number"],
   "param"=>nil},
 "sger"=>
  {"summary"=>
    ["SGER   performs the rank 1 operation",
     "   A := alpha*x*y**T + A,",
     "where alpha is a scalar, x is an m element vector, y is an n element",
     "vector and A is an m by n matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the m",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients. On exit, A is",
       "          overwritten by the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."]}},
 "lsame"=>
  {"summary"=>
    ["LSAME returns .TRUE. if CA is the same letter as CB regardless of",
     "case."],
   "param"=>
    {"CA"=>["[in]", "         CA is CHARACTER*1"],
     "CB"=>
      ["[in]",
       "         CB is CHARACTER*1",
       "         CA and CB specify the single characters to be compared."]}},
 "sasum"=>
  {"summary"=>
    ["   SASUM takes the sum of the absolute values.",
     "   uses unrolled loops for increment equal to one."],
   "param"=>nil},
 "scopy"=>
  {"summary"=>
    ["   SCOPY copies a vector, x, to a vector, y.",
     "   uses unrolled loops for increments equal to 1."],
   "param"=>nil},
 "srotg"=>
  {"summary"=>["   SROTG construct givens plane rotation."], "param"=>nil},
 "sgemv"=>
  {"summary"=>
    ["SGEMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n matrix."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**T*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."],
     "X"=>
      ["[in]",
       "         X is REAL array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry with BETA non-zero, the incremented array Y",
       "          must contain the vector y. On exit, Y is overwritten by the",
       "          updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "daxpy"=>
  {"summary"=>
    ["   DAXPY constant times a vector plus a vector.",
     "   uses unrolled loops for increments equal to one."],
   "param"=>nil},
 "dcabs1"=>
  {"summary"=>["DCABS1 computes |Re(.)| + |Im(.)| of a double complex number"],
   "param"=>nil},
 "ctpsv"=>
  {"summary"=>
    ["CTPSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,   or   A**H*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix, supplied in packed form.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**H*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zaxpy"=>
  {"summary"=>["   ZAXPY constant times a vector plus a vector."],
   "param"=>nil},
 "dger"=>
  {"summary"=>
    ["DGER   performs the rank 1 operation",
     "   A := alpha*x*y**T + A,",
     "where alpha is a scalar, x is an m element vector, y is an n element",
     "vector and A is an m by n matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the m",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients. On exit, A is",
       "          overwritten by the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."]}},
 "dspr2"=>
  {"summary"=>
    ["DSPR2  performs the symmetric rank 2 operation",
     "   A := alpha*x*y**T + alpha*y*x**T + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an",
     "n by n symmetric matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix."]}},
 "sdot"=>
  {"summary"=>
    ["   SDOT forms the dot product of two vectors.",
     "   uses unrolled loops for increments equal to one."],
   "param"=>nil},
 "zdscal"=>
  {"summary"=>["   ZDSCAL scales a vector by a constant."], "param"=>nil},
 "dsyr"=>
  {"summary"=>
    ["DSYR   performs the symmetric rank 1 operation",
     "   A := alpha*x*x**T + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "ztbsv"=>
  {"summary"=>
    ["ZTBSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,   or   A**H*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular band matrix, with ( k + 1 )",
     "diagonals.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**H*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dtrmm"=>
  {"summary"=>
    ["DTRMM  performs one of the matrix-matrix operations",
     "   B := alpha*op( A )*B,   or   B := alpha*B*op( A ),",
     "where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE specifies whether  op( A ) multiplies B from",
       "          the left or right as follows:",
       "             SIDE = 'L' or 'l'   B := alpha*op( A )*B.",
       "             SIDE = 'R' or 'r'   B := alpha*B*op( A )."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**T."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "          A is DOUBLE PRECISION array of DIMENSION ( LDA, k ), where k is m",
       "          when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain the matrix  B,  and  on exit  is overwritten  by the",
       "          transformed matrix."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "sdsdot"=>{"summary"=>[], "param"=>nil},
 "csyr2k"=>
  {"summary"=>
    ["CSYR2K  performs one of the symmetric rank 2k operations",
     "   C := alpha*A*B**T + alpha*B*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*B + alpha*B**T*A + beta*C,",
     "where  alpha and beta  are scalars,  C is an  n by n symmetric matrix",
     "and  A and B  are  n by k  matrices  in the  first  case  and  k by n",
     "matrices in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'    C := alpha*A*B**T + alpha*B*A**T +",
       "                                        beta*C.",
       "             TRANS = 'T' or 't'    C := alpha*A**T*B + alpha*B**T*A +",
       "                                        beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns  of the  matrices  A and B,  and on  entry  with",
       "          TRANS = 'T' or 't',  K  specifies  the number of rows of the",
       "          matrices  A and B.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX array of DIMENSION ( LDB, kb ), where kb is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  k by n  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDB must be at least  max( 1, n ), otherwise  LDB must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "ssyr"=>
  {"summary"=>
    ["SSYR   performs the symmetric rank 1 operation",
     "   A := alpha*x*x**T + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "strmm"=>
  {"summary"=>
    ["STRMM  performs one of the matrix-matrix operations",
     "   B := alpha*op( A )*B,   or   B := alpha*B*op( A ),",
     "where  alpha  is a scalar,  B  is an m by n matrix,  A  is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE specifies whether  op( A ) multiplies B from",
       "          the left or right as follows:",
       "             SIDE = 'L' or 'l'   B := alpha*op( A )*B.",
       "             SIDE = 'R' or 'r'   B := alpha*B*op( A )."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**T."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, k ), where k is m",
       "          when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is REAL array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain the matrix  B,  and  on exit  is overwritten  by the",
       "          transformed matrix."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "cher2k"=>
  {"summary"=>
    ["CHER2K  performs one of the hermitian rank 2k operations",
     "   C := alpha*A*B**H + conjg( alpha )*B*A**H + beta*C,",
     "or",
     "   C := alpha*A**H*B + conjg( alpha )*B**H*A + beta*C,",
     "where  alpha and beta  are scalars with  beta  real,  C is an  n by n",
     "hermitian matrix and  A and B  are  n by k matrices in the first case",
     "and  k by n  matrices in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'    C := alpha*A*B**H          +",
       "                                        conjg( alpha )*B*A**H +",
       "                                        beta*C.",
       "             TRANS = 'C' or 'c'    C := alpha*A**H*B          +",
       "                                        conjg( alpha )*B**H*A +",
       "                                        beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns  of the  matrices  A and B,  and on  entry  with",
       "          TRANS = 'C' or 'c',  K  specifies  the number of rows of the",
       "          matrices  A and B.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX array of DIMENSION ( LDB, kb ), where kb is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  k by n  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDB must be at least  max( 1, n ), otherwise  LDB must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set,  they are assumed to be zero,  and on exit they",
       "          are set to zero."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "zhemv"=>
  {"summary"=>
    ["ZHEMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n hermitian matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the hermitian matrix and the strictly",
       "          lower triangular part of A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the hermitian matrix and the strictly",
       "          upper triangular part of A is not referenced.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set and are assumed to be zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "dgemm"=>
  {"summary"=>
    ["DGEMM  performs one of the matrix-matrix operations",
     "   C := alpha*op( A )*op( B ) + beta*C,",
     "where  op( X ) is one of",
     "   op( X ) = X   or   op( X ) = X**T,",
     "alpha and beta are scalars, and A, B and C are matrices, with op( A )",
     "an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix."],
   "param"=>
    {"TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n',  op( A ) = A.",
       "             TRANSA = 'T' or 't',  op( A ) = A**T.",
       "             TRANSA = 'C' or 'c',  op( A ) = A**T."],
     "TRANSB"=>
      ["[in]",
       "         TRANSB is CHARACTER*1",
       "          On entry, TRANSB specifies the form of op( B ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSB = 'N' or 'n',  op( B ) = B.",
       "             TRANSB = 'T' or 't',  op( B ) = B**T.",
       "             TRANSB = 'C' or 'c',  op( B ) = B**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies  the number  of rows  of the  matrix",
       "          op( A )  and of the  matrix  C.  M  must  be at least  zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N  specifies the number  of columns of the matrix",
       "          op( B ) and the number of columns of the matrix C. N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry,  K  specifies  the number of columns of the matrix",
       "          op( A ) and the number of rows of the matrix op( B ). K must",
       "          be at least  zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.",
       "          Before entry with  TRANSA = 'N' or 'n',  the leading  m by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by m  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. When  TRANSA = 'N' or 'n' then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is",
       "          n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.",
       "          Before entry with  TRANSB = 'N' or 'n',  the leading  k by n",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  n by k  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in the calling (sub) program. When  TRANSB = 'N' or 'n' then",
       "          LDB must be at least  max( 1, k ), otherwise  LDB must be at",
       "          least  max( 1, n )."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n  matrix",
       "          ( alpha*op( A )*op( B ) + beta*C )."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "strmv"=>
  {"summary"=>
    ["STRMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**T*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "sspr2"=>
  {"summary"=>
    ["SSPR2  performs the symmetric rank 2 operation",
     "   A := alpha*x*y**T + alpha*y*x**T + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an",
     "n by n symmetric matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is REAL array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix."]}},
 "zgemm"=>
  {"summary"=>
    ["ZGEMM  performs one of the matrix-matrix operations",
     "   C := alpha*op( A )*op( B ) + beta*C,",
     "where  op( X ) is one of",
     "   op( X ) = X   or   op( X ) = X**T   or   op( X ) = X**H,",
     "alpha and beta are scalars, and A, B and C are matrices, with op( A )",
     "an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix."],
   "param"=>
    {"TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n',  op( A ) = A.",
       "             TRANSA = 'T' or 't',  op( A ) = A**T.",
       "             TRANSA = 'C' or 'c',  op( A ) = A**H."],
     "TRANSB"=>
      ["[in]",
       "         TRANSB is CHARACTER*1",
       "          On entry, TRANSB specifies the form of op( B ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSB = 'N' or 'n',  op( B ) = B.",
       "             TRANSB = 'T' or 't',  op( B ) = B**T.",
       "             TRANSB = 'C' or 'c',  op( B ) = B**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies  the number  of rows  of the  matrix",
       "          op( A )  and of the  matrix  C.  M  must  be at least  zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N  specifies the number  of columns of the matrix",
       "          op( B ) and the number of columns of the matrix C. N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry,  K  specifies  the number of columns of the matrix",
       "          op( A ) and the number of rows of the matrix op( B ). K must",
       "          be at least  zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANSA = 'N' or 'n',  and is  m  otherwise.",
       "          Before entry with  TRANSA = 'N' or 'n',  the leading  m by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by m  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. When  TRANSA = 'N' or 'n' then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array of DIMENSION ( LDB, kb ), where kb is",
       "          n  when  TRANSB = 'N' or 'n',  and is  k  otherwise.",
       "          Before entry with  TRANSB = 'N' or 'n',  the leading  k by n",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  n by k  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in the calling (sub) program. When  TRANSB = 'N' or 'n' then",
       "          LDB must be at least  max( 1, k ), otherwise  LDB must be at",
       "          least  max( 1, n )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n  matrix",
       "          ( alpha*op( A )*op( B ) + beta*C )."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "ctbsv"=>
  {"summary"=>
    ["CTBSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,   or   A**H*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular band matrix, with ( k + 1 )",
     "diagonals.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**H*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "strsv"=>
  {"summary"=>
    ["STRSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**T*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dtpmv"=>
  {"summary"=>
    ["DTPMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**T*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is DOUBLE PRECISION array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "ztrmv"=>
  {"summary"=>
    ["ZTRMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,   or   x := A**H*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**H*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in]",
       "         X is (input/output) COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dasum"=>
  {"summary"=>["   DASUM takes the sum of the absolute values."],
   "param"=>nil},
 "ccopy"=>
  {"summary"=>["   CCOPY copies a vector x to a vector y."], "param"=>nil},
 "caxpy"=>
  {"summary"=>["   CAXPY constant times a vector plus a vector."],
   "param"=>nil},
 "zgemv"=>
  {"summary"=>
    ["ZGEMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,   or",
     "   y := alpha*A**H*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n matrix."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**H*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry with BETA non-zero, the incremented array Y",
       "          must contain the vector y. On exit, Y is overwritten by the",
       "          updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "chbmv"=>
  {"summary"=>
    ["CHBMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n hermitian band matrix, with k super-diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the band matrix A is being supplied as",
       "          follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 being supplied.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 being supplied."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry, K specifies the number of super-diagonals of the",
       "          matrix A. K must satisfy  0 .le. K."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the hermitian matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer the upper",
       "          triangular part of a hermitian band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the hermitian matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer the lower",
       "          triangular part of a hermitian band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set and are assumed to be zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "chemm"=>
  {"summary"=>
    ["CHEMM  performs one of the matrix-matrix operations",
     "   C := alpha*A*B + beta*C,",
     "or",
     "   C := alpha*B*A + beta*C,",
     "where alpha and beta are scalars, A is an hermitian matrix and  B and",
     "C are m by n matrices."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE  specifies whether  the  hermitian matrix  A",
       "          appears on the  left or right  in the  operation as follows:",
       "             SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,",
       "             SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of  the  hermitian  matrix   A  is  to  be",
       "          referenced as follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of the",
       "                                 hermitian matrix is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of the",
       "                                 hermitian matrix is to be referenced."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies the number of rows of the matrix  C.",
       "          M  must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix C.",
       "          N  must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          m  when  SIDE = 'L' or 'l'  and is n  otherwise.",
       "          Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of",
       "          the array  A  must contain the  hermitian matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading m by m upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  hermitian matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  m by m  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  hermitian",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of",
       "          the array  A  must contain the  hermitian matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading n by n upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  hermitian matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  n by n  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  hermitian",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Note that the imaginary parts  of the diagonal elements need",
       "          not be set, they are assumed to be zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the  calling (sub) program. When  SIDE = 'L' or 'l'  then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX array of DIMENSION ( LDB, n ).",
       "          Before entry, the leading  m by n part of the array  B  must",
       "          contain the matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n updated",
       "          matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "sgbmv"=>
  {"summary"=>
    ["SGBMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n band matrix, with kl sub-diagonals and ku super-diagonals."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**T*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "          On entry, KL specifies the number of sub-diagonals of the",
       "          matrix A. KL must satisfy  0 .le. KL."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "          On entry, KU specifies the number of super-diagonals of the",
       "          matrix A. KU must satisfy  0 .le. KU."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading ( kl + ku + 1 ) by n part of the",
       "          array A must contain the matrix of coefficients, supplied",
       "          column by column, with the leading diagonal of the matrix in",
       "          row ( ku + 1 ) of the array, the first super-diagonal",
       "          starting at position 2 in row ku, the first sub-diagonal",
       "          starting at position 1 in row ( ku + 2 ), and so on.",
       "          Elements in the array A that do not correspond to elements",
       "          in the band matrix (such as the top left ku by ku triangle)",
       "          are not referenced.",
       "          The following program segment will transfer a band matrix",
       "          from conventional full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   K = KU + 1 - J",
       "                   DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )",
       "                      A( K + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( kl + ku + 1 )."],
     "X"=>
      ["[in]",
       "         X is REAL array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "dtrsm"=>
  {"summary"=>
    ["DTRSM  solves one of the matrix equations",
     "   op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,",
     "where alpha is a scalar, X and B are m by n matrices, A is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T.",
     "The matrix X is overwritten on B."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry, SIDE specifies whether op( A ) appears on the left",
       "          or right of X as follows:",
       "             SIDE = 'L' or 'l'   op( A )*X = alpha*B.",
       "             SIDE = 'R' or 'r'   X*op( A ) = alpha*B."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**T."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, k ),",
       "          where k is m when SIDE = 'L' or 'l'",
       "            and k is n when SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain  the  right-hand  side  matrix  B,  and  on exit  is",
       "          overwritten by the solution matrix  X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "zsymm"=>
  {"summary"=>
    ["ZSYMM  performs one of the matrix-matrix operations",
     "   C := alpha*A*B + beta*C,",
     "or",
     "   C := alpha*B*A + beta*C,",
     "where  alpha and beta are scalars, A is a symmetric matrix and  B and",
     "C are m by n matrices."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE  specifies whether  the  symmetric matrix  A",
       "          appears on the  left or right  in the  operation as follows:",
       "             SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,",
       "             SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of  the  symmetric  matrix   A  is  to  be",
       "          referenced as follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of the",
       "                                 symmetric matrix is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of the",
       "                                 symmetric matrix is to be referenced."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies the number of rows of the matrix  C.",
       "          M  must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix C.",
       "          N  must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          m  when  SIDE = 'L' or 'l'  and is n  otherwise.",
       "          Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading m by m upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  m by m  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading n by n upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  n by n  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the  calling (sub) program. When  SIDE = 'L' or 'l'  then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array of DIMENSION ( LDB, n ).",
       "          Before entry, the leading  m by n part of the array  B  must",
       "          contain the matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n updated",
       "          matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "dtpsv"=>
  {"summary"=>
    ["DTPSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix, supplied in packed form.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**T*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is DOUBLE PRECISION array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dtbsv"=>
  {"summary"=>
    ["DTBSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular band matrix, with ( k + 1 )",
     "diagonals.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**T*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "scasum"=>
  {"summary"=>
    ["   SCASUM takes the sum of the (|Re(.)| + |Im(.)|)'s of a complex vector and",
     "   returns a single precision result."],
   "param"=>nil},
 "dsymv"=>
  {"summary"=>
    ["DSYMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "ctbmv"=>
  {"summary"=>
    ["CTBMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,   or   x := A**H*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular band matrix, with ( k + 1 ) diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**H*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "ssyrk"=>
  {"summary"=>
    ["SSYRK  performs one of the symmetric rank k operations",
     "   C := alpha*A*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*A + beta*C,",
     "where  alpha and beta  are scalars, C is an  n by n  symmetric matrix",
     "and  A  is an  n by k  matrix in the first case and a  k by n  matrix",
     "in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*A**T + beta*C.",
       "             TRANS = 'T' or 't'   C := alpha*A**T*A + beta*C.",
       "             TRANS = 'C' or 'c'   C := alpha*A**T*A + beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns   of  the   matrix   A,   and  on   entry   with",
       "          TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number",
       "          of rows of the matrix  A.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is REAL array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "cdotu"=>
  {"summary"=>
    ["CDOTU forms the dot product of two complex vectors",
     "     CDOTU = X^T * Y"],
   "param"=>nil},
 "ctrsv"=>
  {"summary"=>
    ["CTRSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,   or   A**H*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**H*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular matrix and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular matrix and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced either, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "stbmv"=>
  {"summary"=>
    ["STBMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular band matrix, with ( k + 1 ) diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**T*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zcopy"=>
  {"summary"=>["   ZCOPY copies a vector, x, to a vector, y."], "param"=>nil},
 "zhemm"=>
  {"summary"=>
    ["ZHEMM  performs one of the matrix-matrix operations",
     "   C := alpha*A*B + beta*C,",
     "or",
     "   C := alpha*B*A + beta*C,",
     "where alpha and beta are scalars, A is an hermitian matrix and  B and",
     "C are m by n matrices."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE  specifies whether  the  hermitian matrix  A",
       "          appears on the  left or right  in the  operation as follows:",
       "             SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,",
       "             SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of  the  hermitian  matrix   A  is  to  be",
       "          referenced as follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of the",
       "                                 hermitian matrix is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of the",
       "                                 hermitian matrix is to be referenced."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies the number of rows of the matrix  C.",
       "          M  must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix C.",
       "          N  must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          m  when  SIDE = 'L' or 'l'  and is n  otherwise.",
       "          Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of",
       "          the array  A  must contain the  hermitian matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading m by m upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  hermitian matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  m by m  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  hermitian",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of",
       "          the array  A  must contain the  hermitian matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading n by n upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  hermitian matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  n by n  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  hermitian",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Note that the imaginary parts  of the diagonal elements need",
       "          not be set, they are assumed to be zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the  calling (sub) program. When  SIDE = 'L' or 'l'  then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array of DIMENSION ( LDB, n ).",
       "          Before entry, the leading  m by n part of the array  B  must",
       "          contain the matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n updated",
       "          matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "zhbmv"=>
  {"summary"=>
    ["ZHBMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n hermitian band matrix, with k super-diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the band matrix A is being supplied as",
       "          follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 being supplied.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 being supplied."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry, K specifies the number of super-diagonals of the",
       "          matrix A. K must satisfy  0 .le. K."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the hermitian matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer the upper",
       "          triangular part of a hermitian band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the hermitian matrix, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer the lower",
       "          triangular part of a hermitian band matrix from conventional",
       "          full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set and are assumed to be zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "dgbmv"=>
  {"summary"=>
    ["DGBMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n band matrix, with kl sub-diagonals and ku super-diagonals."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**T*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "          On entry, KL specifies the number of sub-diagonals of the",
       "          matrix A. KL must satisfy  0 .le. KL."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "          On entry, KU specifies the number of super-diagonals of the",
       "          matrix A. KU must satisfy  0 .le. KU."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading ( kl + ku + 1 ) by n part of the",
       "          array A must contain the matrix of coefficients, supplied",
       "          column by column, with the leading diagonal of the matrix in",
       "          row ( ku + 1 ) of the array, the first super-diagonal",
       "          starting at position 2 in row ku, the first sub-diagonal",
       "          starting at position 1 in row ( ku + 2 ), and so on.",
       "          Elements in the array A that do not correspond to elements",
       "          in the band matrix (such as the top left ku by ku triangle)",
       "          are not referenced.",
       "          The following program segment will transfer a band matrix",
       "          from conventional full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   K = KU + 1 - J",
       "                   DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )",
       "                      A( K + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( kl + ku + 1 )."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "cgemv"=>
  {"summary"=>
    ["CGEMV performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,   or",
     "   y := alpha*A**H*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n matrix."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**H*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry with BETA non-zero, the incremented array Y",
       "          must contain the vector y. On exit, Y is overwritten by the",
       "          updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "cherk"=>
  {"summary"=>
    ["CHERK  performs one of the hermitian rank k operations",
     "   C := alpha*A*A**H + beta*C,",
     "or",
     "   C := alpha*A**H*A + beta*C,",
     "where  alpha and beta  are  real scalars,  C is an  n by n  hermitian",
     "matrix and  A  is an  n by k  matrix in the  first case and a  k by n",
     "matrix in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*A**H + beta*C.",
       "             TRANS = 'C' or 'c'   C := alpha*A**H*A + beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns   of  the   matrix   A,   and  on   entry   with",
       "          TRANS = 'C' or 'c',  K  specifies  the number of rows of the",
       "          matrix A.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set,  they are assumed to be zero,  and on exit they",
       "          are set to zero."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "dsdot"=>
  {"summary"=>
    ["Compute the inner product of two vectors with extended",
     "precision accumulation and result.",
     "Returns D.P. dot product accumulated in D.P., for S.P. SX and SY",
     "DSDOT = sum for I = 0 to N-1 of  SX(LX+I*INCX) * SY(LY+I*INCY),",
     "where LX = 1 if INCX .GE. 0, else LX = 1+(1-N)*INCX, and LY is",
     "defined in a similar way using INCY."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "        number of elements in input vector(s)"],
     "SX"=>
      ["[in]",
       "         SX is REAL array, dimension(N)",
       "        single precision vector with N elements"],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         storage spacing between elements of SX"],
     "SY"=>
      ["[in]",
       "         SY is REAL array, dimension(N)",
       "        single precision vector with N elements"],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "        storage spacing between elements of SY",
       "         DSDOT is DOUBLE PRECISION",
       "        DSDOT  double precision dot product (zero if N.LE.0)"]}},
 "stbsv"=>
  {"summary"=>
    ["STBSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular band matrix, with ( k + 1 )",
     "diagonals.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**T*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zdotc"=>
  {"summary"=>
    ["ZDOTC forms the dot product of two complex vectors",
     "     ZDOTC = X^H * Y"],
   "param"=>nil},
 "stpsv"=>
  {"summary"=>
    ["STPSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix, supplied in packed form.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**T*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is REAL array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zgbmv"=>
  {"summary"=>
    ["ZGBMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,   or",
     "   y := alpha*A**H*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n band matrix, with kl sub-diagonals and ku super-diagonals."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**H*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "          On entry, KL specifies the number of sub-diagonals of the",
       "          matrix A. KL must satisfy  0 .le. KL."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "          On entry, KU specifies the number of super-diagonals of the",
       "          matrix A. KU must satisfy  0 .le. KU."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading ( kl + ku + 1 ) by n part of the",
       "          array A must contain the matrix of coefficients, supplied",
       "          column by column, with the leading diagonal of the matrix in",
       "          row ( ku + 1 ) of the array, the first super-diagonal",
       "          starting at position 2 in row ku, the first sub-diagonal",
       "          starting at position 1 in row ( ku + 2 ), and so on.",
       "          Elements in the array A that do not correspond to elements",
       "          in the band matrix (such as the top left ku by ku triangle)",
       "          are not referenced.",
       "          The following program segment will transfer a band matrix",
       "          from conventional full matrix storage to band storage:",
       "                DO 20, J = 1, N",
       "                   K = KU + 1 - J",
       "                   DO 10, I = MAX( 1, J - KU ), MIN( M, J + KL )",
       "                      A( K + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( kl + ku + 1 )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry, the incremented array Y must contain the",
       "          vector y. On exit, Y is overwritten by the updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "zhpr"=>
  {"summary"=>
    ["ZHPR    performs the hermitian rank 1 operation",
     "   A := alpha*x*x**H + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n hermitian matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX*16 array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."]}},
 "dsyr2"=>
  {"summary"=>
    ["DSYR2  performs the symmetric rank 2 operation",
     "   A := alpha*x*y**T + alpha*y*x**T + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an n",
     "by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "zherk"=>
  {"summary"=>
    ["ZHERK  performs one of the hermitian rank k operations",
     "   C := alpha*A*A**H + beta*C,",
     "or",
     "   C := alpha*A**H*A + beta*C,",
     "where  alpha and beta  are  real scalars,  C is an  n by n  hermitian",
     "matrix and  A  is an  n by k  matrix in the  first case and a  k by n",
     "matrix in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*A**H + beta*C.",
       "             TRANS = 'C' or 'c'   C := alpha*A**H*A + beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns   of  the   matrix   A,   and  on   entry   with",
       "          TRANS = 'C' or 'c',  K  specifies  the number of rows of the",
       "          matrix A.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION .",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  hermitian matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set,  they are assumed to be zero,  and on exit they",
       "          are set to zero."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "dspr"=>
  {"summary"=>
    ["DSPR    performs the symmetric rank 1 operation",
     "   A := alpha*x*x**T + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n symmetric matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix."]}},
 "chpmv"=>
  {"summary"=>
    ["CHPMV  performs the matrix-vector operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n hermitian matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set and are assumed to be zero."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "dtbmv"=>
  {"summary"=>
    ["DTBMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular band matrix, with ( k + 1 ) diagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**T*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with UPLO = 'U' or 'u', K specifies the number of",
       "          super-diagonals of the matrix A.",
       "          On entry with UPLO = 'L' or 'l', K specifies the number of",
       "          sub-diagonals of the matrix A.",
       "          K must satisfy  0 .le. K."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry with UPLO = 'U' or 'u', the leading ( k + 1 )",
       "          by n part of the array A must contain the upper triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row",
       "          ( k + 1 ) of the array, the first super-diagonal starting at",
       "          position 2 in row k, and so on. The top left k by k triangle",
       "          of the array A is not referenced.",
       "          The following program segment will transfer an upper",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = K + 1 - J",
       "                   DO 10, I = MAX( 1, J - K ), J",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Before entry with UPLO = 'L' or 'l', the leading ( k + 1 )",
       "          by n part of the array A must contain the lower triangular",
       "          band part of the matrix of coefficients, supplied column by",
       "          column, with the leading diagonal of the matrix in row 1 of",
       "          the array, the first sub-diagonal starting at position 1 in",
       "          row 2, and so on. The bottom right k by k triangle of the",
       "          array A is not referenced.",
       "          The following program segment will transfer a lower",
       "          triangular band matrix from conventional full matrix storage",
       "          to band storage:",
       "                DO 20, J = 1, N",
       "                   M = 1 - J",
       "                   DO 10, I = J, MIN( N, J + K )",
       "                      A( M + I, J ) = matrix( I, J )",
       "             10    CONTINUE",
       "             20 CONTINUE",
       "          Note that when DIAG = 'U' or 'u' the elements of the array A",
       "          corresponding to the diagonal elements of the matrix are not",
       "          referenced, but are assumed to be unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          ( k + 1 )."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "dspmv"=>
  {"summary"=>
    ["DSPMV  performs the matrix-vector operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "AP"=>
      ["[in]",
       "         AP is DOUBLE PRECISION array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "dnrm2"=>
  {"summary"=>
    ["DNRM2 returns the euclidean norm of a vector via the function",
     "name, so that",
     "   DNRM2 := sqrt( x'*x )"],
   "param"=>nil},
 "drotg"=>
  {"summary"=>["   DROTG construct givens plane rotation."], "param"=>nil},
 "drot"=>{"summary"=>["   DROT applies a plane rotation."], "param"=>nil},
 "cswap"=>{"summary"=>["  CSWAP interchanges two vectors."], "param"=>nil},
 "srot"=>{"summary"=>["   applies a plane rotation."], "param"=>nil},
 "ssyr2k"=>
  {"summary"=>
    ["SSYR2K  performs one of the symmetric rank 2k operations",
     "   C := alpha*A*B**T + alpha*B*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*B + alpha*B**T*A + beta*C,",
     "where  alpha and beta  are scalars, C is an  n by n  symmetric matrix",
     "and  A and B  are  n by k  matrices  in the  first  case  and  k by n",
     "matrices in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*B**T + alpha*B*A**T +",
       "                                       beta*C.",
       "             TRANS = 'T' or 't'   C := alpha*A**T*B + alpha*B**T*A +",
       "                                       beta*C.",
       "             TRANS = 'C' or 'c'   C := alpha*A**T*B + alpha*B**T*A +",
       "                                       beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns  of the  matrices  A and B,  and on  entry  with",
       "          TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number",
       "          of rows of the matrices  A and B.  K must be at least  zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is REAL array of DIMENSION ( LDB, kb ), where kb is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  k by n  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDB must be at least  max( 1, n ), otherwise  LDB must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is REAL array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "dgemv"=>
  {"summary"=>
    ["DGEMV  performs one of the matrix-vector operations",
     "   y := alpha*A*x + beta*y,   or   y := alpha*A**T*x + beta*y,",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n matrix."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.",
       "             TRANS = 'T' or 't'   y := alpha*A**T*x + beta*y.",
       "             TRANS = 'C' or 'c'   y := alpha*A**T*x + beta*y."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array of DIMENSION at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array of DIMENSION at least",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry with BETA non-zero, the incremented array Y",
       "          must contain the vector y. On exit, Y is overwritten by the",
       "          updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "drotmg"=>
  {"summary"=>
    ["   CONSTRUCT THE MODIFIED GIVENS TRANSFORMATION MATRIX H WHICH ZEROS",
     "   THE SECOND COMPONENT OF THE 2-VECTOR  (DSQRT(DD1)*DX1,DSQRT(DD2)*>    DY2)**T.",
     "   WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..",
     "   DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0",
     "     (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)",
     "   H=(          )    (          )    (          )    (          )",
     "     (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).",
     "   LOCATIONS 2-4 OF DPARAM CONTAIN DH11, DH21, DH12, AND DH22",
     "   RESPECTIVELY. (VALUES OF 1.D0, -1.D0, OR 0.D0 IMPLIED BY THE",
     "   VALUE OF DPARAM(1) ARE NOT STORED IN DPARAM.)",
     "   THE VALUES OF GAMSQ AND RGAMSQ SET IN THE DATA STATEMENT MAY BE",
     "   INEXACT.  THIS IS OK AS THEY ARE ONLY USED FOR TESTING THE SIZE",
     "   OF DD1 AND DD2.  ALL ACTUAL SCALING OF DATA IS DONE USING GAM."],
   "param"=>
    {"DD1"=>["[in,out]", "         DD1 is DOUBLE PRECISION"],
     "DD2"=>["[in,out]", "         DD2 is DOUBLE PRECISION"],
     "DX1"=>["[in,out]", "         DX1 is DOUBLE PRECISION"],
     "DY1"=>["[in]", "         DY1 is DOUBLE PRECISION"],
     "DPARAM"=>
      ["[in,out]",
       "         DPARAM is DOUBLE PRECISION array, dimension 5",
       "    DPARAM(1)=DFLAG",
       "    DPARAM(2)=DH11",
       "    DPARAM(3)=DH21",
       "    DPARAM(4)=DH12",
       "    DPARAM(5)=DH22"]}},
 "isamax"=>
  {"summary"=>
    ["   ISAMAX finds the index of the first element having maximum absolute value."],
   "param"=>nil},
 "zher"=>
  {"summary"=>
    ["ZHER   performs the hermitian rank 1 operation",
     "   A := alpha*x*x**H + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n hermitian matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the hermitian matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the hermitian matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "dsyrk"=>
  {"summary"=>
    ["DSYRK  performs one of the symmetric rank k operations",
     "   C := alpha*A*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*A + beta*C,",
     "where  alpha and beta  are scalars, C is an  n by n  symmetric matrix",
     "and  A  is an  n by k  matrix in the first case and a  k by n  matrix",
     "in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   C := alpha*A*A**T + beta*C.",
       "             TRANS = 'T' or 't'   C := alpha*A**T*A + beta*C.",
       "             TRANS = 'C' or 'c'   C := alpha*A**T*A + beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns   of  the   matrix   A,   and  on   entry   with",
       "          TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number",
       "          of rows of the matrix  A.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "scnrm2"=>
  {"summary"=>
    ["SCNRM2 returns the euclidean norm of a vector via the function",
     "name, so that",
     "   SCNRM2 := sqrt( x**H*x )"],
   "param"=>nil},
 "ztrsm"=>
  {"summary"=>
    ["ZTRSM  solves one of the matrix equations",
     "   op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,",
     "where alpha is a scalar, X and B are m by n matrices, A is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T   or   op( A ) = A**H.",
     "The matrix X is overwritten on B."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry, SIDE specifies whether op( A ) appears on the left",
       "          or right of X as follows:",
       "             SIDE = 'L' or 'l'   op( A )*X = alpha*B.",
       "             SIDE = 'R' or 'r'   X*op( A ) = alpha*B."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**H."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, k ),",
       "          where k is m when SIDE = 'L' or 'l'",
       "            and k is n when SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain  the  right-hand  side  matrix  B,  and  on exit  is",
       "          overwritten by the solution matrix  X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}},
 "dswap"=>
  {"summary"=>
    ["   interchanges two vectors.",
     "   uses unrolled loops for increments equal one."],
   "param"=>nil},
 "zgeru"=>
  {"summary"=>
    ["ZGERU  performs the rank 1 operation",
     "   A := alpha*x*y**T + A,",
     "where alpha is a scalar, x is an m element vector, y is an n element",
     "vector and A is an m by n matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the m",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients. On exit, A is",
       "          overwritten by the updated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, m )."]}},
 "dscal"=>
  {"summary"=>
    ["   DSCAL scales a vector by a constant.",
     "   uses unrolled loops for increment equal to one."],
   "param"=>nil},
 "csscal"=>
  {"summary"=>["   CSSCAL scales a complex vector by a real constant."],
   "param"=>nil},
 "saxpy"=>
  {"summary"=>
    ["   SAXPY constant times a vector plus a vector.",
     "   uses unrolled loops for increments equal to one."],
   "param"=>nil},
 "ssymm"=>
  {"summary"=>
    ["SSYMM  performs one of the matrix-matrix operations",
     "   C := alpha*A*B + beta*C,",
     "or",
     "   C := alpha*B*A + beta*C,",
     "where alpha and beta are scalars,  A is a symmetric matrix and  B and",
     "C are  m by n matrices."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE  specifies whether  the  symmetric matrix  A",
       "          appears on the  left or right  in the  operation as follows:",
       "             SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,",
       "             SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of  the  symmetric  matrix   A  is  to  be",
       "          referenced as follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of the",
       "                                 symmetric matrix is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of the",
       "                                 symmetric matrix is to be referenced."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies the number of rows of the matrix  C.",
       "          M  must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix C.",
       "          N  must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, ka ), where ka is",
       "          m  when  SIDE = 'L' or 'l'  and is  n otherwise.",
       "          Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading m by m upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  m by m  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading n by n upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  n by n  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least  max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is REAL array of DIMENSION ( LDB, n ).",
       "          Before entry, the leading  m by n part of the array  B  must",
       "          contain the matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is REAL array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n updated",
       "          matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "ctpmv"=>
  {"summary"=>
    ["CTPMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,   or   x := A**H*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**H*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "ztpsv"=>
  {"summary"=>
    ["ZTPSV  solves one of the systems of equations",
     "   A*x = b,   or   A**T*x = b,   or   A**H*x = b,",
     "where b and x are n element vectors and A is an n by n unit, or",
     "non-unit, upper or lower triangular matrix, supplied in packed form.",
     "No test for singularity or near-singularity is included in this",
     "routine. Such tests must be performed before calling this routine."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the equations to be solved as",
       "          follows:",
       "             TRANS = 'N' or 'n'   A*x = b.",
       "             TRANS = 'T' or 't'   A**T*x = b.",
       "             TRANS = 'C' or 'c'   A**H*x = b."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX*16 array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element right-hand side vector b. On exit, X is overwritten",
       "          with the solution vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "chemv"=>
  {"summary"=>
    ["CHEMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n hermitian matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the hermitian matrix and the strictly",
       "          lower triangular part of A is not referenced.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the hermitian matrix and the strictly",
       "          upper triangular part of A is not referenced.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set and are assumed to be zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."]}},
 "chpr"=>
  {"summary"=>
    ["CHPR    performs the hermitian rank 1 operation",
     "   A := alpha*x*x**H + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n hermitian matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."]}},
 "stpmv"=>
  {"summary"=>
    ["STPMV  performs one of the matrix-vector operations",
     "   x := A*x,   or   x := A**T*x,",
     "where x is an n element vector and  A is an n by n unit, or non-unit,",
     "upper or lower triangular matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'   x := A*x.",
       "             TRANS = 'T' or 't'   x := A**T*x.",
       "             TRANS = 'C' or 'c'   x := A**T*x."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit",
       "          triangular as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "AP"=>
      ["[in]",
       "         AP is REAL array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 1, 2 ) and a( 2, 2 )",
       "          respectively, and so on.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular matrix packed sequentially,",
       "          column by column, so that AP( 1 ) contains a( 1, 1 ),",
       "          AP( 2 ) and AP( 3 ) contain a( 2, 1 ) and a( 3, 1 )",
       "          respectively, and so on.",
       "          Note that when  DIAG = 'U' or 'u', the diagonal elements of",
       "          A are not referenced, but are assumed to be unity."],
     "X"=>
      ["[in,out]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x. On exit, X is overwritten with the",
       "          transformed vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."]}},
 "zswap"=>{"summary"=>["   ZSWAP interchanges two vectors."], "param"=>nil},
 "sspr"=>
  {"summary"=>
    ["SSPR    performs the symmetric rank 1 operation",
     "   A := alpha*x*x**T + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n symmetric matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is REAL array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is REAL array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the symmetric matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix."]}},
 "dsymm"=>
  {"summary"=>
    ["DSYMM  performs one of the matrix-matrix operations",
     "   C := alpha*A*B + beta*C,",
     "or",
     "   C := alpha*B*A + beta*C,",
     "where alpha and beta are scalars,  A is a symmetric matrix and  B and",
     "C are  m by n matrices."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry,  SIDE  specifies whether  the  symmetric matrix  A",
       "          appears on the  left or right  in the  operation as follows:",
       "             SIDE = 'L' or 'l'   C := alpha*A*B + beta*C,",
       "             SIDE = 'R' or 'r'   C := alpha*B*A + beta*C,"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of  the  symmetric  matrix   A  is  to  be",
       "          referenced as follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of the",
       "                                 symmetric matrix is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of the",
       "                                 symmetric matrix is to be referenced."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry,  M  specifies the number of rows of the matrix  C.",
       "          M  must be at least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix C.",
       "          N  must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION.",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is",
       "          m  when  SIDE = 'L' or 'l'  and is  n otherwise.",
       "          Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading m by m upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  m by m  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced.",
       "          Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of",
       "          the array  A  must contain the  symmetric matrix,  such that",
       "          when  UPLO = 'U' or 'u', the leading n by n upper triangular",
       "          part of the array  A  must contain the upper triangular part",
       "          of the  symmetric matrix and the  strictly  lower triangular",
       "          part of  A  is not referenced,  and when  UPLO = 'L' or 'l',",
       "          the leading  n by n  lower triangular part  of the  array  A",
       "          must  contain  the  lower triangular part  of the  symmetric",
       "          matrix and the  strictly upper triangular part of  A  is not",
       "          referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA must be at least  max( 1, m ), otherwise  LDA must be at",
       "          least  max( 1, n )."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array of DIMENSION ( LDB, n ).",
       "          Before entry, the leading  m by n part of the array  B  must",
       "          contain the matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION.",
       "          On entry,  BETA  specifies the scalar  beta.  When  BETA  is",
       "          supplied as zero then C need not be set on input."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array of DIMENSION ( LDC, n ).",
       "          Before entry, the leading  m by n  part of the array  C must",
       "          contain the matrix  C,  except when  beta  is zero, in which",
       "          case C need not be set on entry.",
       "          On exit, the array  C  is overwritten by the  m by n updated",
       "          matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, m )."]}},
 "dzasum"=>
  {"summary"=>
    ["   DZASUM takes the sum of the (|Re(.)| + |Im(.)|)'s of a complex vector and",
     "   returns a single precision result."],
   "param"=>nil},
 "zsyr2k"=>
  {"summary"=>
    ["ZSYR2K  performs one of the symmetric rank 2k operations",
     "   C := alpha*A*B**T + alpha*B*A**T + beta*C,",
     "or",
     "   C := alpha*A**T*B + alpha*B**T*A + beta*C,",
     "where  alpha and beta  are scalars,  C is an  n by n symmetric matrix",
     "and  A and B  are  n by k  matrices  in the  first  case  and  k by n",
     "matrices in the second case."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On  entry,   UPLO  specifies  whether  the  upper  or  lower",
       "          triangular  part  of the  array  C  is to be  referenced  as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the  upper triangular part of  C",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the  lower triangular part of  C",
       "                                 is to be referenced."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "          On entry,  TRANS  specifies the operation to be performed as",
       "          follows:",
       "             TRANS = 'N' or 'n'    C := alpha*A*B**T + alpha*B*A**T +",
       "                                        beta*C.",
       "             TRANS = 'T' or 't'    C := alpha*A**T*B + alpha*B**T*A +",
       "                                        beta*C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry,  N specifies the order of the matrix C.  N must be",
       "          at least zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "          On entry with  TRANS = 'N' or 'n',  K  specifies  the number",
       "          of  columns  of the  matrices  A and B,  and on  entry  with",
       "          TRANS = 'T' or 't',  K  specifies  the number of rows of the",
       "          matrices  A and B.  K must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array of DIMENSION ( LDA, ka ), where ka is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  A  must contain the matrix  A,  otherwise",
       "          the leading  k by n  part of the array  A  must contain  the",
       "          matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDA must be at least  max( 1, n ), otherwise  LDA must",
       "          be at least  max( 1, k )."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array of DIMENSION ( LDB, kb ), where kb is",
       "          k  when  TRANS = 'N' or 'n',  and is  n  otherwise.",
       "          Before entry with  TRANS = 'N' or 'n',  the  leading  n by k",
       "          part of the array  B  must contain the matrix  B,  otherwise",
       "          the leading  k by n  part of the array  B  must contain  the",
       "          matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n'",
       "          then  LDB must be at least  max( 1, n ), otherwise  LDB must",
       "          be at least  max( 1, k )."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX*16",
       "          On entry, BETA specifies the scalar beta."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array of DIMENSION ( LDC, n ).",
       "          Before entry  with  UPLO = 'U' or 'u',  the leading  n by n",
       "          upper triangular part of the array C must contain the upper",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          lower triangular part of C is not referenced.  On exit, the",
       "          upper triangular part of the array  C is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry  with  UPLO = 'L' or 'l',  the leading  n by n",
       "          lower triangular part of the array C must contain the lower",
       "          triangular part  of the  symmetric matrix  and the strictly",
       "          upper triangular part of C is not referenced.  On exit, the",
       "          lower triangular part of the array  C is overwritten by the",
       "          lower triangular part of the updated matrix."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "          On entry, LDC specifies the first dimension of C as declared",
       "          in  the  calling  (sub)  program.   LDC  must  be  at  least",
       "          max( 1, n )."]}},
 "cher"=>
  {"summary"=>
    ["CHER   performs the hermitian rank 1 operation",
     "   A := alpha*x*x**H + A,",
     "where alpha is a real scalar, x is an n element vector and A is an",
     "n by n hermitian matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array of DIMENSION ( LDA, n ).",
       "          Before entry with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the hermitian matrix and the strictly",
       "          lower triangular part of A is not referenced. On exit, the",
       "          upper triangular part of the array A is overwritten by the",
       "          upper triangular part of the updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the hermitian matrix and the strictly",
       "          upper triangular part of A is not referenced. On exit, the",
       "          lower triangular part of the array A is overwritten by the",
       "          lower triangular part of the updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n )."]}},
 "zhpr2"=>
  {"summary"=>
    ["ZHPR2  performs the hermitian rank 2 operation",
     "   A := alpha*x*y**H + conjg( alpha )*y*x**H + A,",
     "where alpha is a scalar, x and y are n element vectors and A is an",
     "n by n hermitian matrix, supplied in packed form."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the matrix A is supplied in the packed",
       "          array AP as follows:",
       "             UPLO = 'U' or 'u'   The upper triangular part of A is",
       "                                 supplied in AP.",
       "             UPLO = 'L' or 'l'   The lower triangular part of A is",
       "                                 supplied in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX*16",
       "          On entry, ALPHA specifies the scalar alpha."],
     "X"=>
      ["[in]",
       "         X is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the n",
       "          element vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero."],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX*16 array of dimension at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX*16 array of DIMENSION at least",
       "          ( ( n*( n + 1 ) )/2 ).",
       "          Before entry with  UPLO = 'U' or 'u', the array AP must",
       "          contain the upper triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 1, 2 )",
       "          and a( 2, 2 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the upper triangular part of the",
       "          updated matrix.",
       "          Before entry with UPLO = 'L' or 'l', the array AP must",
       "          contain the lower triangular part of the hermitian matrix",
       "          packed sequentially, column by column, so that AP( 1 )",
       "          contains a( 1, 1 ), AP( 2 ) and AP( 3 ) contain a( 2, 1 )",
       "          and a( 3, 1 ) respectively, and so on. On exit, the array",
       "          AP is overwritten by the lower triangular part of the",
       "          updated matrix.",
       "          Note that the imaginary parts of the diagonal elements need",
       "          not be set, they are assumed to be zero, and on exit they",
       "          are set to zero."]}},
 "cdotc"=>
  {"summary"=>
    ["CDOTC forms the dot product of two complex vectors",
     "     CDOTC = X^H * Y"],
   "param"=>nil},
 "strsm"=>
  {"summary"=>
    ["STRSM  solves one of the matrix equations",
     "   op( A )*X = alpha*B,   or   X*op( A ) = alpha*B,",
     "where alpha is a scalar, X and B are m by n matrices, A is a unit, or",
     "non-unit,  upper or lower triangular matrix  and  op( A )  is one  of",
     "   op( A ) = A   or   op( A ) = A**T.",
     "The matrix X is overwritten on B."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "          On entry, SIDE specifies whether op( A ) appears on the left",
       "          or right of X as follows:",
       "             SIDE = 'L' or 'l'   op( A )*X = alpha*B.",
       "             SIDE = 'R' or 'r'   X*op( A ) = alpha*B."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the matrix A is an upper or",
       "          lower triangular matrix as follows:",
       "             UPLO = 'U' or 'u'   A is an upper triangular matrix.",
       "             UPLO = 'L' or 'l'   A is a lower triangular matrix."],
     "TRANSA"=>
      ["[in]",
       "         TRANSA is CHARACTER*1",
       "          On entry, TRANSA specifies the form of op( A ) to be used in",
       "          the matrix multiplication as follows:",
       "             TRANSA = 'N' or 'n'   op( A ) = A.",
       "             TRANSA = 'T' or 't'   op( A ) = A**T.",
       "             TRANSA = 'C' or 'c'   op( A ) = A**T."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "          On entry, DIAG specifies whether or not A is unit triangular",
       "          as follows:",
       "             DIAG = 'U' or 'u'   A is assumed to be unit triangular.",
       "             DIAG = 'N' or 'n'   A is not assumed to be unit",
       "                                 triangular."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of B. M must be at",
       "          least zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of B.  N must be",
       "          at least zero."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry,  ALPHA specifies the scalar  alpha. When  alpha is",
       "          zero then  A is not referenced and  B need not be set before",
       "          entry."],
     "A"=>
      ["[in]",
       "         A is REAL array of DIMENSION ( LDA, k ),",
       "          where k is m when SIDE = 'L' or 'l'",
       "            and k is n when SIDE = 'R' or 'r'.",
       "          Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k",
       "          upper triangular part of the array  A must contain the upper",
       "          triangular matrix  and the strictly lower triangular part of",
       "          A is not referenced.",
       "          Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k",
       "          lower triangular part of the array  A must contain the lower",
       "          triangular matrix  and the strictly upper triangular part of",
       "          A is not referenced.",
       "          Note that when  DIAG = 'U' or 'u',  the diagonal elements of",
       "          A  are not referenced either,  but are assumed to be  unity."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program.  When  SIDE = 'L' or 'l'  then",
       "          LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r'",
       "          then LDA must be at least max( 1, n )."],
     "B"=>
      ["[in,out]",
       "         B is REAL array of DIMENSION ( LDB, n ).",
       "          Before entry,  the leading  m by n part of the array  B must",
       "          contain  the  right-hand  side  matrix  B,  and  on exit  is",
       "          overwritten by the solution matrix  X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "          On entry, LDB specifies the first dimension of B as declared",
       "          in  the  calling  (sub)  program.   LDB  must  be  at  least",
       "          max( 1, m )."]}}}
