import itertools
import re
import zipfile
from _typeshed import FileDescriptorOrPath, Incomplete, ReadableBuffer, SizedBuffer, Unused
from collections.abc import Generator
from typing import ClassVar, Final, Literal
from xml.etree import ElementTree

from docutils import nodes, writers
from docutils.frontend import Values
from docutils.languages import _LanguageModule
from docutils.readers import standalone

__docformat__: Final = "reStructuredText"
VERSION: Final[str]
IMAGE_NAME_COUNTER: Final[itertools.count[int]]

class _ElementInterfaceWrapper(ElementTree.Element):
    def __init__(self, tag: str, attrib: dict[str, str] | None = None) -> None: ...
    def setparent(self, parent) -> None: ...
    def getparent(self): ...

SPACES_PATTERN: Final[re.Pattern[str]]
TABS_PATTERN: Final[re.Pattern[str]]
FILL_PAT1: Final[re.Pattern[str]]
FILL_PAT2: Final[re.Pattern[str]]
TABLESTYLEPREFIX: Final[str]
TABLENAMEDEFAULT: Final[str]
TABLEPROPERTYNAMES: Final[tuple[str, ...]]
GENERATOR_DESC: Final[str]
NAME_SPACE_1: Final[str]
CONTENT_NAMESPACE_DICT: Final[dict[str, str]]
CNSD: Final[dict[str, str]]
STYLES_NAMESPACE_DICT: Final[dict[str, str]]
SNSD: Final[dict[str, str]]
MANIFEST_NAMESPACE_DICT: Final[dict[str, str]]
MANNSD: Final[dict[str, str]]
META_NAMESPACE_DICT: Final[dict[str, str]]
METNSD: Final[dict[str, str]]
CONTENT_NAMESPACE_ATTRIB: Final[dict[str, str]]
STYLES_NAMESPACE_ATTRIB: Final[dict[str, str]]
MANIFEST_NAMESPACE_ATTRIB: Final[dict[str, str]]
META_NAMESPACE_ATTRIB: Final[dict[str, str]]

def Element(
    tag: str, attrib: dict[str, str] | None = None, nsmap: Unused = None, nsdict: Unused = ...
) -> _ElementInterfaceWrapper: ...
def SubElement(
    parent: _ElementInterfaceWrapper, tag: str, attrib: dict[str, str] | None = None, nsmap: Unused = None, nsdict: Unused = ...
) -> _ElementInterfaceWrapper: ...
def fix_ns(tag: str, attrib: dict[str, str], nsdict: Unused) -> tuple[str, dict[str, str]]: ...
def add_ns(tag: str, nsdict: Unused = ...) -> str: ...
def ToString(et: ElementTree.ElementTree) -> str: ...
def escape_cdata(text: str) -> str: ...

class TableStyle:
    border: str | None
    backgroundcolor: str | None
    def __init__(self, border: str | None = None, backgroundcolor: str | None = None) -> None: ...
    def get_border_(self): ...
    def set_border_(self, border) -> None: ...
    border_: Incomplete
    def get_backgroundcolor_(self): ...
    def set_backgroundcolor_(self, backgroundcolor) -> None: ...
    backgroundcolor_: Incomplete

BUILTIN_DEFAULT_TABLE_STYLE: TableStyle

class ListLevel:
    level: int
    sibling_level: bool
    nested_level: bool
    def __init__(self, level: int, sibling_level: bool = True, nested_level: bool = True) -> None: ...
    def get_sibling(self) -> bool: ...
    def set_sibling(self, sibling_level: bool) -> None: ...
    def get_nested(self) -> bool: ...
    def set_nested(self, nested_level: bool) -> None: ...
    def get_level(self) -> int: ...
    def set_level(self, level: int) -> None: ...

class Writer(writers.Writer[bytes]):
    MIME_TYPE: ClassVar[str]
    EXTENSION: ClassVar[str]
    default_stylesheet: ClassVar[str]
    default_stylesheet_path: ClassVar[str]
    default_template: ClassVar[str]
    default_template_path: ClassVar[str]
    translator_class: type[ODFTranslator]
    settings: Values
    visitor: ODFTranslator
    def assemble_my_parts(self) -> None: ...
    def update_stylesheet(self, stylesheet_root, language_code: str | None, region_code: str | None): ...
    def write_zip_str(self, zfile: zipfile.ZipFile, name: str, bytes: str | SizedBuffer, compress_type: int = 8) -> None: ...
    def store_embedded_files(self, zfile: zipfile.ZipFile) -> None: ...
    def get_settings(self) -> bytes: ...
    def get_stylesheet(self) -> bytes: ...
    def copy_from_stylesheet(self, outzipfile: zipfile.ZipFile) -> None: ...
    def assemble_parts(self) -> None: ...
    def create_manifest(self) -> str: ...
    def create_meta(self) -> str: ...

class ODFTranslator(nodes.GenericNodeVisitor):
    used_styles: ClassVar[tuple[str, ...]]
    settings: Values
    language_code: str
    language: _LanguageModule
    format_map: dict[str, str]
    section_level: int
    section_count: int
    content_tree: ElementTree.ElementTree
    current_element: _ElementInterfaceWrapper
    automatic_styles: _ElementInterfaceWrapper
    body_text_element: _ElementInterfaceWrapper
    paragraph_style_stack: list[str]
    list_style_stack: list[str]
    table_count: int
    column_count: int
    trace_level: int
    optiontablestyles_generated: bool
    field_name: Incomplete
    field_element: Incomplete
    title: str | None
    image_count: int
    image_style_count: int
    image_dict: dict[str, tuple[str, str]]
    embedded_file_list: list[Incomplete]
    syntaxhighlighting: int
    syntaxhighlight_lexer: str
    header_content: list[Incomplete]
    footer_content: list[Incomplete]
    in_header: bool
    in_footer: bool
    blockstyle: str
    in_table_of_contents: bool
    table_of_content_index_body: _ElementInterfaceWrapper | None
    list_level: int
    def_list_level: int
    footnote_ref_dict: dict[Incomplete, _ElementInterfaceWrapper]
    footnote_list: list[tuple[Incomplete, Incomplete]]
    footnote_chars_idx: int
    footnote_level: int
    pending_ids: Incomplete
    in_paragraph: bool
    found_doc_title: bool
    bumped_list_level_stack: list[ListLevel]
    meta_dict: dict[Incomplete, Incomplete]
    line_block_level: int
    line_indent_level: int
    citation_id: Incomplete
    style_index: int
    str_stylesheet: str | bytes
    str_stylesheetcontent: str | bytes | None
    dom_stylesheet: ElementTree.Element | None
    table_styles: dict[str, TableStyle] | None
    in_citation: bool
    inline_style_count_stack: list[int]
    def get_str_stylesheet(self) -> str | bytes: ...
    dom_stylesheetcontent: ElementTree.Element
    def retrieve_styles(self, extension: str) -> None: ...
    def extract_table_styles(self, styles_str: str | ReadableBuffer) -> dict[str, TableStyle]: ...
    def get_property(self, stylenode: ElementTree.Element) -> str | None: ...
    def add_doc_title(self) -> None: ...
    def find_first_text_p(self, el: _ElementInterfaceWrapper) -> _ElementInterfaceWrapper | None: ...
    def attach_page_style(self, el: _ElementInterfaceWrapper) -> None: ...
    def rststyle(self, name: str, parameters: tuple[object, ...] = ()) -> str: ...
    def generate_content_element(self, root: _ElementInterfaceWrapper) -> _ElementInterfaceWrapper: ...
    def setup_page(self): ...
    def get_dom_stylesheet(self) -> ElementTree.Element | None: ...
    def setup_paper(self, root_el) -> None: ...
    def add_header_footer(self, root_el) -> None: ...
    code_none: int
    code_field: int
    code_text: int
    field_pat: re.Pattern[str]
    def create_custom_headfoot(self, parent: _ElementInterfaceWrapper, text: str, style_name, automatic_styles) -> None: ...
    def make_field_element(
        self, parent: _ElementInterfaceWrapper, text: str, style_name, automatic_styles
    ) -> _ElementInterfaceWrapper | None: ...
    def split_field_specifiers_iter(self, text: str) -> Generator[tuple[int, str]]: ...
    def astext(self) -> str: ...
    def content_astext(self) -> str: ...
    def set_title(self, title: str) -> None: ...
    def get_title(self) -> str | None: ...
    def set_embedded_file_list(self, embedded_file_list) -> None: ...
    def get_embedded_file_list(self): ...
    def get_meta_dict(self): ...
    def process_footnotes(self) -> None: ...
    def append_child(
        self, tag: str, attrib: dict[str, str] | None = None, parent: _ElementInterfaceWrapper | None = None
    ) -> _ElementInterfaceWrapper: ...
    def append_p(self, style: str, text: str | None = None) -> _ElementInterfaceWrapper: ...
    def append_pending_ids(self, el: _ElementInterfaceWrapper) -> None: ...
    def set_current_element(self, el: _ElementInterfaceWrapper) -> None: ...
    def set_to_parent(self) -> None: ...
    def generate_labeled_block(self, node: nodes.Node, label: str) -> _ElementInterfaceWrapper: ...
    def generate_labeled_line(self, node: nodes.Node, label: str) -> _ElementInterfaceWrapper: ...
    def encode(self, text: str) -> str: ...
    def dispatch_visit(self, node: nodes.Element) -> None: ...  # type: ignore[override]
    def handle_basic_atts(self, node: nodes.Element) -> None: ...
    def default_visit(self, node: nodes.Element) -> None: ...  # type: ignore[override]
    def default_departure(self, node: nodes.Element) -> None: ...  # type: ignore[override]
    def visit_Text(self, node: nodes.Text) -> None: ...
    def depart_Text(self, node: nodes.Text) -> None: ...
    def visit_address(self, node: nodes.address) -> None: ...
    def depart_address(self, node: nodes.address) -> None: ...
    def visit_author(self, node: nodes.author) -> None: ...
    def depart_author(self, node: nodes.author) -> None: ...
    def visit_authors(self, node: nodes.authors) -> None: ...
    def depart_authors(self, node: nodes.authors) -> None: ...
    def visit_contact(self, node: nodes.contact) -> None: ...
    def depart_contact(self, node: nodes.contact) -> None: ...
    def visit_copyright(self, node: nodes.copyright) -> None: ...
    def depart_copyright(self, node: nodes.copyright) -> None: ...
    def visit_date(self, node: nodes.date) -> None: ...
    def depart_date(self, node: nodes.date) -> None: ...
    def visit_organization(self, node: nodes.organization) -> None: ...
    def depart_organization(self, node: nodes.organization) -> None: ...
    def visit_status(self, node: nodes.status) -> None: ...
    def depart_status(self, node: nodes.status) -> None: ...
    def visit_revision(self, node: nodes.revision) -> None: ...
    def depart_revision(self, node: nodes.revision) -> None: ...
    def visit_version(self, node: nodes.version) -> None: ...
    def depart_version(self, node: nodes.version) -> None: ...
    def visit_attribution(self, node: nodes.attribution) -> None: ...
    def depart_attribution(self, node: nodes.attribution) -> None: ...
    def visit_block_quote(self, node: nodes.block_quote) -> None: ...
    def depart_block_quote(self, node: nodes.block_quote) -> None: ...
    def visit_bullet_list(self, node: nodes.bullet_list) -> None: ...
    def depart_bullet_list(self, node: nodes.bullet_list) -> None: ...
    def visit_caption(self, node: nodes.caption) -> None: ...
    def depart_caption(self, node: nodes.caption) -> None: ...
    def visit_comment(self, node: nodes.comment) -> None: ...
    def depart_comment(self, node: nodes.comment) -> None: ...
    def visit_compound(self, node: nodes.compound) -> None: ...
    def depart_compound(self, node: nodes.compound) -> None: ...
    def visit_container(self, node: nodes.container) -> None: ...
    def depart_container(self, node: nodes.container) -> None: ...
    def visit_decoration(self, node: nodes.decoration) -> None: ...
    def depart_decoration(self, node: nodes.decoration) -> None: ...
    def visit_definition_list(self, node: nodes.definition_list) -> None: ...
    def depart_definition_list(self, node: nodes.definition_list) -> None: ...
    def visit_definition_list_item(self, node: nodes.definition_list_item) -> None: ...
    def depart_definition_list_item(self, node: nodes.definition_list_item) -> None: ...
    def visit_term(self, node: nodes.term) -> None: ...
    def depart_term(self, node: nodes.term) -> None: ...
    def visit_definition(self, node: nodes.definition) -> None: ...
    def depart_definition(self, node: nodes.definition) -> None: ...
    def visit_classifier(self, node: nodes.classifier) -> None: ...
    def depart_classifier(self, node: nodes.classifier) -> None: ...
    def visit_document(self, node: nodes.document) -> None: ...
    def depart_document(self, node: nodes.document) -> None: ...
    def visit_docinfo(self, node: nodes.docinfo) -> None: ...
    def depart_docinfo(self, node: nodes.docinfo) -> None: ...
    def visit_emphasis(self, node: nodes.emphasis) -> None: ...
    def depart_emphasis(self, node: nodes.emphasis) -> None: ...
    def visit_enumerated_list(self, node: nodes.enumerated_list) -> None: ...
    def depart_enumerated_list(self, node: nodes.enumerated_list) -> None: ...
    def visit_list_item(self, node: nodes.list_item) -> None: ...
    def depart_list_item(self, node: nodes.list_item) -> None: ...
    def visit_header(self, node: nodes.header) -> None: ...
    def depart_header(self, node: nodes.header) -> None: ...
    def visit_footer(self, node: nodes.footer) -> None: ...
    def depart_footer(self, node: nodes.footer) -> None: ...
    def visit_field(self, node: nodes.field) -> None: ...
    def depart_field(self, node: nodes.field) -> None: ...
    def visit_field_list(self, node: nodes.field_list) -> None: ...
    def depart_field_list(self, node: nodes.field_list) -> None: ...
    def visit_field_name(self, node: nodes.field_name) -> None: ...
    def depart_field_name(self, node: nodes.field_name) -> None: ...
    def visit_field_body(self, node: nodes.field_body) -> None: ...
    def depart_field_body(self, node: nodes.field_body) -> None: ...
    def visit_figure(self, node: nodes.figure) -> None: ...
    def depart_figure(self, node: nodes.figure) -> None: ...
    save_footnote_current: _ElementInterfaceWrapper
    def visit_footnote(self, node: nodes.footnote) -> None: ...
    def depart_footnote(self, node: nodes.footnote) -> None: ...
    footnote_chars: list[str]
    def visit_footnote_reference(self, node: nodes.footnote_reference) -> None: ...
    def depart_footnote_reference(self, node: nodes.footnote_reference) -> None: ...
    def visit_citation(self, node: nodes.citation) -> None: ...
    def depart_citation(self, node: nodes.citation) -> None: ...
    def visit_citation_reference(self, node: nodes.citation_reference) -> None: ...
    def depart_citation_reference(self, node: nodes.citation_reference) -> None: ...
    def visit_label(self, node: nodes.label) -> None: ...
    def depart_label(self, node: nodes.label) -> None: ...
    def visit_generated(self, node: nodes.generated) -> None: ...
    def depart_generated(self, node: nodes.generated) -> None: ...
    def check_file_exists(self, path: FileDescriptorOrPath) -> Literal[1, 0]: ...
    def visit_image(self, node: nodes.image) -> None: ...
    def depart_image(self, node: nodes.image) -> None: ...
    def get_image_width_height(self, node: nodes.image, attr: str) -> tuple[float | None, Literal["%", "cm"] | None]: ...
    def convert_to_cm(self, size: str) -> tuple[float, Literal["cm"]]: ...
    def get_image_scale(self, node: nodes.image) -> float: ...
    def get_image_scaled_width_height(self, node: nodes.image, source) -> tuple[Incomplete, Incomplete]: ...
    def get_page_width(self) -> float: ...
    def generate_figure(self, node: nodes.image, source, destination, current_element): ...
    def generate_image(
        self, node: nodes.image, source, destination, current_element, frame_attrs: dict[str, str] | None = None
    ): ...
    def is_in_table(self, node: nodes.Node) -> bool: ...
    def visit_legend(self, node: nodes.legend) -> None: ...
    def depart_legend(self, node: nodes.legend) -> None: ...
    def visit_line_block(self, node: nodes.line_block) -> None: ...
    def depart_line_block(self, node: nodes.line_block) -> None: ...
    def visit_line(self, node: nodes.line) -> None: ...
    def depart_line(self, node: nodes.line) -> None: ...
    def visit_literal(self, node: nodes.literal) -> None: ...
    def depart_literal(self, node: nodes.literal) -> None: ...
    def visit_inline(self, node: nodes.inline) -> None: ...
    def depart_inline(self, node: nodes.inline) -> None: ...
    def fill_line(self, line: str) -> str: ...
    def fill_func1(self, matchobj: re.Match[str]) -> str: ...
    def fill_func2(self, matchobj: re.Match[str]) -> str: ...
    def visit_literal_block(self, node: nodes.literal_block) -> None: ...
    def depart_literal_block(self, node: nodes.literal_block) -> None: ...
    def visit_doctest_block(self, node: nodes.doctest_block) -> None: ...
    def depart_doctest_block(self, node: nodes.doctest_block) -> None: ...
    def visit_math(self, node: nodes.math) -> None: ...
    def depart_math(self, node: nodes.math) -> None: ...
    def visit_math_block(self, node: nodes.math_block) -> None: ...
    def depart_math_block(self, node: nodes.math_block) -> None: ...
    def visit_meta(self, node: nodes.meta) -> None: ...
    def depart_meta(self, node: nodes.meta) -> None: ...
    def visit_option_list(self, node: nodes.option_list) -> None: ...
    def depart_option_list(self, node: nodes.option_list) -> None: ...
    def visit_option_list_item(self, node: nodes.option_list_item) -> None: ...
    def depart_option_list_item(self, node: nodes.option_list_item) -> None: ...
    def visit_option_group(self, node: nodes.option_group) -> None: ...
    def depart_option_group(self, node: nodes.option_group) -> None: ...
    def visit_option(self, node: nodes.option) -> None: ...
    def depart_option(self, node: nodes.option) -> None: ...
    def visit_option_string(self, node: nodes.option_string) -> None: ...
    def depart_option_string(self, node: nodes.option_string) -> None: ...
    def visit_option_argument(self, node: nodes.option_argument) -> None: ...
    def depart_option_argument(self, node: nodes.option_argument) -> None: ...
    def visit_description(self, node: nodes.description) -> None: ...
    def depart_description(self, node: nodes.description) -> None: ...
    def visit_paragraph(self, node: nodes.paragraph) -> None: ...
    def depart_paragraph(self, node: nodes.paragraph) -> None: ...
    def visit_problematic(self, node: nodes.problematic) -> None: ...
    def depart_problematic(self, node: nodes.problematic) -> None: ...
    def visit_raw(self, node: nodes.raw) -> None: ...
    def depart_raw(self, node: nodes.raw) -> None: ...
    def visit_reference(self, node: nodes.reference) -> None: ...
    def depart_reference(self, node: nodes.reference) -> None: ...
    def visit_rubric(self, node: nodes.rubric) -> None: ...
    def depart_rubric(self, node: nodes.rubric) -> None: ...
    def visit_section(self, node: nodes.section, move_ids: int = 1) -> None: ...
    def depart_section(self, node: nodes.section) -> None: ...
    def visit_strong(self, node: nodes.strong) -> None: ...
    def depart_strong(self, node: nodes.strong) -> None: ...
    def visit_substitution_definition(self, node: nodes.substitution_definition) -> None: ...
    def depart_substitution_definition(self, node: nodes.substitution_definition) -> None: ...
    def visit_system_message(self, node: nodes.system_message) -> None: ...
    def depart_system_message(self, node: nodes.system_message) -> None: ...
    def get_table_style(self, node) -> TableStyle: ...
    current_table_style: _ElementInterfaceWrapper
    table_width: float
    def visit_table(self, node: nodes.table) -> None: ...
    def depart_table(self, node: nodes.table) -> None: ...
    def visit_tgroup(self, node: nodes.tgroup) -> None: ...
    def depart_tgroup(self, node: nodes.tgroup) -> None: ...
    def visit_colspec(self, node: nodes.colspec) -> None: ...
    def depart_colspec(self, node: nodes.colspec) -> None: ...
    in_thead: bool
    def visit_thead(self, node: nodes.thead) -> None: ...
    def depart_thead(self, node: nodes.thead) -> None: ...
    def visit_row(self, node: nodes.row) -> None: ...
    def depart_row(self, node: nodes.row) -> None: ...
    def visit_entry(self, node: nodes.entry) -> None: ...
    def depart_entry(self, node: nodes.entry) -> None: ...
    def visit_tbody(self, node: nodes.tbody) -> None: ...
    def depart_tbody(self, node: nodes.tbody) -> None: ...
    def visit_target(self, node: nodes.target) -> None: ...
    def depart_target(self, node: nodes.target) -> None: ...
    def visit_title(self, node: nodes.title, move_ids: int = 1, title_type: str = "title") -> None: ...
    def depart_title(self, node: nodes.title) -> None: ...
    def visit_subtitle(self, node: nodes.subtitle, move_ids: int = 1) -> None: ...
    def depart_subtitle(self, node: nodes.subtitle) -> None: ...
    def visit_title_reference(self, node: nodes.title_reference) -> None: ...
    def depart_title_reference(self, node: nodes.title_reference) -> None: ...
    def generate_table_of_content_entry_template(self, el1) -> None: ...
    def find_title_label(self, node, class_type, label_key): ...
    save_current_element: Incomplete
    def visit_topic(self, node: nodes.topic) -> None: ...
    def depart_topic(self, node: nodes.topic) -> None: ...
    def update_toc_page_numbers(self, el) -> None: ...
    def update_toc_collect(self, el, level, collection) -> None: ...
    def update_toc_add_numbers(self, collection) -> None: ...
    def visit_transition(self, node: nodes.transition) -> None: ...
    def depart_transition(self, node: nodes.transition) -> None: ...
    def visit_warning(self, node: nodes.warning) -> None: ...
    def depart_warning(self, node: nodes.warning) -> None: ...
    def visit_attention(self, node: nodes.attention) -> None: ...
    def depart_attention(self, node: nodes.attention) -> None: ...
    def visit_caution(self, node: nodes.caution) -> None: ...
    def depart_caution(self, node: nodes.caution) -> None: ...
    def visit_danger(self, node: nodes.danger) -> None: ...
    def depart_danger(self, node: nodes.danger) -> None: ...
    def visit_error(self, node: nodes.error) -> None: ...
    def depart_error(self, node: nodes.error) -> None: ...
    def visit_hint(self, node: nodes.hint) -> None: ...
    def depart_hint(self, node: nodes.hint) -> None: ...
    def visit_important(self, node: nodes.important) -> None: ...
    def depart_important(self, node: nodes.important) -> None: ...
    def visit_note(self, node: nodes.note) -> None: ...
    def depart_note(self, node: nodes.note) -> None: ...
    def visit_tip(self, node: nodes.tip) -> None: ...
    def depart_tip(self, node: nodes.tip) -> None: ...
    def visit_admonition(self, node: nodes.admonition) -> None: ...
    def depart_admonition(self, node: nodes.admonition) -> None: ...
    def generate_admonition(self, node: nodes.Node, label: str, title: str | None = None) -> None: ...
    def visit_subscript(self, node: nodes.subscript) -> None: ...
    def depart_subscript(self, node: nodes.subscript) -> None: ...
    def visit_superscript(self, node: nodes.superscript) -> None: ...
    def depart_superscript(self, node: nodes.superscript) -> None: ...
    def visit_abbreviation(self, node: nodes.abbreviation) -> None: ...
    def depart_abbreviation(self, node: nodes.abbreviation) -> None: ...
    def visit_acronym(self, node: nodes.acronym) -> None: ...
    def depart_acronym(self, node: nodes.acronym) -> None: ...
    def visit_sidebar(self, node: nodes.sidebar) -> None: ...
    def depart_sidebar(self, node: nodes.sidebar) -> None: ...

class Reader(standalone.Reader[str | bytes]): ...
