/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.7.1/LICENSE.txt
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.maplibregl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var maplibregl = {};
var modules = {};
function define(moduleName, _dependencies, moduleFactory) {
    modules[moduleName] = moduleFactory;

    // to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
    if (moduleName !== 'index') {
        return;
    }

    // we assume that when an index module is initializing then other modules are loaded already
    var workerBundleString = 'var sharedModule = {}; (' + modules.shared + ')(sharedModule); (' + modules.worker + ')(sharedModule);'

    var sharedModule = {};
    // the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
    // to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
    // we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
    modules.shared(sharedModule);
    modules.index(maplibregl, sharedModule);

    if (typeof window !== 'undefined') {
        maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' })));
    }

    return maplibregl;
};



define("shared",["exports"],(function(t){"use strict";function e(t,e,r,n){return new(r||(r=Promise))((function(i,s){function a(t){try{l(n.next(t));}catch(t){s(t);}}function o(t){try{l(n.throw(t));}catch(t){s(t);}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e);}))).then(a,o);}l((n=n.apply(t,e||[])).next());}))}function r(t,e){this.x=t,this.y=e;}function n(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var i,s;"function"==typeof SuppressedError&&SuppressedError,r.prototype={clone(){return new r(this.x,this.y)},add(t){return this.clone()._add(t)},sub(t){return this.clone()._sub(t)},multByPoint(t){return this.clone()._multByPoint(t)},divByPoint(t){return this.clone()._divByPoint(t)},mult(t){return this.clone()._mult(t)},div(t){return this.clone()._div(t)},rotate(t){return this.clone()._rotate(t)},rotateAround(t,e){return this.clone()._rotateAround(t,e)},matMult(t){return this.clone()._matMult(t)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(t){return this.x===t.x&&this.y===t.y},dist(t){return Math.sqrt(this.distSqr(t))},distSqr(t){const e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle(){return Math.atan2(this.y,this.x)},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith(t){return this.angleWithSep(t.x,t.y)},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add(t){return this.x+=t.x,this.y+=t.y,this},_sub(t){return this.x-=t.x,this.y-=t.y,this},_mult(t){return this.x*=t,this.y*=t,this},_div(t){return this.x/=t,this.y/=t,this},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this},_unit(){return this._div(this.mag()),this},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this},_rotate(t){const e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround(t,e){const r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:r},r.convert=function(t){if(t instanceof r)return t;if(Array.isArray(t))return new r(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new r(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format")};var a=function(){if(s)return i;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return s=1,i=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},i}(),o=n(a);let l,u;function c(){return null==l&&(l="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),l}function h(){if(null==u&&(u=!1,c())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1);}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){u=!0;break}}}return u||!1}var p=1e-6,f="undefined"!=typeof Float32Array?Float32Array:Array;function d(){var t=new f(9);return f!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function y(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function m(){var t=new f(3);return f!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function g(t){var e=t[0],r=t[1],n=t[2];return Math.sqrt(e*e+r*r+n*n)}function x(t,e,r){var n=new f(3);return n[0]=t,n[1]=e,n[2]=r,n}function v(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function b(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function w(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t}var _,S=g;function A(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}function k(){var t=new f(4);return f!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function M(t,e,r,n){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",s=Math.PI/360;e*=s,n*=s,r*=s;var a=Math.sin(e),o=Math.cos(e),l=Math.sin(r),u=Math.cos(r),c=Math.sin(n),h=Math.cos(n);switch(i){case "xyz":t[0]=a*u*h+o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h-a*l*c;break;case "xzy":t[0]=a*u*h-o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h+a*l*c;break;case "yxz":t[0]=a*u*h+o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h+a*l*c;break;case "yzx":t[0]=a*u*h+o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h-a*l*c;break;case "zxy":t[0]=a*u*h-o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h-a*l*c;break;case "zyx":t[0]=a*u*h-o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h+a*l*c;break;default:throw new Error("Unknown angle order "+i)}return t}function I(){var t=new f(2);return f!=Float32Array&&(t[0]=0,t[1]=0),t}function z(t,e){var r=new f(2);return r[0]=t,r[1]=e,r}m(),_=new f(4),f!=Float32Array&&(_[0]=0,_[1]=0,_[2]=0,_[3]=0),m(),x(1,0,0),x(0,1,0),k(),k(),d(),I();const P=8192;function C(t,e,r){return e*(P/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}function E(t,e){return (t%e+e)%e}function B(t,e,r){return t*(1-r)+e*r}function V(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function T(t,e,r,n){const i=new o(t,e,r,n);return t=>i.solve(t)}const F=T(.25,.1,.25,1);function L(t,e,r){return Math.min(r,Math.max(e,t))}function $(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function O(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let D=1;function R(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function U(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function j(t){return Array.isArray(t)?t.map(j):"object"==typeof t&&t?R(t,j):t}const N={};function q(t){N[t]||("undefined"!=typeof console&&console.warn(t),N[t]=!0);}function G(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function X(t){return "undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let Z=null;function Y(t){return "undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const H="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function K(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const a=null==e?void 0:e.format;if(!a||!a.startsWith("BGR")&&!a.startsWith("RGB"))throw new Error(`Unrecognized format ${a}`);const o=a.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),a=(Math.max(0,r)-r)*n*4+s,o=4*n,l=Math.max(0,e),u=Math.max(0,r);return {rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:a,stride:o}]}}(t,r,n,i,s)),o)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e;}return l}finally{e.close();}}))}let J,W;function Q(t,e,r,n){return t.addEventListener(e,r,n),{unsubscribe:()=>{t.removeEventListener(e,r,n);}}}function tt(t){return t*Math.PI/180}function et(t){return t/Math.PI*180}const rt={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},nt={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0},it="AbortError";function st(){return new Error(it)}const at={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function ot(t){return at.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const lt="global-dispatcher";class ut extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n;}}const ct=()=>X(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,ht=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=ot(t.url);if(e)return e(t,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:lt},r)}if(!(/^file:/.test(n=t.url)||/^file:/.test(ct())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,(function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:ct(),signal:r.signal});let n,i;"json"!==t.type||e.headers.has("Accept")||e.headers.set("Accept","application/json");try{n=yield fetch(e);}catch(e){throw new ut(0,e.message,t.url,new Blob)}if(!n.ok){const e=yield n.blob();throw new ut(n.status,n.statusText,t.url,e)}i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw st();return {data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(t,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:lt},r)}var n;return function(t,e){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText));},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response);}catch(t){return void n(t)}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")});}else {const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new ut(s.status,s.statusText,t.url,e));}},e.signal.addEventListener("abort",(()=>{s.abort(),n(st());})),s.send(t.body);}))}(t,r)};function pt(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return !0;const e=new URL(t),r=window.location;return e.protocol===r.protocol&&e.host===r.host}function ft(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function dt(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class yt{constructor(t,e={}){O(this,e),this.type=t;}}class mt extends yt{constructor(t,e={}){super("error",O({error:t},e));}}class gt{on(t,e){return this._listeners=this._listeners||{},ft(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e);}}}off(t,e){return dt(t,e,this._listeners),dt(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},ft(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new yt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)dt(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(O(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof mt&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var xt={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const vt=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function bt(t,e){const r={};for(const e in t)"ref"!==e&&(r[e]=t[e]);return vt.forEach((t=>{t in e&&(r[t]=e[t]);})),r}function wt(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!wt(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!wt(t[r],e[r]))return !1;return !0}return t===e}function _t(t,e){t.push(e);}function St(t,e,r){_t(r,{command:"addSource",args:[t,e[t]]});}function At(t,e,r){_t(e,{command:"removeSource",args:[t]}),r[t]=!0;}function kt(t,e,r,n){At(t,r,n),St(t,e,r);}function Mt(t,e,r){let n;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!wt(t[r][n],e[r][n]))return !1;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!wt(t[r][n],e[r][n]))return !1;return !0}function It(t,e,r,n,i,s){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(wt(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(wt(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));}function zt(t){return t.id}function Pt(t,e){return t[e.id]=e,t}class Ct{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function Et(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class Bt extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Vt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Vt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Tt={kind:"null"},Ft={kind:"number"},Lt={kind:"string"},$t={kind:"boolean"},Ot={kind:"color"},Dt={kind:"projectionDefinition"},Rt={kind:"object"},Ut={kind:"value"},jt={kind:"collator"},Nt={kind:"formatted"},qt={kind:"padding"},Gt={kind:"colorArray"},Xt={kind:"numberArray"},Zt={kind:"resolvedImage"},Yt={kind:"variableAnchorOffsetCollection"};function Ht(t,e){return {kind:"array",itemType:t,N:e}}function Kt(t){if("array"===t.kind){const e=Kt(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Jt=[Tt,Ft,Lt,$t,Ot,Dt,Nt,Rt,Ht(Ut),qt,Xt,Gt,Zt,Yt];function Wt(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Wt(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Jt)if(!Wt(t,e))return null}return `Expected ${Kt(t)} but found ${Kt(e)} instead.`}function Qt(t,e){return e.some((e=>e.kind===t.kind))}function te(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function ee(t,e){return "array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const re=.96422,ne=.82521,ie=4/29,se=6/29,ae=3*se*se,oe=se*se*se,le=Math.PI/180,ue=180/Math.PI;function ce(t){return (t%=360)<0&&(t+=360),t}function he([t,e,r,n]){let i,s;const a=fe((.2225045*(t=pe(t))+.7168786*(e=pe(e))+.0606169*(r=pe(r)))/1);t===e&&e===r?i=s=a:(i=fe((.4360747*t+.3850649*e+.1430804*r)/re),s=fe((.0139322*t+.0971045*e+.7141733*r)/ne));const o=116*a-16;return [o<0?0:o,500*(i-a),200*(a-s),n]}function pe(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function fe(t){return t>oe?Math.pow(t,1/3):t/ae+ie}function de([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,a=isNaN(r)?i:i-r/200;return i=1*me(i),s=re*me(s),a=ne*me(a),[ye(3.1338561*s-1.6168667*i-.4906146*a),ye(-.9787684*s+1.9161415*i+.033454*a),ye(.0719453*s-.2289914*i+1.4052427*a),n]}function ye(t){return (t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function me(t){return t>se?t*t*t:ae*(t-ie)}const ge=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function xe(t,e){return ge(t,e)?t[e]:void 0}function ve(t){return parseInt(t.padEnd(2,t),16)/255}function be(t,e){return we(e?t/100:t,0,1)}function we(t,e,r){return Math.min(Math.max(e,t),r)}function _e(t){return !t.some(Number.isNaN)}const Se={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function Ae(t,e,r){return t+r*(e-t)}function ke(t,e,r){return t.map(((t,n)=>Ae(t,e[n],r)))}class Me{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]));}static parse(t){if(t instanceof Me)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return [0,0,0,0];const e=xe(Se,t);if(e){const[t,r,n]=e;return [t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return [ve(t.slice(r,r+=e)),ve(t.slice(r,r+=e)),ve(t.slice(r,r+=e)),ve(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,a,o,l,u,c,h,p]=e,f=[i||" ",o||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,a,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[we(+r/e,0,1),we(+s/e,0,1),we(+l/e,0,1),h?be(+h,p):1];if(_e(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,a,o,l,u]=r,c=[n||" ",s||" ",o].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,we(+i,0,100),we(+a,0,100),l?be(+l,u):1];if(_e(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=ce(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new Me(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=he(t),s=Math.sqrt(r*r+n*n);return [Math.round(1e4*s)?ce(Math.atan2(n,r)*ue):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",he(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return `rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}static interpolate(t,e,r,n="rgb"){switch(n){case "rgb":{const[n,i,s,a]=ke(t.rgb,e.rgb,r);return new Me(n,i,s,a,!1)}case "hcl":{const[n,i,s,a]=t.hcl,[o,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(o))isNaN(n)?isNaN(o)?h=NaN:(h=o,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else {let t=o-n;o>n&&t>180?t-=360:o<n&&n-o>180&&(t+=360),h=n+r*t;}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*le,de([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:Ae(i,l,r),Ae(s,u,r),Ae(a,c,r)]);return new Me(f,d,y,m,!1)}case "lab":{const[n,i,s,a]=de(ke(t.lab,e.lab,r));return new Me(n,i,s,a,!1)}}}}Me.black=new Me(0,0,0,1),Me.white=new Me(1,1,1,1),Me.transparent=new Me(0,0,0,0),Me.red=new Me(1,0,0,1);class Ie{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const ze=["bottom","center","top"];class Pe{constructor(t,e,r,n,i,s){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s;}}class Ce{constructor(t){this.sections=t;}static fromString(t){return new Ce([new Pe(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Ce?t:Ce.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Ee{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Ee)return t;if("number"==typeof t)return new Ee([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new Ee(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Ee(ke(t.values,e.values,r))}}class Be{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Be)return t;if("number"==typeof t)return new Be([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Be(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Be(ke(t.values,e.values,r))}}class Ve{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Ve)return t;if("string"==typeof t){const e=Me.parse(t);if(!e)return;return new Ve([e])}if(!Array.isArray(t))return;const e=[];for(const r of t){if("string"!=typeof r)return;const t=Me.parse(r);if(!t)return;e.push(t);}return new Ve(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r,n="rgb"){const i=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)i.push(Me.interpolate(t.values[s],e.values[s],r,n));return new Ve(i)}}class Te extends Error{constructor(t){super(t),this.name="RuntimeError";}toJSON(){return this.message}}const Fe=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Le{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Le)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Fe.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Le(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new Te(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new Te(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,a]=n[t+1],[o,l]=i[t+1];s.push([Ae(e,o,r),Ae(a,l,r)]);}return new Le(s)}}class $e{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new $e({name:t,available:!1}):null}}class Oe{constructor(t,e,r){this.from=t,this.to=e,this.transition=r;}static interpolate(t,e,r){return new Oe(t,e,r)}static parse(t){return t instanceof Oe?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new Oe(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new Oe(t.from,t.to,t.transition):"string"==typeof t?new Oe(t,t,1):void 0}}function De(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Re(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Oe||t instanceof Me||t instanceof Ie||t instanceof Ce||t instanceof Ee||t instanceof Be||t instanceof Ve||t instanceof Le||t instanceof $e)return !0;if(Array.isArray(t)){for(const e of t)if(!Re(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Re(t[e]))return !1;return !0}return !1}function Ue(t){if(null===t)return Tt;if("string"==typeof t)return Lt;if("boolean"==typeof t)return $t;if("number"==typeof t)return Ft;if(t instanceof Me)return Ot;if(t instanceof Oe)return Dt;if(t instanceof Ie)return jt;if(t instanceof Ce)return Nt;if(t instanceof Ee)return qt;if(t instanceof Be)return Xt;if(t instanceof Ve)return Gt;if(t instanceof Le)return Yt;if(t instanceof $e)return Zt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Ue(e);if(r){if(r===t)continue;r=Ut;break}r=t;}return Ht(r||Ut,e)}return Rt}function je(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Me||t instanceof Oe||t instanceof Ce||t instanceof Ee||t instanceof Be||t instanceof Ve||t instanceof Le||t instanceof $e?t.toString():JSON.stringify(t)}class Ne{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Re(t[1]))return e.error("invalid value");const r=t[1];let n=Ue(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Ne(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}const qe={string:Lt,number:Ft,boolean:$t,object:Rt};class Ge{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in qe)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=qe[r],n++;}else i=Ut;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Ht(i,s);}else {if(!qe[i])throw new Error(`Types doesn't contain name = ${i}`);r=qe[i];}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Ut);if(!r)return null;s.push(r);}return new Ge(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!Wt(this.type,Ue(r)))return r;if(e===this.args.length-1)throw new Te(`Expected value to be of type ${Kt(this.type)}, but found ${Kt(Ue(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Xe={"to-boolean":$t,"to-color":Ot,"to-number":Ft,"to-string":Lt};class Ze{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Xe[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Xe[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,Ut);if(!n)return null;i.push(n);}return new Ze(n,i)}evaluate(t){switch(this.type.kind){case "boolean":return Boolean(this.args[0].evaluate(t));case "color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Me)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:De(e[0],e[1],e[2],e[3]),!r))return new Me(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Te(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=Ee.parse(e);if(n)return n}throw new Te(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "numberArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Be.parse(e);if(n)return n}throw new Te(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "colorArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Ve.parse(e);if(n)return n}throw new Te(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=Le.parse(e);if(n)return n}throw new Te(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Te(`Could not convert ${JSON.stringify(e)} to number.`)}case "formatted":return Ce.fromString(je(this.args[0].evaluate(t)));case "resolvedImage":return $e.fromString(je(this.args[0].evaluate(t)));case "projectionDefinition":return this.args[0].evaluate(t);default:return je(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Ye=["Unknown","Point","LineString","Polygon"];class He{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Ye[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=Me.parse(t),this._parseColorCache.set(t,e)),e}}class Ke{constructor(t,e,r=[],n,i=new Vt,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Ge(e,[t]):"coerce"===r?new Ze(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===t.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(i.kind))n=r(n,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof Ne)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new He;try{n=new Ne(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Ke(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Bt(r,t));}checkSubtype(t,e){const r=Wt(t,e);return r&&this.error(r),r}}class Je{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Je(r,n):null}outputDefined(){return this.result.outputDefined()}}class We{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new We(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}}class Qe{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ft),n=e.parse(t[2],2,Ht(e.expectedType||Ut));return r&&n?new Qe(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Te(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Te(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Te(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}}class tr{constructor(t,e){this.type=$t,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ut),n=e.parse(t[2],2,Ut);return r&&n?Qt(r.type,[$t,Lt,Ft,Tt,Ut])?new tr(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Kt(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!te(e,["boolean","string","number","null"]))throw new Te(`Expected first argument to be of type boolean, string, number or null, but found ${Kt(Ue(e))} instead.`);if(!te(r,["string","array"]))throw new Te(`Expected second argument to be of type array or string, but found ${Kt(Ue(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}}class er{constructor(t,e,r){this.type=Ft,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ut),n=e.parse(t[2],2,Ut);if(!r||!n)return null;if(!Qt(r.type,[$t,Lt,Ft,Tt,Ut]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Kt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Ft);return i?new er(r,n,i):null}return new er(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!te(e,["boolean","string","number","null"]))throw new Te(`Expected first argument to be of type boolean, string, number or null, but found ${Kt(Ue(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),te(r,["string"])){const t=r.indexOf(e,n);return -1===t?-1:[...r.slice(0,t)].length}if(te(r,["array"]))return r.indexOf(e,n);throw new Te(`Expected second argument to be of type array or string, but found ${Kt(Ue(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}}class rr{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Ue(t)))return null}else r=Ue(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,Ut);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new rr(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (Ue(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class nr{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,$t);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new nr(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class ir{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ut),n=e.parse(t[2],2,Ft);if(!r||!n)return null;if(!Qt(r.type,[Ht(Ut),Lt,Ut]))return e.error(`Expected first argument to be of type array or string, but found ${Kt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Ft);return i?new ir(r.type,r,n,i):null}return new ir(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),te(e,["string"]))return [...e].slice(r,n).join("");if(te(e,["array"]))return e.slice(r,n);throw new Te(`Expected first argument to be of type array or string, but found ${Kt(Ue(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}}function sr(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new Te("Input is not a number.");a=o-1;}return 0}class ar{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Ft);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new ar(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[sr(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function or(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var lr,ur,cr=function(){if(ur)return lr;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return ur=1,lr=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},lr}(),hr=or(cr);class pr{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=fr(e,t.base,r,n);else if("linear"===t.name)i=fr(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new hr(s[0],s[1],s[2],s[3]).solve(fr(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Ft),!i)return null;const a=[];let o=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||e.expectedType==Gt?e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType):o=Ot;for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return ee(o,Ft)||ee(o,Dt)||ee(o,Ot)||ee(o,qt)||ee(o,Xt)||ee(o,Gt)||ee(o,Yt)||ee(o,Ht(Ft))?new pr(o,r,n,i,a):e.error(`Type ${Kt(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=sr(e,n),a=pr.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case "interpolate":switch(this.type.kind){case "number":return Ae(o,l,a);case "color":return Me.interpolate(o,l,a);case "padding":return Ee.interpolate(o,l,a);case "colorArray":return Ve.interpolate(o,l,a);case "numberArray":return Be.interpolate(o,l,a);case "variableAnchorOffsetCollection":return Le.interpolate(o,l,a);case "array":return ke(o,l,a);case "projectionDefinition":return Oe.interpolate(o,l,a)}case "interpolate-hcl":switch(this.type.kind){case "color":return Me.interpolate(o,l,a,"hcl");case "colorArray":return Ve.interpolate(o,l,a,"hcl")}case "interpolate-lab":switch(this.type.kind){case "color":return Me.interpolate(o,l,a,"lab");case "colorArray":return Ve.interpolate(o,l,a,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function fr(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}const dr={color:Me.interpolate,number:Ae,padding:Ee.interpolate,numberArray:Be.interpolate,colorArray:Ve.interpolate,variableAnchorOffsetCollection:Le.interpolate,array:ke};class yr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}if(!r)throw new Error("No output type");const s=n&&i.some((t=>Wt(n,t.type)));return new yr(s?Ut:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof $e&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function mr(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function gr(t,e,r,n){return 0===n.compare(e,r)}function xr(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=$t,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Ut);if(!s)return null;if(!mr(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Kt(s.type)}'.`);let a=e.parse(t[2],2,Ut);if(!a)return null;if(!mr(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Kt(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${Kt(s.type)}' and '${Kt(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new Ge(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new Ge(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,jt),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Ue(s),r=Ue(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Te(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Ue(s),r=Ue(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}}}const vr=xr("==",(function(t,e,r){return e===r}),gr),br=xr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !gr(0,e,r,n)})),wr=xr("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),_r=xr(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),Sr=xr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Ar=xr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class kr{constructor(t,e,r){this.type=jt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,$t);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,$t);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Lt),!s)?null:new kr(n,i,s)}evaluate(t){return new Ie(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}}class Mr{constructor(t,e,r,n,i){this.type=Lt,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Ft);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,Lt),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,Lt),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,Ft),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,Ft),!o)?null:new Mr(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}}class Ir{constructor(t){this.type=Nt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Ft),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Ht(Lt)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Ot),!a))return null;let o=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!ze.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(o=e.parse(s["vertical-align"],1,Lt),!o)return null}const l=n[n.length-1];l.scale=t,l.font=r,l.textColor=a,l.verticalAlign=o;}else {const s=e.parse(t[r],1,Ut);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null});}}return new Ir(n)}evaluate(t){return new Ce(this.sections.map((e=>{const r=e.content.evaluate(t);return Ue(r)===Zt?new Pe("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Pe(je(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign);}outputDefined(){return !1}}class zr{constructor(t){this.type=Zt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Lt);return r?new zr(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=$e.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}}class Pr{constructor(t){this.type=Ft,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Kt(r.type)} instead.`):new Pr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return [...e].length;if(Array.isArray(e))return e.length;throw new Te(`Expected value to be of type string or array, but found ${Kt(Ue(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}}const Cr=8192;function Er(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Cr),Math.round(n*i*Cr)]}function Br(t,e){const r=Math.pow(2,e.z);return [(i=(t[0]/Cr+e.x)/r,360*i-180),(n=(t[1]/Cr+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i;}function Vr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Tr(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Fr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function Lr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!jr(t,e,r,n)||!jr(r,n,t,e));var i,s;}function $r(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Lr(t,e,n[r],n[r+1]))return !0;return !1}function Or(t,e,r=!1){let n=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(Fr(t,o[e],o[e+1]))return r;(s=o[e])[1]>(i=t)[1]!=(a=o[e+1])[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}var i,s,a;return n}function Dr(t,e){for(const r of e)if(Or(t,r))return !0;return !1}function Rr(t,e){for(const r of t)if(!Or(r,e))return !1;for(let r=0;r<t.length-1;++r)if($r(t[r],t[r+1],e))return !1;return !0}function Ur(t,e){for(const r of e)if(Rr(t,r))return !0;return !1}function jr(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function Nr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=Er(t[i][n],r);Vr(e,a),s.push(a);}n.push(s);}return n}function qr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Nr(t[i],e,r);n.push(s);}return n}function Gr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Vr(e,t);}function Xr(t,e,r,n){const i=Math.pow(2,n.z)*Cr,s=[n.x*Cr,n.y*Cr],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Gr(n,e,r,i),a.push(n);}return a}function Zr(t,e,r,n){const i=Math.pow(2,n.z)*Cr,s=[n.x*Cr,n.y*Cr],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Vr(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Gr(n,e,r,i);}var o;return a}class Yr{constructor(t,e){this.type=$t,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Re(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n);}if(t.length)return new Yr(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Yr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Yr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Nr(e.coordinates,n,i),a=Xr(t.geometry(),r,n,i);if(!Tr(r,n))return !1;for(const t of a)if(!Or(t,s))return !1}if("MultiPolygon"===e.type){const s=qr(e.coordinates,n,i),a=Xr(t.geometry(),r,n,i);if(!Tr(r,n))return !1;for(const t of a)if(!Dr(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Nr(e.coordinates,n,i),a=Zr(t.geometry(),r,n,i);if(!Tr(r,n))return !1;for(const t of a)if(!Rr(t,s))return !1}if("MultiPolygon"===e.type){const s=qr(e.coordinates,n,i),a=Zr(t.geometry(),r,n,i);if(!Tr(r,n))return !1;for(const t of a)if(!Ur(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}let Hr=class{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}};function Kr(t,e,r=0,n=t.length-1,i=Wr){for(;n>r;){if(n-r>600){const s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);Kr(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}const s=t[e];let a=r,o=n;for(Jr(t,r,e),i(t[n],s)>0&&Jr(t,r,n);a<o;){for(Jr(t,a,o),a++,o--;i(t[a],s)<0;)a++;for(;i(t[o],s)>0;)o--;}0===i(t[r],s)?Jr(t,r,o):(o++,Jr(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function Jr(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Wr(t,e){return t<e?-1:t>e?1:0}function Qr(t,e){if(t.length<=1)return [t];const r=[];let n,i;for(const e of t){const t=en(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e));}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Kr(r[t],e,1,r[t].length-1,tn),r[t]=r[t].slice(0,e));return r}function tn(t,e){return e.area-t.area}function en(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}const rn=1/298.257223563,nn=rn*(2-rn),sn=Math.PI/180;class an{constructor(t){const e=6378.137*sn*1e3,r=Math.cos(t*sn),n=1/(1-nn*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-nn);}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,i,s,a=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=this.wrap(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<a&&(a=f,r=l,n=u,i=o,s=p);}return {point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function on(t,e){return e[0]-t[0]}function ln(t){return t[1]-t[0]+1}function un(t,e){return t[1]>=t[0]&&t[1]<e}function cn(t,e){if(t[0]>t[1])return [null,null];const r=ln(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return [t,null];const n=Math.floor(r/2)-1;return [[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function hn(t,e){if(!un(e,t.length))return [1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)Vr(r,t[n]);return r}function pn(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)Vr(e,t);return e}function fn(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function dn(t,e,r){if(!fn(t)||!fn(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function yn(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function mn(t,e,r,n,i){const s=Math.min(yn(t,[r,n],i),yn(e,[r,n],i)),a=Math.min(yn(r,[t,e],i),yn(n,[t,e],i));return Math.min(s,a)}function gn(t,e,r,n,i){if(!un(e,t.length)||!un(n,r.length))return 1/0;let s=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],o=t[a+1];for(let t=n[0];t<n[1];++t){const n=r[t],a=r[t+1];if(Lr(e,o,n,a))return 0;s=Math.min(s,mn(e,o,n,a,i));}}return s}function xn(t,e,r,n,i){if(!un(e,t.length)||!un(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[a],r[e])),0===s)return s;return s}function vn(t,e,r){if(Or(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,yn(t,[s,e],r)),0===n))return n;const a=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,a.point)),0===n)return n}return n}function bn(t,e,r,n){if(!un(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Or(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],a=t[s+1];for(const t of r)for(let r=0,s=t.length,o=s-1;r<s;o=r++){const s=t[o],l=t[r];if(Lr(e,a,s,l))return 0;i=Math.min(i,mn(e,a,s,l,n));}}return i}function wn(t,e){for(const r of t)for(const t of r)if(Or(t,e,!0))return !0;return !1}function _n(t,e,r,n=1/0){const i=pn(t),s=pn(e);if(n!==1/0&&dn(i,s,r)>=n)return n;if(Tr(i,s)){if(wn(t,e))return 0}else if(wn(e,t))return 0;let a=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],o=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if(Lr(i,o,n,l))return 0;a=Math.min(a,mn(i,o,n,l,r));}}return a}function Sn(t,e,r,n,i,s){if(!s)return;const a=dn(hn(n,s),i,r);a<e&&t.push([a,s,[0,0]]);}function An(t,e,r,n,i,s,a){if(!s||!a)return;const o=dn(hn(n,s),hn(i,a),r);o<e&&t.push([o,s,a]);}function kn(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new Hr([[0,[0,t.length-1],[0,0]]],on),o=pn(r);for(;a.length>0;){const i=a.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(ln(l)<=u){if(!un(l,t.length))return NaN;if(e){const e=bn(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e);}else for(let e=l[0];e<=l[1];++e){const i=vn(t[e],r,n);if(s=Math.min(s,i),0===s)return 0}}else {const r=cn(l,e);Sn(a,s,n,t,o,r[0]),Sn(a,s,n,t,o,r[1]);}}return s}function Mn(t,e,r,n,i,s=1/0){let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new Hr([[0,[0,t.length-1],[0,r.length-1]]],on);for(;o.length>0;){const s=o.pop();if(s[0]>=a)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(ln(l)<=c&&ln(u)<=h){if(!un(l,t.length)&&un(u,r.length))return NaN;let s;if(e&&n)s=gn(t,l,r,u,i),a=Math.min(a,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=yn(r[t],e,i),a=Math.min(a,s),0===a)return a}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=yn(t[r],e,i),a=Math.min(a,s),0===a)return a}else s=xn(t,l,r,u,i),a=Math.min(a,s);}else {const s=cn(l,e),c=cn(u,n);An(o,a,i,t,r,s[0],c[0]),An(o,a,i,t,r,s[0],c[1]),An(o,a,i,t,r,s[1],c[0]),An(o,a,i,t,r,s[1],c[1]);}}return a}function In(t){return "MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class zn{constructor(t,e){this.type=Ft,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Re(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new zn(e,e.features.map((t=>In(t.geometry))).flat());if("Feature"===e.type)return new zn(e,In(e.geometry));if("type"in e&&"coordinates"in e)return new zn(e,In(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Br([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new an(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case "Point":s=Math.min(s,Mn(n,!1,[t.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,Mn(n,!1,t.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,kn(n,!1,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Br([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new an(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case "Point":s=Math.min(s,Mn(n,!0,[t.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,Mn(n,!0,t.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,kn(n,!0,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=Qr(r,0).map((e=>e.map((e=>e.map((e=>Br([e.x,e.y],t.canonical))))))),i=new an(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case "Point":s=Math.min(s,kn([t.coordinates],!1,e,i,s));break;case "LineString":s=Math.min(s,kn(t.coordinates,!0,e,i,s));break;case "Polygon":s=Math.min(s,_n(e,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return !0}}class Pn{constructor(t){this.type=Ut,this.key=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=t[1];return null==r?e.error("Global state property must be defined."):"string"!=typeof r?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Pn(r)}evaluate(t){var e;const r=null===(e=t.globals)||void 0===e?void 0:e.globalState;return r&&0!==Object.keys(r).length?xe(r,this.key):null}eachChild(){}outputDefined(){return !1}}const Cn={"==":vr,"!=":br,">":_r,"<":wr,">=":Ar,"<=":Sr,array:Ge,at:Qe,boolean:Ge,case:nr,coalesce:yr,collator:kr,format:Ir,image:zr,in:tr,"index-of":er,interpolate:pr,"interpolate-hcl":pr,"interpolate-lab":pr,length:Pr,let:Je,literal:Ne,match:rr,number:Ge,"number-format":Mr,object:Ge,slice:ir,step:ar,string:Ge,"to-boolean":Ze,"to-color":Ze,"to-number":Ze,"to-string":Ze,var:We,within:Yr,distance:zn,"global-state":Pn};class En{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}static parse(t,e){const r=t[0],n=En.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new Ke(e.registry,Ln,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new En(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(Kt).join(", ")})`:`(${Kt(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Kt(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){En.definitions=e;for(const r in e)t[r]=En;}}function Bn(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=De(e,r,n,s);if(a)throw new Te(a);return new Me(e/255,r/255,n/255,s,!1)}function Vn(t,e){return t in e}function Tn(t,e){const r=e[t];return void 0===r?null:r}function Fn(t){return {type:t}}function Ln(t){if(t instanceof We)return Ln(t.boundExpression);if(t instanceof En&&"error"===t.name)return !1;if(t instanceof kr)return !1;if(t instanceof Yr)return !1;if(t instanceof zn)return !1;if(t instanceof Pn)return !1;const e=t instanceof Ze||t instanceof Ge;let r=!0;return t.eachChild((t=>{r=e?r&&Ln(t):r&&t instanceof Ne;})),!!r&&$n(t)&&Dn(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function $n(t){if(t instanceof En){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Yr)return !1;if(t instanceof zn)return !1;let e=!0;return t.eachChild((t=>{e&&!$n(t)&&(e=!1);})),e}function On(t){if(t instanceof En&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!On(t)&&(e=!1);})),e}function Dn(t,e){if(t instanceof En&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Dn(t,e)&&(r=!1);})),r}function Rn(t){return {result:"success",value:t}}function Un(t){return {result:"error",value:t}}function jn(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Nn(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function qn(t){return !!t.expression&&t.expression.interpolated}function Gn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Xn(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)&&Ue(t)===Rt}function Zn(t){return t}function Yn(t,e){const r=t.stops&&"object"==typeof t.stops[0][0],n=r||!(r||void 0!==t.property),i=t.type||(qn(e)?"exponential":"interval"),s=function(t){switch(t.type){case "color":return Me.parse;case "padding":return Ee.parse;case "numberArray":return Be.parse;case "colorArray":return Ve.parse;default:return null}}(e);if(s&&((t=Et({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],s(t[1])]))),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;const o=function(t){switch(t){case "exponential":return Wn;case "interval":return Jn;case "categorical":return Kn;case "identity":return Qn;default:throw new Error(`Unknown function type "${t}"`)}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0];}if(r){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Yn(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:pr.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Wn({stops:i,base:t.base},e,r).evaluate(r,n)}}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:pr.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,l,u)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Hn(t.default,e.default):o(t,e,i,l,u)}}}function Hn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Kn(t,e,r,n,i){return Hn(typeof r===i?n[r]:void 0,t.default,e.default)}function Jn(t,e,r){if("number"!==Gn(r))return Hn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=sr(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Wn(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Gn(r))return Hn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=sr(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1],u=dr[e.type]||Zn;return "function"==typeof o.evaluate?{evaluate(...e){const r=o.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,a,t.colorSpace)}}:u(o,l,a,t.colorSpace)}function Qn(t,e,r){switch(e.type){case "color":r=Me.parse(r);break;case "formatted":r=Ce.fromString(r.toString());break;case "resolvedImage":r=$e.fromString(r.toString());break;case "padding":r=Ee.parse(r);break;case "colorArray":r=Ve.parse(r);break;case "numberArray":r=Be.parse(r);break;default:Gn(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return Hn(r,t.default,e.default)}En.register(Cn,{error:[{kind:"error"},[Lt],(t,[e])=>{throw new Te(e.evaluate(t))}],typeof:[Lt,[Ut],(t,[e])=>Kt(Ue(e.evaluate(t)))],"to-rgba":[Ht(Ft,4),[Ot],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return [255*r,255*n,255*i,s]}],rgb:[Ot,[Ft,Ft,Ft],Bn],rgba:[Ot,[Ft,Ft,Ft,Ft],Bn],has:{type:$t,overloads:[[[Lt],(t,[e])=>Vn(e.evaluate(t),t.properties())],[[Lt,Rt],(t,[e,r])=>Vn(e.evaluate(t),r.evaluate(t))]]},get:{type:Ut,overloads:[[[Lt],(t,[e])=>Tn(e.evaluate(t),t.properties())],[[Lt,Rt],(t,[e,r])=>Tn(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ut,[Lt],(t,[e])=>Tn(e.evaluate(t),t.featureState||{})],properties:[Rt,[],t=>t.properties()],"geometry-type":[Lt,[],t=>t.geometryType()],id:[Ut,[],t=>t.id()],zoom:[Ft,[],t=>t.globals.zoom],"heatmap-density":[Ft,[],t=>t.globals.heatmapDensity||0],elevation:[Ft,[],t=>t.globals.elevation||0],"line-progress":[Ft,[],t=>t.globals.lineProgress||0],accumulated:[Ut,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Ft,Fn(Ft),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[Ft,Fn(Ft),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:Ft,overloads:[[[Ft,Ft],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Ft],(t,[e])=>-e.evaluate(t)]]},"/":[Ft,[Ft,Ft],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Ft,[Ft,Ft],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Ft,[],()=>Math.LN2],pi:[Ft,[],()=>Math.PI],e:[Ft,[],()=>Math.E],"^":[Ft,[Ft,Ft],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Ft,[Ft],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Ft,[Ft],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Ft,[Ft],(t,[e])=>Math.log(e.evaluate(t))],log2:[Ft,[Ft],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Ft,[Ft],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Ft,[Ft],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Ft,[Ft],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Ft,[Ft],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Ft,[Ft],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Ft,[Ft],(t,[e])=>Math.atan(e.evaluate(t))],min:[Ft,Fn(Ft),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Ft,Fn(Ft),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Ft,[Ft],(t,[e])=>Math.abs(e.evaluate(t))],round:[Ft,[Ft],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Ft,[Ft],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Ft,[Ft],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[$t,[Lt,Ut],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[$t,[Ut],(t,[e])=>t.id()===e.value],"filter-type-==":[$t,[Lt],(t,[e])=>t.geometryType()===e.value],"filter-<":[$t,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[$t,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[$t,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[$t,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[$t,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[$t,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[$t,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[$t,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[$t,[Ut],(t,[e])=>e.value in t.properties()],"filter-has-id":[$t,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[$t,[Ht(Lt)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[$t,[Ht(Ut)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[$t,[Lt,Ht(Ut)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[$t,[Lt,Ht(Ut)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:$t,overloads:[[[$t,$t],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Fn($t),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:$t,overloads:[[[$t,$t],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Fn($t),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[$t,[$t],(t,[e])=>!e.evaluate(t)],"is-supported-script":[$t,[Lt],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Lt,[Lt],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Lt,[Lt],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Lt,Fn(Ut),(t,e)=>e.map((e=>je(e.evaluate(t)))).join("")],"resolved-locale":[Lt,[jt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class ti{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new He,this._defaultValue=e?function(t){if("color"===t.type&&Xn(t.default))return new Me(0,0,0,0);switch(t.type){case "color":return Me.parse(t.default)||null;case "padding":return Ee.parse(t.default)||null;case "numberArray":return Be.parse(t.default)||null;case "colorArray":return Ve.parse(t.default)||null;case "variableAnchorOffsetCollection":return Le.parse(t.default)||null;case "projectionDefinition":return Oe.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Te(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function ei(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Cn}function ri(t,e){const r=new Ke(Cn,Ln,[],e?function(t){const e={color:Ot,string:Lt,number:Ft,enum:Lt,boolean:$t,formatted:Nt,padding:qt,numberArray:Xt,colorArray:Gt,projectionDefinition:Dt,resolvedImage:Zt,variableAnchorOffsetCollection:Yt};return "array"===t.type?Ht(e[t.value]||Ut,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Rn(new ti(n,e)):Un(r.errors)}class ni{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!On(e.expression),this.globalStateRefs=li(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class ii{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!On(e.expression),this.globalStateRefs=li(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?pr.interpolationFactor(this.interpolationType,t,e,r):0}}function si(t,e){const r=ri(t,e);if("error"===r.result)return r;const n=r.value.expression,i=$n(n);if(!i&&!jn(e))return Un([new Bt("","data expressions not supported")]);const s=Dn(n,["zoom"]);if(!s&&!Nn(e))return Un([new Bt("","zoom expressions not supported")]);const a=oi(n);return a||s?a instanceof Bt?Un([a]):a instanceof pr&&!qn(e)?Un([new Bt("",'"interpolate" expressions cannot be used with this property')]):Rn(a?new ii(i?"camera":"composite",r.value,a.labels,a instanceof pr?a.interpolation:void 0):new ni(i?"constant":"source",r.value)):Un([new Bt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class ai{constructor(t,e){this._parameters=t,this._specification=e,Et(this,Yn(this._parameters,this._specification));}static deserialize(t){return new ai(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function oi(t){let e=null;if(t instanceof Je)e=oi(t.result);else if(t instanceof yr){for(const r of t.args)if(e=oi(r),e)break}else (t instanceof ar||t instanceof pr)&&t.input instanceof En&&"zoom"===t.input.name&&(e=t);return e instanceof Bt||t.eachChild((t=>{const r=oi(t);r instanceof Bt?e=r:!e&&r?e=new Bt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new Bt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function li(t,e=new Set){return t instanceof Pn&&e.add(t.key),t.eachChild((t=>{li(t,e);})),e}function ui(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case "has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case "in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case "!in":case "!has":case "none":return !1;case "==":case "!=":case ">":case ">=":case "<":case "<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case "any":case "all":for(const e of t.slice(1))if(!ui(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const ci={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function hi(t){if(null==t)return {filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};ui(t)||(t=di(t));const e=ri(t,ci);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:fi(t),getGlobalStateRefs:()=>li(e.value.expression)}}function pi(t,e){return t<e?-1:t>e?1:0}function fi(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(fi(t[e]))return !0;return !1}function di(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?yi(t[1],t[2],"=="):"!="===e?xi(yi(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?yi(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(di))):"all"===e?["all"].concat(t.slice(1).map(di)):"none"===e?["all"].concat(t.slice(1).map(di).map(xi)):"in"===e?mi(t[1],t.slice(2)):"!in"===e?xi(mi(t[1],t.slice(2))):"has"===e?gi(t[1]):"!has"!==e||xi(gi(t[1]));var r;}function yi(t,e,r){switch(t){case "$type":return [`filter-type-${r}`,e];case "$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function mi(t,e){if(0===e.length)return !1;switch(t){case "$type":return ["filter-type-in",["literal",e]];case "$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(pi)]]:["filter-in-small",t,["literal",e]]}}function gi(t){switch(t){case "$type":return !0;case "$id":return ["filter-has-id"];default:return ["filter-has",t]}}function xi(t){return ["!",t]}function vi(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${vi(r)},`;return `${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${vi(t[r[e]])},`;return `${n}}`}function bi(t){let e="";for(const r of vt)e+=`/${vi(t[r])}`;return e}function wi(t){const e=t.value;return e?[new Ct(t.key,e,"constants have been deprecated as of v8")]:[]}function _i(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Si(t){if(Array.isArray(t))return t.map(Si);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Si(t[r]);return e}return _i(t)}function Ai(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const u=Gn(r);if("object"!==u)return [new Ct(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=xe(n,u)||n["*"];let h;if(xe(i,u))h=i[u];else if(xe(n,u))h=o;else if(i["*"])h=i["*"];else {if(!n["*"]){l.push(new Ct(e,r[t],`unknown property "${t}"`));continue}h=o;}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:a,object:r,objectKey:t,validateSpec:o},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new Ct(e,r,`missing required property "${t}"`));return l}function ki(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==Gn(e))return [new Ct(s,e,`array expected, ${Gn(e)} found`)];if(r.length&&e.length!==r.length)return [new Ct(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new Ct(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function),"object"===Gn(r.value)&&(o=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:o,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function Mi(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Gn(r);return "number"===i&&r!=r&&(i="NaN"),"number"!==i?[new Ct(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new Ct(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new Ct(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function Ii(t){const e=t.valueSpec,r=_i(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Gn(t.value.stops)&&"array"===Gn(t.value.stops[0])&&"object"===Gn(t.value.stops[0][0]),c=Ai({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new Ct(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(ki({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Gn(n)&&0===n.length&&e.push(new Ct(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new Ct(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Ct(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!qn(t.valueSpec)&&c.push(new Ct(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!jn(t.valueSpec)?c.push(new Ct(t.key,t.value,"property functions not supported")):o&&!Nn(t.valueSpec)&&c.push(new Ct(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Ct(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Gn(n))return [new Ct(o,n,`array expected, ${Gn(n)} found`)];if(2!==n.length)return [new Ct(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Gn(n[0]))return [new Ct(o,n,`object expected, ${Gn(n[0])} found`)];if(void 0===n[0].zoom)return [new Ct(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new Ct(o,n,"object stop key must have value")];if(s&&s>_i(n[0].zoom))return [new Ct(o,n[0].zoom,"stop zoom values must appear in ascending order")];_i(n[0].zoom)!==s&&(s=_i(n[0].zoom),i=void 0,a={}),r=r.concat(Ai({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:Mi,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return ei(Si(n[1]))?r.concat([new Ct(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${o}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Gn(t.value),l=_i(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new Ct(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new Ct(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return jn(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Ct(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new Ct(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new Ct(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Ct(t.key,u,`integer expected, found ${l}`)]}}function zi(t){const e=("property"===t.expressionContext?si:ri)(Si(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Ct(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new Ct(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!On(r))return [new Ct(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!On(r))return [new Ct(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Dn(r,["zoom","feature-state"]))return [new Ct(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!$n(r))return [new Ct(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function Pi(t){const e=t.key,r=t.value,n=Gn(r);return "string"!==n?[new Ct(e,r,`color expected, ${n} found`)]:Me.parse(String(r))?[]:[new Ct(e,r,`color expected, "${r}" found`)]}function Ci(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(_i(r))&&i.push(new Ct(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(_i(r))&&i.push(new Ct(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function Ei(t){return ui(Si(t.value))?zi(Et({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Bi(t)}function Bi(t){const e=t.value,r=t.key;if("array"!==Gn(e))return [new Ct(r,e,`array expected, ${Gn(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new Ct(r,e,"filter array must have at least 1 element")];switch(s=s.concat(Ci({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),_i(e[0])){case "<":case "<=":case ">":case ">=":e.length>=2&&"$type"===_i(e[1])&&s.push(new Ct(r,e,`"$type" cannot be use with operator "${e[0]}"`));case "==":case "!=":3!==e.length&&s.push(new Ct(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case "in":case "!in":e.length>=2&&(i=Gn(e[1]),"string"!==i&&s.push(new Ct(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Gn(e[a]),"$type"===_i(e[1])?s=s.concat(Ci({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new Ct(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case "any":case "all":case "none":for(let n=1;n<e.length;n++)s=s.concat(Bi({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case "has":case "!has":i=Gn(e[1]),2!==e.length?s.push(new Ct(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new Ct(`${r}[1]`,e[1],`string expected, ${i} found`));}return s}function Vi(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,a=t.value,o=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return [];const u=o.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:a,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[o];if(!c)return [new Ct(r,a,`unknown property "${o}"`)];let h;if("string"===Gn(a)&&jn(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(a)))return [new Ct(r,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return "symbol"===t.layerType&&("text-field"===o&&i&&!i.glyphs&&p.push(new Ct(r,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===o&&Xn(Si(a))&&"identity"===_i(a.type)&&p.push(new Ct(r,a,'"text-font" does not support identity functions'))),p.concat(n({key:t.key,value:a,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:o}))}function Ti(t){return Vi(t,"paint")}function Fi(t){return Vi(t,"layout")}function Li(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;if("object"!==Gn(r))return [new Ct(n,r,`object expected, ${Gn(r)} found`)];r.type||r.ref||e.push(new Ct(n,r,'either "type" or "ref" is required'));let a=_i(r.type);const o=_i(r.ref);if(r.id){const s=_i(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];_i(t.id)===s&&e.push(new Ct(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new Ct(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{_i(e.id)===o&&(t=e);})),t?t.ref?e.push(new Ct(n,r.ref,"ref cannot reference another ref layer")):a=_i(t.type):e.push(new Ct(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&_i(t.type);t?"vector"===s&&"raster"===a?e.push(new Ct(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a||"raster-dem"!==s&&"color-relief"===a?e.push(new Ct(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?e.push(new Ct(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a&&"color-relief"!==a?e.push(new Ct(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Ct(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Ct(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Ct(n,r.source,`source "${r.source}" not found`));}else e.push(new Ct(n,r,'missing required property "source"'));return e=e.concat(Ai({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:Ei,layout:t=>Ai({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Fi(Et({layerType:a},t))}}),paint:t=>Ai({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Ti(Et({layerType:a},t))}})}})),e}function $i(t){const e=t.value,r=t.key,n=Gn(e);return "string"!==n?[new Ct(r,e,`string expected, ${n} found`)]:[]}const Oi={promoteId:function({key:t,value:e}){if("string"===Gn(e))return $i({key:t,value:e});{const r=[];for(const n in e)r.push(...$i({key:`${t}.${n}`,value:e[n]}));return r}}};function Di(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return [new Ct(r,e,'"type" is required')];const a=_i(e.type);let o;switch(a){case "vector":case "raster":return o=Ai({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Oi,validateSpec:s}),o;case "raster-dem":return o=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,a=t.style;let o=[];const l=Gn(n);if(void 0===n)return o;if("object"!==l)return o.push(new Ct("source_raster_dem",n,`object expected, ${l} found`)),o;const u="custom"===_i(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?o.push(new Ct(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?o=o.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:a,styleSpec:i})):o.push(new Ct(e,n[e],`unknown property "${e}"`));return o}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),o;case "geojson":if(o=Ai({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:Oi}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;o.push(...zi({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),o.push(...zi({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return o;case "video":return Ai({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case "image":return Ai({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case "canvas":return [new Ct(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Ci({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Ri(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Gn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Ct("light",e,`object expected, ${a} found`)]),s;for(const a in e){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new Ct(a,e[a],`unknown property "${a}"`)]);}return s}function Ui(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=Gn(e);if(void 0===e)return [];if("object"!==s)return [new Ct("sky",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new Ct(s,e[s],`unknown property "${s}"`)]);return a}function ji(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const a=Gn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Ct("terrain",e,`object expected, ${a} found`)]),s;for(const a in e)s=s.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new Ct(a,e[a],`unknown property "${a}"`)]);return s}function Ni(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const a in r)r[a].id&&i.includes(r[a].id)&&e.push(new Ct(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),i.push(r[a].id),r[a].url&&s.includes(r[a].url)&&e.push(new Ct(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),s.push(r[a].url),e=e.concat(Ai({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return $i({key:n,value:r})}function qi(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new Ct(t.key,t.value,`object expected, ${Gn(t.value)} found`)];var e;}const Gi={"*":()=>[],array:ki,boolean:function(t){const e=t.value,r=t.key,n=Gn(e);return "boolean"!==n?[new Ct(r,e,`boolean expected, ${n} found`)]:[]},number:Mi,color:Pi,constants:wi,enum:Ci,filter:Ei,function:Ii,layer:Li,object:Ai,source:Di,light:Ri,sky:Ui,terrain:ji,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=Gn(e);if(void 0===e)return [];if("object"!==s)return [new Ct("projection",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new Ct(s,e[s],`unknown property "${s}"`)]);return a},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=Gn(r);return "array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(r)||function(t){return !!["interpolate","step","literal"].includes(t[0])}(r)?["array","string"].includes(n)?[]:[new Ct(e,r,`projection expected, invalid type "${n}" found`)]:[new Ct(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:$i,formatted:function(t){return 0===$i(t).length?[]:zi(t)},resolvedImage:function(t){return 0===$i(t).length?[]:zi(t)},padding:function(t){const e=t.key,r=t.value;if("array"===Gn(r)){if(r.length<1||r.length>4)return [new Ct(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return Mi({key:e,value:r,valueSpec:{}})},numberArray:function(t){const e=t.key,r=t.value;if("array"===Gn(r)){const n={type:"number"};if(r.length<1)return [new Ct(e,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return Mi({key:e,value:r,valueSpec:{}})},colorArray:function(t){const e=t.key,r=t.value;if("array"===Gn(r)){if(r.length<1)return [new Ct(e,r,"array length at least 1 expected, length 0 found")];let t=[];for(let n=0;n<r.length;n++)t=t.concat(Pi({key:`${e}[${n}]`,value:r[n]}));return t}return Pi({key:e,value:r})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=Gn(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return [new Ct(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Ci({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(ki({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:Ni,state:qi};function Xi(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=Xi,r.expression&&Xn(_i(e))?Ii(t):r.expression&&ei(Si(e))?zi(t):r.type&&Gi[r.type]?Gi[r.type](t):Ai(Et({},t,{valueSpec:r.type?n[r.type]:r}))}function Zi(t){const e=t.value,r=t.key,n=$i(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new Ct(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new Ct(r,e,'"glyphs" url must include a "{range}" token'))),n}function Yi(t,e=xt){let r=[];return r=r.concat(Xi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Xi,objectElementValidators:{glyphs:Zi,"*":()=>[]}})),t.constants&&(r=r.concat(wi({key:"constants",value:t.constants}))),Ki(r)}function Hi(t){return function(e){return t({...e,validateSpec:Xi})}}function Ki(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function Ji(t){return function(...e){return Ki(t.apply(this,e))}}Yi.source=Ji(Hi(Di)),Yi.sprite=Ji(Hi(Ni)),Yi.glyphs=Ji(Hi(Zi)),Yi.light=Ji(Hi(Ri)),Yi.sky=Ji(Hi(Ui)),Yi.terrain=Ji(Hi(ji)),Yi.state=Ji(Hi(qi)),Yi.layer=Ji(Hi(Li)),Yi.filter=Ji(Hi(Ei)),Yi.paintProperty=Ji(Hi(Ti)),Yi.layoutProperty=Ji(Hi(Fi));const Wi=Yi,Qi=Wi.light,ts=Wi.sky,es=Wi.paintProperty,rs=Wi.layoutProperty;function ns(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new mt(new Error(n.message))),r=!0;return r}class is{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s);}query(t,e,r,n,i){const s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,a,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===a[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(a[h]=!0,s.push(i[h])):a[h]=!1;}}}}_forEachCell(t,e,r,n,i,s,a,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,a,o))return}}_convertFromCellCoord(t){return (t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length;}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new is(t.buffer)}}const ss={};function as(t,e,r={}){if(ss[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ss[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}as("Object",Object),as("Set",Set),as("TransferableGridIndex",is),as("Color",Me),as("Error",Error),as("AJAXError",ut),as("ResolvedImage",$e),as("StylePropertyFunction",ai),as("StyleExpression",ti,{omit:["_evaluator"]}),as("ZoomDependentExpression",ii),as("ZoomConstantExpression",ni),as("CompoundExpression",En,{omit:["_evaluate"]});for(const t in Cn)Cn[t]._classRegistryKey||as(`Expression_${t}`,Cn[t]);function os(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function ls(t){return t.$name||t.constructor._classRegistryKey}function us(t){return !function(t){if(null===t||"object"!=typeof t)return !1;const e=ls(t);return !(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||os(t)||Y(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function cs(t,e){if(us(t))return (os(t)||Y(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(cs(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=ls(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!ss[r])throw new Error(`${r} is not registered.`);const{klass:n}=ss[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const n in t){if(!t.hasOwnProperty(n))continue;if(ss[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=ss[r].shallow.indexOf(n)>=0?s:cs(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==r&&(i.$name=r),i}function hs(t){if(us(t))return t;if(Array.isArray(t))return t.map(hs);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=ls(t)||"Object";if(!ss[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=ss[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=ss[e].shallow.indexOf(r)>=0?i:hs(i);}return n}class ps{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const fs={"Latin-1 Supplement":t=>t>=128&&t<=255,"Hangul Jamo":t=>t>=4352&&t<=4607,Khmer:t=>t>=6016&&t<=6143,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Kanbun:t=>t>=12688&&t<=12703,"CJK Strokes":t=>t>=12736&&t<=12783,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Hangul Syllables":t=>t>=44032&&t<=55215,"Private Use Area":t=>t>=57344&&t<=63743,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function ds(t){for(const e of t)if(bs(e.charCodeAt(0)))return !0;return !1}function ys(t){for(const e of t)if(!xs(e.charCodeAt(0)))return !1;return !0}function ms(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const gs=ms(["Arab","Dupl","Mong","Ougr","Syrc"]);function xs(t){return !gs.test(String.fromCodePoint(t))}const vs=ms(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function bs(t){return !(746!==t&&747!==t&&(t<4352||!(fs["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||fs["CJK Compatibility"](t)||fs["CJK Strokes"](t)||!(!fs["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||fs["Enclosed CJK Letters and Months"](t)||fs["Ideographic Description Characters"](t)||fs.Kanbun(t)||fs.Katakana(t)&&12540!==t||!(!fs["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!fs["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||fs["Vertical Forms"](t)||fs["Yijing Hexagram Symbols"](t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||vs.test(String.fromCodePoint(t)))))}function ws(t){return !(bs(t)||function(t){return !!(fs["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||fs["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||fs["Letterlike Symbols"](t)||fs["Number Forms"](t)||fs["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||fs["Control Pictures"](t)&&9251!==t||fs["Optical Character Recognition"](t)||fs["Enclosed Alphanumerics"](t)||fs["Geometric Shapes"](t)||fs["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||fs["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||fs["CJK Symbols and Punctuation"](t)||fs.Katakana(t)||fs["Private Use Area"](t)||fs["CJK Compatibility Forms"](t)||fs["Small Form Variants"](t)||fs["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}const _s=ms(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Ss(t){return _s.test(String.fromCodePoint(t))}function As(t,e){return !(!e&&Ss(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||fs.Khmer(t))}function ks(t){for(const e of t)if(Ss(e.charCodeAt(0)))return !0;return !1}const Ms=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{};}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL;}getState(){return {pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(Ms.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve();}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,r){return e(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const e=t.pluginURL,n=new Promise((t=>{this.loadScriptResolve=t;}));r(e);const i=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:e};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${e}`)}))}};class Is{constructor(t,e){this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new ps,this.transition=e.transition||{},this.globalState=e.globalState||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new ps,this.transition={},this.globalState={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!As(r.charCodeAt(0),e))return !1;return !0}(t,"loaded"===Ms.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class zs{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Xn(t))return new ai(t,e);if(ei(t)){const r=si(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "color"===e.type&&"string"==typeof t?r=Me.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=Le.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=Oe.parse(t)):r=Ve.parse(t):r=Be.parse(t):r=Ee.parse(t),{globalStateRefs:new Set,kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification),this._evaluate=this.expression.evaluate;}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}setGlobalState(t){this.expression.evaluate=(e,r,n,i,s,a)=>(e.globalState=t,this._evaluate.call(this.expression,e,r,n,i,s,a));}}class Ps{constructor(t){this.property=t,this.value=new zs(t,void 0);}transitioned(t,e){return new Es(this.property,this.value,e,O({},t.transition,this.transition),t.now)}untransitioned(){return new Es(this.property,this.value,null,{},0)}}class Cs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return j(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ps(this._values[t].property)),this._values[t].value=new zs(this._values[t].property,null===e?void 0:j(e));}getTransition(t){return j(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ps(this._values[t].property)),this._values[t].transition=j(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Bs(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Bs(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Es{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,V(a))}}return i}}class Bs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Fs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Vs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._globalState={};}hasValue(t){return void 0!==this._values[t].value}getValue(t){return j(this._values[t].value)}setValue(t,e){this._values[t]=new zs(this._values[t].property,null===e?void 0:j(e)),this._values[t].setGlobalState(this._globalState);}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Fs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}setGlobalState(t){this._globalState=t;for(const e of Object.values(this._values))e.setGlobalState(t);}}class Ts{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Fs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class Ls{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=dr[this.specification.type];return n?n(t,e,r):t}}class $s{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Ts(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Ts(this,{kind:"constant",value:void 0},t.parameters);const n=dr[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new Ts(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class Os extends $s{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new Ts(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new Ts(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Ts(this,{kind:"constant",value:r},e)}return new Ts(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Ds{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Is(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Is(Math.floor(e.zoom),e)),t.expression.evaluate(new Is(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Rs{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Us{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new zs(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new Ps(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}as("DataDrivenProperty",$s),as("DataConstantProperty",Ls),as("CrossFadedDataDrivenProperty",Os),as("CrossFadedProperty",Ds),as("ColorRampProperty",Rs);const js="-transition";class Ns extends gt{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,this._globalState={},"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=hi(t.filter)),e.layout&&(this._unevaluatedLayout=new Vs(e.layout)),e.paint)){this._transitionablePaint=new Cs(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Fs(e.paint);}}setFilter(t){this.filter=t,this._featureFilter=hi(t);}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[e];for(const e of r.getGlobalStateRefs())t.add(e);}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}getPaintAffectingGlobalStateRefs(){var t;const e=new globalThis.Map;if(this._transitionablePaint)for(const r in this._transitionablePaint._values){const n=this._transitionablePaint._values[r].value;for(const i of n.getGlobalStateRefs()){const s=null!==(t=e.get(i))&&void 0!==t?t:[];s.push({name:r,value:n.value}),e.set(i,s);}}return e}setLayoutProperty(t,e,r={}){null!=e&&this._validate(rs,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return t.endsWith(js)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(es,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(t.endsWith(js))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.globalState=this._globalState,t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}setGlobalState(t){this._globalState=t,this._unevaluatedLayout&&this._unevaluatedLayout.setGlobalState(t);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),U(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&ns(this,t.call(Wi,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:xt,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Ts&&jn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const qs={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Gs{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class Xs{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function Zs(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=qs[t.type].BYTES_PER_ELEMENT,s=r=Ys(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:Ys(r,Math.max(n,e)),alignment:e}}function Ys(t,e){return Math.ceil(t/e)*e}class Hs extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}Hs.prototype.bytesPerElement=4,as("StructArrayLayout2i4",Hs);class Ks extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Ks.prototype.bytesPerElement=6,as("StructArrayLayout3i6",Ks);class Js extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}Js.prototype.bytesPerElement=8,as("StructArrayLayout4i8",Js);class Ws extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}Ws.prototype.bytesPerElement=12,as("StructArrayLayout2i4i12",Ws);class Qs extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=a,t}}Qs.prototype.bytesPerElement=8,as("StructArrayLayout2i4ub8",Qs);class ta extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}ta.prototype.bytesPerElement=8,as("StructArrayLayout2f8",ta);class ea extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}ea.prototype.bytesPerElement=20,as("StructArrayLayout10ui20",ea);class ra extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}ra.prototype.bytesPerElement=24,as("StructArrayLayout4i4ui4i24",ra);class na extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}na.prototype.bytesPerElement=12,as("StructArrayLayout3f12",na);class ia extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ia.prototype.bytesPerElement=4,as("StructArrayLayout1ul4",ia);class sa extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l)}emplace(t,e,r,n,i,s,a,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=a,this.uint32[h+3]=o,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}sa.prototype.bytesPerElement=20,as("StructArrayLayout6i1ul2ui20",sa);class aa extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}aa.prototype.bytesPerElement=12,as("StructArrayLayout2i2i2i12",aa);class oa extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}oa.prototype.bytesPerElement=16,as("StructArrayLayout2f1f2i16",oa);class la extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=16*t,l=4*t,u=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=a,t}}la.prototype.bytesPerElement=16,as("StructArrayLayout2ub2f2i16",la);class ua extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}ua.prototype.bytesPerElement=6,as("StructArrayLayout3ui6",ua);class ca extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}ca.prototype.bytesPerElement=48,as("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",ca);class ha extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I,z){const P=32*t,C=16*t;return this.int16[P+0]=e,this.int16[P+1]=r,this.int16[P+2]=n,this.int16[P+3]=i,this.int16[P+4]=s,this.int16[P+5]=a,this.int16[P+6]=o,this.int16[P+7]=l,this.uint16[P+8]=u,this.uint16[P+9]=c,this.uint16[P+10]=h,this.uint16[P+11]=p,this.uint16[P+12]=f,this.uint16[P+13]=d,this.uint16[P+14]=y,this.uint16[P+15]=m,this.uint16[P+16]=g,this.uint16[P+17]=x,this.uint16[P+18]=v,this.uint16[P+19]=b,this.uint16[P+20]=w,this.uint16[P+21]=_,this.uint16[P+22]=S,this.uint32[C+12]=A,this.float32[C+13]=k,this.float32[C+14]=M,this.uint16[P+30]=I,this.uint16[P+31]=z,t}}ha.prototype.bytesPerElement=64,as("StructArrayLayout8i15ui1ul2f2ui64",ha);class pa extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}pa.prototype.bytesPerElement=4,as("StructArrayLayout1f4",pa);class fa extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}fa.prototype.bytesPerElement=12,as("StructArrayLayout1ui2f12",fa);class da extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}da.prototype.bytesPerElement=8,as("StructArrayLayout1ul2ui8",da);class ya extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}ya.prototype.bytesPerElement=4,as("StructArrayLayout2ui4",ya);class ma extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}ma.prototype.bytesPerElement=2,as("StructArrayLayout1ui2",ma);class ga extends Xs{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}ga.prototype.bytesPerElement=16,as("StructArrayLayout4f16",ga);class xa extends Gs{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new r(this.anchorPointX,this.anchorPointY)}}xa.prototype.size=20;class va extends sa{get(t){return new xa(this,t)}}as("CollisionBoxArray",va);class ba extends Gs{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}ba.prototype.size=48;class wa extends ca{get(t){return new ba(this,t)}}as("PlacedSymbolArray",wa);class _a extends Gs{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}_a.prototype.size=64;class Sa extends ha{get(t){return new _a(this,t)}}as("SymbolInstanceArray",Sa);class Aa extends pa{getoffsetX(t){return this.float32[1*t+0]}}as("GlyphOffsetArray",Aa);class ka extends Ks{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}as("SymbolLineVertexArray",ka);class Ma extends Gs{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Ma.prototype.size=12;class Ia extends fa{get(t){return new Ma(this,t)}}as("TextAnchorOffsetArray",Ia);class za extends Gs{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}za.prototype.size=8;class Pa extends da{get(t){return new za(this,t)}}as("FeatureIndexArray",Pa);class Ca extends Hs{}class Ea extends Hs{}class Ba extends Hs{}class Va extends Ws{}class Ta extends Qs{}class Fa extends ta{}class La extends ea{}class $a extends ra{}class Oa extends na{}class Da extends ia{}class Ra extends aa{}class Ua extends la{}class ja extends ua{}class Na extends ya{}const qa=Zs([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ga}=qa;class Xa{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t;}prepareSegment(t,e,r,n){const i=this.segments[this.segments.length-1];return t>Xa.MAX_VERTEX_ARRAY_LENGTH&&q(`Max vertices per segment is ${Xa.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${Xa.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+t>Xa.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(e,r,n):i}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0;}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new Xa([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function Za(t,e){return 256*(t=L(Math.floor(t),0,255))+L(Math.floor(e),0,255)}Xa.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,as("SegmentVector",Xa);const Ya=Zs([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var Ha,Ka,Ja,Wa={exports:{}},Qa={exports:{}},to={exports:{}},eo=function(){if(Ja)return Wa.exports;Ja=1;var t=(Ha||(Ha=1,Qa.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),Qa.exports),e=(Ka||(Ka=1,to.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),to.exports);return Wa.exports=t,Wa.exports.murmur3=t,Wa.exports.murmur2=e,Wa.exports}(),ro=n(eo);class no{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(io(t)),this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=io(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return so(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new no;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function io(t){const e=+t;return !isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:ro(String(t))}function so(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;ao(t,s,a),ao(e,3*s,3*a),ao(e,3*s+1,3*a+1),ao(e,3*s+2,3*a+2);}a-r<n-a?(so(t,e,r,a),r=a+1):(so(t,e,a+1,n),n=a);}}function ao(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}as("FeaturePositionMap",no);class oo{constructor(t,e){this.gl=t.gl,this.location=e;}}class lo extends oo{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class uo extends oo{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class co extends oo{constructor(t,e){super(t,e),this.current=Me.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const ho=new Float32Array(16);function po(t){return [Za(255*t.r,255*t.g),Za(255*t.b,255*t.a)]}class fo{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new co(t,e):new lo(t,e)}}class yo{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new uo(t,e):new lo(t,e)}}class mo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r){const n=this.paintVertexArray.length,i=this.expression.evaluate(new Is(0,r),e,{},r.canonical,[],r.formattedSection);this.paintVertexArray.resize(t),this._setPaintValue(n,t,i);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Is(0,i),r,n);this._setPaintValue(t,e,s);}_setPaintValue(t,e,r){if("color"===this.type){const n=po(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class go{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r){const n=this.expression.evaluate(new Is(this.zoom,r),e,{},r.canonical,[],r.formattedSection),i=this.expression.evaluate(new Is(this.zoom+1,r),e,{},r.canonical,[],r.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(s,t,n,i);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Is(this.zoom,i),r,n),a=this.expression.evaluate(new Is(this.zoom+1,i),r,n);this._setPaintValue(t,e,s,a);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=po(r),s=po(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=L(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new lo(t,e)}}class xo{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r.imagePositions);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i.imagePositions);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:a}=r,o=n[i],l=n[s],u=n[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,Ya.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,Ya.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class vo{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof Ts&&jn(s.property.specification)))continue;const a=wo(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new yo(o.value,a):new fo(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=_o(i,l,"source");this.binders[i]=h?new xo(o,l,u,e,r,t.id):new mo(o,a,l,r),n.push(`/a_${i}`);}else {const t=_o(i,l,"composite");this.binders[i]=new go(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof mo||e instanceof go?e.maxValue:0}populatePaintArrays(t,e,r){for(const n in this.binders){const i=this.binders[n];(i instanceof mo||i instanceof go||i instanceof xo)&&i.populatePaintArray(t,e,r);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof yo&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof mo||l instanceof go||l instanceof xo)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof fo||r instanceof yo)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof mo||r instanceof go)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof xo)for(let e=0;e<Ya.members.length;e++)t.push(Ya.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof fo||r instanceof yo||r instanceof go)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof fo||i instanceof yo||i instanceof go)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof xo){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof mo||r instanceof go)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof mo||r instanceof go||r instanceof xo)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof mo||e instanceof go||e instanceof xo)&&e.destroy();}}}class bo{constructor(t,e,r=()=>!0){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new vo(n,e,r);this.needsUpload=!1,this._featureMap=new no,this._bufferOffset=0;}populatePaintArrays(t,e,r,n){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function wo(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function _o(t,e,r){const n={color:{source:ta,composite:ga},number:{source:pa,composite:ta}},i=function(t){return {"line-pattern":{source:La,composite:La},"fill-pattern":{source:La,composite:La},"fill-extrusion-pattern":{source:La,composite:La}}[t]}(t);return i&&i[r]||n[e][r]}as("ConstantBinder",fo),as("CrossFadedConstantBinder",yo),as("SourceExpressionBinder",mo),as("CrossFadedCompositeBinder",xo),as("CompositeExpressionBinder",go),as("ProgramConfiguration",vo,{omit:["_buffers"]}),as("ProgramConfigurationSet",bo);const So=Math.pow(2,14)-1,Ao=-So-1;function ko(t){const e=P/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=L(i,Ao,So),r.y=L(s,Ao,So),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&q("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function Mo(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?ko(t):[]}}const Io=-32768;function zo(t,e,r,n,i){t.emplaceBack(Io+8*e+n,Io+8*r+i);}class Po{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Ea,this.indexArray=new ja,this.segments=new Xa,this.programConfigurations=new bo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let s=null,a=!1,o="heatmap"===n.type;if("circle"===n.type){const t=n;s=t.layout.get("circle-sort-key"),a=!s.isConstant(),o=o||"map"===t.paint.get("circle-pitch-alignment");}const l=o?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Mo(e,t);if(!this.layers[0]._featureFilter.filter(new Is(this.zoom,{globalState:this.globalState}),u,r))continue;const c=a?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:ko(e),patterns:{},sortKey:c};i.push(h);}a&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r,l),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r,globalState:this.globalState});}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ga),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const a=s.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=P||n<0||n>=P)continue;const i=this.segments.prepareSegment(a*a,this.layoutVertexArray,this.indexArray,t.sortKey),o=i.vertexLength;for(let t=0;t<a;t++)for(let e=0;e<a;e++)zo(this.layoutVertexArray,r,n,s[e],s[t]);for(let t=0;t<a-1;t++)for(let e=0;e<a-1;e++){const r=o+t*a+e,n=o+(t+1)*a+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1);}i.vertexLength+=a*a,i.primitiveLength+=(a-1)*(a-1)*2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:{},canonical:n,globalState:this.globalState});}}function Co(t,e){for(let r=0;r<t.length;r++)if(Do(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Do(t,e[r]))return !0;return !!To(t,e)}function Eo(t,e,r){return !!Do(t,e)||!!Lo(e,t,r)}function Bo(t,e){if(1===t.length)return Oo(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Do(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Oo(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(To(t,e[r]))return !0;return !1}function Vo(t,e,r){if(t.length>1){if(To(t,e))return !0;for(let n=0;n<e.length;n++)if(Lo(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(Lo(t[n],e,r))return !0;return !1}function To(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Fo(n,i,e[t],e[t+1]))return !0}return !1}function Fo(t,e,r,n){return G(t,r,n)!==G(e,r,n)&&G(t,e,r)!==G(t,e,n)}function Lo(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if($o(t,e[r-1],e[r])<n)return !0;return !1}function $o(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Oo(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function Do(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function Ro(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=G(t,e,r[0]);return s!==G(t,e,r[1])||s!==G(t,e,r[2])||s!==G(t,e,r[3])}function Uo(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function jo(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function No(t,e,n,i,s){if(!e[0]&&!e[1])return t;const a=r.convert(e)._mult(s);"viewport"===n&&a._rotate(-i);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}let qo,Go;as("CircleBucket",Po,{omit:["layers"]});var Xo={get paint(){return Go=Go||new Us({"circle-radius":new $s(xt.paint_circle["circle-radius"]),"circle-color":new $s(xt.paint_circle["circle-color"]),"circle-blur":new $s(xt.paint_circle["circle-blur"]),"circle-opacity":new $s(xt.paint_circle["circle-opacity"]),"circle-translate":new Ls(xt.paint_circle["circle-translate"]),"circle-translate-anchor":new Ls(xt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Ls(xt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Ls(xt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new $s(xt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new $s(xt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new $s(xt.paint_circle["circle-stroke-opacity"])})},get layout(){return qo=qo||new Us({"circle-sort-key":new $s(xt.layout_circle["circle-sort-key"])})}};class Zo extends Ns{constructor(t){super(t,Xo);}createBucket(t){return new Po(t)}queryRadius(t){const e=t;return Uo("circle-radius",this,e)+Uo("circle-stroke-width",this,e)+jo(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}){const l=No(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c="map"===this.paint.get("circle-pitch-alignment"),h=c?l:function(t,e,r,n){return t.map((t=>Yo(t,e,r,n)))}(l,i,a,o),p=c?u*s:u;for(const t of n)for(const e of t){const t=c?e:Yo(e,i,a,o);let r=p;const n=i.projectTileCoordinates(e.x,e.y,a,o).signedDistanceFromCamera;if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n/i.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=i.cameraToCenterDistance/n),Eo(h,t,r))return !0}return !1}}function Yo(t,e,n,i){const s=e.projectTileCoordinates(t.x,t.y,n,i).point;return new r((.5*s.x+.5)*e.width,(.5*-s.y+.5)*e.height)}class Ho extends Po{}let Ko;as("HeatmapBucket",Ho,{omit:["layers"]});var Jo={get paint(){return Ko=Ko||new Us({"heatmap-radius":new $s(xt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new $s(xt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Ls(xt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Rs(xt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Ls(xt.paint_heatmap["heatmap-opacity"])})}};function Wo(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function Qo(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=Wo({},{width:e,height:r},n);tl(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function tl(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}class el{constructor(t,e){Wo(this,t,1,e);}resize(t){Qo(this,t,1);}clone(){return new el({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){tl(t,e,r,n,i,1);}}class rl{constructor(t,e){Wo(this,t,4,e);}resize(t){Qo(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new rl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){tl(t,e,r,n,i,4);}setPixel(t,e,r){const n=4*(t*this.width+e);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a);}}function nl(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new rl({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,a)=>{e[t.evaluationKey]=a;const o=t.expression.evaluate(e);i.setPixel(n/4/r,s/4,o);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}as("AlphaImage",el),as("RGBAImage",rl);const il="big-fb";class sl extends Ns{createBucket(t){return new Ho(t)}constructor(t){super(t,Jo),this.heatmapFbos=new Map,this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=nl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbos.has(il)&&this.heatmapFbos.delete(il);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let al;var ol={get paint(){return al=al||new Us({"hillshade-illumination-direction":new Ls(xt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new Ls(xt.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new Ls(xt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Ls(xt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Ls(xt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Ls(xt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Ls(xt.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new Ls(xt.paint_hillshade["hillshade-method"])})}};class ll extends Ns{constructor(t){super(t,ol),this.recalculate({zoom:0,zoomHistory:{}},void 0);}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(t.length,e.length,r.length,n.length);t=t.concat(Array(i-t.length).fill(t.at(-1))),e=e.concat(Array(i-e.length).fill(e.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=e.map(tt);return {directionRadians:t.map(tt),altitudeRadians:s,shadowColor:n,highlightColor:r}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let ul;var cl={get paint(){return ul=ul||new Us({"color-relief-opacity":new Ls(xt["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new Rs(xt["paint_color-relief"]["color-relief-color"])})}};class hl{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Y(t)?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,n,i,0,this.format,o.UNSIGNED_BYTE,t.data);else {const{x:e,y:s}=r||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Y(t)?o.texSubImage2D(o.TEXTURE_2D,0,e,s,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,s,n,i,o.RGBA,o.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D),a.pixelStoreUnpackFlipY.setDefault(),a.pixelStoreUnpack.setDefault(),a.pixelStoreUnpackPremultiplyAlpha.setDefault();}bind(t,e,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),t!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class pl{constructor(t,e,r,n=1,i=1,s=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void q(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case "terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case "custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return [this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}pack(t){return fl(t,this.getUnpackVector())}getPixels(){return new rl({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case -1:n=i-1;break;case 1:i=n+1;}switch(r){case -1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}function fl(t,e){const r=e[0],n=e[1],i=e[2],s=e[3],a=Math.min(r,n,i),o=Math.round((t+s)/a);return {r:Math.floor(o*a/r)%256,g:Math.floor(o*a/n)%256,b:Math.floor(o*a/i)%256}}as("DEMData",pl);class dl extends Ns{constructor(t){super(t,cl);}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof ni&&r._styleExpression.expression instanceof pr){this.colorRampExpression=r;const t=r._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const r of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:r}}));}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[Me.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const n={elevationStops:[],colorStops:[]},i=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=i)n.elevationStops.push(e.elevationStops[Math.round(t)]),n.colorStops.push(e.colorStops[Math.round(t)]);return q(`Too many colors in specification of ${this.id} color-relief layer, may not render properly.`),n}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(e),i=new rl({width:n.colorStops.length,height:1}),s=new rl({width:n.colorStops.length,height:1});for(let t=0;t<n.elevationStops.length;t++){const e=fl(n.elevationStops[t],r);s.setPixel(0,t,new Me(e.r/255,e.g/255,e.b/255,1)),i.setPixel(0,t,n.colorStops[t]);}return this.colorRampTextures={elevationTexture:new hl(t,s,t.gl.RGBA),colorTexture:new hl(t,i,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return "none"!==this.visibility&&!!this.colorRampTextures}}const yl=Zs([{name:"a_pos",components:2,type:"Int16"}],4),{members:ml}=yl;function gl(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function xl(t,e,r,n,i){const{zoom:s,globalState:a}=n,o=i.patternDependencies;for(const n of e){const e=n.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:s-1,globalState:a},r,{},i.availableImages),l=e.evaluate({zoom:s,globalState:a},r,{},i.availableImages),u=e.evaluate({zoom:s+1,globalState:a},r,{},i.availableImages);t=t&&t.name?t.name:t,l=l&&l.name?l.name:l,u=u&&u.name?u.name:u,o[t]=!0,o[l]=!0,o[u]=!0,r.patterns[n.id]={min:t,mid:l,max:u};}}return r}function vl(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=Ul(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=Ul(i/n|0,t[i],t[i+1],s);return s&&Fl(s,s.next)&&(jl(s),s=s.next),s}function bl(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Fl(n,n.next)&&0!==Tl(n.prev,n,n.next))n=n.next;else {if(jl(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function wl(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Pl(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Sl(t,n,i,s):_l(t))e.push(l.i,t.i,u.i),jl(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?wl(t=Al(bl(t),e),e,r,n,i,s,2):2===a&&kl(t,e,r,n,i,s):wl(bl(t),e,r,n,i,s,1);break}}}function _l(t){const e=t.prev,r=t,n=t.next;if(Tl(e,r,n)>=0)return !1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=Math.min(i,s,a),h=Math.min(o,l,u),p=Math.max(i,s,a),f=Math.max(o,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Bl(i,o,s,l,a,u,d.x,d.y)&&Tl(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Sl(t,e,r,n){const i=t.prev,s=t,a=t.next;if(Tl(i,s,a)>=0)return !1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=Math.min(o,l,u),d=Math.min(c,h,p),y=Math.max(o,l,u),m=Math.max(c,h,p),g=Pl(f,d,e,r,n),x=Pl(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&Bl(o,c,l,h,u,p,v.x,v.y)&&Tl(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&Bl(o,c,l,h,u,p,b.x,b.y)&&Tl(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&Bl(o,c,l,h,u,p,v.x,v.y)&&Tl(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&Bl(o,c,l,h,u,p,b.x,b.y)&&Tl(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Al(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Fl(n,i)&&Ll(n,r,r.next,i)&&Dl(n,i)&&Dl(i,n)&&(e.push(n.i,r.i,i.i),jl(r),jl(r.next),r=t=i),r=r.next;}while(r!==t);return bl(r)}function kl(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&Vl(a,t)){let o=Rl(a,t);return a=bl(a,a.next),o=bl(o,o.next),wl(a,e,r,n,i,s,0),void wl(o,e,r,n,i,s,0)}t=t.next;}a=a.next;}while(a!==t)}function Ml(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Il(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;if(Fl(t,r))return r;do{if(Fl(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&El(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);Dl(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&zl(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s}(t,e);if(!r)return e;const n=Rl(r,t);return bl(n,n.next),bl(r,r.next)}function zl(t,e){return Tl(t.prev,t,e.prev)<0&&Tl(e.next,t,t.next)<0}function Pl(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Cl(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function El(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function Bl(t,e,r,n,i,s,a,o){return !(t===a&&e===o)&&El(t,e,r,n,i,s,a,o)}function Vl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Ll(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Dl(t,e)&&Dl(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Tl(t.prev,t,e.prev)||Tl(t,e.prev,e))||Fl(t,e)&&Tl(t.prev,t,t.next)>0&&Tl(e.prev,e,e.next)>0)}function Tl(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Fl(t,e){return t.x===e.x&&t.y===e.y}function Ll(t,e,r,n){const i=Ol(Tl(t,e,r)),s=Ol(Tl(t,e,n)),a=Ol(Tl(r,n,t)),o=Ol(Tl(r,n,e));return i!==s&&a!==o||!(0!==i||!$l(t,r,e))||!(0!==s||!$l(t,n,e))||!(0!==a||!$l(r,t,n))||!(0!==o||!$l(r,e,n))}function $l(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Ol(t){return t>0?1:t<0?-1:0}function Dl(t,e){return Tl(t.prev,t,t.next)<0?Tl(t,e,t.next)>=0&&Tl(t,t.prev,e)>=0:Tl(t,e,t.prev)<0||Tl(t,t.next,e)<0}function Rl(t,e){const r=Nl(t.i,t.x,t.y),n=Nl(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function Ul(t,e,r,n){const i=Nl(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function jl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function Nl(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class ql{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e;}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class Gl{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle;}}Gl.noSubdivision=new Gl({fill:new ql(0,0),line:new ql(0,0),tile:new ql(0,0),stencil:new ql(0,0),circle:1}),as("SubdivisionGranularityExpression",ql),as("SubdivisionGranularitySetting",Gl);const Xl=-32768,Zl=32767;class Yl{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=P/t,this._canonical=e;}_getKey(t,e){return (t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const i=e[n],s=e[n+1],a=e[n+2],o=t[2*i],l=t[2*i+1];(t[2*s]-o)*(t[2*a+1]-l)-(t[2*s+1]-l)*(t[2*a]-o)>0?(r.push(i),r.push(a),r.push(s)):(r.push(i),r.push(s),r.push(a));}return r}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],i=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let s=1/0,a=1/0,o=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=i[2*t],r=i[2*t+1];s=Math.min(s,e),o=Math.max(o,e),a=Math.min(a,r),l=Math.max(l,r);}if(s===o||a===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(o/this._granularityCellSize),h=Math.floor(a/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let t=h;t<p;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,i,r);Jl(this._vertexBuffer,n,e);}else e.push(...r);}return e}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const a=e[2*t],o=e[2*t+1],l=e[2*(t+1)%6],u=e[(2*(t+1)+1)%6],c=e[2*(t+2)%6],h=e[(2*(t+2)+1)%6],p=l-a,f=u-o,d=0===p,y=0===f,m=(n-o)/f,g=(i-o)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(o<n||o>i)){u>=n&&u<=i&&s.push(r[(t+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(a+p*x,o+f*x));const b=a+p*Math.max(x,0),w=a+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,a,o,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(a+p*v,o+f*v)),(y||u>=n&&u<=i)&&s.push(r[(t+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,a,o,l,u,c,h,w,n,i);}return s}_generateIntraEdgeVertices(t,e,r,n,i,s,a){const o=n-e,l=i-r,u=0===l,c=u?Math.min(e,n):Math.min(s,a),h=u?Math.max(e,n):Math.max(s,a),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?e<n:s<a)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}}_generateInterEdgeVertices(t,e,r,n,i,s,a,o,l,u){const c=i-r,h=s-n,p=a-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,o)/this._granularityCellSize)-1,b=o<g;const w=0===p;if(w&&(a===l||a===u))return;if(w||y>=1||m<=0){const t=r-a,n=s+(e-s)*Math.min((l-a)/t,(u-a)/t);x=Math.floor(Math.min(n,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,o)/this._granularityCellSize)-1,b=o<n;}const _=c>0?u:l;if(b)for(let e=x;e<=v;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,_));else for(let e=v;e>=x;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,_));}_generateOutline(t){const e=[];for(const r of t){const t=Kl(r,this._granularity,!0),n=this._pointArrayToIndices(t),i=[];for(let t=1;t<n.length;t++)i.push(n[t-1]),i.push(n[t]);e.push(i);}return e}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r);}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===Xl&&(t[e+1]=-32767),r===Zl&&(t[e+1]=32766);}}_generatePoleQuad(t,e,r,n,i,s){n>i!=(s===Xl)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,s)),t.push(r),t.push(this._vertexToIndex(i,s)),t.push(this._vertexToIndex(n,s))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(i,s)),t.push(r),t.push(this._vertexToIndex(n,s)));}_fillPoles(t,e,r){const n=this._vertexBuffer,i=P,s=t.length;for(let a=2;a<s;a+=3){const s=t[a-2],o=t[a-1],l=t[a],u=n[2*s],c=n[2*s+1],h=n[2*o],p=n[2*o+1],f=n[2*l],d=n[2*l+1];e&&(0===c&&0===p&&this._generatePoleQuad(t,s,o,u,h,Xl),0===p&&0===d&&this._generatePoleQuad(t,o,l,h,f,Xl),0===d&&0===c&&this._generatePoleQuad(t,l,s,f,u,Xl)),r&&(c===i&&p===i&&this._generatePoleQuad(t,s,o,u,h,Zl),p===i&&d===i&&this._generatePoleQuad(t,o,l,h,f,Zl),d===i&&c===i&&this._generatePoleQuad(t,l,s,f,u,Zl));}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1]);}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y);}return {flattened:r,holeIndices:e}}(t);let i;this._initializeVertices(r);try{const t=function(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=vl(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=vl(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(Cl(a));}i.sort(Ml);for(let t=0;t<i.length;t++)r=Il(i[t],r);return r}(t,e,s,r)),t.length>80*r){o=t[0],l=t[1];let e=o,n=l;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return wl(s,a,r,o,l,u,0),a}(r,n),e=this._convertIndices(r,t);i=this._subdivideTrianglesScanline(e);}catch(t){console.error(t);}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y));}return e}}function Hl(t,e,r,n=!0){return new Yl(r,e).subdividePolygonInternal(t,n)}function Kl(t,e,n=!1){if(!t||t.length<1)return [];if(t.length<2)return [];const i=t[0],s=t[t.length-1],a=n&&(i.x!==s.x||i.y!==s.y);if(e<2)return a?[...t,t[0]]:[...t];const o=Math.floor(P/e),l=[];l.push(new r(t[0].x,t[0].y));const u=t.length,c=a?u:u-1;for(let e=0;e<c;e++){const n=t[e],i=e<u-1?t[e+1]:t[0],s=n.x,a=n.y,c=i.x,h=i.y,p=s!==c,f=a!==h;if(!p&&!f)continue;const d=c-s,y=h-a,m=Math.abs(d),g=Math.abs(y);let x=s,v=a;for(;;){const t=d>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,e=y>0?(Math.floor(v/o)+1)*o:(Math.ceil(v/o)-1)*o,n=Math.abs(x-t),i=Math.abs(v-e),s=Math.abs(x-c),a=Math.abs(v-h),u=p?n/m:Number.POSITIVE_INFINITY,b=f?i/g:Number.POSITIVE_INFINITY;if((s<=n||!p)&&(a<=i||!f))break;if(u<b&&p||!f){x=t,v+=y*u;const e=new r(x,Math.round(v));l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e);}else {x+=d*b,v=e;const t=new r(Math.round(x),v);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t);}}const b=new r(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b);}return l}function Jl(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=t[2*e[0]];for(let r=1;r<e.length;r++){const s=t[2*e[r]];s<i&&(i=s,n=r);}const s=e.length;let a=n,o=(a+1)%s;for(;;){const n=a-1>=0?a-1:s-1,i=(o+1)%s,l=t[2*e[n]],u=t[2*e[i]],c=t[2*e[a]],h=t[2*e[a]+1],p=t[2*e[o]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else {const r=p-h,s=-(t[2*e[o]]-c),a=h<p?1:-1;((l-c)*r+(t[2*e[n]+1]-h)*s)*a>((u-c)*r+(t[2*e[i]+1]-h)*s)*a&&(f=!0);}if(f){const t=e[n],i=e[a],l=e[o];t!==i&&t!==l&&i!==l&&r.push(l,i,t),a--,a<0&&(a=s-1);}else {const t=e[i],n=e[a],l=e[o];t!==n&&t!==l&&n!==l&&r.push(l,n,t),o++,o>=s&&(o=0);}if(n===i)break}}function Wl(t,e,r,n,i,s,a,o,l){const u=i.length/2,c=a&&o&&l;if(u<Xa.MAX_VERTEX_ARRAY_LENGTH){const h=e.prepareSegment(u,r,n),p=h.vertexLength;for(let t=0;t<s.length;t+=3)n.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=a.prepareSegment(u,r,o),f=d.vertexLength,d.vertexLength+=u);for(let e=0;e<i.length;e+=2)t(i[e],i[e+1]);if(c)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)o.emplaceBack(f+e[t-1],f+e[t]);d.primitiveLength+=e.length/2;}}else !function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=a[p]<l,m=a[f]<l,g=a[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>Xa.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,y=!0,m=!0,g=!0,c=0);const x=Ql(a,n,s,o,p,y,u),v=Ql(a,n,s,o,f,m,u),b=Ql(a,n,s,o,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++;}}(e,r,n,i,s,t),c&&function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=a[i]<l,y=a[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>Xa.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,d=!0,y=!0,c=0);const m=Ql(a,n,s,o,i,d,u),g=Ql(a,n,s,o,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++;}}}(a,r,o,i,l,t),e.forceNewSegmentOnNextPrepare(),null==a||a.forceNewSegmentOnNextPrepare();}function Ql(t,e,r,n,i,s,a){if(s){const s=n.count;return r(e[2*i],e[2*i+1]),t[i]=n.count,n.count++,a.vertexLength++,s}return t[i]}class tu{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Ba,this.indexArray=new ja,this.indexArray2=new Na,this.programConfigurations=new bo(t.layers,t.zoom),this.segments=new Xa,this.segments2=new Xa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=gl("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Mo(a,t);if(!this.layers[0]._featureFilter.filter(new Is(this.zoom,{globalState:this.globalState}),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:ko(a),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=xl("fill",this.layers,n,{zoom:this.zoom,globalState:this.globalState},e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r,globalState:this.globalState});}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ml),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s){for(const t of Qr(e,500)){const e=Hl(t,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;Wl(((t,e)=>{r.emplaceBack(t,e);}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n,globalState:this.globalState});}}let eu,ru;as("FillBucket",tu,{omit:["layers","patternFeatures"]});var nu={get paint(){return ru=ru||new Us({"fill-antialias":new Ls(xt.paint_fill["fill-antialias"]),"fill-opacity":new $s(xt.paint_fill["fill-opacity"]),"fill-color":new $s(xt.paint_fill["fill-color"]),"fill-outline-color":new $s(xt.paint_fill["fill-outline-color"]),"fill-translate":new Ls(xt.paint_fill["fill-translate"]),"fill-translate-anchor":new Ls(xt.paint_fill["fill-translate-anchor"]),"fill-pattern":new Os(xt.paint_fill["fill-pattern"])})},get layout(){return eu=eu||new Us({"fill-sort-key":new $s(xt.layout_fill["fill-sort-key"])})}};class iu extends Ns{constructor(t){super(t,nu);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new tu(t)}queryRadius(){return jo(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}){return Bo(No(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e)}isTileClipped(){return !0}}const su=Zs([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),au=Zs([{name:"a_centroid",components:2,type:"Int16"}],4),{members:ou}=su;class lu{constructor(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(uu,this,e);}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos,n=[];let i,s=1,a=0,o=0,l=0;for(;t.pos<e;){if(a<=0){const e=t.readVarint();s=7&e,a=e>>3;}if(a--,1===s||2===s)o+=t.readSVarint(),l+=t.readSVarint(),1===s&&(i&&n.push(i),i=[]),i&&i.push(new r(o,l));else {if(7!==s)throw new Error(`unknown command ${s}`);i&&i.push(i[0].clone());}}return i&&n.push(i),n}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;for(;t.pos<e;){if(n<=0){const e=t.readVarint();r=7&e,n=e>>3;}if(n--,1===r||2===r)i+=t.readSVarint(),s+=t.readSVarint(),i<a&&(a=i),i>o&&(o=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`)}return [a,l,o,u]}toGeoJSON(t,e,r){const n=this.extent*Math.pow(2,r),i=this.extent*t,s=this.extent*e,a=this.loadGeometry();function o(t){return [360*(t.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+s)/n)*Math.PI))-90]}function l(t){return t.map(o)}let u;if(1===this.type){const t=[];for(const e of a)t.push(e[0]);const e=l(t);u=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e};}else if(2===this.type){const t=a.map(l);u=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t};}else {if(3!==this.type)throw new Error("unknown feature type");{const t=function(t){const e=t.length;if(e<=1)return [t];const r=[];let n,i;for(let s=0;s<e;s++){const e=cu(t[s]);0!==e&&(void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t[s]]):n&&n.push(t[s]));}return n&&r.push(n),r}(a),e=[];for(const r of t)e.push(r.map(l));u=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e};}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c}}function uu(t,e,r){1===t?e.id=r.readVarint():2===t?function(t,e){const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n;}}(r,e):3===t?e.type=r.readVarint():4===t&&(e._geometry=r.pos);}function cu(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}lu.types=["Unknown","Point","LineString","Polygon"];class hu{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(pu,this,e),this.length=this._features.length;}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new lu(this._pbf,e,this.extent,this._keys,this._values)}}function pu(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){let e=null;const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null;}if(null==e)throw new Error("unknown feature value");return e}(r));}class fu{constructor(t,e){this.layers=t.readFields(du,{},e);}}function du(t,e,r){if(3===t){const t=new hu(r,r.readVarint()+r.pos);t.length&&(e[t.name]=t);}}const yu=Math.pow(2,13);function mu(t,e,r,n,i,s,a,o){t.emplaceBack(e,r,2*Math.floor(n*yu)+a,i*yu*2,s*yu*2,Math.round(o));}class gu{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new Va,this.centroidVertexArray=new Ca,this.indexArray=new ja,this.programConfigurations=new bo(t.layers,t.zoom),this.segments=new Xa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.features=[],this.hasPattern=gl("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=Mo(n,t);if(!this.layers[0]._featureFilter.filter(new Is(this.zoom,{globalState:this.globalState}),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:ko(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(xl("fill-extrusion",this.layers,l,{zoom:this.zoom,globalState:this.globalState},e)):this.addFeature(l,l.geometry,s,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,l.geometry,s,a,this.index,!0);}}addFeatures(t,e,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,e,r,t.subdivisionGranularity);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r,globalState:this.globalState});}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ou),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,au.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i,s){for(const r of Qr(e,500)){const e={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,s);const a=this.layoutVertexArray.length-i,o=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<a;t++)this.centroidVertexArray.emplaceBack(o,l);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n,globalState:this.globalState});}processPolygon(t,e,r,n,i){if(n.length<1)return;if(bu(n[0]))return;for(const e of n)0!==e.length&&xu(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},a=i.fill.getGranularityForZoomLevel(e.z),o="Polygon"===lu.types[r.type];for(const t of n){if(0===t.length)continue;if(bu(t))continue;const e=Kl(t,a,o);this._generateSideFaces(e,s);}if(!o)return;const l=Hl(n,e,a,!1),u=this.layoutVertexArray;Wl(((t,e)=>{mu(u,t,e,0,0,1,1,0);}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles);}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const i=t[n],s=t[n-1];if(vu(i,s))continue;e.segment.vertexLength+4>Xa.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const a=i.sub(s)._perp()._unit(),o=s.dist(i);r+o>32768&&(r=0),mu(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,0,r),mu(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,1,r),r+=o,mu(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,0,r),mu(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,1,r);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2;}}}function xu(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++);}}function vu(t,e){return t.x===e.x&&(t.x<0||t.x>P)||t.y===e.y&&(t.y<0||t.y>P)}function bu(t){return t.every((t=>t.x<0))||t.every((t=>t.x>P))||t.every((t=>t.y<0))||t.every((t=>t.y>P))}let wu;as("FillExtrusionBucket",gu,{omit:["layers","features"]});var _u={get paint(){return wu=wu||new Us({"fill-extrusion-opacity":new Ls(xt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new $s(xt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Ls(xt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Ls(xt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Os(xt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new $s(xt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new $s(xt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Ls(xt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Su extends Ns{constructor(t){super(t,_u);}createBucket(t){return new gu(t)}queryRadius(){return jo(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:n,geometry:i,transform:s,pixelsToTileUnits:a,pixelPosMatrix:o}){const l=No(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,a),u=this.paint.get("fill-extrusion-height").evaluate(e,n),c=this.paint.get("fill-extrusion-base").evaluate(e,n),h=function(t,e){const n=[];for(const i of t){const t=[i.x,i.y,0,1];A(t,t,e),n.push(new r(t[0]/t[3],t[1]/t[3]));}return n}(l,o),p=function(t,e,n,i){const s=[],a=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*n,p=i[9]*n,f=i[10]*n,d=i[11]*n;for(const e of t){const t=[],n=[];for(const s of e){const e=s.x,a=s.y,y=i[0]*e+i[4]*a+i[12],m=i[1]*e+i[5]*a+i[13],g=i[2]*e+i[6]*a+i[14],x=i[3]*e+i[7]*a+i[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,A=x+d,k=new r((y+o)/b,(m+l)/b);k.z=v/b,t.push(k);const M=new r(w/A,_/A);M.z=S/A,n.push(M);}s.push(t),a.push(n);}return [s,a]}(i,c,u,o);return function(t,e,r){let n=1/0;Bo(r,e)&&(n=ku(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];Co(r,i)&&(n=Math.min(n,ku(r,i)));}}return n!==1/0&&n}(p[0],p[1],h)}}function Au(t,e){return t.x*e.x+t.y*e.y}function ku(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Au(o,o),h=Au(o,l),p=Au(l,l),f=Au(u,o),d=Au(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const Mu=Zs([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:Iu}=Mu,zu=Zs([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Pu}=zu,Cu=Math.cos(Math.PI/180*37.5),Eu=Math.pow(2,14)/.5;class Bu{constructor(t){this.zoom=t.zoom,this.globalState=t.globalState,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new Ta,this.layoutVertexArray2=new Fa,this.indexArray=new ja,this.programConfigurations=new bo(t.layers,t.zoom),this.segments=new Xa,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=gl("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Mo(e,t);if(!this.layers[0]._featureFilter.filter(new Is(this.zoom,{globalState:this.globalState}),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:ko(e),patterns:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=xl("line",this.layers,n,{zoom:this.zoom,globalState:this.globalState},e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r,globalState:this.globalState});}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Pu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Iu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s){const a=this.layers[0].layout,o=a.get("line-join").evaluate(t,{}),l=a.get("line-cap"),u=a.get("line-miter-limit"),c=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,o,l,u,c,n,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n,globalState:this.globalState});}addLine(t,e,r,n,i,s,a,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=Kl(t,a?o.line.getGranularityForZoomLevel(a.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===lu.types[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=t[u-2],g=t[c].sub(f)._unit()._perp());for(let e=c;e<u;e++){if(y=e===u-1?l?t[c+1]:void 0:t[e+1],y&&t[e].equals(y))continue;g&&(m=g),f&&(d=f),f=t[e],g=y?y.sub(f)._unit()._perp():m,m=m||g;let a=m.add(g);0===a.x&&0===a.y||a._unit();const o=m.x*g.x+m.y*g.y,x=a.x*g.x+a.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Cu&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&e>c){const t=f.dist(d);if(t>2*h){const e=f.sub(f.sub(d)._mult(h/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,m,0,0,p),d=e;}}const S=d&&y;let A=S?r:l?"butt":n;if(S&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),d&&this.updateDistance(d,f),"miter"===A)a._mult(v),this.addCurrentVertex(f,a,0,0,p);else if("flipbevel"===A){if(v>100)a=g.mult(-1);else {const t=v*m.add(g).mag()/m.sub(g).mag();a._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(f,a,0,0,p),this.addCurrentVertex(f,a.mult(-1),0,0,p);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(d&&this.addCurrentVertex(f,m,e,r,p),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+o*(o*(3.55645-1.43519*o)-3.2452))*t*t+(.848013+o*(.215638*o-1.06021)));}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p);}}y&&this.addCurrentVertex(f,g,-e,-r,p);}else if("butt"===A)this.addCurrentVertex(f,a,0,0,p);else if("square"===A){const t=d?1:-1;this.addCurrentVertex(f,a,t,t,p);}else "round"===A&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&e<u-1){const t=f.dist(y);if(t>2*h){const e=f.add(y.sub(f)._mult(h/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,g,0,0,p),f=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i),this.distance>Eu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s));}addHalfVertex({x:t,y:e},r,n,i,s,a,o){const l=.5*(this.lineClips?this.scaledDistance*(Eu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),o.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}let Vu,Tu;as("LineBucket",Bu,{omit:["layers","patternFeatures"]});var Fu={get paint(){return Tu=Tu||new Us({"line-opacity":new $s(xt.paint_line["line-opacity"]),"line-color":new $s(xt.paint_line["line-color"]),"line-translate":new Ls(xt.paint_line["line-translate"]),"line-translate-anchor":new Ls(xt.paint_line["line-translate-anchor"]),"line-width":new $s(xt.paint_line["line-width"]),"line-gap-width":new $s(xt.paint_line["line-gap-width"]),"line-offset":new $s(xt.paint_line["line-offset"]),"line-blur":new $s(xt.paint_line["line-blur"]),"line-dasharray":new Ds(xt.paint_line["line-dasharray"]),"line-pattern":new Os(xt.paint_line["line-pattern"]),"line-gradient":new Rs(xt.paint_line["line-gradient"])})},get layout(){return Vu=Vu||new Us({"line-cap":new Ls(xt.layout_line["line-cap"]),"line-join":new $s(xt.layout_line["line-join"]),"line-miter-limit":new Ls(xt.layout_line["line-miter-limit"]),"line-round-limit":new Ls(xt.layout_line["line-round-limit"]),"line-sort-key":new $s(xt.layout_line["line-sort-key"])})}};class Lu extends $s{possiblyEvaluate(t,e){return e=new Is(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=O({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let $u;class Ou extends Ns{constructor(t){super(t,Fu),this.gradientVersion=0,$u||($u=new Lu(Fu.paint.properties["line-width"].specification),$u.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof ar,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=$u.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new Bu(t)}queryRadius(t){const e=t,r=Du(Uo("line-width",this,e),Uo("line-gap-width",this,e)),n=Uo("line-offset",this,e);return r/2+Math.abs(n)+jo(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:n,geometry:i,transform:s,pixelsToTileUnits:a}){const o=No(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,a),l=a/2*Du(this.paint.get("line-width").evaluate(e,n),this.paint.get("line-gap-width").evaluate(e,n)),u=this.paint.get("line-offset").evaluate(e,n);return u&&(i=function(t,e){const n=[];for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const n=s[t-1],i=s[t],o=s[t+1],l=0===t?new r(0,0):i.sub(n)._unit()._perp(),u=t===s.length-1?new r(0,0):o.sub(i)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),a.push(c._mult(e)._add(i));}n.push(a);}return n}(i,u*a)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Do(t,i[e]))return !0;if(Vo(t,i,r))return !0}return !1}(o,i,l)}isTileClipped(){return !0}}function Du(t,e){return e>0?e+2*t:t}const Ru=Zs([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Uu=Zs([{name:"a_projected_pos",components:3,type:"Float32"}],4);Zs([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const ju=Zs([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);Zs([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Nu=Zs([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),qu=Zs([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function Gu(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Ms.applyArabicShaping&&(t=Ms.applyArabicShaping(t)),t}(t.text,e,r);})),t}Zs([{name:"triangle",components:3,type:"Uint16"}]),Zs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),Zs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),Zs([{type:"Float32",name:"offsetX"}]),Zs([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),Zs([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const Xu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var Zu=24;const Yu=4294967296,Hu=1/Yu,Ku="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class Ju{constructor(t=new Uint8Array(16)){this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length;}readFields(t,e,r=this.length){for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,t(n,e,this),this.pos===i&&this.skip(r);}return e}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos)}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*Yu;return this.pos+=8,t}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*Yu;return this.pos+=8,t}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t}readVarint(t){const e=this.buf;let r,n;return n=e[this.pos++],r=127&n,n<128?r:(n=e[this.pos++],r|=(127&n)<<7,n<128?r:(n=e[this.pos++],r|=(127&n)<<14,n<128?r:(n=e[this.pos++],r|=(127&n)<<21,n<128?r:(n=e[this.pos],r|=(15&n)<<28,function(t,e,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return Wu(t,i,e);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return Wu(t,i,e);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return Wu(t,i,e);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return Wu(t,i,e);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return Wu(t,i,e);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return Wu(t,i,e);throw new Error("Expected varint not more than 10 bytes")}(r,t,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2}readBoolean(){return Boolean(this.readVarint())}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Ku?Ku.decode(this.buf.subarray(e,t)):function(t,e,r){let n="",i=e;for(;i<r;){const e=t[i];let s,a,o,l=null,u=e>239?4:e>223?3:e>191?2:1;if(i+u>r)break;1===u?e<128&&(l=e):2===u?(s=t[i+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===u?(s=t[i+1],a=t[i+2],128==(192&s)&&128==(192&a)&&(l=(15&e)<<12|(63&s)<<6|63&a,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=t[i+1],a=t[i+2],o=t[i+3],128==(192&s)&&128==(192&a)&&128==(192&o)&&(l=(15&e)<<18|(63&s)<<12|(63&a)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n}(this.buf,e,t)}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e}readPackedVarint(t=[],e){const r=this.readPackedEnd();for(;this.pos<r;)t.push(this.readVarint(e));return t}readPackedSVarint(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t}readPackedBoolean(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t}readPackedFloat(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t}readPackedDouble(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t}readPackedFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t}readPackedSFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t}readPackedFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t}readPackedSFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else {if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8;}}writeTag(t,e){this.writeVarint(t<<3|e);}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e;}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*Hu),!0),this.pos+=8;}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*Hu),!0),this.pos+=8;}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(r=~(-t%4294967296),n=~(-t/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){const r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t);}writeBoolean(t){this.writeVarint(+t);}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,r){for(let n,i,s=0;s<e.length;s++){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);const r=this.pos-e;r>=128&&Qu(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4;}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8;}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let r=0;r<e;r++)this.buf[this.pos++]=t[r];}writeRawMessage(t,e){this.pos++;const r=this.pos;t(e,this);const n=this.pos-r;n>=128&&Qu(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;}writeMessage(t,e,r){this.writeTag(t,2),this.writeRawMessage(e,r);}writePackedVarint(t,e){e.length&&this.writeMessage(t,tc,e);}writePackedSVarint(t,e){e.length&&this.writeMessage(t,ec,e);}writePackedBoolean(t,e){e.length&&this.writeMessage(t,ic,e);}writePackedFloat(t,e){e.length&&this.writeMessage(t,rc,e);}writePackedDouble(t,e){e.length&&this.writeMessage(t,nc,e);}writePackedFixed32(t,e){e.length&&this.writeMessage(t,sc,e);}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,ac,e);}writePackedFixed64(t,e){e.length&&this.writeMessage(t,oc,e);}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,lc,e);}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e);}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e);}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e);}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e);}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e);}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e);}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e);}writeStringField(t,e){this.writeTag(t,2),this.writeString(e);}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e);}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e);}writeBooleanField(t,e){this.writeVarintField(t,+e);}}function Wu(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Qu(t,e,r){const n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(let e=r.pos-1;e>=t;e--)r.buf[e+n]=r.buf[e];}function tc(t,e){for(let r=0;r<t.length;r++)e.writeVarint(t[r]);}function ec(t,e){for(let r=0;r<t.length;r++)e.writeSVarint(t[r]);}function rc(t,e){for(let r=0;r<t.length;r++)e.writeFloat(t[r]);}function nc(t,e){for(let r=0;r<t.length;r++)e.writeDouble(t[r]);}function ic(t,e){for(let r=0;r<t.length;r++)e.writeBoolean(t[r]);}function sc(t,e){for(let r=0;r<t.length;r++)e.writeFixed32(t[r]);}function ac(t,e){for(let r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function oc(t,e){for(let r=0;r<t.length;r++)e.writeFixed64(t[r]);}function lc(t,e){for(let r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function uc(t,e,r){1===t&&r.readMessage(cc,e);}function cc(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(hc,{});e.push({id:t,bitmap:new el({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function hc(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function pc(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();e&&t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}class fc{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:a,textFitHeight:o}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=a,this.textFitHeight=o;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class dc{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=pc(i),o=new rl({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;rl.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,a=i.y+1,l=r.data.width,u=r.data.height;rl.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),rl.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),rl.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),rl.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),rl.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new fc(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}var yc;as("ImagePosition",fc),as("ImageAtlas",dc),t.ao=void 0,(yc=t.ao||(t.ao={}))[yc.none=0]="none",yc[yc.horizontal=1]="horizontal",yc[yc.vertical=2]="vertical",yc[yc.horizontalOnly=3]="horizontalOnly";class mc{constructor(){this.scale=1,this.fontStack="",this.imageName=null,this.verticalAlign="bottom";}static forText(t,e,r){const n=new mc;return n.scale=t||1,n.fontStack=e,n.verticalAlign=r||"bottom",n}static forImage(t,e){const r=new mc;return r.imageName=t,r.verticalAlign=e||"bottom",r}}class gc{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new gc;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&ws(n)&&!Xu[t[r+1]]||i&&ws(i)&&!Xu[t[r-1]]||!Xu[t[r]]?t[r]:Xu[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&vc[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&vc[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new gc;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if(i.imageName){const n=t[i.imageName];if(!n)continue;const s=n.displaySize;e=Math.max(e,s[0]),r=Math.max(r,s[1]);}}return {maxImageWidth:e,maxImageHeight:r}}addTextSection(t,e){this.text+=t.text,this.sections.push(mc.forText(t.scale,t.fontStack||e,t.verticalAlign));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void q("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(mc.forImage(e,t.verticalAlign)),this.sectionIndex.push(this.sections.length-1)):q("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function xc(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=gc.fromFeature(e,s);let g;p===t.ao.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=Ms;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),Ic(m,c,a,r,i,d));for(const e of t){const t=new gc;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,Ic(m,c,a,r,i,d));for(const e of t){const t=new gc;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,Ic(m,c,a,r,i,d));const b=[],w={positionedLines:b,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===o?1:"left"===o?0:.5,g=Zu/h;let x=0;for(const a of i){a.trim();const i=a.getMaxScale(),o={positionedGlyphs:[],lineOffset:0};t.positionedLines[x]=o;const h=o.positionedGlyphs;let v=0;if(!a.length()){f+=s,++x;continue}const b=Pc(n,a,g);for(let s=0;s<a.length();s++){const o=a.getSection(s),d=a.getSectionIndex(s),y=a.getCharCode(s),m=Ec(l,c,y);let x;if(o.imageName){if(t.iconsInText=!0,o.scale=o.scale*g,x=Vc(o,m,i,b,n),!x)continue;v=Math.max(v,x.imageOffset);}else if(x=Bc(o,y,m,b,e,r),!x)continue;const{rect:w,metrics:_,baselineOffset:S}=x;h.push({glyph:y,imageName:o.imageName,x:p,y:f+S+-17,vertical:m,scale:o.scale,fontStack:o.fontStack,sectionIndex:d,metrics:_,rect:w}),m?(t.verticalizable=!0,p+=(o.imageName?_.advance:Zu)*o.scale+u):p+=_.advance*o.scale+u;}0!==h.length&&(d=Math.max(p-u,d),Tc(h,0,h.length-1,m)),p=0,o.lineOffset=Math.max(v,(i-1)*Zu);const w=s*i+v;f+=w,y=Math.max(w,y),++x;}const{horizontalAlign:v,verticalAlign:b}=zc(a);((function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n- -17:-n*l*a+.5*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;}))(t.positionedLines,m,v,b,d,y,s,f,i.length),t.top+=-b*f,t.bottom=t.top+f,t.left+=-v*d,t.right=t.left+d;}(w,r,n,i,g,o,l,u,p,c,f,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const vc={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},bc={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},wc={40:!0};function _c(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*Zu/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function Sc(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function Ac(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function kc(t,e,r,n,i,s){let a=null,o=Sc(e,r,i,s);for(const t of n){const n=Sc(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function Mc(t){return t?Mc(t.priorBreak).concat(t.index):[]}function Ic(t,e,r,n,i,s){if(!t)return [];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=_c(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(vc[p]||(u+=_c(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904)&&(!!fs["CJK Compatibility Forms"](c)||!!fs["CJK Compatibility"](c)||!!fs["CJK Strokes"](c)||!!fs["CJK Symbols and Punctuation"](c)||!!fs["Enclosed CJK Letters and Months"](c)||!!fs["Halfwidth and Fullwidth Forms"](c)||!!fs["Ideographic Description Characters"](c)||!!fs["Vertical Forms"](c)||vs.test(String.fromCodePoint(c)));(bc[p]||e||h.imageName||r!==t.length()-2&&wc[t.getCharCode(r+1)])&&a.push(kc(r+1,u,o,a,Ac(p,t.getCharCode(r+1),e&&l),!1));}}var c;return Mc(kc(t.length(),u,o,a,0,!0))}function zc(t){let e=.5,r=.5;switch(t){case "right":case "top-right":case "bottom-right":e=1;break;case "left":case "top-left":case "bottom-left":e=0;}switch(t){case "bottom":case "bottom-right":case "bottom-left":r=1;break;case "top":case "top-right":case "top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Pc(t,e,r){const n=e.getMaxScale()*Zu,{maxImageWidth:i,maxImageHeight:s}=e.getMaxImageSize(t),a=Math.max(n,s*r);return {verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:a}}function Cc(t){switch(t){case "top":return 0;case "center":return .5;default:return 1}}function Ec(e,r,n){return !(e===t.ao.horizontal||!r&&!bs(n)||r&&(vc[n]||(i=n,/\p{sc=Arab}/u.test(String.fromCodePoint(i)))));var i;}function Bc(t,e,r,n,i,s){const a=s[t.fontStack],o=function(t,e,r,n){if(t&&t.rect)return t;const i=e[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(a&&a[e],i,t,e);if(null===o)return null;let l;if(r)l=n.verticalLineContentWidth-t.scale*Zu;else {const e=Cc(t.verticalAlign);l=(n.horizontalLineContentHeight-t.scale*Zu)*e;}return {rect:o.rect,metrics:o.metrics,baselineOffset:l}}function Vc(t,e,r,n,i){const s=i[t.imageName];if(!s)return null;const a=s.paddedRect,o=s.displaySize,l={width:o[0],height:o[1],left:1,top:-3,advance:e?o[1]:o[0]};let u;if(e)u=n.verticalLineContentWidth-o[1]*t.scale;else {const e=Cc(t.verticalAlign);u=(n.horizontalLineContentHeight-o[1]*t.scale)*e;}return {rect:a,metrics:l,baselineOffset:u,imageOffset:(e?o[0]:o[1])*t.scale-Zu*r}}function Tc(t,e,r,n){if(0===n)return;const i=t[r],s=(t[r].x+i.metrics.advance*i.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s;}function Fc(t,e,r){const{horizontalAlign:n,verticalAlign:i}=zc(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function Lc(t){var e,r;let n=t.left,i=t.top,s=t.right-n,a=t.bottom-i;const o=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===o&&s/a<u||"proportional"===o){const t=Math.ceil(a*u);n*=t/s,s=t;}}else if("proportional"===o&&"stretchOnly"===l&&0!==u&&s/a>u){const t=Math.ceil(s/u);i*=t/a,a=t;}return {x1:n,y1:i,x2:n+s,y2:i+a}}function $c(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o}}const Oc=128,Dc=32640;function Rc(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Is(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Is(a)),maxSize:r.evaluate(new Is(o)),interpolationType:n}}}function Uc(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const jc=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Nc(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(Dc,Math.round(o[0])):0,d=o?Math.min(Dc,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function qc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Gc(t){for(const e of t.sections)if(ks(e.text))return !0;return !1}class Xc{constructor(t){this.layoutVertexArray=new $a,this.indexArray=new ja,this.programConfigurations=t,this.segments=new Xa,this.dynamicLayoutVertexArray=new Oa,this.opacityVertexArray=new Da,this.hasVisibleVertices=!1,this.placedSymbolArray=new wa;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ru.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Uu.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,jc,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}as("SymbolBuffers",Xc);class Zc{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Xa,this.collisionVertexArray=new Ua;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,ju.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}as("CollisionBuffers",Zc);class Yc{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.globalState=e.globalState,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Rc(this.zoom,r["text-size"]),this.iconSizeData=Rc(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==Uc(n,"text-overlap","text-allow-overlap")||"never"!==Uc(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((e=>t.ao[e]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID;}createArrays(){this.text=new Xc(new bo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new Xc(new bo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Aa,this.lineVertexArray=new ka,this.symbolInstances=new Sa,this.textAnchorOffsets=new Ia;}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=Xu[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof Ce&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new Is(this.zoom,{globalState:this.globalState});for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=Mo(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=ko(r)),u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=Ce.factory(t),r=this.hasRTLText=this.hasRTLText||Gc(e);(!r||"unavailable"===Ms.getRTLTextPluginStatus()||r&&Ms.isParsed())&&(x=Gu(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof $e?t:$e.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:lu.types[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.ao.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else {const n=ds(x.toString()),i=t.fontStack||e,s=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r,globalState:this.globalState}),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r,globalState:this.globalState}));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,r,n,i,s,a,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.ao.vertical?Math.PI/2:0,v=a.text&&a.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:s,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=r[t],A=y.vertexLength,k=w[1];Nc(d,l.x,l.y,i.x,k+i.y,c.x,c.y,n,_,h.x,h.y,g,b),Nc(d,l.x,l.y,s.x,k+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),Nc(d,l.x,l.y,o.x,k+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),Nc(d,l.x,l.y,u.x,k+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),qc(e.dynamicLayoutVertexArray,l,x),f.emplaceBack(A,A+2,A+1),f.emplaceBack(A+1,A+2,A+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),t!==r.length-1&&S===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,a,a.index,{imagePositions:{},canonical:p,formattedSection:v&&v[S],globalState:this.globalState});}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,n,i,s,a,o){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),u=l.vertexLength,c=s.layoutVertexArray,h=s.collisionVertexArray,p=o.anchorX,f=o.anchorY;this._addCollisionDebugVertex(c,h,a,p,f,new r(t,e)),this._addCollisionDebugVertex(c,h,a,p,f,new r(n,e)),this._addCollisionDebugVertex(c,h,a,p,f,new r(n,i)),this._addCollisionDebugVertex(c,h,a,p,f,new r(t,i)),l.vertexLength+=4;const d=s.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Zc(Ra,Nu.members,Na),this.iconCollisionBox=new Zc(Ra,Nu.members,Na);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let Hc,Kc;as("SymbolBucket",Yc,{omit:["layers","collisionBoxArray","features","compareText"]}),Yc.MAX_GLYPHS=65535,Yc.addDynamicAttributes=qc;var Jc={get paint(){return Kc=Kc||new Us({"icon-opacity":new $s(xt.paint_symbol["icon-opacity"]),"icon-color":new $s(xt.paint_symbol["icon-color"]),"icon-halo-color":new $s(xt.paint_symbol["icon-halo-color"]),"icon-halo-width":new $s(xt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new $s(xt.paint_symbol["icon-halo-blur"]),"icon-translate":new Ls(xt.paint_symbol["icon-translate"]),"icon-translate-anchor":new Ls(xt.paint_symbol["icon-translate-anchor"]),"text-opacity":new $s(xt.paint_symbol["text-opacity"]),"text-color":new $s(xt.paint_symbol["text-color"],{runtimeType:Ot,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new $s(xt.paint_symbol["text-halo-color"]),"text-halo-width":new $s(xt.paint_symbol["text-halo-width"]),"text-halo-blur":new $s(xt.paint_symbol["text-halo-blur"]),"text-translate":new Ls(xt.paint_symbol["text-translate"]),"text-translate-anchor":new Ls(xt.paint_symbol["text-translate-anchor"])})},get layout(){return Hc=Hc||new Us({"symbol-placement":new Ls(xt.layout_symbol["symbol-placement"]),"symbol-spacing":new Ls(xt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Ls(xt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new $s(xt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Ls(xt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Ls(xt.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Ls(xt.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Ls(xt.layout_symbol["icon-ignore-placement"]),"icon-optional":new Ls(xt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Ls(xt.layout_symbol["icon-rotation-alignment"]),"icon-size":new $s(xt.layout_symbol["icon-size"]),"icon-text-fit":new Ls(xt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ls(xt.layout_symbol["icon-text-fit-padding"]),"icon-image":new $s(xt.layout_symbol["icon-image"]),"icon-rotate":new $s(xt.layout_symbol["icon-rotate"]),"icon-padding":new $s(xt.layout_symbol["icon-padding"]),"icon-keep-upright":new Ls(xt.layout_symbol["icon-keep-upright"]),"icon-offset":new $s(xt.layout_symbol["icon-offset"]),"icon-anchor":new $s(xt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Ls(xt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Ls(xt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Ls(xt.layout_symbol["text-rotation-alignment"]),"text-field":new $s(xt.layout_symbol["text-field"]),"text-font":new $s(xt.layout_symbol["text-font"]),"text-size":new $s(xt.layout_symbol["text-size"]),"text-max-width":new $s(xt.layout_symbol["text-max-width"]),"text-line-height":new Ls(xt.layout_symbol["text-line-height"]),"text-letter-spacing":new $s(xt.layout_symbol["text-letter-spacing"]),"text-justify":new $s(xt.layout_symbol["text-justify"]),"text-radial-offset":new $s(xt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Ls(xt.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new $s(xt.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new $s(xt.layout_symbol["text-anchor"]),"text-max-angle":new Ls(xt.layout_symbol["text-max-angle"]),"text-writing-mode":new Ls(xt.layout_symbol["text-writing-mode"]),"text-rotate":new $s(xt.layout_symbol["text-rotate"]),"text-padding":new Ls(xt.layout_symbol["text-padding"]),"text-keep-upright":new Ls(xt.layout_symbol["text-keep-upright"]),"text-transform":new $s(xt.layout_symbol["text-transform"]),"text-offset":new $s(xt.layout_symbol["text-offset"]),"text-allow-overlap":new Ls(xt.layout_symbol["text-allow-overlap"]),"text-overlap":new Ls(xt.layout_symbol["text-overlap"]),"text-ignore-placement":new Ls(xt.layout_symbol["text-ignore-placement"]),"text-optional":new Ls(xt.layout_symbol["text-optional"])})}};class Wc{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:Tt,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}as("FormatSectionOverride",Wc,{omit:["defaultValue"]});class Qc extends Ns{constructor(t){super(t,Jc);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||ei(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new Yc(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of Jc.paint.overridableProperties){if(!Qc.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Wc(e),n=new ti(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new ni("source",n):new ii("composite",n,e.value.zoomStops),this.paint._values[t]=new Ts(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Qc.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Jc.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Ce)s(r.value.value.sections);else if("source"===r.value.kind||"composite"===r.value.kind){const t=e=>{i||(e instanceof Ne&&Ue(e.value)===Nt?s(e.value.sections):e instanceof Ir?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}}let th;var eh={get paint(){return th=th||new Us({"background-color":new Ls(xt.paint_background["background-color"]),"background-pattern":new Ds(xt.paint_background["background-pattern"]),"background-opacity":new Ls(xt.paint_background["background-opacity"])})}};class rh extends Ns{constructor(t){super(t,eh);}}let nh;var ih={get paint(){return nh=nh||new Us({"raster-opacity":new Ls(xt.paint_raster["raster-opacity"]),"raster-hue-rotate":new Ls(xt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Ls(xt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Ls(xt.paint_raster["raster-brightness-max"]),"raster-saturation":new Ls(xt.paint_raster["raster-saturation"]),"raster-contrast":new Ls(xt.paint_raster["raster-contrast"]),"raster-resampling":new Ls(xt.paint_raster["raster-resampling"]),"raster-fade-duration":new Ls(xt.paint_raster["raster-fade-duration"])})}};class sh extends Ns{constructor(t){super(t,ih);}}class ah extends Ns{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);},this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}class oh{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle();}),0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const lh={once:!0},uh=6371008.8;class ch{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new ch($(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return uh*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof ch)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new ch(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new ch(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const hh=2*Math.PI*uh;function ph(t){return hh*Math.cos(t*Math.PI/180)}function fh(t){return (180+t)/360}function dh(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function yh(t,e){return t/ph(e)}function mh(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function gh(t,e){return t*ph(mh(e))}class xh{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=ch.convert(t);return new xh(fh(r.lng),dh(r.lat),yh(e,r.lat))}toLngLat(){return new ch(360*this.x-180,mh(this.y))}toAltitude(){return gh(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/hh*(t=mh(this.y),1/Math.cos(t*Math.PI/180));var t;}}function vh(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class bh{constructor(t,e,r){if(!function(t,e,r){return !(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=Sh(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(s=this.y,a=this.z,o=vh(256*(i=this.x),256*(s=Math.pow(2,a)-s-1),a),l=vh(256*(i+1),256*(s+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var i,s,a,o,l;const u=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new r((t.x*e-this.x)*P,(t.y*e-this.y)*P)}toString(){return `${this.z}/${this.x}/${this.y}`}}class wh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Sh(t,e.z,e.z,e.x,e.y);}}class _h{constructor(t,e,r,n,i){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new bh(r,+n,+i),this.key=Sh(e,t,r,n,i);}clone(){return new _h(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new _h(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new _h(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?Sh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Sh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new _h(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new _h(e,this.wrap,e,r,n),new _h(e,this.wrap,e,r+1,n),new _h(e,this.wrap,e,r,n+1),new _h(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new _h(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new _h(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new wh(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new xh(t.x-this.wrap,t.y))}}function Sh(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return (s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}function Ah(t,e){return e?t.properties[e]:t.id}as("CanonicalTileID",bh),as("OverscaledTileID",_h,{omit:["terrainRttPosMatrix32f"]});class kh{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0;}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const e=new kh;return e.extend(t(new r(this.minX,this.minY))),e.extend(t(new r(this.maxX,this.minY))),e.extend(t(new r(this.minX,this.maxY))),e.extend(t(new r(this.maxX,this.maxY))),e}static fromPoints(t){const e=new kh;for(const r of t)e.extend(r);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return !this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return !this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class Mh{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class Ih{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class zh{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new is(P,16,0),this.grid3D=new is(P,16,0),this.featureIndexArray=new Pa,this.promoteId=e;}insert(t,e,r,n,i,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<P&&n[1]<P&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new fu(new Ju(this.rawTileData)).layers,this.sourceLayerCoder=new Mh(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,n,i){this.loadVTLayers();const s=t.params,a=P/t.tileSize/t.scale,o=hi(s.filter),l=t.queryGeometry,u=t.queryPadding*a,c=kh.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=kh.fromPoints(t.cameraQueryGeometry).expandBy(u),f=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,((e,n,i,s)=>function(t,e,n,i,s){for(const r of t)if(e<=r.x&&n<=r.y&&i>=r.x&&s>=r.y)return !0;const a=[new r(e,n),new r(e,s),new r(i,s),new r(i,n)];if(t.length>2)for(const e of a)if(Do(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Ro(t[e],t[e+1],a))return !0;return !1}(t.cameraQueryGeometry,e-u,n-u,i+u,s+u)));for(const t of f)h.push(t);h.sort(Ch);const d={};let y;for(let r=0;r<h.length;r++){const u=h[r];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,o,s.layers,s.availableImages,e,n,i,((e,r,n)=>(p||(p=ko(e)),r.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:n,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:a,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))));}return d}loadMatchingFeature(t,e,r,n,i,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!h.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=Mo(f,!0);if(!i.filter(new Is(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new Is(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&!s.has(r))continue;const i=o[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",d));const y=O({},l[r]);y.paint=Ph(y.paint,i.paint,f,p,a),y.layout=Ph(y.layout,i.layout,f,p,a);const m=!c||c(f,i,p);if(!m)continue;const g=new Ih(f,this.z,this.x,this.y,d);g.layer=y;let x=t[r];void 0===x&&(x=t[r]=[]),x.push({featureIndex:n,feature:g,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=hi(i);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n}}function Ph(t,e,r,n,i){return R(t,((t,s)=>{const a=e instanceof Fs?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function Ch(t,e){return e-t}function Eh(t,e,n,i,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new r(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new r(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<n&&c.y<n||(o.y<n?o=new r(o.x+(n-o.y)/(c.y-o.y)*(c.x-o.x),n)._round():c.y<n&&(c=new r(o.x+(n-o.y)/(c.y-o.y)*(c.x-o.x),n)._round()),o.x>=i&&c.x>=i||(o.x>=i?o=new r(i,o.y+(i-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=i&&(c=new r(i,o.y+(i-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new r(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new r(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}as("FeatureIndex",zh,{omit:["rawTileData","sourceLayerCoder"]});class Bh extends r{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new Bh(this.x,this.y,this.angle,this.segment)}}function Vh(t,e,r,n,i){if(void 0===e.segment||0===r)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function Th(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Fh(t,e,r){return t?.6*e*r:0}function Lh(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function $h(t,e,r,n,i,s){const a=Fh(r,i,s),o=Lh(r,n)*s;let l=0;const u=Th(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=dr.number(n.x,i.x,c),p=dr.number(n.y,i.y,c),f=new Bh(h,p,i.angleTo(n),r);return f._round(),!a||Vh(t,f,o,a,e)?f:void 0}l+=s;}}function Oh(t,e,r,n,i,s,a,o,l){const u=Fh(n,s,a),c=Lh(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),Dh(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function Dh(t,e,r,n,i,s,a,o,l){const u=s/2,c=Th(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=dr.number(a.x,o.x,m),x=dr.number(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Bh(g,x,y,e);r._round(),n&&!Vh(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=Dh(t,h/2,r,n,i,s,a,!0,l)),f}function Rh(t,e,n,i){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=a.stretchX||[[0,l]],p=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,A=0,k=g;if(a.content&&i){const e=a.content,r=e[2]-e[0],n=e[3]-e[1];(a.textFitWidth||a.textFitHeight)&&(c=Lc(t)),x=Uh(h,0,e[0]),b=Uh(p,0,e[1]),v=Uh(h,e[0],e[2]),w=Uh(p,e[1],e[3]),_=e[0]-x,A=e[1]-b,S=r-v,k=n-w;}const M=c.x1,I=c.y1,z=c.x2-M,P=c.y2-I,C=(t,i,s,l)=>{const u=Nh(t.stretch-x,v,z,M),c=qh(t.fixed-_,S,t.stretch,d),h=Nh(i.stretch-b,w,P,I),p=qh(i.fixed-A,k,i.stretch,y),f=Nh(s.stretch-x,v,z,M),m=qh(s.fixed-_,S,s.stretch,d),g=Nh(l.stretch-b,w,P,I),C=qh(l.fixed-A,k,l.stretch,y),E=new r(u,h),B=new r(f,h),V=new r(f,g),T=new r(u,g),F=new r(c/o,p/o),L=new r(m/o,C/o),$=e*Math.PI/180;if($){const t=Math.sin($),e=Math.cos($),r=[e,-t,t,e];E._matMult(r),B._matMult(r),T._matMult(r),V._matMult(r);}const O=t.stretch+t.fixed,D=i.stretch+i.fixed;return {tl:E,tr:B,bl:T,br:V,tex:{x:a.paddedRect.x+1+O,y:a.paddedRect.y+1+D,w:s.stretch+s.fixed-O,h:l.stretch+l.fixed-D},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:L,minFontScaleX:S/o/z,minFontScaleY:k/o/P,isSDF:n}};if(i&&(a.stretchX||a.stretchY)){const t=jh(h,m,d),e=jh(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(C(n,e[t],i,e[t+1]));}}else s.push(C({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Uh(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function jh(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}),n}function Nh(t,e,r,n){return t/e*r+n}function qh(t,e,r,n){return t-e*r/n}as("Anchor",Bh);class Gh{constructor(t,e,n,i,s,a,o,l,u,c){var h;if(this.boxStartIndex=t.length,u){let t=a.top,e=a.bottom;const r=a.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else {const u=(null===(h=a.image)||void 0===h?void 0:h.content)&&(a.image.textFitWidth||a.image.textFitHeight)?Lc(a):{x1:a.left,y1:a.top,x2:a.right,y2:a.bottom};u.y1=u.y1*o-l[0],u.y2=u.y2*o+l[2],u.x1=u.x1*o-l[3],u.x2=u.x2*o+l[1];const p=a.collisionPadding;if(p&&(u.x1-=p[0]*o,u.y1-=p[1]*o,u.x2+=p[2]*o,u.y2+=p[3]*o),c){const t=new r(u.x1,u.y1),e=new r(u.x2,u.y1),n=new r(u.x1,u.y2),i=new r(u.x2,u.y2),s=c*Math.PI/180;t._rotate(s),e._rotate(s),n._rotate(s),i._rotate(s),u.x1=Math.min(t.x,e.x,n.x,i.x),u.x2=Math.max(t.x,e.x,n.x,i.x),u.y1=Math.min(t.y,e.y,n.y,i.y),u.y2=Math.max(t.y,e.y,n.y,i.y);}t.emplaceBack(e.x,e.y,u.x1,u.y1,u.x2,u.y2,n,i,s);}this.boxEndIndex=t.length;}}class Xh{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}function Zh(t,e=1,n=!1){const i=kh.fromPoints(t[0]),s=Math.min(i.width(),i.height());let a=s/2;const o=new Xh([],Yh),{minX:l,minY:u,maxX:c,maxY:h}=i;if(0===s)return new r(l,u);for(let e=l;e<c;e+=s)for(let r=u;r<h;r+=s)o.push(new Hh(e+a,r+a,a,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new Hh(r/e,n/e,0,t)}(t),f=o.length;for(;o.length;){const r=o.pop();(r.d>p.d||!p.d)&&(p=r,n&&console.log("found best %d after %d probes",Math.round(1e4*r.d)/1e4,f)),r.max-p.d<=e||(a=r.h/2,o.push(new Hh(r.p.x-a,r.p.y-a,a,t)),o.push(new Hh(r.p.x+a,r.p.y-a,a,t)),o.push(new Hh(r.p.x-a,r.p.y+a,a,t)),o.push(new Hh(r.p.x+a,r.p.y+a,a,t)),f+=4);}return n&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function Yh(t,e){return e.max-t.max}function Hh(t,e,n,i){this.p=new r(t,e),this.h=n,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,$o(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,i),this.max=this.d+this.h*Math.SQRT2;}var Kh;t.aE=void 0,(Kh=t.aE||(t.aE={}))[Kh.center=1]="center",Kh[Kh.left=2]="left",Kh[Kh.right=3]="right",Kh[Kh.top=4]="top",Kh[Kh.bottom=5]="bottom",Kh[Kh["top-left"]=6]="top-left",Kh[Kh["top-right"]=7]="top-right",Kh[Kh["bottom-left"]=8]="bottom-left",Kh[Kh["bottom-right"]=9]="bottom-right";const Jh=Number.POSITIVE_INFINITY;function Wh(t,e){return e[1]!==Jh?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case "top-right":case "top-left":case "top":i=r-7;break;case "bottom-right":case "bottom-left":case "bottom":i=7-r;}switch(t){case "top-right":case "bottom-right":case "right":n=-e;break;case "top-left":case "bottom-left":case "left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case "top-right":case "top-left":n=i-7;break;case "bottom-right":case "bottom-left":n=7-i;break;case "bottom":n=7-e;break;case "top":n=e-7;}switch(t){case "top-right":case "bottom-right":r=-i;break;case "top-left":case "bottom-left":r=i;break;case "left":r=e;break;case "right":r=-e;}return [r,n]}(t,e[0])}function Qh(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*Zu));n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),e[r+1]=i;}return new Le(e)}const a=i.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*Zu,Jh]:i.get("text-offset").evaluate(e,{},r).map((t=>t*Zu));const s=[];for(const t of a)s.push(t,Wh(t,n));return new Le(s)}return null}function tp(t){switch(t){case "right":case "top-right":case "bottom-right":return "right";case "left":case "top-left":case "bottom-left":return "left"}return "center"}function ep(e,r,n,i,s,a,o,l,u,c,h,p){let f=a.textMaxSize.evaluate(r,{});void 0===f&&(f=o);const d=e.layers[0].layout,y=d.get("icon-offset").evaluate(r,{},h),m=np(n.horizontal),g=o/24,x=e.tilePixelRatio*g,v=e.tilePixelRatio*f/24,b=e.tilePixelRatio*l,w=e.tilePixelRatio*d.get("symbol-spacing"),_=d.get("text-padding")*e.tilePixelRatio,S=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return [s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(d,r,h,e.tilePixelRatio),A=d.get("text-max-angle")/180*Math.PI,k="viewport"!==d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),M="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),I=d.get("symbol-placement"),z=w/2,C=d.get("icon-text-fit");let E;i&&"none"!==C&&(e.allowVerticalPlacement&&n.vertical&&(E=$c(i,n.vertical,C,d.get("icon-text-fit-padding"),y,g)),m&&(i=$c(i,m,C,d.get("icon-text-fit-padding"),y,g)));const B=h?p.line.getGranularityForZoomLevel(h.z):1,V=(l,p)=>{p.x<0||p.x>=P||p.y<0||p.y>=P||function(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k){const M=e.addToLineVertexArray(r,n);let I,z,P,C,E=0,B=0,V=0,T=0,F=-1,L=-1;const $={};let O=ro("");if(e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},A)+90;P=new Gh(u,r,c,h,p,i.vertical,f,d,y,t),o&&(C=new Gh(u,r,c,h,p,o,g,x,y,t));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),a=Rh(s,n,S,i),f=o?Rh(o,n,S,i):void 0;z=new Gh(u,r,c,h,p,s,g,x,!1,n),E=4*a.length;const d=e.iconSizeData;let y=null;"source"===d.kind?(y=[Oc*l.layout.get("icon-size").evaluate(w,{})],y[0]>Dc&&q(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[Oc*_.compositeIconSizes[0].evaluate(w,{},A),Oc*_.compositeIconSizes[1].evaluate(w,{},A)],(y[0]>Dc||y[1]>Dc)&&q(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),e.addSymbols(e.icon,a,y,b,v,w,t.ao.none,r,M.lineStartIndex,M.lineLength,-1,A),F=e.icon.placedSymbolArray.length-1,f&&(B=4*f.length,e.addSymbols(e.icon,f,y,b,v,w,t.ao.vertical,r,M.lineStartIndex,M.lineLength,-1,A),L=e.icon.placedSymbolArray.length-1);}const D=Object.keys(i.horizontal);for(const n of D){const s=i.horizontal[n];if(!I){O=ro(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},A);I=new Gh(u,r,c,h,p,s,f,d,y,t);}const o=1===s.positionedLines.length;if(V+=rp(e,r,s,a,l,y,w,m,M,i.vertical?t.ao.horizontal:t.ao.horizontalOnly,o?D:[n],$,F,_,A),o)break}i.vertical&&(T+=rp(e,r,i.vertical,a,l,y,w,m,M,t.ao.vertical,["vertical"],$,L,_,A));const R=I?I.boxStartIndex:e.collisionBoxArray.length,U=I?I.boxEndIndex:e.collisionBoxArray.length,j=P?P.boxStartIndex:e.collisionBoxArray.length,N=P?P.boxEndIndex:e.collisionBoxArray.length,G=z?z.boxStartIndex:e.collisionBoxArray.length,X=z?z.boxEndIndex:e.collisionBoxArray.length,Z=C?C.boxStartIndex:e.collisionBoxArray.length,Y=C?C.boxEndIndex:e.collisionBoxArray.length;let H=-1;const K=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;H=K(I,H),H=K(P,H),H=K(z,H),H=K(C,H);const J=H>-1?1:0;J&&(H*=k/Zu),e.glyphOffsetArray.length>=Yc.MAX_GLYPHS&&q("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const W=Qh(l,w,A),[Q,tt]=function(e,r){const n=e.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];e.emplaceBack(t.aE[i[r]],n[0],n[1]);}return [n,e.length]}(e.textAnchorOffsets,W);e.symbolInstances.emplaceBack(r.x,r.y,$.right>=0?$.right:-1,$.center>=0?$.center:-1,$.left>=0?$.left:-1,$.vertical||-1,F,L,O,R,U,j,N,G,X,Z,Y,c,V,T,E,B,J,0,f,H,Q,tt);}(e,p,l,n,i,s,E,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,x,[_,_,_,_],k,u,b,S,M,y,r,a,c,h,o);};if("line"===I)for(const t of Eh(r.geometry,0,0,P,P)){const r=Kl(t,B),s=Oh(r,w,A,n.vertical||m,i,24,v,e.overscaling,P);for(const t of s)m&&ip(e,m.text,z,t)||V(r,t);}else if("line-center"===I){for(const t of r.geometry)if(t.length>1){const e=Kl(t,B),r=$h(e,A,n.vertical||m,i,24,v);r&&V(e,r);}}else if("Polygon"===r.type)for(const t of Qr(r.geometry,0)){const e=Zh(t,16);V(Kl(t[0],B,!0),new Bh(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry){const e=Kl(t,B);V(e,new Bh(e[0].x,e[0].y,0));}else if("Point"===r.type)for(const t of r.geometry)for(const e of t)V([e],new Bh(e.x,e.y,0));}function rp(t,e,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=function(t,e,n,i,s,a,o,l){const u=i.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const i of t.positionedGlyphs){if(!i.rect)continue;const a=i.rect||{};let h=4,p=!0,f=1,d=0;const y=(s||l)&&i.vertical,m=i.metrics.advance*i.scale/2;if(l&&e.verticalizable&&(d=t.lineOffset/2-(i.imageName?-(Zu-i.metrics.width*i.scale)/2:(i.scale-1)*Zu)),i.imageName){const t=o[i.imageName];p=t.sdf,f=t.pixelRatio,h=1/f;}const g=s?[i.x+m,i.y]:[0,0];let x=s?[0,0]:[i.x+m+n[0],i.y+n[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=i.metrics.isDoubleResolution?2:1,w=(i.metrics.left-h)*i.scale-m+x[0],_=(-i.metrics.top-h)*i.scale+x[1],S=w+a.w/b*i.scale/f,A=_+a.h/b*i.scale/f,k=new r(w,_),M=new r(S,_),I=new r(w,A),z=new r(S,A);if(y){const t=new r(-m,m- -17),e=-Math.PI/2,n=12-m,s=new r(22-n,-(i.imageName?n:0)),a=new r(...v);k._rotateAround(e,t)._add(s)._add(a),M._rotateAround(e,t)._add(s)._add(a),I._rotateAround(e,t)._add(s)._add(a),z._rotateAround(e,t)._add(s)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),M._matMult(r),I._matMult(r),z._matMult(r);}const P=new r(0,0),C=new r(0,0);c.push({tl:k,tr:M,bl:I,br:z,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:i.sectionIndex,isSDF:p,pixelOffsetTL:P,pixelOffsetBR:C,minFontScaleX:0,minFontScaleY:0});}return c}(0,n,l,s,a,o,i,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[Oc*s.layout.get("text-size").evaluate(o,{})],x[0]>Dc&&q(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[Oc*d.compositeTextSizes[0].evaluate(o,{},y),Oc*d.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>Dc||x[1]>Dc)&&q(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function np(t){for(const e in t)return t[e];return null}function ip(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const sp=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class ap{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=sp[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new ap(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=sp.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return op(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)hp(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];hp(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function op(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;lp(t,e,a,n,i,s),op(t,e,r,n,a-1,1-s),op(t,e,r,a+1,i,1-s);}function lp(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);lp(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(up(t,e,n,r),e[2*i+s]>a&&up(t,e,n,i);o<l;){for(up(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?up(t,e,n,l):(l++,up(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function up(t,e,r,n){cp(t,r,n),cp(e,2*r,2*n),cp(e,2*r+1,2*n+1);}function cp(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function hp(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}var pp;t.cx=void 0,(pp=t.cx||(t.cx={})).create="create",pp.load="load",pp.fullLoad="fullLoad";let fp=null,dp=[];const yp=1e3/60,mp="loadTime",gp="fullLoadTime",xp={mark(t){performance.mark(t);},frame(t){const e=t;null!=fp&&dp.push(e-fp),fp=e;},clearMetrics(){fp=null,dp=[],performance.clearMeasures(mp),performance.clearMeasures(gp);for(const e in t.cx)performance.clearMarks(t.cx[e]);},getPerformanceMetrics(){performance.measure(mp,t.cx.create,t.cx.load),performance.measure(gp,t.cx.create,t.cx.fullLoad);const e=performance.getEntriesByName(mp)[0].duration,r=performance.getEntriesByName(gp)[0].duration,n=dp.length,i=1/(dp.reduce(((t,e)=>t+e),0)/n/1e3),s=dp.filter((t=>t>yp)).reduce(((t,e)=>t+(e-yp)/yp),0);return {loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n}}};t.$=P,t.A=f,t.B=function([t,e,r]){return e+=90,e*=Math.PI/180,r*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)}},t.C=dr,t.D=Ls,t.E=gt,t.F=Is,t.G=ts,t.H=function(t){if(null==Z){const e=t.navigator?t.navigator.userAgent:null;Z=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Z},t.I=fc,t.J=class{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new oh((()=>this.process())),this.subscription=Q(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=X(self)?t:window;}registerMessageHandler(t,e){this.messageHandlers[t]=e;}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?Q(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e);}),lh):null;this.resolveRejects[i]={resolve:t=>{null==s||s.unsubscribe(),r(t);},reject:t=>{null==s||s.unsubscribe(),n(t);}};const a=[],o=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:cs(t.data,a)});this.target.postMessage(o,{transfer:a});}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(X(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e);}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e);}processTask(t,r){return e(this,void 0,void 0,(function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(hs(r.error)):e.resolve(hs(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=hs(r.data),n=new AbortController;this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i);}catch(e){this.completeTask(t,e);}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?cs(e):null,data:cs(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},t.K=lt,t.L=function(){var t=new f(16);return f!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.M=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t},t.N=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.O=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t},t.P=r,t.Q=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.R=rl,t.S=ch,t.T=hl,t.U=dh,t.V=fh,t.W=c,t.X=h,t.Y=K,t.Z=_h,t._=e,t.a=at,t.a$=S,t.a0=function(t,e){var r,n,i,s,a;if(!t)return null!=e?e:{};if(!e)return t;let o=Object.assign({},t);if(e.removeAll&&(o={removeAll:!0}),e.remove){const n=new Set(e.remove);o.add&&(o.add=o.add.filter((t=>!n.has(t.id)))),o.update&&(o.update=o.update.filter((t=>!n.has(t.id))));const i=new Set((null!==(r=t.add)&&void 0!==r?r:[]).map((t=>t.id)));e.remove=e.remove.filter((t=>!i.has(t)));}if(e.remove){const t=new Set(o.remove?o.remove.concat(e.remove):e.remove);o.remove=Array.from(t.values());}if(e.add){const t=o.add?o.add.concat(e.add):e.add,r=new Map(t.map((t=>[t.id,t])));o.add=Array.from(r.values());}if(e.update){const t=new Map(null===(n=o.update)||void 0===n?void 0:n.map((t=>[t.id,t])));for(const r of e.update){const e=null!==(i=t.get(r.id))&&void 0!==i?i:{id:r.id};r.newGeometry&&(e.newGeometry=r.newGeometry),r.addOrUpdateProperties&&(e.addOrUpdateProperties=(null!==(s=e.addOrUpdateProperties)&&void 0!==s?s:[]).concat(r.addOrUpdateProperties)),r.removeProperties&&(e.removeProperties=(null!==(a=e.removeProperties)&&void 0!==a?a:[]).concat(r.removeProperties)),r.removeAllProperties&&(e.removeAllProperties=!0),t.set(r.id,e);}o.update=Array.from(t.values());}return o.remove&&o.add&&(o.remove=o.remove.filter((t=>-1===o.add.findIndex((e=>e.id===t))))),o},t.a1=xh,t.a2=kh,t.a3=25,t.a4=bh,t.a5=t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((r=>{e.onloadstart=()=>{r(e);};for(const r of t){const t=window.document.createElement("source");pt(r)||(e.crossOrigin="Anonymous"),t.src=r,e.appendChild(t);}}))},t.a6=Ct,t.a7=function(){return D++},t.a8=va,t.a9=Yc,t.aA=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return [e,r,n,i]},t.aB=Zu,t.aC=C,t.aD=function(t,e,r,n,i=!1){if(!r[0]&&!r[1])return [0,0];const s=i?"map"===n?-t.bearingInRadians:0:"viewport"===n?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);r=[r[0]*e-r[1]*t,r[0]*t+r[1]*e];}return [i?r[0]:C(e,r[0],t.zoom),i?r[1]:C(e,r[1],t.zoom)]},t.aF=Uc,t.aG=tp,t.aH=zc,t.aI=ap,t.aJ=Zs,t.aK=Gl,t.aL=Ca,t.aM=Xa,t.aN=ja,t.aO=$,t.aP=et,t.aQ=gh,t.aR=b,t.aS=v,t.aT=function(t){var e=new f(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},t.aU=function(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t},t.aV=function(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t},t.aW=w,t.aX=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]},t.aY=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t},t.aZ=g,t.a_=function(t,e,r){const n=e[0]*r[0]+e[1]*r[1]+e[2]*r[2];return 0===n?null:(-(t[0]*r[0]+t[1]*r[1]+t[2]*r[2])-r[3])/n},t.aa=hi,t.ab=Mo,t.ac=Ih,t.ad=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e},t.ae=tt,t.af=function(t){return Math.pow(2,t)},t.ag=y,t.ah=L,t.ai=85.051129,t.aj=yh,t.ak=function(t){return Math.log(t)/Math.LN2},t.al=function(t){var e=t[0],r=t[1];return e*e+r*r},t.am=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.an=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?L(pr.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=dr.number(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}},t.ap=function(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/Oc:"composite"===t.kind?dr.number(n/Oc,i/Oc,r):e},t.aq=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,S=i*u-s*l,A=c*y-h*d,k=c*m-p*d,M=c*g-f*d,I=h*m-p*y,z=h*g-f*y,P=p*g-f*m,C=x*P-v*z+b*I+w*M-_*k+S*A;return C?(t[0]=(o*P-l*z+u*I)*(C=1/C),t[1]=(i*z-n*P-s*I)*C,t[2]=(y*S-m*_+g*w)*C,t[3]=(p*_-h*S-f*w)*C,t[4]=(l*M-a*P-u*k)*C,t[5]=(r*P-i*M+s*k)*C,t[6]=(m*b-d*S-g*v)*C,t[7]=(c*S-p*b+f*v)*C,t[8]=(a*z-o*M+u*A)*C,t[9]=(n*M-r*z-s*A)*C,t[10]=(d*_-y*b+g*x)*C,t[11]=(h*b-c*_-f*x)*C,t[12]=(o*k-a*I-l*A)*C,t[13]=(r*I-n*k+i*A)*C,t[14]=(y*v-d*w-m*x)*C,t[15]=(c*w-h*v+p*x)*C,t):null},t.ar=I,t.as=function(t){var e=t[0],r=t[1];return Math.sqrt(e*e+r*r)},t.at=function(t){return t[0]=0,t[1]=0,t},t.au=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},t.av=qc,t.aw=A,t.ax=function(t,e,n,i){const s=e.y-t.y,a=e.x-t.x,o=i.y-n.y,l=i.x-n.x,u=o*a-l*s;if(0===u)return null;const c=(l*(t.y-n.y)-o*(t.x-n.x))/u;return new r(t.x+c*a,t.y+c*s)},t.ay=Eh,t.az=Co,t.b=Y,t.b$=class extends oa{},t.b0=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},t.b1=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]},t.b2=wh,t.b3=Sh,t.b4=function(t,e,r,n,i){var s=1/Math.tan(e/2);if(t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0){var a=1/(n-i);t[10]=(i+n)*a,t[14]=2*i*n*a;}else t[10]=-1,t[14]=-2*n;return t},t.b5=function(t){var e=new f(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.b6=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.b7=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},t.b8=function(){const t=new Float32Array(16);return y(t),t},t.b9=function(){const t=new Float64Array(16);return y(t),t},t.bA=function(t,e){const r=E(t,360),n=E(e,360),i=n-r,s=n>r?i-360:i+360;return Math.abs(i)<Math.abs(s)?i:s},t.bB=function(t){return t[0]=0,t[1]=0,t[2]=0,t},t.bC=function(t,e,r,n){const i=Math.sqrt(t*t+e*e),s=Math.sqrt(r*r+n*n);t/=i,e/=i,r/=s,n/=s;const a=Math.acos(t*r+e*n);return -e*r+t*n>0?a:-a},t.bD=function(t,e){const r=E(t,2*Math.PI),n=E(e,2*Math.PI);return Math.min(Math.abs(r-n),Math.abs(r-n+2*Math.PI),Math.abs(r-n-2*Math.PI))},t.bE=function(){const t={},e=xt.$version;for(const r in xt.$root){const n=xt.$root[r];if(n.required){let i=null;i="version"===r?e:"array"===n.type?[]:{},null!=i&&(t[r]=i);}}return t},t.bF=ps,t.bG=ct,t.bH=function t(e,r){if(Array.isArray(e)){if(!Array.isArray(r)||e.length!==r.length)return !1;for(let n=0;n<e.length;n++)if(!t(e[n],r[n]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==r){if("object"!=typeof r)return !1;if(Object.keys(e).length!==Object.keys(r).length)return !1;for(const n in e)if(!t(e[n],r[n]))return !1;return !0}return e===r},t.bI=function(t){t=t.slice();const e=Object.create(null);for(let r=0;r<t.length;r++)e[t[r].id]=t[r];for(let r=0;r<t.length;r++)"ref"in t[r]&&(t[r]=bt(t[r],e[t[r].ref]));return t},t.bJ=function(t){if("custom"===t.type)return new ah(t);switch(t.type){case "background":return new rh(t);case "circle":return new Zo(t);case "color-relief":return new dl(t);case "fill":return new iu(t);case "fill-extrusion":return new Su(t);case "heatmap":return new sl(t);case "hillshade":return new ll(t);case "line":return new Ou(t);case "raster":return new sh(t);case "symbol":return new Qc(t)}},t.bK=j,t.bL=function(t,e){if(!t)return [{command:"setStyle",args:[e]}];let r=[];try{if(!wt(t.version,e.version))return [{command:"setStyle",args:[e]}];wt(t.center,e.center)||r.push({command:"setCenter",args:[e.center]}),wt(t.state,e.state)||r.push({command:"setGlobalState",args:[e.state]}),wt(t.centerAltitude,e.centerAltitude)||r.push({command:"setCenterAltitude",args:[e.centerAltitude]}),wt(t.zoom,e.zoom)||r.push({command:"setZoom",args:[e.zoom]}),wt(t.bearing,e.bearing)||r.push({command:"setBearing",args:[e.bearing]}),wt(t.pitch,e.pitch)||r.push({command:"setPitch",args:[e.pitch]}),wt(t.roll,e.roll)||r.push({command:"setRoll",args:[e.roll]}),wt(t.sprite,e.sprite)||r.push({command:"setSprite",args:[e.sprite]}),wt(t.glyphs,e.glyphs)||r.push({command:"setGlyphs",args:[e.glyphs]}),wt(t.transition,e.transition)||r.push({command:"setTransition",args:[e.transition]}),wt(t.light,e.light)||r.push({command:"setLight",args:[e.light]}),wt(t.terrain,e.terrain)||r.push({command:"setTerrain",args:[e.terrain]}),wt(t.sky,e.sky)||r.push({command:"setSky",args:[e.sky]}),wt(t.projection,e.projection)||r.push({command:"setProjection",args:[e.projection]});const n={},i=[];!function(t,e,r,n){let i;for(i in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)||At(i,r,n));for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)?wt(t[i],e[i])||("geojson"===t[i].type&&"geojson"===e[i].type&&Mt(t,e,i)?_t(r,{command:"setGeoJSONSourceData",args:[i,e[i].data]}):kt(i,e,r,n)):St(i,e,r));}(t.sources,e.sources,i,n);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&n[t.source]?r.push({command:"removeLayer",args:[t.id]}):s.push(t);})),r=r.concat(i),function(t,e,r){e=e||[];const n=(t=t||[]).map(zt),i=e.map(zt),s=t.reduce(Pt,{}),a=e.reduce(Pt,{}),o=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let t=0,e=0;t<n.length;t++)u=n[t],Object.prototype.hasOwnProperty.call(a,u)?e++:(_t(r,{command:"removeLayer",args:[u]}),o.splice(o.indexOf(u,e),1));for(let t=0,e=0;t<i.length;t++)u=i[i.length-1-t],o[o.length-1-t]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(_t(r,{command:"removeLayer",args:[u]}),o.splice(o.lastIndexOf(u,o.length-e),1)):e++,p=o[o.length-t],_t(r,{command:"addLayer",args:[a[u],p]}),o.splice(o.length-t,0,u),l[u]=!0);for(let t=0;t<i.length;t++)if(u=i[t],c=s[u],h=a[u],!l[u]&&!wt(c,h))if(wt(c.source,h.source)&&wt(c["source-layer"],h["source-layer"])&&wt(c.type,h.type)){for(f in It(c.layout,h.layout,r,u,null,"setLayoutProperty"),It(c.paint,h.paint,r,u,null,"setPaintProperty"),wt(c.filter,h.filter)||_t(r,{command:"setFilter",args:[u,h.filter]}),wt(c.minzoom,h.minzoom)&&wt(c.maxzoom,h.maxzoom)||_t(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?It(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):wt(c[f],h[f])||_t(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?It(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):wt(c[f],h[f])||_t(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else _t(r,{command:"removeLayer",args:[u]}),p=o[o.lastIndexOf(u)+1],_t(r,{command:"addLayer",args:[h,p]});}(s,e.layers,r);}catch(t){console.warn("Unable to compute style diff:",t),r=[{command:"setStyle",args:[e]}];}return r},t.bM=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.bN=R,t.bO=U,t.bP=class extends oo{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.bQ=co,t.bR=class extends oo{constructor(t,e){super(t,e),this.current=ho;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.bS=uo,t.bT=class extends oo{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.bU=class extends oo{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.bV=d,t.bW=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.bX=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},t.bY=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.bZ=class extends oo{constructor(t,e){super(t,e),this.current=new Array;}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(4*t.length);for(let r=0;r<t.length;r++)e[4*r]=t[r].r,e[4*r+1]=t[r].g,e[4*r+2]=t[r].b,e[4*r+3]=t[r].a;this.gl.uniform4fv(this.location,e);}}},t.b_=class extends oo{constructor(t,e){super(t,e),this.current=new Array;}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(t);this.gl.uniform1fv(this.location,e);}}},t.ba=function(){return new Float64Array(16)},t.bb=function(t,e,r){const n=new Float64Array(4);return M(n,t,e-90,r),n},t.bc=function(t,e,r,n){var i,s,a,o,l,u=e[0],c=e[1],h=e[2],f=e[3],d=r[0],y=r[1],m=r[2],g=r[3];return (s=u*d+c*y+h*m+f*g)<0&&(s=-s,d=-d,y=-y,m=-m,g=-g),1-s>p?(i=Math.acos(s),a=Math.sin(i),o=Math.sin((1-n)*i)/a,l=Math.sin(n*i)/a):(o=1-n,l=n),t[0]=o*u+l*d,t[1]=o*c+l*y,t[2]=o*h+l*m,t[3]=o*f+l*g,t},t.bd=function(t){const e=new Float64Array(9);var r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v;h=(i=(n=t)[0])*(l=i+i),p=(s=n[1])*l,d=(a=n[2])*l,y=a*(u=s+s),g=(o=n[3])*l,x=o*u,v=o*(c=a+a),(r=e)[0]=1-(f=s*u)-(m=a*c),r[3]=p-v,r[6]=d+x,r[1]=p+v,r[4]=1-h-m,r[7]=y-g,r[2]=d-x,r[5]=y+g,r[8]=1-h-f;const b=et(-Math.asin(L(e[2],-1,1)));let w,_;return Math.hypot(e[5],e[8])<.001?(w=0,_=-et(Math.atan2(e[3],e[4]))):(w=et(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),_=et(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:w,pitch:b+90,bearing:_}},t.be=function(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing},t.bf=Me,t.bg=lo,t.bh=Xl,t.bi=Zl,t.bj=ql,t.bk=B,t.bl=V,t.bm=Oe,t.bn=function(t,e,r,n,i){return B(n,i,L((t-e)/(r-e),0,1))},t.bo=E,t.bp=function(){return new Float64Array(3)},t.bq=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t},t.br=M,t.bs=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=r[3],o=e[0],l=e[1],u=e[2],c=i*u-s*l,h=s*o-n*u,p=n*l-i*o;return t[0]=o+a*(c+=c)+i*(p+=p)-s*(h+=h),t[1]=l+a*h+s*c-n*p,t[2]=u+a*p+n*h-i*c,t},t.bt=function(t,e,r){const n=(i=[t[0],t[1],t[2],e[0],e[1],e[2],r[0],r[1],r[2]])[0]*((c=i[8])*(a=i[4])-(o=i[5])*(u=i[7]))+i[1]*(-c*(s=i[3])+o*(l=i[6]))+i[2]*(u*s-a*l);var i,s,a,o,l,u,c;if(0===n)return null;const h=w([],[e[0],e[1],e[2]],[r[0],r[1],r[2]]),p=w([],[r[0],r[1],r[2]],[t[0],t[1],t[2]]),f=w([],[t[0],t[1],t[2]],[e[0],e[1],e[2]]),d=b([],h,-t[3]);return v(d,d,b([],p,-e[3])),v(d,d,b([],f,-r[3])),b(d,d,1/n),d},t.bu=uh,t.bv=function(){return new Float64Array(4)},t.bw=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bx=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.by=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bz=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},t.c=st,t.c0=qu,t.c1=class extends ua{},t.c2=il,t.c3=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.c4=nl,t.c5=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t},t.c6=class extends Js{},t.c7=class extends ma{},t.c8=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},t.c9=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],f=t[10],d=t[11],y=t[12],m=t[13],g=t[14],x=t[15],v=e[0],b=e[1],w=e[2],_=e[3],S=e[4],A=e[5],k=e[6],M=e[7],I=e[8],z=e[9],P=e[10],C=e[11],E=e[12],B=e[13],V=e[14],T=e[15];return Math.abs(r-v)<=p*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=p*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(i-w)<=p*Math.max(1,Math.abs(i),Math.abs(w))&&Math.abs(s-_)<=p*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(a-S)<=p*Math.max(1,Math.abs(a),Math.abs(S))&&Math.abs(o-A)<=p*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-k)<=p*Math.max(1,Math.abs(l),Math.abs(k))&&Math.abs(u-M)<=p*Math.max(1,Math.abs(u),Math.abs(M))&&Math.abs(c-I)<=p*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-z)<=p*Math.max(1,Math.abs(h),Math.abs(z))&&Math.abs(f-P)<=p*Math.max(1,Math.abs(f),Math.abs(P))&&Math.abs(d-C)<=p*Math.max(1,Math.abs(d),Math.abs(C))&&Math.abs(y-E)<=p*Math.max(1,Math.abs(y),Math.abs(E))&&Math.abs(m-B)<=p*Math.max(1,Math.abs(m),Math.abs(B))&&Math.abs(g-V)<=p*Math.max(1,Math.abs(g),Math.abs(V))&&Math.abs(x-T)<=p*Math.max(1,Math.abs(x),Math.abs(T))},t.cA=function(t,e){at.REGISTERED_PROTOCOLS[t]=e;},t.cB=function(t){delete at.REGISTERED_PROTOCOLS[t];},t.cC=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||bi(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n]);}const n=[];for(const t in r)n.push(r[t]);return n},t.cD=as,t.cE=Mh,t.cF=zh,t.cG=dc,t.cH=function(e){e.bucket.createArrays(),e.bucket.tilePixelRatio=P/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new Is(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new Is(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new Is(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new Is(t),e.canonical),i["text-size"].possiblyEvaluate(new Is(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new Is(t),e.canonical),i["icon-size"].possiblyEvaluate(new Is(r),e.canonical)];}const a=n.get("text-line-height")*Zu,o="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*Zu,f=ys(s)?u:0,m=n.get("text-anchor").evaluate(i,{},e.canonical),x=Qh(r,i,e.canonical);if(!x){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?Wh(m,[t*Zu,Jh]):n.get("text-offset").evaluate(i,{},e.canonical).map((t=>t*Zu));}let v=o?"center":n.get("text-justify").evaluate(i,{},e.canonical);const b="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},e.canonical)*Zu:1/0,w=()=>{e.bucket.allowVerticalPlacement&&ds(s)&&(d.vertical=xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,"left",f,g,t.ao.vertical,!0,p,h));};if(!o&&x){const r=new Set;if("auto"===v)for(let t=0;t<x.values.length;t+=2)r.add(tp(x.values[t]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else {const r=xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,"center",i,f,g,t.ao.horizontal,!1,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}w();}else {"auto"===v&&(v=tp(m));const r=xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.ao.horizontal,!1,p,h);r&&(d.horizontal[v]=r),w(),ds(s)&&o&&l&&(d.vertical=xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.ao.vertical,!1,p,h));}}let x=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=Fc(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),x=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&q("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=np(d.horizontal)||d.vertical;e.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&ep(e.bucket,i,d,m,e.imageMap,s,p,f,g,x,e.canonical,e.subdivisionGranularity);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();},t.cI=Bu,t.cJ=tu,t.cK=gu,t.cL=fu,t.cM=Ju,t.cN=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}},t.cO=function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if(h())try{return yield K(t,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,a=t.height;J&&W||(J=new OffscreenCanvas(s,a),W=J.getContext("2d",{willReadFrequently:!0})),J.width=s,J.height=a,W.drawImage(t,0,0,s,a);const o=W.getImageData(e,r,n,i);return W.clearRect(0,0,s,a),o.data}(t,r,n,i,s)}))},t.cP=pl,t.cQ=n,t.cR=hu,t.cS=lu,t.cT=ri,t.cU=function(t,e){const r=new Map;if(null==t);else if("Feature"===t.type)r.set(Ah(t,e),t);else for(const n of t.features)r.set(Ah(n,e),n);return r},t.cV=function(t,e){if(null==t)return !0;if("Feature"===t.type)return null!=Ah(t,e);if("FeatureCollection"===t.type){const r=new Set;for(const n of t.features){const t=Ah(n,e);if(null==t)return !1;if(r.has(t))return !1;r.add(t);}return !0}return !1},t.cW=function(t,e,r){var n,i,s,a;if(e.removeAll&&t.clear(),e.remove)for(const r of e.remove)t.delete(r);if(e.add)for(const n of e.add){const e=Ah(n,r);null!=e&&t.set(e,n);}if(e.update)for(const r of e.update){let e=t.get(r.id);if(null==e)continue;const o=!r.removeAllProperties&&((null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0);if((r.newGeometry||r.removeAllProperties||o)&&(e=Object.assign({},e),t.set(r.id,e),o&&(e.properties=Object.assign({},e.properties))),r.newGeometry&&(e.geometry=r.newGeometry),r.removeAllProperties)e.properties={};else if((null===(s=r.removeProperties)||void 0===s?void 0:s.length)>0)for(const t of r.removeProperties)Object.prototype.hasOwnProperty.call(e.properties,t)&&delete e.properties[t];if((null===(a=r.addOrUpdateProperties)||void 0===a?void 0:a.length)>0)for(const{key:t,value:n}of r.addOrUpdateProperties)e.properties[t]=n;}},t.cX=Ms,t.ca=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.cb=t=>"symbol"===t.type,t.cc=t=>"circle"===t.type,t.cd=t=>"heatmap"===t.type,t.ce=t=>"line"===t.type,t.cf=t=>"fill"===t.type,t.cg=t=>"fill-extrusion"===t.type,t.ch=t=>"hillshade"===t.type,t.ci=t=>"color-relief"===t.type,t.cj=t=>"raster"===t.type,t.ck=t=>"background"===t.type,t.cl=t=>"custom"===t.type,t.cm=T,t.cn=function(t,e,r){const n=z(e.x-r.x,e.y-r.y),i=z(t.x-r.x,t.y-r.y);var s,a;return et(Math.atan2(n[0]*i[1]-n[1]*i[0],(s=n)[0]*(a=i)[0]+s[1]*a[1]))},t.co=F,t.cp=function(t,e){return nt[e]&&(t instanceof MouseEvent||t instanceof WheelEvent)},t.cq=function(t,e){return rt[e]&&"touches"in t},t.cr=function(t){return rt[t]||nt[t]},t.cs=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},t.ct=function(t,e){const{x:r,y:n}=xh.fromLngLat(e);return !(t<0||t>25||n<0||n>=1||r<0||r>=1)},t.cu=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.cv=class extends Ks{},t.cw=xp,t.cy=function(t){return t.message===it},t.cz=ut,t.d=pt,t.e=O,t.f=t=>e(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})),t.g=ot,t.h=t=>new Promise(((e,r)=>{const n=new Image;n.onload=()=>{e(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame((()=>{n.src=H;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?URL.createObjectURL(i):H;})),t.i=X,t.j=(t,e)=>ht(O(t,{type:"json"}),e),t.k=mt,t.l=yt,t.m=ht,t.n=(t,e)=>ht(O(t,{type:"arrayBuffer"}),e),t.o=function(t){return new Ju(t).readFields(uc,[])},t.p=pc,t.q=el,t.r=Us,t.s=Q,t.t=Cs,t.u=fs,t.v=xt,t.w=q,t.x=Qi,t.y=ns,t.z=Wi;}));

define("worker",["./shared"],(function(e){"use strict";class t{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,i){for(const i of t){this._layerConfigs[i.id]=i;const t=this._layers[i.id]=e.bJ(i);t._featureFilter=e.aa(t.filter),this.keyCache[i.id]&&delete this.keyCache[i.id];}for(const e of i)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const o=e.cC(Object.values(this._layerConfigs),this.keyCache);for(const e of o){const t=e.map((e=>this._layers[e.id])),i=t[0];if("none"===i.visibility)continue;const o=i.source||"";let s=this.familiesBySource[o];s||(s=this.familiesBySource[o]={});const n=i.sourceLayer||"_geojsonTileLayer";let r=s[n];r||(r=s[n]=[]),r.push(t);}}}class i{constructor(t){const i={},o=[];for(const e in t){const s=t[e],n=i[e]={};for(const e in s){const t=s[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const i={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};o.push(i),n[e]={rect:i,metrics:t.metrics};}}const{w:s,h:n}=e.p(o),r=new e.q({width:s||1,height:n||1});for(const o in t){const s=t[o];for(const t in s){const n=s[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=i[o][t].rect;e.q.copy(n.bitmap,r,{x:0,y:0},{x:a.x+1,y:a.y+1},n.bitmap);}}this.image=r,this.positions=i;}}e.cD("GlyphAtlas",i);class o{constructor(t){this.tileID=new e.Z(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[],this.globalState=t.globalState;}parse(t,o,n,r,a){return e._(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.a8;const l=new e.cE(Object.keys(t.layers).sort()),c=new e.cF(this.tileID,this.promoteId);c.bucketLayerIDs=[];const u={},h={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:n,subdivisionGranularity:a},d=o.familiesBySource[this.source];for(const i in d){const o=t.layers[i];if(!o)continue;1===o.version&&e.w(`Vector tile source "${this.source}" layer "${i}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const r=l.encode(i),a=[];for(let e=0;e<o.length;e++){const t=o.feature(e),s=c.getId(t,i);a.push({feature:t,id:s,index:e,sourceLayerIndex:r});}for(const t of d[i]){const i=t[0];i.source!==this.source&&e.w(`layer.source = ${i.source} does not equal this.source = ${this.source}`),i.minzoom&&this.zoom<Math.floor(i.minzoom)||i.maxzoom&&this.zoom>=i.maxzoom||"none"!==i.visibility&&(s(t,this.zoom,n,this.globalState),(u[i.id]=i.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:r,sourceID:this.source,globalState:this.globalState})).populate(a,h,this.tileID.canonical),c.bucketLayerIDs.push(t.map((e=>e.id))));}}const f=e.bN(h.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let g=Promise.resolve({});if(Object.keys(f).length){const e=new AbortController;this.inFlightDependencies.push(e),g=r.sendAsync({type:"GG",data:{stacks:f,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const p=Object.keys(h.iconDependencies);let m=Promise.resolve({});if(p.length){const e=new AbortController;this.inFlightDependencies.push(e),m=r.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e);}const y=Object.keys(h.patternDependencies);let v=Promise.resolve({});if(y.length){const e=new AbortController;this.inFlightDependencies.push(e),v=r.sendAsync({type:"GI",data:{icons:y,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const[w,x,b]=yield Promise.all([g,m,v]),S=new i(w),M=new e.cG(x,b);for(const t in u){const i=u[t];i instanceof e.a9?(s(i.layers,this.zoom,n,this.globalState),e.cH({bucket:i,glyphMap:w,glyphPositions:S.positions,imageMap:x,imagePositions:M.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:h.subdivisionGranularity})):i.hasPattern&&(i instanceof e.cI||i instanceof e.cJ||i instanceof e.cK)&&(s(i.layers,this.zoom,n,this.globalState),i.addFeatures(h,this.tileID.canonical,M.patternPositions));}return this.status="done",{buckets:Object.values(u).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:S.image,imageAtlas:M,glyphMap:this.returnDependencies?w:null,iconMap:this.returnDependencies?x:null,glyphPositions:this.returnDependencies?S.positions:null}}))}}function s(t,i,o,s){const n=new e.F(i);for(const e of t)e.setGlobalState(s),e.recalculate(n,o);}class n{constructor(e,t,i){this.actor=e,this.layerIndex=t,this.availableImages=i,this.fetching={},this.loading={},this.loaded={};}loadVectorTile(t,i){return e._(this,void 0,void 0,(function*(){const o=yield e.n(t.request,i);try{return {vectorTile:new e.cL(new e.cM(o.data)),rawData:o.data,cacheControl:o.cacheControl,expires:o.expires}}catch(e){const i=new Uint8Array(o.data);let s=`Unable to parse the tile at ${t.request.url}, `;throw s+=31===i[0]&&139===i[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.message}`,new Error(s)}}))}loadTile(t){return e._(this,void 0,void 0,(function*(){const i=t.uid,s=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.cN(t.request),n=new o(t);this.loading[i]=n;const r=new AbortController;n.abort=r;try{const o=yield this.loadVectorTile(t,r);if(delete this.loading[i],!o)return null;const a=o.rawData,l={};o.expires&&(l.expires=o.expires),o.cacheControl&&(l.cacheControl=o.cacheControl);const c={};if(s){const e=s.finish();e&&(c.resourceTiming=JSON.parse(JSON.stringify(e)));}n.vectorTile=o.vectorTile;const u=n.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);this.loaded[i]=n,this.fetching[i]={rawTileData:a,cacheControl:l,resourceTiming:c};try{const t=yield u;return e.e({rawTileData:a.slice(0)},t,l,c)}finally{delete this.fetching[i];}}catch(e){throw delete this.loading[i],n.status="done",this.loaded[i]=n,e}}))}reloadTile(t){return e._(this,void 0,void 0,(function*(){const i=t.uid;if(!this.loaded||!this.loaded[i])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const o=this.loaded[i];if(o.showCollisionBoxes=t.showCollisionBoxes,o.globalState=t.globalState,"parsing"===o.status){const s=yield o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);let n;if(this.fetching[i]){const{rawTileData:t,cacheControl:o,resourceTiming:r}=this.fetching[i];delete this.fetching[i],n=e.e({rawTileData:t.slice(0)},s,o,r);}else n=s;return n}if("done"===o.status&&o.vectorTile)return o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity)}))}abortTile(t){return e._(this,void 0,void 0,(function*(){const e=this.loading,i=t.uid;e&&e[i]&&e[i].abort&&(e[i].abort.abort(),delete e[i]);}))}removeTile(t){return e._(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];}))}}class r{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:i,encoding:o,rawImageData:s,redFactor:n,greenFactor:r,blueFactor:a,baseShift:l}=t,c=s.width+2,u=s.height+2,h=e.b(s)?new e.R({width:c,height:u},yield e.cO(s,-1,-1,c,u)):s,d=new e.cP(i,h,o,n,r,a,l);return this.loaded=this.loaded||{},this.loaded[i]=d,d}))}removeTile(e){const t=this.loaded,i=e.uid;t&&t[i]&&delete t[i];}}var a,l,c=function(){if(l)return a;function e(e,i){if(0!==e.length){t(e[0],i);for(var o=1;o<e.length;o++)t(e[o],!i);}}function t(e,t){for(var i=0,o=0,s=0,n=e.length,r=n-1;s<n;r=s++){var a=(e[s][0]-e[r][0])*(e[r][1]+e[s][1]),l=i+a;o+=Math.abs(i)>=Math.abs(a)?i-l+a:a-l+i,i=l;}i+o>=0!=!!t&&e.reverse();}return l=1,a=function t(i,o){var s,n=i&&i.type;if("FeatureCollection"===n)for(s=0;s<i.features.length;s++)t(i.features[s],o);else if("GeometryCollection"===n)for(s=0;s<i.geometries.length;s++)t(i.geometries[s],o);else if("Feature"===n)t(i.geometry,o);else if("Polygon"===n)e(i.coordinates,o);else if("MultiPolygon"===n)for(s=0;s<i.coordinates.length;s++)e(i.coordinates[s],o);return i}}(),u=e.cQ(c);class h extends e.cS{constructor(t,i){super(new e.cM,0,i,[],[]),this.feature=t,this.type=t.type,this.properties=t.tags?t.tags:{},"id"in t&&("string"==typeof t.id?this.id=parseInt(t.id,10):"number"!=typeof t.id||isNaN(t.id)||(this.id=t.id));}loadGeometry(){const t=[],i=1===this.feature.type?[this.feature.geometry]:this.feature.geometry;for(const o of i){const i=[];for(const t of o)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}class d extends e.cR{constructor(t,i){super(new e.cM),this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.version=i?i.version:1,this.extent=i?i.extent:4096,this.length=t.length,this.features=t;}feature(e){return new h(this.features[e],this.extent)}}function f(e,t){t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);const i={keys:[],values:[],keycache:{},valuecache:{}};for(let o=0;o<e.length;o++)i.feature=e.feature(o),t.writeMessage(2,g,i);const o=i.keys;for(const e of o)t.writeStringField(3,e);const s=i.values;for(const e of s)t.writeMessage(4,w,e);}function g(e,t){if(!e.feature)return;const i=e.feature;void 0!==i.id&&t.writeVarintField(1,i.id),t.writeMessage(2,p,e),t.writeVarintField(3,i.type),t.writeMessage(4,v,i);}function p(e,t){for(const i in e.feature?.properties){let o=e.feature.properties[i],s=e.keycache[i];if(null===o)continue;void 0===s&&(e.keys.push(i),s=e.keys.length-1,e.keycache[i]=s),t.writeVarint(s),"string"!=typeof o&&"boolean"!=typeof o&&"number"!=typeof o&&(o=JSON.stringify(o));const n=typeof o+":"+o;let r=e.valuecache[n];void 0===r&&(e.values.push(o),r=e.values.length-1,e.valuecache[n]=r),t.writeVarint(r);}}function m(e,t){return (t<<3)+(7&e)}function y(e){return e<<1^e>>31}function v(e,t){const i=e.loadGeometry(),o=e.type;let s=0,n=0;for(const r of i){let i=1;1===o&&(i=r.length),t.writeVarint(m(1,i));const a=3===o?r.length-1:r.length;for(let e=0;e<a;e++){1===e&&1!==o&&t.writeVarint(m(2,a-1));const i=r[e].x-s,l=r[e].y-n;t.writeVarint(y(i)),t.writeVarint(y(l)),s+=i,n+=l;}3===e.type&&t.writeVarint(m(7,1));}}function w(e,t){const i=typeof e;"string"===i?t.writeStringField(1,e):"boolean"===i?t.writeBooleanField(7,e):"number"===i&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}const x={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},b=Math.fround||(S=new Float32Array(1),e=>(S[0]=+e,S[0]));var S;class M{constructor(e){this.options=Object.assign(Object.create(x),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:i,maxZoom:o}=this.options;t&&console.time("total time");const s=`prepare ${e.length} points`;t&&console.time(s),this.points=e;const n=[];for(let t=0;t<e.length;t++){const i=e[t];if(!i.geometry)continue;const[o,s]=i.geometry.coordinates,r=b(k(o)),a=b(P(s));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[o+1]=this._createTree(n);t&&console.timeEnd(s);for(let e=o;e>=i;e--){const i=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-i);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let i=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let s=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)i=-180,s=180;else if(i>s){const e=this.getClusters([i,o,180,n],t),r=this.getClusters([-180,o,s,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(k(i),P(n),k(s),P(o)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+5]>1?_(l,t,this.clusterProps):this.points[l[t+3]]);}return c}getChildren(e){const t=this._getOriginId(e),i=this._getOriginZoom(e),o="No cluster with the specified id.",s=this.trees[i];if(!s)throw new Error(o);const n=s.data;if(t*this.stride>=n.length)throw new Error(o);const r=this.options.radius/(this.options.extent*Math.pow(2,i-1)),a=s.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const i=t*this.stride;n[i+4]===e&&l.push(n[i+5]>1?_(n,i,this.clusterProps):this.points[n[i+3]]);}if(0===l.length)throw new Error(o);return l}getLeaves(e,t,i){const o=[];return this._appendLeaves(o,e,t=t||10,i=i||0,0),o}getTile(e,t,i){const o=this.trees[this._limitZoom(e)],s=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(i-a)/s,c=(i+1+a)/s,u={features:[]};return this._addTileFeatures(o.range((t-a)/s,l,(t+1+a)/s,c),o.data,t,i,s,u),0===t&&this._addTileFeatures(o.range(1-a/s,l,1,c),o.data,s,i,s,u),t===s-1&&this._addTileFeatures(o.range(0,l,a/s,c),o.data,-1,i,s,u),u.features.length?u:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const i=this.getChildren(e);if(t++,1!==i.length)break;e=i[0].properties.cluster_id;}return t}_appendLeaves(e,t,i,o,s){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?s+n.point_count<=o?s+=n.point_count:s=this._appendLeaves(e,n.cluster_id,i,o,s):s<o?s++:e.push(t),e.length===i)break}return s}_createTree(t){const i=new e.aI(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)i.add(t[e],t[e+1]);return i.finish(),i.data=t,i}_addTileFeatures(e,t,i,o,s,n){for(const r of e){const e=r*this.stride,a=t[e+5]>1;let l,c,u;if(a)l=I(t,e,this.clusterProps),c=t[e],u=t[e+1];else {const i=this.points[t[e+3]];l=i.properties;const[o,s]=i.geometry.coordinates;c=k(o),u=P(s);}const h={type:1,geometry:[[Math.round(this.options.extent*(c*s-i)),Math.round(this.options.extent*(u*s-o))]],tags:l};let d;d=a||this.options.generateId?t[e+3]:this.points[t[e+3]].id,void 0!==d&&(h.id=d),n.features.push(h);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:i,extent:o,reduce:s,minPoints:n}=this.options,r=i/(o*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let i=0;i<a.length;i+=c){if(a[i+2]<=t)continue;a[i+2]=t;const o=a[i],u=a[i+1],h=e.within(a[i],a[i+1],r),d=a[i+5];let f=d;for(const e of h){const i=e*c;a[i+2]>t&&(f+=a[i+5]);}if(f>d&&f>=n){let e,n=o*d,r=u*d,g=-1;const p=(i/c<<5)+(t+1)+this.points.length;for(const o of h){const l=o*c;if(a[l+2]<=t)continue;a[l+2]=t;const u=a[l+5];n+=a[l]*u,r+=a[l+1]*u,a[l+4]=p,s&&(e||(e=this._map(a,i,!0),g=this.clusterProps.length,this.clusterProps.push(e)),s(e,this._map(a,l)));}a[i+4]=p,l.push(n/f,r/f,1/0,p,-1,f),s&&l.push(g);}else {for(let e=0;e<c;e++)l.push(a[i+e]);if(f>1)for(const e of h){const i=e*c;if(!(a[i+2]<=t)){a[i+2]=t;for(let e=0;e<c;e++)l.push(a[i+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,i){if(e[t+5]>1){const o=this.clusterProps[e[t+6]];return i?Object.assign({},o):o}const o=this.points[e[t+3]].properties,s=this.options.map(o);return i&&s===o?Object.assign({},s):s}}function _(e,t,i){return {type:"Feature",id:e[t+3],properties:I(e,t,i),geometry:{type:"Point",coordinates:[(o=e[t],360*(o-.5)),T(e[t+1])]}};var o;}function I(e,t,i){const o=e[t+5],s=o>=1e4?`${Math.round(o/1e3)}k`:o>=1e3?Math.round(o/100)/10+"k":o,n=e[t+6],r=-1===n?{}:Object.assign({},i[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+3],point_count:o,point_count_abbreviated:s})}function k(e){return e/360+.5}function P(e){const t=Math.sin(e*Math.PI/180),i=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return i<0?0:i>1?1:i}function T(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function D(e,t,i,o){let s=o;const n=t+(i-t>>1);let r,a=i-t;const l=e[t],c=e[t+1],u=e[i],h=e[i+1];for(let o=t+3;o<i;o+=3){const t=C(e[o],e[o+1],l,c,u,h);if(t>s)r=o,s=t;else if(t===s){const e=Math.abs(o-n);e<a&&(r=o,a=e);}}s>o&&(r-t>3&&D(e,t,r,o),e[r+2]=s,i-r>3&&D(e,r,i,o));}function C(e,t,i,o,s,n){let r=s-i,a=n-o;if(0!==r||0!==a){const l=((e-i)*r+(t-o)*a)/(r*r+a*a);l>1?(i=s,o=n):l>0&&(i+=r*l,o+=a*l);}return r=e-i,a=t-o,r*r+a*a}function L(e,t,i,o){const s={id:null==e?null:e,type:t,geometry:i,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)O(s,i);else if("Polygon"===t)O(s,i[0]);else if("MultiLineString"===t)for(const e of i)O(s,e);else if("MultiPolygon"===t)for(const e of i)O(s,e[0]);return s}function O(e,t){for(let i=0;i<t.length;i+=3)e.minX=Math.min(e.minX,t[i]),e.minY=Math.min(e.minY,t[i+1]),e.maxX=Math.max(e.maxX,t[i]),e.maxY=Math.max(e.maxY,t[i+1]);}function F(e,t,i,o){if(!t.geometry)return;const s=t.geometry.coordinates;if(s&&0===s.length)return;const n=t.geometry.type,r=Math.pow(i.tolerance/((1<<i.maxZoom)*i.extent),2);let a=[],l=t.id;if(i.promoteId?l=t.properties[i.promoteId]:i.generateId&&(l=o||0),"Point"===n)z(s,a);else if("MultiPoint"===n)for(const e of s)z(e,a);else if("LineString"===n)E(s,a,r,!1);else if("MultiLineString"===n){if(i.lineMetrics){for(const i of s)a=[],E(i,a,r,!1),e.push(L(l,"LineString",a,t.properties));return}A(s,a,r,!1);}else if("Polygon"===n)A(s,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const s of t.geometry.geometries)F(e,{id:l,geometry:s,properties:t.properties},i,o);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of s){const t=[];A(e,t,r,!0),a.push(t);}}e.push(L(l,n,a,t.properties));}function z(e,t){t.push(Z(e[0]),j(e[1]),0);}function E(e,t,i,o){let s,n,r=0;for(let i=0;i<e.length;i++){const a=Z(e[i][0]),l=j(e[i][1]);t.push(a,l,0),i>0&&(r+=o?(s*l-a*n)/2:Math.sqrt(Math.pow(a-s,2)+Math.pow(l-n,2))),s=a,n=l;}const a=t.length-3;t[2]=1,D(t,0,a,i),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function A(e,t,i,o){for(let s=0;s<e.length;s++){const n=[];E(e[s],n,i,o),t.push(n);}}function Z(e){return e/360+.5}function j(e){const t=Math.sin(e*Math.PI/180),i=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return i<0?0:i>1?1:i}function G(e,t,i,o,s,n,r,a){if(o/=t,n>=(i/=t)&&r<o)return e;if(r<i||n>=o)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===s?t.minX:t.minY,c=0===s?t.maxX:t.maxY;if(r>=i&&c<o){l.push(t);continue}if(c<i||r>=o)continue;let u=[];if("Point"===n||"MultiPoint"===n)N(e,u,i,o,s);else if("LineString"===n)R(e,u,i,o,s,!1,a.lineMetrics);else if("MultiLineString"===n)J(e,u,i,o,s,!1);else if("Polygon"===n)J(e,u,i,o,s,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];J(t,e,i,o,s,!0),e.length&&u.push(e);}if(u.length){if(a.lineMetrics&&"LineString"===n){for(const e of u)l.push(L(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===u.length?(n="LineString",u=u[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===u.length?"Point":"MultiPoint"),l.push(L(t.id,n,u,t.tags));}}return l.length?l:null}function N(e,t,i,o,s){for(let n=0;n<e.length;n+=3){const r=e[n+s];r>=i&&r<=o&&Y(t,e[n],e[n+1],e[n+2]);}}function R(e,t,i,o,s,n,r){let a=W(e);const l=0===s?q:X;let c,u,h=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],g=e[d+1],p=e[d+2],m=e[d+3],y=e[d+4],v=0===s?f:g,w=0===s?m:y;let x=!1;r&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(g-y,2))),v<i?w>i&&(u=l(a,f,g,m,y,i),r&&(a.start=h+c*u)):v>o?w<o&&(u=l(a,f,g,m,y,o),r&&(a.start=h+c*u)):Y(a,f,g,p),w<i&&v>=i&&(u=l(a,f,g,m,y,i),x=!0),w>o&&v<=o&&(u=l(a,f,g,m,y,o),x=!0),!n&&x&&(r&&(a.end=h+c*u),t.push(a),a=W(e)),r&&(h+=c);}let d=e.length-3;const f=e[d],g=e[d+1],p=0===s?f:g;p>=i&&p<=o&&Y(a,f,g,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&Y(a,a[0],a[1],a[2]),a.length&&t.push(a);}function W(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function J(e,t,i,o,s,n){for(const r of e)R(r,t,i,o,s,n,!1);}function Y(e,t,i,o){e.push(t,i,o);}function q(e,t,i,o,s,n){const r=(n-t)/(o-t);return Y(e,n,i+(s-i)*r,1),r}function X(e,t,i,o,s,n){const r=(n-i)/(s-i);return Y(e,t+(o-t)*r,n,1),r}function H(e,t){const i=[];for(let o=0;o<e.length;o++){const s=e[o],n=s.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=V(s.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of s.geometry)r.push(V(e,t));}else if("MultiPolygon"===n){r=[];for(const e of s.geometry){const i=[];for(const o of e)i.push(V(o,t));r.push(i);}}i.push(L(s.id,n,r,s.tags));}return i}function V(e,t){const i=[];i.size=e.size,void 0!==e.start&&(i.start=e.start,i.end=e.end);for(let o=0;o<e.length;o+=3)i.push(e[o]+t,e[o+1],e[o+2]);return i}function B(e,t){if(e.transformed)return e;const i=1<<e.z,o=e.x,s=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push($(e[r],e[r+1],t,i,o,s));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push($(e[r][n],e[r][n+1],t,i,o,s));n.geometry.push(a);}}return e.transformed=!0,e}function $(e,t,i,o,s,n){return [Math.round(i*(e*o-s)),Math.round(i*(t*o-n))]}function U(e,t,i,o,s){const n=t===s.maxZoom?0:s.tolerance/((1<<t)*s.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:i,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)K(r,t,n,s);return r}function K(e,t,i,o){const s=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<s.length;t+=3)r.push(s[t],s[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)Q(r,s,e,i,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<s.length;t++)Q(r,s[t],e,i,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<s.length;t++){const o=s[t];for(let t=0;t<o.length;t++)Q(r,o[t],e,i,!0,0===t);}if(r.length){let i=t.tags||null;if("LineString"===n&&o.lineMetrics){i={};for(const e in t.tags)i[e]=t.tags[e];i.mapbox_clip_start=s.start/s.size,i.mapbox_clip_end=s.end/s.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:i};null!==t.id&&(a.id=t.id),e.features.push(a);}}function Q(e,t,i,o,s,n){const r=o*o;if(o>0&&t.size<(s?r:o))return void(i.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===o||t[e+2]>r)&&(i.numSimplified++,a.push(t[e],t[e+1])),i.numPoints++;s&&function(e,t){let i=0;for(let t=0,o=e.length,s=o-2;t<o;s=t,t+=2)i+=(e[t]-e[s])*(e[t+1]+e[s+1]);if(i>0===t)for(let t=0,i=e.length;t<i/2;t+=2){const o=e[t],s=e[t+1];e[t]=e[i-2-t],e[t+1]=e[i-1-t],e[i-2-t]=o,e[i-1-t]=s;}}(a,n),e.push(a);}const ee={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class te{constructor(e,t){const i=(t=this.options=function(e,t){for(const i in t)e[i]=t[i];return e}(Object.create(ee),t)).debug;if(i&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let o=function(e,t){const i=[];if("FeatureCollection"===e.type)for(let o=0;o<e.features.length;o++)F(i,e.features[o],t,o);else F(i,"Feature"===e.type?e:{geometry:e},t);return i}(e,t);this.tiles={},this.tileCoords=[],i&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),o=function(e,t){const i=t.buffer/t.extent;let o=e;const s=G(e,1,-1-i,i,0,-1,2,t),n=G(e,1,1-i,2+i,0,-1,2,t);return (s||n)&&(o=G(e,1,-i,1+i,0,-1,2,t)||[],s&&(o=H(s,1).concat(o)),n&&(o=o.concat(H(n,-1)))),o}(o,t),o.length&&this.splitTile(o,0,0,0),i&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,i,o,s,n,r){const a=[e,t,i,o],l=this.options,c=l.debug;for(;a.length;){o=a.pop(),i=a.pop(),t=a.pop(),e=a.pop();const u=1<<t,h=ie(t,i,o);let d=this.tiles[h];if(!d&&(c>1&&console.time("creation"),d=this.tiles[h]=U(e,t,i,o,l),this.tileCoords.push({z:t,x:i,y:o}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,i,o,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==s){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===s)continue;if(null!=s){const e=s-t;if(i!==n>>e||o!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,g=.5-f,p=.5+f,m=1+f;let y=null,v=null,w=null,x=null,b=G(e,u,i-f,i+p,0,d.minX,d.maxX,l),S=G(e,u,i+g,i+m,0,d.minX,d.maxX,l);e=null,b&&(y=G(b,u,o-f,o+p,1,d.minY,d.maxY,l),v=G(b,u,o+g,o+m,1,d.minY,d.maxY,l),b=null),S&&(w=G(S,u,o-f,o+p,1,d.minY,d.maxY,l),x=G(S,u,o+g,o+m,1,d.minY,d.maxY,l),S=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*i,2*o),a.push(v||[],t+1,2*i,2*o+1),a.push(w||[],t+1,2*i+1,2*o),a.push(x||[],t+1,2*i+1,2*o+1);}}getTile(e,t,i){e=+e,t=+t,i=+i;const o=this.options,{extent:s,debug:n}=o;if(e<0||e>24)return null;const r=1<<e,a=ie(e,t=t+r&r-1,i);if(this.tiles[a])return B(this.tiles[a],s);n>1&&console.log("drilling down to z%d-%d-%d",e,t,i);let l,c=e,u=t,h=i;for(;!l&&c>0;)c--,u>>=1,h>>=1,l=this.tiles[ie(c,u,h)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,u,h),console.time("drilling down")),this.splitTile(l.source,c,u,h,e,t,i),n>1&&console.timeEnd("drilling down"),this.tiles[a]?B(this.tiles[a],s):null):null}}function ie(e,t,i){return 32*((1<<e)*i+t)+e}class oe extends n{constructor(){super(...arguments),this._dataUpdateable=new Map;}loadVectorTile(t,i){return e._(this,void 0,void 0,(function*(){const i=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const o=this._geoJSONIndex.getTile(i.z,i.x,i.y);if(!o)return null;const s=new d(o.features,{version:2,extent:e.$});let n=function(t){const i=new e.cM;return function(e,t){for(const i in e.layers)t.writeMessage(3,f,e.layers[i]);}(t,i),i.finish()}(s);return 0===n.byteOffset&&n.byteLength===n.buffer.byteLength||(n=new Uint8Array(n)),{vectorTile:s,rawData:n.buffer}}))}loadData(t){return e._(this,void 0,void 0,(function*(){var i;null===(i=this._pendingRequest)||void 0===i||i.abort();const o=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.cN(t.request);this._pendingRequest=new AbortController;try{this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest);const i=yield this._pendingData;this._geoJSONIndex=t.cluster?new M(function({superclusterOptions:t,clusterProperties:i}){if(!i||!t)return t;const o={},s={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(i);for(const t of a){const[n,r]=i[t],a=e.cT(r),l=e.cT("string"==typeof n?[n,["accumulated"],["get",t]]:n);o[t]=a.value,s[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=s[t].evaluate(n,r);},t}(t)).load(i.features):function(e,t){return new te(e,t)}(i,t.geojsonVtOptions),this.loaded={};const s={data:i};if(o){const e=o.finish();e&&(s.resourceTiming={},s.resourceTiming[t.source]=JSON.parse(JSON.stringify(e)));}return s}catch(t){if(delete this._pendingRequest,e.cy(t))return {abandoned:!0};throw t}}))}getData(){return e._(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadAndProcessGeoJSON(t,i){return e._(this,void 0,void 0,(function*(){let o=yield this.loadGeoJSON(t,i);if(delete this._pendingRequest,"object"!=typeof o)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(u(o,!0),t.filter){const i=e.cT(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===i.result)throw new Error(i.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const s=o.features.filter((e=>i.value.evaluate({zoom:0},e)));o={type:"FeatureCollection",features:s};}return o}))}loadGeoJSON(t,i){return e._(this,void 0,void 0,(function*(){const{promoteId:o}=t;if(t.request){const s=yield e.j(t.request,i);return this._dataUpdateable=e.cV(s.data,o)?e.cU(s.data,o):void 0,s.data}if("string"==typeof t.data)try{const i=JSON.parse(t.data);return this._dataUpdateable=e.cV(i,o)?e.cU(i,o):void 0,i}catch(e){throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`)}if(!t.dataDiff)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${t.source}`);return e.cW(this._dataUpdateable,t.dataDiff,o),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(t){return e._(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort();}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}class se{constructor(t){this.self=t,this.actor=new e.J(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.cA,this.self.removeProtocol=e.cB,this.self.registerRTLTextPlugin=t=>{e.cX.setMethods(t);},this.actor.registerMessageHandler("LDT",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("RDT",((t,i)=>e._(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,i.source).removeTile(i);})))),this.actor.registerMessageHandler("GCEZ",((t,i)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,i.type,i.source).getClusterExpansionZoom(i)})))),this.actor.registerMessageHandler("GCC",((t,i)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,i.type,i.source).getClusterChildren(i)})))),this.actor.registerMessageHandler("GCL",((t,i)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,i.type,i.source).getClusterLeaves(i)})))),this.actor.registerMessageHandler("LD",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("GD",((e,t)=>this._getWorkerSource(e,t.type,t.source).getData())),this.actor.registerMessageHandler("LT",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("RT",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("AT",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("RMT",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("RS",((t,i)=>e._(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][i.type]||!this.workerSources[t][i.type][i.source])return;const e=this.workerSources[t][i.type][i.source];delete this.workerSources[t][i.type][i.source],void 0!==e.removeSource&&e.removeSource(i);})))),this.actor.registerMessageHandler("RM",(t=>e._(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t];})))),this.actor.registerMessageHandler("SR",((t,i)=>e._(this,void 0,void 0,(function*(){this.referrer=i;})))),this.actor.registerMessageHandler("SRPS",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("IS",((t,i)=>e._(this,void 0,void 0,(function*(){this.self.importScripts(i);})))),this.actor.registerMessageHandler("SI",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("UL",((t,i)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(i.layers,i.removedIds);})))),this.actor.registerMessageHandler("SL",((t,i)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(i);}))));}_setImages(t,i){return e._(this,void 0,void 0,(function*(){this.availableImages[t]=i;for(const e in this.workerSources[t]){const o=this.workerSources[t][e];for(const e in o)o[e].availableImages=i;}}))}_syncRTLPluginState(t,i){return e._(this,void 0,void 0,(function*(){return yield e.cX.syncState(i,this.self.importScripts)}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let i=this.layerIndexes[e];return i||(i=this.layerIndexes[e]=new t),i}_getWorkerSource(e,t,i){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][i]){const o={sendAsync:(t,i)=>(t.targetMapId=e,this.actor.sendAsync(t,i))};switch(t){case "vector":this.workerSources[e][t][i]=new n(o,this._getLayerIndex(e),this._getAvailableImages(e));break;case "geojson":this.workerSources[e][t][i]=new oe(o,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][i]=new this.externalWorkerSourceTypes[t](o,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][i]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new r),this.demWorkerSources[e][t]}}return e.i(self)&&(self.worker=new se(self)),se}));

define("index",["exports","./shared"],(function(e,t){"use strict";var i="5.7.1";function o(){var e=new t.A(4);return t.A!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e}let r,a;const s={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frame(e,i,o){const r=requestAnimationFrame((e=>{a(),i(e);})),{unsubscribe:a}=t.s(e.signal,"abort",(()=>{a(),cancelAnimationFrame(r),o(t.c());}),!1);},frameAsync(e){return new Promise(((t,i)=>{this.frame(e,t,i);}))},getImageData(e,t=0){return this.getImageCanvasContext(e).getImageData(-t,-t,e.width+2*t,e.height+2*t)},getImageCanvasContext(e){const t=window.document.createElement("canvas"),i=t.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0,e.width,e.height),i},resolveURL:e=>(r||(r=document.createElement("a")),r.href=e,r.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return !!matchMedia&&(null==a&&(a=matchMedia("(prefers-reduced-motion: reduce)")),a.matches)}};class n{static testProp(e){if(!n.docStyle)return e[0];for(let t=0;t<e.length;t++)if(e[t]in n.docStyle)return e[t];return e[0]}static create(e,t,i){const o=window.document.createElement(e);return void 0!==t&&(o.className=t),i&&i.appendChild(o),o}static createNS(e,t){return window.document.createElementNS(e,t)}static disableDrag(){n.docStyle&&n.selectProp&&(n.userSelect=n.docStyle[n.selectProp],n.docStyle[n.selectProp]="none");}static enableDrag(){n.docStyle&&n.selectProp&&(n.docStyle[n.selectProp]=n.userSelect);}static setTransform(e,t){e.style[n.transformProp]=t;}static addEventListener(e,t,i,o={}){e.addEventListener(t,i,"passive"in o?o:o.capture);}static removeEventListener(e,t,i,o={}){e.removeEventListener(t,i,"passive"in o?o:o.capture);}static suppressClickInternal(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",n.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",n.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",n.suppressClickInternal,!0);}),0);}static getScale(e){const t=e.getBoundingClientRect();return {x:t.width/e.offsetWidth||1,y:t.height/e.offsetHeight||1,boundingClientRect:t}}static getPoint(e,i,o){const r=i.boundingClientRect;return new t.P((o.clientX-r.left)/i.x-e.clientLeft,(o.clientY-r.top)/i.y-e.clientTop)}static mousePos(e,t){const i=n.getScale(e);return n.getPoint(e,i,t)}static touchPos(e,t){const i=[],o=n.getScale(e);for(let r=0;r<t.length;r++)i.push(n.getPoint(e,o,t[r]));return i}static mouseButton(e){return e.button}static remove(e){e.parentNode&&e.parentNode.removeChild(e);}static sanitize(e){const t=(new DOMParser).parseFromString(e,"text/html").body||document.createElement("body"),i=t.querySelectorAll("script");for(const e of i)e.remove();return n.clean(t),t.innerHTML}static isPossiblyDangerous(e,t){const i=t.replace(/\s+/g,"").toLowerCase();return !(!["src","href","xlink:href"].includes(e)||!i.includes("javascript:")&&!i.includes("data:"))||!!e.startsWith("on")||void 0}static clean(e){const t=e.children;for(const e of t)n.removeAttributes(e),n.clean(e);}static removeAttributes(e){for(const{name:t,value:i}of e.attributes)n.isPossiblyDangerous(t,i)&&e.removeAttribute(t);}}n.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,n.selectProp=n.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),n.transformProp=n.testProp(["transform","WebkitTransform"]);const l={supported:!1,testSupport:function(e){!u&&h&&(d?_(e):c=e);}};let c,h,u=!1,d=!1;function _(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,h),e.isContextLost())return;l.supported=!0;}catch(e){}e.deleteTexture(t),u=!0;}var p;"undefined"!=typeof document&&(h=document.createElement("img"),h.onload=()=>{c&&_(c),c=null,d=!0;},h.onerror=()=>{u=!0,c=null;},h.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(e){let i,o,r,a;e.resetRequestQueue=()=>{i=[],o=0,r=0,a={};},e.addThrottleControl=e=>{const t=r++;return a[t]=e,t},e.removeThrottleControl=e=>{delete a[e],n();},e.getImage=(e,o,r=!0)=>new Promise(((a,s)=>{l.supported&&(e.headers||(e.headers={}),e.headers.accept="image/webp,*/*"),t.e(e,{type:"image"}),i.push({abortController:o,requestParameters:e,supportImageRefresh:r,state:"queued",onError:e=>{s(e);},onSuccess:e=>{a(e);}}),n();}));const s=e=>t._(this,void 0,void 0,(function*(){e.state="running";const{requestParameters:i,supportImageRefresh:r,onError:a,onSuccess:s,abortController:l}=e,h=!1===r&&!t.i(self)&&!t.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce(((e,t)=>e&&"accept"===t),!0));o++;const u=h?c(i,l):t.m(i,l);try{const i=yield u;delete e.abortController,e.state="completed",i.data instanceof HTMLImageElement||t.b(i.data)?s(i):i.data&&s({data:yield(d=i.data,"function"==typeof createImageBitmap?t.f(d):t.h(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(t){delete e.abortController,a(t);}finally{o--,n();}var d;})),n=()=>{const e=(()=>{for(const e of Object.keys(a))if(a[e]())return !0;return !1})()?t.a.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:t.a.MAX_PARALLEL_IMAGE_REQUESTS;for(let t=o;t<e&&i.length>0;t++){const e=i.shift();e.abortController.signal.aborted?t--:s(e);}},c=(e,i)=>new Promise(((o,r)=>{const a=new Image,s=e.url,n=e.credentials;n&&"include"===n?a.crossOrigin="use-credentials":(n&&"same-origin"===n||!t.d(s))&&(a.crossOrigin="anonymous"),i.signal.addEventListener("abort",(()=>{a.src="",r(t.c());})),a.fetchPriority="high",a.onload=()=>{a.onerror=a.onload=null,o({data:a});},a.onerror=()=>{a.onerror=a.onload=null,i.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},a.src=s;}));}(p||(p={})),p.resetRequestQueue();class m{constructor(e){this._transformRequestFn=null!=e?e:null;}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}setTransformRequest(e){this._transformRequestFn=e;}}function f(e){const t=[];if("string"==typeof e)t.push({id:"default",url:e});else if(e&&e.length>0){const i=[];for(const{id:o,url:r}of e){const e=`${o}${r}`;-1===i.indexOf(e)&&(i.push(e),t.push({id:o,url:r}));}}return t}function g(e,t,i){try{const o=new URL(e);return o.pathname+=`${t}${i}`,o.toString()}catch(t){throw new Error(`Invalid sprite URL "${e}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function v(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class b extends t.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,promiseResolve:t}of this.requestors)t(this._getImagesForIds(e));this.requestors=[];}}getImage(e){const i=this.images[e];if(i&&!i.data&&i.spriteData){const e=i.spriteData;i.data=new t.R({width:e.width,height:e.height},e.context.getImageData(e.x,e.y,e.width,e.height).data),i.spriteData=null;}return i}addImage(e,t){if(this.images[e])throw new Error(`Image id ${e} already exist, use updateImage instead`);this._validate(e,t)&&(this.images[e]=t);}_validate(e,i){let o=!0;const r=i.data||i.spriteData;return this._validateStretch(i.stretchX,r&&r.width)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,r&&r.height)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;const i=t.spriteData,o=i&&i.width||t.data.width,r=i&&i.height||t.data.height;return !(e[0]<0||o<e[0]||e[1]<0||r<e[1]||e[2]<0||o<e[2]||e[3]<0||r<e[3]||e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i=!0){const o=this.getImage(e);if(i&&(o.data.width!==t.data.width||o.data.height!==t.data.height))throw new Error(`size mismatch between old image (${o.data.width}x${o.data.height}) and new image (${t.data.width}x${t.data.height}).`);t.version=o.version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e){return new Promise(((t,i)=>{let o=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(o=!1);this.isLoaded()||o?t(this._getImagesForIds(e)):this.requestors.push({ids:e,promiseResolve:t});}))}_getImagesForIds(e){const i={};for(const o of e){let e=this.getImage(o);e||(this.fire(new t.l("styleimagemissing",{id:o})),e=this.getImage(o)),e?i[o]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,textFitWidth:e.textFitWidth,textFitHeight:e.textFitHeight,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.w(`Image "${o}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(e){const i=this.patterns[e],o=this.getImage(e);if(!o)return null;if(i&&i.position.version===o.version)return i.position;if(i)i.position.version=o.version;else {const i={w:o.data.width+2,h:o.data.height+2,x:0,y:0},r=new t.I(i,o);this.patterns[e]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const i=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new t.T(e,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:o}=t.p(e),r=this.atlasImage;r.resize({width:i||1,height:o||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],o=i.x+1,a=i.y+1,s=this.getImage(e).data,n=s.width,l=s.height;t.R.copy(s,r,{x:0,y:0},{x:o,y:a},{width:n,height:l}),t.R.copy(s,r,{x:0,y:l-1},{x:o,y:a-1},{width:n,height:1}),t.R.copy(s,r,{x:0,y:0},{x:o,y:a+l},{width:n,height:1}),t.R.copy(s,r,{x:n-1,y:0},{x:o-1,y:a},{width:1,height:l}),t.R.copy(s,r,{x:0,y:0},{x:o+n,y:a},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const i of e){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const e=this.getImage(i);e||t.w(`Image with ID: "${i}" was not found`),v(e)&&this.updateImage(i,e);}}}const x=1e20;function y(e,t,i,o,r,a,s,n,l){for(let c=t;c<t+o;c++)w(e,i*a+c,a,r,s,n,l);for(let c=i;c<i+r;c++)w(e,c*a+t,1,o,s,n,l);}function w(e,t,i,o,r,a,s){a[0]=0,s[0]=-x,s[1]=x,r[0]=e[t];for(let n=1,l=0,c=0;n<o;n++){r[n]=e[t+n*i];const o=n*n;do{const e=a[l];c=(r[n]-r[e]+o-e*e)/(n-e)/2;}while(c<=s[l]&&--l>-1);l++,a[l]=n,s[l]=c,s[l+1]=x;}for(let n=0,l=0;n<o;n++){for(;s[l+1]<n;)l++;const o=a[l],c=n-o;e[t+n*i]=r[o]+c*c;}}class T{constructor(e,t,i){this.requestManager=e,this.localIdeographFontFamily=t,this.entries={},this.lang=i;}setURL(e){this.url=e;}getGlyphs(e){return t._(this,void 0,void 0,(function*(){const t=[];for(const i in e)for(const o of e[i])t.push(this._getAndCacheGlyphsPromise(i,o));const i=yield Promise.all(t),o={};for(const{stack:e,id:t,glyph:r}of i)o[e]||(o[e]={}),o[e][t]=r&&{id:r.id,bitmap:r.bitmap.clone(),metrics:r.metrics};return o}))}_getAndCacheGlyphsPromise(e,i){return t._(this,void 0,void 0,(function*(){let t=this.entries[e];t||(t=this.entries[e]={glyphs:{},requests:{},ranges:{}});let o=t.glyphs[i];if(void 0!==o)return {stack:e,id:i,glyph:o};if(o=this._tinySDF(t,e,i),o)return t.glyphs[i]=o,{stack:e,id:i,glyph:o};const r=Math.floor(i/256);if(256*r>65535)throw new Error("glyphs > 65535 not supported");if(t.ranges[r])return {stack:e,id:i,glyph:o};if(!this.url)throw new Error("glyphsUrl is not set");if(!t.requests[r]){const i=T.loadGlyphRange(e,r,this.url,this.requestManager);t.requests[r]=i;}const a=yield t.requests[r];for(const e in a)this._doesCharSupportLocalGlyph(+e)||(t.glyphs[+e]=a[+e]);return t.ranges[r]=!0,{stack:e,id:i,glyph:a[i]||null}}))}_doesCharSupportLocalGlyph(e){return !!this.localIdeographFontFamily&&(/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(e))||t.u["CJK Unified Ideographs"](e)||t.u["Hangul Syllables"](e)||t.u.Hiragana(e)||t.u.Katakana(e)||t.u["CJK Symbols and Punctuation"](e)||t.u["Halfwidth and Fullwidth Forms"](e))}_tinySDF(e,i,o){const r=this.localIdeographFontFamily;if(!r)return;if(!this._doesCharSupportLocalGlyph(o))return;let a=e.tinySDF;if(!a){let t="400";/bold/i.test(i)?t="900":/medium/i.test(i)?t="500":/light/i.test(i)&&(t="200"),a=e.tinySDF=new T.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,lang:this.lang,fontFamily:r,fontWeight:t});}const s=a.draw(String.fromCharCode(o));return {id:o,bitmap:new t.q({width:s.width||60,height:s.height||60},s.data),metrics:{width:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:s.glyphAdvance/2||24,isDoubleResolution:!0}}}}T.loadGlyphRange=function(e,i,o,r){return t._(this,void 0,void 0,(function*(){const a=256*i,s=a+255,n=r.transformRequest(o.replace("{fontstack}",e).replace("{range}",`${a}-${s}`),"Glyphs"),l=yield t.n(n,new AbortController);if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${a}-${s}`);const c={};for(const e of t.o(l.data))c[e.id]=e;return c}))},T.TinySDF=class{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:o=.25,fontFamily:r="sans-serif",fontWeight:a="normal",fontStyle:s="normal",lang:n=null}={}){this.buffer=t,this.cutoff=o,this.radius=i,this.lang=n;const l=this.size=e+4*t,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${s} ${a} ${e}px ${r}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l);}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:o,actualBoundingBoxLeft:r,actualBoundingBoxRight:a}=this.ctx.measureText(e),s=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(a-r))),l=Math.min(this.size-this.buffer,s+Math.ceil(o)),c=n+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),_={data:d,width:c,height:h,glyphWidth:n,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:t};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;this.lang&&(p.lang=this.lang),p.clearRect(m,m,n,l),p.fillText(e,m,m+s);const v=p.getImageData(m,m,n,l);g.fill(x,0,u),f.fill(0,0,u);for(let e=0;e<l;e++)for(let t=0;t<n;t++){const i=v.data[4*(e*n+t)+3]/255;if(0===i)continue;const o=(e+m)*c+t+m;if(1===i)g[o]=0,f[o]=x;else {const e=.5-i;g[o]=e>0?e*e:0,f[o]=e<0?e*e:0;}}y(g,0,0,c,h,c,this.f,this.v,this.z),y(f,m,m,n,l,c,this.f,this.v,this.z);for(let e=0;e<u;e++){const t=Math.sqrt(g[e])-Math.sqrt(f[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff));}return _}};class P{constructor(){this.specification=t.v.light.position;}possiblyEvaluate(e,i){return t.B(e.expression.evaluate(i))}interpolate(e,i,o){return {x:t.C.number(e.x,i.x,o),y:t.C.number(e.y,i.y,o),z:t.C.number(e.z,i.z,o)}}}let C;class I extends t.E{constructor(e){super(),C=C||new t.r({anchor:new t.D(t.v.light.anchor),position:new P,color:new t.D(t.v.light.color),intensity:new t.D(t.v.light.intensity)}),this._transitionable=new t.t(C),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,i={}){if(!this._validate(t.x,e,i))for(const t in e){const i=e[t];t.endsWith("-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,o){return (!o||!1!==o.validate)&&t.y(this,e.call(t.z,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.v}))}}const M=new t.r({"sky-color":new t.D(t.v.sky["sky-color"]),"horizon-color":new t.D(t.v.sky["horizon-color"]),"fog-color":new t.D(t.v.sky["fog-color"]),"fog-ground-blend":new t.D(t.v.sky["fog-ground-blend"]),"horizon-fog-blend":new t.D(t.v.sky["horizon-fog-blend"]),"sky-horizon-blend":new t.D(t.v.sky["sky-horizon-blend"]),"atmosphere-blend":new t.D(t.v.sky["atmosphere-blend"])});class S extends t.E{constructor(e){super(),this._transitionable=new t.t(M),this.setSky(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.F(0));}setSky(e,i={}){if(!this._validate(t.G,e,i)){e||(e={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const t in e){const i=e[t];t.endsWith("-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i);}}}getSky(){return this._transitionable.serialize()}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,o={}){return !1!==(null==o?void 0:o.validate)&&t.y(this,e.call(t.z,t.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.v})))}calculateFogBlendOpacity(e){return e<60?0:e<70?(e-60)/10:1}}class E{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i]}getDashRanges(e,t,i){const o=[];let r=e.length%2==1?-e[e.length-1]*i:0,a=e[0]*i,s=!0;o.push({left:r,right:a,isDash:s,zeroLength:0===e[0]});let n=e[0];for(let t=1;t<e.length;t++){s=!s;const l=e[t];r=n*i,n+=l,a=n*i,o.push({left:r,right:a,isDash:s,zeroLength:0===l});}return o}addRoundDash(e,t,i){const o=t/2;for(let t=-i;t<=i;t++){const r=this.width*(this.nextRow+i+t);let a=0,s=e[a];for(let n=0;n<this.width;n++){n/s.right>1&&(s=e[++a]);const l=Math.abs(n-s.left),c=Math.abs(n-s.right),h=Math.min(l,c);let u;const d=t/i*(o+1);if(s.isDash){const e=o-Math.abs(d);u=Math.sqrt(h*h+e*e);}else u=o-Math.sqrt(h*h+d*d);this.data[r+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],o=e[t+1];i.zeroLength?e.splice(t,1):o&&o.isDash===i.isDash&&(o.left=i.left,e.splice(t,1));}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const o=this.width*this.nextRow;let r=0,a=e[r];for(let t=0;t<this.width;t++){t/a.right>1&&(a=e[++r]);const i=Math.abs(t-a.left),s=Math.abs(t-a.right),n=Math.min(i,s);this.data[o+t]=Math.max(0,Math.min(255,(a.isDash?n:-n)+128));}}addDash(e,i){const o=i?7:0,r=2*o+1;if(this.nextRow+r>this.height)return t.w("LineAtlas out of space"),null;let a=0;for(let t=0;t<e.length;t++)a+=e[t];if(0!==a){const t=this.width/a,r=this.getDashRanges(e,this.width,t);i?this.addRoundDash(r,t,o):this.addRegularDash(r);}const s={y:(this.nextRow+o+.5)/this.height,height:2*o/this.height,width:a};return this.nextRow+=r,this.dirty=!0,s}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data));}}const R="maplibre_preloaded_worker_pool";class z{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<z.workerCount;)this.workers.push(new Worker(t.a.WORKER_URL));return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[R]}numActive(){return Object.keys(this.active).length}}const D=Math.floor(s.hardwareConcurrency/2);let A,L;function k(){return A||(A=new z),A}z.workerCount=t.H(globalThis)?Math.max(Math.min(D,3),1):1;class F{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=i;const o=this.workerPool.acquire(i);for(let e=0;e<o.length;e++){const r=new t.J(o[e],i);r.name=`Worker ${e}`,this.actors.push(r);}if(!this.actors.length)throw new Error("No actors found")}broadcast(e,t){const i=[];for(const o of this.actors)i.push(o.sendAsync({type:e,data:t}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(e=!0){this.actors.forEach((e=>{e.remove();})),this.actors=[],e&&this.workerPool.release(this.id);}registerMessageHandler(e,t){for(const i of this.actors)i.registerMessageHandler(e,t);}}function B(){return L||(L=new F(k(),t.K),L.registerMessageHandler("GR",((e,i,o)=>t.m(i,o)))),L}function O(e,i){const o=t.L();return t.M(o,o,[1,1,0]),t.N(o,o,[.5*e.width,.5*e.height,1]),e.calculatePosMatrix?t.O(o,o,e.calculatePosMatrix(i.toUnwrapped())):o}function j(e,t,i,o,r,a,s){var n;const l=function(e,t,i){if(e)for(const o of e){const e=t[o];if(e&&e.source===i&&"fill-extrusion"===e.type)return !0}else for(const e in t){const o=t[e];if(o.source===i&&"fill-extrusion"===o.type)return !0}return !1}(null!==(n=null==r?void 0:r.layers)&&void 0!==n?n:null,t,e.id),c=a.maxPitchScaleFactor(),h=e.tilesIn(o,c,l);h.sort(N);const u=[];for(const o of h)u.push({wrappedTileID:o.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(t,i,e._state,o.queryGeometry,o.cameraQueryGeometry,o.scale,r,a,c,O(e.transform,o.tileID),s?(e,t)=>s(o.tileID,e,t):void 0)});return function(e,t){for(const i in e)for(const o of e[i])U(o,t);return e}(function(e){const t={},i={};for(const o of e){const e=o.queryResults,r=o.wrappedTileID,a=i[r]=i[r]||{};for(const i in e){const o=e[i],r=a[i]=a[i]||{},s=t[i]=t[i]||[];for(const e of o)r[e.featureIndex]||(r[e.featureIndex]=!0,s.push(e));}}return t}(u),e)}function N(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function U(e,t){const i=e.feature,o=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=o;}function Z(e,i,o){return t._(this,void 0,void 0,(function*(){let r=e;if(e.url?r=(yield t.j(i.transformRequest(e.url,"Source"),o)).data:yield s.frameAsync(o),!r)return null;const a=t.Q(t.e(r,e),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return "vector_layers"in r&&r.vector_layers&&(a.vectorLayerIds=r.vector_layers.map((e=>e.id))),a}))}class G{constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):Array.isArray(e)&&(4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1])));}setNorthEast(e){return this._ne=e instanceof t.S?new t.S(e.lng,e.lat):t.S.convert(e),this}setSouthWest(e){return this._sw=e instanceof t.S?new t.S(e.lng,e.lat):t.S.convert(e),this}extend(e){const i=this._sw,o=this._ne;let r,a;if(e instanceof t.S)r=e,a=e;else {if(!(e instanceof G))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend(G.convert(e)):this.extend(t.S.convert(e)):e&&("lng"in e||"lon"in e)&&"lat"in e?this.extend(t.S.convert(e)):this;if(r=e._sw,a=e._ne,!r||!a)return this}return i||o?(i.lng=Math.min(r.lng,i.lng),i.lat=Math.min(r.lat,i.lat),o.lng=Math.max(a.lng,o.lng),o.lat=Math.max(a.lat,o.lat)):(this._sw=new t.S(r.lng,r.lat),this._ne=new t.S(a.lng,a.lat)),this}getCenter(){return new t.S((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new t.S(this.getWest(),this.getNorth())}getSouthEast(){return new t.S(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(e){const{lng:i,lat:o}=t.S.convert(e);let r=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=o&&o<=this._ne.lat&&r}static convert(e){return e instanceof G?e:e?new G(e):e}static fromLngLat(e,i=0){const o=360*i/40075017,r=o/Math.cos(Math.PI/180*e.lat);return new G(new t.S(e.lng-r,e.lat-o),new t.S(e.lng+r,e.lat+o))}adjustAntiMeridian(){const e=new t.S(this._sw.lng,this._sw.lat),i=new t.S(this._ne.lng,this._ne.lat);return new G(e,e.lng>i.lng?new t.S(i.lng+360,i.lat):i)}}class V{constructor(e,t,i){this.bounds=G.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const i=Math.pow(2,e.z),o=Math.floor(t.V(this.bounds.getWest())*i),r=Math.floor(t.U(this.bounds.getNorth())*i),a=Math.ceil(t.V(this.bounds.getEast())*i),s=Math.ceil(t.U(this.bounds.getSouth())*i);return e.x>=o&&e.x<a&&e.y>=r&&e.y<s}}class $ extends t.E{constructor(e,i,o,r){if(super(),this.id=e,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.e(this,t.Q(i,["url","scheme","tileSize","promoteId"])),this._options=t.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r);}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield Z(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),e&&(t.e(this,e),e.bounds&&(this.tileBounds=new V(e.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})));}catch(e){this._tileJSONRequest=null,this.fire(new t.k(e));}}))}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.abort(),e(),this.load();}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return t.e({},this._options)}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(t,"Tile"),uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,globalState:this.map.getGlobalState()};i.request.collectResourceTiming=this._collectResourceTiming;let o="RT";if(e.actor&&"expired"!==e.state){if("loading"===e.state)return new Promise(((t,i)=>{e.reloadPromise={resolve:t,reject:i};}))}else e.actor=this.dispatcher.getActor(),o="LT";e.abortController=new AbortController;try{const t=yield e.actor.sendAsync({type:o,data:i},e.abortController);if(delete e.abortController,e.aborted)return;this._afterTileLoadWorkerResponse(e,t);}catch(t){if(delete e.abortController,e.aborted)return;if(t&&404!==t.status)throw t;this._afterTileLoadWorkerResponse(e,null);}}))}_afterTileLoadWorkerResponse(e,t){if(t&&t.resourceTiming&&(e.resourceTiming=t.resourceTiming),t&&this.map._refreshExpiredTiles&&e.setExpiryData(t),e.loadVectorData(t,this.map.painter),e.reloadPromise){const t=e.reloadPromise;e.reloadPromise=null,this.loadTile(e).then(t.resolve).catch(t.reject);}}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.actor&&(yield e.actor.sendAsync({type:"AT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),e.actor&&(yield e.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}hasTransition(){return !1}}class q extends t.E{constructor(e,i,o,r){super(),this.id=e,this.dispatcher=o,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.e({type:"raster"},i),t.e(this,t.Q(i,["url","scheme","tileSize"]));}load(){return t._(this,arguments,void 0,(function*(e=!1){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const i=yield Z(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,i&&(t.e(this,i),i.bounds&&(this.tileBounds=new V(i.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:e})));}catch(e){this._tileJSONRequest=null,this.fire(new t.k(e));}}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(e){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),e(),this.load(!0);}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}serialize(){return t.e({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);e.abortController=new AbortController;try{const o=yield p.getImage(this.map._requestManager.transformRequest(i,"Tile"),e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(o&&o.data){this.map._refreshExpiredTiles&&(o.cacheControl||o.expires)&&e.setExpiryData({cacheControl:o.cacheControl,expires:o.expires});const i=this.map.painter.context,r=i.gl,a=o.data;e.texture=this.map.painter.getTileTexture(a.width),e.texture?e.texture.update(a,{useMipmap:!0}):(e.texture=new t.T(i,a,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),e.state="loaded";}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController);}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.texture&&this.map.painter.saveTileTexture(e.texture);}))}hasTransition(){return !1}}class W extends q{constructor(e,i,o,r){super(e,i,o,r),this.type="raster-dem",this.maxzoom=22,this._options=t.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),o=this.map._requestManager.transformRequest(i,"Tile");e.neighboringTiles=this._getNeighboringTiles(e.tileID),e.abortController=new AbortController;try{const i=yield p.getImage(o,e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){const o=i.data;this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const r=t.b(o)&&t.W()?o:yield this.readImageNow(o),a={type:this.type,uid:e.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!e.actor||"expired"===e.state){e.actor=this.dispatcher.getActor();const t=yield e.actor.sendAsync({type:"LDT",data:a});e.dem=t,e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0,e.state="loaded";}}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}readImageNow(e){return t._(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&t.X()){const i=e.width+2,o=e.height+2;try{return new t.R({width:i,height:o},yield t.Y(e,-1,-1,i,o))}catch(e){}}return s.getImageData(e,1)}))}_getNeighboringTiles(e){const i=e.canonical,o=Math.pow(2,i.z),r=(i.x-1+o)%o,a=0===i.x?e.wrap-1:e.wrap,s=(i.x+1+o)%o,n=i.x+1===o?e.wrap+1:e.wrap,l={};return l[new t.Z(e.overscaledZ,a,i.z,r,i.y).key]={backfilled:!1},l[new t.Z(e.overscaledZ,n,i.z,s,i.y).key]={backfilled:!1},i.y>0&&(l[new t.Z(e.overscaledZ,a,i.z,r,i.y-1).key]={backfilled:!1},l[new t.Z(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.Z(e.overscaledZ,n,i.z,s,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new t.Z(e.overscaledZ,a,i.z,r,i.y+1).key]={backfilled:!1},l[new t.Z(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.Z(e.overscaledZ,n,i.z,s,i.y+1).key]={backfilled:!1}),l}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded",e.actor&&(yield e.actor.sendAsync({type:"RDT",data:{type:this.type,uid:e.uid,source:this.id}}));}))}}class H extends t.E{constructor(e,i,o,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:i.data},this.actor=o.getActor(),this.setEventedParent(r),this._data=i.data,this._options=t.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId,void 0!==i.clusterMaxZoom&&this.maxzoom<=i.clusterMaxZoom&&t.w(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${i.clusterMaxZoom}".`),this.workerOptions=t.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==i.buffer?i.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==i.tolerance?i.tolerance:.375),extent:t.$,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(i.clusterMaxZoom),minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.$,radius:this._pixelsToTileUnits(i.clusterRadius||50),log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}_pixelsToTileUnits(e){return e*(t.$/this.tileSize)}_getClusterMaxZoom(e){const i=e?Math.round(e):this.maxzoom-1;return Number.isInteger(e)||void 0===e||t.w(`Integer expected for option 'clusterMaxZoom': provided value "${e}" rounded to "${i}"`),i}load(){return t._(this,void 0,void 0,(function*(){yield this._updateWorkerData();}))}onAdd(e){this.map=e,this.load();}setData(e){return this._data=e,this._pendingWorkerUpdate={data:e},this._updateWorkerData(),this}updateData(e){return this._pendingWorkerUpdate.diff=t.a0(this._pendingWorkerUpdate.diff,e),this._updateWorkerData(),this}getData(){return t._(this,void 0,void 0,(function*(){const e=t.e({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:e})}))}getCoordinatesFromGeometry(e){return "GeometryCollection"===e.type?e.geometries.map((e=>e.coordinates)).flat(1/0):e.coordinates.flat(1/0)}getBounds(){return t._(this,void 0,void 0,(function*(){const e=new G,t=yield this.getData();let i;switch(t.type){case "FeatureCollection":i=t.features.map((e=>this.getCoordinatesFromGeometry(e.geometry))).flat(1/0);break;case "Feature":i=this.getCoordinatesFromGeometry(t.geometry);break;default:i=this.getCoordinatesFromGeometry(t);}if(0==i.length)return e;for(let t=0;t<i.length-1;t+=2)e.extend([i[t],i[t+1]]);return e}))}setClusterOptions(e){return this.workerOptions.cluster=e.cluster,e&&(void 0!==e.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(e.clusterRadius)),void 0!==e.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(e.clusterMaxZoom))),this._updateWorkerData(),this}getClusterExpansionZoom(e){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:e,source:this.id}})}getClusterChildren(e){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:e,source:this.id}})}getClusterLeaves(e,t,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:e,limit:t,offset:i}})}_updateWorkerData(){return t._(this,void 0,void 0,(function*(){if(this._isUpdatingWorker)return;const{data:e,diff:i}=this._pendingWorkerUpdate;if(!e&&!i)return void t.w(`No data or diff provided to GeoJSONSource ${this.id}.`);const o=t.e({type:this.type},this.workerOptions);e?("string"==typeof e?(o.request=this.map._requestManager.transformRequest(s.resolveURL(e),"Source"),o.request.collectResourceTiming=this._collectResourceTiming):o.data=JSON.stringify(e),this._pendingWorkerUpdate.data=void 0):i&&(o.dataDiff=i,this._pendingWorkerUpdate.diff=void 0),this._isUpdatingWorker=!0,this.fire(new t.l("dataloading",{dataType:"source"}));try{const e=yield this.actor.sendAsync({type:"LD",data:o});if(this._isUpdatingWorker=!1,this._removed||e.abandoned)return void this.fire(new t.l("dataabort",{dataType:"source"}));this._data=e.data;let i=null;e.resourceTiming&&e.resourceTiming[this.id]&&(i=e.resourceTiming[this.id].slice(0));const r={dataType:"source"};this._collectResourceTiming&&i&&i.length>0&&t.e(r,{resourceTiming:i}),this.fire(new t.l("data",Object.assign(Object.assign({},r),{sourceDataType:"metadata"}))),this.fire(new t.l("data",Object.assign(Object.assign({},r),{sourceDataType:"content"})));}catch(e){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new t.l("dataabort",{dataType:"source"}));this.fire(new t.k(e));}finally{(this._pendingWorkerUpdate.data||this._pendingWorkerUpdate.diff)&&this._updateWorkerData();}}))}loaded(){return !this._isUpdatingWorker&&void 0===this._pendingWorkerUpdate.data&&void 0===this._pendingWorkerUpdate.diff}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.actor?"RT":"LT";e.actor=this.actor;const i={type:this.type,uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,globalState:this.map.getGlobalState()};e.abortController=new AbortController;const o=yield this.actor.sendAsync({type:t,data:i},e.abortController);delete e.abortController,e.unloadVectorData(),e.aborted||e.loadVectorData(o,this.map.painter,"RT"===t);}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.aborted=!0;}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}});}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}});}serialize(){return t.e({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}}class X extends t.E{constructor(e,t,i,o){super(),this.flippedWindingOrder=!1,this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(o),this.options=t;}load(e){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const t=yield p.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,t&&t.data&&(this.image=t.data,e&&(this.coordinates=e),this._finishLoading());}catch(e){this._request=null,this._loaded=!0,this.fire(new t.k(e));}}))}loaded(){return this._loaded}updateImage(e){return e.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=e.url,this.load(e.coordinates).finally((()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(e){this.coordinates=e;const i=e.map(t.a1.fromLngLat);var o;return this.tileID=function(e){const i=t.a2.fromPoints(e),o=i.width(),r=i.height(),a=Math.max(o,r),s=Math.max(0,Math.floor(-Math.log(a)/Math.LN2)),n=Math.pow(2,s);return new t.a4(s,Math.floor((i.minX+i.maxX)/2*n),Math.floor((i.minY+i.maxY)/2*n))}(i),this.terrainTileRanges=this._getOverlappingTileRanges(i),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=i.map((e=>this.tileID.getTilePoint(e)._round())),this.flippedWindingOrder=((o=this.tileCoords)[1].x-o[0].x)*(o[2].y-o[0].y)-(o[1].y-o[0].y)*(o[2].x-o[0].x)<0,this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.texture||(this.texture=new t.T(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let o=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,o=!0);}o&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(e){return t._(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={}):e.state="errored";}))}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}_getOverlappingTileRanges(e){const{minX:i,minY:o,maxX:r,maxY:a}=t.a2.fromPoints(e),s={};for(let e=0;e<=t.a3;e++){const t=Math.pow(2,e),n=Math.floor(i*t),l=Math.floor(o*t),c=Math.floor(r*t),h=Math.floor(a*t);s[e]={minTileX:n,minTileY:l,maxTileX:c,maxTileY:h};}return s}}class K extends X{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1;const e=this.options;this.urls=[];for(const t of e.urls)this.urls.push(this.map._requestManager.transformRequest(t,"Source").url);try{const e=yield t.a5(this.urls);if(this._loaded=!0,!e)return;this.video=e,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading();}catch(e){this.fire(new t.k(e));}}))}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.k(new t.a6(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new t.T(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let o=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,o=!0);}o&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class Y extends X{constructor(e,i,o,r){super(e,i,o,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new t.k(new t.a6(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.k(new t.a6(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.k(new t.a6(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new t.k(new t.a6(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.k(new t.a6(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.k(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}))}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,o=i.gl;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new t.T(i,this.canvas,o.RGBA,{premultiply:!0});let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0);}r&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}}const Q={},J=e=>{switch(e){case "geojson":return H;case "image":return X;case "raster":return q;case "raster-dem":return W;case "vector":return $;case "video":return K;case "canvas":return Y}return Q[e]},ee="RTLPluginLoaded";class te extends t.E{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=B();}_syncState(e){return this.status=e,this.dispatcher.broadcast("SRPS",{pluginStatus:e,pluginURL:this.url}).catch((e=>{throw this.status="error",e}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null;}setRTLTextPlugin(e){return t._(this,arguments,void 0,(function*(e,t=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=s.resolveURL(e),!this.url)throw new Error(`requested url ${e} is invalid`);if("unavailable"===this.status){if(!t)return this._requestImport();this.status="deferred",this._syncState(this.status);}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return t._(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new t.l(ee));}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport();}}let ie=null;function oe(){return ie||(ie=new te),ie}class re{constructor(e,i){this.timeAdded=0,this.fadeEndTime=0,this.tileID=e,this.uid=t.a7(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(e){const t=e+this.timeAdded;t<this.fadeEndTime||(this.fadeEndTime=t);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(e){this.demTexture&&e.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(e,i,o){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const o of e){const e=o.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){o.layers=e,o.stateDependentLayerIds&&(o.stateDependentLayers=o.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.id]=o;}}return i}(e.buckets,null==i?void 0:i.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.a9){if(this.hasSymbolBuckets=!0,!o)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.a9&&i.hasRTLText){this.hasRTLText=!0,oe().lazyLoad();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(e).queryRadius(t));}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage);}else this.collisionBoxArray=new t.a8;}unloadVectorData(){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(e){return this.buckets[e.id]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e);}const i=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new t.T(e,this.imageAtlas.image,i.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new t.T(e,this.glyphAtlasImage,i.ALPHA),this.glyphAtlasImage=null);}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture);}queryRenderedFeatures(e,t,i,o,r,a,s,n,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:o,cameraQueryGeometry:r,scale:a,tileSize:this.tileSize,pixelPosMatrix:c,transform:n,params:s,queryPadding:this.queryPadding*l,getElevation:h},e,t,i):{}}querySourceFeatures(e,i){const o=this.latestFeatureIndex;if(!o||!o.rawTileData)return;const r=o.loadVTLayers(),a=i&&i.sourceLayer?i.sourceLayer:"",s=r._geojsonTileLayer||r[a];if(!s)return;const n=t.aa(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<s.length;i++){const r=s.feature(i);if(n.needGeometry){const e=t.ab(r,!0);if(!n.filter(new t.F(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!n.filter(new t.F(this.tileID.overscaledZ),r))continue;const d=o.getId(r,a),_=new t.ac(r,l,c,h,d);_.tile=u,e.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const i=this.expirationTime;if(e.cacheControl){const i=t.ad(e.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const o=this.expirationTime-i;o?this.expirationTime=e+Math.max(o,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,t){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const o in this.buckets){if(!t.style.hasLayer(o))continue;const r=this.buckets[o],a=r.layers[0].sourceLayer||"_geojsonTileLayer",s=i[a],n=e[a];if(!s||!n||0===Object.keys(n).length)continue;r.update(n,s,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=t&&t.style&&t.style.getLayer(o);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(r)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<s.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(e){this.symbolFadeHoldUntil=s.now()+e;}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}}class ae{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const o=e.wrapped().key;void 0===this.data[o]&&(this.data[o]=[]);const r={value:t,timeout:void 0};if(void 0!==i&&(r.timeout=setTimeout((()=>{this.remove(e,r);}),i)),this.data[o].push(r),this.order.push(o),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,o=void 0===t?0:this.data[i].indexOf(t),r=this.data[i][o];return this.data[i].splice(o,1),r.timeout&&clearTimeout(r.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(r.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const o of this.data[i])e(o.value)||t.push(o);for(const e of t)this.remove(e.value.tileID,e);}}class se{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(e,i,o){const r=String(i);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},t.e(this.stateChanges[e][r],o),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null);}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])o[t]||(this.deletedStates[e][r][t]=null);}else for(const t in o)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const o=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][o]&&(this.deletedStates[e][o]=this.deletedStates[e][o]||{},this.deletedStates[e][o][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][o])for(i in this.deletedStates[e][o]={},this.stateChanges[e][o])this.deletedStates[e][o][i]=null;else this.deletedStates[e][o]=null;else this.deletedStates[e]=null;}getState(e,i){const o=String(i),r=t.e({},(this.state[e]||{})[o],(this.stateChanges[e]||{})[o]);if(null===this.deletedStates[e])return {};if(this.deletedStates[e]){const t=this.deletedStates[e][i];if(null===t)return {};for(const e in t)delete r[e];}return r}initializeTileState(e,t){e.setFeatureState(this.state,t);}coalesceChanges(e,i){const o={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const i={};for(const o in this.stateChanges[e])this.state[e][o]||(this.state[e][o]={}),t.e(this.state[e][o],this.stateChanges[e][o]),i[o]=this.state[e][o];o[e]=i;}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const i={};if(null===this.deletedStates[e])for(const t in this.state[e])i[t]={},this.state[e][t]={};else for(const t in this.deletedStates[e]){if(null===this.deletedStates[e][t])this.state[e][t]={};else for(const i of Object.keys(this.deletedStates[e][t]))delete this.state[e][t][i];i[t]=this.state[e][t];}o[e]=o[e]||{},t.e(o[e],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(o).length)for(const t in e)e[t].setFeatureState(o,i);}}const ne=89.25;function le(e,i){const o=t.ah(i.lat,-t.ai,t.ai);return new t.P(t.V(i.lng)*e,t.U(o)*e)}function ce(e,i){return new t.a1(i.x/e,i.y/e).toLngLat()}function he(e){return e.cameraToCenterDistance*Math.min(.85*Math.tan(t.ae(90-e.pitch)),Math.tan(t.ae(ne-e.pitch)))}function ue(e,i){const o=e.canonical,r=i/t.af(o.z),a=o.x+Math.pow(2,o.z)*e.wrap,s=t.ag(new Float64Array(16));return t.M(s,s,[a*r,o.y*r,0]),t.N(s,s,[r/t.$,r/t.$,1]),s}function de(e,i,o,r,a){const s=t.a1.fromLngLat(e,i),n=a*t.aj(1,e.lat),l=n*Math.cos(t.ae(o)),c=Math.sqrt(n*n-l*l),h=c*Math.sin(t.ae(-r)),u=c*Math.cos(t.ae(-r));return new t.a1(s.x+h,s.y+u,s.z+l)}function _e(e,t,i){const o=t.intersectsFrustum(e);if(!i||0===o)return o;const r=t.intersectsPlane(i);return 0===r?0:2===o&&2===r?2:1}function pe(e,t,i){let o=0;const r=(i-t)/10;for(let a=0;a<10;a++)o+=r*Math.pow(Math.cos(t+(a+.5)/10*(i-t)),e);return o}function me(e,i){return function(o,r,a,s,n){const l=2*((e-1)/t.ak(Math.cos(t.ae(ne-n))/Math.cos(t.ae(ne)))-1),c=Math.acos(a/s),h=2*pe(l-1,0,t.ae(n/2)),u=Math.min(t.ae(ne),c+t.ae(n/2)),d=pe(l-1,Math.min(u,c-t.ae(n/2)),u),_=Math.atan(r/a),p=Math.hypot(r,a);let m=o;return m+=t.ak(s/p/Math.max(.5,Math.cos(t.ae(n/2)))),m+=l*t.ak(Math.cos(_))/2,m-=t.ak(Math.max(1,d/h/i))/2,m}}const fe=me(9.314,3);function ge(e,i){const o=(i.roundZoom?Math.round:Math.floor)(e.zoom+t.ak(e.tileSize/i.tileSize));return Math.max(0,o)}function ve(e,i){const o=e.getCameraFrustum(),r=e.getClippingPlane(),a=e.screenPointToMercatorCoordinate(e.getCameraPoint()),s=t.a1.fromLngLat(e.center,e.elevation);a.z=s.z+Math.cos(e.pitchInRadians)*e.cameraToCenterDistance/e.worldSize;const n=e.getCoveringTilesDetailsProvider(),l=n.allowVariableZoom(e,i),c=ge(e,i),h=i.minzoom||0,u=void 0!==i.maxzoom?i.maxzoom:e.maxZoom,d=Math.min(Math.max(0,c),u),_=Math.pow(2,d),p=[_*a.x,_*a.y,0],m=[_*s.x,_*s.y,0],f=Math.hypot(s.x-a.x,s.y-a.y),g=Math.abs(s.z-a.z),v=Math.hypot(f,g),b=e=>({zoom:0,x:0,y:0,wrap:e,fullyVisible:!1}),x=[],y=[];if(e.renderWorldCopies&&n.allowWorldCopies())for(let e=1;e<=3;e++)x.push(b(-e)),x.push(b(e));for(x.push(b(0));x.length>0;){const _=x.pop(),f=_.x,b=_.y;let w=_.fullyVisible;const T={x:f,y:b,z:_.zoom},P=n.getTileBoundingVolume(T,_.wrap,e.elevation,i);if(!w){const e=_e(o,P,r);if(0===e)continue;w=2===e;}const C=n.distanceToTile2d(a.x,a.y,T,P);let I=c;l&&(I=(i.calculateTileZoom||fe)(e.zoom+t.ak(e.tileSize/i.tileSize),C,g,v,e.fov)),I=(i.roundZoom?Math.round:Math.floor)(I),I=Math.max(0,I);const M=Math.min(I,u);if(_.wrap=n.getWrap(s,T,_.wrap),_.zoom>=M){if(_.zoom<h)continue;const e=d-_.zoom,o=p[0]-.5-(f<<e),r=p[1]-.5-(b<<e),a=i.reparseOverscaled?Math.max(_.zoom,I):_.zoom;y.push({tileID:new t.Z(_.zoom===u?a:_.zoom,_.wrap,_.zoom,f,b),distanceSq:t.al([m[0]-.5-f,m[1]-.5-b]),tileDistanceToCamera:Math.sqrt(o*o+r*r)});}else for(let e=0;e<4;e++)x.push({zoom:_.zoom+1,x:(f<<1)+e%2,y:(b<<1)+(e>>1),wrap:_.wrap,fullyVisible:w});}return y.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}const be=t.a2.fromPoints([new t.P(0,0),new t.P(t.$,t.$)]);class xe extends t.E{constructor(e,t,i){super(),this.id=e,this.dispatcher=i,this.on("data",(e=>this._dataHandler(e))),this.on("dataloading",(()=>{this._sourceErrored=!1;})),this.on("error",(()=>{this._sourceErrored=this._source.loaded();})),this._source=((e,t,i,o)=>{const r=new(J(t.type))(e,t,i,o);if(r.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${r.id}`);return r})(e,t,i,this),this._tiles={},this._cache=new ae(0,(e=>this._unloadTile(e))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new se,this._didEmitContent=!1,this._updated=!1;}onAdd(e){this.map=e,this._maxTileCacheSize=e?e._maxTileCacheSize:null,this._maxTileCacheZoomLevels=e?e._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(e);}onRemove(e){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(e);}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return !0;if(!this._updated)return !1;for(const e in this._tiles){const t=this._tiles[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform,this.terrain);}_loadTile(e,i,o){return t._(this,void 0,void 0,(function*(){try{yield this._source.loadTile(e),this._tileLoaded(e,i,o);}catch(i){e.state="errored",404!==i.status?this._source.fire(new t.k(i,{tile:e})):this.update(this.transform,this.terrain);}}))}_unloadTile(e){this._source.unloadTile&&this._source.unloadTile(e);}_abortTile(e){this._source.abortTile&&this._source.abortTile(e),this._source.fire(new t.l("dataabort",{tile:e,coord:e.tileID,dataType:"source"}));}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager);}}getIds(){return Object.values(this._tiles).map((e=>e.tileID)).sort(ye).map((e=>e.key))}getRenderableIds(e){const i=[];for(const t in this._tiles)this._isIdRenderable(t,e)&&i.push(this._tiles[t]);return e?i.sort(((e,i)=>{const o=e.tileID,r=i.tileID,a=new t.P(o.canonical.x,o.canonical.y)._rotate(-this.transform.bearingInRadians),s=new t.P(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians);return o.overscaledZ-r.overscaledZ||s.y-a.y||s.x-a.x})).map((e=>e.tileID.key)):i.map((e=>e.tileID)).sort(ye).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())}reload(e){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)e?this._reloadTile(t,"expired"):"errored"!==this._tiles[t].state&&this._reloadTile(t,"reloading");}}_reloadTile(e,i){return t._(this,void 0,void 0,(function*(){const t=this._tiles[e];t&&("loading"!==t.state&&(t.state=i),yield this._loadTile(t,e,i));}))}_tileLoaded(e,i,o){e.timeAdded=s.now(),"expired"===o&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(i,e),"raster-dem"===this.getSource().type&&e.dem&&this._backfillDEM(e),this._state.initializeTileState(e,this.map?this.map.painter:null),e.aborted||this._source.fire(new t.l("data",{dataType:"source",tile:e,coord:e.tileID}));}_backfillDEM(e){const t=this.getRenderableIds();for(let o=0;o<t.length;o++){const r=t[o];if(e.neighboringTiles&&e.neighboringTiles[r]){const t=this.getTileByID(r);i(e,t),i(t,e);}}function i(e,t){e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const o=t.tileID.canonical.y-e.tileID.canonical.y,r=Math.pow(2,e.tileID.canonical.z),a=t.tileID.key;0===i&&0===o||Math.abs(o)>1||(Math.abs(i)>1&&(1===Math.abs(i+r)?i+=r:1===Math.abs(i-r)&&(i-=r)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,o),e.neighboringTiles&&e.neighboringTiles[a]&&(e.neighboringTiles[a].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,o){for(const r in this._tiles){let a=this._tiles[r];if(o[r]||!a.hasData()||a.tileID.overscaledZ<=t||a.tileID.overscaledZ>i)continue;let s=a.tileID;for(;a&&a.tileID.overscaledZ>t+1;){const e=a.tileID.scaledTo(a.tileID.overscaledZ-1);a=this._tiles[e.key],a&&a.hasData()&&(s=e);}let n=s;for(;n.overscaledZ>t;)if(n=n.scaledTo(n.overscaledZ-1),e[n.key]||e[n.canonical.key]){o[s.key]=s;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),o=this._getLoadedTile(t);if(o)return o}}findLoadedSibling(e){return this._getLoadedTile(e)}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(e.wrapped().key)}updateCacheSize(e){const i=Math.ceil(e.width/this._source.tileSize)+1,o=Math.ceil(e.height/this._source.tileSize)+1,r=Math.floor(i*o*(null===this._maxTileCacheZoomLevels?t.a.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),a="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(a);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const o=this._tiles[i];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),e[o.tileID.key]=o;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(e,this._tiles[e]);}}_updateCoveredAndRetainedTiles(e,t,i,o,r,a){const n={},l={},c=Object.keys(e),h=s.now();for(const i of c){const o=e[i],r=this._tiles[i];if(!r||0!==r.fadeEndTime&&r.fadeEndTime<=h)continue;const a=this.findLoadedParent(o,t),s=this.findLoadedSibling(o),c=a||s||null;c&&(this._addTile(c.tileID),n[c.tileID.key]=c.tileID),l[i]=o;}this._retainLoadedChildren(l,o,i,e);for(const t in n)e[t]||(this._coveredTiles[t]=!0,e[t]=n[t]);if(a){const t={},i={};for(const e of r)this._tiles[e.key].hasData()?t[e.key]=e:i[e.key]=e;for(const o in i){const r=i[o].children(this._source.maxzoom);this._tiles[r[0].key]&&this._tiles[r[1].key]&&this._tiles[r[2].key]&&this._tiles[r[3].key]&&(t[r[0].key]=e[r[0].key]=r[0],t[r[1].key]=e[r[1].key]=r[1],t[r[2].key]=e[r[2].key]=r[2],t[r[3].key]=e[r[3].key]=r[3],delete i[o]);}for(const o in i){const r=i[o],a=this.findLoadedParent(r,this._source.minzoom),s=this.findLoadedSibling(r),n=a||s||null;if(n){t[n.tileID.key]=e[n.tileID.key]=n.tileID;for(const e in t)t[e].isChildOf(n.tileID)&&delete t[e];}}for(const e in this._tiles)t[e]||(this._coveredTiles[e]=!0);}}update(e,i){if(!this._sourceLoaded||this._paused)return;let o;this.transform=e,this.terrain=i,this.updateCacheSize(e),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?o=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new t.Z(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(o=ve(e,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:i,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(o=o.filter((e=>this._source.hasTile(e))))):o=[];const r=ge(e,this._source),a=Math.max(r-xe.maxOverzooming,this._source.minzoom),s=Math.max(r+xe.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const e={};for(const t of o)if(t.canonical.z>this._source.minzoom){const i=t.scaledTo(t.canonical.z-1);e[i.key]=i;const o=t.scaledTo(Math.max(this._source.minzoom,Math.min(t.canonical.z,5)));e[o.key]=o;}o=o.concat(Object.values(e));}const n=0===o.length&&!this._updated&&this._didEmitContent;this._updated=!0,n&&this.fire(new t.l("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const l=this._updateRetainedTiles(o,r);we(this._source.type)&&this._updateCoveredAndRetainedTiles(l,a,s,r,o,i);for(const e in l)this._tiles[e].clearFadeHold();const c=t.am(this._tiles,l);for(const e of c){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(e);}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(e);}_updateRetainedTiles(e,t){var i;const o={},r={},a=Math.max(t-xe.maxOverzooming,this._source.minzoom),s=Math.max(t+xe.maxUnderzooming,this._source.minzoom),n={};for(const i of e){const e=this._addTile(i);o[i.key]=i,e.hasData()||t<this._source.maxzoom&&(n[i.key]=i);}this._retainLoadedChildren(n,t,s,o);for(const s of e){let e=this._tiles[s.key];if(e.hasData())continue;if(t+1>this._source.maxzoom){const e=s.children(this._source.maxzoom)[0],t=this.getTile(e);if(t&&t.hasData()){o[e.key]=e;continue}}else {const e=s.children(this._source.maxzoom);if(o[e[0].key]&&o[e[1].key]&&o[e[2].key]&&o[e[3].key])continue}let n=e.wasRequested();for(let t=s.overscaledZ-1;t>=a;--t){const a=s.scaledTo(t);if(r[a.key])break;if(r[a.key]=!0,e=this.getTile(a),!e&&n&&(e=this._addTile(a)),e){const t=e.hasData();if((t||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||n)&&(o[a.key]=a),n=e.wasRequested(),t)break}}}return o}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,o=this._tiles[e].tileID;for(;o.overscaledZ>0;){if(o.key in this._loadedParentTiles){i=this._loadedParentTiles[o.key];break}t.push(o.key);const e=o.scaledTo(o.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;o=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const e in this._tiles){const t=this._tiles[e].tileID,i=this._getLoadedTile(t);this._loadedSiblingTiles[t.key]=i;}}_addTile(e){let i=this._tiles[e.key];if(i)return i;i=this._cache.getAndRemove(e),i&&(this._setTileReloadTimer(e.key,i),i.tileID=e,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[e.key]&&(clearTimeout(this._cacheTimers[e.key]),delete this._cacheTimers[e.key],this._setTileReloadTimer(e.key,i)));const o=i;return i||(i=new re(e,this._source.tileSize*e.overscaleFactor()),this._loadTile(i,e.key,i.state)),i.uses++,this._tiles[e.key]=i,o||this._source.fire(new t.l("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}refreshTiles(e){for(const t in this._tiles)(this._isIdRenderable(t)||"errored"==this._tiles[t].state)&&e.some((e=>e.equals(this._tiles[t].tileID.canonical)))&&this._reloadTile(t,"expired");}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}_dataHandler(e){const t=e.sourceDataType;"source"===e.dataType&&"metadata"===t&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===t&&(this.reload(e.sourceDataChanged),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0);}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(e);this._cache.reset();}tilesIn(e,i,o){const r=[],a=this.transform;if(!a)return r;const s=a.getCoveringTilesDetailsProvider().allowWorldCopies(),n=o?a.getCameraQueryGeometry(e):e,l=e=>a.screenPointToMercatorCoordinate(e,this.terrain),c=this.transformBbox(e,l,!s),h=this.transformBbox(n,l,!s),u=this.getIds(),d=t.a2.fromPoints(h);for(let e=0;e<u.length;e++){const o=this._tiles[u[e]];if(o.holdingForFade())continue;const n=s?[o.tileID]:[o.tileID.unwrapTo(-1),o.tileID.unwrapTo(0)],l=Math.pow(2,a.zoom-o.tileID.overscaledZ),_=i*o.queryPadding*t.$/o.tileSize/l;for(const e of n){const i=d.map((i=>e.getTilePoint(new t.a1(i.x,i.y))));if(i.expandBy(_),i.intersects(be)){const t=c.map((t=>e.getTilePoint(t))),i=h.map((t=>e.getTilePoint(t)));r.push({tile:o,tileID:s?e:e.unwrapTo(0),queryGeometry:t,cameraQueryGeometry:i,scale:l});}}}return r}transformBbox(e,i,o){let r=e.map(i);if(o){const o=t.a2.fromPoints(e);o.shrinkBy(.001*Math.min(o.width(),o.height()));const a=o.map(i);t.a2.fromPoints(r).covers(a)||(r=r.map((e=>e.x>.5?new t.a1(e.x-1,e.y,e.z):e)));}return r}getVisibleCoordinates(e){const t=this.getRenderableIds(e).map((e=>this._tiles[e].tileID));return this.transform&&this.transform.populateCache(t),t}hasTransition(){if(this._source.hasTransition())return !0;if(we(this._source.type)){const e=s.now();for(const t in this._tiles)if(this._tiles[t].fadeEndTime>=e)return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const o=this._tiles[e];o&&o.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}}function ye(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),o=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||o-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function we(e){return "raster"===e||"image"===e||"video"===e}xe.maxOverzooming=10,xe.maxUnderzooming=3;class Te{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(e){if(1===this.points.length)return this.points[0];e=t.ah(e,0,1);let i=1,o=this._distances[i];const r=e*this.paddedLength+this.padding;for(;o<r&&i<this._distances.length;)o=this._distances[++i];const a=i-1,s=this._distances[a],n=o-s,l=n>0?(r-s)/n:0;return this.points[a].mult(1-l).add(this.points[i].mult(l))}}function Pe(e,t){let i=!0;return "always"===e||"never"!==e&&"never"!==t||(i=!1),i}class Ce{constructor(e,t,i){const o=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,r){this._forEachCell(t,i,o,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(r);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,r,a){this.boxCells[r].push(a);}_insertCircleCell(e,t,i,o,r,a){this.circleCells[r].push(a);}_query(e,t,i,o,r,a,s){if(i<0||e>this.width||o<0||t>this.height)return [];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(r)return [{key:null,x1:e,y1:t,x2:i,y2:o}];for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}}else this._forEachCell(e,t,i,o,this._queryCell,n,{hitTest:r,overlapMode:a,seenUids:{box:{},circle:{}}},s);return n}query(e,t,i,o){return this._query(e,t,i,o,!1,null)}hitTest(e,t,i,o,r,a){return this._query(e,t,i,o,!0,r,a).length>0}hitTestCircle(e,t,i,o,r){const a=e-i,s=e+i,n=t-i,l=t+i;if(s<0||a>this.width||l<0||n>this.height)return !1;const c=[];return this._forEachCell(a,n,s,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},r),c.length>0}_queryCell(e,t,i,o,r,a,s,n){const{seenUids:l,hitTest:c,overlapMode:h}=s,u=this.boxCells[r];if(null!==u){const r=this.bboxes;for(const s of u)if(!l.box[s]){l.box[s]=!0;const u=4*s,d=this.boxKeys[s];if(e<=r[u+2]&&t<=r[u+3]&&i>=r[u+0]&&o>=r[u+1]&&(!n||n(d))&&(!c||!Pe(h,d.overlapMode))&&(a.push({key:d,x1:r[u],y1:r[u+1],x2:r[u+2],y2:r[u+3]}),c))return !0}}const d=this.circleCells[r];if(null!==d){const r=this.circles;for(const s of d)if(!l.circle[s]){l.circle[s]=!0;const u=3*s,d=this.circleKeys[s];if(this._circleAndRectCollide(r[u],r[u+1],r[u+2],e,t,i,o)&&(!n||n(d))&&(!c||!Pe(h,d.overlapMode))){const e=r[u],t=r[u+1],i=r[u+2];if(a.push({key:d,x1:e-i,y1:t-i,x2:e+i,y2:t+i}),c)return !0}}}return !1}_queryCellCircle(e,t,i,o,r,a,s,n){const{circle:l,seenUids:c,overlapMode:h}=s,u=this.boxCells[r];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t,o=this.boxKeys[t];if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!n||n(o))&&!Pe(h,o.overlapMode))return a.push(!0),!0}}const d=this.circleCells[r];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t,o=this.circleKeys[t];if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!n||n(o))&&!Pe(h,o.overlapMode))return a.push(!0),!0}}}_forEachCell(e,t,i,o,r,a,s,n){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(r.call(this,e,t,i,o,this.xCellCount*l+d,a,s,n))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,r,a){const s=o-e,n=r-t,l=i+a;return l*l>s*s+n*n}_circleAndRectCollide(e,t,i,o,r,a,s){const n=(a-o)/2,l=Math.abs(e-(o+n));if(l>n+i)return !1;const c=(s-r)/2,h=Math.abs(t-(r+c));if(h>c+i)return !1;if(l<=n||h<=c)return !0;const u=l-n,d=h-c;return u*u+d*d<=i*i}}function Ie(e,i,r){const a=t.L();if(!e){const{vecSouth:e,vecEast:t}=Se(i),r=o();r[0]=t[0],r[1]=t[1],r[2]=e[0],r[3]=e[1],s=r,(d=(l=(n=r)[0])*(u=n[3])-(h=n[2])*(c=n[1]))&&(s[0]=u*(d=1/d),s[1]=-c*d,s[2]=-h*d,s[3]=l*d),a[0]=r[0],a[1]=r[1],a[4]=r[2],a[5]=r[3];}var s,n,l,c,h,u,d;return t.N(a,a,[1/r,1/r,1]),a}function Me(e,i,o,r){if(e){const e=t.L();if(!i){const{vecSouth:t,vecEast:i}=Se(o);e[0]=i[0],e[1]=i[1],e[4]=t[0],e[5]=t[1];}return t.N(e,e,[r,r,1]),e}return o.pixelsToClipSpaceMatrix}function Se(e){const i=Math.cos(e.rollInRadians),o=Math.sin(e.rollInRadians),r=Math.cos(e.pitchInRadians),a=Math.cos(e.bearingInRadians),s=Math.sin(e.bearingInRadians),n=t.ar();n[0]=-a*r*o-s*i,n[1]=-s*r*o+a*i;const l=t.as(n);l<1e-9?t.at(n):t.au(n,n,1/l);const c=t.ar();c[0]=a*r*i-s*o,c[1]=s*r*i+a*o;const h=t.as(c);return h<1e-9?t.at(c):t.au(c,c,1/h),{vecEast:c,vecSouth:n}}function Ee(e,i,o,r){let a;r?(a=[e,i,r(e,i),1],t.aw(a,a,o)):(a=[e,i,0,1],qe(a,a,o));const s=a[3];return {point:new t.P(a[0]/s,a[1]/s),signedDistanceFromCamera:s,isOccluded:!1}}function Re(e,t){return .5+e/t*.5}function ze(e,t){return e.x>=-t[0]&&e.x<=t[0]&&e.y>=-t[1]&&e.y<=t[1]}function De(e,i,o,r,a,s,n,l,c,h,u,d,_){const p=o?e.textSizeData:e.iconSizeData,m=t.an(p,i.transform.zoom),f=[256/i.width*2+1,256/i.height*2+1],g=o?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;g.clear();const v=e.lineVertexArray,b=o?e.text.placedSymbolArray:e.icon.placedSymbolArray,x=i.transform.width/i.transform.height;let y=!1;for(let o=0;o<b.length;o++){const w=b.get(o);if(w.hidden||w.writingMode===t.ao.vertical&&!y){$e(w.numGlyphs,g);continue}y=!1;const T=new t.P(w.anchorX,w.anchorY),P={getElevation:_,pitchedLabelPlaneMatrix:r,lineVertexArray:v,pitchWithMap:s,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:i.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:d},C=Ne(w.anchorX,w.anchorY,P);if(!ze(C.point,f)){$e(w.numGlyphs,g);continue}const I=Re(i.transform.cameraToCenterDistance,C.signedDistanceFromCamera),M=t.ap(p,m,w),S=s?M*i.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/I:M*I,E=ke({projectionContext:P,pitchedLabelPlaneMatrixInverse:a,symbol:w,fontSize:S,flip:!1,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:x,rotateToLine:l});y=E.useVertical,(E.notEnoughRoom||y||E.needsFlipping&&ke({projectionContext:P,pitchedLabelPlaneMatrixInverse:a,symbol:w,fontSize:S,flip:!0,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:x,rotateToLine:l}).notEnoughRoom)&&$e(w.numGlyphs,g);}o?e.text.dynamicLayoutVertexBuffer.updateData(g):e.icon.dynamicLayoutVertexBuffer.updateData(g);}function Ae(e,t,i,o,r,a,s,n){const l=a.glyphStartIndex+a.numGlyphs,c=a.lineStartIndex,h=a.lineStartIndex+a.lineLength,u=t.getoffsetX(a.glyphStartIndex),d=t.getoffsetX(l-1),_=Ge(e*u,i,o,r,a.segment,c,h,n,s);if(!_)return null;const p=Ge(e*d,i,o,r,a.segment,c,h,n,s);return p?n.projectionCache.anyProjectionOccluded?null:{first:_,last:p}:null}function Le(e,i,o,r){return e===t.ao.horizontal&&Math.abs(o.y-i.y)>Math.abs(o.x-i.x)*r?{useVertical:!0}:(e===t.ao.vertical?i.y<o.y:i.x>o.x)?{needsFlipping:!0}:null}function ke(e){const{projectionContext:i,pitchedLabelPlaneMatrixInverse:o,symbol:r,fontSize:a,flip:s,keepUpright:n,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=e,d=a/24,_=r.lineOffsetX*d,p=r.lineOffsetY*d;let m;if(r.numGlyphs>1){const e=r.glyphStartIndex+r.numGlyphs,t=r.lineStartIndex,a=r.lineStartIndex+r.lineLength,c=Ae(d,l,_,p,s,r,u,i);if(!c)return {notEnoughRoom:!0};const f=je(c.first.point.x,c.first.point.y,i,o),g=je(c.last.point.x,c.last.point.y,i,o);if(n&&!s){const e=Le(r.writingMode,f,g,h);if(e)return e}m=[c.first];for(let o=r.glyphStartIndex+1;o<e-1;o++){const e=Ge(d*l.getoffsetX(o),_,p,s,r.segment,t,a,i,u);if(!e)return {notEnoughRoom:!0};m.push(e);}m.push(c.last);}else {if(n&&!s){const e=Oe(i.tileAnchorPoint.x,i.tileAnchorPoint.y,i).point,a=r.lineStartIndex+r.segment+1,s=new t.P(i.lineVertexArray.getx(a),i.lineVertexArray.gety(a)),n=Oe(s.x,s.y,i),l=n.signedDistanceFromCamera>0?n.point:Fe(i.tileAnchorPoint,s,e,1,i),c=je(e.x,e.y,i,o),u=je(l.x,l.y,i,o),d=Le(r.writingMode,c,u,h);if(d)return d}const e=Ge(d*l.getoffsetX(r.glyphStartIndex),_,p,s,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,i,u);if(!e||i.projectionCache.anyProjectionOccluded)return {notEnoughRoom:!0};m=[e];}for(const e of m)t.av(c,e.point,e.angle);return {}}function Fe(e,t,i,o,r){const a=e.add(e.sub(t)._unit()),s=Oe(a.x,a.y,r).point,n=i.sub(s);return i.add(n._mult(o/n.mag()))}function Be(e,i,o){const r=i.projectionCache;if(r.projections[e])return r.projections[e];const a=new t.P(i.lineVertexArray.getx(e),i.lineVertexArray.gety(e)),s=Oe(a.x,a.y,i);if(s.signedDistanceFromCamera>0)return r.projections[e]=s.point,r.anyProjectionOccluded=r.anyProjectionOccluded||s.isOccluded,s.point;const n=e-o.direction;return Fe(0===o.distanceFromAnchor?i.tileAnchorPoint:new t.P(i.lineVertexArray.getx(n),i.lineVertexArray.gety(n)),a,o.previousVertex,o.absOffsetX-o.distanceFromAnchor+1,i)}function Oe(e,t,i){const o=e+i.translation[0],r=t+i.translation[1];let a;return i.pitchWithMap?(a=Ee(o,r,i.pitchedLabelPlaneMatrix,i.getElevation),a.isOccluded=!1):(a=i.transform.projectTileCoordinates(o,r,i.unwrappedTileID,i.getElevation),a.point.x=(.5*a.point.x+.5)*i.width,a.point.y=(.5*-a.point.y+.5)*i.height),a}function je(e,i,o,r){if(o.pitchWithMap){const a=[e,i,0,1];return t.aw(a,a,r),o.transform.projectTileCoordinates(a[0]/a[3],a[1]/a[3],o.unwrappedTileID,o.getElevation).point}return {x:e/o.width*2-1,y:1-i/o.height*2}}function Ne(e,t,i){return i.transform.projectTileCoordinates(e,t,i.unwrappedTileID,i.getElevation)}function Ue(e,t,i){return e._unit()._perp()._mult(t*i)}function Ze(e,i,o,r,a,s,n,l,c){if(l.projectionCache.offsets[e])return l.projectionCache.offsets[e];const h=o.add(i);if(e+c.direction<r||e+c.direction>=a)return l.projectionCache.offsets[e]=h,h;const u=Be(e+c.direction,l,c),d=Ue(u.sub(o),n,c.direction),_=o.add(d),p=u.add(d);return l.projectionCache.offsets[e]=t.ax(s,h,_,p)||h,l.projectionCache.offsets[e]}function Ge(e,t,i,o,r,a,s,n,l){const c=o?e-t:e+t;let h=c>0?1:-1,u=0;o&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let d,_=h>0?a+r:a+r+1;n.projectionCache.cachedAnchorPoint?d=n.projectionCache.cachedAnchorPoint:(d=Oe(n.tileAnchorPoint.x,n.tileAnchorPoint.y,n).point,n.projectionCache.cachedAnchorPoint=d);let p,m,f=d,g=d,v=0,b=0;const x=Math.abs(c),y=[];let w;for(;v+b<=x;){if(_+=h,_<a||_>=s)return null;v+=b,g=f,m=p;const e={absOffsetX:x,direction:h,distanceFromAnchor:v,previousVertex:g};if(f=Be(_,n,e),0===i)y.push(g),w=f.sub(g);else {let t;const o=f.sub(g);t=0===o.mag()?Ue(Be(_+h,n,e).sub(f),i,h):Ue(o,i,h),m||(m=g.add(t)),p=Ze(_,t,f,a,s,m,i,n,e),y.push(m),w=p.sub(m);}b=w.mag();}const T=w._mult((x-v)/b)._add(m||g),P=u+Math.atan2(f.y-g.y,f.x-g.x);return y.push(T),{point:T,angle:l?P:0,path:y}}const Ve=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function $e(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(Ve,3*e);}}function qe(e,t,i){const o=t[0],r=t[1];return e[0]=i[0]*o+i[4]*r+i[12],e[1]=i[1]*o+i[5]*r+i[13],e[3]=i[3]*o+i[7]*r+i[15],e}const We=100;class He{constructor(e,t=new Ce(e.width+200,e.height+200,25),i=new Ce(e.width+200,e.height+200,25)){this.transform=e,this.grid=t,this.ignoredGrid=i,this.pitchFactor=Math.cos(e.pitch*Math.PI/180)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+We,this.screenBottomBoundary=e.height+We,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.perspectiveRatioCutoff=.6;}placeCollisionBox(e,t,i,o,r,a,s,n,l,c,h,u){const d=this.projectAndGetPerspectiveRatio(e.anchorPointX+n[0],e.anchorPointY+n[1],r,c,u),_=i*d.perspectiveRatio;let p;if(a||s)p=this._projectCollisionBox(e,_,o,r,a,s,n,d,c,h,u);else {const t=d.x+(h?h.x*_:0),i=d.y+(h?h.y*_:0);p={allPointsOccluded:!1,box:[t+e.x1*_,i+e.y1*_,t+e.x2*_,i+e.y2*_]};}const[m,f,g,v]=p.box,b=a?p.allPointsOccluded:d.isOccluded;let x=b;return x||(x=d.perspectiveRatio<this.perspectiveRatioCutoff),x||(x=!this.isInsideGrid(m,f,g,v)),x||"always"!==t&&this.grid.hitTest(m,f,g,v,t,l)?{box:[m,f,g,v],placeable:!1,offscreen:!1,occluded:b}:{box:[m,f,g,v],placeable:!0,offscreen:this.isOffscreen(m,f,g,v),occluded:b}}placeCollisionCircles(e,i,o,r,a,s,n,l,c,h,u,d,_,p){const m=[],f=new t.P(i.anchorX,i.anchorY),g=this.getPerspectiveRatio(f.x,f.y,s,p),v=(c?a*this.transform.getPitchedTextCorrection(i.anchorX,i.anchorY,s)/g:a*g)/t.aB,b={getElevation:p,pitchedLabelPlaneMatrix:n,lineVertexArray:o,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:f,unwrappedTileID:s,width:this.transform.width,height:this.transform.height,translation:_},x=Ae(v,r,i.lineOffsetX*v,i.lineOffsetY*v,!1,i,!1,b);let y=!1,w=!1,T=!0;if(x){const i=.5*u*g+d,o=new t.P(-100,-100),r=new t.P(this.screenRightBoundary,this.screenBottomBoundary),a=new Te,s=x.first,n=x.last;let _=[];for(let e=s.path.length-1;e>=1;e--)_.push(s.path[e]);for(let e=1;e<n.path.length;e++)_.push(n.path[e]);const p=2.5*i;if(c){const e=this.projectPathToScreenSpace(_,b);_=e.some((e=>e.signedDistanceFromCamera<=0))?[]:e.map((e=>e.point));}let f=[];if(_.length>0){const e=_[0].clone(),i=_[0].clone();for(let t=1;t<_.length;t++)e.x=Math.min(e.x,_[t].x),e.y=Math.min(e.y,_[t].y),i.x=Math.max(i.x,_[t].x),i.y=Math.max(i.y,_[t].y);f=e.x>=o.x&&i.x<=r.x&&e.y>=o.y&&i.y<=r.y?[_]:i.x<o.x||e.x>r.x||i.y<o.y||e.y>r.y?[]:t.ay([_],o.x,o.y,r.x,r.y);}for(const t of f){a.reset(t,.25*i);let o=0;o=a.length<=.5*i?1:Math.ceil(a.paddedLength/p)+1;for(let t=0;t<o;t++){const r=t/Math.max(o-1,1),s=a.lerp(r),n=s.x+We,c=s.y+We;m.push(n,c,i,0);const u=n-i,d=c-i,_=n+i,p=c+i;if(T=T&&this.isOffscreen(u,d,_,p),w=w||this.isInsideGrid(u,d,_,p),"always"!==e&&this.grid.hitTestCircle(n,c,i,e,h)&&(y=!0,!l))return {circles:[],offscreen:!1,collisionDetected:y}}}}return {circles:!l&&y||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:y}}projectPathToScreenSpace(e,i){const o=function(e,i){const o=t.L();return t.aq(o,i.pitchedLabelPlaneMatrix),e.map((e=>{const t=Ee(e.x,e.y,o,i.getElevation),r=i.transform.projectTileCoordinates(t.point.x,t.point.y,i.unwrappedTileID,i.getElevation);return r.point.x=(.5*r.point.x+.5)*i.width,r.point.y=(.5*-r.point.y+.5)*i.height,r}))}(e,i);return function(e){let t=0,i=0,o=0,r=0;for(let a=0;a<e.length;a++)e[a].isOccluded?(o=a+1,r=0):(r++,r>i&&(i=r,t=o));return e.slice(t,t+i)}(o)}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[],o=new t.a2;for(const r of e){const e=new t.P(r.x+We,r.y+We);o.extend(e),i.push(e);}const{minX:r,minY:a,maxX:s,maxY:n}=o,l=this.grid.query(r,a,s,n).concat(this.ignoredGrid.query(r,a,s,n)),c={},h={};for(const e of l){const o=e.key;if(void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]={}),c[o.bucketInstanceId][o.featureIndex])continue;const r=[new t.P(e.x1,e.y1),new t.P(e.x2,e.y1),new t.P(e.x2,e.y2),new t.P(e.x1,e.y2)];t.az(i,r)&&(c[o.bucketInstanceId][o.featureIndex]=!0,void 0===h[o.bucketInstanceId]&&(h[o.bucketInstanceId]=[]),h[o.bucketInstanceId].push(o.featureIndex));}return h}insertCollisionBox(e,t,i,o,r,a){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:o,featureIndex:r,collisionGroupID:a,overlapMode:t},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,r,a){const s=i?this.ignoredGrid:this.grid,n={bucketInstanceId:o,featureIndex:r,collisionGroupID:a,overlapMode:t};for(let t=0;t<e.length;t+=4)s.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(e,i,o,r,a){if(a){let o;r?(o=[e,i,r(e,i),1],t.aw(o,o,a)):(o=[e,i,0,1],qe(o,o,a));const s=o[3];return {x:(o[0]/s+1)/2*this.transform.width+We,y:(-o[1]/s+1)/2*this.transform.height+We,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const t=this.transform.projectTileCoordinates(e,i,o,r);return {x:(t.point.x+1)/2*this.transform.width+We,y:(1-t.point.y)/2*this.transform.height+We,perspectiveRatio:.5+this.transform.cameraToCenterDistance/t.signedDistanceFromCamera*.5,isOccluded:t.isOccluded,signedDistanceFromCamera:t.signedDistanceFromCamera}}}getPerspectiveRatio(e,t,i,o){const r=this.transform.projectTileCoordinates(e,t,i,o);return .5+this.transform.cameraToCenterDistance/r.signedDistanceFromCamera*.5}isOffscreen(e,t,i,o){return i<We||e>=this.screenRightBoundary||o<We||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=t.ag([]);return t.M(e,e,[-100,-100,0]),e}_projectCollisionBox(e,i,o,r,a,s,n,l,c,h,u){let d=1,_=0,p=0,m=1;const f=e.anchorPointX+n[0],g=e.anchorPointY+n[1];if(s&&!a){const e=this.projectAndGetPerspectiveRatio(f+1,g,r,c,u),t=e.x-l.x,i=Math.atan((e.y-l.y)/t)+(t<0?Math.PI:0),o=Math.sin(i),a=Math.cos(i);d=a,_=o,p=-o,m=a;}else if(!s&&a){const e=Se(this.transform);d=e.vecEast[0],_=e.vecEast[1],p=e.vecSouth[0],m=e.vecSouth[1];}let v=l.x,b=l.y,x=i;a&&(v=f,b=g,x=Math.pow(2,-(this.transform.zoom-o.overscaledZ)),x*=this.transform.getPitchedTextCorrection(f,g,r),h||(x*=t.ah(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(v+=d*h.x*x+p*h.y*x,b+=_*h.x*x+m*h.y*x);const y=e.x1*x,w=e.x2*x,T=(y+w)/2,P=e.y1*x,C=e.y2*x,I=(P+C)/2,M=[{offsetX:y,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:I},{offsetX:w,offsetY:C},{offsetX:T,offsetY:C},{offsetX:y,offsetY:C},{offsetX:y,offsetY:I}];let S=[];for(const{offsetX:e,offsetY:i}of M)S.push(new t.P(v+d*e+p*i,b+_*e+m*i));let E=!1;if(a){const e=S.map((e=>this.projectAndGetPerspectiveRatio(e.x,e.y,r,c,u)));E=e.some((e=>!e.isOccluded)),S=e.map((e=>new t.P(e.x,e.y)));}else E=!0;return {box:t.aA(S),allPointsOccluded:!E}}}class Xe{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class Ke{constructor(e,t,i,o,r){this.text=new Xe(e?e.text:null,t,i,r),this.icon=new Xe(e?e.icon:null,t,o,r);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Ye{constructor(e,t,i){this.text=e,this.icon=t,this.skipFade=i;}}class Qe{constructor(e,t,i,o,r){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=r;}}class Je{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function et(e,i,o,r,a){const{horizontalAlign:s,verticalAlign:n}=t.aH(e);return new t.P(-(s-.5)*i+r[0]*a,-(n-.5)*o+r[1]*a)}class tt{constructor(e,t,i,o,r){this.transform=e.clone(),this.terrain=t,this.collisionIndex=new He(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new Je(o),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=r,r&&(r.prevPlacement=void 0),this.placedOrientations={};}_getTerrainElevationFunc(e){const t=this.terrain;return t?(i,o)=>t.getElevation(e,i,o):null}getBucketParts(e,i,o,r){const a=o.getBucket(i),s=o.latestFeatureIndex;if(!a||!s||i.id!==a.layerIds[0])return;const n=o.collisionBoxArray,l=a.layers[0].layout,c=a.layers[0].paint,h=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),u=o.tileSize/t.$,d=o.tileID.toUnwrapped(),_="map"===l.get("text-rotation-alignment"),p=t.aC(o,1,this.transform.zoom),m=t.aD(this.collisionIndex.transform,o,c.get("text-translate"),c.get("text-translate-anchor")),f=t.aD(this.collisionIndex.transform,o,c.get("icon-translate"),c.get("icon-translate-anchor")),g=Ie(_,this.transform,p);this.retainedQueryData[a.bucketInstanceId]=new Qe(a.bucketInstanceId,s,a.sourceLayerIndex,a.index,o.tileID);const v={bucket:a,layout:l,translationText:m,translationIcon:f,unwrappedTileID:d,pitchedLabelPlaneMatrix:g,scale:h,textPixelRatio:u,holdingForFade:o.holdingForFade(),collisionBoxArray:n,partiallyEvaluatedTextSize:t.an(a.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(a.sourceID)};if(r)for(const t of a.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r}=t;e.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r,parameters:v});}else e.push({symbolInstanceStart:0,symbolInstanceEnd:a.symbolInstances.length,parameters:v});}attemptAnchorPlacement(e,i,o,r,a,s,n,l,c,h,u,d,_,p,m,f,g,v,b,x){const y=t.aE[e.textAnchor],w=[e.textOffset0,e.textOffset1],T=et(y,o,r,w,a),P=this.collisionIndex.placeCollisionBox(i,d,l,c,h,n,s,f,u.predicate,b,T,x);if((!v||this.collisionIndex.placeCollisionBox(v,d,l,c,h,n,s,g,u.predicate,b,T,x).placeable)&&P.placeable){let e;if(this.prevPlacement&&this.prevPlacement.variableOffsets[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID].text&&(e=this.prevPlacement.variableOffsets[_.crossTileID].anchor),0===_.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[_.crossTileID]={textOffset:w,width:o,height:r,anchor:y,textBoxScale:a,prevAnchor:e},this.markUsedJustification(p,y,_,m),p.allowVerticalPlacement&&(this.markUsedOrientation(p,m,_),this.placedOrientations[_.crossTileID]=m),{shift:T,placedGlyphBoxes:P}}}placeLayerBucketPart(e,i,o){const{bucket:r,layout:a,translationText:s,translationIcon:n,unwrappedTileID:l,pitchedLabelPlaneMatrix:c,textPixelRatio:h,holdingForFade:u,collisionBoxArray:d,partiallyEvaluatedTextSize:_,collisionGroup:p}=e.parameters,m=a.get("text-optional"),f=a.get("icon-optional"),g=t.aF(a,"text-overlap","text-allow-overlap"),v="always"===g,b=t.aF(a,"icon-overlap","icon-allow-overlap"),x="always"===b,y="map"===a.get("text-rotation-alignment"),w="map"===a.get("text-pitch-alignment"),T="none"!==a.get("icon-text-fit"),P="viewport-y"===a.get("symbol-z-order"),C=v&&(x||!r.hasIconData()||f),I=x&&(v||!r.hasTextData()||m);!r.collisionArrays&&d&&r.deserializeCollisionBoxes(d);const M=this.retainedQueryData[r.bucketInstanceId].tileID,S=this._getTerrainElevationFunc(M),E=this.transform.getFastPathSimpleProjectionMatrix(M),R=(e,d,x)=>{var P,R;if(i[e.crossTileID])return;if(u)return void(this.placements[e.crossTileID]=new Ye(!1,!1,!1));let z=!1,D=!1,A=!0,L=null,k={box:null,placeable:!1,offscreen:null,occluded:!1},F={placeable:!1},B=null,O=null,j=null,N=0,U=0,Z=0;d.textFeatureIndex?N=d.textFeatureIndex:e.useRuntimeCollisionCircles&&(N=e.featureIndex),d.verticalTextFeatureIndex&&(U=d.verticalTextFeatureIndex);const G=d.textBox;if(G){const i=i=>{let o=t.ao.horizontal;if(r.allowVerticalPlacement&&!i&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,o=t,this.markUsedOrientation(r,o,e));}return o},a=(i,o)=>{if(r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&d.verticalTextBox){for(const e of r.writingModes)if(e===t.ao.vertical?(k=o(),F=k):k=i(),k&&k.placeable)break}else k=i();},c=e.textAnchorOffsetStartIndex,u=e.textAnchorOffsetEndIndex;if(u===c){const o=(t,i)=>{const o=this.collisionIndex.placeCollisionBox(t,g,h,M,l,w,y,s,p.predicate,S,void 0,E);return o&&o.placeable&&(this.markUsedOrientation(r,i,e),this.placedOrientations[e.crossTileID]=i),o};a((()=>o(G,t.ao.horizontal)),(()=>{const i=d.verticalTextBox;return r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&i?o(i,t.ao.vertical):{box:null,offscreen:null}})),i(k&&k.placeable);}else {let _=t.aE[null===(R=null===(P=this.prevPlacement)||void 0===P?void 0:P.variableOffsets[e.crossTileID])||void 0===R?void 0:R.anchor];const m=(t,i,a)=>{const d=t.x2-t.x1,m=t.y2-t.y1,f=e.textBoxScale,v=T&&"never"===b?i:null;let x=null,P="never"===g?1:2,C="never";_&&P++;for(let i=0;i<P;i++){for(let i=c;i<u;i++){const o=r.textAnchorOffsets.get(i);if(_&&o.textAnchor!==_)continue;const c=this.attemptAnchorPlacement(o,t,d,m,f,y,w,h,M,l,p,C,e,r,a,s,n,v,S);if(c&&(x=c.placedGlyphBoxes,x&&x.placeable))return z=!0,L=c.shift,x}_?_=null:C=g;}return o&&!x&&(x={box:this.collisionIndex.placeCollisionBox(G,"always",h,M,l,w,y,s,p.predicate,S,void 0,E).box,offscreen:!1,placeable:!1,occluded:!1}),x};a((()=>m(G,d.iconBox,t.ao.horizontal)),(()=>{const i=d.verticalTextBox;return r.allowVerticalPlacement&&(!k||!k.placeable)&&e.numVerticalGlyphVertices>0&&i?m(i,d.verticalIconBox,t.ao.vertical):{box:null,occluded:!0,offscreen:null}})),k&&(z=k.placeable,A=k.offscreen);const f=i(k&&k.placeable);if(!z&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(r,t.anchor,e,f));}}}if(B=k,z=B&&B.placeable,A=B&&B.offscreen,e.useRuntimeCollisionCircles){const i=r.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),n=t.ap(r.textSizeData,_,i),h=a.get("text-padding");O=this.collisionIndex.placeCollisionCircles(g,i,r.lineVertexArray,r.glyphOffsetArray,n,l,c,o,w,p.predicate,e.collisionCircleDiameter,h,s,S),O.circles.length&&O.collisionDetected&&!o&&t.w("Collisions detected, but collision boxes are not shown"),z=v||O.circles.length>0&&!O.collisionDetected,A=A&&O.offscreen;}if(d.iconFeatureIndex&&(Z=d.iconFeatureIndex),d.iconBox){const e=e=>this.collisionIndex.placeCollisionBox(e,b,h,M,l,w,y,n,p.predicate,S,T&&L?L:void 0,E);F&&F.placeable&&d.verticalIconBox?(j=e(d.verticalIconBox),D=j.placeable):(j=e(d.iconBox),D=j.placeable),A=A&&j.offscreen;}const V=m||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,$=f||0===e.numIconVertices;V||$?$?V||(D=D&&z):z=D&&z:D=z=D&&z;const q=D&&j.placeable;if(z&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,g,a.get("text-ignore-placement"),r.bucketInstanceId,F&&F.placeable&&U?U:N,p.ID),q&&this.collisionIndex.insertCollisionBox(j.box,b,a.get("icon-ignore-placement"),r.bucketInstanceId,Z,p.ID),O&&z&&this.collisionIndex.insertCollisionCircles(O.circles,g,a.get("text-ignore-placement"),r.bucketInstanceId,N,p.ID),o&&this.storeCollisionData(r.bucketInstanceId,x,d,B,j,O),0===e.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[e.crossTileID]=new Ye((z||C)&&!(null==B?void 0:B.occluded),(D||I)&&!(null==j?void 0:j.occluded),A||r.justReloaded),i[e.crossTileID]=!0;};if(P){if(0!==e.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const t=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let e=t.length-1;e>=0;--e){const i=t[e];R(r.symbolInstances.get(i),r.collisionArrays[i],i);}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)R(r.symbolInstances.get(t),r.collisionArrays[t],t);r.justReloaded=!1;}storeCollisionData(e,t,i,o,r,a){if(i.textBox||i.iconBox){let a,s;this.collisionBoxArrays.has(e)?a=this.collisionBoxArrays.get(e):(a=new Map,this.collisionBoxArrays.set(e,a)),a.has(t)?s=a.get(t):(s={text:null,icon:null},a.set(t,s)),i.textBox&&(s.text=o.box),i.iconBox&&(s.icon=r.box);}if(a){let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=[]);for(let e=0;e<a.circles.length;e+=4)t.push(a.circles[e+0]-We),t.push(a.circles[e+1]-We),t.push(a.circles[e+2]),t.push(a.collisionDetected?1:0);}}markUsedJustification(e,i,o,r){let a;a=r===t.ao.vertical?o.verticalPlacedTextSymbolIndex:{left:o.leftJustifiedTextSymbolIndex,center:o.centerJustifiedTextSymbolIndex,right:o.rightJustifiedTextSymbolIndex}[t.aG(i)];const s=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex,o.verticalPlacedTextSymbolIndex];for(const t of s)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=a>=0&&t!==a?0:o.crossTileID);}markUsedOrientation(e,i,o){const r=i===t.ao.horizontal||i===t.ao.horizontalOnly?i:0,a=i===t.ao.vertical?i:0,s=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex];for(const t of s)e.text.placedSymbolArray.get(t).placedOrientation=r;o.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(o.verticalPlacedTextSymbolIndex).placedOrientation=a);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,r=t?t.opacities:{},a=t?t.variableOffsets:{},s=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],a=r[e];a?(this.opacities[e]=new Ke(a,o,t.text,t.icon),i=i||t.text!==a.text.placed||t.icon!==a.icon.placed):(this.opacities[e]=new Ke(null,o,t.text,t.icon,t.skipFade),i=i||t.text||t.icon);}for(const e in r){const t=r[e];if(!this.opacities[e]){const r=new Ke(t,o,!1,!1);r.isHidden()||(this.opacities[e]=r,i=i||t.text.placed||t.icon.placed);}}for(const e in a)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=a[e]);for(const e in s)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=s[e]);if(t&&void 0===t.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const o of t){const t=o.getBucket(e);t&&o.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,o.tileID,i,o.collisionBoxArray);}}updateBucketOpacities(e,i,o,r){e.hasTextData()&&(e.text.opacityVertexArray.clear(),e.text.hasVisibleVertices=!1),e.hasIconData()&&(e.icon.opacityVertexArray.clear(),e.icon.hasVisibleVertices=!1),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const a=e.layers[0],s=a.layout,n=new Ke(null,0,!1,!1,!0),l=s.get("text-allow-overlap"),c=s.get("icon-allow-overlap"),h=a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===s.get("text-rotation-alignment"),d="map"===s.get("text-pitch-alignment"),_="none"!==s.get("icon-text-fit"),p=new Ke(null,0,l&&(c||!e.hasIconData()||s.get("icon-optional")),c&&(l||!e.hasTextData()||s.get("text-optional")),!0);!e.collisionArrays&&r&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(r);const m=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);e.hasVisibleVertices=e.hasVisibleVertices||i!==ut;},f=this.collisionBoxArrays.get(e.bucketInstanceId);for(let i=0;i<e.symbolInstances.length;i++){const r=e.symbolInstances.get(i),{numHorizontalGlyphVertices:a,numVerticalGlyphVertices:s,crossTileID:l}=r;let c=this.opacities[l];o[l]?c=n:c||(c=p,this.opacities[l]=c),o[l]=!0;const g=r.numIconVertices>0,v=this.placedOrientations[r.crossTileID],b=v===t.ao.vertical,x=v===t.ao.horizontal||v===t.ao.horizontalOnly;if(a>0||s>0){const t=ht(c.text);m(e.text,a,b?ut:t),m(e.text,s,x?ut:t);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||b?1:0);})),r.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||x?1:0);const o=this.variableOffsets[r.crossTileID];o&&this.markUsedJustification(e,o.anchor,r,v);const n=this.placedOrientations[r.crossTileID];n&&(this.markUsedJustification(e,"left",r,n),this.markUsedOrientation(e,n,r));}if(g){const t=ht(c.icon),i=!(_&&r.verticalPlacedIconSymbolIndex&&b);r.placedIconSymbolIndex>=0&&(m(e.icon,r.numIconVertices,i?t:ut),e.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(e.icon,r.numVerticalIconVertices,i?ut:t),e.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden());}const y=f&&f.has(i)?f.get(i):{text:null,icon:null};if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const o=e.collisionArrays[i];if(o){let i=new t.P(0,0);if(o.textBox||o.verticalTextBox){let t=!0;if(h){const e=this.variableOffsets[l];e?(i=et(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),u&&i._rotate(d?-this.transform.bearingInRadians:this.transform.bearingInRadians)):t=!1;}if(o.textBox||o.verticalTextBox){let r;o.textBox&&(r=b),o.verticalTextBox&&(r=x),it(e.textCollisionBox.collisionVertexArray,c.text.placed,!t||r,y.text,i.x,i.y);}}if(o.iconBox||o.verticalIconBox){const t=Boolean(!x&&o.verticalIconBox);let r;o.iconBox&&(r=t),o.verticalIconBox&&(r=!t),it(e.iconCollisionBox.collisionVertexArray,c.icon.placed,r,y.icon,_?i.x:0,_?i.y:0);}}}}if(e.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.text.opacityVertexArray.length!==e.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${e.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${e.text.layoutVertexArray.length}) / 4`);if(e.icon.opacityVertexArray.length!==e.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${e.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${e.icon.layoutVertexArray.length}) / 4`);e.bucketInstanceId in this.collisionCircleArrays&&(e.collisionCircleArray=this.collisionCircleArrays[e.bucketInstanceId],delete this.collisionCircleArrays[e.bucketInstanceId]);}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function it(e,t,i,o,r,a){o&&0!==o.length||(o=[0,0,0,0]);const s=o[0]-We,n=o[1]-We,l=o[2]-We,c=o[3]-We;e.emplaceBack(t?1:0,i?1:0,r||0,a||0,s,n),e.emplaceBack(t?1:0,i?1:0,r||0,a||0,l,n),e.emplaceBack(t?1:0,i?1:0,r||0,a||0,l,c),e.emplaceBack(t?1:0,i?1:0,r||0,a||0,s,c);}const ot=Math.pow(2,25),rt=Math.pow(2,24),at=Math.pow(2,17),st=Math.pow(2,16),nt=Math.pow(2,9),lt=Math.pow(2,8),ct=Math.pow(2,1);function ht(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*ot+t*rt+i*at+t*st+i*nt+t*lt+i*ct+t}const ut=0;class dt{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&!e.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,o,r){const a=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(a,o,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,a.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<a.length;)if(t.placeLayerBucketPart(a[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,r())return !0;return !1}}class _t{constructor(e,t,i,o,r,a,s,n){this.placement=new tt(e,t,a,s,n),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=o,this._showCollisionBoxes=r,this._done=!1;}isDone(){return this._done}continuePlacement(e,t,i){const o=s.now(),r=()=>!this._forceFullPlacement&&s.now()-o>2;for(;this._currentPlacementIndex>=0;){const o=t[e[this._currentPlacementIndex]],a=this.placement.collisionIndex.transform.zoom;if("symbol"===o.type&&(!o.minzoom||o.minzoom<=a)&&(!o.maxzoom||o.maxzoom>a)){if(this._inProgressLayer||(this._inProgressLayer=new dt(o)),this._inProgressLayer.continuePlacement(i[o.source],this.placement,this._showCollisionBoxes,o,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const pt=512/t.$/2;class mt{constructor(e,i,o){this.tileID=e,this.bucketInstanceId=o,this._symbolsByKey={};const r=new Map;for(let e=0;e<i.length;e++){const t=i.get(e),o=t.key,a=r.get(o);a?a.push(t):r.set(o,[t]);}for(const[e,i]of r){const o={positions:i.map((e=>({x:Math.floor(e.anchorX*pt),y:Math.floor(e.anchorY*pt)}))),crossTileIDs:i.map((e=>e.crossTileID))};if(o.positions.length>128){const e=new t.aI(o.positions.length,16,Uint16Array);for(const{x:t,y:i}of o.positions)e.add(t,i);e.finish(),delete o.positions,o.index=e;}this._symbolsByKey[e]=o;}}getScaledCoordinates(e,i){const{x:o,y:r,z:a}=this.tileID.canonical,{x:s,y:n,z:l}=i.canonical,c=pt/Math.pow(2,l-a),h=(n*t.$+e.anchorY)*c,u=r*t.$*pt;return {x:Math.floor((s*t.$+e.anchorX)*c-o*t.$*pt),y:Math.floor(h-u)}}findMatches(e,t,i){const o=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let r=0;r<e.length;r++){const a=e.get(r);if(a.crossTileID)continue;const s=this._symbolsByKey[a.key];if(!s)continue;const n=this.getScaledCoordinates(a,t);if(s.index){const e=s.index.range(n.x-o,n.y-o,n.x+o,n.y+o).sort();for(const t of e){const e=s.crossTileIDs[t];if(!i[e]){i[e]=!0,a.crossTileID=e;break}}}else if(s.positions)for(let e=0;e<s.positions.length;e++){const t=s.positions[e],r=s.crossTileIDs[e];if(Math.abs(t.x-n.x)<=o&&Math.abs(t.y-n.y)<=o&&!i[r]){i[r]=!0,a.crossTileID=r;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:e})=>e))}}class ft{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class gt{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const r=i[e];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),o[r.tileID.key]=r;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in r){const a=r[i];a.tileID.isChildOf(e)&&a.findMatches(t.symbolInstances,e,o);}else {const a=r[e.scaledTo(Number(i)).key];a&&a.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e);r.crossTileID||(r.crossTileID=i.generate(),o[r.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new mt(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.getCrossTileIDsLists())for(const t of i)delete this.usedCrossTileIDs[e][t];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const r in o)e[o[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[r]),delete o[r],t=!0);}return t}}class vt{constructor(){this.layerIndexes={},this.crossTileIDs=new ft,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i){let o=this.layerIndexes[e.id];void 0===o&&(o=this.layerIndexes[e.id]=new gt);let r=!1;const a={};o.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),o.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),a[t.bucketInstanceId]=!0);}return o.removeStaleBuckets(a)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}var bt="void main() {fragColor=vec4(1.0);}";const xt={prelude:yt("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:yt("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:yt("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:yt("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:yt("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:yt("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:yt(bt,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:yt("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:yt("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:yt("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:yt("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:yt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:yt("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:yt(bt,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:yt("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:yt("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:yt("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:yt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:yt("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:yt("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:yt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:yt("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:yt("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:yt("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:yt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:yt("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:yt("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:yt("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:yt("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:yt("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:yt("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:yt("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:yt("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:yt("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:yt("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:yt("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function yt(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,o=t.match(/in ([\w]+) ([\w]+)/g),r=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),a=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=a?a.concat(r):r,n={};return {fragmentSource:e=e.replace(i,((e,t,i,o,r)=>(n[r]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nin ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = u_${r};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,o,r)=>{const a="float"===o?"vec2":"vec4",s=r.match(/color/)?"color":a;return n[r]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${a} a_${r};\nout ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${a} a_${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`})),staticAttributes:o,staticUniforms:s}}class wt{constructor(e,t,i){this.vertexBuffer=e,this.indexBuffer=t,this.segments=i;}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null;}}var Tt=t.aJ([{name:"a_pos",type:"Int16",components:2}]);const Pt="#define PROJECTION_MERCATOR",Ct="mercator";class It{constructor(){this._cachedMesh=null;}get name(){return "mercator"}get useSubdivision(){return !1}get shaderVariantName(){return Ct}get shaderDefine(){return Pt}get shaderPreludeCode(){return xt.projectionMercator}get vertexShaderPreludeCode(){return xt.projectionMercator.vertexSource}get subdivisionGranularity(){return t.aK.noSubdivision}get useGlobeControls(){return !1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(e){}getMeshFromTileID(e,i,o,r,a){if(this._cachedMesh)return this._cachedMesh;const s=new t.aL;s.emplaceBack(0,0),s.emplaceBack(t.$,0),s.emplaceBack(0,t.$),s.emplaceBack(t.$,t.$);const n=e.createVertexBuffer(s,Tt.members),l=t.aM.simpleSegment(0,0,4,2),c=new t.aN;c.emplaceBack(1,0,2),c.emplaceBack(1,2,3);const h=e.createIndexBuffer(c);return this._cachedMesh=new wt(n,h,l),this._cachedMesh}recalculate(){}hasTransition(){return !1}setErrorQueryLatitudeDegrees(e){}}class Mt{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(e,i,o){return null!=i.top&&null!=e.top&&(this.top=t.C.number(e.top,i.top,o)),null!=i.bottom&&null!=e.bottom&&(this.bottom=t.C.number(e.bottom,i.bottom,o)),null!=i.left&&null!=e.left&&(this.left=t.C.number(e.left,i.left,o)),null!=i.right&&null!=e.right&&(this.right=t.C.number(e.right,i.right,o)),this}getCenter(e,i){const o=t.ah((this.left+e-this.right)/2,0,e),r=t.ah((this.top+i-this.bottom)/2,0,i);return new t.P(o,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Mt(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function St(e,t){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}function Et(e){return Math.max(0,Math.floor(e))}class Rt{constructor(e,i,o,r,a,s){this._callbacks=e,this._tileSize=512,this._renderWorldCopies=void 0===s||!!s,this._minZoom=i||0,this._maxZoom=o||22,this._minPitch=null==r?0:r,this._maxPitch=null==a?60:a,this.setMaxBounds(),this._width=0,this._height=0,this._center=new t.S(0,0),this._elevation=0,this._zoom=0,this._tileZoom=Et(this._zoom),this._scale=t.af(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new Mt,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0;}apply(e,i,o){this._latRange=e.latRange,this._lngRange=e.lngRange,this._width=e.width,this._height=e.height,this._center=e.center,this._elevation=e.elevation,this._minElevationForCurrentTile=e.minElevationForCurrentTile,this._zoom=e.zoom,this._tileZoom=Et(this._zoom),this._scale=t.af(this._zoom),this._bearingInRadians=e.bearingInRadians,this._fovInRadians=e.fovInRadians,this._pitchInRadians=e.pitchInRadians,this._rollInRadians=e.rollInRadians,this._unmodified=e.unmodified,this._edgeInsets=new Mt(e.padding.top,e.padding.bottom,e.padding.left,e.padding.right),this._minZoom=e.minZoom,this._maxZoom=e.maxZoom,this._minPitch=e.minPitch,this._maxPitch=e.maxPitch,this._renderWorldCopies=e.renderWorldCopies,this._cameraToCenterDistance=e.cameraToCenterDistance,this._nearZ=e.nearZ,this._farZ=e.farZ,this._autoCalculateNearFarZ=!o&&e.autoCalculateNearFarZ,i&&this._constrain(),this._calcMatrices();}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(e){this._minElevationForCurrentTile=e;}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(e){this._minZoom!==e&&(this._minZoom=e,this.setZoom(this.getConstrained(this._center,this.zoom).zoom));}get maxZoom(){return this._maxZoom}setMaxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.setZoom(this.getConstrained(this._center,this.zoom).zoom));}get minPitch(){return this._minPitch}setMinPitch(e){this._minPitch!==e&&(this._minPitch=e,this.setPitch(Math.max(this.pitch,e)));}get maxPitch(){return this._maxPitch}setMaxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.setPitch(Math.min(this.pitch,e)));}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new t.P(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(e){const i=t.aO(e,-180,180)*Math.PI/180;var r,a,s,n,l,c,h,u,d;this._bearingInRadians!==i&&(this._unmodified=!1,this._bearingInRadians=i,this._calcMatrices(),this._rotationMatrix=o(),r=this._rotationMatrix,s=-this._bearingInRadians,n=(a=this._rotationMatrix)[0],l=a[1],c=a[2],h=a[3],u=Math.sin(s),d=Math.cos(s),r[0]=n*d+c*u,r[1]=l*d+h*u,r[2]=n*-u+c*d,r[3]=l*-u+h*d);}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(e){const i=t.ah(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==i&&(this._unmodified=!1,this._pitchInRadians=i,this._calcMatrices());}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(e){const t=e/180*Math.PI;this._rollInRadians!==t&&(this._unmodified=!1,this._rollInRadians=t,this._calcMatrices());}get fovInRadians(){return this._fovInRadians}get fov(){return t.aP(this._fovInRadians)}setFov(e){e=t.ah(e,.1,150),this.fov!==e&&(this._unmodified=!1,this._fovInRadians=t.ae(e),this._calcMatrices());}get zoom(){return this._zoom}setZoom(e){const i=this.getConstrained(this._center,e).zoom;this._zoom!==i&&(this._unmodified=!1,this._zoom=i,this._tileZoom=Math.max(0,Math.floor(i)),this._scale=t.af(i),this._constrain(),this._calcMatrices());}get center(){return this._center}setCenter(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._constrain(),this._calcMatrices());}get elevation(){return this._elevation}setElevation(e){e!==this._elevation&&(this._elevation=e,this._constrain(),this._calcMatrices());}get padding(){return this._edgeInsets.toJSON()}setPadding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(e,t){this._autoCalculateNearFarZ=!1,this._nearZ=e,this._farZ=t,this._calcMatrices();}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices();}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}resize(e,t,i=!0){this._width=e,this._height=t,i&&this._constrain(),this._calcMatrices();}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new G([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(e){e?(this._lngRange=[e.getWest(),e.getEast()],this._latRange=[e.getSouth(),e.getNorth()],this._constrain()):(this._lngRange=null,this._latRange=[-t.ai,t.ai]);}getConstrained(e,t){return this._callbacks.getConstrained(e,t)}getCameraQueryGeometry(e,i){if(1===i.length)return [i[0],e];{const{minX:o,minY:r,maxX:a,maxY:s}=t.a2.fromPoints(i).extend(e);return [new t.P(o,r),new t.P(a,r),new t.P(a,s),new t.P(o,s),new t.P(o,r)]}}_constrain(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const e=this._unmodified,{center:t,zoom:i}=this.getConstrained(this.center,this.zoom);this.setCenter(t),this.setZoom(i),this._unmodified=e,this._constraining=!1;}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let e=t.ag(new Float64Array(16));t.N(e,e,[this._width/2,-this._height/2,1]),t.M(e,e,[1,-1,0]),this._clipSpaceToPixelsMatrix=e,e=t.ag(new Float64Array(16)),t.N(e,e,[1,-1,1]),t.M(e,e,[-1,-1,0]),t.N(e,e,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=e,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height;}this._callbacks.calcMatrices();}calculateCenterFromCameraLngLatAlt(e,i,o,r){const a=void 0!==o?o:this.bearing,s=r=void 0!==r?r:this.pitch,n=t.a1.fromLngLat(e,i),l=-Math.cos(t.ae(s)),c=Math.sin(t.ae(s)),h=c*Math.sin(t.ae(a)),u=-c*Math.cos(t.ae(a));let d=this.elevation;const _=i-d;let p;l*_>=0||Math.abs(l)<.1?(p=1e4,d=i+p*l):p=-_/l;let m,f,g=t.aQ(1,n.y),v=0;do{if(v+=1,v>10)break;f=p/g,m=new t.a1(n.x+h*f,n.y+u*f),g=1/m.meterInMercatorCoordinateUnits();}while(Math.abs(p-f*g)>1e-12);return {center:m.toLngLat(),elevation:d,zoom:t.ak(this.height/2/Math.tan(this.fovInRadians/2)/f/this.tileSize)}}recalculateZoomAndCenter(e){if(this.elevation-e==0)return;const i=t.aj(1,this.center.lat)*this.worldSize,o=this.cameraToCenterDistance/i,r=t.a1.fromLngLat(this.center,this.elevation),a=de(this.center,this.elevation,this.pitch,this.bearing,o);this._elevation=e;const s=this.calculateCenterFromCameraLngLatAlt(a.toLngLat(),t.aQ(a.z,r.y),this.bearing,this.pitch);this._elevation=s.elevation,this._center=s.center,this.setZoom(s.zoom);}getCameraPoint(){const e=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new t.P(e*Math.sin(this.rollInRadians),e*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const e=t.aj(1,this.center.lat)*this.worldSize;return de(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/e).toLngLat()}getMercatorTileCoordinates(e){if(!e)return [0,0,1,1];const i=e.canonical.z>=0?1<<e.canonical.z:Math.pow(2,e.canonical.z);return [e.canonical.x/i,e.canonical.y/i,1/i/t.$,1/i/t.$]}}class zt{constructor(e,i){this.min=e,this.max=i,this.center=t.aR([],t.aS([],this.min,this.max),.5);}quadrant(e){const i=[e%2==0,e<2],o=t.aT(this.min),r=t.aT(this.max);for(let e=0;e<i.length;e++)o[e]=i[e]?this.min[e]:this.center[e],r[e]=i[e]?this.center[e]:this.max[e];return r[2]=this.max[2],new zt(o,r)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}intersectsFrustum(e){let t=!0;for(let i=0;i<e.planes.length;i++){const o=this.intersectsPlane(e.planes[i]);if(0===o)return 0;1===o&&(t=!1);}return t?2:e.aabb.min[0]>this.max[0]||e.aabb.min[1]>this.max[1]||e.aabb.min[2]>this.max[2]||e.aabb.max[0]<this.min[0]||e.aabb.max[1]<this.min[1]||e.aabb.max[2]<this.min[2]?0:1}intersectsPlane(e){let t=e[3],i=e[3];for(let o=0;o<3;o++)e[o]>0?(t+=e[o]*this.min[o],i+=e[o]*this.max[o]):(i+=e[o]*this.min[o],t+=e[o]*this.max[o]);return t>=0?2:i<0?0:1}}class Dt{distanceToTile2d(e,t,i,o){const r=o.distanceX([e,t]),a=o.distanceY([e,t]);return Math.hypot(r,a)}getWrap(e,t,i){return i}getTileBoundingVolume(e,i,o,r){var a,s;let n=0,l=0;if(null==r?void 0:r.terrain){const c=new t.Z(e.z,i,e.z,e.x,e.y),h=r.terrain.getMinMaxElevation(c);n=null!==(a=h.minElevation)&&void 0!==a?a:Math.min(0,o),l=null!==(s=h.maxElevation)&&void 0!==s?s:Math.max(0,o);}const c=1<<e.z;return new zt([i+e.x/c,e.y/c,n],[i+(e.x+1)/c,(e.y+1)/c,l])}allowVariableZoom(e,i){const o=e.fov*(Math.abs(Math.cos(e.rollInRadians))*e.height+Math.abs(Math.sin(e.rollInRadians))*e.width)/e.height,r=t.ah(78.5-o/2,0,60);return !!i.terrain||e.pitch>r}allowWorldCopies(){return !0}prepareNextFrame(){}}class At{constructor(e,t,i){this.points=e,this.planes=t,this.aabb=i;}static fromInvProjectionMatrix(e,i=1,o=0,r,a){const s=a?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],n=Math.pow(2,o),l=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((o=>function(e,i,o,r){const a=t.aw([],e,i),s=1/a[3]/o*r;return t.aY(a,a,[s,s,1/a[3],s])}(o,e,i,n)));r&&function(e,i,o,r){const a=r?4:0,s=r?0:4;let n=0;const l=[],c=[];for(let i=0;i<4;i++){const o=t.aU([],e[i+s],e[i+a]),r=t.aZ(o);t.aR(o,o,1/r),l.push(r),c.push(o);}for(let i=0;i<4;i++){const r=t.a_(e[i+a],c[i],o);n=null!==r&&r>=0?Math.max(n,r):Math.max(n,l[i]);}const h=function(e,i){const o=t.aU([],e[i[0]],e[i[1]]),r=t.aU([],e[i[2]],e[i[1]]),a=[0,0,0,0];return t.aV(a,t.aW([],o,r)),a[3]=-t.aX(a,e[i[0]]),a}(e,i),u=function(e,i){const o=t.a$(e),r=t.b0([],e,1/o),a=t.aU([],i,t.aR([],r,t.aX(i,r))),s=t.a$(a);if(s>0){const e=Math.sqrt(1-r[3]*r[3]),o=t.aR([],r,-r[3]),n=t.aS([],o,t.aR([],a,e/s));return t.b1(i,n)}return null}(o,h);if(null!==u){const e=u/t.aX(c[0],h);n=Math.min(n,e);}for(let t=0;t<4;t++){const i=Math.min(n,l[t]);e[t+s]=[e[t+a][0]+c[t][0]*i,e[t+a][1]+c[t][1]*i,e[t+a][2]+c[t][2]*i,1];}}(l,s[0],r,a);const c=s.map((e=>{const i=t.aU([],l[e[0]],l[e[1]]),o=t.aU([],l[e[2]],l[e[1]]),r=t.aV([],t.aW([],i,o)),a=-t.aX(r,l[e[1]]);return r.concat(a)})),h=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],u=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const e of l)for(let t=0;t<3;t++)h[t]=Math.min(h[t],e[t]),u[t]=Math.max(u[t],e[t]);return new At(l,c,new zt(h,u))}}class Lt{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e,t){}constructor(e,t,i,o,r){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this._helper=new Rt({calcMatrices:()=>{this._calcMatrices();},getConstrained:(e,t)=>this.getConstrained(e,t)},e,t,i,o,r),this._coveringTilesDetailsProvider=new Dt;}clone(){const e=new Lt;return e.apply(this),e}apply(e,t,i){this._helper.apply(e,t,i);}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(e){const i=[new t.b2(0,e)];if(this._helper._renderWorldCopies){const o=this.screenPointToMercatorCoordinate(new t.P(0,0)),r=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,0)),a=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,this._helper._height)),s=this.screenPointToMercatorCoordinate(new t.P(0,this._helper._height)),n=Math.floor(Math.min(o.x,r.x,a.x,s.x)),l=Math.floor(Math.max(o.x,r.x,a.x,s.x)),c=1;for(let o=n-c;o<=l+c;o++)0!==o&&i.push(new t.b2(o,e));}return i}getCameraFrustum(){return At.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){const t=this.screenPointToLocation(this.centerPoint,e),i=e?e.getElevationForLngLatZoom(t,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i);}setLocationAtPoint(e,i){const o=t.aj(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(i,o),a=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,o),s=t.a1.fromLngLat(e),n=new t.a1(s.x-(r.x-a.x),s.y-(r.y-a.y));this.setCenter(null==n?void 0:n.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap());}locationToScreenPoint(e,i){return i?this.coordinatePoint(t.a1.fromLngLat(e),i.getElevationForLngLatZoom(e,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(t.a1.fromLngLat(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(e,t){if(t){const i=t.pointCoordinate(e);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(e)}screenPointToMercatorCoordinateAtZ(e,i){const o=i||0,r=[e.x,e.y,0,1],a=[e.x,e.y,1,1];t.aw(r,r,this._pixelMatrixInverse),t.aw(a,a,this._pixelMatrixInverse);const s=r[3],n=a[3],l=r[1]/s,c=a[1]/n,h=r[2]/s,u=a[2]/n,d=h===u?0:(o-h)/(u-h);return new t.a1(t.C.number(r[0]/s,a[0]/n,d)/this.worldSize,t.C.number(l,c,d)/this.worldSize,o)}coordinatePoint(e,i=0,o=this._pixelMatrix){const r=[e.x*this.worldSize,e.y*this.worldSize,i,1];return t.aw(r,r,o),new t.P(r[0]/r[3],r[1]/r[3])}getBounds(){const e=Math.max(0,this._helper._height/2-he(this));return (new G).extend(this.screenPointToLocation(new t.P(0,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new t.P(0,this._helper._height)))}isPointOnMapSurface(e,t){return t?null!=t.pointCoordinate(e):e.y>this.height/2-he(this)}calculatePosMatrix(e,i=!1,o){var r;const a=null!==(r=e.key)&&void 0!==r?r:t.b3(e.wrap,e.canonical.z,e.canonical.z,e.canonical.x,e.canonical.y),s=i?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(a)){const e=s.get(a);return o?e.f32:e.f64}const n=ue(e,this.worldSize);t.O(n,i?this._alignedProjMatrix:this._viewProjMatrix,n);const l={f64:n,f32:new Float32Array(n)};return s.set(a,l),o?l.f32:l.f64}calculateFogMatrix(e){const i=e.key,o=this._fogMatrixCacheF32;if(o.has(i))return o.get(i);const r=ue(e,this.worldSize);return t.O(r,this._fogMatrix,r),o.set(i,new Float32Array(r)),o.get(i)}getConstrained(e,i){i=t.ah(+i,this.minZoom,this.maxZoom);const o={center:new t.S(e.lng,e.lat),zoom:i};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const e=180-1e-10;r=[-e,e];}const a=this.tileSize*t.af(o.zoom);let s=0,n=a,l=0,c=a,h=0,u=0;const{x:d,y:_}=this.size;if(this._helper._latRange){const e=this._helper._latRange;s=t.U(e[1])*a,n=t.U(e[0])*a,n-s<_&&(h=_/(n-s));}r&&(l=t.aO(t.V(r[0])*a,0,a),c=t.aO(t.V(r[1])*a,0,a),c<l&&(c+=a),c-l<d&&(u=d/(c-l)));const{x:p,y:m}=le(a,e);let f,g;const v=Math.max(u||0,h||0);if(v){const e=new t.P(u?(c+l)/2:p,h?(n+s)/2:m);return o.center=ce(a,e).wrap(),o.zoom+=t.ak(v),o}if(this._helper._latRange){const e=_/2;m-e<s&&(g=s+e),m+e>n&&(g=n-e);}if(r){const e=(l+c)/2;let i=p;this._helper._renderWorldCopies&&(i=t.aO(p,e-a/2,e+a/2));const o=d/2;i-o<l&&(f=l+o),i+o>c&&(f=c-o);}if(void 0!==f||void 0!==g){const e=new t.P(null!=f?f:p,null!=g?g:m);o.center=ce(a,e).wrap();}return o}calculateCenterFromCameraLngLatAlt(e,t,i,o){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,o)}_calculateNearFarZIfNeeded(e,i,o){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),a=e-r*this._helper._pixelPerMeter/Math.cos(i),s=r<0?a:e,n=Math.PI/2+this.pitchInRadians,l=t.ae(this.fov)*(Math.abs(Math.cos(t.ae(this.roll)))*this.height+Math.abs(Math.sin(t.ae(this.roll)))*this.width)/this.height*(.5+o.y/this.height),c=Math.sin(l)*s/Math.sin(t.ah(Math.PI-n-l,.01,Math.PI-.01)),h=he(this),u=Math.atan(h/this._helper.cameraToCenterDistance),d=t.ae(.75),_=u>d?2*u*(.5+o.y/(2*h)):d,p=Math.sin(_)*s/Math.sin(t.ah(Math.PI-n-_,.01,Math.PI-.01)),m=Math.min(c,p);this._helper._farZ=1.01*(Math.cos(Math.PI/2-i)*m+s),this._helper._nearZ=this._helper._height/50;}_calcMatrices(){if(!this._helper._height)return;const e=this.centerOffset,i=le(this.worldSize,this.center),o=i.x,r=i.y;this._helper._pixelPerMeter=t.aj(1,this.center.lat)*this.worldSize;const a=t.ae(Math.min(this.pitch,ne)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(a));let n;this._calculateNearFarZIfNeeded(s,a,e),n=new Float64Array(16),t.b4(n,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),t.aq(this._invProjMatrix,n),n[8]=2*-e.x/this._helper._width,n[9]=2*e.y/this._helper._height,this._projectionMatrix=t.b5(n),t.N(n,n,[1,-1,1]),t.M(n,n,[0,0,-this._helper.cameraToCenterDistance]),t.b6(n,n,-this.rollInRadians),t.b7(n,n,this.pitchInRadians),t.b6(n,n,-this.bearingInRadians),t.M(n,n,[-o,-r,0]),this._mercatorMatrix=t.N([],n,[this.worldSize,this.worldSize,this.worldSize]),t.N(n,n,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=t.O(new Float64Array(16),this.clipSpaceToPixelsMatrix,n),t.M(n,n,[0,0,-this.elevation]),this._viewProjMatrix=n,this._invViewProjMatrix=t.aq([],n);const l=[0,0,-1,1];t.aw(l,l,this._invViewProjMatrix),this._cameraPosition=[l[0]/l[3],l[1]/l[3],l[2]/l[3]],this._fogMatrix=new Float64Array(16),t.b4(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-e.x/this.width,this._fogMatrix[9]=2*e.y/this.height,t.N(this._fogMatrix,this._fogMatrix,[1,-1,1]),t.M(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),t.b6(this._fogMatrix,this._fogMatrix,-this.rollInRadians),t.b7(this._fogMatrix,this._fogMatrix,this.pitchInRadians),t.b6(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),t.M(this._fogMatrix,this._fogMatrix,[-o,-r,0]),t.N(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),t.M(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=t.O(new Float64Array(16),this.clipSpaceToPixelsMatrix,n);const c=this._helper._width%2/2,h=this._helper._height%2/2,u=Math.cos(this.bearingInRadians),d=Math.sin(-this.bearingInRadians),_=o-Math.round(o)+u*c+d*h,p=r-Math.round(r)+u*h+d*c,m=new Float64Array(n);if(t.M(m,m,[_>.5?_-1:_,p>.5?p-1:p,0]),this._alignedProjMatrix=m,n=t.aq(new Float64Array(16),this._pixelMatrix),!n)throw new Error("failed to invert matrix");this._pixelMatrixInverse=n,this._clearMatrixCaches();}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear();}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const e=this.screenPointToMercatorCoordinate(new t.P(0,0)),i=[e.x*this.worldSize,e.y*this.worldSize,0,1];return t.aw(i,i,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const e=t.aj(1,this.center.lat)*this.worldSize;return de(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/e).toLngLat()}lngLatToCameraDepth(e,i){const o=t.a1.fromLngLat(e),r=[o.x*this.worldSize,o.y*this.worldSize,i,1];return t.aw(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(e){const{overscaledTileID:i,aligned:o,applyTerrainMatrix:r}=e,a=this._helper.getMercatorTileCoordinates(i),s=i?this.calculatePosMatrix(i,o,!0):null;let n;return n=i&&i.terrainRttPosMatrix32f&&r?i.terrainRttPosMatrix32f:s||t.b8(),{mainMatrix:n,tileMercatorCoords:a,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:n}}isLocationOccluded(e){return !1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(e,t,i){return 1}transformLightDirection(e){return t.aT(e)}getRayDirectionFromPixel(e){throw new Error("Not implemented.")}projectTileCoordinates(e,i,o,r){const a=this.calculatePosMatrix(o);let s;r?(s=[e,i,r(e,i),1],t.aw(s,s,a)):(s=[e,i,0,1],qe(s,s,a));const n=s[3];return {point:new t.P(s[0]/n,s[1]/n),signedDistanceFromCamera:n,isOccluded:!1}}populateCache(e){for(const t of e)this.calculatePosMatrix(t);}getMatrixForModel(e,i){const o=t.a1.fromLngLat(e,i),r=o.meterInMercatorCoordinateUnits(),a=t.b9();return t.M(a,a,[o.x,o.y,o.z]),t.b6(a,a,Math.PI),t.b7(a,a,Math.PI/2),t.N(a,a,[-r,r,r]),a}getProjectionDataForCustomLayer(e=!0){const i=new t.Z(0,0,0,0,0),o=this.getProjectionData({overscaledTileID:i,applyGlobeMatrix:e}),r=ue(i,this.worldSize);t.O(r,this._viewProjMatrix,r),o.tileMercatorCoords=[0,0,1,1];const a=[t.$,t.$,this.worldSize/this._helper.pixelsPerMeter],s=t.ba();return t.N(s,r,a),o.fallbackMatrix=s,o.mainMatrix=s,o}getFastPathSimpleProjectionMatrix(e){return this.calculatePosMatrix(e)}}function kt(){t.w("Map cannot fit within canvas with the given bounds, padding, and/or offset.");}function Ft(e){if(e.useSlerp)if(e.k<1){const i=t.bb(e.startEulerAngles.roll,e.startEulerAngles.pitch,e.startEulerAngles.bearing),o=t.bb(e.endEulerAngles.roll,e.endEulerAngles.pitch,e.endEulerAngles.bearing),r=new Float64Array(4);t.bc(r,i,o,e.k);const a=t.bd(r);e.tr.setRoll(a.roll),e.tr.setPitch(a.pitch),e.tr.setBearing(a.bearing);}else e.tr.setRoll(e.endEulerAngles.roll),e.tr.setPitch(e.endEulerAngles.pitch),e.tr.setBearing(e.endEulerAngles.bearing);else e.tr.setRoll(t.C.number(e.startEulerAngles.roll,e.endEulerAngles.roll,e.k)),e.tr.setPitch(t.C.number(e.startEulerAngles.pitch,e.endEulerAngles.pitch,e.k)),e.tr.setBearing(t.C.number(e.startEulerAngles.bearing,e.endEulerAngles.bearing,e.k));}function Bt(e,i,o,r,a){const s=a.padding,n=le(a.worldSize,o.getNorthWest()),l=le(a.worldSize,o.getNorthEast()),c=le(a.worldSize,o.getSouthEast()),h=le(a.worldSize,o.getSouthWest()),u=t.ae(-r),d=n.rotate(u),_=l.rotate(u),p=c.rotate(u),m=h.rotate(u),f=new t.P(Math.max(d.x,_.x,m.x,p.x),Math.max(d.y,_.y,m.y,p.y)),g=new t.P(Math.min(d.x,_.x,m.x,p.x),Math.min(d.y,_.y,m.y,p.y)),v=f.sub(g),b=(a.width-(s.left+s.right+i.left+i.right))/v.x,x=(a.height-(s.top+s.bottom+i.top+i.bottom))/v.y;if(x<0||b<0)return void kt();const y=Math.min(t.ak(a.scale*Math.min(b,x)),e.maxZoom),w=t.P.convert(e.offset),T=new t.P((i.left-i.right)/2,(i.top-i.bottom)/2).rotate(t.ae(r)),P=w.add(T).mult(a.scale/t.af(y));return {center:ce(a.worldSize,n.add(c).div(2).sub(P)),zoom:y,bearing:r}}class Ot{get useGlobeControls(){return !1}handlePanInertia(e,t){const i=e.mag(),o=Math.abs(he(t));return {easingOffset:e.mult(Math.min(.75*o/i,1)),easingCenter:t.center}}handleMapControlsRollPitchBearingZoom(e,t){e.bearingDelta&&t.setBearing(t.bearing+e.bearingDelta),e.pitchDelta&&t.setPitch(t.pitch+e.pitchDelta),e.rollDelta&&t.setRoll(t.roll+e.rollDelta),e.zoomDelta&&t.setZoom(t.zoom+e.zoomDelta);}handleMapControlsPan(e,t,i){e.around.distSqr(t.centerPoint)<.01||t.setLocationAtPoint(i,e.around);}cameraForBoxAndBearing(e,t,i,o,r){return Bt(e,t,i,o,r)}handleJumpToCenterZoom(e,i){e.zoom!==(void 0!==i.zoom?+i.zoom:e.zoom)&&e.setZoom(+i.zoom),void 0!==i.center&&e.setCenter(t.S.convert(i.center));}handleEaseTo(e,i){const o=e.zoom,r=e.padding,a={roll:e.roll,pitch:e.pitch,bearing:e.bearing},s={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},n=void 0!==i.zoom,l=!e.isPaddingEqual(i.padding);let c=!1;const h=n?+i.zoom:e.zoom;let u=e.centerPoint.add(i.offsetAsPoint);const d=e.screenPointToLocation(u),{center:_,zoom:p}=e.getConstrained(t.S.convert(i.center||d),null!=h?h:o);St(e,_);const m=le(e.worldSize,d),f=le(e.worldSize,_).sub(m),g=t.af(p-o);return c=p!==o,{easeFunc:n=>{if(c&&e.setZoom(t.C.number(o,p,n)),t.be(a,s)||Ft({startEulerAngles:a,endEulerAngles:s,tr:e,k:n,useSlerp:a.roll!=s.roll}),l&&(e.interpolatePadding(r,i.padding,n),u=e.centerPoint.add(i.offsetAsPoint)),i.around)e.setLocationAtPoint(i.around,i.aroundPoint);else {const i=t.af(e.zoom-o),r=p>o?Math.min(2,g):Math.max(.5,g),a=Math.pow(r,1-n),s=ce(e.worldSize,m.add(f.mult(n*a)).mult(i));e.setLocationAtPoint(e.renderWorldCopies?s.wrap():s,u);}},isZooming:c,elevationCenter:_}}handleFlyTo(e,i){const o=void 0!==i.zoom,r=e.zoom,a=e.getConstrained(t.S.convert(i.center||i.locationAtOffset),o?+i.zoom:r),s=a.center,n=a.zoom;St(e,s);const l=le(e.worldSize,i.locationAtOffset),c=le(e.worldSize,s).sub(l),h=c.mag(),u=t.af(n-r);let d;if(void 0!==i.minZoom){const o=Math.min(+i.minZoom,r,n),a=e.getConstrained(s,o).zoom;d=t.af(a-r);}return {easeFunc:(i,o,a,h)=>{e.setZoom(1===i?n:r+t.ak(o));const u=1===i?s:ce(e.worldSize,l.add(c.mult(a)).mult(o));e.setLocationAtPoint(e.renderWorldCopies?u.wrap():u,h);},scaleOfZoom:u,targetCenter:s,scaleOfMinZoom:d,pixelPathLength:h}}}class jt{constructor(e,t,i){this.blendFunction=e,this.blendColor=t,this.mask=i;}}jt.Replace=[1,0],jt.disabled=new jt(jt.Replace,t.bf.transparent,[!1,!1,!1,!1]),jt.unblended=new jt(jt.Replace,t.bf.transparent,[!0,!0,!0,!0]),jt.alphaBlended=new jt([1,771],t.bf.transparent,[!0,!0,!0,!0]);const Nt=2305;class Ut{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}Ut.disabled=new Ut(!1,1029,Nt),Ut.backCCW=new Ut(!0,1029,Nt),Ut.frontCCW=new Ut(!0,1028,Nt);class Zt{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Zt.ReadOnly=!1,Zt.ReadWrite=!0,Zt.disabled=new Zt(519,Zt.ReadOnly,[0,1]);const Gt=7680;class Vt{constructor(e,t,i,o,r,a){this.test=e,this.ref=t,this.mask=i,this.fail=o,this.depthFail=r,this.pass=a;}}Vt.disabled=new Vt({func:519,mask:0},0,0,Gt,Gt,Gt);const $t=new WeakMap;function qt(e){var t;if($t.has(e))return $t.get(e);{const i=null===(t=e.getParameter(e.VERSION))||void 0===t?void 0:t.startsWith("WebGL 2.0");return $t.set(e,i),i}}class Wt{get awaitingQuery(){return !!this._readbackQueue}constructor(e){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=e;const i=e.context,o=i.gl;this._texFormat=o.RGBA,this._texType=o.UNSIGNED_BYTE;const r=new t.aL;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const a=new t.aN;a.emplaceBack(0,1,2),this._fullscreenTriangle=new wt(i.createVertexBuffer(r,Tt.members),i.createIndexBuffer(a),t.aM.simpleSegment(0,0,r.length,a.length)),this._resultBuffer=new Uint8Array(4),i.activeTexture.set(o.TEXTURE1);const s=o.createTexture();o.bindTexture(o.TEXTURE_2D,s),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.NEAREST),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.NEAREST),o.texImage2D(o.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=i.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),qt(o)&&(this._pbo=o.createBuffer(),o.bindBuffer(o.PIXEL_PACK_BUFFER,this._pbo),o.bufferData(o.PIXEL_PACK_BUFFER,4,o.STREAM_READ),o.bindBuffer(o.PIXEL_PACK_BUFFER,null));}destroy(){const e=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),e.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null;}updateErrorLoop(e,t){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(e,t),this._updateCount++,this._measuredError}_bindFramebuffer(){const e=this._cachedRenderContext.context,t=e.gl;e.activeTexture.set(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,this._fbo.colorAttachment.get()),e.bindFramebuffer.set(this._fbo.framebuffer);}_renderErrorTexture(e,i){const o=this._cachedRenderContext.context,r=o.gl;if(this._bindFramebuffer(),o.viewport.set([0,0,this._texWidth,this._texHeight]),o.clear({color:t.bf.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(o,r.TRIANGLES,Zt.disabled,Vt.disabled,jt.unblended,Ut.disabled,((e,t)=>({u_input:e,u_output_expected:t}))(e,i),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&qt(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const e=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:e};}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null};}_tryReadback(){const e=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&qt(e)){const i=e.clientWaitSync(this._readbackQueue.sync,0,0);if(i===e.WAIT_FAILED)return t.w("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(i===e.TIMEOUT_EXPIRED)return;e.bindBuffer(e.PIXEL_PACK_BUFFER,this._pbo),e.getBufferSubData(e.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),e.bindBuffer(e.PIXEL_PACK_BUFFER,null);}else this._bindFramebuffer(),e.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=Wt._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount;}static _parseRGBA8float(e){let t=0;return t+=e[0]/256,t+=e[1]/65536,t+=e[2]/16777216,e[3]<127&&(t=-t),t/128}}const Ht=t.$/128;function Xt(e,i){const o=void 0!==e.granularity?Math.max(e.granularity,1):1,r=o+(e.generateBorders?2:0),a=o+(e.extendToNorthPole||e.generateBorders?1:0)+(e.extendToSouthPole||e.generateBorders?1:0),s=r+1,n=a+1,l=e.generateBorders?-1:0,c=e.generateBorders||e.extendToNorthPole?-1:0,h=o+(e.generateBorders?1:0),u=o+(e.generateBorders||e.extendToSouthPole?1:0),d=s*n,_=r*a*6,p=s*n>65536;if(p&&"16bit"===i)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const m=p||"32bit"===i,f=new Int16Array(2*d);let g=0;for(let i=c;i<=u;i++)for(let r=l;r<=h;r++){let a=r/o*t.$;-1===r&&(a=-Ht),r===o+1&&(a=t.$+Ht);let s=i/o*t.$;-1===i&&(s=e.extendToNorthPole?t.bh:-Ht),i===o+1&&(s=e.extendToSouthPole?t.bi:t.$+Ht),f[g++]=a,f[g++]=s;}const v=m?new Uint32Array(_):new Uint16Array(_);let b=0;for(let e=0;e<a;e++)for(let t=0;t<r;t++){const i=t+1+e*s,o=t+(e+1)*s,r=t+1+(e+1)*s;v[b++]=t+e*s,v[b++]=o,v[b++]=i,v[b++]=i,v[b++]=o,v[b++]=r;}return {vertices:f.buffer.slice(0),indices:v.buffer.slice(0),uses32bitIndices:m}}const Kt=new t.aK({fill:new t.bj(128,2),line:new t.bj(512,0),tile:new t.bj(128,32),stencil:new t.bj(128,1),circle:3});class Yt{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3;}get name(){return "vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return !0}get shaderVariantName(){return "globe"}get shaderDefine(){return "#define GLOBE"}get shaderPreludeCode(){return xt.projectionGlobe}get vertexShaderPreludeCode(){return xt.projectionMercator.vertexSource}get subdivisionGranularity(){return Kt}get useGlobeControls(){return !0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy();}updateGPUdependent(e){this._errorMeasurement||(this._errorMeasurement=new Wt(e));const i=t.U(this._errorQueryLatitudeDegrees),o=2*Math.atan(Math.exp(Math.PI-i*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(i,o),a=s.now();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=a);const n=Math.min(Math.max((a-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=t.bk(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,t.bl(n));}_getMeshKey(e){return `${e.granularity.toString(36)}_${e.generateBorders?"b":""}${e.extendToNorthPole?"n":""}${e.extendToSouthPole?"s":""}`}getMeshFromTileID(e,t,i,o,r){const a=("stencil"===r?Kt.stencil:Kt.tile).getGranularityForZoomLevel(t.z);return this._getMesh(e,{granularity:a,generateBorders:i,extendToNorthPole:0===t.y&&o,extendToSouthPole:t.y===(1<<t.z)-1&&o})}_getMesh(e,i){const o=this._getMeshKey(i);if(o in this._tileMeshCache)return this._tileMeshCache[o];const r=function(e,i){const o=Xt(i,"16bit"),r=t.aL.deserialize({arrayBuffer:o.vertices,length:o.vertices.byteLength/2/2}),a=t.aN.deserialize({arrayBuffer:o.indices,length:o.indices.byteLength/2/3});return new wt(e.createVertexBuffer(r,Tt.members),e.createIndexBuffer(a),t.aM.simpleSegment(0,0,r.length,a.length))}(e,i);return this._tileMeshCache[o]=r,r}recalculate(e){}hasTransition(){const e=s.now();let t=!1;return t=t||(e-this._errorMeasurementLastChangeTime)/1e3<.7,t=t||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,t}setErrorQueryLatitudeDegrees(e){this._errorQueryLatitudeDegrees=e;}}const Qt=new t.r({type:new t.D(t.v.projection.type)});class Jt extends t.E{constructor(e){super(),this._transitionable=new t.t(Qt),this.setProjection(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.F(0)),this._mercatorProjection=new It,this._verticalPerspectiveProjection=new Yt;}get transitionState(){const e=this.properties.get("type");if("string"==typeof e&&"mercator"===e)return 0;if("string"==typeof e&&"vertical-perspective"===e)return 1;if(e instanceof t.bm){if("vertical-perspective"===e.from&&"mercator"===e.to)return 1-e.transition;if("mercator"===e.from&&"vertical-perspective"===e.to)return e.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return "globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy();}updateGPUdependent(e){this._mercatorProjection.updateGPUdependent(e),this._verticalPerspectiveProjection.updateGPUdependent(e);}getMeshFromTileID(e,t,i,o,r){return this.currentProjection.getMeshFromTileID(e,t,i,o,r)}setProjection(e){this._transitionable.setValue("type",(null==e?void 0:e.type)||"mercator");}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}setErrorQueryLatitudeDegrees(e){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(e),this._mercatorProjection.setErrorQueryLatitudeDegrees(e);}}function ei(e){const t=oi(e.worldSize,e.center.lat);return 2*Math.PI*t}function ti(e,i,o,r,a){const s=1/(1<<a),n=i/t.$*s+r*s,l=t.bo((e/t.$*s+o*s)*Math.PI*2+Math.PI,2*Math.PI),c=2*Math.atan(Math.exp(Math.PI-n*Math.PI*2))-.5*Math.PI,h=Math.cos(c),u=new Float64Array(3);return u[0]=Math.sin(l)*h,u[1]=Math.sin(c),u[2]=Math.cos(l)*h,u}function ii(e){return function(e,t){const i=Math.cos(t),o=new Float64Array(3);return o[0]=Math.sin(e)*i,o[1]=Math.sin(t),o[2]=Math.cos(e)*i,o}(e.lng*Math.PI/180,e.lat*Math.PI/180)}function oi(e,t){return e/(2*Math.PI)/Math.cos(t*Math.PI/180)}function ri(e){const i=Math.asin(e[1])/Math.PI*180,o=Math.sqrt(e[0]*e[0]+e[2]*e[2]);if(o>1e-6){const r=e[0]/o,a=Math.acos(e[2]/o),s=(r>0?a:-a)/Math.PI*180;return new t.S(t.aO(s,-180,180),i)}return new t.S(0,i)}function ai(e){return Math.cos(e*Math.PI/180)}function si(e,i){const o=ai(e),r=ai(i);return t.ak(r/o)}function ni(e,i){const o=e.rotate(i.bearingInRadians),r=i.zoom+si(i.center.lat,0),a=t.bk(1/ai(i.center.lat),1/ai(Math.min(Math.abs(i.center.lat),60)),t.bn(r,7,3,0,1)),s=360/ei({worldSize:i.worldSize,center:{lat:i.center.lat}});return new t.S(i.center.lng-o.x*s*a,t.ah(i.center.lat+o.y*s,-t.ai,t.ai))}function li(e){const t=.5*e,i=Math.sin(t),o=Math.cos(t);return Math.log(i+o)-Math.log(o-i)}function ci(e,i,o,r){const a=e.lat+o*r;if(Math.abs(o)>1){const s=(Math.sign(e.lat+o)!==Math.sign(e.lat)?-Math.abs(e.lat):Math.abs(e.lat))*Math.PI/180,n=Math.abs(e.lat+o)*Math.PI/180,l=li(s+r*(n-s)),c=li(s),h=li(n);return new t.S(e.lng+i*((l-c)/(h-c)),a)}return new t.S(e.lng+i*r,a)}class hi{constructor(e){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=e;}swapBuffers(){if(!this._hadAnyChanges)return;const e=this._cachePrevious;this._cachePrevious=this._cache,this._cache=e,this._cache.clear(),this._hadAnyChanges=!1;}getTileBoundingVolume(e,t,i,o){const r=`${e.z}_${e.x}_${e.y}_${(null==o?void 0:o.terrain)?"t":""}`,a=this._cache.get(r);if(a)return a;const s=this._cachePrevious.get(r);if(s)return this._cache.set(r,s),s;const n=this._boundingVolumeFactory(e,t,i,o);return this._cache.set(r,n),this._hadAnyChanges=!0,n}}class ui{constructor(e,t,i,o){this.min=i,this.max=o,this.points=e,this.planes=t;}static fromAabb(e,t){const i=[];for(let o=0;o<8;o++)i.push([1&~o?e[0]:t[0],1==(o>>1&1)?t[1]:e[1],1==(o>>2&1)?t[2]:e[2]]);return new ui(i,[[-1,0,0,t[0]],[1,0,0,-e[0]],[0,-1,0,t[1]],[0,1,0,-e[1]],[0,0,-1,t[2]],[0,0,1,-e[2]]],e,t)}static fromCenterSizeAngles(e,i,o){const r=t.br([],o[0],o[1],o[2]),a=t.bs([],[i[0],0,0],r),s=t.bs([],[0,i[1],0],r),n=t.bs([],[0,0,i[2]],r),l=[...e],c=[...e];for(let t=0;t<8;t++)for(let i=0;i<3;i++){const o=e[i]+a[i]*(1&~t?-1:1)+s[i]*(1==(t>>1&1)?1:-1)+n[i]*(1==(t>>2&1)?1:-1);l[i]=Math.min(l[i],o),c[i]=Math.max(c[i],o);}const h=[];for(let i=0;i<8;i++){const o=[...e];t.aS(o,o,t.aR([],a,1&~i?-1:1)),t.aS(o,o,t.aR([],s,1==(i>>1&1)?1:-1)),t.aS(o,o,t.aR([],n,1==(i>>2&1)?1:-1)),h.push(o);}return new ui(h,[[...a,-t.aX(a,h[0])],[...s,-t.aX(s,h[0])],[...n,-t.aX(n,h[0])],[-a[0],-a[1],-a[2],-t.aX(a,h[7])],[-s[0],-s[1],-s[2],-t.aX(s,h[7])],[-n[0],-n[1],-n[2],-t.aX(n,h[7])]],l,c)}intersectsFrustum(e){let t=!0;const i=this.points.length,o=this.planes.length,r=e.planes.length,a=e.points.length;for(let o=0;o<r;o++){const r=e.planes[o];let a=0;for(let e=0;e<i;e++){const t=this.points[e];r[0]*t[0]+r[1]*t[1]+r[2]*t[2]+r[3]>=0&&a++;}if(0===a)return 0;a<i&&(t=!1);}if(t)return 2;for(let t=0;t<o;t++){const i=this.planes[t];let o=0;for(let t=0;t<a;t++){const r=e.points[t];i[0]*r[0]+i[1]*r[1]+i[2]*r[2]+i[3]>=0&&o++;}if(0===o)return 0}return 1}intersectsPlane(e){const t=this.points.length;let i=0;for(let o=0;o<t;o++){const t=this.points[o];e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0&&i++;}return i===t?2:0===i?0:1}}function di(e,t,i){const o=e-t;return o<0?-o:Math.max(0,o-i)}function _i(e,t,i,o,r){const a=e-i;let s;return s=a<0?Math.min(-a,1+a-r):a>1?Math.min(Math.max(a-r,0),1-a):0,Math.max(s,di(t,o,r))}class pi{constructor(){this._boundingVolumeCache=new hi(this._computeTileBoundingVolume);}prepareNextFrame(){this._boundingVolumeCache.swapBuffers();}distanceToTile2d(e,t,i,o){const r=1<<i.z,a=1/r,s=i.x/r,n=i.y/r;let l=2;return l=Math.min(l,_i(e,t,s,n,a)),l=Math.min(l,_i(e,t,s+.5,-n-a,a)),l=Math.min(l,_i(e,t,s+.5,2-n-a,a)),l}getWrap(e,t,i){const o=1<<t.z,r=1/o,a=t.x/o,s=di(e.x,a,r),n=di(e.x,a-1,r),l=di(e.x,a+1,r),c=Math.min(s,n,l);return c===l?1:c===n?-1:0}allowVariableZoom(e,t){return ge(e,t)>4}allowWorldCopies(){return !1}getTileBoundingVolume(e,t,i,o){return this._boundingVolumeCache.getTileBoundingVolume(e,t,i,o)}_computeTileBoundingVolume(e,i,o,r){var a,s;let n=0,l=0;if(null==r?void 0:r.terrain){const c=new t.Z(e.z,i,e.z,e.x,e.y),h=r.terrain.getMinMaxElevation(c);n=null!==(a=h.minElevation)&&void 0!==a?a:Math.min(0,o),l=null!==(s=h.maxElevation)&&void 0!==s?s:Math.max(0,o);}if(n/=t.bu,l/=t.bu,n+=1,l+=1,e.z<=0)return ui.fromAabb([-l,-l,-l],[l,l,l]);if(1===e.z)return ui.fromAabb([0===e.x?-l:0,0===e.y?0:-l,-l],[0===e.x?0:l,0===e.y?l:0,l]);{const i=[ti(0,0,e.x,e.y,e.z),ti(t.$,0,e.x,e.y,e.z),ti(t.$,t.$,e.x,e.y,e.z),ti(0,t.$,e.x,e.y,e.z)],o=[];for(const e of i)o.push(t.aR([],e,l));if(l!==n)for(const e of i)o.push(t.aR([],e,n));0===e.y&&o.push([0,1,0]),e.y===(1<<e.z)-1&&o.push([0,-1,0]);const r=[1,1,1],a=[-1,-1,-1];for(const e of o)for(let t=0;t<3;t++)r[t]=Math.min(r[t],e[t]),a[t]=Math.max(a[t],e[t]);const s=ti(t.$/2,t.$/2,e.x,e.y,e.z),c=t.aW([],[0,1,0],s);t.aV(c,c);const h=t.aW([],s,c);t.aV(h,h);const u=t.aW([],i[2],i[1]);t.aV(u,u);const d=t.aW([],i[0],i[3]);t.aV(d,d),o.push(t.aR([],s,l)),e.y>=(1<<e.z)/2&&o.push(t.aR([],ti(t.$/2,0,e.x,e.y,e.z),l)),e.y<(1<<e.z)/2&&o.push(t.aR([],ti(t.$/2,t.$,e.x,e.y,e.z),l));const _=mi(s,o),p=mi(h,o),m=[-s[0],-s[1],-s[2],_.max],f=[s[0],s[1],s[2],-_.min],g=[-h[0],-h[1],-h[2],p.max],v=[h[0],h[1],h[2],-p.min],b=[...u,0],x=[...d,0],y=[];return 0===e.y?y.push(t.bt(x,b,m),t.bt(x,b,f)):y.push(t.bt(g,b,m),t.bt(g,b,f),t.bt(g,x,m),t.bt(g,x,f)),e.y===(1<<e.z)-1?y.push(t.bt(x,b,m),t.bt(x,b,f)):y.push(t.bt(v,b,m),t.bt(v,b,f),t.bt(v,x,m),t.bt(v,x,f)),new ui(y,[m,f,g,v,b,x],r,a)}}}function mi(e,i){let o=1/0,r=-1/0;for(const a of i){const i=t.aX(e,a);o=Math.min(o,i),r=Math.max(r,i);}return {min:o,max:r}}class fi{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t){this._helper.resize(e,t);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e){}constructor(){this._cachedClippingPlane=t.bv(),this._projectionMatrix=t.b9(),this._globeViewProjMatrix32f=t.b8(),this._globeViewProjMatrixNoCorrection=t.b9(),this._globeViewProjMatrixNoCorrectionInverted=t.b9(),this._globeProjMatrixInverted=t.b9(),this._cameraPosition=t.bp(),this._globeLatitudeErrorCorrectionRadians=0,this._helper=new Rt({calcMatrices:()=>{this._calcMatrices();},getConstrained:(e,t)=>this.getConstrained(e,t)}),this._coveringTilesDetailsProvider=new pi;}clone(){const e=new fi;return e.apply(this),e}apply(e,t){this._globeLatitudeErrorCorrectionRadians=t||0,this._helper.apply(e);}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const e=t.bp();return e[0]=this._cameraPosition[0],e[1]=this._cameraPosition[1],e[2]=this._cameraPosition[2],e}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(e){const{overscaledTileID:t,applyGlobeMatrix:i}=e,o=this._helper.getMercatorTileCoordinates(t);return {mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:o,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(e){const i=this.pitchInRadians,o=this.cameraToCenterDistance/e,r=Math.sin(i)*o,a=Math.cos(i)*o+1,s=1/Math.sqrt(r*r+a*a)*1;let n=-r,l=a;const c=Math.sqrt(n*n+l*l);n/=c,l/=c;const h=[0,n,l];t.bw(h,h,[0,0,0],-this.bearingInRadians),t.bx(h,h,[0,0,0],-1*this.center.lat*Math.PI/180),t.by(h,h,[0,0,0],this.center.lng*Math.PI/180);const u=1/t.aZ(h);return t.aR(h,h,u),[...h,-s*u]}isLocationOccluded(e){return !this.isSurfacePointVisible(ii(e))}transformLightDirection(e){const i=this._helper._center.lng*Math.PI/180,o=this._helper._center.lat*Math.PI/180,r=Math.cos(o),a=[Math.sin(i)*r,Math.sin(o),Math.cos(i)*r],s=[a[2],0,-a[0]],n=[0,0,0];t.aW(n,s,a),t.aV(s,s),t.aV(n,n);const l=[0,0,0];return t.aV(l,[s[0]*e[0]+n[0]*e[1]+a[0]*e[2],s[1]*e[0]+n[1]*e[1]+a[1]*e[2],s[2]*e[0]+n[2]*e[1]+a[2]*e[2]]),l}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(e,i,o){const r=function(e,i,o){const r=1/(1<<o.z);return new t.a1(e/t.$*r+o.x*r,i/t.$*r+o.y*r)}(e,i,o.canonical),a=(s=r.y,[t.bo(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(a[1])}projectTileCoordinates(e,i,o,r){const a=o.canonical,s=ti(e,i,a.x,a.y,a.z),n=1+(r?r(e,i):0)/t.bu,l=[s[0]*n,s[1]*n,s[2]*n,1];t.aw(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*s[0]+c[1]*s[1]+c[2]*s[2]+c[3]<0;return {point:new t.P(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const e=oi(this.worldSize,this.center.lat),i=t.ba(),o=t.ba();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*e),t.b4(i,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;i[8]=2*-r.x/this._helper._width,i[9]=2*r.y/this._helper._height,this._projectionMatrix=t.b5(i),this._globeProjMatrixInverted=t.ba(),t.aq(this._globeProjMatrixInverted,i),t.M(i,i,[0,0,-this.cameraToCenterDistance]),t.b6(i,i,this.rollInRadians),t.b7(i,i,-this.pitchInRadians),t.b6(i,i,this.bearingInRadians),t.M(i,i,[0,0,-e]);const a=t.bp();a[0]=e,a[1]=e,a[2]=e,t.b7(o,i,this.center.lat*Math.PI/180),t.bz(o,o,-this.center.lng*Math.PI/180),t.N(o,o,a),this._globeViewProjMatrixNoCorrection=o,t.b7(i,i,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),t.bz(i,i,-this.center.lng*Math.PI/180),t.N(i,i,a),this._globeViewProjMatrix32f=new Float32Array(i),this._globeViewProjMatrixNoCorrectionInverted=t.ba(),t.aq(this._globeViewProjMatrixNoCorrectionInverted,o);const s=t.bp();this._cameraPosition=t.bp(),this._cameraPosition[2]=this.cameraToCenterDistance/e,t.bw(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),t.bx(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),t.bw(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),t.aS(this._cameraPosition,this._cameraPosition,[0,0,1]),t.bx(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),t.by(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(e);const n=t.b5(this._globeViewProjMatrixNoCorrectionInverted);t.N(n,n,[1,1,-1]),this._cachedFrustum=At.fromInvProjectionMatrix(n,1,0,this._cachedClippingPlane,!0);}calculateFogMatrix(e){t.w("calculateFogMatrix is not supported on globe projection.");const i=t.ba();return t.ag(i),i}getVisibleUnwrappedCoordinates(e){return [new t.b2(0,e)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){e&&t.w("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0);}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,i){if(!this._globeViewProjMatrixNoCorrection)return 1;const o=ii(e);t.aR(o,o,1+i/t.bu);const r=t.bv();return t.aw(r,[o[0],o[1],o[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(e){}getBounds(){const e=.5*this.width,i=.5*this.height,o=[new t.P(0,0),new t.P(e,0),new t.P(this.width,0),new t.P(this.width,i),new t.P(this.width,this.height),new t.P(e,this.height),new t.P(0,this.height),new t.P(0,i)],r=[];for(const e of o)r.push(this.unprojectScreenPoint(e));let a=0,s=0,n=0,l=0;const c=this.center;for(const e of r){const i=t.bA(c.lng,e.lng),o=t.bA(c.lat,e.lat);i<s&&(s=i),i>a&&(a=i),o<l&&(l=o),o>n&&(n=o);}const h=[c.lng+s,c.lat+l,c.lng+a,c.lat+n];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new G(h)}getConstrained(e,i){const o=t.ah(e.lat,-t.ai,t.ai),r=t.ah(+i,this.minZoom+si(0,o),this.maxZoom);return {center:new t.S(e.lng,o),zoom:r}}calculateCenterFromCameraLngLatAlt(e,t,i,o){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,o)}setLocationAtPoint(e,i){const o=ii(this.unprojectScreenPoint(i)),r=ii(e),a=t.bp();t.bB(a);const s=t.bp();t.by(s,o,a,-this.center.lng*Math.PI/180),t.bx(s,s,a,this.center.lat*Math.PI/180);const n=r[0]*r[0]+r[2]*r[2],l=s[0]*s[0];if(n<l)return;const c=Math.sqrt(n-l),h=-c,u=t.bC(r[0],r[2],s[0],c),d=t.bC(r[0],r[2],s[0],h),_=t.bp();t.by(_,r,a,-u);const p=t.bC(_[1],_[2],s[1],s[2]),m=t.bp();t.by(m,r,a,-d);const f=t.bC(m[1],m[2],s[1],s[2]),g=.5*Math.PI,v=p>=-g&&p<=g,b=f>=-g&&f<=g;let x,y;if(v&&b){const e=this.center.lng*Math.PI/180,i=this.center.lat*Math.PI/180;t.bD(u,e)+t.bD(p,i)<t.bD(d,e)+t.bD(f,i)?(x=u,y=p):(x=d,y=f);}else if(v)x=u,y=p;else {if(!b)return;x=d,y=f;}const w=x/Math.PI*180,T=y/Math.PI*180,P=this.center.lat;this.setCenter(new t.S(w,t.ah(T,-90,90))),this.setZoom(this.zoom+si(P,this.center.lat));}locationToScreenPoint(e,i){const o=ii(e);if(i){const r=i.getElevationForLngLatZoom(e,this._helper._tileZoom);t.aR(o,o,1+r/t.bu);}return this._projectSurfacePointToScreen(o)}_projectSurfacePointToScreen(e){const i=t.bv();return t.aw(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],new t.P((.5*i[0]+.5)*this.width,(.5*-i[1]+.5)*this.height)}screenPointToMercatorCoordinate(e,i){if(i){const t=i.pointCoordinate(e);if(t)return t}return t.a1.fromLngLat(this.unprojectScreenPoint(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(e,t){const i=this._cameraPosition,o=this.getRayDirectionFromPixel(e);return !!this.rayPlanetIntersection(i,o)}getRayDirectionFromPixel(e){const i=t.bv();i[0]=e.x/this.width*2-1,i[1]=-1*(e.y/this.height*2-1),i[2]=1,i[3]=1,t.aw(i,i,this._globeViewProjMatrixNoCorrectionInverted),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3];const o=t.bp();o[0]=i[0]-this._cameraPosition[0],o[1]=i[1]-this._cameraPosition[1],o[2]=i[2]-this._cameraPosition[2];const r=t.bp();return t.aV(r,o),r}isSurfacePointVisible(e){const t=this._cachedClippingPlane;return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0}isSurfacePointOnScreen(e){if(!this.isSurfacePointVisible(e))return !1;const i=t.bv();return t.aw(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3],i[0]>-1&&i[0]<1&&i[1]>-1&&i[1]<1&&i[2]>-1&&i[2]<1}rayPlanetIntersection(e,i){const o=t.aX(e,i),r=t.bp(),a=t.bp();t.aR(a,i,o),t.aU(r,e,a);const s=1-t.aX(r,r);if(s<0)return null;const n=t.aX(e,e)-1,l=-o+(o<0?1:-1)*Math.sqrt(s),c=n/l,h=l;return {tMin:Math.min(c,h),tMax:Math.max(c,h)}}unprojectScreenPoint(e){const i=this._cameraPosition,o=this.getRayDirectionFromPixel(e),r=this.rayPlanetIntersection(i,o);if(r){const e=t.bp();t.aS(e,i,[o[0]*r.tMin,o[1]*r.tMin,o[2]*r.tMin]);const a=t.bp();return t.aV(a,e),ri(a)}const a=this._cachedClippingPlane,s=a[0]*o[0]+a[1]*o[1]+a[2]*o[2],n=-t.b1(a,i)/s,l=t.bp();if(n>0)t.aS(l,i,[o[0]*n,o[1]*n,o[2]*n]);else {const e=t.bp();t.aS(e,i,[2*o[0],2*o[1],2*o[2]]);const r=t.b1(this._cachedClippingPlane,e);t.aU(l,e,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r]);}const c=function(e){const i=t.bp();return i[0]=e[0]*-e[3],i[1]=e[1]*-e[3],i[2]=e[2]*-e[3],{center:i,radius:Math.sqrt(1-e[3]*e[3])}}(a);return ri(function(e,i,o){const r=t.bp();t.aU(r,o,e);const a=t.bp();return t.bq(a,e,r,i/t.a$(r)),a}(c.center,c.radius,l))}getMatrixForModel(e,i){const o=t.S.convert(e),r=1/t.bu,a=t.b9();return t.bz(a,a,o.lng/180*Math.PI),t.b7(a,a,-o.lat/180*Math.PI),t.M(a,a,[0,0,1+i/t.bu]),t.b7(a,a,.5*Math.PI),t.N(a,a,[r,r,r]),a}getProjectionDataForCustomLayer(e=!0){const i=this.getProjectionData({overscaledTileID:new t.Z(0,0,0,0,0),applyGlobeMatrix:e});return i.tileMercatorCoords=[0,0,1,1],i}getFastPathSimpleProjectionMatrix(e){}}class gi{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(e,t){this._globeness=e,this._globeLatitudeErrorCorrectionRadians=t,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame();}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this._helper=new Rt({calcMatrices:()=>{this._calcMatrices();},getConstrained:(e,t)=>this.getConstrained(e,t)}),this._globeness=1,this._mercatorTransform=new Lt,this._verticalPerspectiveTransform=new fi;}clone(){const e=new gi;return e._globeness=this._globeness,e._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,e.apply(this),e}apply(e){this._helper.apply(e),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians);}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(e){const t=this._mercatorTransform.getProjectionData(e),i=this._verticalPerspectiveTransform.getProjectionData(e);return {mainMatrix:this.isGlobeRendering?i.mainMatrix:t.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:e.applyGlobeMatrix?this._globeness:0,fallbackMatrix:t.fallbackMatrix}}isLocationOccluded(e){return this.currentTransform.isLocationOccluded(e)}transformLightDirection(e){return this.currentTransform.transformLightDirection(e)}getPixelScale(){return t.bk(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return t.bk(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(e,i,o){const r=this._mercatorTransform.getPitchedTextCorrection(e,i,o),a=this._verticalPerspectiveTransform.getPitchedTextCorrection(e,i,o);return t.bk(r,a,this._globeness)}projectTileCoordinates(e,t,i,o){return this.currentTransform.projectTileCoordinates(e,t,i,o)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ);}calculateFogMatrix(e){return this.currentTransform.calculateFogMatrix(e)}getVisibleUnwrappedCoordinates(e){return this.currentTransform.getVisibleUnwrappedCoordinates(e)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(e){this._mercatorTransform.recalculateZoomAndCenter(e),this._verticalPerspectiveTransform.recalculateZoomAndCenter(e);}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,t){return this.currentTransform.lngLatToCameraDepth(e,t)}populateCache(e){this._mercatorTransform.populateCache(e),this._verticalPerspectiveTransform.populateCache(e);}getBounds(){return this.currentTransform.getBounds()}getConstrained(e,t){return this.currentTransform.getConstrained(e,t)}calculateCenterFromCameraLngLatAlt(e,t,i,o){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,o)}setLocationAtPoint(e,t){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(e,t),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(e,t),this.apply(this._verticalPerspectiveTransform);}locationToScreenPoint(e,t){return this.currentTransform.locationToScreenPoint(e,t)}screenPointToMercatorCoordinate(e,t){return this.currentTransform.screenPointToMercatorCoordinate(e,t)}screenPointToLocation(e,t){return this.currentTransform.screenPointToLocation(e,t)}isPointOnMapSurface(e,t){return this.currentTransform.isPointOnMapSurface(e,t)}getRayDirectionFromPixel(e){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(e)}getMatrixForModel(e,t){return this.currentTransform.getMatrixForModel(e,t)}getProjectionDataForCustomLayer(e=!0){const t=this._mercatorTransform.getProjectionDataForCustomLayer(e);if(!this.isGlobeRendering)return t;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(e);return i.fallbackMatrix=t.mainMatrix,i}getFastPathSimpleProjectionMatrix(e){return this.currentTransform.getFastPathSimpleProjectionMatrix(e)}}class vi{get useGlobeControls(){return !0}handlePanInertia(e,i){const o=ni(e,i);return Math.abs(o.lng-i.center.lng)>180&&(o.lng=i.center.lng+179.5*Math.sign(o.lng-i.center.lng)),{easingCenter:o,easingOffset:new t.P(0,0)}}handleMapControlsRollPitchBearingZoom(e,i){const o=e.around,r=i.screenPointToLocation(o);e.bearingDelta&&i.setBearing(i.bearing+e.bearingDelta),e.pitchDelta&&i.setPitch(i.pitch+e.pitchDelta),e.rollDelta&&i.setRoll(i.roll+e.rollDelta);const a=i.zoom;e.zoomDelta&&i.setZoom(i.zoom+e.zoomDelta);const s=i.zoom-a;if(0===s)return;const n=t.bA(i.center.lng,r.lng),l=n/(Math.abs(n/180)+1),c=t.bA(i.center.lat,r.lat),h=i.getRayDirectionFromPixel(o),u=i.cameraPosition,d=-1*t.aX(u,h),_=t.bp();t.aS(_,u,[h[0]*d,h[1]*d,h[2]*d]);const p=t.aZ(_)-1,m=Math.exp(.5*-Math.max(p-.3,0)),f=oi(i.worldSize,i.center.lat)/Math.min(i.width,i.height),g=t.bn(f,.9,.5,1,.25),v=(1-t.af(-s))*Math.min(m,g),b=i.center.lat,x=i.zoom,y=new t.S(i.center.lng+l*v,t.ah(i.center.lat+c*v,-t.ai,t.ai));i.setLocationAtPoint(r,o);const w=i.center,T=t.bn(Math.abs(n),45,85,0,1),P=t.bn(f,.75,.35,0,1),C=Math.pow(Math.max(T,P),.25),I=t.bA(w.lng,y.lng),M=t.bA(w.lat,y.lat);i.setCenter(new t.S(w.lng+I*C,w.lat+M*C).wrap()),i.setZoom(x+si(b,i.center.lat));}handleMapControlsPan(e,t,i){if(!e.panDelta)return;const o=t.center.lat,r=t.zoom;t.setCenter(ni(e.panDelta,t).wrap()),t.setZoom(r+si(o,t.center.lat));}cameraForBoxAndBearing(e,i,o,r,a){const s=Bt(e,i,o,r,a),n=i.left/a.width*2-1,l=(a.width-i.right)/a.width*2-1,c=i.top/a.height*-2+1,h=(a.height-i.bottom)/a.height*-2+1,u=t.bA(o.getWest(),o.getEast())<0,d=u?o.getEast():o.getWest(),_=u?o.getWest():o.getEast(),p=Math.max(o.getNorth(),o.getSouth()),m=Math.min(o.getNorth(),o.getSouth()),f=d+.5*t.bA(d,_),g=p+.5*t.bA(p,m),v=a.clone();v.setCenter(s.center),v.setBearing(s.bearing),v.setPitch(0),v.setRoll(0),v.setZoom(s.zoom);const b=v.modelViewProjectionMatrix,x=[ii(o.getNorthWest()),ii(o.getNorthEast()),ii(o.getSouthWest()),ii(o.getSouthEast()),ii(new t.S(_,g)),ii(new t.S(d,g)),ii(new t.S(f,p)),ii(new t.S(f,m))],y=ii(s.center);let w=Number.POSITIVE_INFINITY;for(const e of x)n<0&&(w=vi.getLesserNonNegativeNonNull(w,vi.solveVectorScale(e,y,b,"x",n))),l>0&&(w=vi.getLesserNonNegativeNonNull(w,vi.solveVectorScale(e,y,b,"x",l))),c>0&&(w=vi.getLesserNonNegativeNonNull(w,vi.solveVectorScale(e,y,b,"y",c))),h<0&&(w=vi.getLesserNonNegativeNonNull(w,vi.solveVectorScale(e,y,b,"y",h)));if(Number.isFinite(w)&&0!==w)return s.zoom=v.zoom+t.ak(w),s;kt();}handleJumpToCenterZoom(e,i){const o=e.center.lat,r=e.getConstrained(i.center?t.S.convert(i.center):e.center,e.zoom).center;e.setCenter(r.wrap());const a=void 0!==i.zoom?+i.zoom:e.zoom+si(o,r.lat);e.zoom!==a&&e.setZoom(a);}handleEaseTo(e,i){const o=e.zoom,r=e.center,a=e.padding,s={roll:e.roll,pitch:e.pitch,bearing:e.bearing},n={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},l=void 0!==i.zoom,c=!e.isPaddingEqual(i.padding);let h=!1;const u=i.center?t.S.convert(i.center):r,d=e.getConstrained(u,o).center;St(e,d);const _=e.clone();_.setCenter(d),_.setZoom(l?+i.zoom:o+si(r.lat,u.lat)),_.setBearing(i.bearing);const p=new t.P(t.ah(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.ah(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));_.setLocationAtPoint(d,p);const m=(i.offset&&i.offsetAsPoint.mag())>0?_.center:d,f=l?+i.zoom:o+si(r.lat,m.lat),g=o+si(r.lat,0),v=f+si(m.lat,0),b=t.bA(r.lng,m.lng),x=t.bA(r.lat,m.lat),y=t.af(v-g);return h=f!==o,{easeFunc:o=>{if(t.be(s,n)||Ft({startEulerAngles:s,endEulerAngles:n,tr:e,k:o,useSlerp:s.roll!=n.roll}),c&&e.interpolatePadding(a,i.padding,o),i.around)t.w("Easing around a point is not supported under globe projection."),e.setLocationAtPoint(i.around,i.aroundPoint);else {const t=v>g?Math.min(2,y):Math.max(.5,y),i=Math.pow(t,1-o),a=ci(r,b,x,o*i);e.setCenter(a.wrap());}if(h){const i=t.C.number(g,v,o)+si(0,e.center.lat);e.setZoom(i);}},isZooming:h,elevationCenter:m}}handleFlyTo(e,i){const o=void 0!==i.zoom,r=e.center,a=e.zoom,s=e.padding,n=!e.isPaddingEqual(i.padding),l=e.getConstrained(t.S.convert(i.center||i.locationAtOffset),a).center,c=o?+i.zoom:e.zoom+si(e.center.lat,l.lat),h=e.clone();h.setCenter(l),h.setZoom(c),h.setBearing(i.bearing);const u=new t.P(t.ah(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.ah(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));h.setLocationAtPoint(l,u);const d=h.center;St(e,d);const _=function(e,i,o){const r=ii(i),a=ii(o),s=t.aX(r,a),n=Math.acos(s),l=ei(e);return n/(2*Math.PI)*l}(e,r,d),p=a+si(r.lat,0),m=c+si(d.lat,0),f=t.af(m-p);let g;if("number"==typeof i.minZoom){const o=+i.minZoom+si(d.lat,0),r=Math.min(o,p,m)+si(0,d.lat),a=e.getConstrained(d,r).zoom+si(d.lat,0);g=t.af(a-p);}const v=t.bA(r.lng,d.lng),b=t.bA(r.lat,d.lat);return {easeFunc:(o,a,l,h)=>{const u=ci(r,v,b,l);n&&e.interpolatePadding(s,i.padding,o);const _=1===o?d:u;e.setCenter(_.wrap());const m=p+t.ak(a);e.setZoom(1===o?c:m+si(0,_.lat));},scaleOfZoom:f,targetCenter:d,scaleOfMinZoom:g,pixelPathLength:_}}static solveVectorScale(e,t,i,o,r){const a="x"===o?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],s=[i[3],i[7],i[11],i[15]],n=e[0]*a[0]+e[1]*a[1]+e[2]*a[2],l=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],c=t[0]*a[0]+t[1]*a[1]+t[2]*a[2],h=t[0]*s[0]+t[1]*s[1]+t[2]*s[2];return c+r*l===n+r*h||s[3]*(n-c)+a[3]*(h-l)+n*h==c*l?null:(c+a[3]-r*h-r*s[3])/(c-n-r*h+r*l)}static getLesserNonNegativeNonNull(e,t){return null!==t&&t>=0&&t<e?t:e}}class bi{constructor(e){this._globe=e,this._mercatorCameraHelper=new Ot,this._verticalPerspectiveCameraHelper=new vi;}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(e,t){return this.currentHelper.handlePanInertia(e,t)}handleMapControlsRollPitchBearingZoom(e,t){return this.currentHelper.handleMapControlsRollPitchBearingZoom(e,t)}handleMapControlsPan(e,t,i){this.currentHelper.handleMapControlsPan(e,t,i);}cameraForBoxAndBearing(e,t,i,o,r){return this.currentHelper.cameraForBoxAndBearing(e,t,i,o,r)}handleJumpToCenterZoom(e,t){this.currentHelper.handleJumpToCenterZoom(e,t);}handleEaseTo(e,t){return this.currentHelper.handleEaseTo(e,t)}handleFlyTo(e,t){return this.currentHelper.handleFlyTo(e,t)}}const xi=(e,i)=>t.y(e,i&&i.filter((e=>"source.canvas"!==e.identifier))),yi=t.bE();class wi extends t.E{constructor(e,i={}){var o,r;super(),this._rtlPluginLoaded=()=>{for(const e in this.sourceCaches){const t=this.sourceCaches[e].getSource().type;"vector"!==t&&"geojson"!==t||this.sourceCaches[e].reload();}},this.map=e,this.dispatcher=new F(k(),e._getMapId()),this.dispatcher.registerMessageHandler("GG",((e,t)=>this.getGlyphs(e,t))),this.dispatcher.registerMessageHandler("GI",((e,t)=>this.getImages(e,t))),this.imageManager=new b,this.imageManager.setEventedParent(this);const a=(null===(o=e._container)||void 0===o?void 0:o.lang)||"undefined"!=typeof document&&(null===(r=document.documentElement)||void 0===r?void 0:r.lang)||void 0;this.glyphManager=new T(e._requestManager,i.localIdeographFontFamily,a),this.lineAtlas=new E(256,512),this.crossTileSymbolIndex=new vt,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new t.bF,this._loaded=!1,this._availableImages=[],this._globalState={},this._resetUpdates(),this.dispatcher.broadcast("SR",t.bG()),oe().on(ee,this._rtlPluginLoaded),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.sourceCaches[e.sourceId];if(!t)return;const i=t.getSource();if(i&&i.vectorLayerIds)for(const e in this._layers){const t=this._layers[e];t.source===i.id&&this._validateLayer(t);}}));}setGlobalStateProperty(e,i){var o,r,a;this._checkLoaded();const s=null===i?null!==(a=null===(r=null===(o=this.stylesheet.state)||void 0===o?void 0:o[e])||void 0===r?void 0:r.default)&&void 0!==a?a:null:i;if(t.bH(s,this._globalState[e]))return this;this._globalState[e]=s,this._applyGlobalStateChanges([e]);}getGlobalState(){return this._globalState}setGlobalState(e){this._checkLoaded();const i=[];for(const o in e)!t.bH(this._globalState[o],e[o].default)&&(i.push(o),this._globalState[o]=e[o].default);this._applyGlobalStateChanges(i);}_applyGlobalStateChanges(e){if(0===e.length)return;const t=new Set;for(const i in this._layers){const o=this._layers[i],r=o.getLayoutAffectingGlobalStateRefs(),a=o.getPaintAffectingGlobalStateRefs();for(const i of e)if(r.has(i)&&t.add(o.source),a.has(i))for(const{name:e,value:t}of a.get(i))this._updatePaintProperty(o,e,t);}for(const e in this.sourceCaches)t.has(e)&&(this._reloadSource(e),this._changed=!0);}loadURL(e,i={},o){this.fire(new t.l("dataloading",{dataType:"style"})),i.validate="boolean"!=typeof i.validate||i.validate;const r=this.map._requestManager.transformRequest(e,"Style");this._loadStyleRequest=new AbortController;const a=this._loadStyleRequest;t.j(r,this._loadStyleRequest).then((e=>{this._loadStyleRequest=null,this._load(e.data,i,o);})).catch((e=>{this._loadStyleRequest=null,e&&!a.signal.aborted&&this.fire(new t.k(e));}));}loadJSON(e,i={},o){this.fire(new t.l("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,s.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,i.validate=!1!==i.validate,this._load(e,i,o);})).catch((()=>{}));}loadEmpty(){this.fire(new t.l("dataloading",{dataType:"style"})),this._load(yi,{validate:!1});}_load(e,i,o){var r,a;let s=i.transformStyle?i.transformStyle(o,e):e;if(!i.validate||!xi(this,t.z(s))){s=Object.assign({},s),this._loaded=!0,this.stylesheet=s;for(const e in s.sources)this.addSource(e,s.sources[e],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new I(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new S(this.stylesheet.sky),this.map.setTerrain(null!==(a=this.stylesheet.terrain)&&void 0!==a?a:null),this.fire(new t.l("data",{dataType:"style"})),this.fire(new t.l("style.load"));}}_createLayers(){var e;const i=t.bI(this.stylesheet.layers);this.dispatcher.broadcast("SL",i),this._order=i.map((e=>e.id)),this._layers={},this.setGlobalState(null!==(e=this.stylesheet.state)&&void 0!==e?e:null),this._serializedLayers=null;for(const e of i){const i=t.bJ(e);i.setEventedParent(this,{layer:{id:e.id}}),i.setGlobalState(this._globalState),this._layers[e.id]=i;}}_loadSprite(e,i=!1,o=void 0){let r;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(e,i,o,r){return t._(this,void 0,void 0,(function*(){const a=f(e),n=o>1?"@2x":"",l={},c={};for(const{id:e,url:o}of a){const a=i.transformRequest(g(o,n,".json"),"SpriteJSON");l[e]=t.j(a,r);const s=i.transformRequest(g(o,n,".png"),"SpriteImage");c[e]=p.getImage(s,r);}return yield Promise.all([...Object.values(l),...Object.values(c)]),function(e,i){return t._(this,void 0,void 0,(function*(){const t={};for(const o in e){t[o]={};const r=s.getImageCanvasContext((yield i[o]).data),a=(yield e[o]).data;for(const e in a){const{width:i,height:s,x:n,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m}=a[e];t[o][e]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m,spriteData:{width:i,height:s,x:n,y:l,context:r}};}}return t}))}(l,c)}))}(e,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((e=>{if(this._spriteRequest=null,e)for(const t in e){this._spritesImagesIds[t]=[];const o=this._spritesImagesIds[t]?this._spritesImagesIds[t].filter((t=>!(t in e))):[];for(const e of o)this.imageManager.removeImage(e),this._changedImages[e]=!0;for(const o in e[t]){const r="default"===t?o:`${t}:${o}`;this._spritesImagesIds[t].push(r),r in this.imageManager.images?this.imageManager.updateImage(r,e[t][o],!1):this.imageManager.addImage(r,e[t][o]),i&&(this._changedImages[r]=!0);}}})).catch((e=>{this._spriteRequest=null,r=e,this.fire(new t.k(r));})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),i&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"})),o&&o(r);}));}_unloadSprite(){for(const e of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(e),this._changedImages[e]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}_validateLayer(e){const i=this.sourceCaches[e.source];if(!i)return;const o=e.sourceLayer;if(!o)return;const r=i.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(o))&&this.fire(new t.k(new Error(`Source layer "${o}" does not exist on source "${r.id}" as specified by style layer "${e.id}".`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this.sourceCaches)if(!this.sourceCaches[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeByIds(e,i=!1){const o=this._serializedAllLayers();if(!e||0===e.length)return Object.values(i?t.bK(o):o);const r=[];for(const a of e)if(o[a]){const e=i?t.bK(o[a]):o[a];r.push(e);}return r}_serializedAllLayers(){let e=this._serializedLayers;if(e)return e;e=this._serializedLayers={};const t=Object.keys(this._layers);for(const i of t){const t=this._layers[i];"custom"!==t.type&&(e[i]=t.serialize());}return e}hasTransitions(){var e,t,i;if(null===(e=this.light)||void 0===e?void 0:e.hasTransition())return !0;if(null===(t=this.sky)||void 0===t?void 0:t.hasTransition())return !0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return !0;for(const e in this.sourceCaches)if(this.sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(e){if(!this._loaded)return;const i=this._changed;if(i){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const e in this._updatedSources){const t=this._updatedSources[e];if("reload"===t)this._reloadSource(e);else {if("clear"!==t)throw new Error(`Invalid action ${t}`);this._clearSource(e);}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this.sky.updateTransitions(e),this._resetUpdates();}const o={};for(const e in this.sourceCaches){const t=this.sourceCaches[e];o[e]=t.used,t.used=!1;}for(const t of this._order){const i=this._layers[t];i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0);}for(const e in o){const i=this.sourceCaches[e];!!o[e]!=!!i.used&&i.fire(new t.l("data",{sourceDataType:"visibility",dataType:"source",sourceId:e}));}this.light.recalculate(e),this.sky.recalculate(e),this.projection.recalculate(e),this.z=e.zoom,i&&this.fire(new t.l("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1;}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(e,!1),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1;}setState(e,i={}){var o;this._checkLoaded();const r=this.serialize();if(e=i.transformStyle?i.transformStyle(r,e):e,(null===(o=i.validate)||void 0===o||o)&&xi(this,t.z(e)))return !1;(e=t.bK(e)).layers=t.bI(e.layers);const a=t.bL(r,e),s=this._getOperationsToPerform(a);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return !1;for(const e of s.operations)e();return this.stylesheet=e,this._serializedLayers=null,!0}_getOperationsToPerform(e){const t=[],i=[];for(const o of e)switch(o.command){case "setCenter":case "setZoom":case "setBearing":case "setPitch":case "setRoll":continue;case "addLayer":t.push((()=>this.addLayer.apply(this,o.args)));break;case "removeLayer":t.push((()=>this.removeLayer.apply(this,o.args)));break;case "setPaintProperty":t.push((()=>this.setPaintProperty.apply(this,o.args)));break;case "setLayoutProperty":t.push((()=>this.setLayoutProperty.apply(this,o.args)));break;case "setFilter":t.push((()=>this.setFilter.apply(this,o.args)));break;case "addSource":t.push((()=>this.addSource.apply(this,o.args)));break;case "removeSource":t.push((()=>this.removeSource.apply(this,o.args)));break;case "setLayerZoomRange":t.push((()=>this.setLayerZoomRange.apply(this,o.args)));break;case "setLight":t.push((()=>this.setLight.apply(this,o.args)));break;case "setGeoJSONSourceData":t.push((()=>this.setGeoJSONSourceData.apply(this,o.args)));break;case "setGlyphs":t.push((()=>this.setGlyphs.apply(this,o.args)));break;case "setSprite":t.push((()=>this.setSprite.apply(this,o.args)));break;case "setTerrain":t.push((()=>this.map.setTerrain.apply(this,o.args)));break;case "setSky":t.push((()=>this.setSky.apply(this,o.args)));break;case "setProjection":this.setProjection.apply(this,o.args);break;case "setGlobalState":t.push((()=>this.setGlobalState.apply(this,o.args)));break;case "setTransition":t.push((()=>{}));break;default:i.push(o.command);}return {operations:t,unimplemented:i}}addImage(e,i){if(this.getImage(e))return this.fire(new t.k(new Error(`An image named "${e}" already exists.`)));this.imageManager.addImage(e,i),this._afterImageUpdated(e);}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(e){if(!this.getImage(e))return this.fire(new t.k(new Error(`An image named "${e}" does not exist.`)));this.imageManager.removeImage(e),this._afterImageUpdated(e);}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,i,o={}){if(this._checkLoaded(),void 0!==this.sourceCaches[e])throw new Error(`Source "${e}" already exists.`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(t.z.source,`sources.${e}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=this.sourceCaches[e]=new xe(e,i,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:e}))),r.onAdd(this.map),this._changed=!0;}removeSource(e){if(this._checkLoaded(),void 0===this.sourceCaches[e])throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===e)return this.fire(new t.k(new Error(`Source "${e}" cannot be removed while layer "${i}" is using it.`)));const i=this.sourceCaches[e];delete this.sourceCaches[e],delete this._updatedSources[e],i.fire(new t.l("data",{sourceDataType:"metadata",dataType:"source",sourceId:e})),i.setEventedParent(null),i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(e,t){if(this._checkLoaded(),void 0===this.sourceCaches[e])throw new Error(`There is no source with this ID=${e}`);const i=this.sourceCaches[e].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(t),this._changed=!0;}getSource(e){return this.sourceCaches[e]&&this.sourceCaches[e].getSource()}addLayer(e,i,o={}){this._checkLoaded();const r=e.id;if(this.getLayer(r))return void this.fire(new t.k(new Error(`Layer "${r}" already exists on this map.`)));let a;if("custom"===e.type){if(xi(this,t.bM(e)))return;a=t.bJ(e);}else {if("source"in e&&"object"==typeof e.source&&(this.addSource(r,e.source),e=t.bK(e),e=t.e(e,{source:r})),this._validate(t.z.layer,`layers.${r}`,e,{arrayIndex:-1},o))return;a=t.bJ(e),this._validateLayer(a),a.setEventedParent(this,{layer:{id:r}});}const s=i?this._order.indexOf(i):this._order.length;if(i&&-1===s)this.fire(new t.k(new Error(`Cannot add layer "${r}" before non-existing layer "${i}".`)));else {if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=a,this._removedLayers[r]&&a.source&&"custom"!==a.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==a.type?this._updatedSources[a.source]="clear":(this._updatedSources[a.source]="reload",this.sourceCaches[a.source].pause());}this._updateLayer(a),a.onAdd&&a.onAdd(this.map);}}moveLayer(e,i){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new t.k(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===i)return;const o=this._order.indexOf(e);this._order.splice(o,1);const r=i?this._order.indexOf(i):this._order.length;i&&-1===r?this.fire(new t.k(new Error(`Cannot move layer "${e}" before non-existing layer "${i}".`))):(this._order.splice(r,0,e),this._layerOrderChanged=!0);}removeLayer(e){this._checkLoaded();const i=this._layers[e];if(!i)return void this.fire(new t.k(new Error(`Cannot remove non-existing layer "${e}".`)));i.setEventedParent(null);const o=this._order.indexOf(e);this._order.splice(o,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=i,delete this._layers[e],this._serializedLayers&&delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],i.onRemove&&i.onRemove(this.map);}getLayer(e){return this._layers[e]}getLayersOrder(){return [...this._order]}hasLayer(e){return e in this._layers}setLayerZoomRange(e,i,o){this._checkLoaded();const r=this.getLayer(e);r?r.minzoom===i&&r.maxzoom===o||(null!=i&&(r.minzoom=i),null!=o&&(r.maxzoom=o),this._updateLayer(r)):this.fire(new t.k(new Error(`Cannot set the zoom range of non-existing layer "${e}".`)));}setFilter(e,i,o={}){this._checkLoaded();const r=this.getLayer(e);if(r){if(!t.bH(r.filter,i))return null==i?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(t.z.filter,`layers.${r.id}.filter`,i,null,o)||(r.setFilter(t.bK(i)),this._updateLayer(r)))}else this.fire(new t.k(new Error(`Cannot filter non-existing layer "${e}".`)));}getFilter(e){return t.bK(this.getLayer(e).filter)}setLayoutProperty(e,i,o,r={}){this._checkLoaded();const a=this.getLayer(e);a?t.bH(a.getLayoutProperty(i),o)||(a.setLayoutProperty(i,o,r),this._updateLayer(a)):this.fire(new t.k(new Error(`Cannot style non-existing layer "${e}".`)));}getLayoutProperty(e,i){const o=this.getLayer(e);if(o)return o.getLayoutProperty(i);this.fire(new t.k(new Error(`Cannot get style of non-existing layer "${e}".`)));}setPaintProperty(e,i,o,r={}){this._checkLoaded();const a=this.getLayer(e);a?t.bH(a.getPaintProperty(i),o)||this._updatePaintProperty(a,i,o,r):this.fire(new t.k(new Error(`Cannot style non-existing layer "${e}".`)));}_updatePaintProperty(e,t,i,o={}){e.setPaintProperty(t,i,o)&&this._updateLayer(e),this._changed=!0,this._updatedPaintProps[e.id]=!0,this._serializedLayers=null;}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(e,i){this._checkLoaded();const o=e.source,r=e.sourceLayer,a=this.sourceCaches[o];if(void 0===a)return void this.fire(new t.k(new Error(`The source '${o}' does not exist in the map's style.`)));const s=a.getSource().type;"geojson"===s&&r?this.fire(new t.k(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===e.id&&this.fire(new t.k(new Error("The feature id parameter must be provided."))),a.setFeatureState(r,e.id,i)):this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));}removeFeatureState(e,i){this._checkLoaded();const o=e.source,r=this.sourceCaches[o];if(void 0===r)return void this.fire(new t.k(new Error(`The source '${o}' does not exist in the map's style.`)));const a=r.getSource().type,s="vector"===a?e.sourceLayer:void 0;"vector"!==a||s?i&&"string"!=typeof e.id&&"number"!=typeof e.id?this.fire(new t.k(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,e.id,i):this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));}getFeatureState(e){this._checkLoaded();const i=e.source,o=e.sourceLayer,r=this.sourceCaches[i];if(void 0!==r)return "vector"!==r.getSource().type||o?(void 0===e.id&&this.fire(new t.k(new Error("The feature id parameter must be provided."))),r.getFeatureState(o,e.id)):void this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new t.k(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return t.e({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const e=t.bN(this.sourceCaches,(e=>e.serialize())),i=this._serializeByIds(this._order,!0),o=this.map.getTerrain()||void 0,r=this.stylesheet;return t.bO({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:e,layers:i,terrain:o},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0,e.source&&!this._updatedSources[e.source]&&"raster"!==this.sourceCaches[e.source].getSource().type&&(this._updatedSources[e.source]="reload",this.sourceCaches[e.source].pause()),this._serializedLayers=null,this._changed=!0;}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},o=[];for(let r=this._order.length-1;r>=0;r--){const a=this._order[r];if(t(a)){i[a]=r;for(const t of e){const e=t[a];if(e)for(const t of e)o.push(t);}}}o.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let a=this._order.length-1;a>=0;a--){const s=this._order[a];if(t(s))for(let e=o.length-1;e>=0;e--){const t=o[e].feature;if(i[t.layer.id]<a)break;r.push(t),o.pop();}else for(const t of e){const e=t[s];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(e,i,o){i&&i.filter&&this._validate(t.z.filter,"queryRenderedFeatures.filter",i.filter,null,i);const r={};if(i&&i.layers){if(!(Array.isArray(i.layers)||i.layers instanceof Set))return this.fire(new t.k(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const e of i.layers){const i=this._layers[e];if(!i)return this.fire(new t.k(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const a=[];i.availableImages=this._availableImages;const s=this._serializedAllLayers(),n=i.layers instanceof Set?i.layers:Array.isArray(i.layers)?new Set(i.layers):null,l=Object.assign(Object.assign({},i),{layers:n});for(const t in this.sourceCaches)i.layers&&!r[t]||a.push(j(this.sourceCaches[t],this._layers,s,e,l,o,this.map.terrain?(e,t,i)=>this.map.terrain.getElevation(e,t,i):void 0));return this.placement&&a.push(function(e,t,i,o,r,a,s){const n={},l=a.queryRenderedSymbols(o),c=[];for(const e of Object.keys(l).map(Number))c.push(s[e]);c.sort(N);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,r.filter,r.layers,r.availableImages,e);for(const e in o){const t=n[e]=n[e]||[],r=o[e];r.sort(((e,t)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(e.featureIndex);return o.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of r)t.push(e);}}return function(e,t,i){for(const o in e)for(const r of e[o])U(r,i[t[o].source]);return e}(n,e,i)}(this._layers,s,this.sourceCaches,e,l,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(a)}querySourceFeatures(e,i){i&&i.filter&&this._validate(t.z.filter,"querySourceFeatures.filter",i.filter,null,i);const o=this.sourceCaches[e];return o?function(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],r={};for(let e=0;e<i.length;e++){const a=i[e],s=a.tileID.canonical.key;r[s]||(r[s]=!0,a.querySourceFeatures(o,t));}return o}(o,i):[]}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const o=this.light.getLight();let r=!1;for(const i in e)if(!t.bH(e[i],o[i])){r=!0;break}if(!r)return;const a={now:s.now(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,i),this.light.updateTransitions(a);}getProjection(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.projection}setProjection(e){if(this._checkLoaded(),this.projection){if(this.projection.name===e.type)return;this.projection.destroy(),delete this.projection;}this.stylesheet.projection=e,this._setProjectionInternal(e.type);}getSky(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.sky}setSky(e,i={}){this._checkLoaded();const o=this.getSky();let r=!1;if(!e&&!o)return;if(e&&!o)r=!0;else if(!e&&o)r=!0;else for(const i in e)if(!t.bH(e[i],o[i])){r=!0;break}if(!r)return;const a={now:s.now(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=e,this.sky.setSky(e,i),this.sky.updateTransitions(a);}_setProjectionInternal(e){const i=function(e){if(Array.isArray(e)){const t=new Jt({type:e});return {projection:t,transform:new gi,cameraHelper:new bi(t)}}switch(e){case "mercator":return {projection:new It,transform:new Lt,cameraHelper:new Ot};case "globe":{const e=new Jt({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return {projection:e,transform:new gi,cameraHelper:new bi(e)}}case "vertical-perspective":return {projection:new Yt,transform:new fi,cameraHelper:new vi};default:return t.w(`Unknown projection name: ${e}. Falling back to mercator projection.`),{projection:new It,transform:new Lt,cameraHelper:new Ot}}}(e);this.projection=i.projection,this.map.migrateProjection(i.transform,i.cameraHelper);for(const e in this.sourceCaches)this.sourceCaches[e].reload();}_validate(e,i,o,r,a={}){return (!a||!1!==a.validate)&&xi(this,e.call(t.z,t.e({key:i,style:this.serialize(),value:o,styleSpec:t.v},r)))}_remove(e=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),oe().off(ee,this._rtlPluginLoaded);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this.sourceCaches){const t=this.sourceCaches[e];t.setEventedParent(null),t.onRemove(this.map);}this.imageManager.setEventedParent(null),this.setEventedParent(null),e&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(e);}_clearSource(e){this.sourceCaches[e].clearTiles();}_reloadSource(e){this.sourceCaches[e].resume(),this.sourceCaches[e].reload();}_updateSources(e){for(const t in this.sourceCaches)this.sourceCaches[t].update(e,this.map.terrain);}_generateCollisionBoxes(){for(const e in this.sourceCaches)this._reloadSource(e);}_updatePlacement(e,t,i,o,r=!1){let a=!1,n=!1;const l={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!l[i.source]){const e=this.sourceCaches[i.source];l[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const o=this.crossTileSymbolIndex.addLayer(i,l[i.source],e.center.lng);a=a||o;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((r=r||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(s.now(),e.zoom))&&(this.pauseablePlacement=new _t(e,this.map.terrain,this._order,r,t,i,o,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(s.now()),n=!0),a&&this.pauseablePlacement.placement.setStale()),n||a)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,l[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(s.now())}_releaseSymbolFadeTiles(){for(const e in this.sourceCaches)this.sourceCaches[e].releaseSymbolFadeTiles();}getImages(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.imageManager.getImages(i.icons);this._updateTilesForChangedImages();const t=this.sourceCaches[i.source];return t&&t.setDependencies(i.tileID.key,i.type,i.icons),e}))}getGlyphs(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.glyphManager.getGlyphs(i.stacks),t=this.sourceCaches[i.source];return t&&t.setDependencies(i.tileID.key,i.type,[""]),e}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(e,i={}){this._checkLoaded(),e&&this._validate(t.z.glyphs,"glyphs",e,null,i)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=e,this.glyphManager.entries={},this.glyphManager.setURL(e));}addSprite(e,i,o={},r){this._checkLoaded();const a=[{id:e,url:i}],s=[...f(this.stylesheet.sprite),...a];this._validate(t.z.sprite,"sprite",s,null,o)||(this.stylesheet.sprite=s,this._loadSprite(a,!0,r));}removeSprite(e){this._checkLoaded();const i=f(this.stylesheet.sprite);if(i.find((t=>t.id===e))){if(this._spritesImagesIds[e])for(const t of this._spritesImagesIds[e])this.imageManager.removeImage(t),this._changedImages[t]=!0;i.splice(i.findIndex((t=>t.id===e)),1),this.stylesheet.sprite=i.length>0?i:void 0,delete this._spritesImagesIds[e],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}else this.fire(new t.k(new Error(`Sprite "${e}" doesn't exists on this map.`)));}getSprite(){return f(this.stylesheet.sprite)}setSprite(e,i={},o){this._checkLoaded(),e&&this._validate(t.z.sprite,"sprite",e,null,i)||(this.stylesheet.sprite=e,e?this._loadSprite(e,!0,o):(this._unloadSprite(),o&&o(null)));}}var Ti=t.aJ([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Pi{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(e,t,i,o,r,a,s,n,l){this.context=e;let c=this.boundPaintVertexBuffers.length!==o.length;for(let e=0;!c&&e<o.length;e++)this.boundPaintVertexBuffers[e]!==o[e]&&(c=!0);!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==r||this.boundVertexOffset!==a||this.boundDynamicVertexBuffer!==s||this.boundDynamicVertexBuffer2!==n||this.boundDynamicVertexBuffer3!==l?this.freshBind(t,i,o,r,a,s,n,l):(e.bindVertexArray.set(this.vao),s&&s.bind(),r&&r.dynamicDraw&&r.bind(),n&&n.bind(),l&&l.bind());}freshBind(e,t,i,o,r,a,s,n){const l=e.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=r,this.boundDynamicVertexBuffer=a,this.boundDynamicVertexBuffer2=s,this.boundDynamicVertexBuffer3=n,t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);a&&a.enableAttributes(h,e),s&&s.enableAttributes(h,e),n&&n.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,r);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,r);a&&(a.bind(),a.setVertexAttribPointers(h,e,r)),o&&o.bind(),s&&(s.bind(),s.setVertexAttribPointers(h,e,r)),n&&(n.bind(),n.setVertexAttribPointers(h,e,r)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null);}}const Ci=(e,i,o,r,a)=>({u_texture:0,u_ele_delta:e,u_fog_matrix:i,u_fog_color:o?o.properties.get("fog-color"):t.bf.white,u_fog_ground_blend:o?o.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:a?0:o?o.calculateFogBlendOpacity(r):0,u_horizon_color:o?o.properties.get("horizon-color"):t.bf.white,u_horizon_fog_blend:o?o.properties.get("horizon-fog-blend"):1,u_is_globe_mode:a?1:0}),Ii={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function Mi(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const o=e[i].split(" ");t.push(o.pop());}return t}class Si{constructor(e,i,o,r,a,s,n,l,c=[]){const h=e.gl;this.program=h.createProgram();const u=Mi(i.staticAttributes),d=o?o.getBinderAttributes():[],_=u.concat(d),p=xt.prelude.staticUniforms?Mi(xt.prelude.staticUniforms):[],m=n.staticUniforms?Mi(n.staticUniforms):[],f=i.staticUniforms?Mi(i.staticUniforms):[],g=o?o.getBinderUniforms():[],v=p.concat(m).concat(f).concat(g),b=[];for(const e of v)b.indexOf(e)<0&&b.push(e);const x=o?o.defines():[];qt(h)&&x.unshift("#version 300 es"),a&&x.push("#define OVERDRAW_INSPECTOR;"),s&&x.push("#define TERRAIN3D;"),l&&x.push(l),c&&x.push(...c);let y=x.concat(xt.prelude.fragmentSource,n.fragmentSource,i.fragmentSource).join("\n"),w=x.concat(xt.prelude.vertexSource,n.vertexSource,i.vertexSource).join("\n");qt(h)||(y=function(e){return e.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(y),w=function(e){return e.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(w));const T=h.createShader(h.FRAGMENT_SHADER);if(h.isContextLost())return void(this.failedToCreate=!0);if(h.shaderSource(T,y),h.compileShader(T),!h.getShaderParameter(T,h.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${h.getShaderInfoLog(T)}`);h.attachShader(this.program,T);const P=h.createShader(h.VERTEX_SHADER);if(h.isContextLost())return void(this.failedToCreate=!0);if(h.shaderSource(P,w),h.compileShader(P),!h.getShaderParameter(P,h.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${h.getShaderInfoLog(P)}`);h.attachShader(this.program,P),this.attributes={};const C={};this.numAttributes=_.length;for(let e=0;e<this.numAttributes;e++)_[e]&&(h.bindAttribLocation(this.program,e,_[e]),this.attributes[_[e]]=e);if(h.linkProgram(this.program),!h.getProgramParameter(this.program,h.LINK_STATUS))throw new Error(`Program failed to link: ${h.getProgramInfoLog(this.program)}`);h.deleteShader(P),h.deleteShader(T);for(let e=0;e<b.length;e++){const t=b[e];if(t&&!C[t]){const e=h.getUniformLocation(this.program,t);e&&(C[t]=e);}}this.fixedUniforms=r(e,C),this.terrainUniforms=((e,i)=>({u_depth:new t.bP(e,i.u_depth),u_terrain:new t.bP(e,i.u_terrain),u_terrain_dim:new t.bg(e,i.u_terrain_dim),u_terrain_matrix:new t.bR(e,i.u_terrain_matrix),u_terrain_unpack:new t.bS(e,i.u_terrain_unpack),u_terrain_exaggeration:new t.bg(e,i.u_terrain_exaggeration)}))(e,C),this.projectionUniforms=((e,i)=>({u_projection_matrix:new t.bR(e,i.u_projection_matrix),u_projection_tile_mercator_coords:new t.bS(e,i.u_projection_tile_mercator_coords),u_projection_clipping_plane:new t.bS(e,i.u_projection_clipping_plane),u_projection_transition:new t.bg(e,i.u_projection_transition),u_projection_fallback_matrix:new t.bR(e,i.u_projection_fallback_matrix)}))(e,C),this.binderUniforms=o?o.getUniforms(e,C):[];}draw(e,t,i,o,r,a,s,n,l,c,h,u,d,_,p,m,f,g,v){const b=e.gl;if(this.failedToCreate)return;if(e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(o),e.setColorMode(r),e.setCullFace(a),n){e.activeTexture.set(b.TEXTURE2),b.bindTexture(b.TEXTURE_2D,n.depthTexture),e.activeTexture.set(b.TEXTURE3),b.bindTexture(b.TEXTURE_2D,n.texture);for(const e in this.terrainUniforms)this.terrainUniforms[e].set(n[e]);}if(l)for(const e in l)this.projectionUniforms[Ii[e]].set(l[e]);if(s)for(const e in this.fixedUniforms)this.fixedUniforms[e].set(s[e]);m&&m.setUniforms(e,this.binderUniforms,_,{zoom:p});let x=0;switch(t){case b.LINES:x=2;break;case b.TRIANGLES:x=3;break;case b.LINE_STRIP:x=1;}for(const i of d.get()){const o=i.vaos||(i.vaos={});(o[c]||(o[c]=new Pi)).bind(e,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,f,g,v),b.drawElements(t,i.primitiveLength*x,b.UNSIGNED_SHORT,i.primitiveOffset*x*2);}}}function Ei(e,i,o){const r=1/t.aC(o,1,i.transform.tileZoom),a=Math.pow(2,o.tileID.overscaledZ),s=o.tileSize*Math.pow(2,i.transform.tileZoom)/a,n=s*(o.tileID.canonical.x+o.tileID.wrap*a),l=s*o.tileID.canonical.y;return {u_image:0,u_texsize:o.imageAtlasTexture.size,u_scale:[r,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[n>>16,l>>16],u_pixel_coord_lower:[65535&n,65535&l]}}const Ri=(e,i,o,r)=>{const a=e.style.light,s=a.properties.get("position"),n=[s.x,s.y,s.z],l=t.bV();"viewport"===a.properties.get("anchor")&&t.bW(l,e.transform.bearingInRadians),t.bX(n,n,l);const c=e.transform.transformLightDirection(n),h=a.properties.get("color");return {u_lightpos:n,u_lightpos_globe:c,u_lightintensity:a.properties.get("intensity"),u_lightcolor:[h.r,h.g,h.b],u_vertical_gradient:+i,u_opacity:o,u_fill_translate:r}},zi=(e,i,o,r,a,s,n)=>t.e(Ri(e,i,o,r),Ei(s,e,n),{u_height_factor:-Math.pow(2,a.overscaledZ)/n.tileSize/8}),Di=(e,i,o,r)=>t.e(Ei(i,e,o),{u_fill_translate:r}),Ai=(e,t)=>({u_world:e,u_fill_translate:t}),Li=(e,i,o,r,a)=>t.e(Di(e,i,o,a),{u_world:r}),ki=(e,i,o,r,a)=>{const s=e.transform;let n,l,c=0;if("map"===o.paint.get("circle-pitch-alignment")){const e=t.aC(i,1,s.zoom);n=!0,l=[e,e],c=e/(t.$*Math.pow(2,i.tileID.overscaledZ))*2*Math.PI*a;}else n=!1,l=s.pixelsToGLUnits;return {u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===o.paint.get("circle-pitch-scale")),u_pitch_with_map:+n,u_device_pixel_ratio:e.pixelRatio,u_extrude_scale:l,u_globe_extrude_scale:c,u_translate:r}},Fi=e=>({u_pixel_extrude_scale:[1/e.width,1/e.height]}),Bi=e=>({u_viewport_size:[e.width,e.height]}),Oi=(e,t=1)=>({u_color:e,u_overlay:0,u_overlay_scale:t}),ji=(e,i,o,r)=>{const a=t.aC(e,1,i)/(t.$*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*r;return {u_extrude_scale:t.aC(e,1,i),u_intensity:o,u_globe_extrude_scale:a}},Ni=(e,i,o,r)=>{const a=t.L();t.bY(a,0,e.width,e.height,0,0,1);const s=e.context.gl;return {u_matrix:a,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:o,u_color_ramp:r,u_opacity:i.paint.get("heatmap-opacity")}},Ui=(e,t,i)=>{const o=i.paint.get("hillshade-accent-color");let r;switch(i.paint.get("hillshade-method")){case "basic":r=4;break;case "combined":r=1;break;case "igor":r=2;break;case "multidirectional":r=3;break;default:r=0;}const a=i.getIlluminationProperties();for(let t=0;t<a.directionRadians.length;t++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(a.directionRadians[t]+=e.transform.bearingInRadians);return {u_image:0,u_latrange:Gi(0,t.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:a.altitudeRadians,u_azimuths:a.directionRadians,u_accent:o,u_method:r,u_highlights:a.highlightColor,u_shadows:a.shadowColor}},Zi=(e,i)=>{const o=i.stride,r=t.L();return t.bY(r,0,t.$,-t.$,0,0,1),t.M(r,r,[0,-t.$,0]),{u_matrix:r,u_image:1,u_dimension:[o,o],u_zoom:e.overscaledZ,u_unpack:i.getUnpackVector()}};function Gi(e,i){const o=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new t.a1(0,r/o).toLngLat().lat,new t.a1(0,(r+1)/o).toLngLat().lat]}const Vi=(e,t,i=0)=>({u_image:0,u_unpack:t.getUnpackVector(),u_dimension:[t.stride,t.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:e.paint.get("color-relief-opacity")}),$i=(e,i,o,r)=>{const a=e.transform;return {u_translation:Ki(e,i,o),u_ratio:r/t.aC(i,1,a.zoom),u_device_pixel_ratio:e.pixelRatio,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]]}},qi=(e,i,o,r,a)=>t.e($i(e,i,o,r),{u_image:0,u_image_height:a}),Wi=(e,i,o,r,a)=>{const s=e.transform,n=Xi(i,s);return {u_translation:Ki(e,i,o),u_texsize:i.imageAtlasTexture.size,u_ratio:r/t.aC(i,1,s.zoom),u_device_pixel_ratio:e.pixelRatio,u_image:0,u_scale:[n,a.fromScale,a.toScale],u_fade:a.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},Hi=(e,i,o,r,a,s)=>{const n=e.lineAtlas,l=Xi(i,e.transform),c="round"===o.layout.get("line-cap"),h=n.getDash(a.from,c),u=n.getDash(a.to,c),d=h.width*s.fromScale,_=u.width*s.toScale;return t.e($i(e,i,o,r),{u_patternscale_a:[l/d,-h.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:n.width/(256*Math.min(d,_)*e.pixelRatio)/2,u_image:0,u_tex_y_a:h.y,u_tex_y_b:u.y,u_mix:s.t})};function Xi(e,i){return 1/t.aC(e,1,i.tileZoom)}function Ki(e,i,o){return t.aD(e.transform,i,o.paint.get("line-translate"),o.paint.get("line-translate-anchor"))}const Yi=(e,t,i,o,r)=>{return {u_tl_parent:e,u_scale_parent:t,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*o.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:o.paint.get("raster-brightness-min"),u_brightness_high:o.paint.get("raster-brightness-max"),u_saturation_factor:(s=o.paint.get("raster-saturation"),s>0?1-1/(1.001-s):-s),u_contrast_factor:(a=o.paint.get("raster-contrast"),a>0?1/(1-a):1+a),u_spin_weights:Qi(o.paint.get("raster-hue-rotate")),u_coords_top:[r[0].x,r[0].y,r[1].x,r[1].y],u_coords_bottom:[r[3].x,r[3].y,r[2].x,r[2].y]};var a,s;};function Qi(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const Ji=(e,t,i,o,r,a,s,n,l,c,h,u,d)=>{const _=s.transform;return {u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:_.cameraToCenterDistance,u_pitch:_.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:_.width/_.height,u_fade_change:s.options.fadeDuration?s.symbolFadeChange:1,u_label_plane_matrix:n,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+o,u_is_along_line:r,u_is_variable_anchor:a,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:d}},eo=(e,i,o,r,a,s,n,l,c,h,u,d,_,p)=>{const m=n.transform;return t.e(Ji(e,i,o,r,a,s,n,l,c,h,u,d,p),{u_gamma_scale:r?Math.cos(m.pitch*Math.PI/180)*m.cameraToCenterDistance:1,u_device_pixel_ratio:n.pixelRatio,u_is_halo:1})},to=(e,i,o,r,a,s,n,l,c,h,u,d,_)=>t.e(eo(e,i,o,r,a,s,n,l,c,h,!0,u,0,_),{u_texsize_icon:d,u_texture_icon:1}),io=(e,t)=>({u_opacity:e,u_color:t}),oo=(e,i,o,r,a)=>t.e(function(e,i,o,r){const a=o.imageManager.getPattern(e.from.toString()),s=o.imageManager.getPattern(e.to.toString()),{width:n,height:l}=o.imageManager.getPixelSize(),c=Math.pow(2,r.tileID.overscaledZ),h=r.tileSize*Math.pow(2,o.transform.tileZoom)/c,u=h*(r.tileID.canonical.x+r.tileID.wrap*c),d=h*r.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:a.tl,u_pattern_br_a:a.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[n,l],u_mix:i.t,u_pattern_size_a:a.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:i.fromScale,u_scale_b:i.toScale,u_tile_units_to_pixels:1/t.aC(r,1,o.transform.tileZoom),u_pixel_coord_upper:[u>>16,d>>16],u_pixel_coord_lower:[65535&u,65535&d]}}(o,a,i,r),{u_opacity:e}),ro=(e,t)=>{},ao={fillExtrusion:(e,i)=>({u_lightpos:new t.bT(e,i.u_lightpos),u_lightpos_globe:new t.bT(e,i.u_lightpos_globe),u_lightintensity:new t.bg(e,i.u_lightintensity),u_lightcolor:new t.bT(e,i.u_lightcolor),u_vertical_gradient:new t.bg(e,i.u_vertical_gradient),u_opacity:new t.bg(e,i.u_opacity),u_fill_translate:new t.bU(e,i.u_fill_translate)}),fillExtrusionPattern:(e,i)=>({u_lightpos:new t.bT(e,i.u_lightpos),u_lightpos_globe:new t.bT(e,i.u_lightpos_globe),u_lightintensity:new t.bg(e,i.u_lightintensity),u_lightcolor:new t.bT(e,i.u_lightcolor),u_vertical_gradient:new t.bg(e,i.u_vertical_gradient),u_height_factor:new t.bg(e,i.u_height_factor),u_opacity:new t.bg(e,i.u_opacity),u_fill_translate:new t.bU(e,i.u_fill_translate),u_image:new t.bP(e,i.u_image),u_texsize:new t.bU(e,i.u_texsize),u_pixel_coord_upper:new t.bU(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bU(e,i.u_pixel_coord_lower),u_scale:new t.bT(e,i.u_scale),u_fade:new t.bg(e,i.u_fade)}),fill:(e,i)=>({u_fill_translate:new t.bU(e,i.u_fill_translate)}),fillPattern:(e,i)=>({u_image:new t.bP(e,i.u_image),u_texsize:new t.bU(e,i.u_texsize),u_pixel_coord_upper:new t.bU(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bU(e,i.u_pixel_coord_lower),u_scale:new t.bT(e,i.u_scale),u_fade:new t.bg(e,i.u_fade),u_fill_translate:new t.bU(e,i.u_fill_translate)}),fillOutline:(e,i)=>({u_world:new t.bU(e,i.u_world),u_fill_translate:new t.bU(e,i.u_fill_translate)}),fillOutlinePattern:(e,i)=>({u_world:new t.bU(e,i.u_world),u_image:new t.bP(e,i.u_image),u_texsize:new t.bU(e,i.u_texsize),u_pixel_coord_upper:new t.bU(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bU(e,i.u_pixel_coord_lower),u_scale:new t.bT(e,i.u_scale),u_fade:new t.bg(e,i.u_fade),u_fill_translate:new t.bU(e,i.u_fill_translate)}),circle:(e,i)=>({u_camera_to_center_distance:new t.bg(e,i.u_camera_to_center_distance),u_scale_with_map:new t.bP(e,i.u_scale_with_map),u_pitch_with_map:new t.bP(e,i.u_pitch_with_map),u_extrude_scale:new t.bU(e,i.u_extrude_scale),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_globe_extrude_scale:new t.bg(e,i.u_globe_extrude_scale),u_translate:new t.bU(e,i.u_translate)}),collisionBox:(e,i)=>({u_pixel_extrude_scale:new t.bU(e,i.u_pixel_extrude_scale)}),collisionCircle:(e,i)=>({u_viewport_size:new t.bU(e,i.u_viewport_size)}),debug:(e,i)=>({u_color:new t.bQ(e,i.u_color),u_overlay:new t.bP(e,i.u_overlay),u_overlay_scale:new t.bg(e,i.u_overlay_scale)}),depth:ro,clippingMask:ro,heatmap:(e,i)=>({u_extrude_scale:new t.bg(e,i.u_extrude_scale),u_intensity:new t.bg(e,i.u_intensity),u_globe_extrude_scale:new t.bg(e,i.u_globe_extrude_scale)}),heatmapTexture:(e,i)=>({u_matrix:new t.bR(e,i.u_matrix),u_world:new t.bU(e,i.u_world),u_image:new t.bP(e,i.u_image),u_color_ramp:new t.bP(e,i.u_color_ramp),u_opacity:new t.bg(e,i.u_opacity)}),hillshade:(e,i)=>({u_image:new t.bP(e,i.u_image),u_latrange:new t.bU(e,i.u_latrange),u_exaggeration:new t.bg(e,i.u_exaggeration),u_altitudes:new t.b_(e,i.u_altitudes),u_azimuths:new t.b_(e,i.u_azimuths),u_accent:new t.bQ(e,i.u_accent),u_method:new t.bP(e,i.u_method),u_shadows:new t.bZ(e,i.u_shadows),u_highlights:new t.bZ(e,i.u_highlights)}),hillshadePrepare:(e,i)=>({u_matrix:new t.bR(e,i.u_matrix),u_image:new t.bP(e,i.u_image),u_dimension:new t.bU(e,i.u_dimension),u_zoom:new t.bg(e,i.u_zoom),u_unpack:new t.bS(e,i.u_unpack)}),colorRelief:(e,i)=>({u_image:new t.bP(e,i.u_image),u_unpack:new t.bS(e,i.u_unpack),u_dimension:new t.bU(e,i.u_dimension),u_elevation_stops:new t.bP(e,i.u_elevation_stops),u_color_stops:new t.bP(e,i.u_color_stops),u_color_ramp_size:new t.bP(e,i.u_color_ramp_size),u_opacity:new t.bg(e,i.u_opacity)}),line:(e,i)=>({u_translation:new t.bU(e,i.u_translation),u_ratio:new t.bg(e,i.u_ratio),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.bU(e,i.u_units_to_pixels)}),lineGradient:(e,i)=>({u_translation:new t.bU(e,i.u_translation),u_ratio:new t.bg(e,i.u_ratio),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.bU(e,i.u_units_to_pixels),u_image:new t.bP(e,i.u_image),u_image_height:new t.bg(e,i.u_image_height)}),linePattern:(e,i)=>({u_translation:new t.bU(e,i.u_translation),u_texsize:new t.bU(e,i.u_texsize),u_ratio:new t.bg(e,i.u_ratio),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_image:new t.bP(e,i.u_image),u_units_to_pixels:new t.bU(e,i.u_units_to_pixels),u_scale:new t.bT(e,i.u_scale),u_fade:new t.bg(e,i.u_fade)}),lineSDF:(e,i)=>({u_translation:new t.bU(e,i.u_translation),u_ratio:new t.bg(e,i.u_ratio),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.bU(e,i.u_units_to_pixels),u_patternscale_a:new t.bU(e,i.u_patternscale_a),u_patternscale_b:new t.bU(e,i.u_patternscale_b),u_sdfgamma:new t.bg(e,i.u_sdfgamma),u_image:new t.bP(e,i.u_image),u_tex_y_a:new t.bg(e,i.u_tex_y_a),u_tex_y_b:new t.bg(e,i.u_tex_y_b),u_mix:new t.bg(e,i.u_mix)}),raster:(e,i)=>({u_tl_parent:new t.bU(e,i.u_tl_parent),u_scale_parent:new t.bg(e,i.u_scale_parent),u_buffer_scale:new t.bg(e,i.u_buffer_scale),u_fade_t:new t.bg(e,i.u_fade_t),u_opacity:new t.bg(e,i.u_opacity),u_image0:new t.bP(e,i.u_image0),u_image1:new t.bP(e,i.u_image1),u_brightness_low:new t.bg(e,i.u_brightness_low),u_brightness_high:new t.bg(e,i.u_brightness_high),u_saturation_factor:new t.bg(e,i.u_saturation_factor),u_contrast_factor:new t.bg(e,i.u_contrast_factor),u_spin_weights:new t.bT(e,i.u_spin_weights),u_coords_top:new t.bS(e,i.u_coords_top),u_coords_bottom:new t.bS(e,i.u_coords_bottom)}),symbolIcon:(e,i)=>({u_is_size_zoom_constant:new t.bP(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bP(e,i.u_is_size_feature_constant),u_size_t:new t.bg(e,i.u_size_t),u_size:new t.bg(e,i.u_size),u_camera_to_center_distance:new t.bg(e,i.u_camera_to_center_distance),u_pitch:new t.bg(e,i.u_pitch),u_rotate_symbol:new t.bP(e,i.u_rotate_symbol),u_aspect_ratio:new t.bg(e,i.u_aspect_ratio),u_fade_change:new t.bg(e,i.u_fade_change),u_label_plane_matrix:new t.bR(e,i.u_label_plane_matrix),u_coord_matrix:new t.bR(e,i.u_coord_matrix),u_is_text:new t.bP(e,i.u_is_text),u_pitch_with_map:new t.bP(e,i.u_pitch_with_map),u_is_along_line:new t.bP(e,i.u_is_along_line),u_is_variable_anchor:new t.bP(e,i.u_is_variable_anchor),u_texsize:new t.bU(e,i.u_texsize),u_texture:new t.bP(e,i.u_texture),u_translation:new t.bU(e,i.u_translation),u_pitched_scale:new t.bg(e,i.u_pitched_scale)}),symbolSDF:(e,i)=>({u_is_size_zoom_constant:new t.bP(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bP(e,i.u_is_size_feature_constant),u_size_t:new t.bg(e,i.u_size_t),u_size:new t.bg(e,i.u_size),u_camera_to_center_distance:new t.bg(e,i.u_camera_to_center_distance),u_pitch:new t.bg(e,i.u_pitch),u_rotate_symbol:new t.bP(e,i.u_rotate_symbol),u_aspect_ratio:new t.bg(e,i.u_aspect_ratio),u_fade_change:new t.bg(e,i.u_fade_change),u_label_plane_matrix:new t.bR(e,i.u_label_plane_matrix),u_coord_matrix:new t.bR(e,i.u_coord_matrix),u_is_text:new t.bP(e,i.u_is_text),u_pitch_with_map:new t.bP(e,i.u_pitch_with_map),u_is_along_line:new t.bP(e,i.u_is_along_line),u_is_variable_anchor:new t.bP(e,i.u_is_variable_anchor),u_texsize:new t.bU(e,i.u_texsize),u_texture:new t.bP(e,i.u_texture),u_gamma_scale:new t.bg(e,i.u_gamma_scale),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_is_halo:new t.bP(e,i.u_is_halo),u_translation:new t.bU(e,i.u_translation),u_pitched_scale:new t.bg(e,i.u_pitched_scale)}),symbolTextAndIcon:(e,i)=>({u_is_size_zoom_constant:new t.bP(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bP(e,i.u_is_size_feature_constant),u_size_t:new t.bg(e,i.u_size_t),u_size:new t.bg(e,i.u_size),u_camera_to_center_distance:new t.bg(e,i.u_camera_to_center_distance),u_pitch:new t.bg(e,i.u_pitch),u_rotate_symbol:new t.bP(e,i.u_rotate_symbol),u_aspect_ratio:new t.bg(e,i.u_aspect_ratio),u_fade_change:new t.bg(e,i.u_fade_change),u_label_plane_matrix:new t.bR(e,i.u_label_plane_matrix),u_coord_matrix:new t.bR(e,i.u_coord_matrix),u_is_text:new t.bP(e,i.u_is_text),u_pitch_with_map:new t.bP(e,i.u_pitch_with_map),u_is_along_line:new t.bP(e,i.u_is_along_line),u_is_variable_anchor:new t.bP(e,i.u_is_variable_anchor),u_texsize:new t.bU(e,i.u_texsize),u_texsize_icon:new t.bU(e,i.u_texsize_icon),u_texture:new t.bP(e,i.u_texture),u_texture_icon:new t.bP(e,i.u_texture_icon),u_gamma_scale:new t.bg(e,i.u_gamma_scale),u_device_pixel_ratio:new t.bg(e,i.u_device_pixel_ratio),u_is_halo:new t.bP(e,i.u_is_halo),u_translation:new t.bU(e,i.u_translation),u_pitched_scale:new t.bg(e,i.u_pitched_scale)}),background:(e,i)=>({u_opacity:new t.bg(e,i.u_opacity),u_color:new t.bQ(e,i.u_color)}),backgroundPattern:(e,i)=>({u_opacity:new t.bg(e,i.u_opacity),u_image:new t.bP(e,i.u_image),u_pattern_tl_a:new t.bU(e,i.u_pattern_tl_a),u_pattern_br_a:new t.bU(e,i.u_pattern_br_a),u_pattern_tl_b:new t.bU(e,i.u_pattern_tl_b),u_pattern_br_b:new t.bU(e,i.u_pattern_br_b),u_texsize:new t.bU(e,i.u_texsize),u_mix:new t.bg(e,i.u_mix),u_pattern_size_a:new t.bU(e,i.u_pattern_size_a),u_pattern_size_b:new t.bU(e,i.u_pattern_size_b),u_scale_a:new t.bg(e,i.u_scale_a),u_scale_b:new t.bg(e,i.u_scale_b),u_pixel_coord_upper:new t.bU(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bU(e,i.u_pixel_coord_lower),u_tile_units_to_pixels:new t.bg(e,i.u_tile_units_to_pixels)}),terrain:(e,i)=>({u_texture:new t.bP(e,i.u_texture),u_ele_delta:new t.bg(e,i.u_ele_delta),u_fog_matrix:new t.bR(e,i.u_fog_matrix),u_fog_color:new t.bQ(e,i.u_fog_color),u_fog_ground_blend:new t.bg(e,i.u_fog_ground_blend),u_fog_ground_blend_opacity:new t.bg(e,i.u_fog_ground_blend_opacity),u_horizon_color:new t.bQ(e,i.u_horizon_color),u_horizon_fog_blend:new t.bg(e,i.u_horizon_fog_blend),u_is_globe_mode:new t.bg(e,i.u_is_globe_mode)}),terrainDepth:(e,i)=>({u_ele_delta:new t.bg(e,i.u_ele_delta)}),terrainCoords:(e,i)=>({u_texture:new t.bP(e,i.u_texture),u_terrain_coords_id:new t.bg(e,i.u_terrain_coords_id),u_ele_delta:new t.bg(e,i.u_ele_delta)}),projectionErrorMeasurement:(e,i)=>({u_input:new t.bg(e,i.u_input),u_output_expected:new t.bg(e,i.u_output_expected)}),atmosphere:(e,i)=>({u_sun_pos:new t.bT(e,i.u_sun_pos),u_atmosphere_blend:new t.bg(e,i.u_atmosphere_blend),u_globe_position:new t.bT(e,i.u_globe_position),u_globe_radius:new t.bg(e,i.u_globe_radius),u_inv_proj_matrix:new t.bR(e,i.u_inv_proj_matrix)}),sky:(e,i)=>({u_sky_color:new t.bQ(e,i.u_sky_color),u_horizon_color:new t.bQ(e,i.u_horizon_color),u_horizon:new t.bU(e,i.u_horizon),u_horizon_normal:new t.bU(e,i.u_horizon_normal),u_sky_horizon_blend:new t.bg(e,i.u_sky_horizon_blend),u_sky_blend:new t.bg(e,i.u_sky_blend)})};class so{constructor(e,t,i){this.context=e;const o=e.gl;this.buffer=o.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),o.bufferData(o.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?o.DYNAMIC_DRAW:o.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const no={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class lo{constructor(e,t,i,o){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=o,this.context=e;const r=e.gl;this.buffer=r.createBuffer(),e.bindVertexBuffer.set(this.buffer),r.bufferData(r.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){if(e.length!==this.length)throw new Error(`Length of new data is ${e.length}, which doesn't match current length of ${this.length}`);const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const o=t.attributes[this.attributes[i].name];void 0!==o&&e.enableVertexAttribArray(o);}}setVertexAttribPointers(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=this.attributes[o],a=t.attributes[r.name];void 0!==a&&e.vertexAttribPointer(a,r.components,e[no[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class co{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class ho extends co{getDefault(){return t.bf.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class uo extends co{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class _o extends co{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class po extends co{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class mo extends co{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class fo extends co{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class go extends co{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class vo extends co{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class bo extends co{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class xo extends co{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class yo extends co{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class wo extends co{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class To extends co{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class Po extends co{getDefault(){const e=this.gl;return [e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1);}}class Co extends co{getDefault(){return t.bf.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class Io extends co{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1);}}class Mo extends co{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class So extends co{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class Eo extends co{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}class Ro extends co{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}}class zo extends co{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class Do extends co{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Ao extends co{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class Lo extends co{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class ko extends co{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class Fo extends co{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Bo extends co{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Oo extends co{getDefault(){return null}set(e){var t;if(e===this.current&&!this.dirty)return;const i=this.gl;qt(i)?i.bindVertexArray(e):null===(t=i.getExtension("OES_vertex_array_object"))||void 0===t||t.bindVertexArrayOES(e),this.current=e,this.dirty=!1;}}class jo extends co{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class No extends co{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class Uo extends co{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class Zo extends co{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class Go extends Zo{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class Vo extends Zo{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class $o extends Zo{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}const qo="Framebuffer is not complete";class Wo{constructor(e,t,i,o,r){this.context=e,this.width=t,this.height=i;const a=e.gl,s=this.framebuffer=a.createFramebuffer();if(this.colorAttachment=new Go(e,s),o)this.depthAttachment=r?new $o(e,s):new Vo(e,s);else if(r)throw new Error("Stencil cannot be set without depth");if(a.checkFramebufferStatus(a.FRAMEBUFFER)!==a.FRAMEBUFFER_COMPLETE)throw new Error(qo)}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}e.deleteFramebuffer(this.framebuffer);}}class Ho{constructor(e){var t,i;if(this.gl=e,this.clearColor=new ho(this),this.clearDepth=new uo(this),this.clearStencil=new _o(this),this.colorMask=new po(this),this.depthMask=new mo(this),this.stencilMask=new fo(this),this.stencilFunc=new go(this),this.stencilOp=new vo(this),this.stencilTest=new bo(this),this.depthRange=new xo(this),this.depthTest=new yo(this),this.depthFunc=new wo(this),this.blend=new To(this),this.blendFunc=new Po(this),this.blendColor=new Co(this),this.blendEquation=new Io(this),this.cullFace=new Mo(this),this.cullFaceSide=new So(this),this.frontFace=new Eo(this),this.program=new Ro(this),this.activeTexture=new zo(this),this.viewport=new Do(this),this.bindFramebuffer=new Ao(this),this.bindRenderbuffer=new Lo(this),this.bindTexture=new ko(this),this.bindVertexBuffer=new Fo(this),this.bindElementBuffer=new Bo(this),this.bindVertexArray=new Oo(this),this.pixelStoreUnpack=new jo(this),this.pixelStoreUnpackPremultiplyAlpha=new No(this),this.pixelStoreUnpackFlipY=new Uo(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),qt(e)){this.HALF_FLOAT=e.HALF_FLOAT;const o=e.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(t=e.RGBA16F)&&void 0!==t?t:null==o?void 0:o.RGBA16F_EXT,this.RGB16F=null!==(i=e.RGB16F)&&void 0!==i?i:null==o?void 0:o.RGB16F_EXT,e.getExtension("EXT_color_buffer_float");}else {e.getExtension("EXT_color_buffer_half_float"),e.getExtension("OES_texture_half_float_linear");const t=e.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==t?void 0:t.HALF_FLOAT_OES;}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t){return new so(this,e,t)}createVertexBuffer(e,t,i){return new lo(this,e,t,i)}createRenderbuffer(e,t,i){const o=this.gl,r=o.createRenderbuffer();return this.bindRenderbuffer.set(r),o.renderbufferStorage(o.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i,o){return new Wo(this,e,t,i,o)}clear({color:e,depth:t,stencil:i}){const o=this.gl;let r=0;e&&(r|=o.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(r|=o.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(r|=o.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),o.clear(r);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(e){t.bH(e.blendFunction,jt.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask);}createVertexArray(){var e;return qt(this.gl)?this.gl.createVertexArray():null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.createVertexArrayOES()}deleteVertexArray(e){var t;return qt(this.gl)?this.gl.deleteVertexArray(e):null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.deleteVertexArrayOES(e)}unbindVAO(){this.bindVertexArray.set(null);}}let Xo;function Ko(e,i,o,r,a){const s=e.context,n=e.transform,l=s.gl,c=e.useProgram("collisionBox"),h=[];let u=0,d=0;for(let t=0;t<r.length;t++){const _=r[t],p=i.getTile(_).getBucket(o);if(!p)continue;const m=a?p.textCollisionBox:p.iconCollisionBox,f=p.collisionCircleArray;f.length>0&&(h.push({circleArray:f,circleOffset:d,coord:_}),u+=f.length/4,d=u),m&&c.draw(s,l.LINES,Zt.disabled,Vt.disabled,e.colorModeForRenderPass(),Ut.disabled,Fi(e.transform),e.style.map.terrain&&e.style.map.terrain.getTerrainData(_),n.getProjectionData({overscaledTileID:_,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),o.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,e.transform.zoom,null,null,m.collisionVertexBuffer);}if(!a||!h.length)return;const _=e.useProgram("collisionCircle"),p=new t.b$;p.resize(4*u),p._trim();let m=0;for(const e of h)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,o=e.circleArray[i+0],r=e.circleArray[i+1],a=e.circleArray[i+2],s=e.circleArray[i+3];p.emplace(m++,o,r,a,s,0),p.emplace(m++,o,r,a,s,1),p.emplace(m++,o,r,a,s,2),p.emplace(m++,o,r,a,s,3);}(!Xo||Xo.length<2*u)&&(Xo=function(e){const i=2*e,o=new t.c1;o.resize(i),o._trim();for(let e=0;e<i;e++){const t=6*e;o.uint16[t+0]=4*e+0,o.uint16[t+1]=4*e+1,o.uint16[t+2]=4*e+2,o.uint16[t+3]=4*e+2,o.uint16[t+4]=4*e+3,o.uint16[t+5]=4*e+0;}return o}(u));const f=s.createIndexBuffer(Xo,!0),g=s.createVertexBuffer(p,t.c0.members,!0);for(const i of h){const r=Bi(e.transform);_.draw(s,l.TRIANGLES,Zt.disabled,Vt.disabled,e.colorModeForRenderPass(),Ut.disabled,r,e.style.map.terrain&&e.style.map.terrain.getTerrainData(i.coord),null,o.id,g,f,t.aM.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,e.transform.zoom,null,null,null);}g.destroy(),f.destroy();}const Yo=t.ag(new Float32Array(16));function Qo(e,i,o,r,a,s){const{horizontalAlign:n,verticalAlign:l}=t.aH(e);return new t.P((-(n-.5)*i/a+r[0])*s,(-(l-.5)*o/a+r[1])*s)}function Jo(e,i,o,r,a,s){const n=i.tileAnchorPoint.add(new t.P(i.translation[0],i.translation[1]));if(i.pitchWithMap){let e=r.mult(s);o||(e=e.rotate(-a));const t=n.add(e);return Ee(t.x,t.y,i.pitchedLabelPlaneMatrix,i.getElevation).point}if(o){const t=Oe(i.tileAnchorPoint.x+1,i.tileAnchorPoint.y,i).point.sub(e),o=Math.atan(t.y/t.x)+(t.x<0?Math.PI:0);return e.add(r.rotate(o))}return e.add(r)}function er(e,i,o,r,a,s,n,l,c,h,u,d){const _=e.text.placedSymbolArray,p=e.text.dynamicLayoutVertexArray,m=e.icon.dynamicLayoutVertexArray,f={};p.clear();for(let m=0;m<_.length;m++){const g=_.get(m),v=g.hidden||!g.crossTileID||e.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(v){const r=new t.P(g.anchorX,g.anchorY),_={getElevation:d,width:a.width,height:a.height,pitchedLabelPlaneMatrix:s,pitchWithMap:o,transform:a,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=o?Ne(r.x,r.y,_):Oe(r.x,r.y,_),b=Re(a.cameraToCenterDistance,m.signedDistanceFromCamera);let x=t.ap(e.textSizeData,l,g)*b/t.aB;o&&(x*=e.tilePixelRatio/n);const{width:y,height:w,anchor:T,textOffset:P,textBoxScale:C}=v,I=Qo(T,y,w,P,C,x),M=a.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),S=Jo(m.point,_,i,I,-a.bearingInRadians,M),E=e.allowVerticalPlacement&&g.placedOrientation===t.ao.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)t.av(p,S,E);c&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:S,angle:E});}else $e(g.numGlyphs,p);}if(c){m.clear();const i=e.icon.placedSymbolArray;for(let e=0;e<i.length;e++){const o=i.get(e);if(o.hidden)$e(o.numGlyphs,m);else {const i=f[e];if(i)for(let e=0;e<o.numGlyphs;e++)t.av(m,i.shiftedAnchor,i.angle);else $e(o.numGlyphs,m);}}e.icon.dynamicLayoutVertexBuffer.updateData(m);}e.text.dynamicLayoutVertexBuffer.updateData(p);}function tr(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function ir(e,i,o,r,a,s,n,l,c,h,u,d,_){const p=e.context,m=p.gl,f=e.transform,g="map"===l,v="map"===c,b="viewport"!==l&&"point"!==o.layout.get("symbol-placement"),x=g&&!v&&!b,y=!o.layout.get("symbol-sort-key").isConstant();let w=!1;const T=e.getDepthModeForSublayer(0,Zt.ReadOnly),P=o._unevaluatedLayout.hasValue("text-variable-anchor")||o._unevaluatedLayout.hasValue("text-variable-anchor-offset"),C=[],I=f.getCircleRadiusCorrection();for(const l of r){const r=i.getTile(l),c=r.getBucket(o);if(!c)continue;const u=a?c.text:c.icon;if(!u||!u.segments.get().length||!u.hasVisibleVertices)continue;const d=u.programConfigurations.get(o.id),p=a||c.sdfIcons,T=a?c.textSizeData:c.iconSizeData,M=v||0!==f.pitch,S=e.useProgram(tr(p,a,c),d),E=t.an(T,f.zoom),R=e.style.map.terrain&&e.style.map.terrain.getTerrainData(l);let z,D,A,L,k=[0,0],F=null;if(a)D=r.glyphAtlasTexture,A=m.LINEAR,z=r.glyphAtlasTexture.size,c.iconsInText&&(k=r.imageAtlasTexture.size,F=r.imageAtlasTexture,L=M||e.options.rotating||e.options.zooming||"composite"===T.kind||"camera"===T.kind?m.LINEAR:m.NEAREST);else {const t=1!==o.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;D=r.imageAtlasTexture,A=p||e.options.rotating||e.options.zooming||t||M?m.LINEAR:m.NEAREST,z=r.imageAtlasTexture.size;}const B=t.aC(r,1,e.transform.zoom),O=Ie(g,e.transform,B),j=t.L();t.aq(j,O);const N=Me(v,g,e.transform,B),U=t.aD(f,r,s,n),Z=f.getProjectionData({overscaledTileID:l,applyGlobeMatrix:!_,applyTerrainMatrix:!0}),G=P&&c.hasTextData(),V="none"!==o.layout.get("icon-text-fit")&&G&&c.hasIconData();if(b){const t=e.style.map.terrain?(t,i)=>e.style.map.terrain.getElevation(l,t,i):null,i="map"===o.layout.get("text-rotation-alignment");De(c,e,a,O,j,v,h,i,l.toUnwrapped(),f.width,f.height,U,t);}const $=a&&P||V,q=b||$?Yo:v?O:e.transform.clipSpaceToPixelsMatrix,W=p&&0!==o.paint.get(a?"text-halo-width":"icon-halo-width").constantOr(1);let H;H=p?c.iconsInText?to(T.kind,E,x,v,b,$,e,q,N,U,z,k,I):eo(T.kind,E,x,v,b,$,e,q,N,U,a,z,0,I):Ji(T.kind,E,x,v,b,$,e,q,N,U,a,z,I);const X={program:S,buffers:u,uniformValues:H,projectionData:Z,atlasTexture:D,atlasTextureIcon:F,atlasInterpolation:A,atlasInterpolationIcon:L,isSDF:p,hasHalo:W};if(y&&c.canOverlap){w=!0;const e=u.segments.get();for(const i of e)C.push({segments:new t.aM([i]),sortKey:i.sortKey,state:X,terrainData:R});}else C.push({segments:u.segments,sortKey:0,state:X,terrainData:R});}w&&C.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of C){const i=t.state;if(p.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(p.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const r=i.uniformValues;i.hasHalo&&(r.u_is_halo=1,or(i.buffers,t.segments,o,e,i.program,T,u,d,r,i.projectionData,t.terrainData)),r.u_is_halo=0;}or(i.buffers,t.segments,o,e,i.program,T,u,d,i.uniformValues,i.projectionData,t.terrainData);}}function or(e,t,i,o,r,a,s,n,l,c,h){const u=o.context;r.draw(u,u.gl.TRIANGLES,a,s,n,Ut.backCCW,l,h,c,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,o.transform.zoom,e.programConfigurations.get(i.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer);}function rr(e,i,o,r,a){const s=e.context,n=s.gl,l=Vt.disabled,c=new jt([n.ONE,n.ONE],t.bf.transparent,[!0,!0,!0,!0]),h=i.getBucket(o);if(!h)return;const u=r.key;let d=o.heatmapFbos.get(u);d||(d=sr(s,i.tileSize,i.tileSize),o.heatmapFbos.set(u,d)),s.bindFramebuffer.set(d.framebuffer),s.viewport.set([0,0,i.tileSize,i.tileSize]),s.clear({color:t.bf.transparent});const _=h.programConfigurations.get(o.id),p=e.useProgram("heatmap",_,!a),m=e.transform.getProjectionData({overscaledTileID:i.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),f=e.style.map.terrain.getTerrainData(r);p.draw(s,n.TRIANGLES,Zt.disabled,l,c,Ut.disabled,ji(i,e.transform.zoom,o.paint.get("heatmap-intensity"),1),f,m,o.id,h.layoutVertexBuffer,h.indexBuffer,h.segments,o.paint,e.transform.zoom,_);}function ar(e,t,i,o,r){const a=e.context,s=a.gl,n=e.transform;a.setColorMode(e.colorModeForRenderPass());const l=nr(a,t),c=i.key,h=t.heatmapFbos.get(c);if(!h)return;a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,h.colorAttachment.get()),a.activeTexture.set(s.TEXTURE1),l.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=n.getProjectionData({overscaledTileID:i,applyTerrainMatrix:r,applyGlobeMatrix:!o});e.useProgram("heatmapTexture").draw(a,s.TRIANGLES,Zt.disabled,Vt.disabled,e.colorModeForRenderPass(),Ut.disabled,Ni(e,t,0,1),null,u,t.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments,t.paint,n.zoom),h.destroy(),t.heatmapFbos.delete(c);}function sr(e,t,i){var o,r;const a=e.gl,s=a.createTexture();a.bindTexture(a.TEXTURE_2D,s),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR);const n=null!==(o=e.HALF_FLOAT)&&void 0!==o?o:a.UNSIGNED_BYTE,l=null!==(r=e.RGBA16F)&&void 0!==r?r:a.RGBA;a.texImage2D(a.TEXTURE_2D,0,l,t,i,0,a.RGBA,n,null);const c=e.createFramebuffer(t,i,!1,!1);return c.colorAttachment.set(s),c}function nr(e,i){return i.colorRampTexture||(i.colorRampTexture=new t.T(e,i.colorRamp,e.gl.RGBA)),i.colorRampTexture}function lr(e,t,i,o,r){if(!i||!o||!o.imageAtlas)return;const a=o.imageAtlas.patternPositions;let s=a[i.to.toString()],n=a[i.from.toString()];if(!s&&n&&(s=n),!n&&s&&(n=s),!s||!n){const e=r.getPaintProperty(t);s=a[e],n=a[e];}s&&n&&e.setConstantPatternPositions(s,n);}function cr(e,i,o,r,a,s,n,l){const c=e.context.gl,h="fill-pattern",u=o.paint.get(h),d=u&&u.constantOr(1),_=o.getCrossfadeParameters();let p,m,f,g,v;const b=e.transform,x=o.paint.get("fill-translate"),y=o.paint.get("fill-translate-anchor");n?(m=d&&!o.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=c.LINES):(m=d?"fillPattern":"fill",p=c.TRIANGLES);const w=u.constantOr(null);for(const u of r){const r=i.getTile(u);if(d&&!r.patternsLoaded())continue;const T=r.getBucket(o);if(!T)continue;const P=T.programConfigurations.get(o.id),C=e.useProgram(m,P),I=e.style.map.terrain&&e.style.map.terrain.getTerrainData(u);d&&(e.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),P.updatePaintBuffers(_)),lr(P,h,w,r,o);const M=b.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!l,applyTerrainMatrix:!0}),S=t.aD(b,r,x,y);if(n){g=T.indexBuffer2,v=T.segments2;const t=[c.drawingBufferWidth,c.drawingBufferHeight];f="fillOutlinePattern"===m&&d?Li(e,_,r,t,S):Ai(t,S);}else g=T.indexBuffer,v=T.segments,f=d?Di(e,_,r,S):{u_fill_translate:S};const E=e.stencilModeForClipping(u);C.draw(e.context,p,a,E,s,Ut.backCCW,f,I,M,o.id,T.layoutVertexBuffer,g,v,o.paint,e.transform.zoom,P);}}function hr(e,i,o,r,a,s,n,l){const c=e.context,h=c.gl,u="fill-extrusion-pattern",d=o.paint.get(u),_=d.constantOr(1),p=o.getCrossfadeParameters(),m=o.paint.get("fill-extrusion-opacity"),f=d.constantOr(null),g=e.transform;for(const d of r){const r=i.getTile(d),v=r.getBucket(o);if(!v)continue;const b=e.style.map.terrain&&e.style.map.terrain.getTerrainData(d),x=v.programConfigurations.get(o.id),y=e.useProgram(_?"fillExtrusionPattern":"fillExtrusion",x);_&&(e.context.activeTexture.set(h.TEXTURE0),r.imageAtlasTexture.bind(h.LINEAR,h.CLAMP_TO_EDGE),x.updatePaintBuffers(p));const w=g.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!l,applyTerrainMatrix:!0});lr(x,u,f,r,o);const T=t.aD(g,r,o.paint.get("fill-extrusion-translate"),o.paint.get("fill-extrusion-translate-anchor")),P=o.paint.get("fill-extrusion-vertical-gradient"),C=_?zi(e,P,m,T,d,p,r):Ri(e,P,m,T);y.draw(c,c.gl.TRIANGLES,a,s,n,Ut.backCCW,C,b,w,o.id,v.layoutVertexBuffer,v.indexBuffer,v.segments,o.paint,e.transform.zoom,x,e.style.map.terrain&&v.centroidVertexBuffer);}}function ur(e,t,i,o,r,a,s,n,l){var c;const h=e.style.projection,u=e.context,d=e.transform,_=u.gl,p=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=e.useProgram("hillshade",null,!1,p),f=!e.options.moving;for(const p of o){const o=t.getTile(p),g=o.fbo;if(!g)continue;const v=h.getMeshFromTileID(u,p.canonical,n,!0,"raster"),b=null===(c=e.style.map.terrain)||void 0===c?void 0:c.getTerrainData(p);u.activeTexture.set(_.TEXTURE0),_.bindTexture(_.TEXTURE_2D,g.colorAttachment.get());const x=d.getProjectionData({overscaledTileID:p,aligned:f,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,_.TRIANGLES,a,r[p.overscaledZ],s,Ut.backCCW,Ui(e,o,i),b,x,i.id,v.vertexBuffer,v.indexBuffer,v.segments);}}function dr(e,i,o,r,a,s,n,l,c){var h;const u=e.style.projection,d=e.context,_=e.transform,p=d.gl,m=e.useProgram("colorRelief"),f=!e.options.moving;let g=!0,v=0;for(const b of r){const r=i.getTile(b),x=r.dem;if(g){const e=p.getParameter(p.MAX_TEXTURE_SIZE),{elevationTexture:t,colorTexture:i}=o.getColorRampTextures(d,e,x.getUnpackVector());d.activeTexture.set(p.TEXTURE1),t.bind(p.NEAREST,p.CLAMP_TO_EDGE),d.activeTexture.set(p.TEXTURE4),i.bind(p.LINEAR,p.CLAMP_TO_EDGE),g=!1,v=t.size[0];}if(!x||!x.data)continue;const y=x.stride,w=x.getPixels();if(d.activeTexture.set(p.TEXTURE0),d.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||e.getTileTexture(y),r.demTexture){const e=r.demTexture;e.update(w,{premultiply:!1}),e.bind(p.LINEAR,p.CLAMP_TO_EDGE);}else r.demTexture=new t.T(d,w,p.RGBA,{premultiply:!1}),r.demTexture.bind(p.LINEAR,p.CLAMP_TO_EDGE);const T=u.getMeshFromTileID(d,b.canonical,l,!0,"raster"),P=null===(h=e.style.map.terrain)||void 0===h?void 0:h.getTerrainData(b),C=_.getProjectionData({overscaledTileID:b,aligned:f,applyGlobeMatrix:!c,applyTerrainMatrix:!0});m.draw(d,p.TRIANGLES,s,a[b.overscaledZ],n,Ut.backCCW,Vi(o,r.dem,v),P,C,o.id,T.vertexBuffer,T.indexBuffer,T.segments);}}const _r=[new t.P(0,0),new t.P(t.$,0),new t.P(t.$,t.$),new t.P(0,t.$)];function pr(e,t,i,o,r,a,s,n,l=!1,c=!1){const h=o[o.length-1].overscaledZ,u=e.context,d=u.gl,_=e.useProgram("raster"),p=e.transform,m=e.style.projection,f=e.colorModeForRenderPass(),g=!e.options.moving;for(const v of o){const o=e.getDepthModeForSublayer(v.overscaledZ-h,1===i.paint.get("raster-opacity")?Zt.ReadWrite:Zt.ReadOnly,d.LESS),b=t.getTile(v);b.registerFadeDuration(i.paint.get("raster-fade-duration"));const x=t.findLoadedParent(v,0),y=t.findLoadedSibling(v),w=mr(b,x||y||null,t,i,e.transform,e.style.map.terrain);let T,P;const C="nearest"===i.paint.get("raster-resampling")?d.NEAREST:d.LINEAR;u.activeTexture.set(d.TEXTURE0),b.texture.bind(C,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(d.TEXTURE1),x?(x.texture.bind(C,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),T=Math.pow(2,x.tileID.overscaledZ-b.tileID.overscaledZ),P=[b.tileID.canonical.x*T%1,b.tileID.canonical.y*T%1]):b.texture.bind(C,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),b.texture.useMipmap&&u.extTextureFilterAnisotropic&&e.transform.pitch>20&&d.texParameterf(d.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const I=e.style.map.terrain&&e.style.map.terrain.getTerrainData(v),M=p.getProjectionData({overscaledTileID:v,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),S=Yi(P||[0,0],T||1,w,i,n),E=m.getMeshFromTileID(u,v.canonical,a,s,"raster");_.draw(u,d.TRIANGLES,o,r?r[v.overscaledZ]:Vt.disabled,f,l?Ut.frontCCW:Ut.backCCW,S,I,M,i.id,E.vertexBuffer,E.indexBuffer,E.segments);}}function mr(e,i,o,r,a,n){const l=r.paint.get("raster-fade-duration");if(!n&&l>0){const r=s.now(),n=(r-e.timeAdded)/l,c=i?(r-i.timeAdded)/l:-1,h=o.getSource(),u=ge(a,{tileSize:h.tileSize,roundZoom:h.roundZoom}),d=!i||Math.abs(i.tileID.overscaledZ-u)>Math.abs(e.tileID.overscaledZ-u),_=d&&e.refreshedUponExpiration?1:t.ah(d?n:1-c,0,1);return e.refreshedUponExpiration&&n>=1&&(e.refreshedUponExpiration=!1),i?{opacity:1,mix:1-_}:{opacity:_,mix:0}}return {opacity:1,mix:0}}const fr=new t.bf(1,0,0,1),gr=new t.bf(0,1,0,1),vr=new t.bf(0,0,1,1),br=new t.bf(1,0,1,1),xr=new t.bf(0,1,1,1);function yr(e,t,i,o){Tr(e,0,t+i/2,e.transform.width,i,o);}function wr(e,t,i,o){Tr(e,t-i/2,0,i,e.transform.height,o);}function Tr(e,t,i,o,r,a){const s=e.context,n=s.gl;n.enable(n.SCISSOR_TEST),n.scissor(t*e.pixelRatio,i*e.pixelRatio,o*e.pixelRatio,r*e.pixelRatio),s.clear({color:a}),n.disable(n.SCISSOR_TEST);}function Pr(e,i,o){const r=e.context,a=r.gl,s=e.useProgram("debug"),n=Zt.disabled,l=Vt.disabled,c=e.colorModeForRenderPass(),h="$debug",u=e.style.map.terrain&&e.style.map.terrain.getTerrainData(o);r.activeTexture.set(a.TEXTURE0);const d=i.getTileByID(o.key).latestRawTileData,_=Math.floor((d&&d.byteLength||0)/1024),p=i.getTile(o).tileSize,m=512/Math.min(p,512)*(o.overscaledZ/e.transform.zoom)*.5;let f=o.canonical.toString();o.overscaledZ!==o.canonical.z&&(f+=` => ${o.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,o=e.context.gl,r=e.debugOverlayCanvas.getContext("2d");r.clearRect(0,0,i.width,i.height),r.shadowColor="white",r.shadowBlur=2,r.lineWidth=1.5,r.strokeStyle="white",r.textBaseline="top",r.font="bold 36px Open Sans, sans-serif",r.fillText(t,5,5),r.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE);}(e,`${f} ${_}kB`);const g=e.transform.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,a.TRIANGLES,n,l,jt.alphaBlended,Ut.disabled,Oi(t.bf.transparent,m),null,g,h,e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments),s.draw(r,a.LINE_STRIP,n,l,c,Ut.disabled,Oi(t.bf.red),u,g,h,e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments);}function Cr(e,t,i,o){const{isRenderingGlobe:r}=o,a=e.context,s=a.gl,n=e.transform,l=e.colorModeForRenderPass(),c=e.getDepthModeFor3D(),h=e.useProgram("terrain");a.bindFramebuffer.set(null),a.viewport.set([0,0,e.width,e.height]);for(const o of i){const i=t.getTerrainMesh(o.tileID),u=e.renderToTexture.getTexture(o),d=t.getTerrainData(o.tileID);a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,u.texture);const _=t.getMeshFrameDelta(n.zoom),p=n.calculateFogMatrix(o.tileID.toUnwrapped()),m=Ci(_,p,e.style.sky,n.pitch,r),f=n.getProjectionData({overscaledTileID:o.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(a,s.TRIANGLES,c,Vt.disabled,l,Ut.backCCW,m,d,f,"terrain",i.vertexBuffer,i.indexBuffer,i.segments);}}function Ir(e,i){if(!i.mesh){const o=new t.aL;o.emplaceBack(-1,-1),o.emplaceBack(1,-1),o.emplaceBack(1,1),o.emplaceBack(-1,1);const r=new t.aN;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),i.mesh=new wt(e.createVertexBuffer(o,Tt.members),e.createIndexBuffer(r),t.aM.simpleSegment(0,0,o.length,r.length));}return i.mesh}class Mr{constructor(e,i){this.context=new Ho(e),this.transform=i,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:t.ag(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=xe.maxUnderzooming+xe.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new vt;}resize(e,t,i){if(this.width=Math.floor(e*i),this.height=Math.floor(t*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style._order)this.style._layers[e].resize();}setup(){const e=this.context,i=new t.aL;i.emplaceBack(0,0),i.emplaceBack(t.$,0),i.emplaceBack(0,t.$),i.emplaceBack(t.$,t.$),this.tileExtentBuffer=e.createVertexBuffer(i,Tt.members),this.tileExtentSegments=t.aM.simpleSegment(0,0,4,2);const o=new t.aL;o.emplaceBack(0,0),o.emplaceBack(t.$,0),o.emplaceBack(0,t.$),o.emplaceBack(t.$,t.$),this.debugBuffer=e.createVertexBuffer(o,Tt.members),this.debugSegments=t.aM.simpleSegment(0,0,4,5);const r=new t.c6;r.emplaceBack(0,0,0,0),r.emplaceBack(t.$,0,t.$,0),r.emplaceBack(0,t.$,0,t.$),r.emplaceBack(t.$,t.$,t.$,t.$),this.rasterBoundsBuffer=e.createVertexBuffer(r,Ti.members),this.rasterBoundsSegments=t.aM.simpleSegment(0,0,4,2);const a=new t.aL;a.emplaceBack(0,0),a.emplaceBack(t.$,0),a.emplaceBack(0,t.$),a.emplaceBack(t.$,t.$),this.rasterBoundsBufferPosOnly=e.createVertexBuffer(a,Tt.members),this.rasterBoundsSegmentsPosOnly=t.aM.simpleSegment(0,0,4,5);const s=new t.aL;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(s,Tt.members),this.viewportSegments=t.aM.simpleSegment(0,0,4,2);const n=new t.c7;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(n);const l=new t.aN;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(l);const c=this.context.gl;this.stencilClearMode=new Vt({func:c.ALWAYS,mask:0},0,255,c.ZERO,c.ZERO,c.ZERO),this.tileExtentMesh=new wt(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}clearStencil(){const e=this.context,i=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const o=t.L();t.bY(o,0,this.width,this.height,0,0,1),t.N(o,o,[i.drawingBufferWidth,i.drawingBufferHeight,0]);const r={mainMatrix:o,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:o};this.useProgram("clippingMask",null,!0).draw(e,i.TRIANGLES,Zt.disabled,this.stencilClearMode,jt.disabled,Ut.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(e,t,i){if(this.currentStencilSource===e.source||!e.isTileClipped()||!t||!t.length)return;this.currentStencilSource=e.source,this.nextStencilID+t.length>256&&this.clearStencil();const o=this.context;o.setColorMode(jt.disabled),o.setDepthMode(Zt.disabled);const r={};for(const e of t)r[e.key]=this.nextStencilID++;this._renderTileMasks(r,t,i,!0),this._renderTileMasks(r,t,i,!1),this._tileClippingMaskIDs=r;}_renderTileMasks(e,t,i,o){const r=this.context,a=r.gl,s=this.style.projection,n=this.transform,l=this.useProgram("clippingMask");for(const c of t){const t=e[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=s.getMeshFromTileID(this.context,c.canonical,o,!0,"stencil"),d=n.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(r,a.TRIANGLES,Zt.disabled,new Vt({func:a.ALWAYS,mask:0},t,255,a.KEEP,a.KEEP,a.REPLACE),jt.disabled,i?Ut.disabled:Ut.backCCW,null,h,d,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments);}}_renderTilesDepthBuffer(){const e=this.context,t=e.gl,i=this.style.projection,o=this.transform,r=this.useProgram("depth"),a=this.getDepthModeFor3D(),s=ve(o,{tileSize:o.tileSize});for(const n of s){const s=this.style.map.terrain&&this.style.map.terrain.getTerrainData(n),l=i.getMeshFromTileID(this.context,n.canonical,!0,!0,"raster"),c=o.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!0,applyTerrainMatrix:!0});r.draw(e,t.TRIANGLES,a,Vt.disabled,jt.disabled,Ut.backCCW,null,s,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,t=this.context.gl;return new Vt({func:t.NOTEQUAL,mask:255},e,255,t.KEEP,t.KEEP,t.REPLACE)}stencilModeForClipping(e){const t=this.context.gl;return new Vt({func:t.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,t.KEEP,t.KEEP,t.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),o=i[i.length-1].overscaledZ,r=i[0].overscaledZ-o+1;if(r>1){this.currentStencilSource=void 0,this.nextStencilID+r>256&&this.clearStencil();const e={};for(let i=0;i<r;i++)e[i+o]=new Vt({func:t.GEQUAL,mask:255},i+this.nextStencilID,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID+=r,[e,i]}return [{[o]:Vt.disabled},i]}stencilConfigForOverlapTwoPass(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),o=i[i.length-1].overscaledZ,r=i[0].overscaledZ-o+1;if(this.clearStencil(),r>1){const e={},a={};for(let i=0;i<r;i++)e[i+o]=new Vt({func:t.GREATER,mask:255},r+1+i,255,t.KEEP,t.KEEP,t.REPLACE),a[i+o]=new Vt({func:t.GREATER,mask:255},1+i,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID=2*r+1,[e,a,i]}return this.nextStencilID=3,[{[o]:new Vt({func:t.GREATER,mask:255},2,255,t.KEEP,t.KEEP,t.REPLACE)},{[o]:new Vt({func:t.GREATER,mask:255},1,255,t.KEEP,t.KEEP,t.REPLACE)},i]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new jt([e.CONSTANT_COLOR,e.ONE],new t.bf(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?jt.unblended:jt.alphaBlended}getDepthModeForSublayer(e,t,i){if(!this.opaquePassEnabledForLayer())return Zt.disabled;const o=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new Zt(i||this.context.gl.LEQUAL,t,[o,o])}getDepthModeFor3D(){return new Zt(this.context.gl.LEQUAL,Zt.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,i){var o,r;this.style=e,this.options=i,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(s.now()),this.imageManager.beginFrame();const a=this.style._order,n=this.style.sourceCaches,l={},c={},h={},u={isRenderingToTexture:!1,isRenderingGlobe:(null===(o=e.projection)||void 0===o?void 0:o.transitionState)>0};for(const e in n){const t=n[e];t.used&&t.prepare(this.context),l[e]=t.getVisibleCoordinates(!1),c[e]=l[e].slice().reverse(),h[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<a.length;e++)if(this.style._layers[a[e]].is3D()){this.opaquePassCutoff=e;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const e of a){const t=this.style._layers[e];if(!t.hasOffscreenPass()||t.isHidden(this.transform.zoom))continue;const i=c[t.source];("custom"===t.type||i.length)&&this.renderLayer(this,n[t.source],t,i,u);}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:e=>this.useProgram(e)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?t.bf.black:t.bf.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(e,t){const i=e.context,o=i.gl,r=((e,t,i)=>{const o=Math.cos(t.rollInRadians),r=Math.sin(t.rollInRadians),a=he(t),s=t.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return {u_sky_color:e.properties.get("sky-color"),u_horizon_color:e.properties.get("horizon-color"),u_horizon:[(t.width/2-a*r)*i,(t.height/2+a*o)*i],u_horizon_normal:[-r,o],u_sky_horizon_blend:e.properties.get("sky-horizon-blend")*t.height/2*i,u_sky_blend:s}})(t,e.style.map.transform,e.pixelRatio),a=new Zt(o.LEQUAL,Zt.ReadWrite,[0,1]),s=Vt.disabled,n=e.colorModeForRenderPass(),l=e.useProgram("sky"),c=Ir(i,t);l.draw(i,o.TRIANGLES,a,s,n,Ut.disabled,r,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments);}(this,this.style.sky),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(e._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=a.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[a[this.currentLayer]],t=n[e.source],i=l[e.source];this._renderTileClippingMasks(e,i,!1),this.renderLayer(this,t,e,i,u);}this.renderPass="translucent";let d=!1;for(this.currentLayer=0;this.currentLayer<a.length;this.currentLayer++){const e=this.style._layers[a[this.currentLayer]],t=n[e.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(e,u))continue;this.opaquePassEnabledForLayer()||d||(d=!0,u.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===e.type?h:c)[e.source];this._renderTileClippingMasks(e,l[e.source],!!this.renderToTexture),this.renderLayer(this,t,e,i,u);}if(u.isRenderingGlobe&&function(e,i,o){const r=e.context,a=r.gl,s=e.useProgram("atmosphere"),n=new Zt(a.LEQUAL,Zt.ReadOnly,[0,1]),l=e.transform,c=function(e,i){const o=e.properties.get("position"),r=[-o.x,-o.y,-o.z],a=t.ag(new Float64Array(16));return "map"===e.properties.get("anchor")&&(t.b6(a,a,i.rollInRadians),t.b7(a,a,-i.pitchInRadians),t.b6(a,a,i.bearingInRadians),t.b7(a,a,i.center.lat*Math.PI/180),t.bz(a,a,-i.center.lng*Math.PI/180)),t.c5(r,r,a),r}(o,e.transform),h=l.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),u=i.properties.get("atmosphere-blend")*h.projectionTransition;if(0===u)return;const d=oi(l.worldSize,l.center.lat),_=l.inverseProjectionMatrix,p=new Float64Array(4);p[3]=1,t.aw(p,p,l.modelViewProjectionMatrix),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1,t.aw(p,p,_),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1;const m=((e,t,i,o,r)=>({u_sun_pos:e,u_atmosphere_blend:t,u_globe_position:i,u_globe_radius:o,u_inv_proj_matrix:r}))(c,u,[p[0],p[1],p[2]],d,_),f=Ir(r,i);s.draw(r,a.TRIANGLES,n,Vt.disabled,jt.alphaBlended,Ut.disabled,m,null,null,"atmosphere",f.vertexBuffer,f.indexBuffer,f.segments);}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const e=function(e,t){let i=null;const o=Object.values(e._layers).flatMap((i=>i.source&&!i.isHidden(t)?[e.sourceCaches[i.source]]:[])),r=o.filter((e=>"vector"===e.getSource().type)),a=o.filter((e=>"vector"!==e.getSource().type)),s=e=>{(!i||i.getSource().maxzoom<e.getSource().maxzoom)&&(i=e);};return r.forEach((e=>s(e))),i||a.forEach((e=>s(e))),i}(this.style,this.transform.zoom);e&&function(e,t,i){for(let o=0;o<i.length;o++)Pr(e,t,i[o]);}(this,e,e.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;yr(e,e.transform.height-(t.top||0),3,fr),yr(e,t.bottom||0,3,gr),wr(e,t.left||0,3,vr),wr(e,e.transform.width-(t.right||0),3,br);const i=e.transform.centerPoint;!function(e,t,i,o){Tr(e,t-1,i-10,2,20,o),Tr(e,t-10,i-1,20,2,o);}(e,i.x,e.transform.height-i.y,xr);}(this),this.context.setDefault();}maybeDrawDepthAndCoords(e){if(!this.style||!this.style.map||!this.style.map.terrain)return;const i=this.terrainFacilitator.matrix,o=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;r||(r=e?!t.c8(i,o):!t.c9(i,o)),r||(r=this.style.map.terrain.sourceCache.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(t.ca(i,o),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(e,i){const o=e.context,r=o.gl,a=e.transform,s=jt.unblended,n=new Zt(r.LEQUAL,Zt.ReadWrite,[0,1]),l=i.sourceCache.getRenderableTiles(),c=e.useProgram("terrainDepth");o.bindFramebuffer.set(i.getFramebuffer("depth").framebuffer),o.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),o.clear({color:t.bf.transparent,depth:1});for(const e of l){const t=i.getTerrainMesh(e.tileID),l=i.getTerrainData(e.tileID),h=a.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:i.getMeshFrameDelta(a.zoom)};c.draw(o,r.TRIANGLES,n,Vt.disabled,s,Ut.backCCW,u,l,h,"terrain",t.vertexBuffer,t.indexBuffer,t.segments);}o.bindFramebuffer.set(null),o.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain),function(e,i){const o=e.context,r=o.gl,a=e.transform,s=jt.unblended,n=new Zt(r.LEQUAL,Zt.ReadWrite,[0,1]),l=i.getCoordsTexture(),c=i.sourceCache.getRenderableTiles(),h=e.useProgram("terrainCoords");o.bindFramebuffer.set(i.getFramebuffer("coords").framebuffer),o.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),o.clear({color:t.bf.transparent,depth:1}),i.coordsIndex=[];for(const e of c){const t=i.getTerrainMesh(e.tileID),c=i.getTerrainData(e.tileID);o.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,l.texture);const u={u_terrain_coords_id:(255-i.coordsIndex.length)/255,u_texture:0,u_ele_delta:i.getMeshFrameDelta(a.zoom)},d=a.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(o,r.TRIANGLES,n,Vt.disabled,s,Ut.backCCW,u,c,d,"terrain",t.vertexBuffer,t.indexBuffer,t.segments),i.coordsIndex.push(e.tileID.key);}o.bindFramebuffer.set(null),o.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain));}renderLayer(e,i,o,r,a){o.isHidden(this.transform.zoom)||("background"===o.type||"custom"===o.type||(r||[]).length)&&(this.id=o.id,t.cb(o)?function(e,i,o,r,a,s){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:n}=s,l=Vt.disabled,c=e.colorModeForRenderPass();(o._unevaluatedLayout.hasValue("text-variable-anchor")||o._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(e,i,o,r,a,s,n,l,c){const h=i.transform,u=i.style.map.terrain,d="map"===a,_="map"===s;for(const a of e){const e=r.getTile(a),s=e.getBucket(o);if(!s||!s.text||!s.text.segments.get().length)continue;const p=t.an(s.textSizeData,h.zoom),m=t.aC(e,1,i.transform.zoom),f=Ie(d,i.transform,m),g="none"!==o.layout.get("icon-text-fit")&&s.hasIconData();if(p){const i=Math.pow(2,h.zoom-e.tileID.overscaledZ),o=u?(e,t)=>u.getElevation(a,e,t):null;er(s,d,_,c,h,f,i,p,g,t.aD(h,e,n,l),a.toUnwrapped(),o);}}}(r,e,o,i,o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),a),0!==o.paint.get("icon-opacity").constantOr(1)&&ir(e,i,o,r,!1,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),o.layout.get("icon-rotation-alignment"),o.layout.get("icon-pitch-alignment"),o.layout.get("icon-keep-upright"),l,c,n),0!==o.paint.get("text-opacity").constantOr(1)&&ir(e,i,o,r,!0,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.layout.get("text-keep-upright"),l,c,n),i.map.showCollisionBoxes&&(Ko(e,i,o,r,!0),Ko(e,i,o,r,!1));}(e,i,o,r,this.style.placement.variableOffsets,a):t.cc(o)?function(e,i,o,r,a){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=a,n=o.paint.get("circle-opacity"),l=o.paint.get("circle-stroke-width"),c=o.paint.get("circle-stroke-opacity"),h=!o.layout.get("circle-sort-key").isConstant();if(0===n.constantOr(1)&&(0===l.constantOr(1)||0===c.constantOr(1)))return;const u=e.context,d=u.gl,_=e.transform,p=e.getDepthModeForSublayer(0,Zt.ReadOnly),m=Vt.disabled,f=e.colorModeForRenderPass(),g=[],v=_.getCircleRadiusCorrection();for(let a=0;a<r.length;a++){const n=r[a],l=i.getTile(n),c=l.getBucket(o);if(!c)continue;const u=o.paint.get("circle-translate"),d=o.paint.get("circle-translate-anchor"),p=t.aD(_,l,u,d),m=c.programConfigurations.get(o.id),f=e.useProgram("circle",m),b=c.layoutVertexBuffer,x=c.indexBuffer,y=e.style.map.terrain&&e.style.map.terrain.getTerrainData(n),w={programConfiguration:m,program:f,layoutVertexBuffer:b,indexBuffer:x,uniformValues:ki(e,l,o,p,v),terrainData:y,projectionData:_.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(h){const e=c.segments.get();for(const i of e)g.push({segments:new t.aM([i]),sortKey:i.sortKey,state:w});}else g.push({segments:c.segments,sortKey:0,state:w});}h&&g.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of g){const{programConfiguration:i,program:r,layoutVertexBuffer:a,indexBuffer:s,uniformValues:n,terrainData:l,projectionData:c}=t.state;r.draw(u,d.TRIANGLES,p,m,f,Ut.backCCW,n,l,c,o.id,a,s,t.segments,o.paint,e.transform.zoom,i);}}(e,i,o,r,a):t.cd(o)?function(e,i,o,r,a){if(0===o.paint.get("heatmap-opacity"))return;const s=e.context,{isRenderingToTexture:n,isRenderingGlobe:l}=a;if(e.style.map.terrain){for(const t of r){const r=i.getTile(t);i.hasRenderableParent(t)||("offscreen"===e.renderPass?rr(e,r,o,t,l):"translucent"===e.renderPass&&ar(e,o,t,n,l));}s.viewport.set([0,0,e.width,e.height]);}else "offscreen"===e.renderPass?function(e,i,o,r){const a=e.context,s=a.gl,n=e.transform,l=Vt.disabled,c=new jt([s.ONE,s.ONE],t.bf.transparent,[!0,!0,!0,!0]);((function(e,i,o){const r=e.gl;e.activeTexture.set(r.TEXTURE1),e.viewport.set([0,0,i.width/4,i.height/4]);let a=o.heatmapFbos.get(t.c2);a?(r.bindTexture(r.TEXTURE_2D,a.colorAttachment.get()),e.bindFramebuffer.set(a.framebuffer)):(a=sr(e,i.width/4,i.height/4),o.heatmapFbos.set(t.c2,a));}))(a,e,o),a.clear({color:t.bf.transparent});for(let t=0;t<r.length;t++){const h=r[t];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(o);if(!d)continue;const _=d.programConfigurations.get(o.id),p=e.useProgram("heatmap",_),m=n.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),f=n.getCircleRadiusCorrection();p.draw(a,s.TRIANGLES,Zt.disabled,l,c,Ut.backCCW,ji(u,n.zoom,o.paint.get("heatmap-intensity"),f),null,m,o.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,o.paint,n.zoom,_);}a.viewport.set([0,0,e.width,e.height]);}(e,i,o,r):"translucent"===e.renderPass&&function(e,i){const o=e.context,r=o.gl;o.setColorMode(e.colorModeForRenderPass());const a=i.heatmapFbos.get(t.c2);a&&(o.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,a.colorAttachment.get()),o.activeTexture.set(r.TEXTURE1),nr(o,i).bind(r.LINEAR,r.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(o,r.TRIANGLES,Zt.disabled,Vt.disabled,e.colorModeForRenderPass(),Ut.disabled,Ni(e,i,0,1),null,null,i.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,i.paint,e.transform.zoom));}(e,o);}(e,i,o,r,a):t.ce(o)?function(e,i,o,r,a){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=a,n=o.paint.get("line-opacity"),l=o.paint.get("line-width");if(0===n.constantOr(1)||0===l.constantOr(1))return;const c=e.getDepthModeForSublayer(0,Zt.ReadOnly),h=e.colorModeForRenderPass(),u=o.paint.get("line-dasharray"),d=o.paint.get("line-pattern"),_=d.constantOr(1),p=o.paint.get("line-gradient"),m=o.getCrossfadeParameters(),f=_?"linePattern":u?"lineSDF":p?"lineGradient":"line",g=e.context,v=g.gl,b=e.transform;let x=!0;for(const a of r){const r=i.getTile(a);if(_&&!r.patternsLoaded())continue;const n=r.getBucket(o);if(!n)continue;const l=n.programConfigurations.get(o.id),y=e.context.program.get(),w=e.useProgram(f,l),T=x||w.program!==y,P=e.style.map.terrain&&e.style.map.terrain.getTerrainData(a),C=d.constantOr(null);if(C&&r.imageAtlas){const e=r.imageAtlas,t=e.patternPositions[C.to.toString()],i=e.patternPositions[C.from.toString()];t&&i&&l.setConstantPatternPositions(t,i);}const I=b.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!s,applyTerrainMatrix:!0}),M=b.getPixelScale(),S=_?Wi(e,r,o,M,m):u?Hi(e,r,o,M,u,m):p?qi(e,r,o,M,n.lineClipsArray.length):$i(e,r,o,M);if(_)g.activeTexture.set(v.TEXTURE0),r.imageAtlasTexture.bind(v.LINEAR,v.CLAMP_TO_EDGE),l.updatePaintBuffers(m);else if(u&&(T||e.lineAtlas.dirty))g.activeTexture.set(v.TEXTURE0),e.lineAtlas.bind(g);else if(p){const r=n.gradients[o.id];let s=r.texture;if(o.gradientVersion!==r.version){let l=256;if(o.stepInterpolant){const o=i.getSource().maxzoom,r=a.canonical.z===o?Math.ceil(1<<e.transform.maxZoom-a.canonical.z):1;l=t.ah(t.c3(n.maxLineLength/t.$*1024*r),256,g.maxTextureSize);}r.gradient=t.c4({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:r.gradient||void 0,clips:n.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new t.T(g,r.gradient,v.RGBA),r.version=o.gradientVersion,s=r.texture;}g.activeTexture.set(v.TEXTURE0),s.bind(o.stepInterpolant?v.NEAREST:v.LINEAR,v.CLAMP_TO_EDGE);}const E=e.stencilModeForClipping(a);w.draw(g,v.TRIANGLES,c,E,h,Ut.disabled,S,P,I,o.id,n.layoutVertexBuffer,n.indexBuffer,n.segments,o.paint,e.transform.zoom,l,n.layoutVertexBuffer2),x=!1;}}(e,i,o,r,a):t.cf(o)?function(e,i,o,r,a){const s=o.paint.get("fill-color"),n=o.paint.get("fill-opacity");if(0===n.constantOr(1))return;const{isRenderingToTexture:l}=a,c=e.colorModeForRenderPass(),h=o.paint.get("fill-pattern"),u=e.opaquePassEnabledForLayer()&&!h.constantOr(1)&&1===s.constantOr(t.bf.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(e.renderPass===u){const t=e.getDepthModeForSublayer(1,"opaque"===e.renderPass?Zt.ReadWrite:Zt.ReadOnly);cr(e,i,o,r,t,c,!1,l);}if("translucent"===e.renderPass&&o.paint.get("fill-antialias")){const t=e.getDepthModeForSublayer(o.getPaintProperty("fill-outline-color")?2:0,Zt.ReadOnly);cr(e,i,o,r,t,c,!0,l);}}(e,i,o,r,a):t.cg(o)?function(e,t,i,o,r){const a=i.paint.get("fill-extrusion-opacity");if(0===a)return;const{isRenderingToTexture:s}=r;if("translucent"===e.renderPass){const r=new Zt(e.context.gl.LEQUAL,Zt.ReadWrite,e.depthRangeFor3D);if(1!==a||i.paint.get("fill-extrusion-pattern").constantOr(1))hr(e,t,i,o,r,Vt.disabled,jt.disabled,s),hr(e,t,i,o,r,e.stencilModeFor3D(),e.colorModeForRenderPass(),s);else {const a=e.colorModeForRenderPass();hr(e,t,i,o,r,Vt.disabled,a,s);}}}(e,i,o,r,a):t.ch(o)?function(e,i,o,r,a){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=a,n=e.context,l=e.style.projection.useSubdivision,c=e.getDepthModeForSublayer(0,Zt.ReadOnly),h=e.colorModeForRenderPass();if("offscreen"===e.renderPass)!function(e,i,o,r,a,s,n){const l=e.context,c=l.gl;for(const h of o){const o=i.getTile(h),u=o.dem;if(!u||!u.data)continue;if(!o.needsHillshadePrepare)continue;const d=u.dim,_=u.stride,p=u.getPixels();if(l.activeTexture.set(c.TEXTURE1),l.pixelStoreUnpackPremultiplyAlpha.set(!1),o.demTexture=o.demTexture||e.getTileTexture(_),o.demTexture){const e=o.demTexture;e.update(p,{premultiply:!1}),e.bind(c.NEAREST,c.CLAMP_TO_EDGE);}else o.demTexture=new t.T(l,p,c.RGBA,{premultiply:!1}),o.demTexture.bind(c.NEAREST,c.CLAMP_TO_EDGE);l.activeTexture.set(c.TEXTURE0);let m=o.fbo;if(!m){const e=new t.T(l,{width:d,height:d,data:null},c.RGBA);e.bind(c.LINEAR,c.CLAMP_TO_EDGE),m=o.fbo=l.createFramebuffer(d,d,!0,!1),m.colorAttachment.set(e.texture);}l.bindFramebuffer.set(m.framebuffer),l.viewport.set([0,0,d,d]),e.useProgram("hillshadePrepare").draw(l,c.TRIANGLES,a,s,n,Ut.disabled,Zi(o.tileID,u),null,null,r.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),o.needsHillshadePrepare=!1;}}(e,i,r,o,c,Vt.disabled,h),n.viewport.set([0,0,e.width,e.height]);else if("translucent"===e.renderPass)if(l){const[t,a,n]=e.stencilConfigForOverlapTwoPass(r);ur(e,i,o,n,t,c,h,!1,s),ur(e,i,o,n,a,c,h,!0,s);}else {const[t,a]=e.getStencilConfigForOverlapAndUpdateStencilID(r);ur(e,i,o,a,t,c,h,!1,s);}}(e,i,o,r,a):t.ci(o)?function(e,t,i,o,r){if("translucent"!==e.renderPass)return;if(!o.length)return;const{isRenderingToTexture:a}=r,s=e.style.projection.useSubdivision,n=e.getDepthModeForSublayer(0,Zt.ReadOnly),l=e.colorModeForRenderPass();if(s){const[r,s,c]=e.stencilConfigForOverlapTwoPass(o);dr(e,t,i,c,r,n,l,!1,a),dr(e,t,i,c,s,n,l,!0,a);}else {const[r,s]=e.getStencilConfigForOverlapAndUpdateStencilID(o);dr(e,t,i,s,r,n,l,!1,a);}}(e,i,o,r,a):t.cj(o)?function(e,t,i,o,r){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!o.length)return;const{isRenderingToTexture:a}=r,s=t.getSource(),n=e.style.projection.useSubdivision;if(s instanceof X)pr(e,t,i,o,null,!1,!1,s.tileCoords,s.flippedWindingOrder,a);else if(n){const[r,s,n]=e.stencilConfigForOverlapTwoPass(o);pr(e,t,i,n,r,!1,!0,_r,!1,a),pr(e,t,i,n,s,!0,!0,_r,!1,a);}else {const[r,s]=e.getStencilConfigForOverlapAndUpdateStencilID(o);pr(e,t,i,s,r,!1,!0,_r,!1,a);}}(e,i,o,r,a):t.ck(o)?function(e,t,i,o,r){const a=i.paint.get("background-color"),s=i.paint.get("background-opacity");if(0===s)return;const{isRenderingToTexture:n}=r,l=e.context,c=l.gl,h=e.style.projection,u=e.transform,d=u.tileSize,_=i.paint.get("background-pattern");if(e.isPatternMissing(_))return;const p=!_&&1===a.a&&1===s&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==p)return;const m=Vt.disabled,f=e.getDepthModeForSublayer(0,"opaque"===p?Zt.ReadWrite:Zt.ReadOnly),g=e.colorModeForRenderPass(),v=e.useProgram(_?"backgroundPattern":"background"),b=o||ve(u,{tileSize:d,terrain:e.style.map.terrain});_&&(l.activeTexture.set(c.TEXTURE0),e.imageManager.bind(e.context));const x=i.getCrossfadeParameters();for(const t of b){const o=u.getProjectionData({overscaledTileID:t,applyGlobeMatrix:!n,applyTerrainMatrix:!0}),r=_?oo(s,e,_,{tileID:t,tileSize:d},x):io(s,a),p=e.style.map.terrain&&e.style.map.terrain.getTerrainData(t),b=h.getMeshFromTileID(l,t.canonical,!1,!0,"raster");v.draw(l,c.TRIANGLES,f,m,g,Ut.backCCW,r,p,o,i.id,b.vertexBuffer,b.indexBuffer,b.segments);}}(e,0,o,r,a):t.cl(o)&&function(e,t,i,o){const{isRenderingGlobe:r}=o,a=e.context,s=i.implementation,n=e.style.projection,l=e.transform,c=l.getProjectionDataForCustomLayer(r),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:n.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${n.shaderPreludeCode.vertexSource}`,define:n.shaderDefine},defaultProjectionData:c},u=s.renderingMode?s.renderingMode:"2d";if("offscreen"===e.renderPass){const t=s.prerender;t&&(e.setCustomLayerDefaults(),a.setColorMode(e.colorModeForRenderPass()),t.call(s,a.gl,h),a.setDirty(),e.setBaseState());}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),a.setColorMode(e.colorModeForRenderPass()),a.setStencilMode(Vt.disabled);const t="3d"===u?e.getDepthModeFor3D():e.getDepthModeForSublayer(0,Zt.ReadOnly);a.setDepthMode(t),s.render(a.gl,h),a.setDirty(),e.setBaseState(),a.bindFramebuffer.set(null);}}(e,0,o,a));}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return !1;if(!e.from||!e.to)return !0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return !t||!i}useProgram(e,t,i=!1,o=[]){this.cache=this.cache||{};const r=!!this.style.map.terrain,a=this.style.projection,s=i?xt.projectionMercator:a.shaderPreludeCode,n=i?Pt:a.shaderDefine,l=e+(t?t.cacheKey:"")+`/${i?Ct:a.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(r?"/terrain":"")+(o?`/${o.join("/")}`:"");return this.cache[l]||(this.cache[l]=new Si(this.context,xt[e],t,ao[e],this._showOverdrawInspector,r,s,n,o)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new t.T(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}overLimit(){const{drawingBufferWidth:e,drawingBufferHeight:t}=this.context.gl;return this.width!==e||this.height!==t}}function Sr(e,t){let i,o=!1,r=null,a=null;const s=()=>{r=null,o&&(e.apply(a,i),r=setTimeout(s,t),o=!1);};return (...e)=>(o=!0,a=this,i=e,r||s(),r)}class Er{constructor(e){this._getCurrentHash=()=>{const e=window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map((e=>e.split("="))).forEach((e=>{e[0]===this._hashName&&(t=e);})),(t&&t[1]||"").split("/")}return e.split("/")},this._onHashChange=()=>{const e=this._getCurrentHash();if(!this._isValidHash(e))return !1;const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0},this._updateHashUnthrottled=()=>{const e=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,e);},this._removeHash=()=>{const e=this._getCurrentHash();if(0===e.length)return;const t=e.join("/");let i=t;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${t}`);let o=window.location.hash.replace(i,"");o.startsWith("#&")?o=o.slice(0,1)+o.slice(2):"#"===o&&(o="");let r=window.location.href.replace(/(#.+)?$/,o);r=r.replace("&&","&"),window.history.replaceState(window.history.state,null,r);},this._updateHash=Sr(this._updateHashUnthrottled,300),this._hashName=e&&encodeURIComponent(e);}addTo(e){return this._map=e,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(e){const t=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,o=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),r=Math.pow(10,o),a=Math.round(t.lng*r)/r,s=Math.round(t.lat*r)/r,n=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=e?`/${a}/${s}/${i}`:`${i}/${s}/${a}`,(n||l)&&(c+="/"+Math.round(10*n)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const e=this._hashName;let t=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const o=i.split("=")[0];return o===e?(t=!0,`${o}=${c}`):i})).filter((e=>e));return t||i.push(`${e}=${c}`),`#${i.join("&")}`}return `#${c}`}_isValidHash(e){if(e.length<3||e.some(isNaN))return !1;try{new t.S(+e[2],+e[1]);}catch(e){return !1}const i=+e[0],o=+(e[3]||0),r=+(e[4]||0);return i>=this._map.getMinZoom()&&i<=this._map.getMaxZoom()&&o>=-180&&o<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const Rr={linearity:.3,easing:t.cm(0,0,.3,1)},zr=t.e({deceleration:2500,maxSpeed:1400},Rr),Dr=t.e({deceleration:20,maxSpeed:1400},Rr),Ar=t.e({deceleration:1e3,maxSpeed:360},Rr),Lr=t.e({deceleration:1e3,maxSpeed:90},Rr),kr=t.e({deceleration:1e3,maxSpeed:360},Rr);class Fr{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:s.now(),settings:e});}_drainInertiaBuffer(){const e=this._inertiaBuffer,t=s.now();for(;e.length>0&&t-e[0].time>160;)e.shift();}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,roll:0,pan:new t.P(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,i.roll+=e.rollDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const o=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(i.pan.mag()){const a=Or(i.pan.mag(),o,t.e({},zr,e||{})),s=i.pan.mult(a.amount/i.pan.mag()),n=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=n.easingCenter,r.offset=n.easingOffset,Br(r,a);}if(i.zoom){const e=Or(i.zoom,o,Dr);r.zoom=this._map.transform.zoom+e.amount,Br(r,e);}if(i.bearing){const e=Or(i.bearing,o,Ar);r.bearing=this._map.transform.bearing+t.ah(e.amount,-179,179),Br(r,e);}if(i.pitch){const e=Or(i.pitch,o,Lr);r.pitch=this._map.transform.pitch+e.amount,Br(r,e);}if(i.roll){const e=Or(i.roll,o,kr);r.roll=this._map.transform.roll+t.ah(e.amount,-179,179),Br(r,e);}if(r.zoom||r.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),t.e(r,{noMoveStart:!0})}}function Br(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function Or(e,i,o){const{maxSpeed:r,linearity:a,deceleration:s}=o,n=t.ah(e*a/(i/1e3),-r,r),l=Math.abs(n)/(s*a);return {easing:o.easing,duration:1e3*l,amount:n*(l/2)}}class jr extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,o,r={}){o=o instanceof MouseEvent?o:new MouseEvent(e,o);const a=n.mousePos(i.getCanvas(),o),s=i.unproject(a);super(e,t.e({point:a,lngLat:s,originalEvent:o},r)),this._defaultPrevented=!1,this.target=i;}}class Nr extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,o){const r="touchend"===e?o.changedTouches:o.touches,a=n.touchPos(i.getCanvasContainer(),r),s=a.map((e=>i.unproject(e))),l=a.reduce(((e,t,i,o)=>e.add(t.div(o.length))),new t.P(0,0));super(e,{points:a,point:l,lngLats:s,lngLat:i.unproject(l),originalEvent:o}),this._defaultPrevented=!1;}}class Ur extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class Zr{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){delete this._mousedownPos;}wheel(e){return this._firePreventable(new Ur(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new jr(e.type,this._map,e))}mouseup(e){this._map.fire(new jr(e.type,this._map,e));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||this._map.fire(new jr(e.type,this._map,e));}dblclick(e){return this._firePreventable(new jr(e.type,this._map,e))}mouseover(e){this._map.fire(new jr(e.type,this._map,e));}mouseout(e){this._map.fire(new jr(e.type,this._map,e));}touchstart(e){return this._firePreventable(new Nr(e.type,this._map,e))}touchmove(e){this._map.fire(new Nr(e.type,this._map,e));}touchend(e){this._map.fire(new Nr(e.type,this._map,e));}touchcancel(e){this._map.fire(new Nr(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Gr{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent;}mousemove(e){this._map.fire(new jr(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new jr("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._ignoreContextMenu||this._map.fire(new jr(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Vr{constructor(e){this._map=e;}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return {lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this._map.terrain)}}class $r{constructor(e,t){this._map=e,this._tr=new Vr(e),this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(n.disableDrag(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const o=this._startPos;this._lastPos=i,this._box||(this._box=n.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",e));const r=Math.min(o.x,i.x),a=Math.max(o.x,i.x),s=Math.min(o.y,i.y),l=Math.max(o.y,i.y);n.setTransform(this._box,`translate(${r}px,${s}px)`),this._box.style.width=a-r+"px",this._box.style.height=l-s+"px";}mouseupWindow(e,i){if(!this._active)return;if(0!==e.button)return;const o=this._startPos,r=i;if(this.reset(),n.suppressClick(),o.x!==r.x||o.y!==r.y)return this._map.fire(new t.l("boxzoomend",{originalEvent:e})),{cameraAnimation:e=>e.fitScreenCoordinates(o,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",e);}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(n.remove(this._box),this._box=null),n.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(e,i){return this._map.fire(new t.l(e,{originalEvent:i}))}}function qr(e,t){if(e.length!==t.length)throw new Error(`The number of touches and points are not equal - touches ${e.length}, points ${t.length}`);const i={};for(let o=0;o<e.length;o++)i[e[o].identifier]=t[o];return i}class Wr{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(e,i,o){(this.centroid||o.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),o.length===this.numTouches&&(this.centroid=function(e){const i=new t.P(0,0);for(const t of e)i._add(t);return i.div(e.length)}(i),this.touches=qr(o,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const o=qr(i,t);for(const e in this.touches){const t=o[e];(!t||t.dist(this.touches[e])>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class Hr{constructor(e){this.singleTap=new Wr(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const o=this.singleTap.touchend(e,t,i);if(o){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(o)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=o,this.count===this.numTaps)return this.reset(),o}}}class Xr{constructor(e){this._tr=new Vr(e),this._zoomIn=new Hr({numTouches:1,numTaps:2}),this._zoomOut=new Hr({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const o=this._zoomIn.touchend(e,t,i),r=this._zoomOut.touchend(e,t,i),a=this._tr;return o?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:a.zoom+1,around:a.unproject(o)},{originalEvent:e})}):r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:a.zoom-1,around:a.unproject(r)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Kr{constructor(e){this._enabled=!!e.enable,this._moveStateManager=e.moveStateManager,this._clickTolerance=e.clickTolerance||1,this._moveFunction=e.move,this._activateOnStart=!!e.activateOnStart,e.assignEvents(this),this.reset();}reset(e){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(e);}_move(...e){const t=this._moveFunction(...e);if(t.bearingDelta||t.pitchDelta||t.rollDelta||t.around||t.panDelta)return this._active=!0,t}dragStart(e,t){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(e)&&(this._moveStateManager.startMove(e),this._lastPoint=Array.isArray(t)?t[0]:t,this._activateOnStart&&this._lastPoint&&(this._active=!0));}dragMove(e,t){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(e.preventDefault(),!this._moveStateManager.isValidMoveEvent(e))return void this.reset(e);const o=Array.isArray(t)?t[0]:t;return !this._moved&&o.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=o,this._move(i,o))}dragEnd(e){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(e)&&(this._moved&&n.suppressClick(),this.reset(e));}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const Yr=0,Qr=2,Jr={[Yr]:1,[Qr]:2};class ea{constructor(e){this._correctEvent=e.checkCorrectEvent;}startMove(e){const t=n.mouseButton(e);this._eventButton=t;}endMove(e){delete this._eventButton;}isValidStartEvent(e){return this._correctEvent(e)}isValidMoveEvent(e){return !function(e,t){const i=Jr[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton)}isValidEndEvent(e){return n.mouseButton(e)===this._eventButton}}class ta{constructor(){this._firstTouch=void 0;}_isOneFingerTouch(e){return 1===e.targetTouches.length}_isSameTouchEvent(e){return e.targetTouches[0].identifier===this._firstTouch}startMove(e){this._firstTouch=e.targetTouches[0].identifier;}endMove(e){delete this._firstTouch;}isValidStartEvent(e){return this._isOneFingerTouch(e)}isValidMoveEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}isValidEndEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}}class ia{constructor(e=new ea({checkCorrectEvent:()=>!0}),t=new ta){this.mouseMoveStateManager=e,this.oneFingerTouchMoveStateManager=t;}_executeRelevantHandler(e,t,i){return e instanceof MouseEvent?t(e):"undefined"!=typeof TouchEvent&&e instanceof TouchEvent?i(e):void 0}startMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.startMove(e)),(e=>this.oneFingerTouchMoveStateManager.startMove(e)));}endMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.endMove(e)),(e=>this.oneFingerTouchMoveStateManager.endMove(e)));}isValidStartEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidStartEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidStartEvent(e)))}isValidMoveEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidMoveEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(e)))}isValidEndEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidEndEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidEndEvent(e)))}}const oa=e=>{e.mousedown=e.dragStart,e.mousemoveWindow=e.dragMove,e.mouseup=e.dragEnd,e.contextmenu=e=>{e.preventDefault();};};class ra{constructor(e,t){this._clickTolerance=e.clickTolerance||1,this._map=t,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new t.P(0,0);}_shouldBePrevented(e){return e<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active){if(!this._shouldBePrevented(i.length))return e.preventDefault(),this._calculateTransform(e,t,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",e);}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&this._shouldBePrevented(i.length)&&this.reset();}touchcancel(){this.reset();}_calculateTransform(e,i,o){o.length>0&&(this._active=!0);const r=qr(o,i),a=new t.P(0,0),s=new t.P(0,0);let n=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(a._add(t),s._add(t.sub(i)),n++,r[e]=t);}if(this._touches=r,this._shouldBePrevented(n)||!s.mag())return;const l=s.div(n);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:a.div(n),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class aa{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[o,r]=this._firstTwoTouches,a=sa(i,t,o),s=sa(i,t,r);if(!a||!s)return;const n=this._aroundCenter?null:a.add(s).div(2);return this._move([a,s],n,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[o,r]=this._firstTwoTouches,a=sa(i,t,o),s=sa(i,t,r);a&&s||(this._active&&n.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}}function sa(e,t,i){for(let o=0;o<e.length;o++)if(e[o].identifier===i)return t[o]}function na(e,t){return Math.log(e/t)/Math.LN2}class la extends aa{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(na(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:na(this._distance,i),pinchAround:t}}}function ca(e,t){return 180*e.angleWith(t)/Math.PI}class ha extends aa{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t,i){const o=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:ca(this._vector,o),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=ca(e,this._startVector);return Math.abs(i)<t}}function ua(e){return Math.abs(e.y)>Math.abs(e.x)}class da extends aa{constructor(e){super(),this._currentTouchCount=0,this._map=e;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}touchstart(e,t,i){super.touchstart(e,t,i),this._currentTouchCount=i.length;}_start(e){this._lastPoints=e,ua(e[0].sub(e[1]))&&(this._valid=!1);}_move(e,t,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const o=e[0].sub(this._lastPoints[0]),r=e[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(o,r,i.timeStamp),this._valid?(this._lastPoints=e,this._active=!0,{pitchDelta:(o.y+r.y)/2*-.5}):void 0}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const o=e.mag()>=2,r=t.mag()>=2;if(!o&&!r)return;if(!o||!r)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const a=e.y>0==t.y>0;return ua(e)&&ua(t)&&a}}const _a={panStep:100,bearingStep:15,pitchStep:10};class pa{constructor(e){this._tr=new Vr(e);const t=_a;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,o=0,r=0,a=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),r=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),r=1);break;case 38:e.shiftKey?o=1:(e.preventDefault(),a=-1);break;case 40:e.shiftKey?o=-1:(e.preventDefault(),a=1);break;default:return}return this._rotationDisabled&&(i=0,o=0),{cameraAnimation:s=>{const n=this._tr;s.easeTo({duration:300,easeId:"keyboardHandler",easing:ma,zoom:t?Math.round(n.zoom)+t*(e.shiftKey?2:1):n.zoom,bearing:n.bearing+i*this._bearingStep,pitch:n.pitch+o*this._pitchStep,offset:[-r*this._panStep,-a*this._panStep],center:n.center},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function ma(e){return e*(2-e)}const fa=4.000244140625,ga=1/450;class va{constructor(e,t){this._onTimeout=e=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);},this._map=e,this._tr=new Vr(e),this._triggerRenderFrame=t,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=ga;}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around);}disable(){this.isEnabled()&&(this._enabled=!1);}_shouldBePrevented(e){return !!this._map.cooperativeGestures.isEnabled()&&!(e.ctrlKey||this._map.cooperativeGestures.isBypassed(e))}wheel(e){if(!this.isEnabled())return;if(this._shouldBePrevented(e))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",e);let t=e.deltaMode===WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const i=s.now(),o=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==t&&t%fa==0?this._type="wheel":0!==t&&Math.abs(t)<4?this._type="trackpad":o>400?(this._type=null,this._lastValue=t,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(o*t)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,t+=this._lastValue)),e.shiftKey&&t&&(t/=4),this._type&&(this._lastWheelEvent=e,this._delta-=t,this._active||this._start(e)),e.preventDefault();}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const i=n.mousePos(this._map.getCanvas(),e),o=this._tr;this._aroundPoint=this._aroundCenter?o.transform.locationToScreenPoint(t.S.convert(o.center)):i,this._frameId||(this._frameId=!0,this._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const t=e.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=t),"number"==typeof this._targetZoom&&(this._targetZoom+=t);}if(0!==this._delta){const i="wheel"===this._type&&Math.abs(this._delta)>fa?this._wheelZoomRate:this._defaultZoomRate;let o=2/(1+Math.exp(-Math.abs(this._delta*i)));this._delta<0&&0!==o&&(o=1/o);const r="number"!=typeof this._targetZoom?e.scale:t.af(this._targetZoom);this._targetZoom=e.getConstrained(e.getCameraLngLat(),t.ak(r*o)).zoom,"wheel"===this._type&&(this._startZoom=e.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0;}const i="number"!=typeof this._targetZoom?e.zoom:this._targetZoom,o=this._startZoom,r=this._easing;let a,n=!1;if("wheel"===this._type&&o&&r){const e=s.now()-this._lastWheelEventTime,l=Math.min((e+5)/200,1),c=r(l);a=t.C.number(o,i,c),l<1?this._frameId||(this._frameId=!0):n=!0;}else a=i,n=!0;return this._active=!0,n&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout;}),200)),this._lastExpectedZoom=a,{noInertia:!0,needsRenderFrame:!n,zoomDelta:a-e.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let i=t.co;if(this._prevEase){const e=this._prevEase,o=(s.now()-e.start)/e.duration,r=e.easing(o+.01)-e.easing(o),a=.27/Math.sqrt(r*r+1e-4)*.01,n=Math.sqrt(.0729-a*a);i=t.cm(a,n,.25,1);}return this._prevEase={start:s.now(),duration:e,easing:i},i}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);}}class ba{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class xa{constructor(e){this._tr=new Vr(e),this.reset();}reset(){this._active=!1;}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(e.shiftKey?-1:1),around:this._tr.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class ya{constructor(){this._tap=new Hr({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset();}touchstart(e,t,i){if(!this._swipePoint)if(this._tapTime){const o=t[0],r=e.timeStamp-this._tapTime<500,a=this._tapPoint.dist(o)<30;r&&a?i.length>0&&(this._swipePoint=o,this._swipeTouch=i[0].identifier):this.reset();}else this._tap.touchstart(e,t,i);}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const o=t[0],r=o.y-this._swipePoint.y;return this._swipePoint=o,e.preventDefault(),this._active=!0,{zoomDelta:r/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else {const o=this._tap.touchend(e,t,i);o&&(this._tapTime=e.timeStamp,this._tapPoint=o);}}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class wa{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class Ta{constructor(e,t,i,o){this._pitchWithRotate=e.pitchWithRotate,this._rollEnabled=e.rollEnabled,this._mouseRotate=t,this._mousePitch=i,this._mouseRoll=o;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class Pa{constructor(e,t,i,o){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=o,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}class Ca{constructor(e,t){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=e,this._options=t,this._enabled=!1;}isActive(){return !1}reset(){}_setupUI(){if(this._container)return;const e=this._map.getCanvasContainer();e.classList.add("maplibregl-cooperative-gestures"),this._container=n.create("div","maplibregl-cooperative-gesture-screen",e);let t=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(t=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),o=document.createElement("div");o.className="maplibregl-desktop-message",o.textContent=t,this._container.appendChild(o);const r=document.createElement("div");r.className="maplibregl-mobile-message",r.textContent=i,this._container.appendChild(r),this._container.setAttribute("aria-hidden","true");}_destroyUI(){this._container&&(n.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container;}enable(){this._setupUI(),this._enabled=!0;}disable(){this._enabled=!1,this._destroyUI();}isEnabled(){return this._enabled}isBypassed(e){return e[this._bypassKey]}notifyGestureBlocked(e,i){this._enabled&&(this._map.fire(new t.l("cooperativegestureprevented",{gestureType:e,originalEvent:i})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show");}),100));}}const Ia=e=>e.zoom||e.drag||e.roll||e.pitch||e.rotate;class Ma extends t.l{}function Sa(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta||e.rollDelta}class Ea{constructor(e,i){this.handleWindowEvent=e=>{this.handleEvent(e,`${e.type}Window`);},this.handleEvent=(e,i)=>{if("blur"===e.type)return void this.stop(!0);this._updatingCamera=!0;const o="renderFrame"===e.type?void 0:e,r={needsRenderFrame:!1},a={},s={};for(const{handlerName:l,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;if(this._blockedByActive(s,h,l))c.reset();else if(c[i||e.type]){if(t.cp(e,i||e.type)){const t=n.mousePos(this._map.getCanvas(),e);u=c[i||e.type](e,t);}else if(t.cq(e,i||e.type)){const t=this._getMapTouches(e.touches),o=n.touchPos(this._map.getCanvas(),t);u=c[i||e.type](e,o,t);}else t.cr(i||e.type)||(u=c[i||e.type](e));this.mergeHandlerResult(r,a,u,l,o),u&&u.needsRenderFrame&&this._triggerRenderFrame();}(u||c.isActive())&&(s[l]=c);}const l={};for(const e in this._previousActiveHandlers)s[e]||(l[e]=o);this._previousActiveHandlers=s,(Object.keys(l).length||Sa(r))&&(this._changes.push([r,a,l]),this._triggerRenderFrame()),(Object.keys(s).length||Sa(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:c}=r;c&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],c(this._map));},this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new Fr(e),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(i);const o=this._el;this._listeners=[[o,"touchstart",{passive:!0}],[o,"touchmove",{passive:!1}],[o,"touchend",void 0],[o,"touchcancel",void 0],[o,"mousedown",void 0],[o,"mousemove",void 0],[o,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[o,"mouseover",void 0],[o,"mouseout",void 0],[o,"dblclick",void 0],[o,"click",void 0],[o,"keydown",{capture:!1}],[o,"keyup",void 0],[o,"wheel",{passive:!1}],[o,"contextmenu",void 0],[window,"blur",void 0]];for(const[e,t,i]of this._listeners)n.addEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}destroy(){for(const[e,t,i]of this._listeners)n.removeEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}_addDefaultHandlers(e){const i=this._map,o=i.getCanvasContainer();this._add("mapEvent",new Zr(i,e));const r=i.boxZoom=new $r(i,e);this._add("boxZoom",r),e.interactive&&e.boxZoom&&r.enable();const a=i.cooperativeGestures=new Ca(i,e.cooperativeGestures);this._add("cooperativeGestures",a),e.cooperativeGestures&&a.enable();const s=new Xr(i),l=new xa(i);i.doubleClickZoom=new ba(l,s),this._add("tapZoom",s),this._add("clickZoom",l),e.interactive&&e.doubleClickZoom&&i.doubleClickZoom.enable();const c=new ya;this._add("tapDragZoom",c);const h=i.touchPitch=new da(i);this._add("touchPitch",h),e.interactive&&e.touchPitch&&i.touchPitch.enable(e.touchPitch);const u=()=>i.project(i.getCenter()),d=function({enable:e,clickTolerance:i,aroundCenter:o=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:a=.8},s){const l=new ea({checkCorrectEvent:e=>0===n.mouseButton(e)&&e.ctrlKey||2===n.mouseButton(e)&&!e.ctrlKey});return new Kr({clickTolerance:i,move:(e,i)=>{const n=s();if(o&&Math.abs(n.y-e.y)>r)return {bearingDelta:t.cn(new t.P(e.x,i.y),i,n)};let l=(i.x-e.x)*a;return o&&i.y<n.y&&(l=-l),{bearingDelta:l}},moveStateManager:l,enable:e,assignEvents:oa})}(e,u),_=function({enable:e,clickTolerance:t,pitchDegreesPerPixelMoved:i=-.5}){const o=new ea({checkCorrectEvent:e=>0===n.mouseButton(e)&&e.ctrlKey||2===n.mouseButton(e)});return new Kr({clickTolerance:t,move:(e,t)=>({pitchDelta:(t.y-e.y)*i}),moveStateManager:o,enable:e,assignEvents:oa})}(e),p=function({enable:e,clickTolerance:t,rollDegreesPerPixelMoved:i=.3},o){const r=new ea({checkCorrectEvent:e=>2===n.mouseButton(e)&&e.ctrlKey});return new Kr({clickTolerance:t,move:(e,t)=>{const r=o();let a=(t.x-e.x)*i;return t.y<r.y&&(a=-a),{rollDelta:a}},moveStateManager:r,enable:e,assignEvents:oa})}(e,u);i.dragRotate=new Ta(e,d,_,p),this._add("mouseRotate",d,["mousePitch"]),this._add("mousePitch",_,["mouseRotate","mouseRoll"]),this._add("mouseRoll",p,["mousePitch"]),e.interactive&&e.dragRotate&&i.dragRotate.enable();const m=function({enable:e,clickTolerance:t}){const i=new ea({checkCorrectEvent:e=>0===n.mouseButton(e)&&!e.ctrlKey});return new Kr({clickTolerance:t,move:(e,t)=>({around:t,panDelta:t.sub(e)}),activateOnStart:!0,moveStateManager:i,enable:e,assignEvents:oa})}(e),f=new ra(e,i);i.dragPan=new wa(o,m,f),this._add("mousePan",m),this._add("touchPan",f,["touchZoom","touchRotate"]),e.interactive&&e.dragPan&&i.dragPan.enable(e.dragPan);const g=new ha,v=new la;i.touchZoomRotate=new Pa(o,v,g,c),this._add("touchRotate",g,["touchPan","touchZoom"]),this._add("touchZoom",v,["touchPan","touchRotate"]),e.interactive&&e.touchZoomRotate&&i.touchZoomRotate.enable(e.touchZoomRotate);const b=i.scrollZoom=new va(i,(()=>this._triggerRenderFrame()));this._add("scrollZoom",b,["mousePan"]),e.interactive&&e.scrollZoom&&i.scrollZoom.enable(e.scrollZoom);const x=i.keyboard=new pa(i);this._add("keyboard",x),e.interactive&&e.keyboard&&i.keyboard.enable(),this._add("blockableMapEvent",new Gr(i));}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(Ia(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const o in e)if(o!==i&&(!t||t.indexOf(o)<0))return !0;return !1}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}mergeHandlerResult(e,i,o,r,a){if(!o)return;t.e(e,o);const s={handlerName:r,originalEvent:o.originalEvent||a};void 0!==o.zoomDelta&&(i.zoom=s),void 0!==o.panDelta&&(i.drag=s),void 0!==o.rollDelta&&(i.roll=s),void 0!==o.pitchDelta&&(i.pitch=s),void 0!==o.bearingDelta&&(i.rotate=s);}_applyChanges(){const e={},i={},o={};for(const[r,a,s]of this._changes)r.panDelta&&(e.panDelta=(e.panDelta||new t.P(0,0))._add(r.panDelta)),r.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(e.rollDelta=(e.rollDelta||0)+r.rollDelta),void 0!==r.around&&(e.around=r.around),void 0!==r.pinchAround&&(e.pinchAround=r.pinchAround),r.noInertia&&(e.noInertia=r.noInertia),t.e(i,a),t.e(o,s);this._updateMapTransform(e,i,o),this._changes=[];}_updateMapTransform(e,t,i){const o=this._map,r=o._getTransformForUpdate(),a=o.terrain;if(!(Sa(e)||a&&this._terrainMovement))return this._fireEvents(t,i,!0);o._stop(!0);let{panDelta:s,zoomDelta:n,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:d}=e;void 0!==d&&(u=d),u=u||o.transform.centerPoint,a&&!r.isPointOnMapSurface(u)&&(u=r.centerPoint);const _={panDelta:s,zoomDelta:n,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!r.isPointOnMapSurface(u)&&(u=r.centerPoint);const p=u.distSqr(r.centerPoint)<.01?r.center:r.screenPointToLocation(s?u.sub(s):u);a?(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(_,r),this._terrainMovement||!t.drag&&!t.zoom?t.drag&&this._terrainMovement?r.setCenter(r.screenPointToLocation(r.centerPoint.sub(s))):this._map.cameraHelper.handleMapControlsPan(_,r,p):(this._terrainMovement=!0,this._map._elevationFreeze=!0,this._map.cameraHelper.handleMapControlsPan(_,r,p))):(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(_,r),this._map.cameraHelper.handleMapControlsPan(_,r,p)),o._applyUpdatedTransform(r),this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(t,i,!0);}_fireEvents(e,i,o){const r=Ia(this._eventsInProgress),a=Ia(e),n={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(n[`${t}start`]=i),this._eventsInProgress[t]=e[t];}!r&&a&&this._fireEvent("movestart",a.originalEvent);for(const e in n)this._fireEvent(e,n[e]);a&&this._fireEvent("move",a.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i);}const l={};let c;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:o}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],c=i[t]||o,l[`${e}end`]=c);}for(const e in l)this._fireEvent(e,l[e]);const h=Ia(this._eventsInProgress),u=(r||a)&&!h;if(u&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const e=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&e.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(e);}if(o&&u){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;!e||!e.essential&&s.prefersReducedMotion?(this._map.fire(new t.l("moveend",{originalEvent:c})),i(this._map.getBearing())&&this._map.resetNorth()):(i(e.bearing||this._map.getBearing())&&(e.bearing=0),e.freezeElevation=!0,this._map.easeTo(e,{originalEvent:c})),this._updatingCamera=!1;}}_fireEvent(e,i){this._map.fire(new t.l(e,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{delete this._frameId,this.handleEvent(new Ma("renderFrame",{timeStamp:e})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class Ra extends t.E{constructor(e,t,i){super(),this._renderFrameCallback=()=>{const e=Math.min((s.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();},this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,this.cameraHelper=t,this.on("moveend",(()=>{delete this._requestedCameraState;}));}migrateProjection(e,t){e.apply(this.transform),this.transform=e,this.cameraHelper=t;}getCenter(){return new t.S(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}getCenterElevation(){return this.transform.elevation}setCenterElevation(e,t){return this.jumpTo({elevation:e},t),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(e){this._centerClampedToGround=e;}panBy(e,i,o){return e=t.P.convert(e).mult(-1),this.panTo(this.transform.center,t.e({offset:e},i),o)}panTo(e,i,o){return this.easeTo(t.e({center:e},i),o)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(e,i,o){return this.easeTo(t.e({zoom:e},i),o)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(e,i){return e!=this.transform.fov&&(this.transform.setFov(e),this.fire(new t.l("movestart",i)).fire(new t.l("move",i)).fire(new t.l("moveend",i))),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(e,i,o){return this.easeTo(t.e({bearing:e},i),o)}resetNorth(e,i){return this.rotateTo(0,t.e({duration:1e3},e),i),this}resetNorthPitch(e,i){return this.easeTo(t.e({bearing:0,pitch:0,roll:0,duration:1e3},e),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}getRoll(){return this.transform.roll}setRoll(e,t){return this.jumpTo({roll:e},t),this}cameraForBounds(e,t){e=G.convert(e).adjustAntiMeridian();const i=t&&t.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),i,t)}_cameraForBoxAndBearing(e,i,o,r){const a={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=t.e({padding:a,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const e=r.padding;r.padding={top:e,bottom:e,right:e,left:e};}const s=t.e(a,r.padding);r.padding=s;const n=this.transform,l=new G(e,i);return this.cameraHelper.cameraForBoxAndBearing(r,s,l,o,n)}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}fitScreenCoordinates(e,i,o,r,a){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(t.P.convert(e)),this.transform.screenPointToLocation(t.P.convert(i)),o,r),r,a)}_fitInternal(e,i,o){return e?(delete(i=t.e(e,i)).padding,i.linear?this.easeTo(i,o):this.flyTo(i,o)):this}jumpTo(e,i){this.stop();const o=this._getTransformForUpdate();let r=!1,a=!1,s=!1;const n=o.zoom;this.cameraHelper.handleJumpToCenterZoom(o,e);const l=o.zoom!==n;return "elevation"in e&&o.elevation!==+e.elevation&&o.setElevation(+e.elevation),"bearing"in e&&o.bearing!==+e.bearing&&(r=!0,o.setBearing(+e.bearing)),"pitch"in e&&o.pitch!==+e.pitch&&(a=!0,o.setPitch(+e.pitch)),"roll"in e&&o.roll!==+e.roll&&(s=!0,o.setRoll(+e.roll)),null==e.padding||o.isPaddingEqual(e.padding)||o.setPadding(e.padding),this._applyUpdatedTransform(o),this.fire(new t.l("movestart",i)).fire(new t.l("move",i)),l&&this.fire(new t.l("zoomstart",i)).fire(new t.l("zoom",i)).fire(new t.l("zoomend",i)),r&&this.fire(new t.l("rotatestart",i)).fire(new t.l("rotate",i)).fire(new t.l("rotateend",i)),a&&this.fire(new t.l("pitchstart",i)).fire(new t.l("pitch",i)).fire(new t.l("pitchend",i)),s&&this.fire(new t.l("rollstart",i)).fire(new t.l("roll",i)).fire(new t.l("rollend",i)),this.fire(new t.l("moveend",i))}calculateCameraOptionsFromTo(e,i,o,r=0){const a=t.a1.fromLngLat(e,i),s=t.a1.fromLngLat(o,r),n=s.x-a.x,l=s.y-a.y,c=s.z-a.z,h=Math.hypot(n,l,c);if(0===h)throw new Error("Can't calculate camera options with same From and To");const u=Math.hypot(n,l),d=t.ak(this.transform.cameraToCenterDistance/h/this.transform.tileSize),_=180*Math.atan2(n,-l)/Math.PI;let p=180*Math.acos(u/h)/Math.PI;return p=c<0?90-p:90+p,{center:s.toLngLat(),elevation:r,zoom:d,pitch:p,bearing:_}}calculateCameraOptionsFromCameraLngLatAltRotation(e,t,i,o,r){const a=this.transform.calculateCenterFromCameraLngLatAlt(e,t,i,o);return {center:a.center,elevation:a.elevation,zoom:a.zoom,bearing:i,pitch:o,roll:r}}easeTo(e,i){this._stop(!1,e.easeId),(!1===(e=t.e({offset:[0,0],duration:500,easing:t.co},e)).animate||!e.essential&&s.prefersReducedMotion)&&(e.duration=0);const o=this._getTransformForUpdate(),r=this.getBearing(),a=o.pitch,n=o.roll,l="bearing"in e?this._normalizeBearing(e.bearing,r):r,c="pitch"in e?+e.pitch:a,h="roll"in e?this._normalizeBearing(e.roll,n):n,u="padding"in e?e.padding:o.padding,d=t.P.convert(e.offset);let _,p;e.around&&(_=t.S.convert(e.around),p=o.locationToScreenPoint(_));const m={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},f=this.cameraHelper.handleEaseTo(o,{bearing:l,pitch:c,roll:h,padding:u,around:_,aroundPoint:p,offsetAsPoint:d,offset:e.offset,zoom:e.zoom,center:e.center});return this._rotating=this._rotating||r!==l,this._pitching=this._pitching||c!==a,this._rolling=this._rolling||h!==n,this._padding=!o.isPaddingEqual(u),this._zooming=this._zooming||f.isZooming,this._easeId=e.easeId,this._prepareEase(i,e.noMoveStart,m),this.terrain&&this._prepareElevation(f.elevationCenter),this._ease((t=>{f.easeFunc(t),this.terrain&&!e.freezeElevation&&this._updateElevation(t),this._applyUpdatedTransform(o),this._fireMoveEvents(i);}),(t=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i,t);}),e),this}_prepareEase(e,i,o={}){this._moving=!0,i||o.moving||this.fire(new t.l("movestart",e)),this._zooming&&!o.zooming&&this.fire(new t.l("zoomstart",e)),this._rotating&&!o.rotating&&this.fire(new t.l("rotatestart",e)),this._pitching&&!o.pitching&&this.fire(new t.l("pitchstart",e)),this._rolling&&!o.rolling&&this.fire(new t.l("rollstart",e));}_prepareElevation(e){this._elevationCenter=e,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(e,this.transform.tileZoom),this._elevationFreeze=!0;}_updateElevation(e){void 0!==this._elevationStart&&void 0!==this._elevationCenter||this._prepareElevation(this.transform.center),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const i=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(e<1&&i!==this._elevationTarget){const t=this._elevationTarget-this._elevationStart;this._elevationStart+=e*(t-(i-(t*e+this._elevationStart))/(1-e)),this._elevationTarget=i;}this.transform.setElevation(t.C.number(this._elevationStart,this._elevationTarget,e));}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain);}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(e){if(!this.terrain&&e.elevation>=0&&e.pitch<=90)return {};const t=e.getCameraLngLat(),i=e.getCameraAltitude(),o=this.terrain?this.terrain.getElevationForLngLatZoom(t,e.zoom):0;if(i<o){const i=this.calculateCameraOptionsFromTo(t,o,e.center,e.elevation);return {pitch:i.pitch,zoom:i.zoom}}return {}}_applyUpdatedTransform(e){const t=[];if(t.push((e=>this._elevateCameraIfInsideTerrain(e))),this.transformCameraUpdate&&t.push((e=>this.transformCameraUpdate(e))),!t.length)return;const i=e.clone();for(const e of t){const t=i.clone(),{center:o,zoom:r,roll:a,pitch:s,bearing:n,elevation:l}=e(t);o&&t.setCenter(o),void 0!==l&&t.setElevation(l),void 0!==r&&t.setZoom(r),void 0!==a&&t.setRoll(a),void 0!==s&&t.setPitch(s),void 0!==n&&t.setBearing(n),i.apply(t);}this.transform.apply(i);}_fireMoveEvents(e){this.fire(new t.l("move",e)),this._zooming&&this.fire(new t.l("zoom",e)),this._rotating&&this.fire(new t.l("rotate",e)),this._pitching&&this.fire(new t.l("pitch",e)),this._rolling&&this.fire(new t.l("roll",e));}_afterEase(e,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId;const o=this._zooming,r=this._rotating,a=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,o&&this.fire(new t.l("zoomend",e)),r&&this.fire(new t.l("rotateend",e)),a&&this.fire(new t.l("pitchend",e)),s&&this.fire(new t.l("rollend",e)),this.fire(new t.l("moveend",e));}flyTo(e,i){if(!e.essential&&s.prefersReducedMotion){const o=t.Q(e,["center","zoom","bearing","pitch","roll","elevation"]);return this.jumpTo(o,i)}this.stop(),e=t.e({offset:[0,0],speed:1.2,curve:1.42,easing:t.co},e);const o=this._getTransformForUpdate(),r=o.bearing,a=o.pitch,n=o.roll,l=o.padding,c="bearing"in e?this._normalizeBearing(e.bearing,r):r,h="pitch"in e?+e.pitch:a,u="roll"in e?this._normalizeBearing(e.roll,n):n,d="padding"in e?e.padding:o.padding,_=t.P.convert(e.offset);let p=o.centerPoint.add(_);const m=o.screenPointToLocation(p),f=this.cameraHelper.handleFlyTo(o,{bearing:c,pitch:h,roll:u,padding:d,locationAtOffset:m,offsetAsPoint:_,center:e.center,minZoom:e.minZoom,zoom:e.zoom});let g=e.curve;const v=Math.max(o.width,o.height),b=v/f.scaleOfZoom,x=f.pixelPathLength;"number"==typeof f.scaleOfMinZoom&&(g=Math.sqrt(v/f.scaleOfMinZoom/x*2));const y=g*g;function w(e){const t=(b*b-v*v+(e?-1:1)*y*y*x*x)/(2*(e?b:v)*y*x);return Math.log(Math.sqrt(t*t+1)-t)}function T(e){return (Math.exp(e)-Math.exp(-e))/2}function P(e){return (Math.exp(e)+Math.exp(-e))/2}const C=w(!1);let I=function(e){return P(C)/P(C+g*e)},M=function(e){return v*((P(C)*(T(t=C+g*e)/P(t))-T(C))/y)/x;var t;},S=(w(!0)-C)/g;if(Math.abs(x)<2e-6||!isFinite(S)){if(Math.abs(v-b)<1e-6)return this.easeTo(e,i);const t=b<v?-1:1;S=Math.abs(Math.log(b/v))/g,M=()=>0,I=e=>Math.exp(t*g*e);}return e.duration="duration"in e?+e.duration:1e3*S/("screenSpeed"in e?+e.screenSpeed/g:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=r!==c,this._pitching=h!==a,this._rolling=u!==n,this._padding=!o.isPaddingEqual(d),this._prepareEase(i,!1),this.terrain&&this._prepareElevation(f.targetCenter),this._ease((s=>{const m=s*S,g=1/I(m),v=M(m);this._rotating&&o.setBearing(t.C.number(r,c,s)),this._pitching&&o.setPitch(t.C.number(a,h,s)),this._rolling&&o.setRoll(t.C.number(n,u,s)),this._padding&&(o.interpolatePadding(l,d,s),p=o.centerPoint.add(_)),f.easeFunc(s,g,v,p),this.terrain&&!e.freezeElevation&&this._updateElevation(s),this._applyUpdatedTransform(o),this._fireMoveEvents(i);}),(()=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i);}),e),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t);}return e||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(e,t,i){!1===i.animate||0===i.duration?(e(1),t()):(this._easeStart=s.now(),this._easeOptions=i,this._onEaseFrame=e,this._onEaseEnd=t,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_normalizeBearing(e,i){e=t.aO(e,-180,180);const o=Math.abs(e-i);return Math.abs(e-360-i)<o&&(e-=360),Math.abs(e+360-i)<o&&(e+=360),e}queryTerrainElevation(e){return this.terrain?this.terrain.getElevationForLngLatZoom(t.S.convert(e),this.transform.tileZoom):null}}const za={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class Da{constructor(e=za){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")));},this._updateData=e=>{!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType&&"terrain"!==e.type||this._updateAttributions();},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"));},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show");},this.options=e;}getDefaultPosition(){return "bottom-right"}onAdd(e){return this._map=e,this._compact=this.options.compact,this._container=n.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=n.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=n.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){n.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.title=i,e.setAttribute("aria-label",i);}_updateAttributions(){if(!this._map.style)return;let e=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=e.concat(this.options.customAttribution.map((e=>"string"!=typeof e?"":e))):"string"==typeof this.options.customAttribution&&e.push(this.options.customAttribution)),this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style.sourceCaches;for(const i in t){const o=t[i];if(o.used||o.usedForTerrain){const t=o.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e=e.filter((e=>String(e).trim())),e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let o=i+1;o<e.length;o++)if(e[o].indexOf(t)>=0)return !1;return !0}));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=n.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null);}}class Aa{constructor(e={}){this._updateCompact=()=>{const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&t.classList.add("maplibregl-compact"):t.classList.remove("maplibregl-compact");}},this.options=e;}getDefaultPosition(){return "bottom-left"}onAdd(e){this._map=e,this._compact=this.options&&this.options.compact,this._container=n.create("div","maplibregl-ctrl");const t=n.create("a","maplibregl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://maplibre.org/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){n.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0;}}class La{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}var ka=t.aJ([{name:"a_pos3d",type:"Int16",components:3}]);class Fa extends t.E{constructor(e){super(),this._lastTilesetChange=s.now(),this.sourceCache=e,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=e._source.tileSize*2**this.deltaZoom,e.usedForTerrain=!0,e.tileSize=this.tileSize;}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null;}update(e,i){this.sourceCache.update(e,i),this._renderableTilesKeys=[];const o={};for(const r of ve(e,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:i,calculateTileZoom:this.sourceCache._source.calculateTileZoom}))o[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),t.bY(r.terrainRttPosMatrix32f,0,t.$,t.$,0,0,1),this._tiles[r.key]=new re(r,this.tileSize),this._lastTilesetChange=s.now());for(const e in this._tiles)o[e]||delete this._tiles[e];}freeRtt(e){for(const t in this._tiles){const i=this._tiles[t];(!e||i.tileID.equals(e)||i.tileID.isChildOf(e)||e.isChildOf(i.tileID))&&(i.rtt=[]);}}getRenderableTiles(){return this._renderableTilesKeys.map((e=>this.getTileByID(e)))}getTileByID(e){return this._tiles[e]}getTerrainCoords(e,t){return t?this._getTerrainCoordsForTileRanges(e,t):this._getTerrainCoordsForRegularTile(e)}_getTerrainCoordsForRegularTile(e){const i={};for(const o of this._renderableTilesKeys){const r=this._tiles[o].tileID,a=e.clone(),s=t.ba();if(r.canonical.equals(e.canonical))t.bY(s,0,t.$,t.$,0,0,1);else if(r.canonical.isChildOf(e.canonical)){const i=r.canonical.z-e.canonical.z,o=r.canonical.x-(r.canonical.x>>i<<i),a=r.canonical.y-(r.canonical.y>>i<<i),n=t.$>>i;t.bY(s,0,n,n,0,0,1),t.M(s,s,[-o*n,-a*n,0]);}else {if(!e.canonical.isChildOf(r.canonical))continue;{const i=e.canonical.z-r.canonical.z,o=e.canonical.x-(e.canonical.x>>i<<i),a=e.canonical.y-(e.canonical.y>>i<<i),n=t.$>>i;t.bY(s,0,t.$,t.$,0,0,1),t.M(s,s,[o*n,a*n,0]),t.N(s,s,[1/2**i,1/2**i,0]);}}a.terrainRttPosMatrix32f=new Float32Array(s),i[o]=a;}return i}_getTerrainCoordsForTileRanges(e,i){const o={};for(const r of this._renderableTilesKeys){const a=this._tiles[r].tileID;if(!this._isWithinTileRanges(a,i))continue;const s=e.clone(),n=t.ba();if(a.canonical.z===e.canonical.z){const i=e.canonical.x-a.canonical.x,o=e.canonical.y-a.canonical.y;t.bY(n,0,t.$,t.$,0,0,1),t.M(n,n,[i*t.$,o*t.$,0]);}else if(a.canonical.z>e.canonical.z){const i=a.canonical.z-e.canonical.z,o=a.canonical.x-(a.canonical.x>>i<<i),r=a.canonical.y-(a.canonical.y>>i<<i),s=e.canonical.x-(a.canonical.x>>i),l=e.canonical.y-(a.canonical.y>>i),c=t.$>>i;t.bY(n,0,c,c,0,0,1),t.M(n,n,[-o*c+s*t.$,-r*c+l*t.$,0]);}else {const i=e.canonical.z-a.canonical.z,o=e.canonical.x-(e.canonical.x>>i<<i),r=e.canonical.y-(e.canonical.y>>i<<i),s=(e.canonical.x>>i)-a.canonical.x,l=(e.canonical.y>>i)-a.canonical.y,c=t.$<<i;t.bY(n,0,c,c,0,0,1),t.M(n,n,[o*t.$+s*c,r*t.$+l*c,0]);}s.terrainRttPosMatrix32f=new Float32Array(n),o[r]=s;}return o}getSourceTile(e,t){const i=this.sourceCache._source;let o=e.overscaledZ-this.deltaZoom;if(o>i.maxzoom&&(o=i.maxzoom),o<i.minzoom)return null;this._sourceTileCache[e.key]||(this._sourceTileCache[e.key]=e.scaledTo(o).key);let r=this.sourceCache.getTileByID(this._sourceTileCache[e.key]);if((!r||!r.dem)&&t)for(;o>=i.minzoom&&(!r||!r.dem);)r=this.sourceCache.getTileByID(e.scaledTo(o--).key);return r}anyTilesAfterTime(e=Date.now()){return this._lastTilesetChange>=e}_isWithinTileRanges(e,t){return t[e.canonical.z]&&e.canonical.x>=t[e.canonical.z].minTileX&&e.canonical.x<=t[e.canonical.z].maxTileX&&e.canonical.y>=t[e.canonical.z].minTileY&&e.canonical.y<=t[e.canonical.z].maxTileY}}class Ba{constructor(e,t,i){this._meshCache={},this.painter=e,this.sourceCache=new Fa(t),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024;}getDEMElevation(e,i,o,r=t.$){var a;if(!(i>=0&&i<r&&o>=0&&o<r))return 0;const s=this.getTerrainData(e),n=null===(a=s.tile)||void 0===a?void 0:a.dem;if(!n)return 0;const l=t.cs([],[i/r*t.$,o/r*t.$],s.u_terrain_matrix),c=[l[0]*n.dim,l[1]*n.dim],h=Math.floor(c[0]),u=Math.floor(c[1]),d=c[0]-h,_=c[1]-u;return n.get(h,u)*(1-d)*(1-_)+n.get(h+1,u)*d*(1-_)+n.get(h,u+1)*(1-d)*_+n.get(h+1,u+1)*d*_}getElevationForLngLatZoom(e,i){if(!t.ct(i,e.wrap()))return 0;const{tileID:o,mercatorX:r,mercatorY:a}=this._getOverscaledTileIDFromLngLatZoom(e,i);return this.getElevation(o,r%t.$,a%t.$,t.$)}getElevation(e,i,o,r=t.$){return this.getDEMElevation(e,i,o,r)*this.exaggeration}getTerrainData(e){if(!this._emptyDemTexture){const e=this.painter.context,i=new t.R({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new t.T(e,i,e.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new t.T(e,new t.R({width:1,height:1}),e.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=t.ag([]);}const i=this.sourceCache.getSourceTile(e,!0);if(i&&i.dem&&(!i.demTexture||i.needsTerrainPrepare)){const e=this.painter.context;i.demTexture=this.painter.getTileTexture(i.dem.stride),i.demTexture?i.demTexture.update(i.dem.getPixels(),{premultiply:!1}):i.demTexture=new t.T(e,i.dem.getPixels(),e.gl.RGBA,{premultiply:!1}),i.demTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),i.needsTerrainPrepare=!1;}const o=i&&i+i.tileID.key+e.key;if(o&&!this._demMatrixCache[o]){const o=this.sourceCache.sourceCache._source.maxzoom;let r=e.canonical.z-i.tileID.canonical.z;e.overscaledZ>e.canonical.z&&(e.canonical.z>=o?r=e.canonical.z-o:t.w("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const a=e.canonical.x-(e.canonical.x>>r<<r),s=e.canonical.y-(e.canonical.y>>r<<r),n=t.cu(new Float64Array(16),[1/(t.$<<r),1/(t.$<<r),0]);t.M(n,n,[a*t.$,s*t.$,0]),this._demMatrixCache[e.key]={matrix:n,coord:e};}return {u_depth:2,u_terrain:3,u_terrain_dim:i&&i.dem&&i.dem.dim||1,u_terrain_matrix:o?this._demMatrixCache[e.key].matrix:this._emptyDemMatrix,u_terrain_unpack:i&&i.dem&&i.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(i&&i.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:i}}getFramebuffer(e){const i=this.painter,o=i.width/devicePixelRatio,r=i.height/devicePixelRatio;return !this._fbo||this._fbo.width===o&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new t.T(i.context,{width:o,height:r,data:null},i.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(i.context.gl.NEAREST,i.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new t.T(i.context,{width:o,height:r,data:null},i.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(i.context.gl.NEAREST,i.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=i.context.createFramebuffer(o,r,!0,!1),this._fbo.depthAttachment.set(i.context.createRenderbuffer(i.context.gl.DEPTH_COMPONENT16,o,r))),this._fbo.colorAttachment.set("coords"===e?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const e=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const i=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let e=0,t=0;e<this._coordsTextureSize;e++)for(let o=0;o<this._coordsTextureSize;o++,t+=4)i[t+0]=255&o,i[t+1]=255&e,i[t+2]=o>>8<<4|e>>8,i[t+3]=0;const o=new t.R({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(i.buffer)),r=new t.T(e,o,e.gl.RGBA,{premultiply:!1});return r.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(e){this.painter.maybeDrawDepthAndCoords(!0);const i=new Uint8Array(4),o=this.painter.context,r=o.gl,a=Math.round(e.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(e.y*this.painter.pixelRatio/devicePixelRatio),n=Math.round(this.painter.height/devicePixelRatio);o.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(a,n-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,i),o.bindFramebuffer.set(null);const l=i[0]+(i[2]>>4<<8),c=i[1]+((15&i[2])<<8),h=this.coordsIndex[255-i[3]],u=h&&this.sourceCache.getTileByID(h);if(!u)return null;const d=this._coordsTextureSize,_=(1<<u.tileID.canonical.z)*d;return new t.a1((u.tileID.canonical.x*d+l)/_+u.tileID.wrap,(u.tileID.canonical.y*d+c)/_,this.getElevation(u.tileID,l,c,d))}depthAtPoint(e){const t=new Uint8Array(4),i=this.painter.context,o=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),o.readPixels(e.x,this.painter.height/devicePixelRatio-e.y-1,1,1,o.RGBA,o.UNSIGNED_BYTE,t),i.bindFramebuffer.set(null),(t[0]/16777216+t[1]/65536+t[2]/256+t[3])/256}getTerrainMesh(e){var i;const o=(null===(i=this.painter.style.projection)||void 0===i?void 0:i.transitionState)>0,r=o&&0===e.canonical.y,a=o&&e.canonical.y===(1<<e.canonical.z)-1,s=`m_${r?"n":""}_${a?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const n=this.painter.context,l=new t.cv,c=new t.aN,h=this.meshSize,u=t.$/h,d=h*h;for(let e=0;e<=h;e++)for(let t=0;t<=h;t++)l.emplaceBack(t*u,e*u,0);for(let e=0;e<d;e+=h+1)for(let t=0;t<h;t++)c.emplaceBack(t+e,h+t+e+1,h+t+e+2),c.emplaceBack(t+e,h+t+e+2,t+e+1);const _=l.length,p=_+(h+1),m=(h+1)*h,f=r?t.bh:0,g=r?0:1,v=a?t.bi:t.$,b=a?0:1;for(let e=0;e<=h;e++)l.emplaceBack(e*u,f,g);for(let e=0;e<=h;e++)l.emplaceBack(e*u,v,b);for(let e=0;e<h;e++)c.emplaceBack(m+e,p+e,p+e+1),c.emplaceBack(m+e,p+e+1,m+e+1),c.emplaceBack(0+e,_+e+1,_+e),c.emplaceBack(0+e,0+e+1,_+e+1);const x=l.length,y=x+2*(h+1);for(const e of [0,1])for(let i=0;i<=h;i++)for(const o of [0,1])l.emplaceBack(e*t.$,i*u,o);for(let e=0;e<2*h;e+=2)c.emplaceBack(x+e,x+e+1,x+e+3),c.emplaceBack(x+e,x+e+3,x+e+2),c.emplaceBack(y+e,y+e+3,y+e+1),c.emplaceBack(y+e,y+e+2,y+e+3);const w=new wt(n.createVertexBuffer(l,ka.members),n.createIndexBuffer(c),t.aM.simpleSegment(0,0,l.length,c.length));return this._meshCache[s]=w,w}getMeshFrameDelta(e){return 2*Math.PI*t.bu/Math.pow(2,Math.max(e,0))/5}getMinTileElevationForLngLatZoom(e,t){var i;const{tileID:o}=this._getOverscaledTileIDFromLngLatZoom(e,t);return null!==(i=this.getMinMaxElevation(o).minElevation)&&void 0!==i?i:0}getMinMaxElevation(e){const t=this.getTerrainData(e).tile,i={minElevation:null,maxElevation:null};return t&&t.dem&&(i.minElevation=t.dem.min*this.exaggeration,i.maxElevation=t.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(e,i){const o=t.a1.fromLngLat(e.wrap()),r=(1<<i)*t.$,a=o.x*r,s=o.y*r,n=Math.floor(a/t.$),l=Math.floor(s/t.$);return {tileID:new t.Z(i,0,i,n,l),mercatorX:a,mercatorY:s}}}class Oa{constructor(e,t,i){this._context=e,this._size=t,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0;}destruct(){for(const e of this._objects)e.texture.destroy(),e.fbo.destroy();}_createObject(e){const i=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),o=new t.T(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return o.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),i.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),i.colorAttachment.set(o.texture),{id:e,fbo:i,texture:o,stamp:-1,inUse:!1}}getObjectForId(e){return this._objects[e]}useObject(e){e.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((t=>e.id!==t)),this._recentlyUsed.push(e.id);}stampObject(e){e.stamp=++this._stamp;}getOrCreateFreeObject(){for(const e of this._recentlyUsed)if(!this._objects[e].inUse)return this._objects[e];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const e=this._createObject(this._objects.length);return this._objects.push(e),e}freeObject(e){e.inUse=!1;}freeAllObjects(){for(const e of this._objects)this.freeObject(e);}isFull(){return !(this._objects.length<this._size)&&!1===this._objects.some((e=>!e.inUse))}}const ja={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class Na{constructor(e,t){this.painter=e,this.terrain=t,this.pool=new Oa(e.context,30,t.sourceCache.tileSize*t.qualityFactor);}destruct(){this.pool.destruct();}getTexture(e){return this.pool.getObjectForId(e.rtt[this._stacks.length-1].id).texture}prepareForRender(e,t){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=e._order.filter((i=>!e._layers[i].isHidden(t))),this._coordsAscending={};for(const t in e.sourceCaches){this._coordsAscending[t]={};const i=e.sourceCaches[t].getVisibleCoordinates(),o=e.sourceCaches[t].getSource(),r=o instanceof X?o.terrainTileRanges:null;for(const e of i){const i=this.terrain.sourceCache.getTerrainCoords(e,r);for(const e in i)this._coordsAscending[t][e]||(this._coordsAscending[t][e]=[]),this._coordsAscending[t][e].push(i[e]);}}this._coordsAscendingStr={};for(const t of e._order){const i=e._layers[t],o=i.source;if(ja[i.type]&&!this._coordsAscendingStr[o]){this._coordsAscendingStr[o]={};for(const e in this._coordsAscending[o])this._coordsAscendingStr[o][e]=this._coordsAscending[o][e].map((e=>e.key)).sort().join();}}for(const e of this._renderableTiles)for(const t in this._coordsAscendingStr){const i=this._coordsAscendingStr[t][e.tileID.key];i&&i!==e.rttCoords[t]&&(e.rtt=[]);}}renderLayer(e,i){if(e.isHidden(this.painter.transform.zoom))return !1;const o=Object.assign(Object.assign({},i),{isRenderingToTexture:!0}),r=e.type,a=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===e.id;if(ja[r]&&(this._prevType&&ja[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(e.id),!s))return !0;if(ja[this._prevType]||ja[r]&&s){this._prevType=r;const e=this._stacks.length-1,i=this._stacks[e]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(Cr(this.painter,this.terrain,this._rttTiles,o),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[e]){const t=this.pool.getObjectForId(r.rtt[e].id);if(t.stamp===r.rtt[e].stamp){this.pool.useObject(t);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[e]={id:s.id,stamp:s.stamp},a.context.bindFramebuffer.set(s.fbo.framebuffer),a.context.clear({color:t.bf.transparent,stencil:0}),a.currentStencilSource=void 0;for(let e=0;e<i.length;e++){const t=a.style._layers[i[e]],n=t.source?this._coordsAscending[t.source][r.tileID.key]:[r.tileID];a.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),a._renderTileClippingMasks(t,n,!0),a.renderLayer(a,a.style.sourceCaches[t.source],t,n,o),t.source&&(r.rttCoords[t.source]=this._coordsAscendingStr[t.source][r.tileID.key]);}}return Cr(this.painter,this.terrain,this._rttTiles,o),this._rttTiles=[],this.pool.freeAllObjects(),ja[r]}return !1}}const Ua={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},Za=i,Ga={hash:!1,interactive:!0,bearingSnap:7,attributionControl:za,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:t.a.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0},Va={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class $a{constructor(e,i,o=!1){this.mousedown=e=>{this.startMove(e,n.mousePos(this.element,e)),n.addEventListener(window,"mousemove",this.mousemove),n.addEventListener(window,"mouseup",this.mouseup);},this.mousemove=e=>{this.move(e,n.mousePos(this.element,e));},this.mouseup=e=>{this._rotatePitchHandler.dragEnd(e),this.offTemp();},this.touchstart=e=>{1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=n.touchPos(this.element,e.targetTouches)[0],this.startMove(e,this._startPos),n.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),n.addEventListener(window,"touchend",this.touchend));},this.touchmove=e=>{1!==e.targetTouches.length?this.reset():(this._lastPos=n.touchPos(this.element,e.targetTouches)[0],this.move(e,this._lastPos));},this.touchend=e=>{0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp();},this.reset=()=>{this._rotatePitchHandler.reset(),delete this._startPos,delete this._lastPos,this.offTemp();},this._clickTolerance=10,this.element=i;const r=new ia;this._rotatePitchHandler=new Kr({clickTolerance:3,move:(e,r)=>{const a=i.getBoundingClientRect(),s=new t.P((a.bottom-a.top)/2,(a.right-a.left)/2);return {bearingDelta:t.cn(new t.P(e.x,r.y),r,s),pitchDelta:o?-.5*(r.y-e.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=e,n.addEventListener(i,"mousedown",this.mousedown),n.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),n.addEventListener(i,"touchcancel",this.reset);}startMove(e,t){this._rotatePitchHandler.dragStart(e,t),n.disableDrag();}move(e,t){const i=this.map,{bearingDelta:o,pitchDelta:r}=this._rotatePitchHandler.dragMove(e,t)||{};o&&i.setBearing(i.getBearing()+o),r&&i.setPitch(i.getPitch()+r);}off(){const e=this.element;n.removeEventListener(e,"mousedown",this.mousedown),n.removeEventListener(e,"touchstart",this.touchstart,{passive:!1}),n.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),n.removeEventListener(window,"touchend",this.touchend),n.removeEventListener(e,"touchcancel",this.reset),this.offTemp();}offTemp(){n.enableDrag(),n.removeEventListener(window,"mousemove",this.mousemove),n.removeEventListener(window,"mouseup",this.mouseup),n.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),n.removeEventListener(window,"touchend",this.touchend);}}let qa;function Wa(e,i,o,r=!1){if(r||!o.getCoveringTilesDetailsProvider().allowWorldCopies())return null==e?void 0:e.wrap();const a=new t.S(e.lng,e.lat);if(e=new t.S(e.lng,e.lat),i){const r=new t.S(e.lng-360,e.lat),a=new t.S(e.lng+360,e.lat),s=o.locationToScreenPoint(e).distSqr(i);o.locationToScreenPoint(r).distSqr(i)<s?e=r:o.locationToScreenPoint(a).distSqr(i)<s&&(e=a);}for(;Math.abs(e.lng-o.center.lng)>180;){const t=o.locationToScreenPoint(e);if(t.x>=0&&t.y>=0&&t.x<=o.width&&t.y<=o.height)break;e.lng>o.center.lng?e.lng-=360:e.lng+=360;}return e.lng!==a.lng&&o.isPointOnMapSurface(o.locationToScreenPoint(e))?e:a}const Ha={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Xa(e,t,i){const o=e.classList;for(const e in Ha)o.remove(`maplibregl-${i}-anchor-${e}`);o.add(`maplibregl-${i}-anchor-${t}`);}class Ka extends t.E{constructor(e){if(super(),this._onKeyPress=e=>{const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();},this._onMapClick=e=>{const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();},this._update=e=>{if(!this._map)return;const t=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==e?void 0:e.type)||"render"===(null==e?void 0:e.type)&&!t)&&this._map.once("render",this._update),this._lngLat=Wa(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let o="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?o="rotateX(0deg)":"map"===this._pitchAlignment&&(o=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||e&&"moveend"!==e.type||(this._pos=this._pos.round()),n.setTransform(this._element,`${Ha[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${o} ${i}`),s.frameAsync(new AbortController).then((()=>{this._updateOpacity(e&&"moveend"===e.type);})).catch((()=>{}));},this._onMove=e=>{if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t;}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new t.l("dragstart"))),this.fire(new t.l("drag")));},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new t.l("dragend")),this._state="inactive";},this._addDragHandler=e=>{this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._offset),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));},this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._subpixelPositioning=e&&e.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,this.setOpacity(null==e?void 0:e.opacity,null==e?void 0:e.opacityWhenCovered),e&&e.element)this._element=e.element,this._offset=t.P.convert(e&&e.offset||[0,0]);else {this._defaultMarker=!0,this._element=n.create("div");const i=n.createNS("http://www.w3.org/2000/svg","svg"),o=41,r=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${o}px`),i.setAttributeNS(null,"width",`${r}px`),i.setAttributeNS(null,"viewBox",`0 0 ${r} ${o}`);const a=n.createNS("http://www.w3.org/2000/svg","g");a.setAttributeNS(null,"stroke","none"),a.setAttributeNS(null,"stroke-width","1"),a.setAttributeNS(null,"fill","none"),a.setAttributeNS(null,"fill-rule","evenodd");const s=n.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const l=n.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const c=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const e of c){const t=n.createNS("http://www.w3.org/2000/svg","ellipse");t.setAttributeNS(null,"opacity","0.04"),t.setAttributeNS(null,"cx","10.5"),t.setAttributeNS(null,"cy","5.80029008"),t.setAttributeNS(null,"rx",e.rx),t.setAttributeNS(null,"ry",e.ry),l.appendChild(t);}const h=n.createNS("http://www.w3.org/2000/svg","g");h.setAttributeNS(null,"fill",this._color);const u=n.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),h.appendChild(u);const d=n.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=n.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const p=n.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const m=n.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=n.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=n.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),m.appendChild(f),m.appendChild(g),s.appendChild(l),s.appendChild(h),s.appendChild(d),s.appendChild(p),s.appendChild(m),i.appendChild(s),i.setAttributeNS(null,"height",o*this._scale+"px"),i.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(i),this._offset=t.P.convert(e&&e.offset||[0,-14]);}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault();})),this._element.addEventListener("mousedown",(e=>{e.preventDefault();})),Xa(this._element,this._anchor,"marker"),e&&e.className)for(const t of e.className.split(" "))this._element.classList.add(t);this._popup=null;}addTo(e){return this.remove(),this._map=e,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",e._getUIString("Marker.Title")),e.getCanvasContainer().appendChild(this._element),e.on("move",this._update),e.on("moveend",this._update),e.on("terrain",this._update),e.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),n.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.S.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,o=Math.abs(i)/Math.SQRT2;e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[o,-1*(t-i+o)],"bottom-right":[-o,-1*(t-i+o)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset;}this._popup=e,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}setSubpixelPositioning(e){return this._subpixelPositioning=e,this}getPopup(){return this._popup}togglePopup(){const e=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:e?(e.isOpen()?e.remove():(e.setLngLat(this._lngLat),e.addTo(this._map)),this):this}_updateOpacity(e=!1){var i,o;const r=null===(i=this._map)||void 0===i?void 0:i.terrain,a=this._map.transform.isLocationOccluded(this._lngLat);if(!r||a){const e=a?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==e&&(this._element.style.opacity=e))}if(e)this._opacityTimeout=null;else {if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null;}),100);}const s=this._map,n=s.terrain.depthAtPoint(this._pos),l=s.terrain.getElevationForLngLatZoom(this._lngLat,s.transform.tileZoom);if(s.transform.lngLatToCameraDepth(this._lngLat,l)-n<.006)return void(this._element.style.opacity=this._opacity);const c=-this._offset.y/s.transform.pixelsPerMeter,h=Math.sin(s.getPitch()*Math.PI/180)*c,u=s.terrain.depthAtPoint(new t.P(this._pos.x,this._pos.y-this._offset.y)),d=s.transform.lngLatToCameraDepth(this._lngLat,l+h)-u>.006;(null===(o=this._popup)||void 0===o?void 0:o.isOpen())&&d&&this._popup.remove(),this._element.style.opacity=d?this._opacityWhenCovered:this._opacity;}getOffset(){return this._offset}setOffset(e){return this._offset=t.P.convert(e),this._update(),this}addClassName(e){this._element.classList.add(e);}removeClassName(e){this._element.classList.remove(e);}toggleClassName(e){return this._element.classList.toggle(e)}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(e,t){return (void 0===this._opacity||void 0===e&&void 0===t)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==e&&(this._opacity=e),void 0!==t&&(this._opacityWhenCovered=t),this._map&&this._updateOpacity(!0),this}}const Ya={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let Qa=0,Ja=!1;const es={maxWidth:100,unit:"metric"};function ts(e,t,i){const o=i&&i.maxWidth||100,r=e._container.clientHeight/2,a=e._container.clientWidth/2,s=e.unproject([a-o/2,r]),n=e.unproject([a+o/2,r]),l=Math.round(e.project(n).x-e.project(s).x),c=Math.min(o,l,e._container.clientWidth),h=s.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?is(t,c,i/5280,e._getUIString("ScaleControl.Miles")):is(t,c,i,e._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?is(t,c,h/1852,e._getUIString("ScaleControl.NauticalMiles")):h>=1e3?is(t,c,h/1e3,e._getUIString("ScaleControl.Kilometers")):is(t,c,h,e._getUIString("ScaleControl.Meters"));}function is(e,t,i,o){const r=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i);e.style.width=t*(r/i)+"px",e.innerHTML=`${r}&nbsp;${o}`;}const os={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0},rs=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function as(e){if(e){if("number"==typeof e){const i=Math.round(Math.abs(e)/Math.SQRT2);return {center:new t.P(0,0),top:new t.P(0,e),"top-left":new t.P(i,i),"top-right":new t.P(-i,i),bottom:new t.P(0,-e),"bottom-left":new t.P(i,-i),"bottom-right":new t.P(-i,-i),left:new t.P(e,0),right:new t.P(-e,0)}}if(e instanceof t.P||Array.isArray(e)){const i=t.P.convert(e);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:t.P.convert(e.center||[0,0]),top:t.P.convert(e.top||[0,0]),"top-left":t.P.convert(e["top-left"]||[0,0]),"top-right":t.P.convert(e["top-right"]||[0,0]),bottom:t.P.convert(e.bottom||[0,0]),"bottom-left":t.P.convert(e["bottom-left"]||[0,0]),"bottom-right":t.P.convert(e["bottom-right"]||[0,0]),left:t.P.convert(e.left||[0,0]),right:t.P.convert(e.right||[0,0])}}return as(new t.P(0,0))}const ss=i;e.AJAXError=t.cz,e.Event=t.l,e.Evented=t.E,e.LngLat=t.S,e.MercatorCoordinate=t.a1,e.Point=t.P,e.addProtocol=t.cA,e.config=t.a,e.removeProtocol=t.cB,e.AttributionControl=Da,e.BoxZoomHandler=$r,e.CanvasSource=Y,e.CooperativeGesturesHandler=Ca,e.DoubleClickZoomHandler=ba,e.DragPanHandler=wa,e.DragRotateHandler=Ta,e.EdgeInsets=Mt,e.FullscreenControl=class extends t.E{constructor(e={}){super(),this._onFullscreenChange=()=>{var e;let t=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(e=null==t?void 0:t.shadowRoot)||void 0===e?void 0:e.fullscreenElement;)t=t.shadowRoot.fullscreenElement;t===this._container!==this._fullscreen&&this._handleFullscreenChange();},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen();},this._fullscreen=!1,e&&e.container&&(e.container instanceof HTMLElement?this._container=e.container:t.w("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange");}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){n.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange);}_setupUI(){const e=this._fullscreenButton=n.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);n.create("span","maplibregl-ctrl-icon",e).setAttribute("aria-hidden","true"),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.title=e;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new t.l("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new t.l("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable());}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen();}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen();}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize();}},e.GeoJSONSource=H,e.GeolocateControl=class extends t.E{constructor(e){super(),this._onSuccess=e=>{if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new t.l("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "BACKGROUND":case "BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new t.l("geolocate",e)),this._finish();}},this._updateCamera=e=>{const i=new t.S(e.coords.longitude,e.coords.latitude),o=e.coords.accuracy,r=this._map.getBearing(),a=t.e({bearing:r},this.options.fitBoundsOptions),s=G.fromLngLat(i,o);this._map.fitBounds(s,a,{geolocateSource:!0});},this._updateMarker=e=>{if(e){const i=new t.S(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=e.coords.accuracy,this._updateCircleRadiusIfNeeded();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();},this._onUpdate=()=>{this._updateCircleRadiusIfNeeded();},this._onError=e=>{if(this._map){if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===e.code&&Ja)return;this.options.trackUserLocation&&this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new t.l("error",e)),this._finish();}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=n.create("button","maplibregl-ctrl-geolocate",this._container),n.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0);},this._finishSetupUI=e=>{if(this._map){if(!1===e){t.w("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=n.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new Ka({element:this._dotElement}),this._circleElement=n.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Ka({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onUpdate),this._map.on("move",this._onUpdate),this._map.on("rotate",this._onUpdate),this._map.on("pitch",this._onUpdate)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{const i=(null==e?void 0:e[0])instanceof ResizeObserverEntry;e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||i||this._map.isZooming()||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new t.l("trackuserlocationend")),this.fire(new t.l("userlocationlostfocus")));}));}},this.options=t.e({},Ya,e);}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return t._(this,arguments,void 0,(function*(e=!1){if(void 0!==qa&&!e)return qa;if(void 0===window.navigator.permissions)return qa=!!window.navigator.geolocation,qa;try{const e=yield window.navigator.permissions.query({name:"geolocation"});qa="denied"!==e.state;}catch(e){qa=!!window.navigator.geolocation;}return qa}))}().then((e=>this._finishSetupUI(e))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),n.remove(this._container),this._map.off("zoom",this._onUpdate),this._map.off("move",this._onUpdate),this._map.off("rotate",this._onUpdate),this._map.off("pitch",this._onUpdate),this._map=void 0,Qa=0,Ja=!1;}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case "WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case "ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadiusIfNeeded(){const e=this._userLocationDotMarker.getLngLat();if(!(this.options.showUserLocation&&this.options.showAccuracyCircle&&this._accuracy&&e))return;const t=this._map.project(e),i=this._map.unproject([t.x+100,t.y]),o=e.distanceTo(i)/100,r=2*this._accuracy/o;this._circleElement.style.width=`${r.toFixed(2)}px`,this._circleElement.style.height=`${r.toFixed(2)}px`;}trigger(){if(!this._setup)return t.w("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case "OFF":this._watchState="WAITING_ACTIVE",this.fire(new t.l("trackuserlocationstart"));break;case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":case "BACKGROUND_ERROR":Qa--,Ja=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new t.l("trackuserlocationend"));break;case "BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new t.l("trackuserlocationstart")),this.fire(new t.l("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case "WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),Qa++,Qa>1?(e={maximumAge:6e5,timeout:0},Ja=!0):(e=this.options.positionOptions,Ja=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e);}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},e.GlobeControl=class{constructor(){this._toggleProjection=()=>{var e;const t=null===(e=this._map.getProjection())||void 0===e?void 0:e.type;this._map.setProjection("mercator"!==t&&t?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon();},this._updateGlobeIcon=()=>{var e;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(e=this._map.getProjection())||void 0===e?void 0:e.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"));};}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=n.create("button","maplibregl-ctrl-globe",this._container),n.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){n.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0;}},e.Hash=Er,e.ImageSource=X,e.KeyboardHandler=pa,e.LngLatBounds=G,e.LogoControl=Aa,e.Map=class extends Ra{constructor(e){var i,o;t.cw.mark(t.cx.create);const r=Object.assign(Object.assign(Object.assign({},Ga),e),{canvasContextAttributes:Object.assign(Object.assign({},Ga.canvasContextAttributes),e.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const a=new Lt,s=new Ot;if(void 0!==r.minZoom&&a.setMinZoom(r.minZoom),void 0!==r.maxZoom&&a.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&a.setMinPitch(r.minPitch),void 0!==r.maxPitch&&a.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&a.setRenderWorldCopies(r.renderWorldCopies),super(a,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new La,this._controls=[],this._mapId=t.a7(),this._contextLost=e=>{e.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new t.l("webglcontextlost",{originalEvent:e}));},this._contextRestored=e=>{this._setupPainter(),this.resize(),this._update(),this.fire(new t.l("webglcontextrestored",{originalEvent:e}));},this._onMapScroll=e=>{if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update();},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},Ua),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this.transformCameraUpdate=r.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=p.addThrottleControl((()=>this.isMoving())),this._requestManager=new m(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else {if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container;}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0);})),this.once("idle",(()=>{this._idleTriggered=!0;})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let e=!1;const t=Sr((e=>{this._trackResize&&!this._removed&&(this.resize(e),this.redraw());}),50);this._resizeObserver=new ResizeObserver((i=>{e?t(i):e=!0;})),this._resizeObserver.observe(this._container);}this.handlers=new Ea(this,r),this._hash=r.hash&&new Er("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,t.e({},r.fitBoundsOptions,{duration:0}))));const n="string"==typeof r.style||!("globe"===(null===(o=null===(i=r.style)||void 0===i?void 0:i.projection)||void 0===o?void 0:o.type));this.resize(null,n),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new Da("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new Aa,r.logoPosition),this.on("style.load",(()=>{if(n||this._resizeTransform(),this.transform.unmodified){const e=t.Q(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(e);}})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new t.l(`${e.dataType}data`,e));})),this.on("dataloading",(e=>{this.fire(new t.l(`${e.dataType}dataloading`,e));})),this.on("dataabort",(e=>{this.fire(new t.l("sourcedataabort",e));}));}_getMapId(){return this._mapId}setGlobalStateProperty(e,t){return this.style.setGlobalStateProperty(e,t),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(e,i){if(void 0===i&&(i=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new t.k(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const o=e.onAdd(this);this._controls.push(e);const r=this._controlPositions[i];return -1!==i.indexOf("bottom")?r.insertBefore(o,r.firstChild):r.appendChild(o),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new t.k(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(e);return i>-1&&this._controls.splice(i,1),e.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}coveringTiles(e){return ve(this.transform,e)}calculateCameraOptionsFromTo(e,t,i,o){return null==o&&this.terrain&&(o=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(e,t,i,o)}resize(e,i=!0){const[o,r]=this._containerDimensions(),a=this._getClampedPixelRatio(o,r);if(this._resizeCanvas(o,r,a),this.painter.resize(o,r,a),this.painter.overLimit()){const e=this.painter.context.gl;this._maxCanvasSize=[e.drawingBufferWidth,e.drawingBufferHeight];const t=this._getClampedPixelRatio(o,r);this._resizeCanvas(o,r,t),this.painter.resize(o,r,t);}this._resizeTransform(i);const s=!this._moving;return s&&(this.stop(),this.fire(new t.l("movestart",e)).fire(new t.l("move",e))),this.fire(new t.l("resize",e)),s&&this.fire(new t.l("moveend",e)),this}_resizeTransform(e=!0){var t;const[i,o]=this._containerDimensions();this.transform.resize(i,o,e),null===(t=this._requestedCameraState)||void 0===t||t.resize(i,o,e);}_getClampedPixelRatio(e,t){const{0:i,1:o}=this._maxCanvasSize,r=this.getPixelRatio(),a=e*r,s=t*r;return Math.min(a>i?i/a:1,s>o?o/s:1)*r}getPixelRatio(){var e;return null!==(e=this._overridePixelRatio)&&void 0!==e?e:devicePixelRatio}setPixelRatio(e){this._overridePixelRatio=e,this.resize();}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds(G.convert(e)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom)return this.transform.setMinZoom(e),this._update(),this.getZoom()<e&&this.setZoom(e),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom)return this.transform.setMaxZoom(e),this._update(),this.getZoom()>e&&this.setZoom(e),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.setMinPitch(e),this._update(),this.getPitch()<e&&this.setPitch(e),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?60:e)>180)throw new Error("maxPitch must be less than or equal to 180");if(e>=this.transform.minPitch)return this.transform.setMaxPitch(e),this._update(),this.getPitch()>e&&this.setPitch(e),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.setRenderWorldCopies(e),this._update()}project(e){return this.transform.locationToScreenPoint(t.S.convert(e),this.style&&this.terrain)}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this.terrain)}isMoving(){var e;return this._moving||(null===(e=this.handlers)||void 0===e?void 0:e.isMoving())}isZooming(){var e;return this._zooming||(null===(e=this.handlers)||void 0===e?void 0:e.isZooming())}isRotating(){var e;return this._rotating||(null===(e=this.handlers)||void 0===e?void 0:e.isRotating())}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let o=!1;const r=r=>{const a=t.filter((e=>this.getLayer(e))),s=0!==a.length?this.queryRenderedFeatures(r.point,{layers:a}):[];s.length?o||(o=!0,i.call(this,new jr(e,this,r.originalEvent,{features:s}))):o=!1;};return {layers:t,listener:i,delegates:{mousemove:r,mouseout:()=>{o=!1;}}}}if("mouseleave"===e||"mouseout"===e){let o=!1;const r=r=>{const a=t.filter((e=>this.getLayer(e)));(0!==a.length?this.queryRenderedFeatures(r.point,{layers:a}):[]).length?o=!0:o&&(o=!1,i.call(this,new jr(e,this,r.originalEvent)));},a=t=>{o&&(o=!1,i.call(this,new jr(e,this,t.originalEvent)));};return {layers:t,listener:i,delegates:{mousemove:r,mouseout:a}}}{const o=e=>{const o=t.filter((e=>this.getLayer(e))),r=0!==o.length?this.queryRenderedFeatures(e.point,{layers:o}):[];r.length&&(e.features=r,i.call(this,e),delete e.features);};return {layers:t,listener:i,delegates:{[e]:o}}}}_saveDelegatedListener(e,t){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(t);}_removeDelegatedListener(e,t,i){if(!this._delegatedListeners||!this._delegatedListeners[e])return;const o=this._delegatedListeners[e];for(let e=0;e<o.length;e++){const r=o[e];if(r.listener===i&&r.layers.length===t.length&&r.layers.every((e=>t.includes(e)))){for(const e in r.delegates)this.off(e,r.delegates[e]);return void o.splice(e,1)}}}on(e,t,i){if(void 0===i)return super.on(e,t);const o="string"==typeof t?[t]:t,r=this._createDelegatedListener(e,o,i);this._saveDelegatedListener(e,r);for(const e in r.delegates)this.on(e,r.delegates[e]);return {unsubscribe:()=>{this._removeDelegatedListener(e,o,i);}}}once(e,t,i){if(void 0===i)return super.once(e,t);const o="string"==typeof t?[t]:t,r=this._createDelegatedListener(e,o,i);for(const t in r.delegates){const a=r.delegates[t];r.delegates[t]=(...t)=>{this._removeDelegatedListener(e,o,i),a(...t);};}this._saveDelegatedListener(e,r);for(const e in r.delegates)this.once(e,r.delegates[e]);return this}off(e,t,i){return void 0===i?super.off(e,t):(this._removeDelegatedListener(e,"string"==typeof t?[t]:t,i),this)}queryRenderedFeatures(e,i){if(!this.style)return [];let o;const r=e instanceof t.P||Array.isArray(e),a=r?e:[[0,0],[this.transform.width,this.transform.height]];if(i=i||(r?{}:e)||{},a instanceof t.P||"number"==typeof a[0])o=[t.P.convert(a)];else {const e=t.P.convert(a[0]),i=t.P.convert(a[1]);o=[e,new t.P(i.x,e.y),i,new t.P(e.x,i.y),e];}return this.style.queryRenderedFeatures(o,i,this.transform)}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(e,i){return !1!==(i=t.e({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&e?(this._diffStyle(e,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(e,i))}setTransformRequest(e){return this._requestManager.setTransformRequest(e),this}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){var i,o;if(t.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(e,t)));const r=this.style&&t.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!e)),e?(this.style=new wi(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e,t,r):this.style.loadJSON(e,t,r),this):(null===(o=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===o||o.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new wi(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(e,i){if("string"==typeof e){const o=this._requestManager.transformRequest(e,"Style");t.j(o,new AbortController).then((e=>{this._updateDiff(e.data,i);})).catch((e=>{e&&this.fire(new t.k(e));}));}else "object"==typeof e&&this._updateDiff(e,i);}_updateDiff(e,i){try{this.style.setState(e,i)&&this._update(!0);}catch(o){t.w(`Unable to perform style diff: ${o.message||o.error||o}.  Rebuilding the style from scratch.`),this._updateStyle(e,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():t.w("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){const i=this.style&&this.style.sourceCaches[e];if(void 0!==i)return i.loaded();this.fire(new t.k(new Error(`There is no source with ID '${e}'`)));}setTerrain(e){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),e){const i=this.style.sourceCaches[e.source];if(!i)throw new Error(`cannot load terrain, because there exists no source with ID: ${e.source}`);null===this.terrain&&i.reload();for(const i in this.style._layers){const o=this.style._layers[i];"hillshade"===o.type&&o.source===e.source&&t.w("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===o.type&&o.source===e.source&&t.w("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.");}this.terrain=new Ba(this.painter,i,e),this.painter.renderToTexture=new Na(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=t=>{var i;"style"===t.dataType?this.terrain.sourceCache.freeRtt():"source"===t.dataType&&t.tile&&(t.sourceId!==e.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=t.source)||void 0===i?void 0:i.type)?this.terrain.sourceCache.freeRtt():this.terrain.sourceCache.freeRtt(t.tile.tileID));},this.style.on("data",this._terrainDataCallback);}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new t.l("terrain",{terrain:e})),this}getTerrain(){var e,t;return null!==(t=null===(e=this.terrain)||void 0===e?void 0:e.options)&&void 0!==t?t:null}areTilesLoaded(){const e=this.style&&this.style.sourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}removeSource(e){return this.style.removeSource(e),this._update(!0)}getSource(e){return this.style.getSource(e)}setSourceTileLodParams(e,t,i){if(i){const o=this.getSource(i);if(!o)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);o.calculateTileZoom=me(Math.max(1,e),Math.max(1,t));}else for(const i in this.style.sourceCaches)this.style.sourceCaches[i].getSource().calculateTileZoom=me(Math.max(1,e),Math.max(1,t));return this._update(!0),this}refreshTiles(e,i){const o=this.style.sourceCaches[e];if(!o)throw new Error(`There is no source cache with ID "${e}", cannot refresh tile`);void 0===i?o.reload(!0):o.refreshTiles(i.map((e=>new t.a4(e.z,e.x,e.y))));}addImage(e,i,o={}){const{pixelRatio:r=1,sdf:a=!1,stretchX:n,stretchY:l,content:c,textFitWidth:h,textFitHeight:u}=o;if(this._lazyInitEmptyStyle(),!(i instanceof HTMLImageElement||t.b(i))){if(void 0===i.width||void 0===i.height)return this.fire(new t.k(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:o,height:s,data:d}=i,_=i;return this.style.addImage(e,{data:new t.R({width:o,height:s},new Uint8Array(d)),pixelRatio:r,stretchX:n,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:a,version:0,userImage:_}),_.onAdd&&_.onAdd(this,e),this}}{const{width:o,height:d,data:_}=s.getImageData(i);this.style.addImage(e,{data:new t.R({width:o,height:d},_),pixelRatio:r,stretchX:n,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:a,version:0});}}updateImage(e,i){const o=this.style.getImage(e);if(!o)return this.fire(new t.k(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=i instanceof HTMLImageElement||t.b(i)?s.getImageData(i):i,{width:a,height:n,data:l}=r;if(void 0===a||void 0===n)return this.fire(new t.k(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(a!==o.data.width||n!==o.data.height)return this.fire(new t.k(new Error("The width and height of the updated image must be that same as the previous version of the image")));const c=!(i instanceof HTMLImageElement||t.b(i));return o.data.replace(l,c),this.style.updateImage(e,o),this}getImage(e){return this.style.getImage(e)}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new t.k(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(e){return p.getImage(this._requestManager.transformRequest(e,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,o={}){return this.style.setPaintProperty(e,t,i,o),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,o={}){return this.style.setLayoutProperty(e,t,i,o),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setGlyphs(e,t={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(e,t),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(e,t,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(e,t,i,(e=>{e||this._update(!0);})),this}removeSprite(e){return this._lazyInitEmptyStyle(),this.style.removeSprite(e),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSprite(e,t,(e=>{e||this._update(!0);})),this}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setSky(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSky(e,t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let e=0,t=0;return this._container&&(e=this._container.clientWidth||400,t=this._container.clientHeight||300),[e,t]}_setupContainer(){const e=this._container;e.classList.add("maplibregl-map");const t=this._canvasContainer=n.create("div","maplibregl-canvas-container",e);this._interactive&&t.classList.add("maplibregl-interactive"),this._canvas=n.create("canvas","maplibregl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),o=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],o);const r=this._controlContainer=n.create("div","maplibregl-control-container",e),a=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{a[e]=n.create("div",`maplibregl-ctrl-${e} `,r);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(e,t,i){this._canvas.width=Math.floor(i*e),this._canvas.height=Math.floor(i*t),this._canvas.style.width=`${e}px`,this._canvas.style.height=`${t}px`;}_setupPainter(){const e=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let t=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{t={requestedAttributes:e},i&&(t.statusMessage=i.statusMessage,t.type=i.type);}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,e):this._canvas.getContext("webgl2",e)||this._canvas.getContext("webgl",e),!i){const e="Failed to initialize WebGL";throw t?(t.message=e,new Error(JSON.stringify(t))):new Error(e)}this.painter=new Mr(i,this.transform),l.testSupport(i);}migrateProjection(e,i){super.migrateProjection(e,i),this.painter.transform=e,this.fire(new t.l("projectiontransition",{newProjection:this.style.projection.name}));}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_render(e){var i,o,r,a,n;const l=this._idleTriggered?this._fadeDuration:0,c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let h=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,i=s.now();this.style.zoomHistory.update(e,i);const o=new t.F(e,{now:i,fadeDuration:l,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition(),globalState:this.style.getGlobalState()}),r=o.crossFadingFactor();1===r&&r===this._crossFadingFactor||(h=!0,this._crossFadingFactor=r),this.style.update(o);}const u=(null===(o=this.style.projection)||void 0===o?void 0:o.transitionState)>0!==c;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(a=this.style.projection)||void 0===a?void 0:a.transitionState,null===(n=this.style.projection)||void 0===n?void 0:n.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||u)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,l,this._crossSourceCollisions,u),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:l,showPadding:this.showPadding}),this.fire(new t.l("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,t.cw.mark(t.cx.load),this.fire(new t.l("load"))),this.style&&(this.style.hasTransitions()||h)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const d=this._sourcesDirty||this._styleDirty||this._placementDirty;return d||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new t.l("idle")),!this._loaded||this._fullyLoaded||d||(this._fullyLoaded=!0,t.cw.mark(t.cx.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var e;this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),p.removeThrottleControl(this._imageQueueHandle),null===(e=this._resizeObserver)||void 0===e||e.disconnect();const i=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==i?void 0:i.loseContext)&&i.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),n.remove(this._canvasContainer),n.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),t.cw.clearMetrics(),this._removed=!0,this.fire(new t.l("remove"));}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,s.frame(this._frameRequest,(e=>{t.cw.frame(e),this._frameRequest=null;try{this._render(e);}catch(e){if(!t.cy(e)&&!function(e){return e.message===qo}(e))throw e}}),(()=>{})));}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update());}get showPadding(){return !!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update());}get repaint(){return !!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(e){this._vertices=e,this._update();}get version(){return Za}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(e){return this._lazyInitEmptyStyle(),this.style.setProjection(e),this._update(!0)}},e.MapMouseEvent=jr,e.MapTouchEvent=Nr,e.MapWheelEvent=Ur,e.Marker=Ka,e.NavigationControl=class{constructor(e){this._updateZoomButtons=()=>{const e=this._map.getZoom(),t=e===this._map.getMaxZoom(),i=e===this._map.getMinZoom();this._zoomInButton.disabled=t,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",t.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`;},this._setButtonTitle=(e,t)=>{const i=this._map._getUIString(`NavigationControl.${t}`);e.title=i,e.setAttribute("aria-label",i);},this.options=t.e({},Va,e),this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(e=>this._map.zoomIn({},{originalEvent:e}))),n.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(e=>this._map.zoomOut({},{originalEvent:e}))),n.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(e=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:e}):this._map.resetNorth({},{originalEvent:e});})),this._compassIcon=n.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"));}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new $a(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){n.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(e,t){const i=n.create("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}},e.Popup=class extends t.E{constructor(e){super(),this._updateOpacity=()=>{void 0!==this.options.locationOccludedOpacity&&(this._container.style.opacity=this._map.transform.isLocationOccluded(this.getLngLat())?`${this.options.locationOccludedOpacity}`:"");},this.remove=()=>(this._content&&n.remove(this._content),this._container&&(n.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new t.l("close"))),this),this._onMouseUp=e=>{this._update(e.point);},this._onMouseMove=e=>{this._update(e.point);},this._onDrag=e=>{this._update(e.point);},this._update=e=>{if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=n.create("div","maplibregl-popup",this._map.getContainer()),this._tip=n.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const e of this.options.className.split(" "))this._container.classList.add(e);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer");}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=Wa(this._lngLat,this._flatPos,this._map.transform,this._trackPointer),this._trackPointer&&!e)return;const t=this._flatPos=this._pos=this._trackPointer&&e?e:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&e?e:this._map.transform.locationToScreenPoint(this._lngLat));let i=this.options.anchor;const o=as(this.options.offset);if(!i){const e=this._container.offsetWidth,r=this._container.offsetHeight;let a;a=t.y+o.bottom.y<r?["top"]:t.y>this._map.transform.height-r?["bottom"]:[],t.x<e/2?a.push("left"):t.x>this._map.transform.width-e/2&&a.push("right"),i=0===a.length?"bottom":a.join("-");}let r=t.add(o[i]);this.options.subpixelPositioning||(r=r.round()),n.setTransform(this._container,`${Ha[i]} translate(${r.x}px,${r.y}px)`),Xa(this._container,i,"popup"),this._updateOpacity();},this._onClose=()=>{this.remove();},this.options=t.e(Object.create(os),e);}addTo(e){return this._map&&this.remove(),this._map=e,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new t.l("open")),this}isOpen(){return !!this._map}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.S.convert(e),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(e){return this.setDOMContent(document.createTextNode(e))}setHTML(e){const t=document.createDocumentFragment(),i=document.createElement("body");let o;for(i.innerHTML=e;o=i.firstChild,o;)t.appendChild(o);return this.setDOMContent(t)}getMaxWidth(){var e;return null===(e=this._container)||void 0===e?void 0:e.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=n.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(e),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(e){return this._container&&this._container.classList.add(e),this}removeClassName(e){return this._container&&this._container.classList.remove(e),this}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){if(this._container)return this._container.classList.toggle(e)}setSubpixelPositioning(e){this.options.subpixelPositioning=e;}_createCloseButton(){this.options.closeButton&&(this._closeButton=n.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(rs);e&&e.focus();}},e.RasterDEMTileSource=W,e.RasterTileSource=q,e.ScaleControl=class{constructor(e){this._onMove=()=>{ts(this._map,this._container,this.options);},this.setUnit=e=>{this.options.unit=e,ts(this._map,this._container,this.options);},this.options=Object.assign(Object.assign({},es),e);}getDefaultPosition(){return "bottom-left"}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-scale",e.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){n.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}},e.ScrollZoomHandler=va,e.Style=wi,e.TerrainControl=class{constructor(e){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon();},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"));},this.options=e;}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=n.create("button","maplibregl-ctrl-terrain",this._container),n.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){n.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0;}},e.TwoFingersTouchPitchHandler=da,e.TwoFingersTouchRotateHandler=ha,e.TwoFingersTouchZoomHandler=la,e.TwoFingersTouchZoomRotateHandler=Pa,e.VectorTileSource=$,e.VideoSource=K,e.addSourceType=(e,i)=>t._(void 0,void 0,void 0,(function*(){if(J(e))throw new Error(`A source type called "${e}" already exists.`);((e,t)=>{Q[e]=t;})(e,i);})),e.clearPrewarmedResources=function(){const e=A;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(R),A=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},e.createTileMesh=Xt,e.getMaxParallelImageRequests=function(){return t.a.MAX_PARALLEL_IMAGE_REQUESTS},e.getRTLTextPluginStatus=function(){return oe().getRTLTextPluginStatus()},e.getVersion=function(){return ss},e.getWorkerCount=function(){return z.workerCount},e.getWorkerUrl=function(){return t.a.WORKER_URL},e.importScriptInWorkers=function(e){return B().broadcast("IS",e)},e.prewarm=function(){k().acquire(R);},e.setMaxParallelImageRequests=function(e){t.a.MAX_PARALLEL_IMAGE_REQUESTS=e;},e.setRTLTextPlugin=function(e,t){return oe().setRTLTextPlugin(e,t)},e.setWorkerCount=function(e){z.workerCount=e;},e.setWorkerUrl=function(e){t.a.WORKER_URL=e;};}));

//
// Our custom intro provides a specialized "define()" function, called by the
// AMD modules below, that sets up the worker blob URL and then executes the
// main module, storing its exported value as 'maplibregl'


var maplibregl$1 = maplibregl;

return maplibregl$1;

}));
//# sourceMappingURL=maplibre-gl.js.map
