# Copyright (c) Metakernel Development Team.
# Distributed under the terms of the Modified BSD License.

from metakernel import Magic


class LSMagicMagic(Magic):
    def line_lsmagic(self) -> None:
        """
        %lsmagic - list the current line and cell magics

        This line magic will list all of the available cell and line
        magics installed in the system and in your personal magic
        folder.

        Example:
            %lsmagic
        """
        line_magics = self.kernel.line_magics.keys()
        cell_magics = self.kernel.cell_magics.keys()

        mp = self.kernel.magic_prefixes["magic"]
        out = [
            "Available line magics:",
            "  ".join(sorted([(mp + lm) for lm in line_magics])),
            "",
            "Available cell magics:",
            "  ".join(sorted([(mp + mp + cm) for cm in cell_magics])),
        ]
        self.kernel.Print("\n".join(out))


def register_magics(kernel) -> None:
    kernel.register_magics(LSMagicMagic)
