"""Provides a convenient StrEnum for Rich color names."""

import sys

if sys.version_info >= (3, 11):
    from enum import StrEnum
else:
    from backports.strenum import StrEnum


class Color(StrEnum):
    """An enumeration of all color names supported by the Rich library.

    Using this enum allows for autocompletion and prevents typos when referencing
    color names. The members can be used for both foreground and background colors.

    Aside from DEFAULT, these colors come from the rich.color.ANSI_COLOR_NAMES dictionary.

    Note: The terminal color settings determines the appearance of the follow 16 colors.

    |                |               |
    |----------------|---------------|
    | BLACK          | BRIGHT_WHITE  |
    | BLUE           | BRIGHT_YELLOW |
    | BRIGHT_BLACK   | CYAN          |
    | BRIGHT_BLUE    | GREEN         |
    | BRIGHT_CYAN    | MAGENTA       |
    | BRIGHT_GREEN   | RED           |
    | BRIGHT_MAGENTA | WHITE         |
    | BRIGHT_RED     | YELLOW        |
    """

    DEFAULT = "default"
    """Represents the terminal's default foreground or background color."""

    AQUAMARINE1 = "aquamarine1"
    AQUAMARINE3 = "aquamarine3"
    BLACK = "black"
    BLUE = "blue"
    BLUE1 = "blue1"
    BLUE3 = "blue3"
    BLUE_VIOLET = "blue_violet"
    BRIGHT_BLACK = "bright_black"
    BRIGHT_BLUE = "bright_blue"
    BRIGHT_CYAN = "bright_cyan"
    BRIGHT_GREEN = "bright_green"
    BRIGHT_MAGENTA = "bright_magenta"
    BRIGHT_RED = "bright_red"
    BRIGHT_WHITE = "bright_white"
    BRIGHT_YELLOW = "bright_yellow"
    CADET_BLUE = "cadet_blue"
    CHARTREUSE1 = "chartreuse1"
    CHARTREUSE2 = "chartreuse2"
    CHARTREUSE3 = "chartreuse3"
    CHARTREUSE4 = "chartreuse4"
    CORNFLOWER_BLUE = "cornflower_blue"
    CORNSILK1 = "cornsilk1"
    CYAN = "cyan"
    CYAN1 = "cyan1"
    CYAN2 = "cyan2"
    CYAN3 = "cyan3"
    DARK_BLUE = "dark_blue"
    DARK_CYAN = "dark_cyan"
    DARK_GOLDENROD = "dark_goldenrod"
    DARK_GREEN = "dark_green"
    DARK_KHAKI = "dark_khaki"
    DARK_MAGENTA = "dark_magenta"
    DARK_OLIVE_GREEN1 = "dark_olive_green1"
    DARK_OLIVE_GREEN2 = "dark_olive_green2"
    DARK_OLIVE_GREEN3 = "dark_olive_green3"
    DARK_ORANGE = "dark_orange"
    DARK_ORANGE3 = "dark_orange3"
    DARK_RED = "dark_red"
    DARK_SEA_GREEN = "dark_sea_green"
    DARK_SEA_GREEN1 = "dark_sea_green1"
    DARK_SEA_GREEN2 = "dark_sea_green2"
    DARK_SEA_GREEN3 = "dark_sea_green3"
    DARK_SEA_GREEN4 = "dark_sea_green4"
    DARK_SLATE_GRAY1 = "dark_slate_gray1"
    DARK_SLATE_GRAY2 = "dark_slate_gray2"
    DARK_SLATE_GRAY3 = "dark_slate_gray3"
    DARK_TURQUOISE = "dark_turquoise"
    DARK_VIOLET = "dark_violet"
    DEEP_PINK1 = "deep_pink1"
    DEEP_PINK2 = "deep_pink2"
    DEEP_PINK3 = "deep_pink3"
    DEEP_PINK4 = "deep_pink4"
    DEEP_SKY_BLUE1 = "deep_sky_blue1"
    DEEP_SKY_BLUE2 = "deep_sky_blue2"
    DEEP_SKY_BLUE3 = "deep_sky_blue3"
    DEEP_SKY_BLUE4 = "deep_sky_blue4"
    DODGER_BLUE1 = "dodger_blue1"
    DODGER_BLUE2 = "dodger_blue2"
    DODGER_BLUE3 = "dodger_blue3"
    GOLD1 = "gold1"
    GOLD3 = "gold3"
    GRAY0 = "gray0"
    GRAY3 = "gray3"
    GRAY7 = "gray7"
    GRAY11 = "gray11"
    GRAY15 = "gray15"
    GRAY19 = "gray19"
    GRAY23 = "gray23"
    GRAY27 = "gray27"
    GRAY30 = "gray30"
    GRAY35 = "gray35"
    GRAY37 = "gray37"
    GRAY39 = "gray39"
    GRAY42 = "gray42"
    GRAY46 = "gray46"
    GRAY50 = "gray50"
    GRAY53 = "gray53"
    GRAY54 = "gray54"
    GRAY58 = "gray58"
    GRAY62 = "gray62"
    GRAY63 = "gray63"
    GRAY66 = "gray66"
    GRAY69 = "gray69"
    GRAY70 = "gray70"
    GRAY74 = "gray74"
    GRAY78 = "gray78"
    GRAY82 = "gray82"
    GRAY84 = "gray84"
    GRAY85 = "gray85"
    GRAY89 = "gray89"
    GRAY93 = "gray93"
    GRAY100 = "gray100"
    GREEN = "green"
    GREEN1 = "green1"
    GREEN3 = "green3"
    GREEN4 = "green4"
    GREEN_YELLOW = "green_yellow"
    GREY0 = "grey0"
    GREY3 = "grey3"
    GREY7 = "grey7"
    GREY11 = "grey11"
    GREY15 = "grey15"
    GREY19 = "grey19"
    GREY23 = "grey23"
    GREY27 = "grey27"
    GREY30 = "grey30"
    GREY35 = "grey35"
    GREY37 = "grey37"
    GREY39 = "grey39"
    GREY42 = "grey42"
    GREY46 = "grey46"
    GREY50 = "grey50"
    GREY53 = "grey53"
    GREY54 = "grey54"
    GREY58 = "grey58"
    GREY62 = "grey62"
    GREY63 = "grey63"
    GREY66 = "grey66"
    GREY69 = "grey69"
    GREY70 = "grey70"
    GREY74 = "grey74"
    GREY78 = "grey78"
    GREY82 = "grey82"
    GREY84 = "grey84"
    GREY85 = "grey85"
    GREY89 = "grey89"
    GREY93 = "grey93"
    GREY100 = "grey100"
    HONEYDEW2 = "honeydew2"
    HOT_PINK = "hot_pink"
    HOT_PINK2 = "hot_pink2"
    HOT_PINK3 = "hot_pink3"
    INDIAN_RED = "indian_red"
    INDIAN_RED1 = "indian_red1"
    KHAKI1 = "khaki1"
    KHAKI3 = "khaki3"
    LIGHT_CORAL = "light_coral"
    LIGHT_CYAN1 = "light_cyan1"
    LIGHT_CYAN3 = "light_cyan3"
    LIGHT_GOLDENROD1 = "light_goldenrod1"
    LIGHT_GOLDENROD2 = "light_goldenrod2"
    LIGHT_GOLDENROD3 = "light_goldenrod3"
    LIGHT_GREEN = "light_green"
    LIGHT_PINK1 = "light_pink1"
    LIGHT_PINK3 = "light_pink3"
    LIGHT_PINK4 = "light_pink4"
    LIGHT_SALMON1 = "light_salmon1"
    LIGHT_SALMON3 = "light_salmon3"
    LIGHT_SEA_GREEN = "light_sea_green"
    LIGHT_SKY_BLUE1 = "light_sky_blue1"
    LIGHT_SKY_BLUE3 = "light_sky_blue3"
    LIGHT_SLATE_BLUE = "light_slate_blue"
    LIGHT_SLATE_GRAY = "light_slate_gray"
    LIGHT_SLATE_GREY = "light_slate_grey"
    LIGHT_STEEL_BLUE = "light_steel_blue"
    LIGHT_STEEL_BLUE1 = "light_steel_blue1"
    LIGHT_STEEL_BLUE3 = "light_steel_blue3"
    LIGHT_YELLOW3 = "light_yellow3"
    MAGENTA = "magenta"
    MAGENTA1 = "magenta1"
    MAGENTA2 = "magenta2"
    MAGENTA3 = "magenta3"
    MEDIUM_ORCHID = "medium_orchid"
    MEDIUM_ORCHID1 = "medium_orchid1"
    MEDIUM_ORCHID3 = "medium_orchid3"
    MEDIUM_PURPLE = "medium_purple"
    MEDIUM_PURPLE1 = "medium_purple1"
    MEDIUM_PURPLE2 = "medium_purple2"
    MEDIUM_PURPLE3 = "medium_purple3"
    MEDIUM_PURPLE4 = "medium_purple4"
    MEDIUM_SPRING_GREEN = "medium_spring_green"
    MEDIUM_TURQUOISE = "medium_turquoise"
    MEDIUM_VIOLET_RED = "medium_violet_red"
    MISTY_ROSE1 = "misty_rose1"
    MISTY_ROSE3 = "misty_rose3"
    NAVAJO_WHITE1 = "navajo_white1"
    NAVAJO_WHITE3 = "navajo_white3"
    NAVY_BLUE = "navy_blue"
    ORANGE1 = "orange1"
    ORANGE3 = "orange3"
    ORANGE4 = "orange4"
    ORANGE_RED1 = "orange_red1"
    ORCHID = "orchid"
    ORCHID1 = "orchid1"
    ORCHID2 = "orchid2"
    PALE_GREEN1 = "pale_green1"
    PALE_GREEN3 = "pale_green3"
    PALE_TURQUOISE1 = "pale_turquoise1"
    PALE_TURQUOISE4 = "pale_turquoise4"
    PALE_VIOLET_RED1 = "pale_violet_red1"
    PINK1 = "pink1"
    PINK3 = "pink3"
    PLUM1 = "plum1"
    PLUM2 = "plum2"
    PLUM3 = "plum3"
    PLUM4 = "plum4"
    PURPLE = "purple"
    PURPLE3 = "purple3"
    PURPLE4 = "purple4"
    RED = "red"
    RED1 = "red1"
    RED3 = "red3"
    ROSY_BROWN = "rosy_brown"
    ROYAL_BLUE1 = "royal_blue1"
    SALMON1 = "salmon1"
    SANDY_BROWN = "sandy_brown"
    SEA_GREEN1 = "sea_green1"
    SEA_GREEN2 = "sea_green2"
    SEA_GREEN3 = "sea_green3"
    SKY_BLUE1 = "sky_blue1"
    SKY_BLUE2 = "sky_blue2"
    SKY_BLUE3 = "sky_blue3"
    SLATE_BLUE1 = "slate_blue1"
    SLATE_BLUE3 = "slate_blue3"
    SPRING_GREEN1 = "spring_green1"
    SPRING_GREEN2 = "spring_green2"
    SPRING_GREEN3 = "spring_green3"
    SPRING_GREEN4 = "spring_green4"
    STEEL_BLUE = "steel_blue"
    STEEL_BLUE1 = "steel_blue1"
    STEEL_BLUE3 = "steel_blue3"
    TAN = "tan"
    THISTLE1 = "thistle1"
    THISTLE3 = "thistle3"
    TURQUOISE2 = "turquoise2"
    TURQUOISE4 = "turquoise4"
    VIOLET = "violet"
    WHEAT1 = "wheat1"
    WHEAT4 = "wheat4"
    WHITE = "white"
    YELLOW = "yellow"
    YELLOW1 = "yellow1"
    YELLOW2 = "yellow2"
    YELLOW3 = "yellow3"
    YELLOW4 = "yellow4"
