""" mxNumber - Arbitrary precision numbers provided by GNU MP (GMP).

    C part of the implementation.

    Copyright (c) 2001-2007, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further information on copyrights,
    or contact the author. All Rights Reserved.
"""
try:
    # On Windows we also distribute the GMP DLL (in the win32 subdir). To
    # have Win32 find the DLL we need to be explicit about the path in
    # sys.path though. This trick works for all startup directories
    # *except* \PythonXX (for some reason this fails), but is not thread
    # safe...
    import sys, os
    if sys.platform[:3] == 'win':
        abspath = os.path.abspath(__path__[0])
        #abspath = os.path.join(abspath, 'win32')
        sys.path.insert(0, abspath)
        from mxNumber import *
        sys.path.remove(abspath)

    else:
        from mxNumber import *

    # Import the version number too
    from mxNumber import __version__
    
except ImportError, why:
    print "*** You don't have the (right) mxNumber binaries installed !"
    print "    Note that mxNumber needs Python 2.1 or later."
    raise ImportError, why
