/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ooxml.lite;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;

public class OOXMLLiteAgent {
    public static void premain(String string, Instrumentation instrumentation) throws IOException {
        String[] stringArray = (string == null ? "" : string).split("\\|", 2);
        String string2 = stringArray.length >= 1 ? stringArray[0] : "ooxml-lite-report";
        XsbLogger.load(string2 + ".xsb");
        ClazzLogger clazzLogger = new ClazzLogger();
        clazzLogger.load(string2 + ".clazz");
        clazzLogger.setPattern(stringArray.length >= 2 ? stringArray[1] : ".*/schemas/.*");
        instrumentation.addTransformer(clazzLogger);
        new AgentBuilder.Default().type((ElementMatcher)ElementMatchers.named((String)"org.apache.xmlbeans.impl.schema.XsbReader")).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.constructor((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to(XsbLogger.class).andThen((Implementation.Composable)SuperMethodCall.INSTANCE))).installOn(instrumentation);
    }

    static void write(Path path, String string, Set<Integer> set) {
        if (!set.contains(string.hashCode()) && !string.contains("$MockitoMock$")) {
            try {
                Files.write(path, (string + "\n").getBytes(StandardCharsets.ISO_8859_1), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                set.add(string.hashCode());
            }
            catch (IOException iOException) {
                System.out.println("Had unexpected exception: " + iOException);
            }
        }
    }

    public static class XsbLogger {
        private static Path logPath;
        private static final Set<Integer> hashes;

        static void load(String string2) throws IOException {
            logPath = Paths.get(string2, new String[0]);
            if (Files.exists(logPath, new LinkOption[0])) {
                try (Stream<String> stream = Files.lines(logPath);){
                    stream.forEach(string -> hashes.add(string.hashCode()));
                }
            }
        }

        public static void loadXsb(SchemaTypeSystemImpl schemaTypeSystemImpl, String string) {
            OOXMLLiteAgent.write(logPath, string, hashes);
        }

        public static void loadXsb(SchemaTypeSystemImpl schemaTypeSystemImpl, String string, int n) {
            XsbLogger.loadXsb(schemaTypeSystemImpl, string);
        }

        static {
            hashes = new HashSet<Integer>();
        }
    }

    public static class ClazzLogger
    implements ClassFileTransformer {
        Path logPath;
        Pattern includes;
        final Set<Integer> hashes = new HashSet<Integer>();

        void setPattern(String string) {
            this.includes = Pattern.compile(string);
        }

        void load(String string2) throws IOException {
            this.logPath = Paths.get(string2, new String[0]);
            if (Files.exists(this.logPath, new LinkOption[0])) {
                try (Stream<String> stream = Files.lines(this.logPath);){
                    stream.forEach(string -> this.hashes.add(string.hashCode()));
                }
            }
        }

        public byte[] transform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
            if (this.logPath != null && string != null && this.includes.matcher(string).find()) {
                OOXMLLiteAgent.write(this.logPath, string, this.hashes);
            }
            return byArray;
        }
    }
}

