/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xwpf.usermodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class UpdateEmbeddedDoc {
    private XWPFDocument doc;
    private File docFile;
    private static final int SHEET_NUM = 0;
    private static final int ROW_NUM = 0;
    private static final int CELL_NUM = 0;
    private static final double NEW_VALUE = 100.98;
    private static final String BINARY_EXTENSION = "xls";
    private static final String OPENXML_EXTENSION = "xlsx";

    public UpdateEmbeddedDoc(String filename) throws FileNotFoundException, IOException {
        this.docFile = new File(filename);
        if (!this.docFile.exists()) {
            throw new FileNotFoundException("The Word document " + filename + " does not exist.");
        }
        try (FileInputStream fis = new FileInputStream(this.docFile);){
            this.doc = new XWPFDocument((InputStream)fis);
        }
    }

    public void updateEmbeddedDoc() throws OpenXML4JException, IOException {
        List embeddedDocs = this.doc.getAllEmbeddedParts();
        for (PackagePart pPart : embeddedDocs) {
            String ext = pPart.getPartName().getExtension();
            if (!BINARY_EXTENSION.equals(ext) && !OPENXML_EXTENSION.equals(ext)) continue;
            InputStream is = pPart.getInputStream();
            try {
                Workbook workbook = WorkbookFactory.create((InputStream)is);
                try {
                    OutputStream os = pPart.getOutputStream();
                    try {
                        Sheet sheet = workbook.getSheetAt(0);
                        Row row = sheet.getRow(0);
                        Cell cell = row.getCell(0);
                        cell.setCellValue(100.98);
                        workbook.write(os);
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                finally {
                    if (workbook == null) continue;
                    workbook.close();
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        if (!embeddedDocs.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(this.docFile);){
                this.doc.write((OutputStream)fos);
            }
        }
    }

    public void checkUpdatedDoc() throws OpenXML4JException, IOException {
        for (PackagePart pPart : this.doc.getAllEmbeddedParts()) {
            String ext = pPart.getPartName().getExtension();
            if (!BINARY_EXTENSION.equals(ext) && !OPENXML_EXTENSION.equals(ext)) continue;
            InputStream is = pPart.getInputStream();
            try {
                Workbook workbook = WorkbookFactory.create((InputStream)is);
                try {
                    Sheet sheet = workbook.getSheetAt(0);
                    Row row = sheet.getRow(0);
                    Cell cell = row.getCell(0);
                    if (cell.getNumericCellValue() == 100.98) continue;
                    throw new IllegalStateException("Failed to validate document content.");
                }
                finally {
                    if (workbook == null) continue;
                    workbook.close();
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    public static void main(String[] args) throws IOException, OpenXML4JException {
        UpdateEmbeddedDoc ued = new UpdateEmbeddedDoc(args[0]);
        ued.updateEmbeddedDoc();
        ued.checkUpdatedDoc();
    }
}

