/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.InputStream;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class EmbeddedObjects {
    public static void main(String[] args) throws Exception {
        try (XSSFWorkbook workbook = new XSSFWorkbook(args[0]);){
            for (PackagePart pPart : workbook.getAllEmbeddedParts()) {
                String contentType = pPart.getContentType();
                InputStream is = pPart.getInputStream();
                try {
                    InputStream document;
                    switch (contentType) {
                        case "application/vnd.ms-excel": {
                            document = new HSSFWorkbook(is);
                            break;
                        }
                        case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                            document = new XSSFWorkbook(is);
                            break;
                        }
                        case "application/msword": {
                            document = new HWPFDocument(is);
                            break;
                        }
                        case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                            document = new XWPFDocument(is);
                            break;
                        }
                        case "application/vnd.ms-powerpoint": {
                            document = new HSLFSlideShow(is);
                            break;
                        }
                        case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                            document = new XMLSlideShow(is);
                            break;
                        }
                        default: {
                            document = is;
                        }
                    }
                    document.close();
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }
}

