/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hwmf;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.hwmf.draw.HwmfROP2Composite;
import org.apache.poi.hwmf.record.HwmfBinaryRasterOp;
import org.apache.poi.util.Units;

public final class ROP2Table {
    private static final Color[] COLORS = new Color[]{new Color(0, 0, 0), new Color(128, 0, 0), new Color(0, 128, 0), new Color(128, 128, 0), new Color(0, 0, 128), new Color(128, 0, 128), new Color(0, 128, 128), new Color(192, 192, 192), new Color(255, 255, 255), new Color(128, 128, 128), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255), new Color(0, 255, 255)};

    private ROP2Table() {
    }

    public static void main(String[] args) throws IOException {
        int square = 800;
        BufferedImage bi = new BufferedImage(square + 500, square, 2);
        Graphics2D g = bi.createGraphics();
        double space = 0.2;
        double hbar = (double)square / ((double)COLORS.length + space);
        double vbar = (double)square / ((double)COLORS.length + space);
        double y = hbar * space;
        double x = vbar * space;
        double w = (double)square - 2.0 * x;
        double h = (double)square - 2.0 * y;
        Rectangle2D.Double vrect = new Rectangle2D.Double(x, y, vbar * (1.0 - space), h);
        for (Color c : COLORS) {
            g.setColor(c);
            g.fill(vrect);
            g.translate(vbar, 0.0);
        }
        g.setTransform(new AffineTransform());
        g.setFont(new Font("SansSerif", 0, (int)Units.pixelToPoints((double)(hbar * 0.8))));
        Composite comp = g.getComposite();
        Rectangle2D.Double hrect = new Rectangle2D.Double(x, y, w, hbar * (1.0 - space));
        int idx = 0;
        for (HwmfBinaryRasterOp op : HwmfBinaryRasterOp.values()) {
            g.setComposite(comp);
            g.setColor(Color.BLACK);
            g.drawString(op.name(), (int)((double)square + vbar), (int)(hbar * 0.8));
            g.setComposite((Composite)new HwmfROP2Composite(op));
            g.setColor(Color.RED);
            g.fill(hrect);
            g.translate(0.0, hbar);
            ++idx;
        }
        g.dispose();
        ImageIO.write((RenderedImage)bi, "PNG", new File("rop2.png"));
    }
}

