/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Removal;
import org.apache.poi.util.Units;

public abstract class Bitmap
extends HSLFPictureData {
    @Deprecated
    @Removal(version="5.3")
    public Bitmap() {
        this(new EscherContainerRecord(), new EscherBSERecord());
    }

    @Internal
    protected Bitmap(EscherContainerRecord recordContainer, EscherBSERecord bse) {
        super(recordContainer, bse);
    }

    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        int prefixLen = 16 * this.getUIDInstanceCount() + 1;
        return IOUtils.safelyClone((byte[])rawdata, (int)prefixLen, (int)(rawdata.length - prefixLen), (int)rawdata.length);
    }

    @Override
    protected byte[] formatImageForSlideshow(byte[] data) {
        byte[] checksum = Bitmap.getChecksum(data);
        byte[] rawData = new byte[checksum.length * this.getUIDInstanceCount() + 1 + data.length];
        int offset = 0;
        System.arraycopy(checksum, 0, rawData, offset, checksum.length);
        offset += checksum.length;
        if (this.getUIDInstanceCount() == 2) {
            System.arraycopy(checksum, 0, rawData, offset, checksum.length);
            offset += checksum.length;
        }
        System.arraycopy(data, 0, rawData, ++offset, data.length);
        return rawData;
    }

    public Dimension getImageDimension() {
        Dimension dimension;
        block8: {
            UnsynchronizedByteArrayInputStream is = UnsynchronizedByteArrayInputStream.builder().setByteArray(this.getData()).get();
            try {
                BufferedImage bi = ImageIO.read((InputStream)is);
                dimension = new Dimension((int)Units.pixelToPoints((double)bi.getWidth()), (int)Units.pixelToPoints((double)bi.getHeight()));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new Dimension(200, 200);
                }
            }
            is.close();
        }
        return dimension;
    }
}

