/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.util.IOUtils;

public class ByteChunkDeferred
extends ByteChunk {
    private DocumentNode node;

    public ByteChunkDeferred(String namePrefix, int chunkId, Types.MAPIType type) {
        super(namePrefix, chunkId, type);
    }

    public void readValue(DocumentNode node) {
        this.node = node;
    }

    @Override
    public void readValue(InputStream value) throws IOException {
        if (this.node == null) {
            super.readValue(value);
        }
    }

    @Override
    public void writeValue(OutputStream out) throws IOException {
        if (this.node == null) {
            super.writeValue(out);
            return;
        }
        try (DocumentInputStream dis = this.createDocumentInputStream();){
            IOUtils.copy((InputStream)dis, (OutputStream)out);
        }
    }

    @Override
    public byte[] getValue() {
        byte[] byArray;
        block9: {
            if (this.node == null) {
                return super.getValue();
            }
            DocumentInputStream dis = this.createDocumentInputStream();
            try {
                byArray = IOUtils.toByteArray((InputStream)dis, (int)this.node.getSize());
                if (dis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            dis.close();
        }
        return byArray;
    }

    @Override
    public void setValue(byte[] value) {
        this.node = null;
        super.setValue(value);
    }

    private DocumentInputStream createDocumentInputStream() throws IOException {
        return ((DirectoryNode)this.node.getParent()).createDocumentInputStream((Entry)this.node);
    }
}

