=head1 NAME

iPE - Package containing global variables and routines for iPE.

=head1 DESCRIPTION

This is the head of the iPE Estimator code.  The standard entry point is through the script ipestimate, which creates an iPE::Instance object.  This is runnable.  The iPE::Estimator object is the main workhorse.

This module simply holds the version and build date as well as some private C functions.

=over 8

=cut

package iPE;
use Carp;

use base("Exporter", "DynaLoader");
use strict;

our $VERSION = '0.3.1';
our $VERSION_DATE = "26 July 2007";

bootstrap iPE;

our @EXPORT = qw(_levels fast_uc); #c routines

=back

=head1 SEE ALSO

L<iPE::gHMM>, L<iPE::Options>, L<iPE::Estimator>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu).

=cut

1;
