=head1 NAME

iPE::Model::Emission::ISO - Isochore separated emission type.

=head1 DESCRIPTION

This model requires submodels.  It decides which submodel to pass the feature on to based on the isochore of the region in question.

=head1 FUNCTIONS

=cut

package iPE::Model::Emission::ISO;
use base("iPE::Model::Emission");
use strict;

sub init {
    my ($this) = @_;

    my $isostr;
    unless($this->hasSettings) {
        #XXX deprecated.  remove when moving to settings format
        $isostr = $this->data;
        $this->settings->{ISOs} = $isostr;
        $this->settings->{ISOs} =~ s/(\S)\s+(\S)/$1,$2/g;
    }

    $isostr = $this->settings->{ISOs}; 
    die(__PACKAGE__.": The ISOs setting must be set for an ISO model.\n".
        "Error found in ".$this->name.".\n") unless(defined($isostr));
    die(__PACKAGE__.":\nThe format for the ISO setting is a whitespace-free ".
        "comma-separated list of\nisochore values.  For example:\n".
        "    ISOs=43.0,51.0,57.0,100.0\nThe offending string '$isostr' ".
        "was found in model ".$this->name."\n") if($isostr =~ m/[^.,0-9]/);
    $isostr =~ s/,/ /g;
    $this->{ISO_} = new iPE::Model::ISO({ISOs => $isostr});
    die("No isochore level 100 for model ".$this->name."\n")
        if($this->{ISO_}->find_exact(100) == -1);
}

sub ISO { shift->{ISO_} }

sub countRegion {
    my ($this, $region) = @_;

    die "Cannot count an isochore model when no DNA sequence is present.\n"
        if(!defined ($region->feature->gcLevel));
    my $model = $this->ISO->find($region->feature->gcLevel);
    $this->submodels->[$model]->countRegion($region);
}

sub countNullRegion {
    my ($this, $region) = @_;

    die "Cannot count an isochore model when no DNA sequence is present.\n"
        if(!defined ($region->feature->gcLevel));
    my $model = $this->ISO->find($region->feature->gcLevel);
    $this->submodels->[$model]->countNullRegion($region);
    #for my $model (@{$this->submodels}) {
        #$model->countNullRegion($region);
    #}
}

sub getZoeHeaderEnd {
    my ($this) = @_;

    my $end = "\n";
    for my $level (@{$this->ISO->levels}) {
        $end .= "$level ";
    }

    return $end;
}

=head1 SEE ALSO

L<iPE::Model::Emission>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
