/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_fa extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0698\u0627\u0646\u0648\u06cc\u0647\u0654",
               "\u0641\u0648\u0631\u06cc\u0647\u0654",
               "\u0645\u0627\u0631\u0633",
               "\u0622\u0648\u0631\u06cc\u0644",
               "\u0645\u0647\u0654",
               "\u0698\u0648\u0626\u0646",
               "\u0698\u0648\u0626\u06cc\u0647\u0654",
               "\u0627\u0648\u062a",
               "\u0633\u067e\u062a\u0627\u0645\u0628\u0631",
               "\u0627\u06a9\u062a\u0628\u0631",
               "\u0646\u0648\u0627\u0645\u0628\u0631",
               "\u062f\u0633\u0627\u0645\u0628\u0631",
               "",
            };
        final String[] metaValue_standalone_MonthNames = new String[] {
               "\u0698\u0627\u0646\u0648\u06cc\u0647",
               "\u0641\u0648\u0631\u06cc\u0647",
               "\u0645\u0627\u0631\u0633",
               "\u0622\u0648\u0631\u06cc\u0644",
               "\u0645\u0647",
               "\u0698\u0648\u0626\u0646",
               "\u0698\u0648\u0626\u06cc\u0647",
               "\u0627\u0648\u062a",
               "\u0633\u067e\u062a\u0627\u0645\u0628\u0631",
               "\u0627\u06a9\u062a\u0628\u0631",
               "\u0646\u0648\u0627\u0645\u0628\u0631",
               "\u062f\u0633\u0627\u0645\u0628\u0631",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0698",
               "\u0641",
               "\u0645",
               "\u0622",
               "\u0645",
               "\u0698",
               "\u0698",
               "\u0627",
               "\u0633",
               "\u0627",
               "\u0646",
               "\u062f",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u06cc\u06a9\u0634\u0646\u0628\u0647",
               "\u062f\u0648\u0634\u0646\u0628\u0647",
               "\u0633\u0647\u200c\u0634\u0646\u0628\u0647",
               "\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647",
               "\u067e\u0646\u062c\u0634\u0646\u0628\u0647",
               "\u062c\u0645\u0639\u0647",
               "\u0634\u0646\u0628\u0647",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u06cc",
               "\u062f",
               "\u0633",
               "\u0686",
               "\u067e",
               "\u062c",
               "\u0634",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u0633\u0647\u200c\u0645\u0627\u0647\u0647\u0654 \u0627\u0648\u0644",
               "\u0633\u0647\u200c\u0645\u0627\u0647\u0647\u0654 \u062f\u0648\u0645",
               "\u0633\u0647\u200c\u0645\u0627\u0647\u0647\u0654 \u0633\u0648\u0645",
               "\u0633\u0647\u200c\u0645\u0627\u0647\u0647\u0654 \u0686\u0647\u0627\u0631\u0645",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "\u0633\u200c\u0645\u06f1",
               "\u0633\u200c\u0645\u06f2",
               "\u0633\u200c\u0645\u06f3",
               "\u0633\u200c\u0645\u06f4",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "\u06f1",
               "\u06f2",
               "\u06f3",
               "\u06f4",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u0642\u0628\u0644\u200c\u0627\u0632\u0638\u0647\u0631",
               "\u0628\u0639\u062f\u0627\u0632\u0638\u0647\u0631",
               "",
               "",
               "\u0628\u0627\u0645\u062f\u0627\u062f",
               "\u0635\u0628\u062d",
               "\u0638\u0647\u0631",
               "\u0639\u0635\u0631",
               "",
               "",
               "\u0634\u0628",
               "\u0646\u06cc\u0645\u0647\u200c\u0634\u0628",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "\u0642",
               "\u0628",
               "",
               "",
               "\u0628",
               "\u0635",
               "\u0638",
               "\u0639",
               "",
               "",
               "\u0634",
               "\u0646",
            };
        final String[] metaValue_abbreviated_AmPmMarkers = new String[] {
               "\u0642.\u0638.",
               "\u0628.\u0638.",
               "",
               "",
               "\u0628\u0627\u0645\u062f\u0627\u062f",
               "\u0635\u0628\u062d",
               "\u0638\u0647\u0631",
               "\u0639\u0635\u0631",
               "",
               "",
               "\u0634\u0628",
               "\u0646\u06cc\u0645\u0647\u200c\u0634\u0628",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "H:mm:ss (zzzz)",
               "H:mm:ss (z)",
               "H:mm:ss",
               "H:mm",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "\u062a\u0642\u0648\u06cc\u0645 \u0628\u0648\u062f\u0627\u06cc\u06cc",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE d MMMM y G",
               "d MMMM y G",
               "d MMM y G",
               "y/M/d GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE d MMMM y GGGG",
               "d MMMM y GGGG",
               "d MMM y GGGG",
               "y/M/d G",
            };
        final String[] metaValue_java_time_japanese_long_Eras = new String[] {
               "\u0645\u06cc\u0644\u0627\u062f\u06cc",
               "Meiji",
               "Taish\u014d",
               "Sh\u014dwa",
               "\u0647\u06cc\u0633\u06cc",
               "Reiwa",
            };
        final String[] metaValue_java_time_japanese_Eras = new String[] {
               "\u0645.",
               "Meiji",
               "Taish\u014d",
               "Sh\u014dwa",
               "\u0647\u06cc\u0633\u06cc",
               "\u0631\u06cc\u0648\u0627",
            };
        final String[] metaValue_java_time_japanese_narrow_Eras = new String[] {
               "\u0645",
               "M",
               "T",
               "S",
               "\u0647\u200d",
               "\u0631",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "\u0642\u0628\u0644 \u0627\u0632 R.O.C.",
               "\u062a\u0642\u0648\u06cc\u0645 \u0645\u06cc\u0646\u06af\u0648",
            };
        final String[] metaValue_islamic_MonthNames = new String[] {
               "\u0645\u062d\u0631\u0645",
               "\u0635\u0641\u0631",
               "\u0631\u0628\u06cc\u0639\u200c\u0627\u0644\u0627\u0648\u0644",
               "\u0631\u0628\u06cc\u0639\u200c\u0627\u0644\u062b\u0627\u0646\u06cc",
               "\u062c\u0645\u0627\u062f\u06cc\u200c\u0627\u0644\u0627\u0648\u0644",
               "\u062c\u0645\u0627\u062f\u06cc\u200c\u0627\u0644\u062b\u0627\u0646\u06cc",
               "\u0631\u062c\u0628",
               "\u0634\u0639\u0628\u0627\u0646",
               "\u0631\u0645\u0636\u0627\u0646",
               "\u0634\u0648\u0627\u0644",
               "\u0630\u06cc\u0642\u0639\u062f\u0647\u0654",
               "\u0630\u06cc\u062d\u062c\u0647\u0654",
               "",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "\u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc",
            };
        final String[] metaValue_java_time_islamic_Eras = new String[] {
               "",
               "\u0647\u200d.\u0642.",
            };
        final String metaValue_calendarname_gregorian = "\u062a\u0642\u0648\u06cc\u0645 \u0645\u06cc\u0644\u0627\u062f\u06cc";
        final String[] metaValue_arab_NumberPatterns = new String[] {
               "#,##0.###",
               "\u200e\u00a4#,##0.00",
               "#,##0%",
               "",
            };
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "java.time.japanese.narrow.Eras", metaValue_java_time_japanese_narrow_Eras },
            { "field.year", "\u0633\u0627\u0644" },
            { "calendarname.islamic-umalqura", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc \u0627\u0645\u200c\u0627\u0644\u0642\u0631\u06cc" },
            { "arabext.NumberElements",
                new String[] {
                    "\u066b",
                    "\u066c",
                    "\u061b",
                    "\u066a",
                    "\u06f0",
                    "#",
                    "\u200e\u2212",
                    "\u00d7\u06f1\u06f0^",
                    "\u0609",
                    "\u221e",
                    "\u0646\u0627\u0639\u062f\u062f",
                    "",
                    "",
                }
            },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.gmtFormat", "{0} \u06af\u0631\u06cc\u0646\u0648\u06cc\u0686" },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "japanese.narrow.Eras", metaValue_java_time_japanese_narrow_Eras },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc \u062c\u062f\u0648\u0644\u06cc \u0645\u062f\u0646\u06cc" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "narrow.Eras",
                new String[] {
                    "\u0642",
                    "\u0645",
                }
            },
            { "abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "timezone.regionFormat.standard", "\u0648\u0642\u062a \u0639\u0627\u062f\u06cc {0}" },
            { "DefaultNumberingSystem", "arabext" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "calendarname.japanese", "\u062a\u0642\u0648\u06cc\u0645 \u0698\u0627\u067e\u0646\u06cc" },
            { "timezone.gmtZeroFormat", "\u06af\u0631\u06cc\u0646\u0648\u06cc\u0686" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayNames },
            { "roc.MonthAbbreviations", metaValue_MonthNames },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_Eras },
            { "long.Eras",
                new String[] {
                    "\u0642\u0628\u0644 \u0627\u0632 \u0645\u06cc\u0644\u0627\u062f",
                    "\u0645\u06cc\u0644\u0627\u062f\u06cc",
                }
            },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthNames },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1}\u060c \u0633\u0627\u0639\u062a {0}",
                    "{1}\u060c \u0633\u0627\u0639\u062a {0}",
                    "{1}\u060c\u200f {0}",
                    "{1}\u060c\u200f {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "\u200e\u2212",
                    "E",
                    "\u2030",
                    "\u221e",
                    "\u0646\u0627\u0639\u062f\u062f",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u062f\u0642\u06cc\u0642\u0647" },
            { "japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "field.era", "\u062f\u0648\u0631\u0647" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u0642.\u0638/\u0628.\u0638" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames", metaValue_islamic_MonthNames },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "arab.NumberElements",
                new String[] {
                    "\u066b",
                    "\u066c",
                    "\u061b",
                    "\u066a",
                    "\u0660",
                    "#",
                    "\u061c-",
                    "\u0627\u0633",
                    "\u0609",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "calendarname.roc", "\u062a\u0642\u0648\u06cc\u0645 \u062c\u0645\u0647\u0648\u0631\u06cc \u0686\u06cc\u0646 (\u062a\u0627\u06cc\u0648\u0627\u0646)" },
            { "islamic.DatePatterns",
                new String[] {
                    "EEEE d MMMM y GGGG",
                    "d MMMM y GGGG",
                    "d MMM y GGGG",
                    "y/M/d GGGG",
                }
            },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.Eras", metaValue_java_time_islamic_Eras },
            { "field.month", "\u0645\u0627\u0647" },
            { "arabext.NumberPatterns", metaValue_arab_NumberPatterns },
            { "java.time.japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.second", "\u062b\u0627\u0646\u06cc\u0647" },
            { "islamic.MonthNarrows",
                new String[] {
                    "\u0645",
                    "\u0635",
                    "\u0631",
                    "\u0631",
                    "\u062c",
                    "\u062c",
                    "\u0631",
                    "\u0634",
                    "\u0631",
                    "\u0634",
                    "\u0630",
                    "\u0630",
                    "",
                }
            },
            { "DayAbbreviations", metaValue_DayNames },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "DayPeriodRules", "night1:19:00-24:00;morning2:04:00-12:00;afternoon1:12:00-13:00;morning1:01:00-04:00;afternoon2:13:00-19:00;night2:00:00-01:00" },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_standalone_MonthNames },
            { "timezone.regionFormat", "\u0648\u0642\u062a {0}" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u0647\u0632\u0627\u0631 other:0' '\u0647\u0632\u0627\u0631}",
                    "{one:00' '\u0647\u0632\u0627\u0631 other:00' '\u0647\u0632\u0627\u0631}",
                    "{one:000' '\u0647\u0632\u0627\u0631 other:000' '\u0647\u0632\u0627\u0631}",
                    "{one:0' '\u0645\u06cc\u0644\u06cc\u0648\u0646 other:0' '\u0645\u06cc\u0644\u06cc\u0648\u0646}",
                    "{one:00' '\u0645\u06cc\u0644\u06cc\u0648\u0646 other:00' '\u0645\u06cc\u0644\u06cc\u0648\u0646}",
                    "{one:000' '\u0645\u06cc\u0644\u06cc\u0648\u0646 other:000' '\u0645\u06cc\u0644\u06cc\u0648\u0646}",
                    "{one:0' '\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f other:0' '\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f}",
                    "{one:00' '\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f other:00' '\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f}",
                    "{one:000' '\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f other:000' '\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f}",
                    "{one:0' '\u0647\u0632\u0627\u0631\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f other:0' '\u0647\u0632\u0627\u0631\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f}",
                    "{one:00' '\u0647\u0632\u0627\u0631\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f other:00' '\u0647\u0632\u0627\u0631\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f}",
                    "{one:000' '\u0647\u0632\u0627\u0631\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f other:000' '\u0647\u0632\u0627\u0631\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f}",
                }
            },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayNames },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "java.time.roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.zone", "\u0645\u0646\u0637\u0642\u0647\u0654 \u0632\u0645\u0627\u0646\u06cc" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "arab.NumberPatterns", metaValue_arab_NumberPatterns },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "Eras",
                new String[] {
                    "\u0642.\u0645.",
                    "\u0645.",
                }
            },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "java.time.islamic.DatePatterns",
                new String[] {
                    "EEEE d MMMM y G",
                    "d MMMM y G",
                    "d MMM y G",
                    "y/M/d G",
                }
            },
            { "field.weekday", "\u0631\u0648\u0632 \u0647\u0641\u062a\u0647" },
            { "islamic.DateTimePatterns",
                new String[] {
                    "{1}\u060c \u0633\u0627\u0639\u062a {0}",
                    "{1}\u060c \u0633\u0627\u0639\u062a {0}",
                    "",
                    "",
                }
            },
            { "japanese.MonthAbbreviations", metaValue_MonthNames },
            { "islamic.DayAbbreviations", metaValue_DayNames },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "timezone.hourFormat", "\u200e+HH:mm;\u200e\u2212HH:mm" },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayNames },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "java.time.japanese.Eras", metaValue_java_time_japanese_Eras },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "\u0647\u0641\u062a\u0647" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u00a0\u0647\u0632\u0627\u0631 other:0\u00a0\u0647\u0632\u0627\u0631}",
                    "{one:00\u00a0\u0647\u0632\u0627\u0631 other:00\u00a0\u0647\u0632\u0627\u0631}",
                    "{one:000\u00a0\u0647\u0632\u0627\u0631 other:000\u00a0\u0647\u0632\u0627\u0631}",
                    "{one:0\u00a0\u0645\u06cc\u0644\u06cc\u0648\u0646 other:0\u00a0\u0645\u06cc\u0644\u06cc\u0648\u0646}",
                    "{one:00\u00a0\u0645\u06cc\u0644\u06cc\u0648\u0646 other:00\u00a0\u0645\u06cc\u0644\u06cc\u0648\u0646}",
                    "{one:000\u00a0\u0645 other:000\u00a0\u0645}",
                    "{one:0\u00a0\u0645 other:0\u00a0\u0645}",
                    "{one:00\u00a0\u0645 other:00\u00a0\u0645}",
                    "{one:000\u00a0\u0628 other:000B}",
                    "{one:0\u00a0\u062a other:0\u00a0\u062a\u0631\u06cc\u0644\u06cc\u0648\u0646}",
                    "{one:00\u00a0\u062a other:00\u00a0\u062a}",
                    "{one:000\u00a0\u062a other:000\u00a0\u062a}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "timezone.regionFormat.daylight", "\u0648\u0642\u062a \u062a\u0627\u0628\u0633\u062a\u0627\u0646\u06cc {0}" },
            { "DatePatterns",
                new String[] {
                    "EEEE d MMMM y",
                    "d MMMM y",
                    "d MMM y",
                    "y/M/d",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayNames },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthNames },
            { "standalone.DayNames", metaValue_DayNames },
            { "PluralRules", "one:i = 0 or n = 1" },
            { "field.hour", "\u0633\u0627\u0639\u062a" },
            { "islamic.MonthAbbreviations", metaValue_islamic_MonthNames },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_Eras },
            { "calendarname.buddhist", "\u062a\u0642\u0648\u06cc\u0645 \u0628\u0648\u062f\u0627\u06cc\u06cc" },
            { "standalone.MonthNames", metaValue_standalone_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u200e\u00a4\u00a0#,##0.00",
                    "#,##0%",
                    "\u200e\u00a4\u00a0#,##0.00;\u200e(\u00a4\u00a0#,##0.00)",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "japanese.Eras", metaValue_java_time_japanese_Eras },
            { "roc.abbreviated.AmPmMarkers", metaValue_abbreviated_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
