# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _flux
else:
    import _flux

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import ooflib.SWIG.engine.fieldindex
import ooflib.SWIG.engine.planarity
import ooflib.SWIG.engine.outputval
class Flux(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    def ndof(self):
        return _flux.Flux_ndof(self)

    def divergence_dim(self):
        return _flux.Flux_divergence_dim(self)

    def name(self):
        return _flux.Flux_name(self)

    def objectid(self):
        return _flux.Flux_objectid(self)

    def newOutputValue(self):
        return _flux.Flux_newOutputValue(self)

    def c_components(self, arg2):
        return _flux.Flux_c_components(self, arg2)

    def c_divergenceComponents(self):
        return _flux.Flux_c_divergenceComponents(self)

    def c_outOfPlaneComponents(self):
        return _flux.Flux_c_outOfPlaneComponents(self)

    def __repr__(self):
        return _flux.Flux___repr__(self)

    def __eq__(self, other):
        return _flux.Flux___eq__(self, other)
    __swig_destroy__ = _flux.delete_Flux

# Register Flux in _flux:
_flux.Flux_swigregister(Flux)
class VectorFlux(Flux):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, name):
        _flux.VectorFlux_swiginit(self, _flux.new_VectorFlux(name))

        finishConstruction(self)




    def __repr__(self):
        return _flux.VectorFlux___repr__(self)
    __swig_destroy__ = _flux.delete_VectorFlux

# Register VectorFlux in _flux:
_flux.VectorFlux_swigregister(VectorFlux)
class SymmetricTensorFlux(Flux):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, name, negate):
        _flux.SymmetricTensorFlux_swiginit(self, _flux.new_SymmetricTensorFlux(name, negate))

        finishConstruction(self)




    def __repr__(self):
        return _flux.SymmetricTensorFlux___repr__(self)
    __swig_destroy__ = _flux.delete_SymmetricTensorFlux

# Register SymmetricTensorFlux in _flux:
_flux.SymmetricTensorFlux_swigregister(SymmetricTensorFlux)

def getFluxByIndex(arg1):
    return _flux.getFluxByIndex(arg1)

def countFluxes():
    return _flux.countFluxes()
# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov. 

from ooflib.common import debug
from ooflib.common import utils
from ooflib.SWIG.engine import planarity
from ooflib.SWIG.common import switchboard

def _Flux___hash__(self):
    return self.objectid()

Flux.__hash__ = _Flux___hash__

# Fluxes are sometimes stored in an OrderedSet and need to have __lt__
# defined.

def _Flux___lt__(self, other):
    try:
        return self.objectid() < other.objectid()
    except:
        return NotImplemented

class _AllFluxes:
    def __getitem__(self, indx):
        if isinstance(indx, int):
            if indx >= countFluxes():
                raise IndexError("Bad flux index: " + str(indx))
            return getFluxByIndex(indx)
        elif isinstance(indx, (str, bytes)):
            try:
                flx = utils.OOFeval(indx)
            except NameError:
                raise IndexError("Bad flux name: " + indx)
            if not isinstance(flx, Flux):
                raise IndexError("Bad flux name: " + indx)
            return flx
    def __len__(self):
        return countFluxes()

allFluxes = _AllFluxes()

def getFlux(which):
    return allFluxes[which]

utils.OOFdefine('getFlux', getFlux)

# finishConstruction is called after the swigged constructors for all
# of the Flux subclasses.  It's installed by %pythonappend lines in
# flux.swg.
def finishConstruction(flx):
    utils.OOFdefine(flx.name(), flx)
    switchboard.notify("new flux")

#=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=#

def _fluxiter(comps):
    beginp = comps.begin()
    endp = comps.end()
    while beginp != endp:
        yield beginp.current()
        beginp.increment()

def _Flux_components(self, plan=planarity.ALL_INDICES):
    return _fluxiter(self.c_components(plan))

Flux.components = _Flux_components

def _Flux_divergenceComponents(self):
    return _fluxiter(self.c_divergenceComponents())

Flux.divergenceComponents = _Flux_divergenceComponents

def _Flux_outOfPlaneComponents(self):
    return _fluxiter(self.c_outOfPlaneComponents())

Flux.outOfPlaneComponents = _Flux_outOfPlaneComponents


