## Copyright (C) 2010-2016   Lukas F. Reichlin
##
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{q} =} floor (@var{q})
## Round quaternion @var{q} towards negative infinity.
## @end deftypefn

## Author: Lukas Reichlin <lukas.reichlin@gmail.com>
## Created: December 2013
## Version: 0.1

function q = floor (q)

  if (nargin != 1)
    print_usage ();
  endif
  
  q.w = builtin ("floor", q.w);
  q.x = builtin ("floor", q.x);
  q.y = builtin ("floor", q.y);
  q.z = builtin ("floor", q.z);

endfunction


%!test
%! q = quaternion (1.8, 2.3, 3.7, 4.1);
%! result = floor (q);
%! expected = quaternion (1, 2, 3, 4);
%! assert (result == expected);
