module type S = sig

type spec = Arg.spec =
  | Unit of (unit -> unit) 
  | Bool of (bool -> unit) 
  | Set of bool ref 
  | Clear of bool ref 
  | String of (string -> unit) 
  | Set_string of string ref 
  | Int of (int -> unit) 
  | Set_int of int ref 
  | Float of (float -> unit) 
  | Set_float of float ref 
  | Tuple of spec list 
  | Symbol of string list * (string -> unit) 
  | Rest of (string -> unit) 
  | Rest_all of (string list -> unit) 
  | Expand of (string -> string array) 

(*
type spec =
  | Unit of (unit -> unit) 
  | Bool of (bool -> unit) 
  | Set of bool ref 
  | Clear of bool ref 
  | String of (string -> unit) 
  | Set_string of string ref 
  | Int of (int -> unit) 
  | Set_int of int ref 
  | Float of (float -> unit) 
  | Set_float of float ref 
  | Tuple of spec list 
  | Symbol of string list * (string -> unit) 
  | Rest of (string -> unit) 
  | Rest_all of (string list -> unit) 
  | Expand of (string -> string array) 
*)
(** @since 4.12.0:
    type spec =
      | Unit of (unit -> unit) 
      | Bool of (bool -> unit) 
      | Set of bool ref 
      | Clear of bool ref 
      | String of (string -> unit) 
      | Set_string of string ref 
      | Int of (int -> unit) 
      | Set_int of int ref 
      | Float of (float -> unit) 
      | Set_float of float ref 
      | Tuple of spec list 
      | Symbol of string list * (string -> unit) 
      | Rest of (string -> unit) 
      | Rest_all of (string list -> unit) 
      | Expand of (string -> string array) 
 *)


type key = string

(*
type key = string
*)
(** @since 3.08.0: type key = string
 *)


type doc = string

(*
type doc = string
*)
(** @since 3.08.0: type doc = string
 *)


type usage_msg = string

(*
type usage_msg = string
*)
(** @since 3.08.0: type usage_msg = string
 *)


type anon_fun = string -> unit

(*
type anon_fun = string -> unit
*)
(** @since 3.08.0: type anon_fun = string -> unit
 *)

exception Help of string 
(** Alias for {!Arg.Help} *)

exception Bad of string 
(** Alias for {!Arg.Bad} *)

val parse_and_expand_argv_dynamic :
  int ref ->
    string array ref ->
      (key * spec * doc) list ref -> anon_fun -> string -> unit
(** @since 4.05.0:
    val parse_and_expand_argv_dynamic :
      int ref ->
        string array ref ->
          (key * spec * doc) list ref -> anon_fun -> string -> unit *)

val parse_expand : (key * spec * doc) list -> anon_fun -> usage_msg -> unit
(** @since 4.05.0:
    val parse_expand :
      (key * spec * doc) list -> anon_fun -> usage_msg -> unit *)

val read_arg : string -> string array
(** @since 4.05.0: val read_arg : string -> string array *)

val read_arg0 : string -> string array
(** @since 4.05.0: val read_arg0 : string -> string array *)

val write_arg : string -> string array -> unit
(** @since 4.05.0: val write_arg : string -> string array -> unit *)

val write_arg0 : string -> string array -> unit
(** @since 4.05.0: val write_arg0 : string -> string array -> unit *)

val parse_dynamic :
  (key * spec * doc) list ref -> anon_fun -> usage_msg -> unit
(** @since 4.02.0:
    val parse_dynamic :
      (key * spec * doc) list ref -> anon_fun -> usage_msg -> unit *)

val parse_argv_dynamic :
  ?current:int ref ->
    string array -> (key * spec * doc) list ref -> anon_fun -> string -> unit
(** @since 4.02.0:
    val parse_argv_dynamic :
      ?current:int ref ->
        string array ->
          (key * spec * doc) list ref -> anon_fun -> string -> unit *)

val align : ?limit:int -> (key * spec * doc) list -> (key * spec * doc) list
(** @since 4.02.0:
    val align :
      ?limit:int -> (key * spec * doc) list -> (key * spec * doc) list *)

val usage_string : (key * spec * doc) list -> usage_msg -> string
(** @since 3.12.0:
    val usage_string : (key * spec * doc) list -> usage_msg -> string *)

val parse : (key * spec * doc) list -> anon_fun -> usage_msg -> unit
(** Alias for {!Arg.parse} *)

val parse_argv :
  ?current:int ref ->
    string array -> (key * spec * doc) list -> anon_fun -> usage_msg -> unit
(** Alias for {!Arg.parse_argv} *)

val usage : (key * spec * doc) list -> usage_msg -> unit
(** Alias for {!Arg.usage} *)

val current : int ref
(** Alias for {!Arg.current} *)

end
