/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: LLVMOps.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::LLVM {

class AShrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class AddOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class AddrSpaceCastOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Creates a pointer pointing to a global, alias or a function
/// Creates an SSA value containing a pointer to a global value (function,
///     variable or alias). The global value can be defined after its first
///     referenced. If the global value is a constant, storing into it is not
///     allowed.
/// 
///     Examples:
/// 
///     ```mlir
///     func @foo() {
///       // Get the address of a global variable.
///       %0 = llvm.mlir.addressof @const : !llvm.ptr
/// 
///       // Use it as a regular pointer.
///       %1 = llvm.load %0 : !llvm.ptr -> i32
/// 
///       // Get the address of a function.
///       %2 = llvm.mlir.addressof @foo : !llvm.ptr
/// 
///       // The function address can be used for indirect calls.
///       llvm.call %2() : !llvm.ptr, () -> ()
/// 
///       // Get the address of an aliased global.
///       %3 = llvm.mlir.addressof @const_alias : !llvm.ptr
///     }
/// 
///     // Define the global.
///     llvm.mlir.global @const(42 : i32) : i32
/// 
///     // Define an alias.
///     llvm.mlir.alias @const_alias : i32 {
///       %0 = llvm.mlir.addressof @const : !llvm.ptr
///       llvm.return %0 : !llvm.ptr
///     }
///     ```
class AddressOfOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect alias.
/// `llvm.mlir.alias` is a top level operation that defines a global alias for
///     global variables and functions. The operation is always initialized by
///     using a initializer region which could be a direct map to another global
///     value or contain some address computation on top of it.
/// 
///     It uses a symbol for its value, which will be uniqued by the module
///     with respect to other symbols in it.
/// 
///     Similarly to functions and globals, they can also have a linkage attribute.
///     This attribute is placed between `llvm.mlir.alias` and the symbol name. If
///     the attribute is omitted, `external` linkage is assumed by default.
/// 
///     Examples:
/// 
///     ```mlir
///     // Global alias use @-identifiers.
///     llvm.mlir.alias external @foo_alias {addr_space = 0 : i32} : !llvm.ptr {
///       %0 = llvm.mlir.addressof @some_function : !llvm.ptr
///       llvm.return %0 : !llvm.ptr
///     }
/// 
///     // More complex initialization.
///     llvm.mlir.alias linkonce_odr hidden @glob
///     {addr_space = 0 : i32, dso_local} : !llvm.array<32 x i32> {
///       %0 = llvm.mlir.constant(1234 : i64) : i64
///       %1 = llvm.mlir.addressof @glob.private : !llvm.ptr
///       %2 = llvm.ptrtoint %1 : !llvm.ptr to i64
///       %3 = llvm.add %2, %0 : i64
///       %4 = llvm.inttoptr %3 : i64 to !llvm.ptr
///       llvm.return %4 : !llvm.ptr
///     }
///     ```
class AliasOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class AllocaOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class AndOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class AtomicCmpXchgOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class AtomicRMWOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class BitcastOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Creates a LLVM blockaddress ptr
/// Creates an SSA value containing a pointer to a basic block. The block
///     address information (function and block) is given by the `BlockAddressAttr`
///     attribute. This operation assumes an existing `llvm.blocktag` operation
///     identifying an existing MLIR block within a function. Example:
/// 
///     ```mlir
///     llvm.mlir.global private @g() : !llvm.ptr {
///       %0 = llvm.blockaddress <function = @fn, tag = <id = 0>> : !llvm.ptr
///       llvm.return %0 : !llvm.ptr
///     }
/// 
///     llvm.func @fn() {
///       llvm.br ^bb1
///     ^bb1:  // pred: ^bb0
///       llvm.blocktag <id = 0>
///       llvm.return
///     }
///     ```
class BlockAddressOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// This operation uses a `tag` to uniquely identify an MLIR block in a
///     function. The same tag is used by `llvm.blockaddress` in order to compute
///     the target address.
/// 
///     A given function should have at most one `llvm.blocktag` operation with a
///     given `tag`. This operation cannot be used as a terminator.
/// 
///     Example:
/// 
///     ```mlir
///     llvm.func @f() -> !llvm.ptr {
///       %addr = llvm.blockaddress <function = @f, tag = <id = 1>> : !llvm.ptr
///       llvm.br ^bb1
///     ^bb1:
///       llvm.blocktag <id = 1>
///       llvm.return %addr : !llvm.ptr
///     }
///     ```
class BlockTagOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class BrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Call to an LLVM intrinsic function.
/// Call the specified llvm intrinsic. If the intrinsic is overloaded, use
///     the MLIR function type of this op to determine which intrinsic to call.
class CallIntrinsicOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Call to an LLVM function.
/// In LLVM IR, functions may return either 0 or 1 value. LLVM IR dialect
///     implements this behavior by providing a variadic `call` operation for 0- and
///     1-result functions. Even though MLIR supports multi-result functions, LLVM
///     IR dialect disallows them.
/// 
///     The `call` instruction supports both direct and indirect calls. Direct calls
///     start with a function name (`@`-prefixed) and indirect calls start with an
///     SSA value (`%`-prefixed). The direct callee, if present, is stored as a
///     function attribute `callee`. For indirect calls, the callee is of `!llvm.ptr` type
///     and is stored as the first value in `callee_operands`. If and only if the
///     callee is a variadic function, the `var_callee_type` attribute must carry
///     the variadic LLVM function type. The trailing type list contains the
///     optional indirect callee type and the MLIR function type, which differs from
///     the LLVM function type that uses an explicit void type to model functions
///     that do not return a value.
/// 
///     If this operatin has the `no_inline` attribute, then this specific function call
///     will never be inlined. The opposite behavior will occur if the call has `always_inline`
///     attribute. The `inline_hint` attribute indicates that it is desirable to inline
///     this function call.
/// 
///     Examples:
/// 
///     ```mlir
///     // Direct call without arguments and with one result.
///     %0 = llvm.call @foo() : () -> (f32)
/// 
///     // Direct call with arguments and without a result.
///     llvm.call @bar(%0) : (f32) -> ()
/// 
///     // Indirect call with an argument and without a result.
///     %1 = llvm.mlir.addressof @foo : !llvm.ptr
///     llvm.call %1(%0) : !llvm.ptr, (f32) -> ()
/// 
///     // Direct variadic call.
///     llvm.call @printf(%0, %1) vararg(!llvm.func<i32 (ptr, ...)>) : (!llvm.ptr, i32) -> i32
/// 
///     // Indirect variadic call
///     llvm.call %1(%0) vararg(!llvm.func<void (...)>) : !llvm.ptr, (i32) -> ()
///     ```
class CallOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect comdat region
/// Provides access to object file COMDAT section/group functionality.
/// 
///     Examples:
///     ```mlir
///     llvm.comdat @__llvm_comdat {
///       llvm.comdat_selector @any any
///     }
///     llvm.mlir.global internal constant @has_any_comdat(1 : i64) comdat(@__llvm_comdat::@any) : i64
///     ```
class ComdatOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect comdat selector declaration
/// Provides access to object file COMDAT section/group functionality.
/// 
///     Examples:
///     ```mlir
///     llvm.comdat @__llvm_comdat {
///       llvm.comdat_selector @any any
///     }
///     llvm.mlir.global internal constant @has_any_comdat(1 : i64) comdat(@__llvm_comdat::@any) : i64
///     ```
class ComdatSelectorOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class CondBrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Defines a constant of LLVM type.
/// Unlike LLVM IR, MLIR does not have first-class constant values. Therefore,
///     all constants must be created as SSA values before being used in other
///     operations. `llvm.mlir.constant` creates such values for scalars, vectors,
///     strings, structs, and array of structs. It has a mandatory `value` attribute
///     whose type depends on the type of the constant value. The type of the constant
///     value must correspond to the attribute type converted to LLVM IR type.
/// 
///     When creating constant scalars, the `value` attribute must be either an
///     integer attribute or a floating point attribute. The type of the attribute
///     may be omitted for `i64` and `f64` types that are implied.
/// 
///     When creating constant vectors, the `value` attribute must be either an
///     array attribute, a dense attribute, or a sparse attribute that contains
///     integers or floats. The number of elements in the result vector must match
///     the number of elements in the attribute.
/// 
///     When creating constant strings, the `value` attribute must be a string
///     attribute. The type of the constant must be an LLVM array of `i8`s, and the
///     length of the array must match the length of the attribute.
/// 
///     When creating constant structs, the `value` attribute must be an array
///     attribute that contains integers or floats. The type of the constant must be
///     an LLVM struct type. The number of fields in the struct must match the
///     number of elements in the attribute, and the type of each LLVM struct field
///     must correspond to the type of the corresponding attribute element converted
///     to LLVM IR.
/// 
///     When creating an array of structs, the `value` attribute must be an array
///     attribute, itself containing zero, or undef, or array attributes for each
///     potential nested array type, and the elements of the leaf array attributes
///     for must match the struct element types or be zero or undef attributes.
/// 
///     Examples:
/// 
///     ```mlir
///     // Integer constant, internal i32 is mandatory
///     %0 = llvm.mlir.constant(42 : i32) : i32
/// 
///     // It's okay to omit i64.
///     %1 = llvm.mlir.constant(42) : i64
/// 
///     // Floating point constant.
///     %2 = llvm.mlir.constant(42.0 : f32) : f32
/// 
///     // Splat dense vector constant.
///     %3 = llvm.mlir.constant(dense<1.0> : vector<4xf32>) : vector<4xf32>
///     ```
class ConstantOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Creates a LLVM dso_local_equivalent ptr
/// Creates an SSA value containing a pointer to a global value (function or
///     alias to function). It represents a function which is functionally
///     equivalent to a given function, but is always defined in the current
///     linkage unit. The target function may not have `extern_weak` linkage.
/// 
///     Examples:
/// 
///     ```mlir
///     llvm.mlir.global external constant @const() : i64 {
///       %0 = llvm.mlir.addressof @const : !llvm.ptr
///       %1 = llvm.ptrtoint %0 : !llvm.ptr to i64
///       %2 = llvm.dso_local_equivalent @func : !llvm.ptr
///       %4 = llvm.ptrtoint %2 : !llvm.ptr to i64
///       llvm.return %4 : i64
///     }
///     ```
class DSOLocalEquivalentOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Extract an element from an LLVM vector.
class ExtractElementOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Extract a value from an LLVM struct.
class ExtractValueOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FAddOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FCmpOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FDivOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FMulOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FNegOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FPExtOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FPToSIOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FPToUIOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FPTruncOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FRemOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FSubOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FenceOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class FreezeOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// This operation mirrors LLVM IRs 'getelementptr' operation that is used to
///     perform pointer arithmetic.
/// 
///     Like in LLVM IR, it is possible to use both constants as well as SSA values
///     as indices. In the case of indexing within a structure, it is required to
///     either use constant indices directly, or supply a constant SSA value.
/// 
///     The no-wrap flags can be used to specify the low-level pointer arithmetic
///     overflow behavior that LLVM uses after lowering the operation to LLVM IR.
///     Valid options include 'inbounds' (pointer arithmetic must be within object
///     bounds), 'nusw' (no unsigned signed wrap), and 'nuw' (no unsigned wrap).
///     Note that 'inbounds' implies 'nusw' which is ensured by the enum
///     definition. The flags can be set individually or in combination.
/// 
///     Examples:
/// 
///     ```mlir
///     // GEP with an SSA value offset
///     %0 = llvm.getelementptr %1[%2] : (!llvm.ptr, i64) -> !llvm.ptr, f32
/// 
///     // GEP with a constant offset and the inbounds attribute set
///     %0 = llvm.getelementptr inbounds %1[3] : (!llvm.ptr) -> !llvm.ptr, f32
/// 
///     // GEP with constant offsets into a structure
///     %0 = llvm.getelementptr %1[0, 1]
///        : (!llvm.ptr) -> !llvm.ptr, !llvm.struct<(i32, f32)>
///     ```
class GEPOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect global_ctors.
/// Specifies a list of constructor functions, priorities, and associated data.
///     The functions referenced by this array will be called in ascending order
///     of priority (i.e. lowest first) when the module is loaded. The order of
///     functions with the same priority is not defined. This operation is
///     translated to LLVM's global_ctors global variable. The initializer
///     functions are run at load time. However, if the associated data is not
///     `#llvm.zero`, functions only run if the data is not discarded.
/// 
///     Examples:
/// 
///     ```mlir
///     llvm.func @ctor() {
///       ...
///       llvm.return
///     }
///     llvm.mlir.global_ctors ctors = [@ctor], priorities = [0],
///                                    data = [#llvm.zero]
///     ```
class GlobalCtorsOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect global_dtors.
/// Specifies a list of destructor functions and priorities. The functions
///     referenced by this array will be called in descending order of priority
///     (i.e. highest first) when the module is unloaded. The order of functions
///     with the same priority is not defined. This operation is translated to
///     LLVM's global_dtors global variable. The destruction functions are run at
///     load time. However, if the associated data is not `#llvm.zero`, functions
///     only run if the data is not discarded.
/// 
///     Examples:
/// 
///     ```mlir
///     llvm.func @dtor() {
///       llvm.return
///     }
///     llvm.mlir.global_dtors dtors = [@dtor], priorities = [0],
///                                    data = [#llvm.zero]
///     ```
class GlobalDtorsOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect global.
/// Since MLIR allows for arbitrary operations to be present at the top level,
///     global variables are defined using the `llvm.mlir.global` operation. Both
///     global constants and variables can be defined, and the value may also be
///     initialized in both cases.
/// 
///     There are two forms of initialization syntax. Simple constants that can be
///     represented as MLIR attributes can be given in-line:
/// 
///     ```mlir
///     llvm.mlir.global @variable(32.0 : f32) : f32
///     ```
/// 
///     This initialization and type syntax is similar to `llvm.mlir.constant` and
///     may use two types: one for MLIR attribute and another for the LLVM value.
///     These types must be compatible.
/// 
///     More complex constants that cannot be represented as MLIR attributes can be
///     given in an initializer region:
/// 
///     ```mlir
///     // This global is initialized with the equivalent of:
///     //   i32* getelementptr (i32* @g2, i32 2)
///     llvm.mlir.global constant @int_gep() : !llvm.ptr {
///       %0 = llvm.mlir.addressof @g2 : !llvm.ptr
///       %1 = llvm.mlir.constant(2 : i32) : i32
///       %2 = llvm.getelementptr %0[%1]
///          : (!llvm.ptr, i32) -> !llvm.ptr, i32
///       // The initializer region must end with `llvm.return`.
///       llvm.return %2 : !llvm.ptr
///     }
///     ```
/// 
///     Only one of the initializer attribute or initializer region may be provided.
/// 
///     `llvm.mlir.global` must appear at top-level of the enclosing module. It uses
///     an @-identifier for its value, which will be uniqued by the module with
///     respect to other @-identifiers in it.
/// 
///     Examples:
/// 
///     ```mlir
///     // Global values use @-identifiers.
///     llvm.mlir.global constant @cst(42 : i32) : i32
/// 
///     // Non-constant values must also be initialized.
///     llvm.mlir.global @variable(32.0 : f32) : f32
/// 
///     // Strings are expected to be of wrapped LLVM i8 array type and do not
///     // automatically include the trailing zero.
///     llvm.mlir.global @string("abc") : !llvm.array<3 x i8>
/// 
///     // For strings globals, the trailing type may be omitted.
///     llvm.mlir.global constant @no_trailing_type("foo bar")
/// 
///     // A complex initializer is constructed with an initializer region.
///     llvm.mlir.global constant @int_gep() : !llvm.ptr {
///       %0 = llvm.mlir.addressof @g2 : !llvm.ptr
///       %1 = llvm.mlir.constant(2 : i32) : i32
///       %2 = llvm.getelementptr %0[%1]
///          : (!llvm.ptr, i32) -> !llvm.ptr, i32
///       llvm.return %2 : !llvm.ptr
///     }
///     ```
/// 
///     Similarly to functions, globals have a linkage attribute. In the custom
///     syntax, this attribute is placed between `llvm.mlir.global` and the optional
///     `constant` keyword. If the attribute is omitted, `external` linkage is
///     assumed by default.
/// 
///     Examples:
/// 
///     ```mlir
///     // A constant with internal linkage will not participate in linking.
///     llvm.mlir.global internal constant @cst(42 : i32) : i32
/// 
///     // By default, "external" linkage is assumed and the global participates in
///     // symbol resolution at link-time.
///     llvm.mlir.global @glob(0 : f32) : f32
/// 
///     // Alignment is optional
///     llvm.mlir.global private constant @y(dense<1.0> : tensor<8xf32>) : !llvm.array<8 x f32>
///     ```
/// 
///     Like global variables in LLVM IR, globals can have an (optional)
///     alignment attribute using keyword `alignment`. The integer value of the
///     alignment must be a positive integer that is a power of 2.
/// 
///     Examples:
/// 
///     ```mlir
///     // Alignment is optional
///     llvm.mlir.global private constant @y(dense<1.0> : tensor<8xf32>) { alignment = 32 : i64 } : !llvm.array<8 x f32>
///     ```
/// 
///     The `target_specific_attrs` attribute provides a mechanism to preserve
///     target-specific LLVM IR attributes that are not explicitly modeled in the
///     LLVM dialect.
/// 
///     The attribute is an array containing either string attributes or
///     two-element array attributes of strings. The value of a standalone string
///     attribute is interpreted as the name of an LLVM IR attribute on the global.
///     A two-element array is interpreted as a key-value pair.
/// 
///     Example:
/// 
///     ```mlir
///     llvm.mlir.global external @example() {
///       target_specific_attrs = ["value-less-attr", ["int-attr", "4"], ["string-attr", "string"]]} : f64
///     ```
class GlobalOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class ICmpOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect ifunc
/// `llvm.mlir.ifunc` is a top level operation that defines a global ifunc.
///     It defines a new symbol and takes a symbol refering to a resolver function.
///     IFuncs can be called as regular functions. The function type is the same
///     as the IFuncType. The symbol is resolved at runtime by calling a resolver
///     function.
/// 
///     Examples:
/// 
///     ```mlir
///     // IFuncs resolve a symbol at runtime using a resovler function.
///     llvm.mlir.ifunc external @foo: !llvm.func<f32 (i64)>, !llvm.ptr @resolver
/// 
///     llvm.func @foo_1(i64) -> f32
///     llvm.func @foo_2(i64) -> f32
/// 
///     llvm.func @resolve_foo() -> !llvm.ptr attributes {
///       %0 = llvm.mlir.addressof @foo_2 : !llvm.ptr
///       %1 = llvm.mlir.addressof @foo_1 : !llvm.ptr
/// 
///       // ... Logic selecting from foo_{1, 2}
/// 
///       // Return function pointer to the selected function
///       llvm.return %7 : !llvm.ptr
///     }
/// 
///     llvm.func @use_foo() {
///       // IFuncs are called as regular functions
///       %res = llvm.call @foo(%value) : i64 -> f32
///     }
///     ```
class IFuncOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Transfer control flow to address in `$addr`. A list of possible target
///     blocks in `$successors` can be provided and maybe used as a hint in LLVM:
/// 
///     ```mlir
///     ...
///     llvm.func @g(...
///       %dest = llvm.blockaddress <function = @g, tag = <id = 0>> : !llvm.ptr
///       llvm.indirectbr %dest : !llvm.ptr, [
///         ^head
///       ]
///     ^head:
///       llvm.blocktag <id = 0>
///       llvm.return %arg0 : i32
///       ...
///     ```
/// 
///     It also supports a list of operands that can be passed to a target block:
/// 
///     ```mlir
///       llvm.indirectbr %dest : !llvm.ptr, [
///         ^head(%arg0 : i32),
///         ^tail(%arg1, %arg0 : i32, i32)
///       ]
///     ^head(%r0 : i32):
///       llvm.return %r0 : i32
///     ^tail(%r1 : i32, %r2 : i32):
///       ...
///     ```
class IndirectBrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// The InlineAsmOp mirrors the underlying LLVM semantics with a notable
///     exception: the embedded `asm_string` is not allowed to define or reference
///     any symbol or any global variable: only the operands of the op may be read,
///     written, or referenced.
///     Attempting to define or reference any symbol or any global behavior is
///     considered undefined behavior at this time.
///     If `tail_call_kind` is used, the operation behaves like the specified
///     tail call kind. The `musttail` kind it's not available for this operation,
///     since it isn't supported by LLVM's inline asm.
class InlineAsmOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Insert an element into an LLVM vector.
class InsertElementOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Insert a value into an LLVM struct.
class InsertValueOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class IntToPtrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class InvokeOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// LLVM dialect function.
/// MLIR functions are defined by an operation that is not built into the IR
///     itself. The LLVM dialect provides an `llvm.func` operation to define
///     functions compatible with LLVM IR. These functions have LLVM dialect
///     function type but use MLIR syntax to express it. They are required to have
///     exactly one result type. LLVM function operation is intended to capture
///     additional properties of LLVM functions, such as linkage and calling
///     convention, that may be modeled differently by the built-in MLIR function.
/// 
///     ```mlir
///     // The type of @bar is !llvm<"i64 (i64)">
///     llvm.func @bar(%arg0: i64) -> i64 {
///       llvm.return %arg0 : i64
///     }
/// 
///     // Type type of @foo is !llvm<"void (i64)">
///     // !llvm.void type is omitted
///     llvm.func @foo(%arg0: i64) {
///       llvm.return
///     }
/// 
///     // A function with `internal` linkage.
///     llvm.func internal @internal_func() {
///       llvm.return
///     }
///     ```
class LLVMFuncOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class LShrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class LandingpadOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Options to pass to the linker when the object file is linked
/// Pass the given options to the linker when the resulting object file is linked.
///     This is used extensively on Windows to determine the C runtime that the object
///     files should link against.
/// 
///     Examples:
///     ```mlir
///     // Link against the MSVC static threaded CRT.
///     llvm.linker_options ["/DEFAULTLIB:", "libcmt"]
/// 
///     // Link against aarch64 compiler-rt builtins
///     llvm.linker_options ["-l", "clang_rt.builtins-aarch64"]
///     ```
class LinkerOptionsOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// The `load` operation is used to read from memory. A load may be marked as
///     atomic, volatile, and/or nontemporal, and takes a number of optional
///     attributes that specify aliasing information.
/// 
///     An atomic load only supports a limited set of pointer, integer, and
///     floating point types, and requires an explicit alignment.
/// 
///     Examples:
///     ```mlir
///     // A volatile load of a float variable.
///     %0 = llvm.load volatile %ptr : !llvm.ptr -> f32
/// 
///     // A nontemporal load of a float variable.
///     %0 = llvm.load %ptr {nontemporal} : !llvm.ptr -> f32
/// 
///     // An atomic load of an integer variable.
///     %0 = llvm.load %ptr atomic monotonic {alignment = 8 : i64}
///         : !llvm.ptr -> i64
///     ```
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#load-instruction
class LoadOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Information about module properties
/// Represents the equivalent in MLIR for LLVM's `llvm.module.flags` metadata,
///     which requires a list of metadata triplets. Each triplet entry is described
///     by a `ModuleFlagAttr`.
/// 
///     Example:
///     ```mlir
///     llvm.module.flags [
///       #llvm.mlir.module_flag<error, "wchar_size", 4>,
///       #llvm.mlir.module_flag<max, "PIC Level", 2>
///     ]
///     ```
class ModuleFlagsOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class MulOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Defines a value containing an empty token to LLVM type.
/// Unlike LLVM IR, MLIR does not have first-class token values. They must be
///     explicitly created as SSA values using `llvm.mlir.none`. This operation has
///     no operands or attributes, and returns a none token value of a wrapped LLVM IR
///     pointer type.
/// 
///     Examples:
/// 
///     ```mlir
///     %0 = llvm.mlir.none : !llvm.token
///     ```
class NoneTokenOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class OrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Creates a poison value of LLVM dialect type.
/// Unlike LLVM IR, MLIR does not have first-class poison values. Such values
///     must be created as SSA values using `llvm.mlir.poison`. This operation has
///     no operands or attributes. It creates a poison value of the specified LLVM
///     IR dialect type.
/// 
///     Example:
/// 
///     ```mlir
///     // Create a poison value for a structure with a 32-bit integer followed
///     // by a float.
///     %0 = llvm.mlir.poison : !llvm.struct<(i32, f32)>
///     ```
class PoisonOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class PtrToIntOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class ResumeOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class ReturnOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SDivOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SExtOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SIToFPOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SRemOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SelectOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class ShlOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Construct a permutation of two vectors.
class ShuffleVectorOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// The `store` operation is used to write to memory. A store may be marked as
///     atomic, volatile, and/or nontemporal, and takes a number of optional
///     attributes that specify aliasing information.
/// 
///     An atomic store only supports a limited set of pointer, integer, and
///     floating point types, and requires an explicit alignment.
/// 
///     Examples:
///     ```mlir
///     // A volatile store of a float variable.
///     llvm.store volatile %val, %ptr : f32, !llvm.ptr
/// 
///     // A nontemporal store of a float variable.
///     llvm.store %val, %ptr {nontemporal} : f32, !llvm.ptr
/// 
///     // An atomic store of an integer variable.
///     llvm.store %val, %ptr atomic monotonic {alignment = 8 : i64}
///         : i64, !llvm.ptr
///     ```
/// 
///     See the following link for more details:
///     https://llvm.org/docs/LangRef.html#store-instruction
class StoreOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SubOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class SwitchOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class TruncOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class UDivOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class UIToFPOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class URemOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Creates an undefined value of LLVM dialect type.
/// Unlike LLVM IR, MLIR does not have first-class undefined values. Such values
///     must be created as SSA values using `llvm.mlir.undef`. This operation has no
///     operands or attributes. It creates an undefined value of the specified LLVM
///     IR dialect type.
/// 
///     Example:
/// 
///     ```mlir
///     // Create a structure with a 32-bit integer followed by a float.
///     %0 = llvm.mlir.undef : !llvm.struct<(i32, f32)>
///     ```
class UndefOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class UnreachableOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class VaArgOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class XOrOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

class ZExtOp;

} // namespace mlir::LLVM
namespace mlir::LLVM {

/// Creates a zero-initialized value of LLVM dialect type.
/// Unlike LLVM IR, MLIR does not have first-class zero-initialized values.
///     Such values must be created as SSA values using `llvm.mlir.zero`. This
///     operation has no operands or attributes. It creates a zero-initialized
///     value of the specified LLVM IR dialect type.
/// 
///     Example:
/// 
///     ```mlir
///     // Create a zero-initialized value for a structure with a 32-bit integer
///     // followed by a float.
///     %0 = llvm.mlir.zero : !llvm.struct<(i32, f32)>
///     ```
class ZeroOp;

} // namespace mlir::LLVM
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AShrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AShrOpGenericAdaptorBase {
public:
  struct Properties {
    using isExactTy = ::mlir::UnitAttr;
    isExactTy isExact;

    auto getIsExact() const {
      auto &propStorage = this->isExact;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setIsExact(const ::mlir::UnitAttr &propValue) {
      this->isExact = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.isExact == this->isExact &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AShrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.ashr", odsAttrs.getContext());
  }

  AShrOpGenericAdaptorBase(AShrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getIsExactAttr();
  bool getIsExact();
};

} // namespace detail
template <typename RangeT>
class AShrOpGenericAdaptor : public detail::AShrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AShrOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  AShrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AShrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AShrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AShrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AShrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AShrOpGenericAdaptor(RangeT values, const AShrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AShrOp, typename = std::enable_if_t<std::is_same_v<LateInst, AShrOp>>>
  AShrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AShrOpAdaptor : public AShrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AShrOpGenericAdaptor::AShrOpGenericAdaptor;
  AShrOpAdaptor(AShrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AShrOp : public ::mlir::Op<AShrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::ExactFlagInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AShrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AShrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::ExactFlagInterface::Trait<AShrOp>::getIsExact;
  using ::mlir::LLVM::ExactFlagInterface::Trait<AShrOp>::setIsExact;
  using ::mlir::LLVM::ExactFlagInterface::Trait<AShrOp>::getIsExactName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("isExact")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIsExactAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIsExactAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.ashr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getIsExactAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().isExact);
  }

  bool getIsExact();
  void setIsExactAttr(::mlir::UnitAttr attr) {
    getProperties().isExact = attr;
  }

  void setIsExact(bool attrValue);
  ::mlir::Attribute removeIsExactAttr() {
      auto attr = getProperties().isExact;
      getProperties().isExact = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AShrOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AddOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AddOpGenericAdaptorBase {
public:
  struct Properties {
    using overflowFlagsTy = ::mlir::LLVM::IntegerOverflowFlags;
    overflowFlagsTy overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none;
    ::mlir::LLVM::IntegerOverflowFlags getOverflowFlags() const {
      auto &propStorage = this->overflowFlags;
      return propStorage;
    }
    void setOverflowFlags(::mlir::LLVM::IntegerOverflowFlags propValue) {
      auto &propStorage = this->overflowFlags;
      propStorage = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.overflowFlags == this->overflowFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.add", odsAttrs.getContext());
  }

  AddOpGenericAdaptorBase(AddOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::IntegerOverflowFlags getOverflowFlags() {
    return getProperties().getOverflowFlags();
  }

};

} // namespace detail
template <typename RangeT>
class AddOpGenericAdaptor : public detail::AddOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddOpGenericAdaptor(RangeT values, const AddOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddOp>>>
  AddOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddOpAdaptor : public AddOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddOpGenericAdaptor::AddOpGenericAdaptor;
  AddOpAdaptor(AddOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddOp : public ::mlir::Op<AddOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait, ::mlir::OpTrait::IsCommutative, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<AddOp>::getOverflowFlags;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<AddOp>::setOverflowFlags;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<AddOp>::hasNoUnsignedWrap;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<AddOp>::hasNoSignedWrap;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<AddOp>::getOverflowFlagsAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.add");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::IntegerOverflowFlags getOverflowFlags() {
    return getProperties().getOverflowFlags();
  }

  void setOverflowFlags(::mlir::LLVM::IntegerOverflowFlags newOverflowFlags) {
    getProperties().setOverflowFlags(newOverflowFlags);
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AddOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AddrSpaceCastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AddrSpaceCastOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddrSpaceCastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.addrspacecast", odsAttrs.getContext());
  }

  AddrSpaceCastOpGenericAdaptorBase(AddrSpaceCastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class AddrSpaceCastOpGenericAdaptor : public detail::AddrSpaceCastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddrSpaceCastOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  AddrSpaceCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddrSpaceCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddrSpaceCastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddrSpaceCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddrSpaceCastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddrSpaceCastOpGenericAdaptor(RangeT values, const AddrSpaceCastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddrSpaceCastOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddrSpaceCastOp>>>
  AddrSpaceCastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddrSpaceCastOpAdaptor : public AddrSpaceCastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddrSpaceCastOpGenericAdaptor::AddrSpaceCastOpGenericAdaptor;
  AddrSpaceCastOpAdaptor(AddrSpaceCastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddrSpaceCastOp : public ::mlir::Op<AddrSpaceCastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::PromotableOpInterface::Trait, ::mlir::ViewLikeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddrSpaceCastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddrSpaceCastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::PromotableOpInterface::Trait<AddrSpaceCastOp>::requiresReplacedValues;
  using ::mlir::PromotableOpInterface::Trait<AddrSpaceCastOp>::visitReplacedValues;
  using ::mlir::ViewLikeOpInterface::Trait<AddrSpaceCastOp>::getViewDest;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.addrspacecast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AddrSpaceCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AddrSpaceCastOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg);
  static AddrSpaceCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg);
  static AddrSpaceCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static AddrSpaceCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static AddrSpaceCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddrSpaceCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddrSpaceCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddrSpaceCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddrSpaceCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  bool canUsesBeRemoved(const ::llvm::SmallPtrSetImpl<::mlir::OpOperand *> &blockingUses, ::llvm::SmallVectorImpl<::mlir::OpOperand *> &newBlockingUses, const ::mlir::DataLayout &datalayout);
  ::mlir::DeletionKind removeBlockingUses(const ::llvm::SmallPtrSetImpl<mlir::OpOperand *> &blockingUses, ::mlir::OpBuilder &builder);
  ::mlir::Value getViewSource();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AddrSpaceCastOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AddressOfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AddressOfOpGenericAdaptorBase {
public:
  struct Properties {
    using global_nameTy = ::mlir::FlatSymbolRefAttr;
    global_nameTy global_name;

    auto getGlobalName() const {
      auto &propStorage = this->global_name;
      return ::llvm::cast<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setGlobalName(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->global_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.global_name == this->global_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddressOfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.addressof", odsAttrs.getContext());
  }

  AddressOfOpGenericAdaptorBase(AddressOfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FlatSymbolRefAttr getGlobalNameAttr() {
    auto attr = ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().global_name);
    return attr;
  }

  ::llvm::StringRef getGlobalName();
};

} // namespace detail
template <typename RangeT>
class AddressOfOpGenericAdaptor : public detail::AddressOfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddressOfOpGenericAdaptorBase;
public:
  AddressOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddressOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddressOfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddressOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddressOfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddressOfOpGenericAdaptor(RangeT values, const AddressOfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddressOfOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddressOfOp>>>
  AddressOfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddressOfOpAdaptor : public AddressOfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddressOfOpGenericAdaptor::AddressOfOpGenericAdaptor;
  AddressOfOpAdaptor(AddressOfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddressOfOp : public ::mlir::Op<AddressOfOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::LLVM::LLVMPointerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ConstantLike, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddressOfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddressOfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("global_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getGlobalNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getGlobalNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.addressof");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FlatSymbolRefAttr getGlobalNameAttr() {
    return ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().global_name);
  }

  ::llvm::StringRef getGlobalName();
  void setGlobalNameAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().global_name = attr;
  }

  void setGlobalName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, GlobalOp global, ArrayRef<NamedAttribute> attrs = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, GlobalOp global, ArrayRef<NamedAttribute> attrs = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, GlobalOp global, ArrayRef<NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFuncOp func, ArrayRef<NamedAttribute> attrs = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFuncOp func, ArrayRef<NamedAttribute> attrs = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFuncOp func, ArrayRef<NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, AliasOp alias, ArrayRef<NamedAttribute> attrs = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, AliasOp alias, ArrayRef<NamedAttribute> attrs = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, AliasOp alias, ArrayRef<NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::FlatSymbolRefAttr global_name);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::FlatSymbolRefAttr global_name);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::FlatSymbolRefAttr global_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr global_name);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr global_name);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr global_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::llvm::StringRef global_name);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::llvm::StringRef global_name);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::llvm::StringRef global_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef global_name);
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef global_name);
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef global_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddressOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddressOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return the llvm.mlir.global operation that defined the value referenced
  /// here.
  GlobalOp getGlobal(SymbolTableCollection &symbolTable);

  /// Return the llvm.func operation that is referenced here.
  LLVMFuncOp getFunction(SymbolTableCollection &symbolTable);

  /// Return the llvm.mlir.alias operation that defined the value referenced
  /// here.
  AliasOp getAlias(SymbolTableCollection &symbolTable);

  /// Return the llvm.mlir.ifunc operation that defined the value referenced
  /// here.
  IFuncOp getIFunc(SymbolTableCollection &symbolTable);
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AddressOfOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AliasOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AliasOpGenericAdaptorBase {
public:
  struct Properties {
    using alias_typeTy = ::mlir::TypeAttr;
    alias_typeTy alias_type;

    auto getAliasType() const {
      auto &propStorage = this->alias_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setAliasType(const ::mlir::TypeAttr &propValue) {
      this->alias_type = propValue;
    }
    using dso_localTy = ::mlir::UnitAttr;
    dso_localTy dso_local;

    auto getDsoLocal() const {
      auto &propStorage = this->dso_local;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setDsoLocal(const ::mlir::UnitAttr &propValue) {
      this->dso_local = propValue;
    }
    using linkageTy = ::mlir::LLVM::LinkageAttr;
    linkageTy linkage;

    auto getLinkage() const {
      auto &propStorage = this->linkage;
      return ::llvm::cast<::mlir::LLVM::LinkageAttr>(propStorage);
    }
    void setLinkage(const ::mlir::LLVM::LinkageAttr &propValue) {
      this->linkage = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using thread_local_Ty = ::mlir::UnitAttr;
    thread_local_Ty thread_local_;

    auto getThreadLocal_() const {
      auto &propStorage = this->thread_local_;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setThreadLocal_(const ::mlir::UnitAttr &propValue) {
      this->thread_local_ = propValue;
    }
    using unnamed_addrTy = ::mlir::LLVM::UnnamedAddrAttr;
    unnamed_addrTy unnamed_addr;

    auto getUnnamedAddr() const {
      auto &propStorage = this->unnamed_addr;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(propStorage);
    }
    void setUnnamedAddr(const ::mlir::LLVM::UnnamedAddrAttr &propValue) {
      this->unnamed_addr = propValue;
    }
    using visibility_Ty = ::mlir::LLVM::VisibilityAttr;
    visibility_Ty visibility_;

    auto getVisibility_() const {
      auto &propStorage = this->visibility_;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(propStorage);
    }
    void setVisibility_(const ::mlir::LLVM::VisibilityAttr &propValue) {
      this->visibility_ = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.alias_type == this->alias_type &&
        rhs.dso_local == this->dso_local &&
        rhs.linkage == this->linkage &&
        rhs.sym_name == this->sym_name &&
        rhs.thread_local_ == this->thread_local_ &&
        rhs.unnamed_addr == this->unnamed_addr &&
        rhs.visibility_ == this->visibility_ &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AliasOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.alias", odsAttrs.getContext());
  }

  AliasOpGenericAdaptorBase(AliasOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getAliasTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().alias_type);
    return attr;
  }

  ::mlir::Type getAliasType();
  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
    return attr;
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr();
  bool getDsoLocal();
  ::mlir::UnitAttr getThreadLocal_Attr();
  bool getThreadLocal_();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
    return attr;
  }

  ::std::optional<::mlir::LLVM::UnnamedAddr> getUnnamedAddr();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr();
  ::mlir::LLVM::Visibility getVisibility_();
  ::mlir::Region &getInitializer() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class AliasOpGenericAdaptor : public detail::AliasOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AliasOpGenericAdaptorBase;
public:
  AliasOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AliasOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AliasOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AliasOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AliasOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AliasOpGenericAdaptor(RangeT values, const AliasOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AliasOp, typename = std::enable_if_t<std::is_same_v<LateInst, AliasOp>>>
  AliasOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AliasOpAdaptor : public AliasOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AliasOpGenericAdaptor::AliasOpGenericAdaptor;
  AliasOpAdaptor(AliasOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AliasOp : public ::mlir::Op<AliasOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ReturnOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AliasOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AliasOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("alias_type"), ::llvm::StringRef("dso_local"), ::llvm::StringRef("linkage"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("thread_local_"), ::llvm::StringRef("unnamed_addr"), ::llvm::StringRef("visibility_")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAliasTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAliasTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDsoLocalAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDsoLocalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getLinkageAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getLinkageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getThreadLocal_AttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getThreadLocal_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getUnnamedAddrAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getUnnamedAddrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getVisibility_AttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getVisibility_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.alias");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getInitializer() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getAliasTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().alias_type);
  }

  ::mlir::Type getAliasType();
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    return ::llvm::cast<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().dso_local);
  }

  bool getDsoLocal();
  ::mlir::UnitAttr getThreadLocal_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().thread_local_);
  }

  bool getThreadLocal_();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
  }

  ::std::optional<::mlir::LLVM::UnnamedAddr> getUnnamedAddr();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(getProperties().visibility_);
  }

  ::mlir::LLVM::Visibility getVisibility_();
  void setAliasTypeAttr(::mlir::TypeAttr attr) {
    getProperties().alias_type = attr;
  }

  void setAliasType(::mlir::Type attrValue);
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setLinkageAttr(::mlir::LLVM::LinkageAttr attr) {
    getProperties().linkage = attr;
  }

  void setLinkage(::mlir::LLVM::Linkage attrValue);
  void setDsoLocalAttr(::mlir::UnitAttr attr) {
    getProperties().dso_local = attr;
  }

  void setDsoLocal(bool attrValue);
  void setThreadLocal_Attr(::mlir::UnitAttr attr) {
    getProperties().thread_local_ = attr;
  }

  void setThreadLocal_(bool attrValue);
  void setUnnamedAddrAttr(::mlir::LLVM::UnnamedAddrAttr attr) {
    getProperties().unnamed_addr = attr;
  }

  void setUnnamedAddr(::std::optional<::mlir::LLVM::UnnamedAddr> attrValue);
  void setVisibility_Attr(::mlir::LLVM::VisibilityAttr attr) {
    getProperties().visibility_ = attr;
  }

  void setVisibility_(::mlir::LLVM::Visibility attrValue);
  ::mlir::Attribute removeDsoLocalAttr() {
      auto attr = getProperties().dso_local;
      getProperties().dso_local = {};
      return attr;
  }

  ::mlir::Attribute removeThreadLocal_Attr() {
      auto attr = getProperties().thread_local_;
      getProperties().thread_local_ = {};
      return attr;
  }

  ::mlir::Attribute removeUnnamedAddrAttr() {
      auto attr = getProperties().unnamed_addr;
      getProperties().unnamed_addr = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type type, Linkage linkage, StringRef name, bool dsoLocal = false, bool thread_local_ = false, ArrayRef<NamedAttribute> attrs = {});
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type type, Linkage linkage, StringRef name, bool dsoLocal = false, bool thread_local_ = false, ArrayRef<NamedAttribute> attrs = {});
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, Type type, Linkage linkage, StringRef name, bool dsoLocal = false, bool thread_local_ = false, ArrayRef<NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeAttr alias_type, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeAttr alias_type, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeAttr alias_type, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr alias_type, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr alias_type, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr alias_type, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type alias_type, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type alias_type, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type alias_type, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type alias_type, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type alias_type, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type alias_type, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AliasOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AliasOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifyRegions();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return the LLVM type of the global alias.
  Type getType() {
    return getAliasType();
  }
  /// Return the initializer region. It's always present and terminates
  /// with an `llvm.return` op with the initializer value.
  Region &getInitializerRegion() {
    return getOperation()->getRegion(0);
  }
  Block &getInitializerBlock() {
    return getInitializerRegion().front();
  }
  // Retrieve address space information from the initializer block
  // result.
  unsigned getAddrSpace();
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AliasOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AllocaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AllocaOpGenericAdaptorBase {
public:
  struct Properties {
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using elem_typeTy = ::mlir::TypeAttr;
    elem_typeTy elem_type;

    auto getElemType() const {
      auto &propStorage = this->elem_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setElemType(const ::mlir::TypeAttr &propValue) {
      this->elem_type = propValue;
    }
    using inallocaTy = ::mlir::UnitAttr;
    inallocaTy inalloca;

    auto getInalloca() const {
      auto &propStorage = this->inalloca;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInalloca(const ::mlir::UnitAttr &propValue) {
      this->inalloca = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.alignment == this->alignment &&
        rhs.elem_type == this->elem_type &&
        rhs.inalloca == this->inalloca &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllocaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.alloca", odsAttrs.getContext());
  }

  AllocaOpGenericAdaptorBase(AllocaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::TypeAttr getElemTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().elem_type);
    return attr;
  }

  ::mlir::Type getElemType();
  ::mlir::UnitAttr getInallocaAttr();
  bool getInalloca();
};

} // namespace detail
template <typename RangeT>
class AllocaOpGenericAdaptor : public detail::AllocaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllocaOpGenericAdaptorBase;
  static constexpr int odsIndex_arraySize = 0;
public:
  AllocaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllocaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllocaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllocaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AllocaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllocaOpGenericAdaptor(RangeT values, const AllocaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllocaOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllocaOp>>>
  AllocaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArraySize() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllocaOpAdaptor : public AllocaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllocaOpGenericAdaptor::AllocaOpGenericAdaptor;
  AllocaOpAdaptor(AllocaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllocaOp : public ::mlir::Op<AllocaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::LLVM::LLVMPointerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::PromotableAllocationOpInterface::Trait, ::mlir::DestructurableAllocationOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllocaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllocaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arraySize = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("alignment"), ::llvm::StringRef("elem_type"), ::llvm::StringRef("inalloca")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getElemTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getElemTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getInallocaAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getInallocaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.alloca");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getArraySize() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArraySizeMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::TypeAttr getElemTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().elem_type);
  }

  ::mlir::Type getElemType();
  ::mlir::UnitAttr getInallocaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().inalloca);
  }

  bool getInalloca();
  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  void setElemTypeAttr(::mlir::TypeAttr attr) {
    getProperties().elem_type = attr;
  }

  void setElemType(::mlir::Type attrValue);
  void setInallocaAttr(::mlir::UnitAttr attr) {
    getProperties().inalloca = attr;
  }

  void setInalloca(bool attrValue);
  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  ::mlir::Attribute removeInallocaAttr() {
      auto attr = getProperties().inalloca;
      getProperties().inalloca = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, Type elementType, Value arraySize, unsigned alignment = 0);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, Type elementType, Value arraySize, unsigned alignment = 0);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, Type elementType, Value arraySize, unsigned alignment = 0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::TypeAttr elem_type, /*optional*/::mlir::UnitAttr inalloca = nullptr);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::TypeAttr elem_type, /*optional*/::mlir::UnitAttr inalloca = nullptr);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::TypeAttr elem_type, /*optional*/::mlir::UnitAttr inalloca = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::TypeAttr elem_type, /*optional*/::mlir::UnitAttr inalloca = nullptr);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::TypeAttr elem_type, /*optional*/::mlir::UnitAttr inalloca = nullptr);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::TypeAttr elem_type, /*optional*/::mlir::UnitAttr inalloca = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::Type elem_type, /*optional*/bool inalloca = false);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::Type elem_type, /*optional*/bool inalloca = false);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::Type elem_type, /*optional*/bool inalloca = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::Type elem_type, /*optional*/bool inalloca = false);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::Type elem_type, /*optional*/bool inalloca = false);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arraySize, /*optional*/::mlir::IntegerAttr alignment, ::mlir::Type elem_type, /*optional*/bool inalloca = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::MemorySlot> getPromotableSlots();
  ::mlir::Value getDefaultValue(const ::mlir::MemorySlot &slot, ::mlir::OpBuilder &builder);
  void handleBlockArgument(const ::mlir::MemorySlot &slot, ::mlir::BlockArgument argument, ::mlir::OpBuilder &builder);
  ::std::optional<::mlir::PromotableAllocationOpInterface> handlePromotionComplete(const ::mlir::MemorySlot &slot, ::mlir::Value defaultValue, ::mlir::OpBuilder &builder);
  ::llvm::SmallVector<::mlir::DestructurableMemorySlot> getDestructurableSlots();
  ::llvm::DenseMap<::mlir::Attribute, ::mlir::MemorySlot> destructure(const ::mlir::DestructurableMemorySlot &slot, const ::llvm::SmallPtrSetImpl<::mlir::Attribute> &usedIndices, ::mlir::OpBuilder &builder, ::mlir::SmallVectorImpl<::mlir::DestructurableAllocationOpInterface> &newAllocators);
  ::std::optional<::mlir::DestructurableAllocationOpInterface> handleDestructuringComplete(const ::mlir::DestructurableMemorySlot &slot, ::mlir::OpBuilder &builder);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AllocaOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AndOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AndOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.and", odsAttrs.getContext());
  }

  AndOpGenericAdaptorBase(AndOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class AndOpGenericAdaptor : public detail::AndOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AndOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  AndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AndOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AndOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AndOpGenericAdaptor(RangeT values, const AndOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AndOp, typename = std::enable_if_t<std::is_same_v<LateInst, AndOp>>>
  AndOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AndOpAdaptor : public AndOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AndOpGenericAdaptor::AndOpGenericAdaptor;
  AndOpAdaptor(AndOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AndOp : public ::mlir::Op<AndOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AndOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AndOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.and");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AndOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AtomicCmpXchgOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AtomicCmpXchgOpGenericAdaptorBase {
public:
  struct Properties {
    using access_groupsTy = ::mlir::ArrayAttr;
    access_groupsTy access_groups;

    auto getAccessGroups() const {
      auto &propStorage = this->access_groups;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAccessGroups(const ::mlir::ArrayAttr &propValue) {
      this->access_groups = propValue;
    }
    using alias_scopesTy = ::mlir::ArrayAttr;
    alias_scopesTy alias_scopes;

    auto getAliasScopes() const {
      auto &propStorage = this->alias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->alias_scopes = propValue;
    }
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using failure_orderingTy = ::mlir::LLVM::AtomicOrderingAttr;
    failure_orderingTy failure_ordering;

    auto getFailureOrdering() const {
      auto &propStorage = this->failure_ordering;
      return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(propStorage);
    }
    void setFailureOrdering(const ::mlir::LLVM::AtomicOrderingAttr &propValue) {
      this->failure_ordering = propValue;
    }
    using noalias_scopesTy = ::mlir::ArrayAttr;
    noalias_scopesTy noalias_scopes;

    auto getNoaliasScopes() const {
      auto &propStorage = this->noalias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNoaliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->noalias_scopes = propValue;
    }
    using success_orderingTy = ::mlir::LLVM::AtomicOrderingAttr;
    success_orderingTy success_ordering;

    auto getSuccessOrdering() const {
      auto &propStorage = this->success_ordering;
      return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(propStorage);
    }
    void setSuccessOrdering(const ::mlir::LLVM::AtomicOrderingAttr &propValue) {
      this->success_ordering = propValue;
    }
    using syncscopeTy = ::mlir::StringAttr;
    syncscopeTy syncscope;

    auto getSyncscope() const {
      auto &propStorage = this->syncscope;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSyncscope(const ::mlir::StringAttr &propValue) {
      this->syncscope = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    using volatile_Ty = ::mlir::UnitAttr;
    volatile_Ty volatile_;

    auto getVolatile_() const {
      auto &propStorage = this->volatile_;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setVolatile_(const ::mlir::UnitAttr &propValue) {
      this->volatile_ = propValue;
    }
    using weakTy = ::mlir::UnitAttr;
    weakTy weak;

    auto getWeak() const {
      auto &propStorage = this->weak;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setWeak(const ::mlir::UnitAttr &propValue) {
      this->weak = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.access_groups == this->access_groups &&
        rhs.alias_scopes == this->alias_scopes &&
        rhs.alignment == this->alignment &&
        rhs.failure_ordering == this->failure_ordering &&
        rhs.noalias_scopes == this->noalias_scopes &&
        rhs.success_ordering == this->success_ordering &&
        rhs.syncscope == this->syncscope &&
        rhs.tbaa == this->tbaa &&
        rhs.volatile_ == this->volatile_ &&
        rhs.weak == this->weak &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicCmpXchgOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.cmpxchg", odsAttrs.getContext());
  }

  AtomicCmpXchgOpGenericAdaptorBase(AtomicCmpXchgOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::AtomicOrderingAttr getSuccessOrderingAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().success_ordering);
    return attr;
  }

  ::mlir::LLVM::AtomicOrdering getSuccessOrdering();
  ::mlir::LLVM::AtomicOrderingAttr getFailureOrderingAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().failure_ordering);
    return attr;
  }

  ::mlir::LLVM::AtomicOrdering getFailureOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::UnitAttr getWeakAttr();
  bool getWeak();
  ::mlir::UnitAttr getVolatile_Attr();
  bool getVolatile_();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
};

} // namespace detail
template <typename RangeT>
class AtomicCmpXchgOpGenericAdaptor : public detail::AtomicCmpXchgOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicCmpXchgOpGenericAdaptorBase;
  static constexpr int odsIndex_ptr = 0;
  static constexpr int odsIndex_cmp = 1;
  static constexpr int odsIndex_val = 2;
public:
  AtomicCmpXchgOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicCmpXchgOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicCmpXchgOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicCmpXchgOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicCmpXchgOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicCmpXchgOpGenericAdaptor(RangeT values, const AtomicCmpXchgOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicCmpXchgOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicCmpXchgOp>>>
  AtomicCmpXchgOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPtr() {
    return (*getODSOperands(0).begin());
  }

  ValueT getCmp() {
    return (*getODSOperands(1).begin());
  }

  ValueT getVal() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicCmpXchgOpAdaptor : public AtomicCmpXchgOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicCmpXchgOpGenericAdaptor::AtomicCmpXchgOpGenericAdaptor;
  AtomicCmpXchgOpAdaptor(AtomicCmpXchgOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicCmpXchgOp : public ::mlir::Op<AtomicCmpXchgOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LLVM::AccessGroupOpInterface::Trait, ::mlir::LLVM::AliasAnalysisOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicCmpXchgOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicCmpXchgOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ptr = 0;
  static constexpr int odsIndex_cmp = 1;
  static constexpr int odsIndex_val = 2;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<AtomicCmpXchgOp>::getAccessGroupsOrNull;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<AtomicCmpXchgOp>::setAccessGroups;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicCmpXchgOp>::getAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicCmpXchgOp>::setAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicCmpXchgOp>::getNoAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicCmpXchgOp>::setNoAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicCmpXchgOp>::getTBAATagsOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicCmpXchgOp>::setTBAATags;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("access_groups"), ::llvm::StringRef("alias_scopes"), ::llvm::StringRef("alignment"), ::llvm::StringRef("failure_ordering"), ::llvm::StringRef("noalias_scopes"), ::llvm::StringRef("success_ordering"), ::llvm::StringRef("syncscope"), ::llvm::StringRef("tbaa"), ::llvm::StringRef("volatile_"), ::llvm::StringRef("weak")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAccessGroupsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAccessGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAliasScopesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getFailureOrderingAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getFailureOrderingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getNoaliasScopesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getNoaliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getSuccessOrderingAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getSuccessOrderingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSyncscopeAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSyncscopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getVolatile_AttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getVolatile_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getWeakAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getWeakAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.cmpxchg");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getCmp() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCmpMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::AtomicOrderingAttr getSuccessOrderingAttr() {
    return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().success_ordering);
  }

  ::mlir::LLVM::AtomicOrdering getSuccessOrdering();
  ::mlir::LLVM::AtomicOrderingAttr getFailureOrderingAttr() {
    return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().failure_ordering);
  }

  ::mlir::LLVM::AtomicOrdering getFailureOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::UnitAttr getWeakAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().weak);
  }

  bool getWeak();
  ::mlir::UnitAttr getVolatile_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().volatile_);
  }

  bool getVolatile_();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  void setSuccessOrderingAttr(::mlir::LLVM::AtomicOrderingAttr attr) {
    getProperties().success_ordering = attr;
  }

  void setSuccessOrdering(::mlir::LLVM::AtomicOrdering attrValue);
  void setFailureOrderingAttr(::mlir::LLVM::AtomicOrderingAttr attr) {
    getProperties().failure_ordering = attr;
  }

  void setFailureOrdering(::mlir::LLVM::AtomicOrdering attrValue);
  void setSyncscopeAttr(::mlir::StringAttr attr) {
    getProperties().syncscope = attr;
  }

  void setSyncscope(::std::optional<::llvm::StringRef> attrValue);
  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  void setWeakAttr(::mlir::UnitAttr attr) {
    getProperties().weak = attr;
  }

  void setWeak(bool attrValue);
  void setVolatile_Attr(::mlir::UnitAttr attr) {
    getProperties().volatile_ = attr;
  }

  void setVolatile_(bool attrValue);
  void setAccessGroupsAttr(::mlir::ArrayAttr attr) {
    getProperties().access_groups = attr;
  }

  void setAliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().alias_scopes = attr;
  }

  void setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().noalias_scopes = attr;
  }

  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  ::mlir::Attribute removeSyncscopeAttr() {
      auto attr = getProperties().syncscope;
      getProperties().syncscope = {};
      return attr;
  }

  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  ::mlir::Attribute removeWeakAttr() {
      auto attr = getProperties().weak;
      getProperties().weak = {};
      return attr;
  }

  ::mlir::Attribute removeVolatile_Attr() {
      auto attr = getProperties().volatile_;
      getProperties().volatile_ = {};
      return attr;
  }

  ::mlir::Attribute removeAccessGroupsAttr() {
      auto attr = getProperties().access_groups;
      getProperties().access_groups = {};
      return attr;
  }

  ::mlir::Attribute removeAliasScopesAttr() {
      auto attr = getProperties().alias_scopes;
      getProperties().alias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeNoaliasScopesAttr() {
      auto attr = getProperties().noalias_scopes;
      getProperties().noalias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value ptr, Value cmp, Value val, LLVM::AtomicOrdering successOrdering, LLVM::AtomicOrdering failureOrdering, StringRef syncscope = StringRef(), unsigned alignment = 0, bool isWeak = false, bool isVolatile = false);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value ptr, Value cmp, Value val, LLVM::AtomicOrdering successOrdering, LLVM::AtomicOrdering failureOrdering, StringRef syncscope = StringRef(), unsigned alignment = 0, bool isWeak = false, bool isVolatile = false);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, Value ptr, Value cmp, Value val, LLVM::AtomicOrdering successOrdering, LLVM::AtomicOrdering failureOrdering, StringRef syncscope = StringRef(), unsigned alignment = 0, bool isWeak = false, bool isVolatile = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr success_ordering, ::mlir::LLVM::AtomicOrderingAttr failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr weak, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value cmp, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering success_ordering, ::mlir::LLVM::AtomicOrdering failure_ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool weak, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCmpXchgOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicCmpXchgOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::llvm::SmallVector<::mlir::Value> getAccessedOperands();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 10 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AtomicCmpXchgOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AtomicRMWOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AtomicRMWOpGenericAdaptorBase {
public:
  struct Properties {
    using access_groupsTy = ::mlir::ArrayAttr;
    access_groupsTy access_groups;

    auto getAccessGroups() const {
      auto &propStorage = this->access_groups;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAccessGroups(const ::mlir::ArrayAttr &propValue) {
      this->access_groups = propValue;
    }
    using alias_scopesTy = ::mlir::ArrayAttr;
    alias_scopesTy alias_scopes;

    auto getAliasScopes() const {
      auto &propStorage = this->alias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->alias_scopes = propValue;
    }
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using bin_opTy = ::mlir::LLVM::AtomicBinOpAttr;
    bin_opTy bin_op;

    auto getBinOp() const {
      auto &propStorage = this->bin_op;
      return ::llvm::cast<::mlir::LLVM::AtomicBinOpAttr>(propStorage);
    }
    void setBinOp(const ::mlir::LLVM::AtomicBinOpAttr &propValue) {
      this->bin_op = propValue;
    }
    using noalias_scopesTy = ::mlir::ArrayAttr;
    noalias_scopesTy noalias_scopes;

    auto getNoaliasScopes() const {
      auto &propStorage = this->noalias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNoaliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->noalias_scopes = propValue;
    }
    using orderingTy = ::mlir::LLVM::AtomicOrderingAttr;
    orderingTy ordering;

    auto getOrdering() const {
      auto &propStorage = this->ordering;
      return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(propStorage);
    }
    void setOrdering(const ::mlir::LLVM::AtomicOrderingAttr &propValue) {
      this->ordering = propValue;
    }
    using syncscopeTy = ::mlir::StringAttr;
    syncscopeTy syncscope;

    auto getSyncscope() const {
      auto &propStorage = this->syncscope;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSyncscope(const ::mlir::StringAttr &propValue) {
      this->syncscope = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    using volatile_Ty = ::mlir::UnitAttr;
    volatile_Ty volatile_;

    auto getVolatile_() const {
      auto &propStorage = this->volatile_;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setVolatile_(const ::mlir::UnitAttr &propValue) {
      this->volatile_ = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.access_groups == this->access_groups &&
        rhs.alias_scopes == this->alias_scopes &&
        rhs.alignment == this->alignment &&
        rhs.bin_op == this->bin_op &&
        rhs.noalias_scopes == this->noalias_scopes &&
        rhs.ordering == this->ordering &&
        rhs.syncscope == this->syncscope &&
        rhs.tbaa == this->tbaa &&
        rhs.volatile_ == this->volatile_ &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AtomicRMWOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.atomicrmw", odsAttrs.getContext());
  }

  AtomicRMWOpGenericAdaptorBase(AtomicRMWOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::AtomicBinOpAttr getBinOpAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::AtomicBinOpAttr>(getProperties().bin_op);
    return attr;
  }

  ::mlir::LLVM::AtomicBinOp getBinOp();
  ::mlir::LLVM::AtomicOrderingAttr getOrderingAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().ordering);
    return attr;
  }

  ::mlir::LLVM::AtomicOrdering getOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::UnitAttr getVolatile_Attr();
  bool getVolatile_();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
};

} // namespace detail
template <typename RangeT>
class AtomicRMWOpGenericAdaptor : public detail::AtomicRMWOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AtomicRMWOpGenericAdaptorBase;
  static constexpr int odsIndex_ptr = 0;
  static constexpr int odsIndex_val = 1;
public:
  AtomicRMWOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AtomicRMWOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AtomicRMWOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AtomicRMWOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AtomicRMWOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AtomicRMWOpGenericAdaptor(RangeT values, const AtomicRMWOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AtomicRMWOp, typename = std::enable_if_t<std::is_same_v<LateInst, AtomicRMWOp>>>
  AtomicRMWOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPtr() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVal() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AtomicRMWOpAdaptor : public AtomicRMWOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AtomicRMWOpGenericAdaptor::AtomicRMWOpGenericAdaptor;
  AtomicRMWOpAdaptor(AtomicRMWOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AtomicRMWOp : public ::mlir::Op<AtomicRMWOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LLVM::AccessGroupOpInterface::Trait, ::mlir::LLVM::AliasAnalysisOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AtomicRMWOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AtomicRMWOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ptr = 0;
  static constexpr int odsIndex_val = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<AtomicRMWOp>::getAccessGroupsOrNull;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<AtomicRMWOp>::setAccessGroups;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicRMWOp>::getAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicRMWOp>::setAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicRMWOp>::getNoAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicRMWOp>::setNoAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicRMWOp>::getTBAATagsOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<AtomicRMWOp>::setTBAATags;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("access_groups"), ::llvm::StringRef("alias_scopes"), ::llvm::StringRef("alignment"), ::llvm::StringRef("bin_op"), ::llvm::StringRef("noalias_scopes"), ::llvm::StringRef("ordering"), ::llvm::StringRef("syncscope"), ::llvm::StringRef("tbaa"), ::llvm::StringRef("volatile_")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAccessGroupsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAccessGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAliasScopesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getBinOpAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getBinOpAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getNoaliasScopesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getNoaliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOrderingAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getOrderingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSyncscopeAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSyncscopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getVolatile_AttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getVolatile_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.atomicrmw");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::AtomicBinOpAttr getBinOpAttr() {
    return ::llvm::cast<::mlir::LLVM::AtomicBinOpAttr>(getProperties().bin_op);
  }

  ::mlir::LLVM::AtomicBinOp getBinOp();
  ::mlir::LLVM::AtomicOrderingAttr getOrderingAttr() {
    return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().ordering);
  }

  ::mlir::LLVM::AtomicOrdering getOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::UnitAttr getVolatile_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().volatile_);
  }

  bool getVolatile_();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  void setBinOpAttr(::mlir::LLVM::AtomicBinOpAttr attr) {
    getProperties().bin_op = attr;
  }

  void setBinOp(::mlir::LLVM::AtomicBinOp attrValue);
  void setOrderingAttr(::mlir::LLVM::AtomicOrderingAttr attr) {
    getProperties().ordering = attr;
  }

  void setOrdering(::mlir::LLVM::AtomicOrdering attrValue);
  void setSyncscopeAttr(::mlir::StringAttr attr) {
    getProperties().syncscope = attr;
  }

  void setSyncscope(::std::optional<::llvm::StringRef> attrValue);
  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  void setVolatile_Attr(::mlir::UnitAttr attr) {
    getProperties().volatile_ = attr;
  }

  void setVolatile_(bool attrValue);
  void setAccessGroupsAttr(::mlir::ArrayAttr attr) {
    getProperties().access_groups = attr;
  }

  void setAliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().alias_scopes = attr;
  }

  void setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().noalias_scopes = attr;
  }

  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  ::mlir::Attribute removeSyncscopeAttr() {
      auto attr = getProperties().syncscope;
      getProperties().syncscope = {};
      return attr;
  }

  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  ::mlir::Attribute removeVolatile_Attr() {
      auto attr = getProperties().volatile_;
      getProperties().volatile_ = {};
      return attr;
  }

  ::mlir::Attribute removeAccessGroupsAttr() {
      auto attr = getProperties().access_groups;
      getProperties().access_groups = {};
      return attr;
  }

  ::mlir::Attribute removeAliasScopesAttr() {
      auto attr = getProperties().alias_scopes;
      getProperties().alias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeNoaliasScopesAttr() {
      auto attr = getProperties().noalias_scopes;
      getProperties().noalias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVM::AtomicBinOp binOp, Value ptr, Value val, LLVM::AtomicOrdering ordering, StringRef syncscope = StringRef(), unsigned alignment = 0, bool isVolatile = false);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVM::AtomicBinOp binOp, Value ptr, Value val, LLVM::AtomicOrdering ordering, StringRef syncscope = StringRef(), unsigned alignment = 0, bool isVolatile = false);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, LLVM::AtomicBinOp binOp, Value ptr, Value val, LLVM::AtomicOrdering ordering, StringRef syncscope = StringRef(), unsigned alignment = 0, bool isVolatile = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicBinOpAttr bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicBinOp bin_op, ::mlir::Value ptr, ::mlir::Value val, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicRMWOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AtomicRMWOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  ::llvm::SmallVector<::mlir::Value> getAccessedOperands();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::AtomicRMWOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::BitcastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BitcastOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BitcastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.bitcast", odsAttrs.getContext());
  }

  BitcastOpGenericAdaptorBase(BitcastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BitcastOpGenericAdaptor : public detail::BitcastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BitcastOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  BitcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BitcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BitcastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BitcastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BitcastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BitcastOpGenericAdaptor(RangeT values, const BitcastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BitcastOp, typename = std::enable_if_t<std::is_same_v<LateInst, BitcastOp>>>
  BitcastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BitcastOpAdaptor : public BitcastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BitcastOpGenericAdaptor::BitcastOpGenericAdaptor;
  BitcastOpAdaptor(BitcastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BitcastOp : public ::mlir::Op<BitcastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::PromotableOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BitcastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BitcastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::PromotableOpInterface::Trait<BitcastOp>::requiresReplacedValues;
  using ::mlir::PromotableOpInterface::Trait<BitcastOp>::visitReplacedValues;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.bitcast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg);
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg);
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitcastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BitcastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  bool canUsesBeRemoved(const ::llvm::SmallPtrSetImpl<::mlir::OpOperand *> &blockingUses, ::llvm::SmallVectorImpl<::mlir::OpOperand *> &newBlockingUses, const ::mlir::DataLayout &datalayout);
  ::mlir::DeletionKind removeBlockingUses(const ::llvm::SmallPtrSetImpl<mlir::OpOperand *> &blockingUses, ::mlir::OpBuilder &builder);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::BitcastOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::BlockAddressOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockAddressOpGenericAdaptorBase {
public:
  struct Properties {
    using block_addrTy = ::mlir::LLVM::BlockAddressAttr;
    block_addrTy block_addr;

    auto getBlockAddr() const {
      auto &propStorage = this->block_addr;
      return ::llvm::cast<::mlir::LLVM::BlockAddressAttr>(propStorage);
    }
    void setBlockAddr(const ::mlir::LLVM::BlockAddressAttr &propValue) {
      this->block_addr = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.block_addr == this->block_addr &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockAddressOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.blockaddress", odsAttrs.getContext());
  }

  BlockAddressOpGenericAdaptorBase(BlockAddressOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::BlockAddressAttr getBlockAddrAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::BlockAddressAttr>(getProperties().block_addr);
    return attr;
  }

  ::mlir::LLVM::BlockAddressAttr getBlockAddr();
};

} // namespace detail
template <typename RangeT>
class BlockAddressOpGenericAdaptor : public detail::BlockAddressOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockAddressOpGenericAdaptorBase;
public:
  BlockAddressOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockAddressOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockAddressOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockAddressOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockAddressOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockAddressOpGenericAdaptor(RangeT values, const BlockAddressOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockAddressOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockAddressOp>>>
  BlockAddressOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockAddressOpAdaptor : public BlockAddressOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockAddressOpGenericAdaptor::BlockAddressOpGenericAdaptor;
  BlockAddressOpAdaptor(BlockAddressOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockAddressOp : public ::mlir::Op<BlockAddressOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::LLVM::LLVMPointerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ConstantLike, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockAddressOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockAddressOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("block_addr")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockAddrAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockAddrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.blockaddress");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::BlockAddressAttr getBlockAddrAttr() {
    return ::llvm::cast<::mlir::LLVM::BlockAddressAttr>(getProperties().block_addr);
  }

  ::mlir::LLVM::BlockAddressAttr getBlockAddr();
  void setBlockAddrAttr(::mlir::LLVM::BlockAddressAttr attr) {
    getProperties().block_addr = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::BlockAddressAttr block_addr);
  static BlockAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::BlockAddressAttr block_addr);
  static BlockAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::BlockAddressAttr block_addr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::BlockAddressAttr block_addr);
  static BlockAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::BlockAddressAttr block_addr);
  static BlockAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::BlockAddressAttr block_addr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockAddressOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockAddressOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return the llvm.func operation that is referenced here.
  LLVMFuncOp getFunction(SymbolTableCollection &symbolTable);

  /// Search for the matching `llvm.blocktag` operation. This is performed
  /// by walking the function in `block_addr`.
  BlockTagOp getBlockTagOp();
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::BlockAddressOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::BlockTagOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockTagOpGenericAdaptorBase {
public:
  struct Properties {
    using tagTy = ::mlir::LLVM::BlockTagAttr;
    tagTy tag;

    auto getTag() const {
      auto &propStorage = this->tag;
      return ::llvm::cast<::mlir::LLVM::BlockTagAttr>(propStorage);
    }
    void setTag(const ::mlir::LLVM::BlockTagAttr &propValue) {
      this->tag = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.tag == this->tag &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockTagOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.blocktag", odsAttrs.getContext());
  }

  BlockTagOpGenericAdaptorBase(BlockTagOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::BlockTagAttr getTagAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::BlockTagAttr>(getProperties().tag);
    return attr;
  }

  ::mlir::LLVM::BlockTagAttr getTag();
};

} // namespace detail
template <typename RangeT>
class BlockTagOpGenericAdaptor : public detail::BlockTagOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockTagOpGenericAdaptorBase;
public:
  BlockTagOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockTagOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockTagOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockTagOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockTagOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockTagOpGenericAdaptor(RangeT values, const BlockTagOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockTagOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockTagOp>>>
  BlockTagOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockTagOpAdaptor : public BlockTagOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockTagOpGenericAdaptor::BlockTagOpGenericAdaptor;
  BlockTagOpAdaptor(BlockTagOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockTagOp : public ::mlir::Op<BlockTagOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockTagOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockTagOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("tag")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTagAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTagAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.blocktag");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::BlockTagAttr getTagAttr() {
    return ::llvm::cast<::mlir::LLVM::BlockTagAttr>(getProperties().tag);
  }

  ::mlir::LLVM::BlockTagAttr getTag();
  void setTagAttr(::mlir::LLVM::BlockTagAttr attr) {
    getProperties().tag = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::BlockTagAttr tag);
  static BlockTagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::BlockTagAttr tag);
  static BlockTagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::BlockTagAttr tag);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::BlockTagAttr tag);
  static BlockTagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::BlockTagAttr tag);
  static BlockTagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::BlockTagAttr tag);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockTagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockTagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockTagOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockTagOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::BlockTagOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::BrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BrOpGenericAdaptorBase {
public:
  struct Properties {
    using loop_annotationTy = ::mlir::LLVM::LoopAnnotationAttr;
    loop_annotationTy loop_annotation;

    auto getLoopAnnotation() const {
      auto &propStorage = this->loop_annotation;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(propStorage);
    }
    void setLoopAnnotation(const ::mlir::LLVM::LoopAnnotationAttr &propValue) {
      this->loop_annotation = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.loop_annotation == this->loop_annotation &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.br", odsAttrs.getContext());
  }

  BrOpGenericAdaptorBase(BrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loop_annotation);
    return attr;
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
};

} // namespace detail
template <typename RangeT>
class BrOpGenericAdaptor : public detail::BrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BrOpGenericAdaptorBase;
  static constexpr int odsIndex_destOperands = 0;
public:
  BrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BrOpGenericAdaptor(RangeT values, const BrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BrOp, typename = std::enable_if_t<std::is_same_v<LateInst, BrOp>>>
  BrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getDestOperands() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BrOpAdaptor : public BrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BrOpGenericAdaptor::BrOpGenericAdaptor;
  BrOpAdaptor(BrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BrOp : public ::mlir::Op<BrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::OneSuccessor, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::BranchOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_destOperands = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::BranchOpInterface::Trait<BrOp>::getSuccessorForOperands;
  using ::mlir::BranchOpInterface::Trait<BrOp>::areTypesCompatible;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("loop_annotation")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getLoopAnnotationAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getLoopAnnotationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.br");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getDestOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getDestOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Block *getDest() {
    return (*this)->getSuccessor(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loop_annotation);
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
  void setLoopAnnotationAttr(::mlir::LLVM::LoopAnnotationAttr attr) {
    getProperties().loop_annotation = attr;
  }

  ::mlir::Attribute removeLoopAnnotationAttr() {
      auto attr = getProperties().loop_annotation;
      getProperties().loop_annotation = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Block *dest);
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Block *dest);
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, Block *dest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ValueRange operands, Block *dest);
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ValueRange operands, Block *dest);
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, ValueRange operands, Block *dest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ValueRange operands, SuccessorRange destinations, ArrayRef<NamedAttribute> attributes = {});
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ValueRange operands, SuccessorRange destinations, ArrayRef<NamedAttribute> attributes = {});
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, ValueRange operands, SuccessorRange destinations, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange destOperands, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *dest);
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange destOperands, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *dest);
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange destOperands, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *dest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange destOperands, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *dest);
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange destOperands, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *dest);
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange destOperands, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *dest);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::SuccessorOperands getSuccessorOperands(unsigned index);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::BrOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CallIntrinsicOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CallIntrinsicOpGenericAdaptorBase {
public:
  struct Properties {
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    using intrinTy = ::mlir::StringAttr;
    intrinTy intrin;

    auto getIntrin() const {
      auto &propStorage = this->intrin;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setIntrin(const ::mlir::StringAttr &propValue) {
      this->intrin = propValue;
    }
    using op_bundle_sizesTy = ::mlir::DenseI32ArrayAttr;
    op_bundle_sizesTy op_bundle_sizes;

    auto getOpBundleSizes() const {
      auto &propStorage = this->op_bundle_sizes;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setOpBundleSizes(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->op_bundle_sizes = propValue;
    }
    using op_bundle_tagsTy = ::mlir::ArrayAttr;
    op_bundle_tagsTy op_bundle_tags;

    auto getOpBundleTags() const {
      auto &propStorage = this->op_bundle_tags;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOpBundleTags(const ::mlir::ArrayAttr &propValue) {
      this->op_bundle_tags = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.arg_attrs == this->arg_attrs &&
        rhs.fastmathFlags == this->fastmathFlags &&
        rhs.intrin == this->intrin &&
        rhs.op_bundle_sizes == this->op_bundle_sizes &&
        rhs.op_bundle_tags == this->op_bundle_tags &&
        rhs.res_attrs == this->res_attrs &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CallIntrinsicOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.call_intrinsic", odsAttrs.getContext());
  }

  CallIntrinsicOpGenericAdaptorBase(CallIntrinsicOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getIntrinAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().intrin);
    return attr;
  }

  ::llvm::StringRef getIntrin();
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  ::mlir::DenseI32ArrayAttr getOpBundleSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().op_bundle_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getOpBundleSizes();
  ::mlir::ArrayAttr getOpBundleTagsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().op_bundle_tags);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getOpBundleTags();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
};

} // namespace detail
template <typename RangeT>
class CallIntrinsicOpGenericAdaptor : public detail::CallIntrinsicOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CallIntrinsicOpGenericAdaptorBase;
  static constexpr int odsIndex_args = 0;
  static constexpr int odsIndex_op_bundle_operands = 1;
public:
  CallIntrinsicOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CallIntrinsicOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CallIntrinsicOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CallIntrinsicOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CallIntrinsicOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CallIntrinsicOpGenericAdaptor(RangeT values, const CallIntrinsicOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CallIntrinsicOp, typename = std::enable_if_t<std::is_same_v<LateInst, CallIntrinsicOp>>>
  CallIntrinsicOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getArgs() {
    return getODSOperands(0);
  }

  ::llvm::SmallVector<RangeT> getOpBundleOperands() {
    auto tblgenTmpOperands = getODSOperands(1);
    auto sizes = getOpBundleSizes();

    ::llvm::SmallVector<RangeT> tblgenTmpOperandGroups;
    for (int i = 0, e = sizes.size(); i < e; ++i) {
      tblgenTmpOperandGroups.push_back(tblgenTmpOperands.take_front(sizes[i]));
      tblgenTmpOperands = tblgenTmpOperands.drop_front(sizes[i]);
    }
    return tblgenTmpOperandGroups;
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CallIntrinsicOpAdaptor : public CallIntrinsicOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CallIntrinsicOpGenericAdaptor::CallIntrinsicOpGenericAdaptor;
  CallIntrinsicOpAdaptor(CallIntrinsicOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CallIntrinsicOp : public ::mlir::Op<CallIntrinsicOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ArgAndResultAttrsOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CallIntrinsicOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CallIntrinsicOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_args = 0;
  static constexpr int odsIndex_op_bundle_operands = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<CallIntrinsicOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<CallIntrinsicOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("arg_attrs"), ::llvm::StringRef("fastmathFlags"), ::llvm::StringRef("intrin"), ::llvm::StringRef("op_bundle_sizes"), ::llvm::StringRef("op_bundle_tags"), ::llvm::StringRef("res_attrs"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getIntrinAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getIntrinAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOpBundleSizesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getOpBundleSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOpBundleTagsAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getOpBundleTagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.call_intrinsic");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getArgs() {
    return getODSOperands(0);
  }

  ::mlir::OperandRangeRange getOpBundleOperands() {
    return getODSOperands(1).split(getOpBundleSizesAttr());
  }

  ::mlir::MutableOperandRange getArgsMutable();
  ::mlir::MutableOperandRangeRange getOpBundleOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResults() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::Type>() : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getIntrinAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().intrin);
  }

  ::llvm::StringRef getIntrin();
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  ::mlir::DenseI32ArrayAttr getOpBundleSizesAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().op_bundle_sizes);
  }

  ::llvm::ArrayRef<int32_t> getOpBundleSizes();
  ::mlir::ArrayAttr getOpBundleTagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().op_bundle_tags);
  }

  ::std::optional< ::mlir::ArrayAttr > getOpBundleTags();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  void setIntrinAttr(::mlir::StringAttr attr) {
    getProperties().intrin = attr;
  }

  void setIntrin(::llvm::StringRef attrValue);
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  void setOpBundleSizesAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().op_bundle_sizes = attr;
  }

  void setOpBundleSizes(::llvm::ArrayRef<int32_t> attrValue);
  void setOpBundleTagsAttr(::mlir::ArrayAttr attr) {
    getProperties().op_bundle_tags = attr;
  }

  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  ::mlir::Attribute removeOpBundleTagsAttr() {
      auto attr = getProperties().op_bundle_tags;
      getProperties().op_bundle_tags = {};
      return attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, StringAttr intrin, ValueRange args);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, StringAttr intrin, ValueRange args);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, StringAttr intrin, ValueRange args);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, StringAttr intrin, ValueRange args, FastmathFlagsAttr fastMathFlags);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, StringAttr intrin, ValueRange args, FastmathFlagsAttr fastMathFlags);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, StringAttr intrin, ValueRange args, FastmathFlagsAttr fastMathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, StringAttr intrin, ValueRange args);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, StringAttr intrin, ValueRange args);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, StringAttr intrin, ValueRange args);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange resultTypes, StringAttr intrin, ValueRange args, FastmathFlagsAttr fastMathFlags);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TypeRange resultTypes, StringAttr intrin, ValueRange args, FastmathFlagsAttr fastMathFlags);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, TypeRange resultTypes, StringAttr intrin, ValueRange args, FastmathFlagsAttr fastMathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type results, ::mlir::StringAttr intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type results, ::mlir::StringAttr intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type results, ::mlir::StringAttr intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type results, ::llvm::StringRef intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlags fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type results, ::llvm::StringRef intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlags fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type results, ::llvm::StringRef intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlags fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlags fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlags fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef intrin, ::mlir::ValueRange args, ::mlir::LLVM::FastmathFlags fastmathFlags, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CallIntrinsicOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CallIntrinsicOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::CallIntrinsicOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CallOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CallOpGenericAdaptorBase {
public:
  struct Properties {
    using CConvTy = ::mlir::LLVM::CConvAttr;
    CConvTy CConv;

    auto getCConv() const {
      auto &propStorage = this->CConv;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::CConvAttr>(propStorage);
    }
    void setCConv(const ::mlir::LLVM::CConvAttr &propValue) {
      this->CConv = propValue;
    }
    using TailCallKindTy = ::mlir::LLVM::TailCallKindAttr;
    TailCallKindTy TailCallKind;

    auto getTailCallKind() const {
      auto &propStorage = this->TailCallKind;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::TailCallKindAttr>(propStorage);
    }
    void setTailCallKind(const ::mlir::LLVM::TailCallKindAttr &propValue) {
      this->TailCallKind = propValue;
    }
    using access_groupsTy = ::mlir::ArrayAttr;
    access_groupsTy access_groups;

    auto getAccessGroups() const {
      auto &propStorage = this->access_groups;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAccessGroups(const ::mlir::ArrayAttr &propValue) {
      this->access_groups = propValue;
    }
    using alias_scopesTy = ::mlir::ArrayAttr;
    alias_scopesTy alias_scopes;

    auto getAliasScopes() const {
      auto &propStorage = this->alias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->alias_scopes = propValue;
    }
    using always_inlineTy = ::mlir::UnitAttr;
    always_inlineTy always_inline;

    auto getAlwaysInline() const {
      auto &propStorage = this->always_inline;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAlwaysInline(const ::mlir::UnitAttr &propValue) {
      this->always_inline = propValue;
    }
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using calleeTy = ::mlir::FlatSymbolRefAttr;
    calleeTy callee;

    auto getCallee() const {
      auto &propStorage = this->callee;
      return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setCallee(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->callee = propValue;
    }
    using convergentTy = ::mlir::UnitAttr;
    convergentTy convergent;

    auto getConvergent() const {
      auto &propStorage = this->convergent;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setConvergent(const ::mlir::UnitAttr &propValue) {
      this->convergent = propValue;
    }
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    using inline_hintTy = ::mlir::UnitAttr;
    inline_hintTy inline_hint;

    auto getInlineHint() const {
      auto &propStorage = this->inline_hint;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInlineHint(const ::mlir::UnitAttr &propValue) {
      this->inline_hint = propValue;
    }
    using memory_effectsTy = ::mlir::LLVM::MemoryEffectsAttr;
    memory_effectsTy memory_effects;

    auto getMemoryEffects() const {
      auto &propStorage = this->memory_effects;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::MemoryEffectsAttr>(propStorage);
    }
    void setMemoryEffects(const ::mlir::LLVM::MemoryEffectsAttr &propValue) {
      this->memory_effects = propValue;
    }
    using no_inlineTy = ::mlir::UnitAttr;
    no_inlineTy no_inline;

    auto getNoInline() const {
      auto &propStorage = this->no_inline;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNoInline(const ::mlir::UnitAttr &propValue) {
      this->no_inline = propValue;
    }
    using no_unwindTy = ::mlir::UnitAttr;
    no_unwindTy no_unwind;

    auto getNoUnwind() const {
      auto &propStorage = this->no_unwind;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNoUnwind(const ::mlir::UnitAttr &propValue) {
      this->no_unwind = propValue;
    }
    using noalias_scopesTy = ::mlir::ArrayAttr;
    noalias_scopesTy noalias_scopes;

    auto getNoaliasScopes() const {
      auto &propStorage = this->noalias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNoaliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->noalias_scopes = propValue;
    }
    using op_bundle_sizesTy = ::mlir::DenseI32ArrayAttr;
    op_bundle_sizesTy op_bundle_sizes;

    auto getOpBundleSizes() const {
      auto &propStorage = this->op_bundle_sizes;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setOpBundleSizes(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->op_bundle_sizes = propValue;
    }
    using op_bundle_tagsTy = ::mlir::ArrayAttr;
    op_bundle_tagsTy op_bundle_tags;

    auto getOpBundleTags() const {
      auto &propStorage = this->op_bundle_tags;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOpBundleTags(const ::mlir::ArrayAttr &propValue) {
      this->op_bundle_tags = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    using var_callee_typeTy = ::mlir::TypeAttr;
    var_callee_typeTy var_callee_type;

    auto getVarCalleeType() const {
      auto &propStorage = this->var_callee_type;
      return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(propStorage);
    }
    void setVarCalleeType(const ::mlir::TypeAttr &propValue) {
      this->var_callee_type = propValue;
    }
    using will_returnTy = ::mlir::UnitAttr;
    will_returnTy will_return;

    auto getWillReturn() const {
      auto &propStorage = this->will_return;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setWillReturn(const ::mlir::UnitAttr &propValue) {
      this->will_return = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.CConv == this->CConv &&
        rhs.TailCallKind == this->TailCallKind &&
        rhs.access_groups == this->access_groups &&
        rhs.alias_scopes == this->alias_scopes &&
        rhs.always_inline == this->always_inline &&
        rhs.arg_attrs == this->arg_attrs &&
        rhs.callee == this->callee &&
        rhs.convergent == this->convergent &&
        rhs.fastmathFlags == this->fastmathFlags &&
        rhs.inline_hint == this->inline_hint &&
        rhs.memory_effects == this->memory_effects &&
        rhs.no_inline == this->no_inline &&
        rhs.no_unwind == this->no_unwind &&
        rhs.noalias_scopes == this->noalias_scopes &&
        rhs.op_bundle_sizes == this->op_bundle_sizes &&
        rhs.op_bundle_tags == this->op_bundle_tags &&
        rhs.res_attrs == this->res_attrs &&
        rhs.tbaa == this->tbaa &&
        rhs.var_callee_type == this->var_callee_type &&
        rhs.will_return == this->will_return &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CallOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.call", odsAttrs.getContext());
  }

  CallOpGenericAdaptorBase(CallOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarCalleeTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().var_callee_type);
    return attr;
  }

  ::std::optional<::mlir::LLVM::LLVMFunctionType> getVarCalleeType();
  ::mlir::FlatSymbolRefAttr getCalleeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().callee);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getCallee();
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  ::mlir::LLVM::CConvAttr getCConvAttr();
  ::mlir::LLVM::cconv::CConv getCConv();
  ::mlir::LLVM::TailCallKindAttr getTailCallKindAttr();
  ::mlir::LLVM::tailcallkind::TailCallKind getTailCallKind();
  ::mlir::LLVM::MemoryEffectsAttr getMemoryEffectsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::MemoryEffectsAttr>(getProperties().memory_effects);
    return attr;
  }

  ::std::optional<::mlir::LLVM::MemoryEffectsAttr> getMemoryEffects();
  ::mlir::UnitAttr getConvergentAttr();
  bool getConvergent();
  ::mlir::UnitAttr getNoUnwindAttr();
  bool getNoUnwind();
  ::mlir::UnitAttr getWillReturnAttr();
  bool getWillReturn();
  ::mlir::DenseI32ArrayAttr getOpBundleSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().op_bundle_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getOpBundleSizes();
  ::mlir::ArrayAttr getOpBundleTagsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().op_bundle_tags);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getOpBundleTags();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::UnitAttr getNoInlineAttr();
  bool getNoInline();
  ::mlir::UnitAttr getAlwaysInlineAttr();
  bool getAlwaysInline();
  ::mlir::UnitAttr getInlineHintAttr();
  bool getInlineHint();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
};

} // namespace detail
template <typename RangeT>
class CallOpGenericAdaptor : public detail::CallOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CallOpGenericAdaptorBase;
  static constexpr int odsIndex_callee_operands = 0;
  static constexpr int odsIndex_op_bundle_operands = 1;
public:
  CallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CallOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CallOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CallOpGenericAdaptor(RangeT values, const CallOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CallOp, typename = std::enable_if_t<std::is_same_v<LateInst, CallOp>>>
  CallOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getCalleeOperands() {
    return getODSOperands(0);
  }

  ::llvm::SmallVector<RangeT> getOpBundleOperands() {
    auto tblgenTmpOperands = getODSOperands(1);
    auto sizes = getOpBundleSizes();

    ::llvm::SmallVector<RangeT> tblgenTmpOperandGroups;
    for (int i = 0, e = sizes.size(); i < e; ++i) {
      tblgenTmpOperandGroups.push_back(tblgenTmpOperands.take_front(sizes[i]));
      tblgenTmpOperands = tblgenTmpOperands.drop_front(sizes[i]);
    }
    return tblgenTmpOperandGroups;
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CallOpAdaptor : public CallOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CallOpGenericAdaptor::CallOpGenericAdaptor;
  CallOpAdaptor(CallOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CallOp : public ::mlir::Op<CallOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LLVM::AccessGroupOpInterface::Trait, ::mlir::LLVM::AliasAnalysisOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::ArgAndResultAttrsOpInterface::Trait, ::mlir::CallOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CallOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CallOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_callee_operands = 0;
  static constexpr int odsIndex_op_bundle_operands = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<CallOp>::getAccessGroupsOrNull;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<CallOp>::setAccessGroups;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<CallOp>::getAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<CallOp>::setAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<CallOp>::getNoAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<CallOp>::setNoAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<CallOp>::getTBAATagsOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<CallOp>::setTBAATags;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<CallOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<CallOp>::getFastmathAttrName;
  using ::mlir::CallOpInterface::Trait<CallOp>::resolveCallableInTable;
  using ::mlir::CallOpInterface::Trait<CallOp>::resolveCallable;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("CConv"), ::llvm::StringRef("TailCallKind"), ::llvm::StringRef("access_groups"), ::llvm::StringRef("alias_scopes"), ::llvm::StringRef("always_inline"), ::llvm::StringRef("arg_attrs"), ::llvm::StringRef("callee"), ::llvm::StringRef("convergent"), ::llvm::StringRef("fastmathFlags"), ::llvm::StringRef("inline_hint"), ::llvm::StringRef("memory_effects"), ::llvm::StringRef("no_inline"), ::llvm::StringRef("no_unwind"), ::llvm::StringRef("noalias_scopes"), ::llvm::StringRef("op_bundle_sizes"), ::llvm::StringRef("op_bundle_tags"), ::llvm::StringRef("res_attrs"), ::llvm::StringRef("tbaa"), ::llvm::StringRef("var_callee_type"), ::llvm::StringRef("will_return"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCConvAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCConvAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getTailCallKindAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getTailCallKindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAccessGroupsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAccessGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getAliasScopesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getAliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getAlwaysInlineAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getAlwaysInlineAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getCalleeAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getCalleeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getConvergentAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getConvergentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getInlineHintAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getInlineHintAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getMemoryEffectsAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getMemoryEffectsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getNoInlineAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getNoInlineAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getNoUnwindAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getNoUnwindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getNoaliasScopesAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getNoaliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getOpBundleSizesAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getOpBundleSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getOpBundleTagsAttrName() {
    return getAttributeNameForIndex(15);
  }

  static ::mlir::StringAttr getOpBundleTagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 15);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(16);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 16);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(17);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 17);
  }

  ::mlir::StringAttr getVarCalleeTypeAttrName() {
    return getAttributeNameForIndex(18);
  }

  static ::mlir::StringAttr getVarCalleeTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 18);
  }

  ::mlir::StringAttr getWillReturnAttrName() {
    return getAttributeNameForIndex(19);
  }

  static ::mlir::StringAttr getWillReturnAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 19);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.call");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getCalleeOperands() {
    return getODSOperands(0);
  }

  ::mlir::OperandRangeRange getOpBundleOperands() {
    return getODSOperands(1).split(getOpBundleSizesAttr());
  }

  ::mlir::MutableOperandRange getCalleeOperandsMutable();
  ::mlir::MutableOperandRangeRange getOpBundleOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::Type>() : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarCalleeTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().var_callee_type);
  }

  ::std::optional<::mlir::LLVM::LLVMFunctionType> getVarCalleeType();
  ::mlir::FlatSymbolRefAttr getCalleeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().callee);
  }

  ::std::optional< ::llvm::StringRef > getCallee();
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  ::mlir::LLVM::CConvAttr getCConvAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::CConvAttr>(getProperties().CConv);
  }

  ::mlir::LLVM::cconv::CConv getCConv();
  ::mlir::LLVM::TailCallKindAttr getTailCallKindAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::TailCallKindAttr>(getProperties().TailCallKind);
  }

  ::mlir::LLVM::tailcallkind::TailCallKind getTailCallKind();
  ::mlir::LLVM::MemoryEffectsAttr getMemoryEffectsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::MemoryEffectsAttr>(getProperties().memory_effects);
  }

  ::std::optional<::mlir::LLVM::MemoryEffectsAttr> getMemoryEffects();
  ::mlir::UnitAttr getConvergentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().convergent);
  }

  bool getConvergent();
  ::mlir::UnitAttr getNoUnwindAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_unwind);
  }

  bool getNoUnwind();
  ::mlir::UnitAttr getWillReturnAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().will_return);
  }

  bool getWillReturn();
  ::mlir::DenseI32ArrayAttr getOpBundleSizesAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().op_bundle_sizes);
  }

  ::llvm::ArrayRef<int32_t> getOpBundleSizes();
  ::mlir::ArrayAttr getOpBundleTagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().op_bundle_tags);
  }

  ::std::optional< ::mlir::ArrayAttr > getOpBundleTags();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::UnitAttr getNoInlineAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_inline);
  }

  bool getNoInline();
  ::mlir::UnitAttr getAlwaysInlineAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().always_inline);
  }

  bool getAlwaysInline();
  ::mlir::UnitAttr getInlineHintAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().inline_hint);
  }

  bool getInlineHint();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  void setVarCalleeTypeAttr(::mlir::TypeAttr attr) {
    getProperties().var_callee_type = attr;
  }

  void setVarCalleeType(::std::optional<::mlir::LLVM::LLVMFunctionType> attrValue);
  void setCalleeAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().callee = attr;
  }

  void setCallee(::std::optional<::llvm::StringRef> attrValue);
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  void setCConvAttr(::mlir::LLVM::CConvAttr attr) {
    getProperties().CConv = attr;
  }

  void setCConv(::mlir::LLVM::cconv::CConv attrValue);
  void setTailCallKindAttr(::mlir::LLVM::TailCallKindAttr attr) {
    getProperties().TailCallKind = attr;
  }

  void setTailCallKind(::mlir::LLVM::tailcallkind::TailCallKind attrValue);
  void setMemoryEffectsAttr(::mlir::LLVM::MemoryEffectsAttr attr) {
    getProperties().memory_effects = attr;
  }

  void setConvergentAttr(::mlir::UnitAttr attr) {
    getProperties().convergent = attr;
  }

  void setConvergent(bool attrValue);
  void setNoUnwindAttr(::mlir::UnitAttr attr) {
    getProperties().no_unwind = attr;
  }

  void setNoUnwind(bool attrValue);
  void setWillReturnAttr(::mlir::UnitAttr attr) {
    getProperties().will_return = attr;
  }

  void setWillReturn(bool attrValue);
  void setOpBundleSizesAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().op_bundle_sizes = attr;
  }

  void setOpBundleSizes(::llvm::ArrayRef<int32_t> attrValue);
  void setOpBundleTagsAttr(::mlir::ArrayAttr attr) {
    getProperties().op_bundle_tags = attr;
  }

  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  void setNoInlineAttr(::mlir::UnitAttr attr) {
    getProperties().no_inline = attr;
  }

  void setNoInline(bool attrValue);
  void setAlwaysInlineAttr(::mlir::UnitAttr attr) {
    getProperties().always_inline = attr;
  }

  void setAlwaysInline(bool attrValue);
  void setInlineHintAttr(::mlir::UnitAttr attr) {
    getProperties().inline_hint = attr;
  }

  void setInlineHint(bool attrValue);
  void setAccessGroupsAttr(::mlir::ArrayAttr attr) {
    getProperties().access_groups = attr;
  }

  void setAliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().alias_scopes = attr;
  }

  void setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().noalias_scopes = attr;
  }

  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  ::mlir::Attribute removeVarCalleeTypeAttr() {
      auto attr = getProperties().var_callee_type;
      getProperties().var_callee_type = {};
      return attr;
  }

  ::mlir::Attribute removeCalleeAttr() {
      auto attr = getProperties().callee;
      getProperties().callee = {};
      return attr;
  }

  ::mlir::Attribute removeMemoryEffectsAttr() {
      auto attr = getProperties().memory_effects;
      getProperties().memory_effects = {};
      return attr;
  }

  ::mlir::Attribute removeConvergentAttr() {
      auto attr = getProperties().convergent;
      getProperties().convergent = {};
      return attr;
  }

  ::mlir::Attribute removeNoUnwindAttr() {
      auto attr = getProperties().no_unwind;
      getProperties().no_unwind = {};
      return attr;
  }

  ::mlir::Attribute removeWillReturnAttr() {
      auto attr = getProperties().will_return;
      getProperties().will_return = {};
      return attr;
  }

  ::mlir::Attribute removeOpBundleTagsAttr() {
      auto attr = getProperties().op_bundle_tags;
      getProperties().op_bundle_tags = {};
      return attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeNoInlineAttr() {
      auto attr = getProperties().no_inline;
      getProperties().no_inline = {};
      return attr;
  }

  ::mlir::Attribute removeAlwaysInlineAttr() {
      auto attr = getProperties().always_inline;
      getProperties().always_inline = {};
      return attr;
  }

  ::mlir::Attribute removeInlineHintAttr() {
      auto attr = getProperties().inline_hint;
      getProperties().inline_hint = {};
      return attr;
  }

  ::mlir::Attribute removeAccessGroupsAttr() {
      auto attr = getProperties().access_groups;
      getProperties().access_groups = {};
      return attr;
  }

  ::mlir::Attribute removeAliasScopesAttr() {
      auto attr = getProperties().alias_scopes;
      getProperties().alias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeNoaliasScopesAttr() {
      auto attr = getProperties().noalias_scopes;
      getProperties().noalias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFuncOp func, ValueRange args);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFuncOp func, ValueRange args);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFuncOp func, ValueRange args);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFunctionType calleeType, ValueRange args);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFunctionType calleeType, ValueRange args);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFunctionType calleeType, ValueRange args);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, StringAttr callee, ValueRange args = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TypeRange results, StringAttr callee, ValueRange args = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, TypeRange results, StringAttr callee, ValueRange args = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, FlatSymbolRefAttr callee, ValueRange args = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TypeRange results, FlatSymbolRefAttr callee, ValueRange args = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, TypeRange results, FlatSymbolRefAttr callee, ValueRange args = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, StringRef callee, ValueRange args = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TypeRange results, StringRef callee, ValueRange args = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, TypeRange results, StringRef callee, ValueRange args = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFunctionType calleeType, StringAttr callee, ValueRange args = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFunctionType calleeType, StringAttr callee, ValueRange args = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFunctionType calleeType, StringAttr callee, ValueRange args = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFunctionType calleeType, FlatSymbolRefAttr callee, ValueRange args = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFunctionType calleeType, FlatSymbolRefAttr callee, ValueRange args = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFunctionType calleeType, FlatSymbolRefAttr callee, ValueRange args = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFunctionType calleeType, StringRef callee, ValueRange args = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFunctionType calleeType, StringRef callee, ValueRange args = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFunctionType calleeType, StringRef callee, ValueRange args = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::mlir::LLVM::CConvAttr CConv, ::mlir::LLVM::TailCallKindAttr TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/::mlir::UnitAttr convergent, /*optional*/::mlir::UnitAttr no_unwind, /*optional*/::mlir::UnitAttr will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::UnitAttr no_inline, /*optional*/::mlir::UnitAttr always_inline, /*optional*/::mlir::UnitAttr inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::mlir::LLVM::CConvAttr CConv, ::mlir::LLVM::TailCallKindAttr TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/::mlir::UnitAttr convergent, /*optional*/::mlir::UnitAttr no_unwind, /*optional*/::mlir::UnitAttr will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::UnitAttr no_inline, /*optional*/::mlir::UnitAttr always_inline, /*optional*/::mlir::UnitAttr inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::mlir::LLVM::CConvAttr CConv, ::mlir::LLVM::TailCallKindAttr TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/::mlir::UnitAttr convergent, /*optional*/::mlir::UnitAttr no_unwind, /*optional*/::mlir::UnitAttr will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::UnitAttr no_inline, /*optional*/::mlir::UnitAttr always_inline, /*optional*/::mlir::UnitAttr inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::mlir::LLVM::CConvAttr CConv, ::mlir::LLVM::TailCallKindAttr TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/::mlir::UnitAttr convergent, /*optional*/::mlir::UnitAttr no_unwind, /*optional*/::mlir::UnitAttr will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::UnitAttr no_inline, /*optional*/::mlir::UnitAttr always_inline, /*optional*/::mlir::UnitAttr inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::mlir::LLVM::CConvAttr CConv, ::mlir::LLVM::TailCallKindAttr TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/::mlir::UnitAttr convergent, /*optional*/::mlir::UnitAttr no_unwind, /*optional*/::mlir::UnitAttr will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::UnitAttr no_inline, /*optional*/::mlir::UnitAttr always_inline, /*optional*/::mlir::UnitAttr inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags, ::mlir::LLVM::CConvAttr CConv, ::mlir::LLVM::TailCallKindAttr TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/::mlir::UnitAttr convergent, /*optional*/::mlir::UnitAttr no_unwind, /*optional*/::mlir::UnitAttr will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::UnitAttr no_inline, /*optional*/::mlir::UnitAttr always_inline, /*optional*/::mlir::UnitAttr inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlags fastmathFlags, ::mlir::LLVM::cconv::CConv CConv, ::mlir::LLVM::tailcallkind::TailCallKind TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/bool convergent, /*optional*/bool no_unwind, /*optional*/bool will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/bool no_inline, /*optional*/bool always_inline, /*optional*/bool inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlags fastmathFlags, ::mlir::LLVM::cconv::CConv CConv, ::mlir::LLVM::tailcallkind::TailCallKind TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/bool convergent, /*optional*/bool no_unwind, /*optional*/bool will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/bool no_inline, /*optional*/bool always_inline, /*optional*/bool inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlags fastmathFlags, ::mlir::LLVM::cconv::CConv CConv, ::mlir::LLVM::tailcallkind::TailCallKind TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/bool convergent, /*optional*/bool no_unwind, /*optional*/bool will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/bool no_inline, /*optional*/bool always_inline, /*optional*/bool inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlags fastmathFlags, ::mlir::LLVM::cconv::CConv CConv, ::mlir::LLVM::tailcallkind::TailCallKind TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/bool convergent, /*optional*/bool no_unwind, /*optional*/bool will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/bool no_inline, /*optional*/bool always_inline, /*optional*/bool inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlags fastmathFlags, ::mlir::LLVM::cconv::CConv CConv, ::mlir::LLVM::tailcallkind::TailCallKind TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/bool convergent, /*optional*/bool no_unwind, /*optional*/bool will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/bool no_inline, /*optional*/bool always_inline, /*optional*/bool inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, ::mlir::LLVM::FastmathFlags fastmathFlags, ::mlir::LLVM::cconv::CConv CConv, ::mlir::LLVM::tailcallkind::TailCallKind TailCallKind, /*optional*/::mlir::LLVM::MemoryEffectsAttr memory_effects, /*optional*/bool convergent, /*optional*/bool no_unwind, /*optional*/bool will_return, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/bool no_inline, /*optional*/bool always_inline, /*optional*/bool inline_hint, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Value> getAccessedOperands();
  ::mlir::CallInterfaceCallable getCallableForCallee();
  void setCalleeFromCallable(::mlir::CallInterfaceCallable callee);
  ::mlir::Operation::operand_range getArgOperands();
  ::mlir::MutableOperandRange getArgOperandsMutable();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 20 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Returns the callee function type.
  LLVMFunctionType getCalleeFunctionType();
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::CallOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ComdatOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ComdatOpGenericAdaptorBase {
public:
  struct Properties {
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.sym_name == this->sym_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ComdatOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.comdat", odsAttrs.getContext());
  }

  ComdatOpGenericAdaptorBase(ComdatOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::Region &getBody() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class ComdatOpGenericAdaptor : public detail::ComdatOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ComdatOpGenericAdaptorBase;
public:
  ComdatOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ComdatOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ComdatOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ComdatOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ComdatOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ComdatOpGenericAdaptor(RangeT values, const ComdatOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ComdatOp, typename = std::enable_if_t<std::is_same_v<LateInst, ComdatOp>>>
  ComdatOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ComdatOpAdaptor : public ComdatOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ComdatOpGenericAdaptor::ComdatOpGenericAdaptor;
  ComdatOpAdaptor(ComdatOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ComdatOp : public ::mlir::Op<ComdatOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::NoTerminator, ::mlir::OpTrait::NoRegionArguments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SymbolTable, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ComdatOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ComdatOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("sym_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.comdat");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getBody() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, StringRef symName);
  static ComdatOp create(::mlir::OpBuilder &builder, ::mlir::Location location, StringRef symName);
  static ComdatOp create(::mlir::ImplicitLocOpBuilder &builder, StringRef symName);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ComdatOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ComdatSelectorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ComdatSelectorOpGenericAdaptorBase {
public:
  struct Properties {
    using comdatTy = ::mlir::LLVM::comdat::ComdatAttr;
    comdatTy comdat;

    auto getComdat() const {
      auto &propStorage = this->comdat;
      return ::llvm::cast<::mlir::LLVM::comdat::ComdatAttr>(propStorage);
    }
    void setComdat(const ::mlir::LLVM::comdat::ComdatAttr &propValue) {
      this->comdat = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.comdat == this->comdat &&
        rhs.sym_name == this->sym_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ComdatSelectorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.comdat_selector", odsAttrs.getContext());
  }

  ComdatSelectorOpGenericAdaptorBase(ComdatSelectorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::LLVM::comdat::ComdatAttr getComdatAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::comdat::ComdatAttr>(getProperties().comdat);
    return attr;
  }

  ::mlir::LLVM::comdat::Comdat getComdat();
};

} // namespace detail
template <typename RangeT>
class ComdatSelectorOpGenericAdaptor : public detail::ComdatSelectorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ComdatSelectorOpGenericAdaptorBase;
public:
  ComdatSelectorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ComdatSelectorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ComdatSelectorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ComdatSelectorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ComdatSelectorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ComdatSelectorOpGenericAdaptor(RangeT values, const ComdatSelectorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ComdatSelectorOp, typename = std::enable_if_t<std::is_same_v<LateInst, ComdatSelectorOp>>>
  ComdatSelectorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ComdatSelectorOpAdaptor : public ComdatSelectorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ComdatSelectorOpGenericAdaptor::ComdatSelectorOpGenericAdaptor;
  ComdatSelectorOpAdaptor(ComdatSelectorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ComdatSelectorOp : public ::mlir::Op<ComdatSelectorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ComdatSelectorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ComdatSelectorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("comdat"), ::llvm::StringRef("sym_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getComdatAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getComdatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.comdat_selector");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::LLVM::comdat::ComdatAttr getComdatAttr() {
    return ::llvm::cast<::mlir::LLVM::comdat::ComdatAttr>(getProperties().comdat);
  }

  ::mlir::LLVM::comdat::Comdat getComdat();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setComdatAttr(::mlir::LLVM::comdat::ComdatAttr attr) {
    getProperties().comdat = attr;
  }

  void setComdat(::mlir::LLVM::comdat::Comdat attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::LLVM::comdat::ComdatAttr comdat);
  static ComdatSelectorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::LLVM::comdat::ComdatAttr comdat);
  static ComdatSelectorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::LLVM::comdat::ComdatAttr comdat);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::LLVM::comdat::ComdatAttr comdat);
  static ComdatSelectorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::LLVM::comdat::ComdatAttr comdat);
  static ComdatSelectorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::LLVM::comdat::ComdatAttr comdat);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::LLVM::comdat::Comdat comdat);
  static ComdatSelectorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::LLVM::comdat::Comdat comdat);
  static ComdatSelectorOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::LLVM::comdat::Comdat comdat);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::LLVM::comdat::Comdat comdat);
  static ComdatSelectorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::LLVM::comdat::Comdat comdat);
  static ComdatSelectorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::LLVM::comdat::Comdat comdat);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ComdatSelectorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ComdatSelectorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ComdatSelectorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ComdatSelectorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ComdatSelectorOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CondBrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CondBrOpGenericAdaptorBase {
public:
  struct Properties {
    using branch_weightsTy = ::mlir::DenseI32ArrayAttr;
    branch_weightsTy branch_weights;

    auto getBranchWeights() const {
      auto &propStorage = this->branch_weights;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setBranchWeights(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->branch_weights = propValue;
    }
    using loop_annotationTy = ::mlir::LLVM::LoopAnnotationAttr;
    loop_annotationTy loop_annotation;

    auto getLoopAnnotation() const {
      auto &propStorage = this->loop_annotation;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(propStorage);
    }
    void setLoopAnnotation(const ::mlir::LLVM::LoopAnnotationAttr &propValue) {
      this->loop_annotation = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.branch_weights == this->branch_weights &&
        rhs.loop_annotation == this->loop_annotation &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CondBrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.cond_br", odsAttrs.getContext());
  }

  CondBrOpGenericAdaptorBase(CondBrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI32ArrayAttr getBranchWeightsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().branch_weights);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getBranchWeights();
  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loop_annotation);
    return attr;
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
};

} // namespace detail
template <typename RangeT>
class CondBrOpGenericAdaptor : public detail::CondBrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CondBrOpGenericAdaptorBase;
  static constexpr int odsIndex_condition = 0;
  static constexpr int odsIndex_trueDestOperands = 1;
  static constexpr int odsIndex_falseDestOperands = 2;
public:
  CondBrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CondBrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CondBrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CondBrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CondBrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CondBrOpGenericAdaptor(RangeT values, const CondBrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CondBrOp, typename = std::enable_if_t<std::is_same_v<LateInst, CondBrOp>>>
  CondBrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getCondition() {
    return (*getODSOperands(0).begin());
  }

  RangeT getTrueDestOperands() {
    return getODSOperands(1);
  }

  RangeT getFalseDestOperands() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CondBrOpAdaptor : public CondBrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CondBrOpGenericAdaptor::CondBrOpGenericAdaptor;
  CondBrOpAdaptor(CondBrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CondBrOp : public ::mlir::Op<CondBrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::NSuccessors<2>::Impl, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::BranchOpInterface::Trait, ::mlir::WeightedBranchOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CondBrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CondBrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_condition = 0;
  static constexpr int odsIndex_trueDestOperands = 1;
  static constexpr int odsIndex_falseDestOperands = 2;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::BranchOpInterface::Trait<CondBrOp>::getSuccessorForOperands;
  using ::mlir::BranchOpInterface::Trait<CondBrOp>::areTypesCompatible;
  using ::mlir::WeightedBranchOpInterface::Trait<CondBrOp>::getWeights;
  using ::mlir::WeightedBranchOpInterface::Trait<CondBrOp>::setWeights;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("branch_weights"), ::llvm::StringRef("loop_annotation"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBranchWeightsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBranchWeightsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLoopAnnotationAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLoopAnnotationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.cond_br");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCondition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getTrueDestOperands() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getFalseDestOperands() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getConditionMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getTrueDestOperandsMutable();
  ::mlir::MutableOperandRange getFalseDestOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Block *getTrueDest() {
    return (*this)->getSuccessor(0);
  }

  ::mlir::Block *getFalseDest() {
    return (*this)->getSuccessor(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI32ArrayAttr getBranchWeightsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().branch_weights);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getBranchWeights();
  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loop_annotation);
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
  void setBranchWeightsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().branch_weights = attr;
  }

  void setBranchWeights(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setLoopAnnotationAttr(::mlir::LLVM::LoopAnnotationAttr attr) {
    getProperties().loop_annotation = attr;
  }

  ::mlir::Attribute removeBranchWeightsAttr() {
      auto attr = getProperties().branch_weights;
      getProperties().branch_weights = {};
      return attr;
  }

  ::mlir::Attribute removeLoopAnnotationAttr() {
      auto attr = getProperties().loop_annotation;
      getProperties().loop_annotation = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value condition, Block *trueDest, ValueRange trueOperands, Block *falseDest, ValueRange falseOperands, std::optional<std::pair<uint32_t, uint32_t>> weights = {});
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value condition, Block *trueDest, ValueRange trueOperands, Block *falseDest, ValueRange falseOperands, std::optional<std::pair<uint32_t, uint32_t>> weights = {});
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, Value condition, Block *trueDest, ValueRange trueOperands, Block *falseDest, ValueRange falseOperands, std::optional<std::pair<uint32_t, uint32_t>> weights = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value condition, Block *trueDest, Block *falseDest, ValueRange falseOperands = {});
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value condition, Block *trueDest, Block *falseDest, ValueRange falseOperands = {});
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, Value condition, Block *trueDest, Block *falseDest, ValueRange falseOperands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value condition, ValueRange trueOperands, ValueRange falseOperands, DenseI32ArrayAttr branchWeights, Block *trueDest, Block *falseDest);
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value condition, ValueRange trueOperands, ValueRange falseOperands, DenseI32ArrayAttr branchWeights, Block *trueDest, Block *falseDest);
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, Value condition, ValueRange trueOperands, ValueRange falseOperands, DenseI32ArrayAttr branchWeights, Block *trueDest, Block *falseDest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ValueRange operands, SuccessorRange destinations, ArrayRef<NamedAttribute> attributes = {});
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ValueRange operands, SuccessorRange destinations, ArrayRef<NamedAttribute> attributes = {});
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, ValueRange operands, SuccessorRange destinations, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::mlir::ValueRange trueDestOperands, ::mlir::ValueRange falseDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *trueDest, ::mlir::Block *falseDest);
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value condition, ::mlir::ValueRange trueDestOperands, ::mlir::ValueRange falseDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *trueDest, ::mlir::Block *falseDest);
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value condition, ::mlir::ValueRange trueDestOperands, ::mlir::ValueRange falseDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *trueDest, ::mlir::Block *falseDest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange trueDestOperands, ::mlir::ValueRange falseDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *trueDest, ::mlir::Block *falseDest);
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange trueDestOperands, ::mlir::ValueRange falseDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *trueDest, ::mlir::Block *falseDest);
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::ValueRange trueDestOperands, ::mlir::ValueRange falseDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, /*optional*/::mlir::LLVM::LoopAnnotationAttr loop_annotation, ::mlir::Block *trueDest, ::mlir::Block *falseDest);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CondBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CondBrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::SuccessorOperands getSuccessorOperands(unsigned index);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::CondBrOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ConstantOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConstantOpGenericAdaptorBase {
public:
  struct Properties {
    using valueTy = ::mlir::Attribute;
    valueTy value;

    auto getValue() const {
      auto &propStorage = this->value;
      return ::llvm::cast<::mlir::Attribute>(propStorage);
    }
    void setValue(const ::mlir::Attribute &propValue) {
      this->value = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.value == this->value &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConstantOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.constant", odsAttrs.getContext());
  }

  ConstantOpGenericAdaptorBase(ConstantOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::Attribute getValueAttr() {
    auto attr = ::llvm::cast<::mlir::Attribute>(getProperties().value);
    return attr;
  }

  ::mlir::Attribute getValue();
};

} // namespace detail
template <typename RangeT>
class ConstantOpGenericAdaptor : public detail::ConstantOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConstantOpGenericAdaptorBase;
public:
  ConstantOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConstantOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConstantOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConstantOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConstantOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConstantOpGenericAdaptor(RangeT values, const ConstantOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConstantOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConstantOp>>>
  ConstantOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConstantOpAdaptor : public ConstantOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConstantOpGenericAdaptor::ConstantOpGenericAdaptor;
  ConstantOpAdaptor(ConstantOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConstantOp : public ::mlir::Op<ConstantOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ConstantLike> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConstantOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConstantOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("value")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getValueAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getValueAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.constant");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::Attribute getValueAttr() {
    return ::llvm::cast<::mlir::Attribute>(getProperties().value);
  }

  ::mlir::Attribute getValue();
  void setValueAttr(::mlir::Attribute attr) {
    getProperties().value = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type type, int64_t value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type type, int64_t value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, Type type, int64_t value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type type, const APInt &value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type type, const APInt &value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, Type type, const APInt &value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type type, const APFloat &value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type type, const APFloat &value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, Type type, const APFloat &value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypedAttr value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TypedAttr value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, TypedAttr value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Attribute value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Attribute value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Attribute value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Attribute value);
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Attribute value);
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Attribute value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConstantOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConstantOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Whether the constant op can be constructed with a particular value and
  /// type.
  static bool isBuildableWith(Attribute value, Type type);

  /// Build the constant op with `value` and `type` if possible, otherwise
  /// returns null.
  static ConstantOp materialize(OpBuilder &builder, Attribute value,
                                Type type, Location loc);
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ConstantOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::DSOLocalEquivalentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DSOLocalEquivalentOpGenericAdaptorBase {
public:
  struct Properties {
    using function_nameTy = ::mlir::FlatSymbolRefAttr;
    function_nameTy function_name;

    auto getFunctionName() const {
      auto &propStorage = this->function_name;
      return ::llvm::cast<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setFunctionName(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->function_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.function_name == this->function_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DSOLocalEquivalentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.dso_local_equivalent", odsAttrs.getContext());
  }

  DSOLocalEquivalentOpGenericAdaptorBase(DSOLocalEquivalentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::FlatSymbolRefAttr getFunctionNameAttr() {
    auto attr = ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().function_name);
    return attr;
  }

  ::llvm::StringRef getFunctionName();
};

} // namespace detail
template <typename RangeT>
class DSOLocalEquivalentOpGenericAdaptor : public detail::DSOLocalEquivalentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DSOLocalEquivalentOpGenericAdaptorBase;
public:
  DSOLocalEquivalentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DSOLocalEquivalentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DSOLocalEquivalentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DSOLocalEquivalentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DSOLocalEquivalentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DSOLocalEquivalentOpGenericAdaptor(RangeT values, const DSOLocalEquivalentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DSOLocalEquivalentOp, typename = std::enable_if_t<std::is_same_v<LateInst, DSOLocalEquivalentOp>>>
  DSOLocalEquivalentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DSOLocalEquivalentOpAdaptor : public DSOLocalEquivalentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DSOLocalEquivalentOpGenericAdaptor::DSOLocalEquivalentOpGenericAdaptor;
  DSOLocalEquivalentOpAdaptor(DSOLocalEquivalentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DSOLocalEquivalentOp : public ::mlir::Op<DSOLocalEquivalentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::LLVM::LLVMPointerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::ConstantLike, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DSOLocalEquivalentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DSOLocalEquivalentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("function_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFunctionNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFunctionNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.dso_local_equivalent");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::FlatSymbolRefAttr getFunctionNameAttr() {
    return ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().function_name);
  }

  ::llvm::StringRef getFunctionName();
  void setFunctionNameAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().function_name = attr;
  }

  void setFunctionName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::FlatSymbolRefAttr function_name);
  static DSOLocalEquivalentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::FlatSymbolRefAttr function_name);
  static DSOLocalEquivalentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::FlatSymbolRefAttr function_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr function_name);
  static DSOLocalEquivalentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr function_name);
  static DSOLocalEquivalentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::FlatSymbolRefAttr function_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::llvm::StringRef function_name);
  static DSOLocalEquivalentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::llvm::StringRef function_name);
  static DSOLocalEquivalentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::llvm::StringRef function_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef function_name);
  static DSOLocalEquivalentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef function_name);
  static DSOLocalEquivalentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef function_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DSOLocalEquivalentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DSOLocalEquivalentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DSOLocalEquivalentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DSOLocalEquivalentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return the llvm.func operation that is referenced here.
  LLVMFuncOp getFunction(SymbolTableCollection &symbolTable);
  /// Return the llvm.mlir.alias operation that defined the value referenced
  /// here.
  AliasOp getAlias(SymbolTableCollection &symbolTable);
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::DSOLocalEquivalentOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ExtractElementOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ExtractElementOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExtractElementOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.extractelement", odsAttrs.getContext());
  }

  ExtractElementOpGenericAdaptorBase(ExtractElementOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ExtractElementOpGenericAdaptor : public detail::ExtractElementOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExtractElementOpGenericAdaptorBase;
  static constexpr int odsIndex_vector = 0;
  static constexpr int odsIndex_position = 1;
public:
  ExtractElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExtractElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExtractElementOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExtractElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExtractElementOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExtractElementOpGenericAdaptor(RangeT values, const ExtractElementOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExtractElementOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExtractElementOp>>>
  ExtractElementOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVector() {
    return (*getODSOperands(0).begin());
  }

  ValueT getPosition() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExtractElementOpAdaptor : public ExtractElementOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExtractElementOpGenericAdaptor::ExtractElementOpGenericAdaptor;
  ExtractElementOpAdaptor(ExtractElementOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExtractElementOp : public ::mlir::Op<ExtractElementOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExtractElementOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExtractElementOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_vector = 0;
  static constexpr int odsIndex_position = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.extractelement");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getVector() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPosition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getVectorMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getPositionMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value vector, ::mlir::Value position);
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value vector, ::mlir::Value position);
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value vector, ::mlir::Value position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value vector, ::mlir::Value position);
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value vector, ::mlir::Value position);
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value vector, ::mlir::Value position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value position);
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value position);
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value position);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ExtractElementOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ExtractValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ExtractValueOpGenericAdaptorBase {
public:
  struct Properties {
    using positionTy = ::mlir::DenseI64ArrayAttr;
    positionTy position;

    auto getPosition() const {
      auto &propStorage = this->position;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setPosition(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->position = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.position == this->position &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExtractValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.extractvalue", odsAttrs.getContext());
  }

  ExtractValueOpGenericAdaptorBase(ExtractValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getPositionAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().position);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getPosition();
};

} // namespace detail
template <typename RangeT>
class ExtractValueOpGenericAdaptor : public detail::ExtractValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExtractValueOpGenericAdaptorBase;
  static constexpr int odsIndex_container = 0;
public:
  ExtractValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExtractValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExtractValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExtractValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExtractValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExtractValueOpGenericAdaptor(RangeT values, const ExtractValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExtractValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExtractValueOp>>>
  ExtractValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getContainer() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExtractValueOpAdaptor : public ExtractValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExtractValueOpGenericAdaptor::ExtractValueOpGenericAdaptor;
  ExtractValueOpAdaptor(ExtractValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExtractValueOp : public ::mlir::Op<ExtractValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExtractValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExtractValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_container = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("position")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getPositionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getPositionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.extractvalue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getContainer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getContainerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getPositionAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().position);
  }

  ::llvm::ArrayRef<int64_t> getPosition();
  void setPositionAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().position = attr;
  }

  void setPosition(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value container, ArrayRef<int64_t> position);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value container, ArrayRef<int64_t> position);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, Value container, ArrayRef<int64_t> position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value container, ::mlir::DenseI64ArrayAttr position);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value container, ::mlir::DenseI64ArrayAttr position);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value container, ::mlir::DenseI64ArrayAttr position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::DenseI64ArrayAttr position);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::DenseI64ArrayAttr position);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::DenseI64ArrayAttr position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value container, ::llvm::ArrayRef<int64_t> position);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value container, ::llvm::ArrayRef<int64_t> position);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value container, ::llvm::ArrayRef<int64_t> position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::llvm::ArrayRef<int64_t> position);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::llvm::ArrayRef<int64_t> position);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::llvm::ArrayRef<int64_t> position);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ExtractValueOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FAddOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FAddOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FAddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fadd", odsAttrs.getContext());
  }

  FAddOpGenericAdaptorBase(FAddOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FAddOpGenericAdaptor : public detail::FAddOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FAddOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  FAddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FAddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FAddOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FAddOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FAddOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FAddOpGenericAdaptor(RangeT values, const FAddOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FAddOp, typename = std::enable_if_t<std::is_same_v<LateInst, FAddOp>>>
  FAddOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FAddOpAdaptor : public FAddOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FAddOpGenericAdaptor::FAddOpGenericAdaptor;
  FAddOpAdaptor(FAddOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FAddOp : public ::mlir::Op<FAddOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FAddOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FAddOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FAddOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FAddOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fadd");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FAddOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FAddOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FAddOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FCmpOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FCmpOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    using predicateTy = ::mlir::LLVM::FCmpPredicateAttr;
    predicateTy predicate;

    auto getPredicate() const {
      auto &propStorage = this->predicate;
      return ::llvm::cast<::mlir::LLVM::FCmpPredicateAttr>(propStorage);
    }
    void setPredicate(const ::mlir::LLVM::FCmpPredicateAttr &propValue) {
      this->predicate = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        rhs.predicate == this->predicate &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FCmpOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fcmp", odsAttrs.getContext());
  }

  FCmpOpGenericAdaptorBase(FCmpOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FCmpPredicateAttr getPredicateAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::FCmpPredicateAttr>(getProperties().predicate);
    return attr;
  }

  ::mlir::LLVM::FCmpPredicate getPredicate();
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FCmpOpGenericAdaptor : public detail::FCmpOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FCmpOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  FCmpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FCmpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FCmpOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FCmpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FCmpOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FCmpOpGenericAdaptor(RangeT values, const FCmpOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FCmpOp, typename = std::enable_if_t<std::is_same_v<LateInst, FCmpOp>>>
  FCmpOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FCmpOpAdaptor : public FCmpOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FCmpOpGenericAdaptor::FCmpOpGenericAdaptor;
  FCmpOpAdaptor(FCmpOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FCmpOp : public ::mlir::Op<FCmpOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::OpTrait::SameTypeOperands, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FCmpOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FCmpOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FCmpOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FCmpOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags"), ::llvm::StringRef("predicate")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getPredicateAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getPredicateAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fcmp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FCmpPredicateAttr getPredicateAttr() {
    return ::llvm::cast<::mlir::LLVM::FCmpPredicateAttr>(getProperties().predicate);
  }

  ::mlir::LLVM::FCmpPredicate getPredicate();
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setPredicateAttr(::mlir::LLVM::FCmpPredicateAttr attr) {
    getProperties().predicate = attr;
  }

  void setPredicate(::mlir::LLVM::FCmpPredicate attrValue);
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::FCmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::FCmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FCmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FCmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FCmpOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FDivOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FDivOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FDivOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fdiv", odsAttrs.getContext());
  }

  FDivOpGenericAdaptorBase(FDivOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FDivOpGenericAdaptor : public detail::FDivOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FDivOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  FDivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FDivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FDivOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FDivOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FDivOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FDivOpGenericAdaptor(RangeT values, const FDivOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FDivOp, typename = std::enable_if_t<std::is_same_v<LateInst, FDivOp>>>
  FDivOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FDivOpAdaptor : public FDivOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FDivOpGenericAdaptor::FDivOpGenericAdaptor;
  FDivOpAdaptor(FDivOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FDivOp : public ::mlir::Op<FDivOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FDivOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FDivOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FDivOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FDivOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fdiv");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FDivOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FDivOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FDivOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FMulOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FMulOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FMulOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fmul", odsAttrs.getContext());
  }

  FMulOpGenericAdaptorBase(FMulOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FMulOpGenericAdaptor : public detail::FMulOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FMulOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  FMulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FMulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FMulOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FMulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FMulOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FMulOpGenericAdaptor(RangeT values, const FMulOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FMulOp, typename = std::enable_if_t<std::is_same_v<LateInst, FMulOp>>>
  FMulOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FMulOpAdaptor : public FMulOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FMulOpGenericAdaptor::FMulOpGenericAdaptor;
  FMulOpAdaptor(FMulOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FMulOp : public ::mlir::Op<FMulOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FMulOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FMulOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FMulOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FMulOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fmul");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FMulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FMulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FMulOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FNegOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FNegOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FNegOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fneg", odsAttrs.getContext());
  }

  FNegOpGenericAdaptorBase(FNegOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FNegOpGenericAdaptor : public detail::FNegOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FNegOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  FNegOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FNegOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FNegOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FNegOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FNegOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FNegOpGenericAdaptor(RangeT values, const FNegOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FNegOp, typename = std::enable_if_t<std::is_same_v<LateInst, FNegOp>>>
  FNegOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FNegOpAdaptor : public FNegOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FNegOpGenericAdaptor::FNegOpGenericAdaptor;
  FNegOpAdaptor(FNegOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FNegOp : public ::mlir::Op<FNegOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FNegOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FNegOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FNegOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FNegOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fneg");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FNegOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FNegOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FNegOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FPExtOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FPExtOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FPExtOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fpext", odsAttrs.getContext());
  }

  FPExtOpGenericAdaptorBase(FPExtOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FPExtOpGenericAdaptor : public detail::FPExtOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FPExtOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  FPExtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FPExtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FPExtOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FPExtOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FPExtOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FPExtOpGenericAdaptor(RangeT values, const FPExtOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FPExtOp, typename = std::enable_if_t<std::is_same_v<LateInst, FPExtOp>>>
  FPExtOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FPExtOpAdaptor : public FPExtOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FPExtOpGenericAdaptor::FPExtOpGenericAdaptor;
  FPExtOpAdaptor(FPExtOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FPExtOp : public ::mlir::Op<FPExtOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FPExtOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FPExtOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fpext");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPExtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPExtOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg);
  static FPExtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg);
  static FPExtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPExtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPExtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPExtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPExtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPExtOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPExtOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FPExtOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FPToSIOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FPToSIOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FPToSIOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fptosi", odsAttrs.getContext());
  }

  FPToSIOpGenericAdaptorBase(FPToSIOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FPToSIOpGenericAdaptor : public detail::FPToSIOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FPToSIOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  FPToSIOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FPToSIOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FPToSIOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FPToSIOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FPToSIOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FPToSIOpGenericAdaptor(RangeT values, const FPToSIOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FPToSIOp, typename = std::enable_if_t<std::is_same_v<LateInst, FPToSIOp>>>
  FPToSIOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FPToSIOpAdaptor : public FPToSIOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FPToSIOpGenericAdaptor::FPToSIOpGenericAdaptor;
  FPToSIOpAdaptor(FPToSIOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FPToSIOp : public ::mlir::Op<FPToSIOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FPToSIOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FPToSIOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fptosi");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPToSIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPToSIOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg);
  static FPToSIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg);
  static FPToSIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPToSIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPToSIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPToSIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPToSIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPToSIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPToSIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FPToSIOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FPToUIOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FPToUIOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FPToUIOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fptoui", odsAttrs.getContext());
  }

  FPToUIOpGenericAdaptorBase(FPToUIOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FPToUIOpGenericAdaptor : public detail::FPToUIOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FPToUIOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  FPToUIOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FPToUIOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FPToUIOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FPToUIOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FPToUIOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FPToUIOpGenericAdaptor(RangeT values, const FPToUIOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FPToUIOp, typename = std::enable_if_t<std::is_same_v<LateInst, FPToUIOp>>>
  FPToUIOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FPToUIOpAdaptor : public FPToUIOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FPToUIOpGenericAdaptor::FPToUIOpGenericAdaptor;
  FPToUIOpAdaptor(FPToUIOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FPToUIOp : public ::mlir::Op<FPToUIOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FPToUIOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FPToUIOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fptoui");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPToUIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPToUIOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg);
  static FPToUIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg);
  static FPToUIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPToUIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPToUIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPToUIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPToUIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPToUIOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPToUIOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FPToUIOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FPTruncOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FPTruncOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FPTruncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fptrunc", odsAttrs.getContext());
  }

  FPTruncOpGenericAdaptorBase(FPTruncOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FPTruncOpGenericAdaptor : public detail::FPTruncOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FPTruncOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  FPTruncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FPTruncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FPTruncOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FPTruncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FPTruncOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FPTruncOpGenericAdaptor(RangeT values, const FPTruncOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FPTruncOp, typename = std::enable_if_t<std::is_same_v<LateInst, FPTruncOp>>>
  FPTruncOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FPTruncOpAdaptor : public FPTruncOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FPTruncOpGenericAdaptor::FPTruncOpGenericAdaptor;
  FPTruncOpAdaptor(FPTruncOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FPTruncOp : public ::mlir::Op<FPTruncOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FPTruncOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FPTruncOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fptrunc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FPTruncOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg);
  static FPTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg);
  static FPTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static FPTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FPTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPTruncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FPTruncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FPTruncOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FRemOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FRemOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FRemOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.frem", odsAttrs.getContext());
  }

  FRemOpGenericAdaptorBase(FRemOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FRemOpGenericAdaptor : public detail::FRemOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FRemOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  FRemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FRemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FRemOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FRemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FRemOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FRemOpGenericAdaptor(RangeT values, const FRemOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FRemOp, typename = std::enable_if_t<std::is_same_v<LateInst, FRemOp>>>
  FRemOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FRemOpAdaptor : public FRemOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FRemOpGenericAdaptor::FRemOpGenericAdaptor;
  FRemOpAdaptor(FRemOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FRemOp : public ::mlir::Op<FRemOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FRemOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FRemOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FRemOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FRemOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.frem");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FRemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FRemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FRemOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FSubOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FSubOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathFlagsTy = ::mlir::LLVM::FastmathFlagsAttr;
    fastmathFlagsTy fastmathFlags;

    auto getFastmathFlags() const {
      auto &propStorage = this->fastmathFlags;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(propStorage);
    }
    void setFastmathFlags(const ::mlir::LLVM::FastmathFlagsAttr &propValue) {
      this->fastmathFlags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmathFlags == this->fastmathFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FSubOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fsub", odsAttrs.getContext());
  }

  FSubOpGenericAdaptorBase(FSubOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr();
  ::mlir::LLVM::FastmathFlags getFastmathFlags();
};

} // namespace detail
template <typename RangeT>
class FSubOpGenericAdaptor : public detail::FSubOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FSubOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  FSubOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FSubOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FSubOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FSubOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FSubOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FSubOpGenericAdaptor(RangeT values, const FSubOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FSubOp, typename = std::enable_if_t<std::is_same_v<LateInst, FSubOp>>>
  FSubOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FSubOpAdaptor : public FSubOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FSubOpGenericAdaptor::FSubOpGenericAdaptor;
  FSubOpAdaptor(FSubOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FSubOp : public ::mlir::Op<FSubOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::FastmathFlagsInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FSubOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FSubOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FSubOp>::getFastmathAttr;
  using ::mlir::LLVM::FastmathFlagsInterface::Trait<FSubOp>::getFastmathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmathFlags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fsub");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::FastmathFlagsAttr getFastmathFlagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  }

  ::mlir::LLVM::FastmathFlags getFastmathFlags();
  void setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
    getProperties().fastmathFlags = attr;
  }

  void setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::LLVM::FastmathFlags fastmathFlags = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FSubOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FSubOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FSubOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FenceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FenceOpGenericAdaptorBase {
public:
  struct Properties {
    using orderingTy = ::mlir::LLVM::AtomicOrderingAttr;
    orderingTy ordering;

    auto getOrdering() const {
      auto &propStorage = this->ordering;
      return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(propStorage);
    }
    void setOrdering(const ::mlir::LLVM::AtomicOrderingAttr &propValue) {
      this->ordering = propValue;
    }
    using syncscopeTy = ::mlir::StringAttr;
    syncscopeTy syncscope;

    auto getSyncscope() const {
      auto &propStorage = this->syncscope;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSyncscope(const ::mlir::StringAttr &propValue) {
      this->syncscope = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.ordering == this->ordering &&
        rhs.syncscope == this->syncscope &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FenceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.fence", odsAttrs.getContext());
  }

  FenceOpGenericAdaptorBase(FenceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::AtomicOrderingAttr getOrderingAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().ordering);
    return attr;
  }

  ::mlir::LLVM::AtomicOrdering getOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
};

} // namespace detail
template <typename RangeT>
class FenceOpGenericAdaptor : public detail::FenceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FenceOpGenericAdaptorBase;
public:
  FenceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FenceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FenceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FenceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FenceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FenceOpGenericAdaptor(RangeT values, const FenceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FenceOp, typename = std::enable_if_t<std::is_same_v<LateInst, FenceOp>>>
  FenceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FenceOpAdaptor : public FenceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FenceOpGenericAdaptor::FenceOpGenericAdaptor;
  FenceOpAdaptor(FenceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FenceOp : public ::mlir::Op<FenceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FenceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FenceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("ordering"), ::llvm::StringRef("syncscope")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOrderingAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOrderingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSyncscopeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSyncscopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.fence");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::AtomicOrderingAttr getOrderingAttr() {
    return ::llvm::cast<::mlir::LLVM::AtomicOrderingAttr>(getProperties().ordering);
  }

  ::mlir::LLVM::AtomicOrdering getOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  void setOrderingAttr(::mlir::LLVM::AtomicOrderingAttr attr) {
    getProperties().ordering = attr;
  }

  void setOrdering(::mlir::LLVM::AtomicOrdering attrValue);
  void setSyncscopeAttr(::mlir::StringAttr attr) {
    getProperties().syncscope = attr;
  }

  void setSyncscope(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeSyncscopeAttr() {
      auto attr = getProperties().syncscope;
      getProperties().syncscope = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVM::AtomicOrdering ordering, StringRef syncscope = StringRef());
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVM::AtomicOrdering ordering, StringRef syncscope = StringRef());
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, LLVM::AtomicOrdering ordering, StringRef syncscope = StringRef());
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope);
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FenceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FenceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FenceOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FreezeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FreezeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FreezeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.freeze", odsAttrs.getContext());
  }

  FreezeOpGenericAdaptorBase(FreezeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FreezeOpGenericAdaptor : public detail::FreezeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FreezeOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  FreezeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FreezeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FreezeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FreezeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FreezeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FreezeOpGenericAdaptor(RangeT values, const FreezeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FreezeOp, typename = std::enable_if_t<std::is_same_v<LateInst, FreezeOp>>>
  FreezeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FreezeOpAdaptor : public FreezeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FreezeOpGenericAdaptor::FreezeOpGenericAdaptor;
  FreezeOpAdaptor(FreezeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FreezeOp : public ::mlir::Op<FreezeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FreezeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FreezeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.freeze");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val);
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value val);
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val);
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value val);
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreezeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreezeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::FreezeOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::GEPOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GEPOpGenericAdaptorBase {
public:
  struct Properties {
    using elem_typeTy = ::mlir::TypeAttr;
    elem_typeTy elem_type;

    auto getElemType() const {
      auto &propStorage = this->elem_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setElemType(const ::mlir::TypeAttr &propValue) {
      this->elem_type = propValue;
    }
    using rawConstantIndicesTy = ::mlir::DenseI32ArrayAttr;
    rawConstantIndicesTy rawConstantIndices;

    auto getRawConstantIndices() const {
      auto &propStorage = this->rawConstantIndices;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setRawConstantIndices(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->rawConstantIndices = propValue;
    }
    using noWrapFlagsTy = ::mlir::LLVM::GEPNoWrapFlags;
    noWrapFlagsTy noWrapFlags = ::mlir::LLVM::GEPNoWrapFlags::none;
    ::mlir::LLVM::GEPNoWrapFlags getNoWrapFlags() const {
      auto &propStorage = this->noWrapFlags;
      return propStorage;
    }
    void setNoWrapFlags(::mlir::LLVM::GEPNoWrapFlags propValue) {
      auto &propStorage = this->noWrapFlags;
      propStorage = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.elem_type == this->elem_type &&
        rhs.rawConstantIndices == this->rawConstantIndices &&
        rhs.noWrapFlags == this->noWrapFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GEPOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.getelementptr", odsAttrs.getContext());
  }

  GEPOpGenericAdaptorBase(GEPOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::GEPNoWrapFlags getNoWrapFlags() {
    return getProperties().getNoWrapFlags();
  }

  ::mlir::DenseI32ArrayAttr getRawConstantIndicesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().rawConstantIndices);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getRawConstantIndices();
  ::mlir::TypeAttr getElemTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().elem_type);
    return attr;
  }

  ::mlir::Type getElemType();
};

} // namespace detail
template <typename RangeT>
class GEPOpGenericAdaptor : public detail::GEPOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GEPOpGenericAdaptorBase;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_dynamicIndices = 1;
public:
  GEPOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GEPOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GEPOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GEPOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GEPOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GEPOpGenericAdaptor(RangeT values, const GEPOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GEPOp, typename = std::enable_if_t<std::is_same_v<LateInst, GEPOp>>>
  GEPOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBase() {
    return (*getODSOperands(0).begin());
  }

  RangeT getDynamicIndices() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GEPOpAdaptor : public GEPOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GEPOpGenericAdaptor::GEPOpGenericAdaptor;
  GEPOpAdaptor(GEPOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GEPOp : public ::mlir::Op<GEPOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::PromotableOpInterface::Trait, ::mlir::SafeMemorySlotAccessOpInterface::Trait, ::mlir::DestructurableAccessorOpInterface::Trait, ::mlir::ViewLikeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GEPOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GEPOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_base = 0;
  static constexpr int odsIndex_dynamicIndices = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::PromotableOpInterface::Trait<GEPOp>::requiresReplacedValues;
  using ::mlir::PromotableOpInterface::Trait<GEPOp>::visitReplacedValues;
  using ::mlir::ViewLikeOpInterface::Trait<GEPOp>::getViewDest;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("elem_type"), ::llvm::StringRef("rawConstantIndices")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getElemTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getElemTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getRawConstantIndicesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getRawConstantIndicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.getelementptr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBase() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getDynamicIndices() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getBaseMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDynamicIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::GEPNoWrapFlags getNoWrapFlags() {
    return getProperties().getNoWrapFlags();
  }

  void setNoWrapFlags(::mlir::LLVM::GEPNoWrapFlags newNoWrapFlags) {
    getProperties().setNoWrapFlags(newNoWrapFlags);
  }

  ::mlir::DenseI32ArrayAttr getRawConstantIndicesAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().rawConstantIndices);
  }

  ::llvm::ArrayRef<int32_t> getRawConstantIndices();
  ::mlir::TypeAttr getElemTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().elem_type);
  }

  ::mlir::Type getElemType();
  void setRawConstantIndicesAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().rawConstantIndices = attr;
  }

  void setRawConstantIndices(::llvm::ArrayRef<int32_t> attrValue);
  void setElemTypeAttr(::mlir::TypeAttr attr) {
    getProperties().elem_type = attr;
  }

  void setElemType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, Type elementType, Value basePtr, ValueRange indices, GEPNoWrapFlags noWrapFlags = GEPNoWrapFlags::none, ArrayRef<NamedAttribute> attributes = {});
  static GEPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, Type elementType, Value basePtr, ValueRange indices, GEPNoWrapFlags noWrapFlags = GEPNoWrapFlags::none, ArrayRef<NamedAttribute> attributes = {});
  static GEPOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, Type elementType, Value basePtr, ValueRange indices, GEPNoWrapFlags noWrapFlags = GEPNoWrapFlags::none, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, Type elementType, Value basePtr, ArrayRef<GEPArg> indices, GEPNoWrapFlags noWrapFlags = GEPNoWrapFlags::none, ArrayRef<NamedAttribute> attributes = {});
  static GEPOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, Type elementType, Value basePtr, ArrayRef<GEPArg> indices, GEPNoWrapFlags noWrapFlags = GEPNoWrapFlags::none, ArrayRef<NamedAttribute> attributes = {});
  static GEPOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, Type elementType, Value basePtr, ArrayRef<GEPArg> indices, GEPNoWrapFlags noWrapFlags = GEPNoWrapFlags::none, ArrayRef<NamedAttribute> attributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  bool canUsesBeRemoved(const ::llvm::SmallPtrSetImpl<::mlir::OpOperand *> &blockingUses, ::llvm::SmallVectorImpl<::mlir::OpOperand *> &newBlockingUses, const ::mlir::DataLayout &datalayout);
  ::mlir::DeletionKind removeBlockingUses(const ::llvm::SmallPtrSetImpl<mlir::OpOperand *> &blockingUses, ::mlir::OpBuilder &builder);
  ::llvm::LogicalResult ensureOnlySafeAccesses(const ::mlir::MemorySlot &slot, ::mlir::SmallVectorImpl<::mlir::MemorySlot> &mustBeSafelyUsed, const ::mlir::DataLayout &dataLayout);
  bool canRewire(const ::mlir::DestructurableMemorySlot &slot, ::llvm::SmallPtrSetImpl<::mlir::Attribute> &usedIndices, ::mlir::SmallVectorImpl<::mlir::MemorySlot> &mustBeSafelyUsed, const ::mlir::DataLayout &dataLayout);
  ::mlir::DeletionKind rewire(const ::mlir::DestructurableMemorySlot &slot, ::llvm::DenseMap<::mlir::Attribute, ::mlir::MemorySlot> &subslots, ::mlir::OpBuilder &builder, const ::mlir::DataLayout &dataLayout);
  ::mlir::Value getViewSource();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  constexpr static int32_t kDynamicIndex = std::numeric_limits<int32_t>::min();

  GEPIndicesAdaptor<ValueRange> getIndices();
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::GEPOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::GlobalCtorsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GlobalCtorsOpGenericAdaptorBase {
public:
  struct Properties {
    using ctorsTy = ::mlir::ArrayAttr;
    ctorsTy ctors;

    auto getCtors() const {
      auto &propStorage = this->ctors;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setCtors(const ::mlir::ArrayAttr &propValue) {
      this->ctors = propValue;
    }
    using dataTy = ::mlir::ArrayAttr;
    dataTy data;

    auto getData() const {
      auto &propStorage = this->data;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setData(const ::mlir::ArrayAttr &propValue) {
      this->data = propValue;
    }
    using prioritiesTy = ::mlir::ArrayAttr;
    prioritiesTy priorities;

    auto getPriorities() const {
      auto &propStorage = this->priorities;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setPriorities(const ::mlir::ArrayAttr &propValue) {
      this->priorities = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.ctors == this->ctors &&
        rhs.data == this->data &&
        rhs.priorities == this->priorities &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalCtorsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.global_ctors", odsAttrs.getContext());
  }

  GlobalCtorsOpGenericAdaptorBase(GlobalCtorsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getCtorsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().ctors);
    return attr;
  }

  ::mlir::ArrayAttr getCtors();
  ::mlir::ArrayAttr getPrioritiesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().priorities);
    return attr;
  }

  ::mlir::ArrayAttr getPriorities();
  ::mlir::ArrayAttr getDataAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().data);
    return attr;
  }

  ::mlir::ArrayAttr getData();
};

} // namespace detail
template <typename RangeT>
class GlobalCtorsOpGenericAdaptor : public detail::GlobalCtorsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalCtorsOpGenericAdaptorBase;
public:
  GlobalCtorsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalCtorsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalCtorsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalCtorsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalCtorsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalCtorsOpGenericAdaptor(RangeT values, const GlobalCtorsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalCtorsOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalCtorsOp>>>
  GlobalCtorsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalCtorsOpAdaptor : public GlobalCtorsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalCtorsOpGenericAdaptor::GlobalCtorsOpGenericAdaptor;
  GlobalCtorsOpAdaptor(GlobalCtorsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalCtorsOp : public ::mlir::Op<GlobalCtorsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalCtorsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalCtorsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("ctors"), ::llvm::StringRef("data"), ::llvm::StringRef("priorities")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCtorsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCtorsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDataAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPrioritiesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPrioritiesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.global_ctors");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getCtorsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().ctors);
  }

  ::mlir::ArrayAttr getCtors();
  ::mlir::ArrayAttr getPrioritiesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().priorities);
  }

  ::mlir::ArrayAttr getPriorities();
  ::mlir::ArrayAttr getDataAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().data);
  }

  ::mlir::ArrayAttr getData();
  void setCtorsAttr(::mlir::ArrayAttr attr) {
    getProperties().ctors = attr;
  }

  void setPrioritiesAttr(::mlir::ArrayAttr attr) {
    getProperties().priorities = attr;
  }

  void setDataAttr(::mlir::ArrayAttr attr) {
    getProperties().data = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ArrayAttr ctors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalCtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ArrayAttr ctors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalCtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ArrayAttr ctors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr ctors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalCtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr ctors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalCtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr ctors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalCtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalCtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalCtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalCtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::GlobalCtorsOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::GlobalDtorsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GlobalDtorsOpGenericAdaptorBase {
public:
  struct Properties {
    using dataTy = ::mlir::ArrayAttr;
    dataTy data;

    auto getData() const {
      auto &propStorage = this->data;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setData(const ::mlir::ArrayAttr &propValue) {
      this->data = propValue;
    }
    using dtorsTy = ::mlir::ArrayAttr;
    dtorsTy dtors;

    auto getDtors() const {
      auto &propStorage = this->dtors;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDtors(const ::mlir::ArrayAttr &propValue) {
      this->dtors = propValue;
    }
    using prioritiesTy = ::mlir::ArrayAttr;
    prioritiesTy priorities;

    auto getPriorities() const {
      auto &propStorage = this->priorities;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setPriorities(const ::mlir::ArrayAttr &propValue) {
      this->priorities = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data == this->data &&
        rhs.dtors == this->dtors &&
        rhs.priorities == this->priorities &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalDtorsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.global_dtors", odsAttrs.getContext());
  }

  GlobalDtorsOpGenericAdaptorBase(GlobalDtorsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getDtorsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dtors);
    return attr;
  }

  ::mlir::ArrayAttr getDtors();
  ::mlir::ArrayAttr getPrioritiesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().priorities);
    return attr;
  }

  ::mlir::ArrayAttr getPriorities();
  ::mlir::ArrayAttr getDataAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().data);
    return attr;
  }

  ::mlir::ArrayAttr getData();
};

} // namespace detail
template <typename RangeT>
class GlobalDtorsOpGenericAdaptor : public detail::GlobalDtorsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalDtorsOpGenericAdaptorBase;
public:
  GlobalDtorsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalDtorsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalDtorsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalDtorsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalDtorsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalDtorsOpGenericAdaptor(RangeT values, const GlobalDtorsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalDtorsOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalDtorsOp>>>
  GlobalDtorsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalDtorsOpAdaptor : public GlobalDtorsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalDtorsOpGenericAdaptor::GlobalDtorsOpGenericAdaptor;
  GlobalDtorsOpAdaptor(GlobalDtorsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalDtorsOp : public ::mlir::Op<GlobalDtorsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalDtorsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalDtorsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("data"), ::llvm::StringRef("dtors"), ::llvm::StringRef("priorities")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDataAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDtorsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDtorsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPrioritiesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPrioritiesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.global_dtors");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getDtorsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dtors);
  }

  ::mlir::ArrayAttr getDtors();
  ::mlir::ArrayAttr getPrioritiesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().priorities);
  }

  ::mlir::ArrayAttr getPriorities();
  ::mlir::ArrayAttr getDataAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().data);
  }

  ::mlir::ArrayAttr getData();
  void setDtorsAttr(::mlir::ArrayAttr attr) {
    getProperties().dtors = attr;
  }

  void setPrioritiesAttr(::mlir::ArrayAttr attr) {
    getProperties().priorities = attr;
  }

  void setDataAttr(::mlir::ArrayAttr attr) {
    getProperties().data = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ArrayAttr dtors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalDtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ArrayAttr dtors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalDtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ArrayAttr dtors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr dtors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalDtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr dtors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static GlobalDtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr dtors, ::mlir::ArrayAttr priorities, ::mlir::ArrayAttr data);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalDtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalDtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalDtorsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalDtorsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::GlobalDtorsOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::GlobalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GlobalOpGenericAdaptorBase {
public:
  struct Properties {
    using addr_spaceTy = ::mlir::IntegerAttr;
    addr_spaceTy addr_space;

    auto getAddrSpace() const {
      auto &propStorage = this->addr_space;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAddrSpace(const ::mlir::IntegerAttr &propValue) {
      this->addr_space = propValue;
    }
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using comdatTy = ::mlir::SymbolRefAttr;
    comdatTy comdat;

    auto getComdat() const {
      auto &propStorage = this->comdat;
      return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(propStorage);
    }
    void setComdat(const ::mlir::SymbolRefAttr &propValue) {
      this->comdat = propValue;
    }
    using constantTy = ::mlir::UnitAttr;
    constantTy constant;

    auto getConstant() const {
      auto &propStorage = this->constant;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setConstant(const ::mlir::UnitAttr &propValue) {
      this->constant = propValue;
    }
    using dbg_exprsTy = ::mlir::ArrayAttr;
    dbg_exprsTy dbg_exprs;

    auto getDbgExprs() const {
      auto &propStorage = this->dbg_exprs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setDbgExprs(const ::mlir::ArrayAttr &propValue) {
      this->dbg_exprs = propValue;
    }
    using dso_localTy = ::mlir::UnitAttr;
    dso_localTy dso_local;

    auto getDsoLocal() const {
      auto &propStorage = this->dso_local;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setDsoLocal(const ::mlir::UnitAttr &propValue) {
      this->dso_local = propValue;
    }
    using externally_initializedTy = ::mlir::UnitAttr;
    externally_initializedTy externally_initialized;

    auto getExternallyInitialized() const {
      auto &propStorage = this->externally_initialized;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setExternallyInitialized(const ::mlir::UnitAttr &propValue) {
      this->externally_initialized = propValue;
    }
    using global_typeTy = ::mlir::TypeAttr;
    global_typeTy global_type;

    auto getGlobalType() const {
      auto &propStorage = this->global_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setGlobalType(const ::mlir::TypeAttr &propValue) {
      this->global_type = propValue;
    }
    using linkageTy = ::mlir::LLVM::LinkageAttr;
    linkageTy linkage;

    auto getLinkage() const {
      auto &propStorage = this->linkage;
      return ::llvm::cast<::mlir::LLVM::LinkageAttr>(propStorage);
    }
    void setLinkage(const ::mlir::LLVM::LinkageAttr &propValue) {
      this->linkage = propValue;
    }
    using sectionTy = ::mlir::StringAttr;
    sectionTy section;

    auto getSection() const {
      auto &propStorage = this->section;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSection(const ::mlir::StringAttr &propValue) {
      this->section = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using target_specific_attrsTy = ::mlir::ArrayAttr;
    target_specific_attrsTy target_specific_attrs;

    auto getTargetSpecificAttrs() const {
      auto &propStorage = this->target_specific_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTargetSpecificAttrs(const ::mlir::ArrayAttr &propValue) {
      this->target_specific_attrs = propValue;
    }
    using thread_local_Ty = ::mlir::UnitAttr;
    thread_local_Ty thread_local_;

    auto getThreadLocal_() const {
      auto &propStorage = this->thread_local_;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setThreadLocal_(const ::mlir::UnitAttr &propValue) {
      this->thread_local_ = propValue;
    }
    using unnamed_addrTy = ::mlir::LLVM::UnnamedAddrAttr;
    unnamed_addrTy unnamed_addr;

    auto getUnnamedAddr() const {
      auto &propStorage = this->unnamed_addr;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(propStorage);
    }
    void setUnnamedAddr(const ::mlir::LLVM::UnnamedAddrAttr &propValue) {
      this->unnamed_addr = propValue;
    }
    using valueTy = ::mlir::Attribute;
    valueTy value;

    auto getValue() const {
      auto &propStorage = this->value;
      return ::llvm::dyn_cast_or_null<::mlir::Attribute>(propStorage);
    }
    void setValue(const ::mlir::Attribute &propValue) {
      this->value = propValue;
    }
    using visibility_Ty = ::mlir::LLVM::VisibilityAttr;
    visibility_Ty visibility_;

    auto getVisibility_() const {
      auto &propStorage = this->visibility_;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(propStorage);
    }
    void setVisibility_(const ::mlir::LLVM::VisibilityAttr &propValue) {
      this->visibility_ = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.addr_space == this->addr_space &&
        rhs.alignment == this->alignment &&
        rhs.comdat == this->comdat &&
        rhs.constant == this->constant &&
        rhs.dbg_exprs == this->dbg_exprs &&
        rhs.dso_local == this->dso_local &&
        rhs.externally_initialized == this->externally_initialized &&
        rhs.global_type == this->global_type &&
        rhs.linkage == this->linkage &&
        rhs.section == this->section &&
        rhs.sym_name == this->sym_name &&
        rhs.target_specific_attrs == this->target_specific_attrs &&
        rhs.thread_local_ == this->thread_local_ &&
        rhs.unnamed_addr == this->unnamed_addr &&
        rhs.value == this->value &&
        rhs.visibility_ == this->visibility_ &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.global", odsAttrs.getContext());
  }

  GlobalOpGenericAdaptorBase(GlobalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getGlobalTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().global_type);
    return attr;
  }

  ::mlir::Type getGlobalType();
  ::mlir::UnitAttr getConstantAttr();
  bool getConstant();
  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
    return attr;
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr();
  bool getDsoLocal();
  ::mlir::UnitAttr getThreadLocal_Attr();
  bool getThreadLocal_();
  ::mlir::UnitAttr getExternallyInitializedAttr();
  bool getExternallyInitialized();
  ::mlir::Attribute getValueAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().value);
    return attr;
  }

  ::std::optional<::mlir::Attribute> getValue();
  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::IntegerAttr getAddrSpaceAttr();
  uint32_t getAddrSpace();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
    return attr;
  }

  ::std::optional<::mlir::LLVM::UnnamedAddr> getUnnamedAddr();
  ::mlir::StringAttr getSectionAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().section);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSection();
  ::mlir::SymbolRefAttr getComdatAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().comdat);
    return attr;
  }

  ::std::optional< ::mlir::SymbolRefAttr > getComdat();
  ::mlir::ArrayAttr getDbgExprsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().dbg_exprs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getDbgExprs();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr();
  ::mlir::LLVM::Visibility getVisibility_();
  ::mlir::ArrayAttr getTargetSpecificAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().target_specific_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTargetSpecificAttrs();
  ::mlir::Region &getInitializer() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class GlobalOpGenericAdaptor : public detail::GlobalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalOpGenericAdaptorBase;
public:
  GlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalOpGenericAdaptor(RangeT values, const GlobalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalOp>>>
  GlobalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalOpAdaptor : public GlobalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalOpGenericAdaptor::GlobalOpGenericAdaptor;
  GlobalOpAdaptor(GlobalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalOp : public ::mlir::Op<GlobalOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ReturnOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("addr_space"), ::llvm::StringRef("alignment"), ::llvm::StringRef("comdat"), ::llvm::StringRef("constant"), ::llvm::StringRef("dbg_exprs"), ::llvm::StringRef("dso_local"), ::llvm::StringRef("externally_initialized"), ::llvm::StringRef("global_type"), ::llvm::StringRef("linkage"), ::llvm::StringRef("section"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("target_specific_attrs"), ::llvm::StringRef("thread_local_"), ::llvm::StringRef("unnamed_addr"), ::llvm::StringRef("value"), ::llvm::StringRef("visibility_")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAddrSpaceAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAddrSpaceAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getComdatAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getComdatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getConstantAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getConstantAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getDbgExprsAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getDbgExprsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getDsoLocalAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getDsoLocalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getExternallyInitializedAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getExternallyInitializedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getGlobalTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getGlobalTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getLinkageAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getLinkageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getSectionAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getSectionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getTargetSpecificAttrsAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getTargetSpecificAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getThreadLocal_AttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getThreadLocal_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getUnnamedAddrAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getUnnamedAddrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getValueAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getValueAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getVisibility_AttrName() {
    return getAttributeNameForIndex(15);
  }

  static ::mlir::StringAttr getVisibility_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 15);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.global");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getInitializer() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getGlobalTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().global_type);
  }

  ::mlir::Type getGlobalType();
  ::mlir::UnitAttr getConstantAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().constant);
  }

  bool getConstant();
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    return ::llvm::cast<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().dso_local);
  }

  bool getDsoLocal();
  ::mlir::UnitAttr getThreadLocal_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().thread_local_);
  }

  bool getThreadLocal_();
  ::mlir::UnitAttr getExternallyInitializedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().externally_initialized);
  }

  bool getExternallyInitialized();
  ::mlir::Attribute getValueAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().value);
  }

  ::std::optional<::mlir::Attribute> getValue();
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::IntegerAttr getAddrSpaceAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().addr_space);
  }

  uint32_t getAddrSpace();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
  }

  ::std::optional<::mlir::LLVM::UnnamedAddr> getUnnamedAddr();
  ::mlir::StringAttr getSectionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().section);
  }

  ::std::optional< ::llvm::StringRef > getSection();
  ::mlir::SymbolRefAttr getComdatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().comdat);
  }

  ::std::optional< ::mlir::SymbolRefAttr > getComdat();
  ::mlir::ArrayAttr getDbgExprsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().dbg_exprs);
  }

  ::std::optional< ::mlir::ArrayAttr > getDbgExprs();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(getProperties().visibility_);
  }

  ::mlir::LLVM::Visibility getVisibility_();
  ::mlir::ArrayAttr getTargetSpecificAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().target_specific_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getTargetSpecificAttrs();
  void setGlobalTypeAttr(::mlir::TypeAttr attr) {
    getProperties().global_type = attr;
  }

  void setGlobalType(::mlir::Type attrValue);
  void setConstantAttr(::mlir::UnitAttr attr) {
    getProperties().constant = attr;
  }

  void setConstant(bool attrValue);
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setLinkageAttr(::mlir::LLVM::LinkageAttr attr) {
    getProperties().linkage = attr;
  }

  void setLinkage(::mlir::LLVM::Linkage attrValue);
  void setDsoLocalAttr(::mlir::UnitAttr attr) {
    getProperties().dso_local = attr;
  }

  void setDsoLocal(bool attrValue);
  void setThreadLocal_Attr(::mlir::UnitAttr attr) {
    getProperties().thread_local_ = attr;
  }

  void setThreadLocal_(bool attrValue);
  void setExternallyInitializedAttr(::mlir::UnitAttr attr) {
    getProperties().externally_initialized = attr;
  }

  void setExternallyInitialized(bool attrValue);
  void setValueAttr(::mlir::Attribute attr) {
    getProperties().value = attr;
  }

  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  void setAddrSpaceAttr(::mlir::IntegerAttr attr) {
    getProperties().addr_space = attr;
  }

  void setAddrSpace(uint32_t attrValue);
  void setUnnamedAddrAttr(::mlir::LLVM::UnnamedAddrAttr attr) {
    getProperties().unnamed_addr = attr;
  }

  void setUnnamedAddr(::std::optional<::mlir::LLVM::UnnamedAddr> attrValue);
  void setSectionAttr(::mlir::StringAttr attr) {
    getProperties().section = attr;
  }

  void setSection(::std::optional<::llvm::StringRef> attrValue);
  void setComdatAttr(::mlir::SymbolRefAttr attr) {
    getProperties().comdat = attr;
  }

  void setDbgExprsAttr(::mlir::ArrayAttr attr) {
    getProperties().dbg_exprs = attr;
  }

  void setVisibility_Attr(::mlir::LLVM::VisibilityAttr attr) {
    getProperties().visibility_ = attr;
  }

  void setVisibility_(::mlir::LLVM::Visibility attrValue);
  void setTargetSpecificAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().target_specific_attrs = attr;
  }

  ::mlir::Attribute removeConstantAttr() {
      auto attr = getProperties().constant;
      getProperties().constant = {};
      return attr;
  }

  ::mlir::Attribute removeDsoLocalAttr() {
      auto attr = getProperties().dso_local;
      getProperties().dso_local = {};
      return attr;
  }

  ::mlir::Attribute removeThreadLocal_Attr() {
      auto attr = getProperties().thread_local_;
      getProperties().thread_local_ = {};
      return attr;
  }

  ::mlir::Attribute removeExternallyInitializedAttr() {
      auto attr = getProperties().externally_initialized;
      getProperties().externally_initialized = {};
      return attr;
  }

  ::mlir::Attribute removeValueAttr() {
      auto attr = getProperties().value;
      getProperties().value = {};
      return attr;
  }

  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  ::mlir::Attribute removeUnnamedAddrAttr() {
      auto attr = getProperties().unnamed_addr;
      getProperties().unnamed_addr = {};
      return attr;
  }

  ::mlir::Attribute removeSectionAttr() {
      auto attr = getProperties().section;
      getProperties().section = {};
      return attr;
  }

  ::mlir::Attribute removeComdatAttr() {
      auto attr = getProperties().comdat;
      getProperties().comdat = {};
      return attr;
  }

  ::mlir::Attribute removeDbgExprsAttr() {
      auto attr = getProperties().dbg_exprs;
      getProperties().dbg_exprs = {};
      return attr;
  }

  ::mlir::Attribute removeTargetSpecificAttrsAttr() {
      auto attr = getProperties().target_specific_attrs;
      getProperties().target_specific_attrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type type, bool isConstant, Linkage linkage, StringRef name, Attribute value, uint64_t alignment = 0, unsigned addrSpace = 0, bool dsoLocal = false, bool thread_local_ = false, SymbolRefAttr comdat = {}, ArrayRef<NamedAttribute> attrs = {}, ArrayRef<Attribute> dbgExprs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type type, bool isConstant, Linkage linkage, StringRef name, Attribute value, uint64_t alignment = 0, unsigned addrSpace = 0, bool dsoLocal = false, bool thread_local_ = false, SymbolRefAttr comdat = {}, ArrayRef<NamedAttribute> attrs = {}, ArrayRef<Attribute> dbgExprs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, Type type, bool isConstant, Linkage linkage, StringRef name, Attribute value, uint64_t alignment = 0, unsigned addrSpace = 0, bool dsoLocal = false, bool thread_local_ = false, SymbolRefAttr comdat = {}, ArrayRef<NamedAttribute> attrs = {}, ArrayRef<Attribute> dbgExprs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeAttr global_type, /*optional*/::mlir::UnitAttr constant, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::UnitAttr externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, ::mlir::IntegerAttr addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::VisibilityAttr visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeAttr global_type, /*optional*/::mlir::UnitAttr constant, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::UnitAttr externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, ::mlir::IntegerAttr addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::VisibilityAttr visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeAttr global_type, /*optional*/::mlir::UnitAttr constant, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::UnitAttr externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, ::mlir::IntegerAttr addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::VisibilityAttr visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr global_type, /*optional*/::mlir::UnitAttr constant, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::UnitAttr externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, ::mlir::IntegerAttr addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::VisibilityAttr visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr global_type, /*optional*/::mlir::UnitAttr constant, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::UnitAttr externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, ::mlir::IntegerAttr addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::VisibilityAttr visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr global_type, /*optional*/::mlir::UnitAttr constant, ::mlir::StringAttr sym_name, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local, /*optional*/::mlir::UnitAttr thread_local_, /*optional*/::mlir::UnitAttr externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, ::mlir::IntegerAttr addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::VisibilityAttr visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type global_type, /*optional*/bool constant, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/bool externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, uint32_t addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::Visibility visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type global_type, /*optional*/bool constant, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/bool externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, uint32_t addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::Visibility visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type global_type, /*optional*/bool constant, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/bool externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, uint32_t addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::Visibility visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type global_type, /*optional*/bool constant, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/bool externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, uint32_t addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::Visibility visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type global_type, /*optional*/bool constant, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/bool externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, uint32_t addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::Visibility visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type global_type, /*optional*/bool constant, ::llvm::StringRef sym_name, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local, /*optional*/bool thread_local_, /*optional*/bool externally_initialized, /*optional*/::mlir::Attribute value, /*optional*/::mlir::IntegerAttr alignment, uint32_t addr_space, /*optional*/::mlir::LLVM::UnnamedAddrAttr unnamed_addr, /*optional*/::mlir::StringAttr section, /*optional*/::mlir::SymbolRefAttr comdat, /*optional*/::mlir::ArrayAttr dbg_exprs, ::mlir::LLVM::Visibility visibility_, /*optional*/::mlir::ArrayAttr target_specific_attrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifyRegions();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 16 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Return the LLVM type of the global.
  Type getType() {
    return getGlobalType();
  }
  /// Return the initializer attribute if it exists, or a null attribute.
  Attribute getValueOrNull() {
    return getValue().value_or(Attribute());
  }
  /// Return the initializer region. This may be empty, but if it is not it
  /// terminates in an `llvm.return` op with the initializer value.
  Region &getInitializerRegion() {
    return getOperation()->getRegion(0);
  }
  /// Return the initializer block. If the initializer region is empty this
  /// is nullptr. If it is not nullptr, it terminates with an `llvm.return`
  /// op with the initializer value.
  Block *getInitializerBlock() {
    return getInitializerRegion().empty() ?
      nullptr : &getInitializerRegion().front();
  }
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::GlobalOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ICmpOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ICmpOpGenericAdaptorBase {
public:
  struct Properties {
    using predicateTy = ::mlir::LLVM::ICmpPredicateAttr;
    predicateTy predicate;

    auto getPredicate() const {
      auto &propStorage = this->predicate;
      return ::llvm::cast<::mlir::LLVM::ICmpPredicateAttr>(propStorage);
    }
    void setPredicate(const ::mlir::LLVM::ICmpPredicateAttr &propValue) {
      this->predicate = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.predicate == this->predicate &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ICmpOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.icmp", odsAttrs.getContext());
  }

  ICmpOpGenericAdaptorBase(ICmpOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ICmpPredicateAttr getPredicateAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::ICmpPredicateAttr>(getProperties().predicate);
    return attr;
  }

  ::mlir::LLVM::ICmpPredicate getPredicate();
};

} // namespace detail
template <typename RangeT>
class ICmpOpGenericAdaptor : public detail::ICmpOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ICmpOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  ICmpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ICmpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ICmpOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ICmpOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ICmpOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ICmpOpGenericAdaptor(RangeT values, const ICmpOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ICmpOp, typename = std::enable_if_t<std::is_same_v<LateInst, ICmpOp>>>
  ICmpOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ICmpOpAdaptor : public ICmpOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ICmpOpGenericAdaptor::ICmpOpGenericAdaptor;
  ICmpOpAdaptor(ICmpOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ICmpOp : public ::mlir::Op<ICmpOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameTypeOperands, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ICmpOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ICmpOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("predicate")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getPredicateAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getPredicateAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.icmp");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ICmpPredicateAttr getPredicateAttr() {
    return ::llvm::cast<::mlir::LLVM::ICmpPredicateAttr>(getProperties().predicate);
  }

  ::mlir::LLVM::ICmpPredicate getPredicate();
  void setPredicateAttr(::mlir::LLVM::ICmpPredicateAttr attr) {
    getProperties().predicate = attr;
  }

  void setPredicate(::mlir::LLVM::ICmpPredicate attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::ICmpPredicateAttr predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::LLVM::ICmpPredicate predicate, ::mlir::Value lhs, ::mlir::Value rhs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ICmpOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ICmpOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ICmpOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::IFuncOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IFuncOpGenericAdaptorBase {
public:
  struct Properties {
    using address_spaceTy = ::mlir::IntegerAttr;
    address_spaceTy address_space;

    auto getAddressSpace() const {
      auto &propStorage = this->address_space;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAddressSpace(const ::mlir::IntegerAttr &propValue) {
      this->address_space = propValue;
    }
    using dso_localTy = ::mlir::UnitAttr;
    dso_localTy dso_local;

    auto getDsoLocal() const {
      auto &propStorage = this->dso_local;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setDsoLocal(const ::mlir::UnitAttr &propValue) {
      this->dso_local = propValue;
    }
    using i_func_typeTy = ::mlir::TypeAttr;
    i_func_typeTy i_func_type;

    auto getIFuncType() const {
      auto &propStorage = this->i_func_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setIFuncType(const ::mlir::TypeAttr &propValue) {
      this->i_func_type = propValue;
    }
    using linkageTy = ::mlir::LLVM::LinkageAttr;
    linkageTy linkage;

    auto getLinkage() const {
      auto &propStorage = this->linkage;
      return ::llvm::cast<::mlir::LLVM::LinkageAttr>(propStorage);
    }
    void setLinkage(const ::mlir::LLVM::LinkageAttr &propValue) {
      this->linkage = propValue;
    }
    using resolverTy = ::mlir::FlatSymbolRefAttr;
    resolverTy resolver;

    auto getResolver() const {
      auto &propStorage = this->resolver;
      return ::llvm::cast<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setResolver(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->resolver = propValue;
    }
    using resolver_typeTy = ::mlir::TypeAttr;
    resolver_typeTy resolver_type;

    auto getResolverType() const {
      auto &propStorage = this->resolver_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setResolverType(const ::mlir::TypeAttr &propValue) {
      this->resolver_type = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using unnamed_addrTy = ::mlir::LLVM::UnnamedAddrAttr;
    unnamed_addrTy unnamed_addr;

    auto getUnnamedAddr() const {
      auto &propStorage = this->unnamed_addr;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(propStorage);
    }
    void setUnnamedAddr(const ::mlir::LLVM::UnnamedAddrAttr &propValue) {
      this->unnamed_addr = propValue;
    }
    using visibility_Ty = ::mlir::LLVM::VisibilityAttr;
    visibility_Ty visibility_;

    auto getVisibility_() const {
      auto &propStorage = this->visibility_;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(propStorage);
    }
    void setVisibility_(const ::mlir::LLVM::VisibilityAttr &propValue) {
      this->visibility_ = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.address_space == this->address_space &&
        rhs.dso_local == this->dso_local &&
        rhs.i_func_type == this->i_func_type &&
        rhs.linkage == this->linkage &&
        rhs.resolver == this->resolver &&
        rhs.resolver_type == this->resolver_type &&
        rhs.sym_name == this->sym_name &&
        rhs.unnamed_addr == this->unnamed_addr &&
        rhs.visibility_ == this->visibility_ &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IFuncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.ifunc", odsAttrs.getContext());
  }

  IFuncOpGenericAdaptorBase(IFuncOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getIFuncTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().i_func_type);
    return attr;
  }

  ::mlir::Type getIFuncType();
  ::mlir::FlatSymbolRefAttr getResolverAttr() {
    auto attr = ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().resolver);
    return attr;
  }

  ::llvm::StringRef getResolver();
  ::mlir::TypeAttr getResolverTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().resolver_type);
    return attr;
  }

  ::mlir::Type getResolverType();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    auto attr = ::llvm::cast<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
    return attr;
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr();
  bool getDsoLocal();
  ::mlir::IntegerAttr getAddressSpaceAttr();
  uint32_t getAddressSpace();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr();
  ::mlir::LLVM::UnnamedAddr getUnnamedAddr();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr();
  ::mlir::LLVM::Visibility getVisibility_();
};

} // namespace detail
template <typename RangeT>
class IFuncOpGenericAdaptor : public detail::IFuncOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IFuncOpGenericAdaptorBase;
public:
  IFuncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IFuncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IFuncOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IFuncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IFuncOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IFuncOpGenericAdaptor(RangeT values, const IFuncOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IFuncOp, typename = std::enable_if_t<std::is_same_v<LateInst, IFuncOp>>>
  IFuncOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IFuncOpAdaptor : public IFuncOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IFuncOpGenericAdaptor::IFuncOpGenericAdaptor;
  IFuncOpAdaptor(IFuncOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IFuncOp : public ::mlir::Op<IFuncOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait, ::mlir::SymbolUserOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IFuncOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IFuncOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("address_space"), ::llvm::StringRef("dso_local"), ::llvm::StringRef("i_func_type"), ::llvm::StringRef("linkage"), ::llvm::StringRef("resolver"), ::llvm::StringRef("resolver_type"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("unnamed_addr"), ::llvm::StringRef("visibility_")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAddressSpaceAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAddressSpaceAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDsoLocalAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDsoLocalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getIFuncTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getIFuncTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getLinkageAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getLinkageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getResolverAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getResolverAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getResolverTypeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getResolverTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getUnnamedAddrAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getUnnamedAddrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getVisibility_AttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getVisibility_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.ifunc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getIFuncTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().i_func_type);
  }

  ::mlir::Type getIFuncType();
  ::mlir::FlatSymbolRefAttr getResolverAttr() {
    return ::llvm::cast<::mlir::FlatSymbolRefAttr>(getProperties().resolver);
  }

  ::llvm::StringRef getResolver();
  ::mlir::TypeAttr getResolverTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().resolver_type);
  }

  ::mlir::Type getResolverType();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    return ::llvm::cast<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().dso_local);
  }

  bool getDsoLocal();
  ::mlir::IntegerAttr getAddressSpaceAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().address_space);
  }

  uint32_t getAddressSpace();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
  }

  ::mlir::LLVM::UnnamedAddr getUnnamedAddr();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(getProperties().visibility_);
  }

  ::mlir::LLVM::Visibility getVisibility_();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setIFuncTypeAttr(::mlir::TypeAttr attr) {
    getProperties().i_func_type = attr;
  }

  void setIFuncType(::mlir::Type attrValue);
  void setResolverAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().resolver = attr;
  }

  void setResolver(::llvm::StringRef attrValue);
  void setResolverTypeAttr(::mlir::TypeAttr attr) {
    getProperties().resolver_type = attr;
  }

  void setResolverType(::mlir::Type attrValue);
  void setLinkageAttr(::mlir::LLVM::LinkageAttr attr) {
    getProperties().linkage = attr;
  }

  void setLinkage(::mlir::LLVM::Linkage attrValue);
  void setDsoLocalAttr(::mlir::UnitAttr attr) {
    getProperties().dso_local = attr;
  }

  void setDsoLocal(bool attrValue);
  void setAddressSpaceAttr(::mlir::IntegerAttr attr) {
    getProperties().address_space = attr;
  }

  void setAddressSpace(uint32_t attrValue);
  void setUnnamedAddrAttr(::mlir::LLVM::UnnamedAddrAttr attr) {
    getProperties().unnamed_addr = attr;
  }

  void setUnnamedAddr(::mlir::LLVM::UnnamedAddr attrValue);
  void setVisibility_Attr(::mlir::LLVM::VisibilityAttr attr) {
    getProperties().visibility_ = attr;
  }

  void setVisibility_(::mlir::LLVM::Visibility attrValue);
  ::mlir::Attribute removeDsoLocalAttr() {
      auto attr = getProperties().dso_local;
      getProperties().dso_local = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, StringRef name, Type i_func_type, StringRef resolver, Type resolver_type, Linkage linkage, LLVM::Visibility visibility);
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, StringRef name, Type i_func_type, StringRef resolver, Type resolver_type, Linkage linkage, LLVM::Visibility visibility);
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, StringRef name, Type i_func_type, StringRef resolver, Type resolver_type, Linkage linkage, LLVM::Visibility visibility);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr i_func_type, ::mlir::FlatSymbolRefAttr resolver, ::mlir::TypeAttr resolver_type, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local = nullptr, ::mlir::IntegerAttr address_space = nullptr, ::mlir::LLVM::UnnamedAddrAttr unnamed_addr = nullptr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::TypeAttr i_func_type, ::mlir::FlatSymbolRefAttr resolver, ::mlir::TypeAttr resolver_type, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local = nullptr, ::mlir::IntegerAttr address_space = nullptr, ::mlir::LLVM::UnnamedAddrAttr unnamed_addr = nullptr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::TypeAttr i_func_type, ::mlir::FlatSymbolRefAttr resolver, ::mlir::TypeAttr resolver_type, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local = nullptr, ::mlir::IntegerAttr address_space = nullptr, ::mlir::LLVM::UnnamedAddrAttr unnamed_addr = nullptr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr i_func_type, ::mlir::FlatSymbolRefAttr resolver, ::mlir::TypeAttr resolver_type, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local = nullptr, ::mlir::IntegerAttr address_space = nullptr, ::mlir::LLVM::UnnamedAddrAttr unnamed_addr = nullptr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr i_func_type, ::mlir::FlatSymbolRefAttr resolver, ::mlir::TypeAttr resolver_type, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local = nullptr, ::mlir::IntegerAttr address_space = nullptr, ::mlir::LLVM::UnnamedAddrAttr unnamed_addr = nullptr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr i_func_type, ::mlir::FlatSymbolRefAttr resolver, ::mlir::TypeAttr resolver_type, ::mlir::LLVM::LinkageAttr linkage, /*optional*/::mlir::UnitAttr dso_local = nullptr, ::mlir::IntegerAttr address_space = nullptr, ::mlir::LLVM::UnnamedAddrAttr unnamed_addr = nullptr, ::mlir::LLVM::VisibilityAttr visibility_ = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type i_func_type, ::llvm::StringRef resolver, ::mlir::Type resolver_type, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local = false, uint32_t address_space = 0, ::mlir::LLVM::UnnamedAddr unnamed_addr = mlir::LLVM::UnnamedAddr::None, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::Type i_func_type, ::llvm::StringRef resolver, ::mlir::Type resolver_type, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local = false, uint32_t address_space = 0, ::mlir::LLVM::UnnamedAddr unnamed_addr = mlir::LLVM::UnnamedAddr::None, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::Type i_func_type, ::llvm::StringRef resolver, ::mlir::Type resolver_type, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local = false, uint32_t address_space = 0, ::mlir::LLVM::UnnamedAddr unnamed_addr = mlir::LLVM::UnnamedAddr::None, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type i_func_type, ::llvm::StringRef resolver, ::mlir::Type resolver_type, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local = false, uint32_t address_space = 0, ::mlir::LLVM::UnnamedAddr unnamed_addr = mlir::LLVM::UnnamedAddr::None, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type i_func_type, ::llvm::StringRef resolver, ::mlir::Type resolver_type, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local = false, uint32_t address_space = 0, ::mlir::LLVM::UnnamedAddr unnamed_addr = mlir::LLVM::UnnamedAddr::None, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type i_func_type, ::llvm::StringRef resolver, ::mlir::Type resolver_type, ::mlir::LLVM::Linkage linkage, /*optional*/bool dso_local = false, uint32_t address_space = 0, ::mlir::LLVM::UnnamedAddr unnamed_addr = mlir::LLVM::UnnamedAddr::None, ::mlir::LLVM::Visibility visibility_ = mlir::LLVM::Visibility::Default);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IFuncOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifySymbolUses(::mlir::SymbolTableCollection &symbolTable);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::IFuncOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::IndirectBrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IndirectBrOpGenericAdaptorBase {
public:
  struct Properties {
    using indbr_operand_segmentsTy = ::mlir::DenseI32ArrayAttr;
    indbr_operand_segmentsTy indbr_operand_segments;

    auto getIndbrOperandSegments() const {
      auto &propStorage = this->indbr_operand_segments;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setIndbrOperandSegments(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->indbr_operand_segments = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.indbr_operand_segments == this->indbr_operand_segments &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IndirectBrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.indirectbr", odsAttrs.getContext());
  }

  IndirectBrOpGenericAdaptorBase(IndirectBrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI32ArrayAttr getIndbrOperandSegmentsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().indbr_operand_segments);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getIndbrOperandSegments();
};

} // namespace detail
template <typename RangeT>
class IndirectBrOpGenericAdaptor : public detail::IndirectBrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IndirectBrOpGenericAdaptorBase;
  static constexpr int odsIndex_addr = 0;
  static constexpr int odsIndex_succOperands = 1;
public:
  IndirectBrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IndirectBrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IndirectBrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IndirectBrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IndirectBrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IndirectBrOpGenericAdaptor(RangeT values, const IndirectBrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IndirectBrOp, typename = std::enable_if_t<std::is_same_v<LateInst, IndirectBrOp>>>
  IndirectBrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAddr() {
    return (*getODSOperands(0).begin());
  }

  ::llvm::SmallVector<RangeT> getSuccOperands() {
    auto tblgenTmpOperands = getODSOperands(1);
    auto sizes = getIndbrOperandSegments();

    ::llvm::SmallVector<RangeT> tblgenTmpOperandGroups;
    for (int i = 0, e = sizes.size(); i < e; ++i) {
      tblgenTmpOperandGroups.push_back(tblgenTmpOperands.take_front(sizes[i]));
      tblgenTmpOperands = tblgenTmpOperands.drop_front(sizes[i]);
    }
    return tblgenTmpOperandGroups;
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IndirectBrOpAdaptor : public IndirectBrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IndirectBrOpGenericAdaptor::IndirectBrOpGenericAdaptor;
  IndirectBrOpAdaptor(IndirectBrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IndirectBrOp : public ::mlir::Op<IndirectBrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::VariadicSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::BranchOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IndirectBrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IndirectBrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_addr = 0;
  static constexpr int odsIndex_succOperands = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::BranchOpInterface::Trait<IndirectBrOp>::getSuccessorForOperands;
  using ::mlir::BranchOpInterface::Trait<IndirectBrOp>::areTypesCompatible;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("indbr_operand_segments")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIndbrOperandSegmentsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIndbrOperandSegmentsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.indirectbr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getAddr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OperandRangeRange getSuccOperands() {
    return getODSOperands(1).split(getIndbrOperandSegmentsAttr());
  }

  ::mlir::OpOperand &getAddrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRangeRange getSuccOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::SuccessorRange getSuccessors() {
    return {std::next((*this)->successor_begin(), 0), (*this)->successor_end()};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI32ArrayAttr getIndbrOperandSegmentsAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().indbr_operand_segments);
  }

  ::llvm::ArrayRef<int32_t> getIndbrOperandSegments();
  void setIndbrOperandSegmentsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().indbr_operand_segments = attr;
  }

  void setIndbrOperandSegments(::llvm::ArrayRef<int32_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value addr, ArrayRef<ValueRange> succOperands = {}, BlockRange successors = {});
  static IndirectBrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value addr, ArrayRef<ValueRange> succOperands = {}, BlockRange successors = {});
  static IndirectBrOp create(::mlir::ImplicitLocOpBuilder &builder, Value addr, ArrayRef<ValueRange> succOperands = {}, BlockRange successors = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::SuccessorOperands getSuccessorOperands(unsigned index);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::IndirectBrOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::InlineAsmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InlineAsmOpGenericAdaptorBase {
public:
  struct Properties {
    using asm_dialectTy = ::mlir::LLVM::AsmDialectAttr;
    asm_dialectTy asm_dialect;

    auto getAsmDialect() const {
      auto &propStorage = this->asm_dialect;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::AsmDialectAttr>(propStorage);
    }
    void setAsmDialect(const ::mlir::LLVM::AsmDialectAttr &propValue) {
      this->asm_dialect = propValue;
    }
    using asm_stringTy = ::mlir::StringAttr;
    asm_stringTy asm_string;

    auto getAsmString() const {
      auto &propStorage = this->asm_string;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setAsmString(const ::mlir::StringAttr &propValue) {
      this->asm_string = propValue;
    }
    using constraintsTy = ::mlir::StringAttr;
    constraintsTy constraints;

    auto getConstraints() const {
      auto &propStorage = this->constraints;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setConstraints(const ::mlir::StringAttr &propValue) {
      this->constraints = propValue;
    }
    using has_side_effectsTy = ::mlir::UnitAttr;
    has_side_effectsTy has_side_effects;

    auto getHasSideEffects() const {
      auto &propStorage = this->has_side_effects;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setHasSideEffects(const ::mlir::UnitAttr &propValue) {
      this->has_side_effects = propValue;
    }
    using is_align_stackTy = ::mlir::UnitAttr;
    is_align_stackTy is_align_stack;

    auto getIsAlignStack() const {
      auto &propStorage = this->is_align_stack;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setIsAlignStack(const ::mlir::UnitAttr &propValue) {
      this->is_align_stack = propValue;
    }
    using operand_attrsTy = ::mlir::ArrayAttr;
    operand_attrsTy operand_attrs;

    auto getOperandAttrs() const {
      auto &propStorage = this->operand_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOperandAttrs(const ::mlir::ArrayAttr &propValue) {
      this->operand_attrs = propValue;
    }
    using tail_call_kindTy = ::mlir::LLVM::TailCallKindAttr;
    tail_call_kindTy tail_call_kind;

    auto getTailCallKind() const {
      auto &propStorage = this->tail_call_kind;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::TailCallKindAttr>(propStorage);
    }
    void setTailCallKind(const ::mlir::LLVM::TailCallKindAttr &propValue) {
      this->tail_call_kind = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.asm_dialect == this->asm_dialect &&
        rhs.asm_string == this->asm_string &&
        rhs.constraints == this->constraints &&
        rhs.has_side_effects == this->has_side_effects &&
        rhs.is_align_stack == this->is_align_stack &&
        rhs.operand_attrs == this->operand_attrs &&
        rhs.tail_call_kind == this->tail_call_kind &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InlineAsmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.inline_asm", odsAttrs.getContext());
  }

  InlineAsmOpGenericAdaptorBase(InlineAsmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getAsmStringAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().asm_string);
    return attr;
  }

  ::llvm::StringRef getAsmString();
  ::mlir::StringAttr getConstraintsAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().constraints);
    return attr;
  }

  ::llvm::StringRef getConstraints();
  ::mlir::UnitAttr getHasSideEffectsAttr();
  bool getHasSideEffects();
  ::mlir::UnitAttr getIsAlignStackAttr();
  bool getIsAlignStack();
  ::mlir::LLVM::TailCallKindAttr getTailCallKindAttr();
  ::mlir::LLVM::tailcallkind::TailCallKind getTailCallKind();
  ::mlir::LLVM::AsmDialectAttr getAsmDialectAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::AsmDialectAttr>(getProperties().asm_dialect);
    return attr;
  }

  ::std::optional<::mlir::LLVM::AsmDialect> getAsmDialect();
  ::mlir::ArrayAttr getOperandAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().operand_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getOperandAttrs();
};

} // namespace detail
template <typename RangeT>
class InlineAsmOpGenericAdaptor : public detail::InlineAsmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InlineAsmOpGenericAdaptorBase;
  static constexpr int odsIndex_operands = 0;
public:
  InlineAsmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InlineAsmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InlineAsmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InlineAsmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InlineAsmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InlineAsmOpGenericAdaptor(RangeT values, const InlineAsmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InlineAsmOp, typename = std::enable_if_t<std::is_same_v<LateInst, InlineAsmOp>>>
  InlineAsmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return getODSOperands(0);
  }

private:
  RangeT odsOperands;
};
class InlineAsmOpAdaptor : public InlineAsmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InlineAsmOpGenericAdaptor::InlineAsmOpGenericAdaptor;
  InlineAsmOpAdaptor(InlineAsmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InlineAsmOp : public ::mlir::Op<InlineAsmOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InlineAsmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InlineAsmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("asm_dialect"), ::llvm::StringRef("asm_string"), ::llvm::StringRef("constraints"), ::llvm::StringRef("has_side_effects"), ::llvm::StringRef("is_align_stack"), ::llvm::StringRef("operand_attrs"), ::llvm::StringRef("tail_call_kind")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAsmDialectAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAsmDialectAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAsmStringAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAsmStringAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getConstraintsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getConstraintsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getHasSideEffectsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getHasSideEffectsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getIsAlignStackAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getIsAlignStackAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOperandAttrsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getOperandAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getTailCallKindAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getTailCallKindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.inline_asm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::Type>() : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getAsmStringAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().asm_string);
  }

  ::llvm::StringRef getAsmString();
  ::mlir::StringAttr getConstraintsAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().constraints);
  }

  ::llvm::StringRef getConstraints();
  ::mlir::UnitAttr getHasSideEffectsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().has_side_effects);
  }

  bool getHasSideEffects();
  ::mlir::UnitAttr getIsAlignStackAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().is_align_stack);
  }

  bool getIsAlignStack();
  ::mlir::LLVM::TailCallKindAttr getTailCallKindAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::TailCallKindAttr>(getProperties().tail_call_kind);
  }

  ::mlir::LLVM::tailcallkind::TailCallKind getTailCallKind();
  ::mlir::LLVM::AsmDialectAttr getAsmDialectAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::AsmDialectAttr>(getProperties().asm_dialect);
  }

  ::std::optional<::mlir::LLVM::AsmDialect> getAsmDialect();
  ::mlir::ArrayAttr getOperandAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().operand_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getOperandAttrs();
  void setAsmStringAttr(::mlir::StringAttr attr) {
    getProperties().asm_string = attr;
  }

  void setAsmString(::llvm::StringRef attrValue);
  void setConstraintsAttr(::mlir::StringAttr attr) {
    getProperties().constraints = attr;
  }

  void setConstraints(::llvm::StringRef attrValue);
  void setHasSideEffectsAttr(::mlir::UnitAttr attr) {
    getProperties().has_side_effects = attr;
  }

  void setHasSideEffects(bool attrValue);
  void setIsAlignStackAttr(::mlir::UnitAttr attr) {
    getProperties().is_align_stack = attr;
  }

  void setIsAlignStack(bool attrValue);
  void setTailCallKindAttr(::mlir::LLVM::TailCallKindAttr attr) {
    getProperties().tail_call_kind = attr;
  }

  void setTailCallKind(::mlir::LLVM::tailcallkind::TailCallKind attrValue);
  void setAsmDialectAttr(::mlir::LLVM::AsmDialectAttr attr) {
    getProperties().asm_dialect = attr;
  }

  void setAsmDialect(::std::optional<::mlir::LLVM::AsmDialect> attrValue);
  void setOperandAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().operand_attrs = attr;
  }

  ::mlir::Attribute removeHasSideEffectsAttr() {
      auto attr = getProperties().has_side_effects;
      getProperties().has_side_effects = {};
      return attr;
  }

  ::mlir::Attribute removeIsAlignStackAttr() {
      auto attr = getProperties().is_align_stack;
      getProperties().is_align_stack = {};
      return attr;
  }

  ::mlir::Attribute removeAsmDialectAttr() {
      auto attr = getProperties().asm_dialect;
      getProperties().asm_dialect = {};
      return attr;
  }

  ::mlir::Attribute removeOperandAttrsAttr() {
      auto attr = getProperties().operand_attrs;
      getProperties().operand_attrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type res, ::mlir::ValueRange operands, ::mlir::StringAttr asm_string, ::mlir::StringAttr constraints, /*optional*/::mlir::UnitAttr has_side_effects, /*optional*/::mlir::UnitAttr is_align_stack, ::mlir::LLVM::TailCallKindAttr tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type res, ::mlir::ValueRange operands, ::mlir::StringAttr asm_string, ::mlir::StringAttr constraints, /*optional*/::mlir::UnitAttr has_side_effects, /*optional*/::mlir::UnitAttr is_align_stack, ::mlir::LLVM::TailCallKindAttr tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type res, ::mlir::ValueRange operands, ::mlir::StringAttr asm_string, ::mlir::StringAttr constraints, /*optional*/::mlir::UnitAttr has_side_effects, /*optional*/::mlir::UnitAttr is_align_stack, ::mlir::LLVM::TailCallKindAttr tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::mlir::StringAttr asm_string, ::mlir::StringAttr constraints, /*optional*/::mlir::UnitAttr has_side_effects, /*optional*/::mlir::UnitAttr is_align_stack, ::mlir::LLVM::TailCallKindAttr tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::mlir::StringAttr asm_string, ::mlir::StringAttr constraints, /*optional*/::mlir::UnitAttr has_side_effects, /*optional*/::mlir::UnitAttr is_align_stack, ::mlir::LLVM::TailCallKindAttr tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::mlir::StringAttr asm_string, ::mlir::StringAttr constraints, /*optional*/::mlir::UnitAttr has_side_effects, /*optional*/::mlir::UnitAttr is_align_stack, ::mlir::LLVM::TailCallKindAttr tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type res, ::mlir::ValueRange operands, ::llvm::StringRef asm_string, ::llvm::StringRef constraints, /*optional*/bool has_side_effects, /*optional*/bool is_align_stack, ::mlir::LLVM::tailcallkind::TailCallKind tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type res, ::mlir::ValueRange operands, ::llvm::StringRef asm_string, ::llvm::StringRef constraints, /*optional*/bool has_side_effects, /*optional*/bool is_align_stack, ::mlir::LLVM::tailcallkind::TailCallKind tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type res, ::mlir::ValueRange operands, ::llvm::StringRef asm_string, ::llvm::StringRef constraints, /*optional*/bool has_side_effects, /*optional*/bool is_align_stack, ::mlir::LLVM::tailcallkind::TailCallKind tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::StringRef asm_string, ::llvm::StringRef constraints, /*optional*/bool has_side_effects, /*optional*/bool is_align_stack, ::mlir::LLVM::tailcallkind::TailCallKind tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::StringRef asm_string, ::llvm::StringRef constraints, /*optional*/bool has_side_effects, /*optional*/bool is_align_stack, ::mlir::LLVM::tailcallkind::TailCallKind tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static InlineAsmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::StringRef asm_string, ::llvm::StringRef constraints, /*optional*/bool has_side_effects, /*optional*/bool is_align_stack, ::mlir::LLVM::tailcallkind::TailCallKind tail_call_kind, /*optional*/::mlir::LLVM::AsmDialectAttr asm_dialect, /*optional*/::mlir::ArrayAttr operand_attrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InlineAsmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InlineAsmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InlineAsmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InlineAsmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static StringRef getElementTypeAttrName() {
    return "elementtype";
  }
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::InlineAsmOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::InsertElementOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InsertElementOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InsertElementOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.insertelement", odsAttrs.getContext());
  }

  InsertElementOpGenericAdaptorBase(InsertElementOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class InsertElementOpGenericAdaptor : public detail::InsertElementOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InsertElementOpGenericAdaptorBase;
  static constexpr int odsIndex_vector = 0;
  static constexpr int odsIndex_value = 1;
  static constexpr int odsIndex_position = 2;
public:
  InsertElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InsertElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InsertElementOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InsertElementOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InsertElementOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InsertElementOpGenericAdaptor(RangeT values, const InsertElementOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InsertElementOp, typename = std::enable_if_t<std::is_same_v<LateInst, InsertElementOp>>>
  InsertElementOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVector() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  ValueT getPosition() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InsertElementOpAdaptor : public InsertElementOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InsertElementOpGenericAdaptor::InsertElementOpGenericAdaptor;
  InsertElementOpAdaptor(InsertElementOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InsertElementOp : public ::mlir::Op<InsertElementOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InsertElementOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InsertElementOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_vector = 0;
  static constexpr int odsIndex_value = 1;
  static constexpr int odsIndex_position = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.insertelement");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getVector() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPosition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getVectorMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getPositionMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value value, ::mlir::Value position);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertElementOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertElementOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::InsertElementOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::InsertValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InsertValueOpGenericAdaptorBase {
public:
  struct Properties {
    using positionTy = ::mlir::DenseI64ArrayAttr;
    positionTy position;

    auto getPosition() const {
      auto &propStorage = this->position;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setPosition(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->position = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.position == this->position &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InsertValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.insertvalue", odsAttrs.getContext());
  }

  InsertValueOpGenericAdaptorBase(InsertValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getPositionAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().position);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getPosition();
};

} // namespace detail
template <typename RangeT>
class InsertValueOpGenericAdaptor : public detail::InsertValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InsertValueOpGenericAdaptorBase;
  static constexpr int odsIndex_container = 0;
  static constexpr int odsIndex_value = 1;
public:
  InsertValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InsertValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InsertValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InsertValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InsertValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InsertValueOpGenericAdaptor(RangeT values, const InsertValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InsertValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, InsertValueOp>>>
  InsertValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getContainer() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InsertValueOpAdaptor : public InsertValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InsertValueOpGenericAdaptor::InsertValueOpGenericAdaptor;
  InsertValueOpAdaptor(InsertValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InsertValueOp : public ::mlir::Op<InsertValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InsertValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InsertValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_container = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("position")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getPositionAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getPositionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.insertvalue");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getContainer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getContainerMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getPositionAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().position);
  }

  ::llvm::ArrayRef<int64_t> getPosition();
  void setPositionAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().position = attr;
  }

  void setPosition(::llvm::ArrayRef<int64_t> attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::Value value, ::mlir::DenseI64ArrayAttr position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value container, ::mlir::Value value, ::llvm::ArrayRef<int64_t> position);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::InsertValueOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::IntToPtrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IntToPtrOpGenericAdaptorBase {
public:
  struct Properties {
    using dereferenceableTy = ::mlir::LLVM::DereferenceableAttr;
    dereferenceableTy dereferenceable;

    auto getDereferenceable() const {
      auto &propStorage = this->dereferenceable;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::DereferenceableAttr>(propStorage);
    }
    void setDereferenceable(const ::mlir::LLVM::DereferenceableAttr &propValue) {
      this->dereferenceable = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dereferenceable == this->dereferenceable &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IntToPtrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.inttoptr", odsAttrs.getContext());
  }

  IntToPtrOpGenericAdaptorBase(IntToPtrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::DereferenceableAttr getDereferenceableAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::DereferenceableAttr>(getProperties().dereferenceable);
    return attr;
  }

  ::std::optional<::mlir::LLVM::DereferenceableAttr> getDereferenceable();
};

} // namespace detail
template <typename RangeT>
class IntToPtrOpGenericAdaptor : public detail::IntToPtrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IntToPtrOpGenericAdaptorBase;
  static constexpr int odsIndex_arg = 0;
public:
  IntToPtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IntToPtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IntToPtrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IntToPtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IntToPtrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IntToPtrOpGenericAdaptor(RangeT values, const IntToPtrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IntToPtrOp, typename = std::enable_if_t<std::is_same_v<LateInst, IntToPtrOp>>>
  IntToPtrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArg() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IntToPtrOpAdaptor : public IntToPtrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IntToPtrOpGenericAdaptor::IntToPtrOpGenericAdaptor;
  IntToPtrOpAdaptor(IntToPtrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IntToPtrOp : public ::mlir::Op<IntToPtrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::DereferenceableOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IntToPtrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IntToPtrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_arg = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::DereferenceableOpInterface::Trait<IntToPtrOp>::getDereferenceableOrNull;
  using ::mlir::LLVM::DereferenceableOpInterface::Trait<IntToPtrOp>::setDereferenceable;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dereferenceable")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDereferenceableAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDereferenceableAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.inttoptr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getArgMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::DereferenceableAttr getDereferenceableAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::DereferenceableAttr>(getProperties().dereferenceable);
  }

  ::std::optional<::mlir::LLVM::DereferenceableAttr> getDereferenceable();
  void setDereferenceableAttr(::mlir::LLVM::DereferenceableAttr attr) {
    getProperties().dereferenceable = attr;
  }

  ::mlir::Attribute removeDereferenceableAttr() {
      auto attr = getProperties().dereferenceable;
      getProperties().dereferenceable = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static IntToPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static IntToPtrOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value arg, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable);
  static IntToPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value arg, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable);
  static IntToPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value arg, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value arg, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable);
  static IntToPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value arg, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable);
  static IntToPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value arg, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IntToPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IntToPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IntToPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IntToPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::IntToPtrOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::InvokeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InvokeOpGenericAdaptorBase {
public:
  struct Properties {
    using CConvTy = ::mlir::LLVM::CConvAttr;
    CConvTy CConv;

    auto getCConv() const {
      auto &propStorage = this->CConv;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::CConvAttr>(propStorage);
    }
    void setCConv(const ::mlir::LLVM::CConvAttr &propValue) {
      this->CConv = propValue;
    }
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using branch_weightsTy = ::mlir::DenseI32ArrayAttr;
    branch_weightsTy branch_weights;

    auto getBranchWeights() const {
      auto &propStorage = this->branch_weights;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setBranchWeights(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->branch_weights = propValue;
    }
    using calleeTy = ::mlir::FlatSymbolRefAttr;
    calleeTy callee;

    auto getCallee() const {
      auto &propStorage = this->callee;
      return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setCallee(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->callee = propValue;
    }
    using op_bundle_sizesTy = ::mlir::DenseI32ArrayAttr;
    op_bundle_sizesTy op_bundle_sizes;

    auto getOpBundleSizes() const {
      auto &propStorage = this->op_bundle_sizes;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setOpBundleSizes(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->op_bundle_sizes = propValue;
    }
    using op_bundle_tagsTy = ::mlir::ArrayAttr;
    op_bundle_tagsTy op_bundle_tags;

    auto getOpBundleTags() const {
      auto &propStorage = this->op_bundle_tags;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setOpBundleTags(const ::mlir::ArrayAttr &propValue) {
      this->op_bundle_tags = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    using var_callee_typeTy = ::mlir::TypeAttr;
    var_callee_typeTy var_callee_type;

    auto getVarCalleeType() const {
      auto &propStorage = this->var_callee_type;
      return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(propStorage);
    }
    void setVarCalleeType(const ::mlir::TypeAttr &propValue) {
      this->var_callee_type = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.CConv == this->CConv &&
        rhs.arg_attrs == this->arg_attrs &&
        rhs.branch_weights == this->branch_weights &&
        rhs.callee == this->callee &&
        rhs.op_bundle_sizes == this->op_bundle_sizes &&
        rhs.op_bundle_tags == this->op_bundle_tags &&
        rhs.res_attrs == this->res_attrs &&
        rhs.var_callee_type == this->var_callee_type &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InvokeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.invoke", odsAttrs.getContext());
  }

  InvokeOpGenericAdaptorBase(InvokeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getVarCalleeTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().var_callee_type);
    return attr;
  }

  ::std::optional<::mlir::LLVM::LLVMFunctionType> getVarCalleeType();
  ::mlir::FlatSymbolRefAttr getCalleeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().callee);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getCallee();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::DenseI32ArrayAttr getBranchWeightsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().branch_weights);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getBranchWeights();
  ::mlir::LLVM::CConvAttr getCConvAttr();
  ::mlir::LLVM::cconv::CConv getCConv();
  ::mlir::DenseI32ArrayAttr getOpBundleSizesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().op_bundle_sizes);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getOpBundleSizes();
  ::mlir::ArrayAttr getOpBundleTagsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().op_bundle_tags);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getOpBundleTags();
};

} // namespace detail
template <typename RangeT>
class InvokeOpGenericAdaptor : public detail::InvokeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InvokeOpGenericAdaptorBase;
  static constexpr int odsIndex_callee_operands = 0;
  static constexpr int odsIndex_normalDestOperands = 1;
  static constexpr int odsIndex_unwindDestOperands = 2;
  static constexpr int odsIndex_op_bundle_operands = 3;
public:
  InvokeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InvokeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InvokeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InvokeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : InvokeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InvokeOpGenericAdaptor(RangeT values, const InvokeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InvokeOp, typename = std::enable_if_t<std::is_same_v<LateInst, InvokeOp>>>
  InvokeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getCalleeOperands() {
    return getODSOperands(0);
  }

  RangeT getNormalDestOperands() {
    return getODSOperands(1);
  }

  RangeT getUnwindDestOperands() {
    return getODSOperands(2);
  }

  ::llvm::SmallVector<RangeT> getOpBundleOperands() {
    auto tblgenTmpOperands = getODSOperands(3);
    auto sizes = getOpBundleSizes();

    ::llvm::SmallVector<RangeT> tblgenTmpOperandGroups;
    for (int i = 0, e = sizes.size(); i < e; ++i) {
      tblgenTmpOperandGroups.push_back(tblgenTmpOperands.take_front(sizes[i]));
      tblgenTmpOperands = tblgenTmpOperands.drop_front(sizes[i]);
    }
    return tblgenTmpOperandGroups;
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InvokeOpAdaptor : public InvokeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InvokeOpGenericAdaptor::InvokeOpGenericAdaptor;
  InvokeOpAdaptor(InvokeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InvokeOp : public ::mlir::Op<InvokeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::NSuccessors<2>::Impl, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::BranchOpInterface::Trait, ::mlir::ArgAndResultAttrsOpInterface::Trait, ::mlir::CallOpInterface::Trait, ::mlir::WeightedBranchOpInterface::Trait, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InvokeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InvokeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_callee_operands = 0;
  static constexpr int odsIndex_normalDestOperands = 1;
  static constexpr int odsIndex_unwindDestOperands = 2;
  static constexpr int odsIndex_op_bundle_operands = 3;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::BranchOpInterface::Trait<InvokeOp>::getSuccessorForOperands;
  using ::mlir::BranchOpInterface::Trait<InvokeOp>::areTypesCompatible;
  using ::mlir::CallOpInterface::Trait<InvokeOp>::resolveCallableInTable;
  using ::mlir::CallOpInterface::Trait<InvokeOp>::resolveCallable;
  using ::mlir::WeightedBranchOpInterface::Trait<InvokeOp>::getWeights;
  using ::mlir::WeightedBranchOpInterface::Trait<InvokeOp>::setWeights;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("CConv"), ::llvm::StringRef("arg_attrs"), ::llvm::StringRef("branch_weights"), ::llvm::StringRef("callee"), ::llvm::StringRef("op_bundle_sizes"), ::llvm::StringRef("op_bundle_tags"), ::llvm::StringRef("res_attrs"), ::llvm::StringRef("var_callee_type"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCConvAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCConvAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getBranchWeightsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getBranchWeightsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getCalleeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getCalleeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOpBundleSizesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getOpBundleSizesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOpBundleTagsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getOpBundleTagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getVarCalleeTypeAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getVarCalleeTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.invoke");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getCalleeOperands() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getNormalDestOperands() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getUnwindDestOperands() {
    return getODSOperands(2);
  }

  ::mlir::OperandRangeRange getOpBundleOperands() {
    return getODSOperands(3).split(getOpBundleSizesAttr());
  }

  ::mlir::MutableOperandRange getCalleeOperandsMutable();
  ::mlir::MutableOperandRange getNormalDestOperandsMutable();
  ::mlir::MutableOperandRange getUnwindDestOperandsMutable();
  ::mlir::MutableOperandRangeRange getOpBundleOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::Type>() : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*results.begin());
  }

  ::mlir::Block *getNormalDest() {
    return (*this)->getSuccessor(0);
  }

  ::mlir::Block *getUnwindDest() {
    return (*this)->getSuccessor(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getVarCalleeTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().var_callee_type);
  }

  ::std::optional<::mlir::LLVM::LLVMFunctionType> getVarCalleeType();
  ::mlir::FlatSymbolRefAttr getCalleeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().callee);
  }

  ::std::optional< ::llvm::StringRef > getCallee();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::DenseI32ArrayAttr getBranchWeightsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().branch_weights);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getBranchWeights();
  ::mlir::LLVM::CConvAttr getCConvAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::CConvAttr>(getProperties().CConv);
  }

  ::mlir::LLVM::cconv::CConv getCConv();
  ::mlir::DenseI32ArrayAttr getOpBundleSizesAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().op_bundle_sizes);
  }

  ::llvm::ArrayRef<int32_t> getOpBundleSizes();
  ::mlir::ArrayAttr getOpBundleTagsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().op_bundle_tags);
  }

  ::std::optional< ::mlir::ArrayAttr > getOpBundleTags();
  void setVarCalleeTypeAttr(::mlir::TypeAttr attr) {
    getProperties().var_callee_type = attr;
  }

  void setVarCalleeType(::std::optional<::mlir::LLVM::LLVMFunctionType> attrValue);
  void setCalleeAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().callee = attr;
  }

  void setCallee(::std::optional<::llvm::StringRef> attrValue);
  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  void setBranchWeightsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().branch_weights = attr;
  }

  void setBranchWeights(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setCConvAttr(::mlir::LLVM::CConvAttr attr) {
    getProperties().CConv = attr;
  }

  void setCConv(::mlir::LLVM::cconv::CConv attrValue);
  void setOpBundleSizesAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().op_bundle_sizes = attr;
  }

  void setOpBundleSizes(::llvm::ArrayRef<int32_t> attrValue);
  void setOpBundleTagsAttr(::mlir::ArrayAttr attr) {
    getProperties().op_bundle_tags = attr;
  }

  ::mlir::Attribute removeVarCalleeTypeAttr() {
      auto attr = getProperties().var_callee_type;
      getProperties().var_callee_type = {};
      return attr;
  }

  ::mlir::Attribute removeCalleeAttr() {
      auto attr = getProperties().callee;
      getProperties().callee = {};
      return attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeBranchWeightsAttr() {
      auto attr = getProperties().branch_weights;
      getProperties().branch_weights = {};
      return attr;
  }

  ::mlir::Attribute removeOpBundleTagsAttr() {
      auto attr = getProperties().op_bundle_tags;
      getProperties().op_bundle_tags = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFuncOp func, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFuncOp func, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFuncOp func, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange tys, FlatSymbolRefAttr callee, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TypeRange tys, FlatSymbolRefAttr callee, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, TypeRange tys, FlatSymbolRefAttr callee, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, LLVMFunctionType calleeType, FlatSymbolRefAttr callee, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, LLVMFunctionType calleeType, FlatSymbolRefAttr callee, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, LLVMFunctionType calleeType, FlatSymbolRefAttr callee, ValueRange ops, Block*normal, ValueRange normalOps, Block*unwind, ValueRange unwindOps);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::CConvAttr CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::CConvAttr CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::CConvAttr CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::CConvAttr CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::CConvAttr CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::CConvAttr CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::cconv::CConv CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::cconv::CConv CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::cconv::CConv CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::cconv::CConv CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::cconv::CConv CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::TypeAttr var_callee_type, /*optional*/::mlir::FlatSymbolRefAttr callee, ::mlir::ValueRange callee_operands, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, ::mlir::ValueRange normalDestOperands, ::mlir::ValueRange unwindDestOperands, /*optional*/::mlir::DenseI32ArrayAttr branch_weights, ::mlir::LLVM::cconv::CConv CConv, ::llvm::ArrayRef<::mlir::ValueRange> op_bundle_operands, /*optional*/::mlir::ArrayAttr op_bundle_tags, ::mlir::Block *normalDest, ::mlir::Block *unwindDest);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InvokeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InvokeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::SuccessorOperands getSuccessorOperands(unsigned index);
  ::mlir::CallInterfaceCallable getCallableForCallee();
  void setCalleeFromCallable(::mlir::CallInterfaceCallable callee);
  ::mlir::Operation::operand_range getArgOperands();
  ::mlir::MutableOperandRange getArgOperandsMutable();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Returns the callee function type.
  LLVMFunctionType getCalleeFunctionType();
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::InvokeOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LLVMFuncOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LLVMFuncOpGenericAdaptorBase {
public:
  struct Properties {
    using CConvTy = ::mlir::LLVM::CConvAttr;
    CConvTy CConv;

    auto getCConv() const {
      auto &propStorage = this->CConv;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::CConvAttr>(propStorage);
    }
    void setCConv(const ::mlir::LLVM::CConvAttr &propValue) {
      this->CConv = propValue;
    }
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using always_inlineTy = ::mlir::UnitAttr;
    always_inlineTy always_inline;

    auto getAlwaysInline() const {
      auto &propStorage = this->always_inline;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAlwaysInline(const ::mlir::UnitAttr &propValue) {
      this->always_inline = propValue;
    }
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using arm_in_zaTy = ::mlir::UnitAttr;
    arm_in_zaTy arm_in_za;

    auto getArmInZa() const {
      auto &propStorage = this->arm_in_za;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmInZa(const ::mlir::UnitAttr &propValue) {
      this->arm_in_za = propValue;
    }
    using arm_inout_zaTy = ::mlir::UnitAttr;
    arm_inout_zaTy arm_inout_za;

    auto getArmInoutZa() const {
      auto &propStorage = this->arm_inout_za;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmInoutZa(const ::mlir::UnitAttr &propValue) {
      this->arm_inout_za = propValue;
    }
    using arm_locally_streamingTy = ::mlir::UnitAttr;
    arm_locally_streamingTy arm_locally_streaming;

    auto getArmLocallyStreaming() const {
      auto &propStorage = this->arm_locally_streaming;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmLocallyStreaming(const ::mlir::UnitAttr &propValue) {
      this->arm_locally_streaming = propValue;
    }
    using arm_new_zaTy = ::mlir::UnitAttr;
    arm_new_zaTy arm_new_za;

    auto getArmNewZa() const {
      auto &propStorage = this->arm_new_za;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmNewZa(const ::mlir::UnitAttr &propValue) {
      this->arm_new_za = propValue;
    }
    using arm_out_zaTy = ::mlir::UnitAttr;
    arm_out_zaTy arm_out_za;

    auto getArmOutZa() const {
      auto &propStorage = this->arm_out_za;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmOutZa(const ::mlir::UnitAttr &propValue) {
      this->arm_out_za = propValue;
    }
    using arm_preserves_zaTy = ::mlir::UnitAttr;
    arm_preserves_zaTy arm_preserves_za;

    auto getArmPreservesZa() const {
      auto &propStorage = this->arm_preserves_za;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmPreservesZa(const ::mlir::UnitAttr &propValue) {
      this->arm_preserves_za = propValue;
    }
    using arm_streamingTy = ::mlir::UnitAttr;
    arm_streamingTy arm_streaming;

    auto getArmStreaming() const {
      auto &propStorage = this->arm_streaming;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmStreaming(const ::mlir::UnitAttr &propValue) {
      this->arm_streaming = propValue;
    }
    using arm_streaming_compatibleTy = ::mlir::UnitAttr;
    arm_streaming_compatibleTy arm_streaming_compatible;

    auto getArmStreamingCompatible() const {
      auto &propStorage = this->arm_streaming_compatible;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setArmStreamingCompatible(const ::mlir::UnitAttr &propValue) {
      this->arm_streaming_compatible = propValue;
    }
    using comdatTy = ::mlir::SymbolRefAttr;
    comdatTy comdat;

    auto getComdat() const {
      auto &propStorage = this->comdat;
      return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(propStorage);
    }
    void setComdat(const ::mlir::SymbolRefAttr &propValue) {
      this->comdat = propValue;
    }
    using convergentTy = ::mlir::UnitAttr;
    convergentTy convergent;

    auto getConvergent() const {
      auto &propStorage = this->convergent;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setConvergent(const ::mlir::UnitAttr &propValue) {
      this->convergent = propValue;
    }
    using denormal_fp_mathTy = ::mlir::StringAttr;
    denormal_fp_mathTy denormal_fp_math;

    auto getDenormalFpMath() const {
      auto &propStorage = this->denormal_fp_math;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDenormalFpMath(const ::mlir::StringAttr &propValue) {
      this->denormal_fp_math = propValue;
    }
    using denormal_fp_math_f32Ty = ::mlir::StringAttr;
    denormal_fp_math_f32Ty denormal_fp_math_f32;

    auto getDenormalFpMathF32() const {
      auto &propStorage = this->denormal_fp_math_f32;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setDenormalFpMathF32(const ::mlir::StringAttr &propValue) {
      this->denormal_fp_math_f32 = propValue;
    }
    using dso_localTy = ::mlir::UnitAttr;
    dso_localTy dso_local;

    auto getDsoLocal() const {
      auto &propStorage = this->dso_local;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setDsoLocal(const ::mlir::UnitAttr &propValue) {
      this->dso_local = propValue;
    }
    using fp_contractTy = ::mlir::StringAttr;
    fp_contractTy fp_contract;

    auto getFpContract() const {
      auto &propStorage = this->fp_contract;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setFpContract(const ::mlir::StringAttr &propValue) {
      this->fp_contract = propValue;
    }
    using frame_pointerTy = ::mlir::LLVM::FramePointerKindAttr;
    frame_pointerTy frame_pointer;

    auto getFramePointer() const {
      auto &propStorage = this->frame_pointer;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::FramePointerKindAttr>(propStorage);
    }
    void setFramePointer(const ::mlir::LLVM::FramePointerKindAttr &propValue) {
      this->frame_pointer = propValue;
    }
    using function_entry_countTy = ::mlir::IntegerAttr;
    function_entry_countTy function_entry_count;

    auto getFunctionEntryCount() const {
      auto &propStorage = this->function_entry_count;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setFunctionEntryCount(const ::mlir::IntegerAttr &propValue) {
      this->function_entry_count = propValue;
    }
    using function_typeTy = ::mlir::TypeAttr;
    function_typeTy function_type;

    auto getFunctionType() const {
      auto &propStorage = this->function_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setFunctionType(const ::mlir::TypeAttr &propValue) {
      this->function_type = propValue;
    }
    using garbageCollectorTy = ::mlir::StringAttr;
    garbageCollectorTy garbageCollector;

    auto getGarbageCollector() const {
      auto &propStorage = this->garbageCollector;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setGarbageCollector(const ::mlir::StringAttr &propValue) {
      this->garbageCollector = propValue;
    }
    using inline_hintTy = ::mlir::UnitAttr;
    inline_hintTy inline_hint;

    auto getInlineHint() const {
      auto &propStorage = this->inline_hint;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInlineHint(const ::mlir::UnitAttr &propValue) {
      this->inline_hint = propValue;
    }
    using instrument_function_entryTy = ::mlir::StringAttr;
    instrument_function_entryTy instrument_function_entry;

    auto getInstrumentFunctionEntry() const {
      auto &propStorage = this->instrument_function_entry;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setInstrumentFunctionEntry(const ::mlir::StringAttr &propValue) {
      this->instrument_function_entry = propValue;
    }
    using instrument_function_exitTy = ::mlir::StringAttr;
    instrument_function_exitTy instrument_function_exit;

    auto getInstrumentFunctionExit() const {
      auto &propStorage = this->instrument_function_exit;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setInstrumentFunctionExit(const ::mlir::StringAttr &propValue) {
      this->instrument_function_exit = propValue;
    }
    using intel_reqd_sub_group_sizeTy = ::mlir::IntegerAttr;
    intel_reqd_sub_group_sizeTy intel_reqd_sub_group_size;

    auto getIntelReqdSubGroupSize() const {
      auto &propStorage = this->intel_reqd_sub_group_size;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIntelReqdSubGroupSize(const ::mlir::IntegerAttr &propValue) {
      this->intel_reqd_sub_group_size = propValue;
    }
    using linkageTy = ::mlir::LLVM::LinkageAttr;
    linkageTy linkage;

    auto getLinkage() const {
      auto &propStorage = this->linkage;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::LinkageAttr>(propStorage);
    }
    void setLinkage(const ::mlir::LLVM::LinkageAttr &propValue) {
      this->linkage = propValue;
    }
    using memory_effectsTy = ::mlir::LLVM::MemoryEffectsAttr;
    memory_effectsTy memory_effects;

    auto getMemoryEffects() const {
      auto &propStorage = this->memory_effects;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::MemoryEffectsAttr>(propStorage);
    }
    void setMemoryEffects(const ::mlir::LLVM::MemoryEffectsAttr &propValue) {
      this->memory_effects = propValue;
    }
    using no_infs_fp_mathTy = ::mlir::BoolAttr;
    no_infs_fp_mathTy no_infs_fp_math;

    auto getNoInfsFpMath() const {
      auto &propStorage = this->no_infs_fp_math;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNoInfsFpMath(const ::mlir::BoolAttr &propValue) {
      this->no_infs_fp_math = propValue;
    }
    using no_inlineTy = ::mlir::UnitAttr;
    no_inlineTy no_inline;

    auto getNoInline() const {
      auto &propStorage = this->no_inline;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNoInline(const ::mlir::UnitAttr &propValue) {
      this->no_inline = propValue;
    }
    using no_nans_fp_mathTy = ::mlir::BoolAttr;
    no_nans_fp_mathTy no_nans_fp_math;

    auto getNoNansFpMath() const {
      auto &propStorage = this->no_nans_fp_math;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNoNansFpMath(const ::mlir::BoolAttr &propValue) {
      this->no_nans_fp_math = propValue;
    }
    using no_signed_zeros_fp_mathTy = ::mlir::BoolAttr;
    no_signed_zeros_fp_mathTy no_signed_zeros_fp_math;

    auto getNoSignedZerosFpMath() const {
      auto &propStorage = this->no_signed_zeros_fp_math;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNoSignedZerosFpMath(const ::mlir::BoolAttr &propValue) {
      this->no_signed_zeros_fp_math = propValue;
    }
    using no_unwindTy = ::mlir::UnitAttr;
    no_unwindTy no_unwind;

    auto getNoUnwind() const {
      auto &propStorage = this->no_unwind;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNoUnwind(const ::mlir::UnitAttr &propValue) {
      this->no_unwind = propValue;
    }
    using optimize_noneTy = ::mlir::UnitAttr;
    optimize_noneTy optimize_none;

    auto getOptimizeNone() const {
      auto &propStorage = this->optimize_none;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setOptimizeNone(const ::mlir::UnitAttr &propValue) {
      this->optimize_none = propValue;
    }
    using passthroughTy = ::mlir::ArrayAttr;
    passthroughTy passthrough;

    auto getPassthrough() const {
      auto &propStorage = this->passthrough;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setPassthrough(const ::mlir::ArrayAttr &propValue) {
      this->passthrough = propValue;
    }
    using personalityTy = ::mlir::FlatSymbolRefAttr;
    personalityTy personality;

    auto getPersonality() const {
      auto &propStorage = this->personality;
      return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setPersonality(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->personality = propValue;
    }
    using prefer_vector_widthTy = ::mlir::StringAttr;
    prefer_vector_widthTy prefer_vector_width;

    auto getPreferVectorWidth() const {
      auto &propStorage = this->prefer_vector_width;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setPreferVectorWidth(const ::mlir::StringAttr &propValue) {
      this->prefer_vector_width = propValue;
    }
    using reciprocal_estimatesTy = ::mlir::StringAttr;
    reciprocal_estimatesTy reciprocal_estimates;

    auto getReciprocalEstimates() const {
      auto &propStorage = this->reciprocal_estimates;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setReciprocalEstimates(const ::mlir::StringAttr &propValue) {
      this->reciprocal_estimates = propValue;
    }
    using reqd_work_group_sizeTy = ::mlir::DenseI32ArrayAttr;
    reqd_work_group_sizeTy reqd_work_group_size;

    auto getReqdWorkGroupSize() const {
      auto &propStorage = this->reqd_work_group_size;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setReqdWorkGroupSize(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->reqd_work_group_size = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    using sectionTy = ::mlir::StringAttr;
    sectionTy section;

    auto getSection() const {
      auto &propStorage = this->section;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSection(const ::mlir::StringAttr &propValue) {
      this->section = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using sym_visibilityTy = ::mlir::StringAttr;
    sym_visibilityTy sym_visibility;

    auto getSymVisibility() const {
      auto &propStorage = this->sym_visibility;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSymVisibility(const ::mlir::StringAttr &propValue) {
      this->sym_visibility = propValue;
    }
    using target_cpuTy = ::mlir::StringAttr;
    target_cpuTy target_cpu;

    auto getTargetCpu() const {
      auto &propStorage = this->target_cpu;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setTargetCpu(const ::mlir::StringAttr &propValue) {
      this->target_cpu = propValue;
    }
    using target_featuresTy = ::mlir::LLVM::TargetFeaturesAttr;
    target_featuresTy target_features;

    auto getTargetFeatures() const {
      auto &propStorage = this->target_features;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::TargetFeaturesAttr>(propStorage);
    }
    void setTargetFeatures(const ::mlir::LLVM::TargetFeaturesAttr &propValue) {
      this->target_features = propValue;
    }
    using tune_cpuTy = ::mlir::StringAttr;
    tune_cpuTy tune_cpu;

    auto getTuneCpu() const {
      auto &propStorage = this->tune_cpu;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setTuneCpu(const ::mlir::StringAttr &propValue) {
      this->tune_cpu = propValue;
    }
    using unnamed_addrTy = ::mlir::LLVM::UnnamedAddrAttr;
    unnamed_addrTy unnamed_addr;

    auto getUnnamedAddr() const {
      auto &propStorage = this->unnamed_addr;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(propStorage);
    }
    void setUnnamedAddr(const ::mlir::LLVM::UnnamedAddrAttr &propValue) {
      this->unnamed_addr = propValue;
    }
    using uwtable_kindTy = ::mlir::LLVM::UWTableKindAttr;
    uwtable_kindTy uwtable_kind;

    auto getUwtableKind() const {
      auto &propStorage = this->uwtable_kind;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::UWTableKindAttr>(propStorage);
    }
    void setUwtableKind(const ::mlir::LLVM::UWTableKindAttr &propValue) {
      this->uwtable_kind = propValue;
    }
    using vec_type_hintTy = ::mlir::LLVM::VecTypeHintAttr;
    vec_type_hintTy vec_type_hint;

    auto getVecTypeHint() const {
      auto &propStorage = this->vec_type_hint;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::VecTypeHintAttr>(propStorage);
    }
    void setVecTypeHint(const ::mlir::LLVM::VecTypeHintAttr &propValue) {
      this->vec_type_hint = propValue;
    }
    using visibility_Ty = ::mlir::LLVM::VisibilityAttr;
    visibility_Ty visibility_;

    auto getVisibility_() const {
      auto &propStorage = this->visibility_;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(propStorage);
    }
    void setVisibility_(const ::mlir::LLVM::VisibilityAttr &propValue) {
      this->visibility_ = propValue;
    }
    using vscale_rangeTy = ::mlir::LLVM::VScaleRangeAttr;
    vscale_rangeTy vscale_range;

    auto getVscaleRange() const {
      auto &propStorage = this->vscale_range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::VScaleRangeAttr>(propStorage);
    }
    void setVscaleRange(const ::mlir::LLVM::VScaleRangeAttr &propValue) {
      this->vscale_range = propValue;
    }
    using will_returnTy = ::mlir::UnitAttr;
    will_returnTy will_return;

    auto getWillReturn() const {
      auto &propStorage = this->will_return;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setWillReturn(const ::mlir::UnitAttr &propValue) {
      this->will_return = propValue;
    }
    using work_group_size_hintTy = ::mlir::DenseI32ArrayAttr;
    work_group_size_hintTy work_group_size_hint;

    auto getWorkGroupSizeHint() const {
      auto &propStorage = this->work_group_size_hint;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setWorkGroupSizeHint(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->work_group_size_hint = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.CConv == this->CConv &&
        rhs.alignment == this->alignment &&
        rhs.always_inline == this->always_inline &&
        rhs.arg_attrs == this->arg_attrs &&
        rhs.arm_in_za == this->arm_in_za &&
        rhs.arm_inout_za == this->arm_inout_za &&
        rhs.arm_locally_streaming == this->arm_locally_streaming &&
        rhs.arm_new_za == this->arm_new_za &&
        rhs.arm_out_za == this->arm_out_za &&
        rhs.arm_preserves_za == this->arm_preserves_za &&
        rhs.arm_streaming == this->arm_streaming &&
        rhs.arm_streaming_compatible == this->arm_streaming_compatible &&
        rhs.comdat == this->comdat &&
        rhs.convergent == this->convergent &&
        rhs.denormal_fp_math == this->denormal_fp_math &&
        rhs.denormal_fp_math_f32 == this->denormal_fp_math_f32 &&
        rhs.dso_local == this->dso_local &&
        rhs.fp_contract == this->fp_contract &&
        rhs.frame_pointer == this->frame_pointer &&
        rhs.function_entry_count == this->function_entry_count &&
        rhs.function_type == this->function_type &&
        rhs.garbageCollector == this->garbageCollector &&
        rhs.inline_hint == this->inline_hint &&
        rhs.instrument_function_entry == this->instrument_function_entry &&
        rhs.instrument_function_exit == this->instrument_function_exit &&
        rhs.intel_reqd_sub_group_size == this->intel_reqd_sub_group_size &&
        rhs.linkage == this->linkage &&
        rhs.memory_effects == this->memory_effects &&
        rhs.no_infs_fp_math == this->no_infs_fp_math &&
        rhs.no_inline == this->no_inline &&
        rhs.no_nans_fp_math == this->no_nans_fp_math &&
        rhs.no_signed_zeros_fp_math == this->no_signed_zeros_fp_math &&
        rhs.no_unwind == this->no_unwind &&
        rhs.optimize_none == this->optimize_none &&
        rhs.passthrough == this->passthrough &&
        rhs.personality == this->personality &&
        rhs.prefer_vector_width == this->prefer_vector_width &&
        rhs.reciprocal_estimates == this->reciprocal_estimates &&
        rhs.reqd_work_group_size == this->reqd_work_group_size &&
        rhs.res_attrs == this->res_attrs &&
        rhs.section == this->section &&
        rhs.sym_name == this->sym_name &&
        rhs.sym_visibility == this->sym_visibility &&
        rhs.target_cpu == this->target_cpu &&
        rhs.target_features == this->target_features &&
        rhs.tune_cpu == this->tune_cpu &&
        rhs.unnamed_addr == this->unnamed_addr &&
        rhs.uwtable_kind == this->uwtable_kind &&
        rhs.vec_type_hint == this->vec_type_hint &&
        rhs.visibility_ == this->visibility_ &&
        rhs.vscale_range == this->vscale_range &&
        rhs.will_return == this->will_return &&
        rhs.work_group_size_hint == this->work_group_size_hint &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LLVMFuncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.func", odsAttrs.getContext());
  }

  LLVMFuncOpGenericAdaptorBase(LLVMFuncOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::StringAttr getSymVisibilityAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().sym_visibility);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSymVisibility();
  ::mlir::TypeAttr getFunctionTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().function_type);
    return attr;
  }

  ::mlir::LLVM::LLVMFunctionType getFunctionType();
  ::mlir::LLVM::LinkageAttr getLinkageAttr();
  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr();
  bool getDsoLocal();
  ::mlir::LLVM::CConvAttr getCConvAttr();
  ::mlir::LLVM::cconv::CConv getCConv();
  ::mlir::SymbolRefAttr getComdatAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().comdat);
    return attr;
  }

  ::std::optional< ::mlir::SymbolRefAttr > getComdat();
  ::mlir::UnitAttr getConvergentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().convergent);
    return attr;
  }

  ::std::optional<bool> getConvergent();
  ::mlir::FlatSymbolRefAttr getPersonalityAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().personality);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getPersonality();
  ::mlir::StringAttr getGarbageCollectorAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().garbageCollector);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getGarbageCollector();
  ::mlir::ArrayAttr getPassthroughAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().passthrough);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getPassthrough();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::IntegerAttr getFunctionEntryCountAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().function_entry_count);
    return attr;
  }

  ::std::optional<uint64_t> getFunctionEntryCount();
  ::mlir::LLVM::MemoryEffectsAttr getMemoryEffectsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::MemoryEffectsAttr>(getProperties().memory_effects);
    return attr;
  }

  ::std::optional<::mlir::LLVM::MemoryEffectsAttr> getMemoryEffects();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr();
  ::mlir::LLVM::Visibility getVisibility_();
  ::mlir::UnitAttr getArmStreamingAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_streaming);
    return attr;
  }

  ::std::optional<bool> getArmStreaming();
  ::mlir::UnitAttr getArmLocallyStreamingAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_locally_streaming);
    return attr;
  }

  ::std::optional<bool> getArmLocallyStreaming();
  ::mlir::UnitAttr getArmStreamingCompatibleAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_streaming_compatible);
    return attr;
  }

  ::std::optional<bool> getArmStreamingCompatible();
  ::mlir::UnitAttr getArmNewZaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_new_za);
    return attr;
  }

  ::std::optional<bool> getArmNewZa();
  ::mlir::UnitAttr getArmInZaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_in_za);
    return attr;
  }

  ::std::optional<bool> getArmInZa();
  ::mlir::UnitAttr getArmOutZaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_out_za);
    return attr;
  }

  ::std::optional<bool> getArmOutZa();
  ::mlir::UnitAttr getArmInoutZaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_inout_za);
    return attr;
  }

  ::std::optional<bool> getArmInoutZa();
  ::mlir::UnitAttr getArmPreservesZaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_preserves_za);
    return attr;
  }

  ::std::optional<bool> getArmPreservesZa();
  ::mlir::StringAttr getSectionAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().section);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSection();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
    return attr;
  }

  ::std::optional<::mlir::LLVM::UnnamedAddr> getUnnamedAddr();
  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::LLVM::VScaleRangeAttr getVscaleRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::VScaleRangeAttr>(getProperties().vscale_range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::VScaleRangeAttr> getVscaleRange();
  ::mlir::LLVM::FramePointerKindAttr getFramePointerAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FramePointerKindAttr>(getProperties().frame_pointer);
    return attr;
  }

  ::std::optional<::mlir::LLVM::FramePointerKindAttr> getFramePointer();
  ::mlir::StringAttr getTargetCpuAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().target_cpu);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getTargetCpu();
  ::mlir::StringAttr getTuneCpuAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().tune_cpu);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getTuneCpu();
  ::mlir::StringAttr getReciprocalEstimatesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().reciprocal_estimates);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getReciprocalEstimates();
  ::mlir::StringAttr getPreferVectorWidthAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().prefer_vector_width);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getPreferVectorWidth();
  ::mlir::LLVM::TargetFeaturesAttr getTargetFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::TargetFeaturesAttr>(getProperties().target_features);
    return attr;
  }

  ::std::optional<::mlir::LLVM::TargetFeaturesAttr> getTargetFeatures();
  ::mlir::BoolAttr getNoInfsFpMathAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().no_infs_fp_math);
    return attr;
  }

  ::std::optional< bool > getNoInfsFpMath();
  ::mlir::BoolAttr getNoNansFpMathAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().no_nans_fp_math);
    return attr;
  }

  ::std::optional< bool > getNoNansFpMath();
  ::mlir::BoolAttr getNoSignedZerosFpMathAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().no_signed_zeros_fp_math);
    return attr;
  }

  ::std::optional< bool > getNoSignedZerosFpMath();
  ::mlir::StringAttr getDenormalFpMathAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().denormal_fp_math);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getDenormalFpMath();
  ::mlir::StringAttr getDenormalFpMathF32Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().denormal_fp_math_f32);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getDenormalFpMathF32();
  ::mlir::StringAttr getFpContractAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().fp_contract);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getFpContract();
  ::mlir::StringAttr getInstrumentFunctionEntryAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().instrument_function_entry);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getInstrumentFunctionEntry();
  ::mlir::StringAttr getInstrumentFunctionExitAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().instrument_function_exit);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getInstrumentFunctionExit();
  ::mlir::UnitAttr getNoInlineAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_inline);
    return attr;
  }

  ::std::optional<bool> getNoInline();
  ::mlir::UnitAttr getAlwaysInlineAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().always_inline);
    return attr;
  }

  ::std::optional<bool> getAlwaysInline();
  ::mlir::UnitAttr getInlineHintAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().inline_hint);
    return attr;
  }

  ::std::optional<bool> getInlineHint();
  ::mlir::UnitAttr getNoUnwindAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_unwind);
    return attr;
  }

  ::std::optional<bool> getNoUnwind();
  ::mlir::UnitAttr getWillReturnAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().will_return);
    return attr;
  }

  ::std::optional<bool> getWillReturn();
  ::mlir::UnitAttr getOptimizeNoneAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().optimize_none);
    return attr;
  }

  ::std::optional<bool> getOptimizeNone();
  ::mlir::LLVM::VecTypeHintAttr getVecTypeHintAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::VecTypeHintAttr>(getProperties().vec_type_hint);
    return attr;
  }

  ::std::optional<::mlir::LLVM::VecTypeHintAttr> getVecTypeHint();
  ::mlir::DenseI32ArrayAttr getWorkGroupSizeHintAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().work_group_size_hint);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWorkGroupSizeHint();
  ::mlir::DenseI32ArrayAttr getReqdWorkGroupSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().reqd_work_group_size);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getReqdWorkGroupSize();
  ::mlir::IntegerAttr getIntelReqdSubGroupSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().intel_reqd_sub_group_size);
    return attr;
  }

  ::std::optional<uint32_t> getIntelReqdSubGroupSize();
  ::mlir::LLVM::UWTableKindAttr getUwtableKindAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::UWTableKindAttr>(getProperties().uwtable_kind);
    return attr;
  }

  ::std::optional<::mlir::LLVM::UWTableKindAttr> getUwtableKind();
  ::mlir::Region &getBody() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class LLVMFuncOpGenericAdaptor : public detail::LLVMFuncOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LLVMFuncOpGenericAdaptorBase;
public:
  LLVMFuncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LLVMFuncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LLVMFuncOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LLVMFuncOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LLVMFuncOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LLVMFuncOpGenericAdaptor(RangeT values, const LLVMFuncOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LLVMFuncOp, typename = std::enable_if_t<std::is_same_v<LateInst, LLVMFuncOp>>>
  LLVMFuncOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LLVMFuncOpAdaptor : public LLVMFuncOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LLVMFuncOpGenericAdaptor::LLVMFuncOpGenericAdaptor;
  LLVMFuncOpAdaptor(LLVMFuncOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LLVMFuncOp : public ::mlir::Op<LLVMFuncOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::AffineScope, ::mlir::OpTrait::AutomaticAllocationScope, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait, ::mlir::ArgAndResultAttrsOpInterface::Trait, ::mlir::CallableOpInterface::Trait, ::mlir::FunctionOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LLVMFuncOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LLVMFuncOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("CConv"), ::llvm::StringRef("alignment"), ::llvm::StringRef("always_inline"), ::llvm::StringRef("arg_attrs"), ::llvm::StringRef("arm_in_za"), ::llvm::StringRef("arm_inout_za"), ::llvm::StringRef("arm_locally_streaming"), ::llvm::StringRef("arm_new_za"), ::llvm::StringRef("arm_out_za"), ::llvm::StringRef("arm_preserves_za"), ::llvm::StringRef("arm_streaming"), ::llvm::StringRef("arm_streaming_compatible"), ::llvm::StringRef("comdat"), ::llvm::StringRef("convergent"), ::llvm::StringRef("denormal_fp_math"), ::llvm::StringRef("denormal_fp_math_f32"), ::llvm::StringRef("dso_local"), ::llvm::StringRef("fp_contract"), ::llvm::StringRef("frame_pointer"), ::llvm::StringRef("function_entry_count"), ::llvm::StringRef("function_type"), ::llvm::StringRef("garbageCollector"), ::llvm::StringRef("inline_hint"), ::llvm::StringRef("instrument_function_entry"), ::llvm::StringRef("instrument_function_exit"), ::llvm::StringRef("intel_reqd_sub_group_size"), ::llvm::StringRef("linkage"), ::llvm::StringRef("memory_effects"), ::llvm::StringRef("no_infs_fp_math"), ::llvm::StringRef("no_inline"), ::llvm::StringRef("no_nans_fp_math"), ::llvm::StringRef("no_signed_zeros_fp_math"), ::llvm::StringRef("no_unwind"), ::llvm::StringRef("optimize_none"), ::llvm::StringRef("passthrough"), ::llvm::StringRef("personality"), ::llvm::StringRef("prefer_vector_width"), ::llvm::StringRef("reciprocal_estimates"), ::llvm::StringRef("reqd_work_group_size"), ::llvm::StringRef("res_attrs"), ::llvm::StringRef("section"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("sym_visibility"), ::llvm::StringRef("target_cpu"), ::llvm::StringRef("target_features"), ::llvm::StringRef("tune_cpu"), ::llvm::StringRef("unnamed_addr"), ::llvm::StringRef("uwtable_kind"), ::llvm::StringRef("vec_type_hint"), ::llvm::StringRef("visibility_"), ::llvm::StringRef("vscale_range"), ::llvm::StringRef("will_return"), ::llvm::StringRef("work_group_size_hint")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCConvAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCConvAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAlwaysInlineAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAlwaysInlineAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getArmInZaAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getArmInZaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getArmInoutZaAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getArmInoutZaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getArmLocallyStreamingAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getArmLocallyStreamingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getArmNewZaAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getArmNewZaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getArmOutZaAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getArmOutZaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getArmPreservesZaAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getArmPreservesZaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getArmStreamingAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getArmStreamingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getArmStreamingCompatibleAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getArmStreamingCompatibleAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getComdatAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getComdatAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getConvergentAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getConvergentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getDenormalFpMathAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getDenormalFpMathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getDenormalFpMathF32AttrName() {
    return getAttributeNameForIndex(15);
  }

  static ::mlir::StringAttr getDenormalFpMathF32AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 15);
  }

  ::mlir::StringAttr getDsoLocalAttrName() {
    return getAttributeNameForIndex(16);
  }

  static ::mlir::StringAttr getDsoLocalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 16);
  }

  ::mlir::StringAttr getFpContractAttrName() {
    return getAttributeNameForIndex(17);
  }

  static ::mlir::StringAttr getFpContractAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 17);
  }

  ::mlir::StringAttr getFramePointerAttrName() {
    return getAttributeNameForIndex(18);
  }

  static ::mlir::StringAttr getFramePointerAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 18);
  }

  ::mlir::StringAttr getFunctionEntryCountAttrName() {
    return getAttributeNameForIndex(19);
  }

  static ::mlir::StringAttr getFunctionEntryCountAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 19);
  }

  ::mlir::StringAttr getFunctionTypeAttrName() {
    return getAttributeNameForIndex(20);
  }

  static ::mlir::StringAttr getFunctionTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 20);
  }

  ::mlir::StringAttr getGarbageCollectorAttrName() {
    return getAttributeNameForIndex(21);
  }

  static ::mlir::StringAttr getGarbageCollectorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 21);
  }

  ::mlir::StringAttr getInlineHintAttrName() {
    return getAttributeNameForIndex(22);
  }

  static ::mlir::StringAttr getInlineHintAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 22);
  }

  ::mlir::StringAttr getInstrumentFunctionEntryAttrName() {
    return getAttributeNameForIndex(23);
  }

  static ::mlir::StringAttr getInstrumentFunctionEntryAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 23);
  }

  ::mlir::StringAttr getInstrumentFunctionExitAttrName() {
    return getAttributeNameForIndex(24);
  }

  static ::mlir::StringAttr getInstrumentFunctionExitAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 24);
  }

  ::mlir::StringAttr getIntelReqdSubGroupSizeAttrName() {
    return getAttributeNameForIndex(25);
  }

  static ::mlir::StringAttr getIntelReqdSubGroupSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 25);
  }

  ::mlir::StringAttr getLinkageAttrName() {
    return getAttributeNameForIndex(26);
  }

  static ::mlir::StringAttr getLinkageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 26);
  }

  ::mlir::StringAttr getMemoryEffectsAttrName() {
    return getAttributeNameForIndex(27);
  }

  static ::mlir::StringAttr getMemoryEffectsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 27);
  }

  ::mlir::StringAttr getNoInfsFpMathAttrName() {
    return getAttributeNameForIndex(28);
  }

  static ::mlir::StringAttr getNoInfsFpMathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 28);
  }

  ::mlir::StringAttr getNoInlineAttrName() {
    return getAttributeNameForIndex(29);
  }

  static ::mlir::StringAttr getNoInlineAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 29);
  }

  ::mlir::StringAttr getNoNansFpMathAttrName() {
    return getAttributeNameForIndex(30);
  }

  static ::mlir::StringAttr getNoNansFpMathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 30);
  }

  ::mlir::StringAttr getNoSignedZerosFpMathAttrName() {
    return getAttributeNameForIndex(31);
  }

  static ::mlir::StringAttr getNoSignedZerosFpMathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 31);
  }

  ::mlir::StringAttr getNoUnwindAttrName() {
    return getAttributeNameForIndex(32);
  }

  static ::mlir::StringAttr getNoUnwindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 32);
  }

  ::mlir::StringAttr getOptimizeNoneAttrName() {
    return getAttributeNameForIndex(33);
  }

  static ::mlir::StringAttr getOptimizeNoneAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 33);
  }

  ::mlir::StringAttr getPassthroughAttrName() {
    return getAttributeNameForIndex(34);
  }

  static ::mlir::StringAttr getPassthroughAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 34);
  }

  ::mlir::StringAttr getPersonalityAttrName() {
    return getAttributeNameForIndex(35);
  }

  static ::mlir::StringAttr getPersonalityAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 35);
  }

  ::mlir::StringAttr getPreferVectorWidthAttrName() {
    return getAttributeNameForIndex(36);
  }

  static ::mlir::StringAttr getPreferVectorWidthAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 36);
  }

  ::mlir::StringAttr getReciprocalEstimatesAttrName() {
    return getAttributeNameForIndex(37);
  }

  static ::mlir::StringAttr getReciprocalEstimatesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 37);
  }

  ::mlir::StringAttr getReqdWorkGroupSizeAttrName() {
    return getAttributeNameForIndex(38);
  }

  static ::mlir::StringAttr getReqdWorkGroupSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 38);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(39);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 39);
  }

  ::mlir::StringAttr getSectionAttrName() {
    return getAttributeNameForIndex(40);
  }

  static ::mlir::StringAttr getSectionAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 40);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(41);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 41);
  }

  ::mlir::StringAttr getSymVisibilityAttrName() {
    return getAttributeNameForIndex(42);
  }

  static ::mlir::StringAttr getSymVisibilityAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 42);
  }

  ::mlir::StringAttr getTargetCpuAttrName() {
    return getAttributeNameForIndex(43);
  }

  static ::mlir::StringAttr getTargetCpuAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 43);
  }

  ::mlir::StringAttr getTargetFeaturesAttrName() {
    return getAttributeNameForIndex(44);
  }

  static ::mlir::StringAttr getTargetFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 44);
  }

  ::mlir::StringAttr getTuneCpuAttrName() {
    return getAttributeNameForIndex(45);
  }

  static ::mlir::StringAttr getTuneCpuAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 45);
  }

  ::mlir::StringAttr getUnnamedAddrAttrName() {
    return getAttributeNameForIndex(46);
  }

  static ::mlir::StringAttr getUnnamedAddrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 46);
  }

  ::mlir::StringAttr getUwtableKindAttrName() {
    return getAttributeNameForIndex(47);
  }

  static ::mlir::StringAttr getUwtableKindAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 47);
  }

  ::mlir::StringAttr getVecTypeHintAttrName() {
    return getAttributeNameForIndex(48);
  }

  static ::mlir::StringAttr getVecTypeHintAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 48);
  }

  ::mlir::StringAttr getVisibility_AttrName() {
    return getAttributeNameForIndex(49);
  }

  static ::mlir::StringAttr getVisibility_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 49);
  }

  ::mlir::StringAttr getVscaleRangeAttrName() {
    return getAttributeNameForIndex(50);
  }

  static ::mlir::StringAttr getVscaleRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 50);
  }

  ::mlir::StringAttr getWillReturnAttrName() {
    return getAttributeNameForIndex(51);
  }

  static ::mlir::StringAttr getWillReturnAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 51);
  }

  ::mlir::StringAttr getWorkGroupSizeHintAttrName() {
    return getAttributeNameForIndex(52);
  }

  static ::mlir::StringAttr getWorkGroupSizeHintAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 52);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.func");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getBody() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::StringAttr getSymVisibilityAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().sym_visibility);
  }

  ::std::optional< ::llvm::StringRef > getSymVisibility();
  ::mlir::TypeAttr getFunctionTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().function_type);
  }

  ::mlir::LLVM::LLVMFunctionType getFunctionType();
  ::mlir::LLVM::LinkageAttr getLinkageAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::LinkageAttr>(getProperties().linkage);
  }

  ::mlir::LLVM::Linkage getLinkage();
  ::mlir::UnitAttr getDsoLocalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().dso_local);
  }

  bool getDsoLocal();
  ::mlir::LLVM::CConvAttr getCConvAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::CConvAttr>(getProperties().CConv);
  }

  ::mlir::LLVM::cconv::CConv getCConv();
  ::mlir::SymbolRefAttr getComdatAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().comdat);
  }

  ::std::optional< ::mlir::SymbolRefAttr > getComdat();
  ::mlir::UnitAttr getConvergentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().convergent);
  }

  ::std::optional<bool> getConvergent();
  ::mlir::FlatSymbolRefAttr getPersonalityAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().personality);
  }

  ::std::optional< ::llvm::StringRef > getPersonality();
  ::mlir::StringAttr getGarbageCollectorAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().garbageCollector);
  }

  ::std::optional< ::llvm::StringRef > getGarbageCollector();
  ::mlir::ArrayAttr getPassthroughAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().passthrough);
  }

  ::std::optional< ::mlir::ArrayAttr > getPassthrough();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::mlir::IntegerAttr getFunctionEntryCountAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().function_entry_count);
  }

  ::std::optional<uint64_t> getFunctionEntryCount();
  ::mlir::LLVM::MemoryEffectsAttr getMemoryEffectsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::MemoryEffectsAttr>(getProperties().memory_effects);
  }

  ::std::optional<::mlir::LLVM::MemoryEffectsAttr> getMemoryEffects();
  ::mlir::LLVM::VisibilityAttr getVisibility_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::VisibilityAttr>(getProperties().visibility_);
  }

  ::mlir::LLVM::Visibility getVisibility_();
  ::mlir::UnitAttr getArmStreamingAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_streaming);
  }

  ::std::optional<bool> getArmStreaming();
  ::mlir::UnitAttr getArmLocallyStreamingAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_locally_streaming);
  }

  ::std::optional<bool> getArmLocallyStreaming();
  ::mlir::UnitAttr getArmStreamingCompatibleAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_streaming_compatible);
  }

  ::std::optional<bool> getArmStreamingCompatible();
  ::mlir::UnitAttr getArmNewZaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_new_za);
  }

  ::std::optional<bool> getArmNewZa();
  ::mlir::UnitAttr getArmInZaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_in_za);
  }

  ::std::optional<bool> getArmInZa();
  ::mlir::UnitAttr getArmOutZaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_out_za);
  }

  ::std::optional<bool> getArmOutZa();
  ::mlir::UnitAttr getArmInoutZaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_inout_za);
  }

  ::std::optional<bool> getArmInoutZa();
  ::mlir::UnitAttr getArmPreservesZaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().arm_preserves_za);
  }

  ::std::optional<bool> getArmPreservesZa();
  ::mlir::StringAttr getSectionAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().section);
  }

  ::std::optional< ::llvm::StringRef > getSection();
  ::mlir::LLVM::UnnamedAddrAttr getUnnamedAddrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::UnnamedAddrAttr>(getProperties().unnamed_addr);
  }

  ::std::optional<::mlir::LLVM::UnnamedAddr> getUnnamedAddr();
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::LLVM::VScaleRangeAttr getVscaleRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::VScaleRangeAttr>(getProperties().vscale_range);
  }

  ::std::optional<::mlir::LLVM::VScaleRangeAttr> getVscaleRange();
  ::mlir::LLVM::FramePointerKindAttr getFramePointerAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::FramePointerKindAttr>(getProperties().frame_pointer);
  }

  ::std::optional<::mlir::LLVM::FramePointerKindAttr> getFramePointer();
  ::mlir::StringAttr getTargetCpuAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().target_cpu);
  }

  ::std::optional< ::llvm::StringRef > getTargetCpu();
  ::mlir::StringAttr getTuneCpuAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().tune_cpu);
  }

  ::std::optional< ::llvm::StringRef > getTuneCpu();
  ::mlir::StringAttr getReciprocalEstimatesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().reciprocal_estimates);
  }

  ::std::optional< ::llvm::StringRef > getReciprocalEstimates();
  ::mlir::StringAttr getPreferVectorWidthAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().prefer_vector_width);
  }

  ::std::optional< ::llvm::StringRef > getPreferVectorWidth();
  ::mlir::LLVM::TargetFeaturesAttr getTargetFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::TargetFeaturesAttr>(getProperties().target_features);
  }

  ::std::optional<::mlir::LLVM::TargetFeaturesAttr> getTargetFeatures();
  ::mlir::BoolAttr getNoInfsFpMathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().no_infs_fp_math);
  }

  ::std::optional< bool > getNoInfsFpMath();
  ::mlir::BoolAttr getNoNansFpMathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().no_nans_fp_math);
  }

  ::std::optional< bool > getNoNansFpMath();
  ::mlir::BoolAttr getNoSignedZerosFpMathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().no_signed_zeros_fp_math);
  }

  ::std::optional< bool > getNoSignedZerosFpMath();
  ::mlir::StringAttr getDenormalFpMathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().denormal_fp_math);
  }

  ::std::optional< ::llvm::StringRef > getDenormalFpMath();
  ::mlir::StringAttr getDenormalFpMathF32Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().denormal_fp_math_f32);
  }

  ::std::optional< ::llvm::StringRef > getDenormalFpMathF32();
  ::mlir::StringAttr getFpContractAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().fp_contract);
  }

  ::std::optional< ::llvm::StringRef > getFpContract();
  ::mlir::StringAttr getInstrumentFunctionEntryAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().instrument_function_entry);
  }

  ::std::optional< ::llvm::StringRef > getInstrumentFunctionEntry();
  ::mlir::StringAttr getInstrumentFunctionExitAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().instrument_function_exit);
  }

  ::std::optional< ::llvm::StringRef > getInstrumentFunctionExit();
  ::mlir::UnitAttr getNoInlineAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_inline);
  }

  ::std::optional<bool> getNoInline();
  ::mlir::UnitAttr getAlwaysInlineAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().always_inline);
  }

  ::std::optional<bool> getAlwaysInline();
  ::mlir::UnitAttr getInlineHintAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().inline_hint);
  }

  ::std::optional<bool> getInlineHint();
  ::mlir::UnitAttr getNoUnwindAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_unwind);
  }

  ::std::optional<bool> getNoUnwind();
  ::mlir::UnitAttr getWillReturnAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().will_return);
  }

  ::std::optional<bool> getWillReturn();
  ::mlir::UnitAttr getOptimizeNoneAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().optimize_none);
  }

  ::std::optional<bool> getOptimizeNone();
  ::mlir::LLVM::VecTypeHintAttr getVecTypeHintAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::VecTypeHintAttr>(getProperties().vec_type_hint);
  }

  ::std::optional<::mlir::LLVM::VecTypeHintAttr> getVecTypeHint();
  ::mlir::DenseI32ArrayAttr getWorkGroupSizeHintAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().work_group_size_hint);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getWorkGroupSizeHint();
  ::mlir::DenseI32ArrayAttr getReqdWorkGroupSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().reqd_work_group_size);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getReqdWorkGroupSize();
  ::mlir::IntegerAttr getIntelReqdSubGroupSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().intel_reqd_sub_group_size);
  }

  ::std::optional<uint32_t> getIntelReqdSubGroupSize();
  ::mlir::LLVM::UWTableKindAttr getUwtableKindAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::UWTableKindAttr>(getProperties().uwtable_kind);
  }

  ::std::optional<::mlir::LLVM::UWTableKindAttr> getUwtableKind();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setSymVisibilityAttr(::mlir::StringAttr attr) {
    getProperties().sym_visibility = attr;
  }

  void setSymVisibility(::std::optional<::llvm::StringRef> attrValue);
  void setFunctionTypeAttr(::mlir::TypeAttr attr) {
    getProperties().function_type = attr;
  }

  void setFunctionType(::mlir::LLVM::LLVMFunctionType attrValue);
  void setLinkageAttr(::mlir::LLVM::LinkageAttr attr) {
    getProperties().linkage = attr;
  }

  void setLinkage(::mlir::LLVM::Linkage attrValue);
  void setDsoLocalAttr(::mlir::UnitAttr attr) {
    getProperties().dso_local = attr;
  }

  void setDsoLocal(bool attrValue);
  void setCConvAttr(::mlir::LLVM::CConvAttr attr) {
    getProperties().CConv = attr;
  }

  void setCConv(::mlir::LLVM::cconv::CConv attrValue);
  void setComdatAttr(::mlir::SymbolRefAttr attr) {
    getProperties().comdat = attr;
  }

  void setConvergentAttr(::mlir::UnitAttr attr) {
    getProperties().convergent = attr;
  }

  void setConvergent(bool attrValue);
  void setPersonalityAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().personality = attr;
  }

  void setPersonality(::std::optional<::llvm::StringRef> attrValue);
  void setGarbageCollectorAttr(::mlir::StringAttr attr) {
    getProperties().garbageCollector = attr;
  }

  void setGarbageCollector(::std::optional<::llvm::StringRef> attrValue);
  void setPassthroughAttr(::mlir::ArrayAttr attr) {
    getProperties().passthrough = attr;
  }

  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  void setFunctionEntryCountAttr(::mlir::IntegerAttr attr) {
    getProperties().function_entry_count = attr;
  }

  void setFunctionEntryCount(::std::optional<uint64_t> attrValue);
  void setMemoryEffectsAttr(::mlir::LLVM::MemoryEffectsAttr attr) {
    getProperties().memory_effects = attr;
  }

  void setVisibility_Attr(::mlir::LLVM::VisibilityAttr attr) {
    getProperties().visibility_ = attr;
  }

  void setVisibility_(::mlir::LLVM::Visibility attrValue);
  void setArmStreamingAttr(::mlir::UnitAttr attr) {
    getProperties().arm_streaming = attr;
  }

  void setArmStreaming(bool attrValue);
  void setArmLocallyStreamingAttr(::mlir::UnitAttr attr) {
    getProperties().arm_locally_streaming = attr;
  }

  void setArmLocallyStreaming(bool attrValue);
  void setArmStreamingCompatibleAttr(::mlir::UnitAttr attr) {
    getProperties().arm_streaming_compatible = attr;
  }

  void setArmStreamingCompatible(bool attrValue);
  void setArmNewZaAttr(::mlir::UnitAttr attr) {
    getProperties().arm_new_za = attr;
  }

  void setArmNewZa(bool attrValue);
  void setArmInZaAttr(::mlir::UnitAttr attr) {
    getProperties().arm_in_za = attr;
  }

  void setArmInZa(bool attrValue);
  void setArmOutZaAttr(::mlir::UnitAttr attr) {
    getProperties().arm_out_za = attr;
  }

  void setArmOutZa(bool attrValue);
  void setArmInoutZaAttr(::mlir::UnitAttr attr) {
    getProperties().arm_inout_za = attr;
  }

  void setArmInoutZa(bool attrValue);
  void setArmPreservesZaAttr(::mlir::UnitAttr attr) {
    getProperties().arm_preserves_za = attr;
  }

  void setArmPreservesZa(bool attrValue);
  void setSectionAttr(::mlir::StringAttr attr) {
    getProperties().section = attr;
  }

  void setSection(::std::optional<::llvm::StringRef> attrValue);
  void setUnnamedAddrAttr(::mlir::LLVM::UnnamedAddrAttr attr) {
    getProperties().unnamed_addr = attr;
  }

  void setUnnamedAddr(::std::optional<::mlir::LLVM::UnnamedAddr> attrValue);
  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  void setVscaleRangeAttr(::mlir::LLVM::VScaleRangeAttr attr) {
    getProperties().vscale_range = attr;
  }

  void setFramePointerAttr(::mlir::LLVM::FramePointerKindAttr attr) {
    getProperties().frame_pointer = attr;
  }

  void setTargetCpuAttr(::mlir::StringAttr attr) {
    getProperties().target_cpu = attr;
  }

  void setTargetCpu(::std::optional<::llvm::StringRef> attrValue);
  void setTuneCpuAttr(::mlir::StringAttr attr) {
    getProperties().tune_cpu = attr;
  }

  void setTuneCpu(::std::optional<::llvm::StringRef> attrValue);
  void setReciprocalEstimatesAttr(::mlir::StringAttr attr) {
    getProperties().reciprocal_estimates = attr;
  }

  void setReciprocalEstimates(::std::optional<::llvm::StringRef> attrValue);
  void setPreferVectorWidthAttr(::mlir::StringAttr attr) {
    getProperties().prefer_vector_width = attr;
  }

  void setPreferVectorWidth(::std::optional<::llvm::StringRef> attrValue);
  void setTargetFeaturesAttr(::mlir::LLVM::TargetFeaturesAttr attr) {
    getProperties().target_features = attr;
  }

  void setNoInfsFpMathAttr(::mlir::BoolAttr attr) {
    getProperties().no_infs_fp_math = attr;
  }

  void setNoInfsFpMath(::std::optional<bool> attrValue);
  void setNoNansFpMathAttr(::mlir::BoolAttr attr) {
    getProperties().no_nans_fp_math = attr;
  }

  void setNoNansFpMath(::std::optional<bool> attrValue);
  void setNoSignedZerosFpMathAttr(::mlir::BoolAttr attr) {
    getProperties().no_signed_zeros_fp_math = attr;
  }

  void setNoSignedZerosFpMath(::std::optional<bool> attrValue);
  void setDenormalFpMathAttr(::mlir::StringAttr attr) {
    getProperties().denormal_fp_math = attr;
  }

  void setDenormalFpMath(::std::optional<::llvm::StringRef> attrValue);
  void setDenormalFpMathF32Attr(::mlir::StringAttr attr) {
    getProperties().denormal_fp_math_f32 = attr;
  }

  void setDenormalFpMathF32(::std::optional<::llvm::StringRef> attrValue);
  void setFpContractAttr(::mlir::StringAttr attr) {
    getProperties().fp_contract = attr;
  }

  void setFpContract(::std::optional<::llvm::StringRef> attrValue);
  void setInstrumentFunctionEntryAttr(::mlir::StringAttr attr) {
    getProperties().instrument_function_entry = attr;
  }

  void setInstrumentFunctionEntry(::std::optional<::llvm::StringRef> attrValue);
  void setInstrumentFunctionExitAttr(::mlir::StringAttr attr) {
    getProperties().instrument_function_exit = attr;
  }

  void setInstrumentFunctionExit(::std::optional<::llvm::StringRef> attrValue);
  void setNoInlineAttr(::mlir::UnitAttr attr) {
    getProperties().no_inline = attr;
  }

  void setNoInline(bool attrValue);
  void setAlwaysInlineAttr(::mlir::UnitAttr attr) {
    getProperties().always_inline = attr;
  }

  void setAlwaysInline(bool attrValue);
  void setInlineHintAttr(::mlir::UnitAttr attr) {
    getProperties().inline_hint = attr;
  }

  void setInlineHint(bool attrValue);
  void setNoUnwindAttr(::mlir::UnitAttr attr) {
    getProperties().no_unwind = attr;
  }

  void setNoUnwind(bool attrValue);
  void setWillReturnAttr(::mlir::UnitAttr attr) {
    getProperties().will_return = attr;
  }

  void setWillReturn(bool attrValue);
  void setOptimizeNoneAttr(::mlir::UnitAttr attr) {
    getProperties().optimize_none = attr;
  }

  void setOptimizeNone(bool attrValue);
  void setVecTypeHintAttr(::mlir::LLVM::VecTypeHintAttr attr) {
    getProperties().vec_type_hint = attr;
  }

  void setWorkGroupSizeHintAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().work_group_size_hint = attr;
  }

  void setWorkGroupSizeHint(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setReqdWorkGroupSizeAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().reqd_work_group_size = attr;
  }

  void setReqdWorkGroupSize(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  void setIntelReqdSubGroupSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().intel_reqd_sub_group_size = attr;
  }

  void setIntelReqdSubGroupSize(::std::optional<uint32_t> attrValue);
  void setUwtableKindAttr(::mlir::LLVM::UWTableKindAttr attr) {
    getProperties().uwtable_kind = attr;
  }

  ::mlir::Attribute removeSymVisibilityAttr() {
      auto attr = getProperties().sym_visibility;
      getProperties().sym_visibility = {};
      return attr;
  }

  ::mlir::Attribute removeDsoLocalAttr() {
      auto attr = getProperties().dso_local;
      getProperties().dso_local = {};
      return attr;
  }

  ::mlir::Attribute removeComdatAttr() {
      auto attr = getProperties().comdat;
      getProperties().comdat = {};
      return attr;
  }

  ::mlir::Attribute removeConvergentAttr() {
      auto attr = getProperties().convergent;
      getProperties().convergent = {};
      return attr;
  }

  ::mlir::Attribute removePersonalityAttr() {
      auto attr = getProperties().personality;
      getProperties().personality = {};
      return attr;
  }

  ::mlir::Attribute removeGarbageCollectorAttr() {
      auto attr = getProperties().garbageCollector;
      getProperties().garbageCollector = {};
      return attr;
  }

  ::mlir::Attribute removePassthroughAttr() {
      auto attr = getProperties().passthrough;
      getProperties().passthrough = {};
      return attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeFunctionEntryCountAttr() {
      auto attr = getProperties().function_entry_count;
      getProperties().function_entry_count = {};
      return attr;
  }

  ::mlir::Attribute removeMemoryEffectsAttr() {
      auto attr = getProperties().memory_effects;
      getProperties().memory_effects = {};
      return attr;
  }

  ::mlir::Attribute removeArmStreamingAttr() {
      auto attr = getProperties().arm_streaming;
      getProperties().arm_streaming = {};
      return attr;
  }

  ::mlir::Attribute removeArmLocallyStreamingAttr() {
      auto attr = getProperties().arm_locally_streaming;
      getProperties().arm_locally_streaming = {};
      return attr;
  }

  ::mlir::Attribute removeArmStreamingCompatibleAttr() {
      auto attr = getProperties().arm_streaming_compatible;
      getProperties().arm_streaming_compatible = {};
      return attr;
  }

  ::mlir::Attribute removeArmNewZaAttr() {
      auto attr = getProperties().arm_new_za;
      getProperties().arm_new_za = {};
      return attr;
  }

  ::mlir::Attribute removeArmInZaAttr() {
      auto attr = getProperties().arm_in_za;
      getProperties().arm_in_za = {};
      return attr;
  }

  ::mlir::Attribute removeArmOutZaAttr() {
      auto attr = getProperties().arm_out_za;
      getProperties().arm_out_za = {};
      return attr;
  }

  ::mlir::Attribute removeArmInoutZaAttr() {
      auto attr = getProperties().arm_inout_za;
      getProperties().arm_inout_za = {};
      return attr;
  }

  ::mlir::Attribute removeArmPreservesZaAttr() {
      auto attr = getProperties().arm_preserves_za;
      getProperties().arm_preserves_za = {};
      return attr;
  }

  ::mlir::Attribute removeSectionAttr() {
      auto attr = getProperties().section;
      getProperties().section = {};
      return attr;
  }

  ::mlir::Attribute removeUnnamedAddrAttr() {
      auto attr = getProperties().unnamed_addr;
      getProperties().unnamed_addr = {};
      return attr;
  }

  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  ::mlir::Attribute removeVscaleRangeAttr() {
      auto attr = getProperties().vscale_range;
      getProperties().vscale_range = {};
      return attr;
  }

  ::mlir::Attribute removeFramePointerAttr() {
      auto attr = getProperties().frame_pointer;
      getProperties().frame_pointer = {};
      return attr;
  }

  ::mlir::Attribute removeTargetCpuAttr() {
      auto attr = getProperties().target_cpu;
      getProperties().target_cpu = {};
      return attr;
  }

  ::mlir::Attribute removeTuneCpuAttr() {
      auto attr = getProperties().tune_cpu;
      getProperties().tune_cpu = {};
      return attr;
  }

  ::mlir::Attribute removeReciprocalEstimatesAttr() {
      auto attr = getProperties().reciprocal_estimates;
      getProperties().reciprocal_estimates = {};
      return attr;
  }

  ::mlir::Attribute removePreferVectorWidthAttr() {
      auto attr = getProperties().prefer_vector_width;
      getProperties().prefer_vector_width = {};
      return attr;
  }

  ::mlir::Attribute removeTargetFeaturesAttr() {
      auto attr = getProperties().target_features;
      getProperties().target_features = {};
      return attr;
  }

  ::mlir::Attribute removeNoInfsFpMathAttr() {
      auto attr = getProperties().no_infs_fp_math;
      getProperties().no_infs_fp_math = {};
      return attr;
  }

  ::mlir::Attribute removeNoNansFpMathAttr() {
      auto attr = getProperties().no_nans_fp_math;
      getProperties().no_nans_fp_math = {};
      return attr;
  }

  ::mlir::Attribute removeNoSignedZerosFpMathAttr() {
      auto attr = getProperties().no_signed_zeros_fp_math;
      getProperties().no_signed_zeros_fp_math = {};
      return attr;
  }

  ::mlir::Attribute removeDenormalFpMathAttr() {
      auto attr = getProperties().denormal_fp_math;
      getProperties().denormal_fp_math = {};
      return attr;
  }

  ::mlir::Attribute removeDenormalFpMathF32Attr() {
      auto attr = getProperties().denormal_fp_math_f32;
      getProperties().denormal_fp_math_f32 = {};
      return attr;
  }

  ::mlir::Attribute removeFpContractAttr() {
      auto attr = getProperties().fp_contract;
      getProperties().fp_contract = {};
      return attr;
  }

  ::mlir::Attribute removeInstrumentFunctionEntryAttr() {
      auto attr = getProperties().instrument_function_entry;
      getProperties().instrument_function_entry = {};
      return attr;
  }

  ::mlir::Attribute removeInstrumentFunctionExitAttr() {
      auto attr = getProperties().instrument_function_exit;
      getProperties().instrument_function_exit = {};
      return attr;
  }

  ::mlir::Attribute removeNoInlineAttr() {
      auto attr = getProperties().no_inline;
      getProperties().no_inline = {};
      return attr;
  }

  ::mlir::Attribute removeAlwaysInlineAttr() {
      auto attr = getProperties().always_inline;
      getProperties().always_inline = {};
      return attr;
  }

  ::mlir::Attribute removeInlineHintAttr() {
      auto attr = getProperties().inline_hint;
      getProperties().inline_hint = {};
      return attr;
  }

  ::mlir::Attribute removeNoUnwindAttr() {
      auto attr = getProperties().no_unwind;
      getProperties().no_unwind = {};
      return attr;
  }

  ::mlir::Attribute removeWillReturnAttr() {
      auto attr = getProperties().will_return;
      getProperties().will_return = {};
      return attr;
  }

  ::mlir::Attribute removeOptimizeNoneAttr() {
      auto attr = getProperties().optimize_none;
      getProperties().optimize_none = {};
      return attr;
  }

  ::mlir::Attribute removeVecTypeHintAttr() {
      auto attr = getProperties().vec_type_hint;
      getProperties().vec_type_hint = {};
      return attr;
  }

  ::mlir::Attribute removeWorkGroupSizeHintAttr() {
      auto attr = getProperties().work_group_size_hint;
      getProperties().work_group_size_hint = {};
      return attr;
  }

  ::mlir::Attribute removeReqdWorkGroupSizeAttr() {
      auto attr = getProperties().reqd_work_group_size;
      getProperties().reqd_work_group_size = {};
      return attr;
  }

  ::mlir::Attribute removeIntelReqdSubGroupSizeAttr() {
      auto attr = getProperties().intel_reqd_sub_group_size;
      getProperties().intel_reqd_sub_group_size = {};
      return attr;
  }

  ::mlir::Attribute removeUwtableKindAttr() {
      auto attr = getProperties().uwtable_kind;
      getProperties().uwtable_kind = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, StringRef name, Type type, Linkage linkage = Linkage::External, bool dsoLocal = false, CConv cconv = CConv::C, SymbolRefAttr comdat = {}, ArrayRef<NamedAttribute> attrs = {}, ArrayRef<DictionaryAttr> argAttrs = {}, std::optional<uint64_t> functionEntryCount = {});
  static LLVMFuncOp create(::mlir::OpBuilder &builder, ::mlir::Location location, StringRef name, Type type, Linkage linkage = Linkage::External, bool dsoLocal = false, CConv cconv = CConv::C, SymbolRefAttr comdat = {}, ArrayRef<NamedAttribute> attrs = {}, ArrayRef<DictionaryAttr> argAttrs = {}, std::optional<uint64_t> functionEntryCount = {});
  static LLVMFuncOp create(::mlir::ImplicitLocOpBuilder &builder, StringRef name, Type type, Linkage linkage = Linkage::External, bool dsoLocal = false, CConv cconv = CConv::C, SymbolRefAttr comdat = {}, ArrayRef<NamedAttribute> attrs = {}, ArrayRef<DictionaryAttr> argAttrs = {}, std::optional<uint64_t> functionEntryCount = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::LogicalResult verifyRegions();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 53 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // Add an entry block to an empty function, and set up the block arguments
  // to match the signature of the function.
  Block *addEntryBlock(OpBuilder &builder);

  bool isVarArg() { return getFunctionType().isVarArg(); }

  /// Returns the argument types of this function.
  ArrayRef<Type> getArgumentTypes() { return getFunctionType().getParams(); }

  /// Returns the result types of this function.
  ArrayRef<Type> getResultTypes() {
    if (::llvm::isa<LLVM::LLVMVoidType>(getFunctionType().getReturnType()))
      return {};
    return getFunctionType().getReturnTypes();
  }

  /// Returns the callable region, which is the function body. If the function
  /// is external, returns null.
  Region *getCallableRegion();

  /// Returns true if the `no_inline` attribute is set, false otherwise.
  bool isNoInline() { return bool(getNoInlineAttr()); }

  /// Returns true if the `always_inline` attribute is set, false otherwise.
  bool isAlwaysInline() { return bool(getAlwaysInlineAttr()); }

  /// Returns true if the `inline_hint` attribute is set, false otherwise.
  bool isInlineHint() { return bool(getInlineHintAttr()); }

  /// Returns true if the `optimize_none` attribute is set, false otherwise.
  bool isOptimizeNone() { return bool(getOptimizeNoneAttr()); }
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LLVMFuncOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LShrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LShrOpGenericAdaptorBase {
public:
  struct Properties {
    using isExactTy = ::mlir::UnitAttr;
    isExactTy isExact;

    auto getIsExact() const {
      auto &propStorage = this->isExact;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setIsExact(const ::mlir::UnitAttr &propValue) {
      this->isExact = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.isExact == this->isExact &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LShrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.lshr", odsAttrs.getContext());
  }

  LShrOpGenericAdaptorBase(LShrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getIsExactAttr();
  bool getIsExact();
};

} // namespace detail
template <typename RangeT>
class LShrOpGenericAdaptor : public detail::LShrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LShrOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  LShrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LShrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LShrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LShrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LShrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LShrOpGenericAdaptor(RangeT values, const LShrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LShrOp, typename = std::enable_if_t<std::is_same_v<LateInst, LShrOp>>>
  LShrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LShrOpAdaptor : public LShrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LShrOpGenericAdaptor::LShrOpGenericAdaptor;
  LShrOpAdaptor(LShrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LShrOp : public ::mlir::Op<LShrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::ExactFlagInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LShrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LShrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::ExactFlagInterface::Trait<LShrOp>::getIsExact;
  using ::mlir::LLVM::ExactFlagInterface::Trait<LShrOp>::setIsExact;
  using ::mlir::LLVM::ExactFlagInterface::Trait<LShrOp>::getIsExactName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("isExact")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIsExactAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIsExactAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.lshr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getIsExactAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().isExact);
  }

  bool getIsExact();
  void setIsExactAttr(::mlir::UnitAttr attr) {
    getProperties().isExact = attr;
  }

  void setIsExact(bool attrValue);
  ::mlir::Attribute removeIsExactAttr() {
      auto attr = getProperties().isExact;
      getProperties().isExact = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::UnitAttr isExact);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/bool isExact = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LShrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LShrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LShrOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LandingpadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LandingpadOpGenericAdaptorBase {
public:
  struct Properties {
    using cleanupTy = ::mlir::UnitAttr;
    cleanupTy cleanup;

    auto getCleanup() const {
      auto &propStorage = this->cleanup;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCleanup(const ::mlir::UnitAttr &propValue) {
      this->cleanup = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.cleanup == this->cleanup &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LandingpadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.landingpad", odsAttrs.getContext());
  }

  LandingpadOpGenericAdaptorBase(LandingpadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getCleanupAttr();
  bool getCleanup();
};

} // namespace detail
template <typename RangeT>
class LandingpadOpGenericAdaptor : public detail::LandingpadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LandingpadOpGenericAdaptorBase;
public:
  LandingpadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LandingpadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LandingpadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LandingpadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LandingpadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LandingpadOpGenericAdaptor(RangeT values, const LandingpadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LandingpadOp, typename = std::enable_if_t<std::is_same_v<LateInst, LandingpadOp>>>
  LandingpadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LandingpadOpAdaptor : public LandingpadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LandingpadOpGenericAdaptor::LandingpadOpGenericAdaptor;
  LandingpadOpAdaptor(LandingpadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LandingpadOp : public ::mlir::Op<LandingpadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LandingpadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LandingpadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("cleanup")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCleanupAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCleanupAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.landingpad");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getCleanupAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().cleanup);
  }

  bool getCleanup();
  void setCleanupAttr(::mlir::UnitAttr attr) {
    getProperties().cleanup = attr;
  }

  void setCleanup(bool attrValue);
  ::mlir::Attribute removeCleanupAttr() {
      auto attr = getProperties().cleanup;
      getProperties().cleanup = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::UnitAttr cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::UnitAttr cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::UnitAttr cleanup, ::mlir::ValueRange odsArg_0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr cleanup, ::mlir::ValueRange odsArg_0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/bool cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/bool cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/bool cleanup, ::mlir::ValueRange odsArg_0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/bool cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/bool cleanup, ::mlir::ValueRange odsArg_0);
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/bool cleanup, ::mlir::ValueRange odsArg_0);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LandingpadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LandingpadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LandingpadOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LinkerOptionsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LinkerOptionsOpGenericAdaptorBase {
public:
  struct Properties {
    using optionsTy = ::mlir::ArrayAttr;
    optionsTy options;

    auto getOptions() const {
      auto &propStorage = this->options;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setOptions(const ::mlir::ArrayAttr &propValue) {
      this->options = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.options == this->options &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LinkerOptionsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.linker_options", odsAttrs.getContext());
  }

  LinkerOptionsOpGenericAdaptorBase(LinkerOptionsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getOptionsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().options);
    return attr;
  }

  ::mlir::ArrayAttr getOptions();
};

} // namespace detail
template <typename RangeT>
class LinkerOptionsOpGenericAdaptor : public detail::LinkerOptionsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LinkerOptionsOpGenericAdaptorBase;
public:
  LinkerOptionsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LinkerOptionsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LinkerOptionsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LinkerOptionsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LinkerOptionsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LinkerOptionsOpGenericAdaptor(RangeT values, const LinkerOptionsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LinkerOptionsOp, typename = std::enable_if_t<std::is_same_v<LateInst, LinkerOptionsOp>>>
  LinkerOptionsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LinkerOptionsOpAdaptor : public LinkerOptionsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LinkerOptionsOpGenericAdaptor::LinkerOptionsOpGenericAdaptor;
  LinkerOptionsOpAdaptor(LinkerOptionsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LinkerOptionsOp : public ::mlir::Op<LinkerOptionsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LinkerOptionsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LinkerOptionsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("options")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOptionsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOptionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.linker_options");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getOptionsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().options);
  }

  ::mlir::ArrayAttr getOptions();
  void setOptionsAttr(::mlir::ArrayAttr attr) {
    getProperties().options = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ArrayAttr options);
  static LinkerOptionsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ArrayAttr options);
  static LinkerOptionsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ArrayAttr options);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr options);
  static LinkerOptionsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr options);
  static LinkerOptionsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr options);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LinkerOptionsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LinkerOptionsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LinkerOptionsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LinkerOptionsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LinkerOptionsOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LoadOpGenericAdaptorBase {
public:
  struct Properties {
    using access_groupsTy = ::mlir::ArrayAttr;
    access_groupsTy access_groups;

    auto getAccessGroups() const {
      auto &propStorage = this->access_groups;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAccessGroups(const ::mlir::ArrayAttr &propValue) {
      this->access_groups = propValue;
    }
    using alias_scopesTy = ::mlir::ArrayAttr;
    alias_scopesTy alias_scopes;

    auto getAliasScopes() const {
      auto &propStorage = this->alias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->alias_scopes = propValue;
    }
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using dereferenceableTy = ::mlir::LLVM::DereferenceableAttr;
    dereferenceableTy dereferenceable;

    auto getDereferenceable() const {
      auto &propStorage = this->dereferenceable;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::DereferenceableAttr>(propStorage);
    }
    void setDereferenceable(const ::mlir::LLVM::DereferenceableAttr &propValue) {
      this->dereferenceable = propValue;
    }
    using invariantTy = ::mlir::UnitAttr;
    invariantTy invariant;

    auto getInvariant() const {
      auto &propStorage = this->invariant;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInvariant(const ::mlir::UnitAttr &propValue) {
      this->invariant = propValue;
    }
    using invariantGroupTy = ::mlir::UnitAttr;
    invariantGroupTy invariantGroup;

    auto getInvariantGroup() const {
      auto &propStorage = this->invariantGroup;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInvariantGroup(const ::mlir::UnitAttr &propValue) {
      this->invariantGroup = propValue;
    }
    using noalias_scopesTy = ::mlir::ArrayAttr;
    noalias_scopesTy noalias_scopes;

    auto getNoaliasScopes() const {
      auto &propStorage = this->noalias_scopes;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setNoaliasScopes(const ::mlir::ArrayAttr &propValue) {
      this->noalias_scopes = propValue;
    }
    using nontemporalTy = ::mlir::UnitAttr;
    nontemporalTy nontemporal;

    auto getNontemporal() const {
      auto &propStorage = this->nontemporal;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNontemporal(const ::mlir::UnitAttr &propValue) {
      this->nontemporal = propValue;
    }
    using orderingTy = ::mlir::LLVM::AtomicOrderingAttr;
    orderingTy ordering;

    auto getOrdering() const {
      auto &propStorage = this->ordering;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::AtomicOrderingAttr>(propStorage);
    }
    void setOrdering(const ::mlir::LLVM::AtomicOrderingAttr &propValue) {
      this->ordering = propValue;
    }
    using syncscopeTy = ::mlir::StringAttr;
    syncscopeTy syncscope;

    auto getSyncscope() const {
      auto &propStorage = this->syncscope;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setSyncscope(const ::mlir::StringAttr &propValue) {
      this->syncscope = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    using volatile_Ty = ::mlir::UnitAttr;
    volatile_Ty volatile_;

    auto getVolatile_() const {
      auto &propStorage = this->volatile_;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setVolatile_(const ::mlir::UnitAttr &propValue) {
      this->volatile_ = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.access_groups == this->access_groups &&
        rhs.alias_scopes == this->alias_scopes &&
        rhs.alignment == this->alignment &&
        rhs.dereferenceable == this->dereferenceable &&
        rhs.invariant == this->invariant &&
        rhs.invariantGroup == this->invariantGroup &&
        rhs.noalias_scopes == this->noalias_scopes &&
        rhs.nontemporal == this->nontemporal &&
        rhs.ordering == this->ordering &&
        rhs.syncscope == this->syncscope &&
        rhs.tbaa == this->tbaa &&
        rhs.volatile_ == this->volatile_ &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.load", odsAttrs.getContext());
  }

  LoadOpGenericAdaptorBase(LoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::UnitAttr getVolatile_Attr();
  bool getVolatile_();
  ::mlir::UnitAttr getNontemporalAttr();
  bool getNontemporal();
  ::mlir::UnitAttr getInvariantAttr();
  bool getInvariant();
  ::mlir::UnitAttr getInvariantGroupAttr();
  bool getInvariantGroup();
  ::mlir::LLVM::AtomicOrderingAttr getOrderingAttr();
  ::mlir::LLVM::AtomicOrdering getOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  ::mlir::LLVM::DereferenceableAttr getDereferenceableAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::DereferenceableAttr>(getProperties().dereferenceable);
    return attr;
  }

  ::std::optional<::mlir::LLVM::DereferenceableAttr> getDereferenceable();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
};

} // namespace detail
template <typename RangeT>
class LoadOpGenericAdaptor : public detail::LoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LoadOpGenericAdaptorBase;
  static constexpr int odsIndex_addr = 0;
public:
  LoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LoadOpGenericAdaptor(RangeT values, const LoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, LoadOp>>>
  LoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAddr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LoadOpAdaptor : public LoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LoadOpGenericAdaptor::LoadOpGenericAdaptor;
  LoadOpAdaptor(LoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LoadOp : public ::mlir::Op<LoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LLVM::AccessGroupOpInterface::Trait, ::mlir::LLVM::AliasAnalysisOpInterface::Trait, ::mlir::DestructurableAccessorOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::PromotableMemOpInterface::Trait, ::mlir::SafeMemorySlotAccessOpInterface::Trait, ::mlir::LLVM::DereferenceableOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_addr = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<LoadOp>::getAccessGroupsOrNull;
  using ::mlir::LLVM::AccessGroupOpInterface::Trait<LoadOp>::setAccessGroups;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<LoadOp>::getAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<LoadOp>::setAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<LoadOp>::getNoAliasScopesOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<LoadOp>::setNoAliasScopes;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<LoadOp>::getTBAATagsOrNull;
  using ::mlir::LLVM::AliasAnalysisOpInterface::Trait<LoadOp>::setTBAATags;
  using ::mlir::LLVM::DereferenceableOpInterface::Trait<LoadOp>::getDereferenceableOrNull;
  using ::mlir::LLVM::DereferenceableOpInterface::Trait<LoadOp>::setDereferenceable;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("access_groups"), ::llvm::StringRef("alias_scopes"), ::llvm::StringRef("alignment"), ::llvm::StringRef("dereferenceable"), ::llvm::StringRef("invariant"), ::llvm::StringRef("invariantGroup"), ::llvm::StringRef("noalias_scopes"), ::llvm::StringRef("nontemporal"), ::llvm::StringRef("ordering"), ::llvm::StringRef("syncscope"), ::llvm::StringRef("tbaa"), ::llvm::StringRef("volatile_")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAccessGroupsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAccessGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAliasScopesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getDereferenceableAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getDereferenceableAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getInvariantAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getInvariantAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getInvariantGroupAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getInvariantGroupAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getNoaliasScopesAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getNoaliasScopesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getNontemporalAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getNontemporalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getOrderingAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getOrderingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getSyncscopeAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getSyncscopeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getVolatile_AttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getVolatile_AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getAddr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getAddrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::UnitAttr getVolatile_Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().volatile_);
  }

  bool getVolatile_();
  ::mlir::UnitAttr getNontemporalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().nontemporal);
  }

  bool getNontemporal();
  ::mlir::UnitAttr getInvariantAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().invariant);
  }

  bool getInvariant();
  ::mlir::UnitAttr getInvariantGroupAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().invariantGroup);
  }

  bool getInvariantGroup();
  ::mlir::LLVM::AtomicOrderingAttr getOrderingAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::AtomicOrderingAttr>(getProperties().ordering);
  }

  ::mlir::LLVM::AtomicOrdering getOrdering();
  ::mlir::StringAttr getSyncscopeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().syncscope);
  }

  ::std::optional< ::llvm::StringRef > getSyncscope();
  ::mlir::LLVM::DereferenceableAttr getDereferenceableAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::DereferenceableAttr>(getProperties().dereferenceable);
  }

  ::std::optional<::mlir::LLVM::DereferenceableAttr> getDereferenceable();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::ArrayAttr getAliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getAliasScopes();
  ::mlir::ArrayAttr getNoaliasScopesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  }

  ::std::optional< ::mlir::ArrayAttr > getNoaliasScopes();
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  void setVolatile_Attr(::mlir::UnitAttr attr) {
    getProperties().volatile_ = attr;
  }

  void setVolatile_(bool attrValue);
  void setNontemporalAttr(::mlir::UnitAttr attr) {
    getProperties().nontemporal = attr;
  }

  void setNontemporal(bool attrValue);
  void setInvariantAttr(::mlir::UnitAttr attr) {
    getProperties().invariant = attr;
  }

  void setInvariant(bool attrValue);
  void setInvariantGroupAttr(::mlir::UnitAttr attr) {
    getProperties().invariantGroup = attr;
  }

  void setInvariantGroup(bool attrValue);
  void setOrderingAttr(::mlir::LLVM::AtomicOrderingAttr attr) {
    getProperties().ordering = attr;
  }

  void setOrdering(::mlir::LLVM::AtomicOrdering attrValue);
  void setSyncscopeAttr(::mlir::StringAttr attr) {
    getProperties().syncscope = attr;
  }

  void setSyncscope(::std::optional<::llvm::StringRef> attrValue);
  void setDereferenceableAttr(::mlir::LLVM::DereferenceableAttr attr) {
    getProperties().dereferenceable = attr;
  }

  void setAccessGroupsAttr(::mlir::ArrayAttr attr) {
    getProperties().access_groups = attr;
  }

  void setAliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().alias_scopes = attr;
  }

  void setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
    getProperties().noalias_scopes = attr;
  }

  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  ::mlir::Attribute removeVolatile_Attr() {
      auto attr = getProperties().volatile_;
      getProperties().volatile_ = {};
      return attr;
  }

  ::mlir::Attribute removeNontemporalAttr() {
      auto attr = getProperties().nontemporal;
      getProperties().nontemporal = {};
      return attr;
  }

  ::mlir::Attribute removeInvariantAttr() {
      auto attr = getProperties().invariant;
      getProperties().invariant = {};
      return attr;
  }

  ::mlir::Attribute removeInvariantGroupAttr() {
      auto attr = getProperties().invariantGroup;
      getProperties().invariantGroup = {};
      return attr;
  }

  ::mlir::Attribute removeSyncscopeAttr() {
      auto attr = getProperties().syncscope;
      getProperties().syncscope = {};
      return attr;
  }

  ::mlir::Attribute removeDereferenceableAttr() {
      auto attr = getProperties().dereferenceable;
      getProperties().dereferenceable = {};
      return attr;
  }

  ::mlir::Attribute removeAccessGroupsAttr() {
      auto attr = getProperties().access_groups;
      getProperties().access_groups = {};
      return attr;
  }

  ::mlir::Attribute removeAliasScopesAttr() {
      auto attr = getProperties().alias_scopes;
      getProperties().alias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeNoaliasScopesAttr() {
      auto attr = getProperties().noalias_scopes;
      getProperties().noalias_scopes = {};
      return attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type type, Value addr, unsigned alignment = 0, bool isVolatile = false, bool isNonTemporal = false, bool isInvariant = false, bool isInvariantGroup = false, AtomicOrdering ordering = AtomicOrdering::not_atomic, StringRef syncscope = StringRef());
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type type, Value addr, unsigned alignment = 0, bool isVolatile = false, bool isNonTemporal = false, bool isInvariant = false, bool isInvariantGroup = false, AtomicOrdering ordering = AtomicOrdering::not_atomic, StringRef syncscope = StringRef());
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, Type type, Value addr, unsigned alignment = 0, bool isVolatile = false, bool isNonTemporal = false, bool isInvariant = false, bool isInvariantGroup = false, AtomicOrdering ordering = AtomicOrdering::not_atomic, StringRef syncscope = StringRef());
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::UnitAttr invariant, /*optional*/::mlir::UnitAttr invariantGroup, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::UnitAttr invariant, /*optional*/::mlir::UnitAttr invariantGroup, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::UnitAttr invariant, /*optional*/::mlir::UnitAttr invariantGroup, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::UnitAttr invariant, /*optional*/::mlir::UnitAttr invariantGroup, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::UnitAttr invariant, /*optional*/::mlir::UnitAttr invariantGroup, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/::mlir::UnitAttr volatile_, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::UnitAttr invariant, /*optional*/::mlir::UnitAttr invariantGroup, ::mlir::LLVM::AtomicOrderingAttr ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/bool nontemporal, /*optional*/bool invariant, /*optional*/bool invariantGroup, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/bool nontemporal, /*optional*/bool invariant, /*optional*/bool invariantGroup, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/bool nontemporal, /*optional*/bool invariant, /*optional*/bool invariantGroup, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/bool nontemporal, /*optional*/bool invariant, /*optional*/bool invariantGroup, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/bool nontemporal, /*optional*/bool invariant, /*optional*/bool invariantGroup, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value addr, /*optional*/::mlir::IntegerAttr alignment, /*optional*/bool volatile_, /*optional*/bool nontemporal, /*optional*/bool invariant, /*optional*/bool invariantGroup, ::mlir::LLVM::AtomicOrdering ordering, /*optional*/::mlir::StringAttr syncscope, /*optional*/::mlir::LLVM::DereferenceableAttr dereferenceable, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Value> getAccessedOperands();
  bool canRewire(const ::mlir::DestructurableMemorySlot &slot, ::llvm::SmallPtrSetImpl<::mlir::Attribute> &usedIndices, ::mlir::SmallVectorImpl<::mlir::MemorySlot> &mustBeSafelyUsed, const ::mlir::DataLayout &dataLayout);
  ::mlir::DeletionKind rewire(const ::mlir::DestructurableMemorySlot &slot, ::llvm::DenseMap<::mlir::Attribute, ::mlir::MemorySlot> &subslots, ::mlir::OpBuilder &builder, const ::mlir::DataLayout &dataLayout);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  bool loadsFrom(const ::mlir::MemorySlot &slot);
  bool storesTo(const ::mlir::MemorySlot &slot);
  ::mlir::Value getStored(const ::mlir::MemorySlot &slot, ::mlir::OpBuilder &builder, ::mlir::Value reachingDef, const ::mlir::DataLayout &dataLayout);
  bool canUsesBeRemoved(const ::mlir::MemorySlot &slot, const ::llvm::SmallPtrSetImpl<::mlir::OpOperand *> &blockingUses, ::llvm::SmallVectorImpl<::mlir::OpOperand *> &newBlockingUses, const ::mlir::DataLayout &datalayout);
  ::mlir::DeletionKind removeBlockingUses(const ::mlir::MemorySlot &slot, const ::llvm::SmallPtrSetImpl<mlir::OpOperand *> &blockingUses, ::mlir::OpBuilder &builder, ::mlir::Value reachingDefinition, const ::mlir::DataLayout &dataLayout);
  ::llvm::LogicalResult ensureOnlySafeAccesses(const ::mlir::MemorySlot &slot, ::mlir::SmallVectorImpl<::mlir::MemorySlot> &mustBeSafelyUsed, const ::mlir::DataLayout &dataLayout);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 12 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::LoadOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ModuleFlagsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ModuleFlagsOpGenericAdaptorBase {
public:
  struct Properties {
    using flagsTy = ::mlir::ArrayAttr;
    flagsTy flags;

    auto getFlags() const {
      auto &propStorage = this->flags;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setFlags(const ::mlir::ArrayAttr &propValue) {
      this->flags = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.flags == this->flags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ModuleFlagsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.module_flags", odsAttrs.getContext());
  }

  ModuleFlagsOpGenericAdaptorBase(ModuleFlagsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getFlagsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().flags);
    return attr;
  }

  ::mlir::ArrayAttr getFlags();
};

} // namespace detail
template <typename RangeT>
class ModuleFlagsOpGenericAdaptor : public detail::ModuleFlagsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ModuleFlagsOpGenericAdaptorBase;
public:
  ModuleFlagsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ModuleFlagsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ModuleFlagsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ModuleFlagsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ModuleFlagsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ModuleFlagsOpGenericAdaptor(RangeT values, const ModuleFlagsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ModuleFlagsOp, typename = std::enable_if_t<std::is_same_v<LateInst, ModuleFlagsOp>>>
  ModuleFlagsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ModuleFlagsOpAdaptor : public ModuleFlagsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ModuleFlagsOpGenericAdaptor::ModuleFlagsOpGenericAdaptor;
  ModuleFlagsOpAdaptor(ModuleFlagsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ModuleFlagsOp : public ::mlir::Op<ModuleFlagsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ModuleFlagsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ModuleFlagsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("flags")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFlagsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFlagsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.module_flags");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getFlagsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().flags);
  }

  ::mlir::ArrayAttr getFlags();
  void setFlagsAttr(::mlir::ArrayAttr attr) {
    getProperties().flags = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ArrayAttr flags);
  static ModuleFlagsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ArrayAttr flags);
  static ModuleFlagsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ArrayAttr flags);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr flags);
  static ModuleFlagsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr flags);
  static ModuleFlagsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ArrayAttr flags);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ModuleFlagsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ModuleFlagsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ModuleFlagsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ModuleFlagsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::ModuleFlagsOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MulOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MulOpGenericAdaptorBase {
public:
  struct Properties {
    using overflowFlagsTy = ::mlir::LLVM::IntegerOverflowFlags;
    overflowFlagsTy overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none;
    ::mlir::LLVM::IntegerOverflowFlags getOverflowFlags() const {
      auto &propStorage = this->overflowFlags;
      return propStorage;
    }
    void setOverflowFlags(::mlir::LLVM::IntegerOverflowFlags propValue) {
      auto &propStorage = this->overflowFlags;
      propStorage = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.overflowFlags == this->overflowFlags &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MulOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mul", odsAttrs.getContext());
  }

  MulOpGenericAdaptorBase(MulOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::IntegerOverflowFlags getOverflowFlags() {
    return getProperties().getOverflowFlags();
  }

};

} // namespace detail
template <typename RangeT>
class MulOpGenericAdaptor : public detail::MulOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MulOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  MulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MulOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MulOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MulOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MulOpGenericAdaptor(RangeT values, const MulOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MulOp, typename = std::enable_if_t<std::is_same_v<LateInst, MulOp>>>
  MulOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MulOpAdaptor : public MulOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MulOpGenericAdaptor::MulOpGenericAdaptor;
  MulOpAdaptor(MulOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MulOp : public ::mlir::Op<MulOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait, ::mlir::OpTrait::IsCommutative, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MulOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MulOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<MulOp>::getOverflowFlags;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<MulOp>::setOverflowFlags;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<MulOp>::hasNoUnsignedWrap;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<MulOp>::hasNoSignedWrap;
  using ::mlir::LLVM::IntegerOverflowFlagsInterface::Trait<MulOp>::getOverflowFlagsAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mul");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::IntegerOverflowFlags getOverflowFlags() {
    return getProperties().getOverflowFlags();
  }

  void setOverflowFlags(::mlir::LLVM::IntegerOverflowFlags newOverflowFlags) {
    getProperties().setOverflowFlags(newOverflowFlags);
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::LLVM::IntegerOverflowFlags overflowFlags = ::mlir::LLVM::IntegerOverflowFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::MulOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::NoneTokenOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class NoneTokenOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NoneTokenOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.mlir.none", odsAttrs.getContext());
  }

  NoneTokenOpGenericAdaptorBase(NoneTokenOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class NoneTokenOpGenericAdaptor : public detail::NoneTokenOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NoneTokenOpGenericAdaptorBase;
public:
  NoneTokenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NoneTokenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NoneTokenOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NoneTokenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NoneTokenOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NoneTokenOpGenericAdaptor(RangeT values, const NoneTokenOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NoneTokenOp, typename = std::enable_if_t<std::is_same_v<LateInst, NoneTokenOp>>>
  NoneTokenOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NoneTokenOpAdaptor : public NoneTokenOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NoneTokenOpGenericAdaptor::NoneTokenOpGenericAdaptor;
  NoneTokenOpAdaptor(NoneTokenOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NoneTokenOp : public ::mlir::Op<NoneTokenOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NoneTokenOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NoneTokenOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.mlir.none");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res);
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res);
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoneTokenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoneTokenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::LLVM
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::LLVM::NoneTokenOp)

namespace mlir::LLVM {


//===----------------------------------------------------------------------===//
// ::mlir::LLVM::OrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class OrOpGenericAdaptorBase {
public:
  struct Properties {
    using isDisjointTy = ::mlir::UnitAttr;
    isDisjointTy isDisjoint;

    auto getIsDisjoint() const {
      auto &propStorage = this->isDisjoint;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setIsDisjoint(const ::mlir::UnitAttr &propValue) {
      this->isDisjoint = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.isDisjoint == this->isDisjoint &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  OrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("llvm.or", odsAttrs.getContext());
  }

  OrOpGenericAdaptorBase(OrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getIsDisjointAttr();
  bool getIsDisjoint();
};

} // namespace detail
template <typename RangeT>
class OrOpGenericAdaptor : public detail::OrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::OrOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  OrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  OrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : OrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  OrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : OrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  OrOpGenericAdaptor(RangeT values, const OrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = OrOp, typename = std::enable_if_t<std::is_same_v<LateInst, OrOp>>>
  OrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class OrOpAdaptor : public OrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using OrOpGenericAdaptor::OrOpGenericAdaptor;
  OrOpAdaptor(OrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class OrOp : public ::mlir::Op<OrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::LLVM::DisjointFlagInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = OrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = OrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LLVM::DisjointFlagInterface::Trait<OrOp>::getIsDisjoint;
  using ::mlir::LLVM::DisjointFlagInterface::Trait<OrOp>::setIsDisjoint;
  using ::mlir::LLVM::DisjointFlagInterface::Trait<OrOp>::getIsDisjointName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("isDisjoint")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIsDisjointAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIsDisjointAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("llvm.or");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr 