/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_ASYNCFUNCTOASYNCRUNTIMEPASS
#define GEN_PASS_DECL_ASYNCPARALLELFORPASS
#define GEN_PASS_DECL_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
#define GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGOPTPASS
#define GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGPASS
#define GEN_PASS_DECL_ASYNCTOASYNCRUNTIMEPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// AsyncFuncToAsyncRuntimePass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ASYNCFUNCTOASYNCRUNTIMEPASS
std::unique_ptr<::mlir::Pass> createAsyncFuncToAsyncRuntimePass();
#undef GEN_PASS_DECL_ASYNCFUNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_DECL_ASYNCFUNCTOASYNCRUNTIMEPASS
#ifdef GEN_PASS_DEF_ASYNCFUNCTOASYNCRUNTIMEPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncFuncToAsyncRuntimePass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class AsyncFuncToAsyncRuntimePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = AsyncFuncToAsyncRuntimePassBase;

  AsyncFuncToAsyncRuntimePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  AsyncFuncToAsyncRuntimePassBase(const AsyncFuncToAsyncRuntimePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  AsyncFuncToAsyncRuntimePassBase& operator=(const AsyncFuncToAsyncRuntimePassBase &) = delete;
  AsyncFuncToAsyncRuntimePassBase(AsyncFuncToAsyncRuntimePassBase &&) = delete;
  AsyncFuncToAsyncRuntimePassBase& operator=(AsyncFuncToAsyncRuntimePassBase &&) = delete;
  ~AsyncFuncToAsyncRuntimePassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("async-func-to-async-runtime");
  }
  ::llvm::StringRef getArgument() const override { return "async-func-to-async-runtime"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Lower async.func operations to the explicit async.runtime andasync.coro operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AsyncFuncToAsyncRuntimePass");
  }
  ::llvm::StringRef getName() const override { return "AsyncFuncToAsyncRuntimePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<async::AsyncDialect>();
    registry.insert<func::FuncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AsyncFuncToAsyncRuntimePassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createAsyncFuncToAsyncRuntimePass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createAsyncFuncToAsyncRuntimePass() {
  return impl::createAsyncFuncToAsyncRuntimePass();
}
#undef GEN_PASS_DEF_ASYNCFUNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_DEF_ASYNCFUNCTOASYNCRUNTIMEPASS

//===----------------------------------------------------------------------===//
// AsyncParallelForPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ASYNCPARALLELFORPASS
struct AsyncParallelForPassOptions {
  bool asyncDispatch = true;
  int32_t numWorkerThreads = 8;
  int32_t minTaskSize = 1000;
};
std::unique_ptr<::mlir::Pass> createAsyncParallelForPass();
std::unique_ptr<::mlir::Pass> createAsyncParallelForPass(AsyncParallelForPassOptions options);
#undef GEN_PASS_DECL_ASYNCPARALLELFORPASS
#endif // GEN_PASS_DECL_ASYNCPARALLELFORPASS
#ifdef GEN_PASS_DEF_ASYNCPARALLELFORPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncParallelForPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncParallelForPass(AsyncParallelForPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class AsyncParallelForPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = AsyncParallelForPassBase;

  AsyncParallelForPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  AsyncParallelForPassBase(const AsyncParallelForPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  AsyncParallelForPassBase& operator=(const AsyncParallelForPassBase &) = delete;
  AsyncParallelForPassBase(AsyncParallelForPassBase &&) = delete;
  AsyncParallelForPassBase& operator=(AsyncParallelForPassBase &&) = delete;
  ~AsyncParallelForPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("async-parallel-for");
  }
  ::llvm::StringRef getArgument() const override { return "async-parallel-for"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Convert scf.parallel operations to multiple async compute ops executed concurrently for non-overlapping iteration ranges)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AsyncParallelForPass");
  }
  ::llvm::StringRef getName() const override { return "AsyncParallelForPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<arith::ArithDialect>();
    registry.insert<async::AsyncDialect>();
    registry.insert<func::FuncDialect>();
    registry.insert<scf::SCFDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AsyncParallelForPassBase<DerivedT>)

  AsyncParallelForPassBase(AsyncParallelForPassOptions options) : AsyncParallelForPassBase() {
    asyncDispatch = std::move(options.asyncDispatch);
    numWorkerThreads = std::move(options.numWorkerThreads);
    minTaskSize = std::move(options.minTaskSize);
  }
protected:
  ::mlir::Pass::Option<bool> asyncDispatch{*this, "async-dispatch", ::llvm::cl::desc(R"PO(Dispatch async compute tasks using recursive work splitting. If `false` async compute tasks will be launched using simple for loop in the caller thread.)PO"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<int32_t> numWorkerThreads{*this, "num-workers", ::llvm::cl::desc(R"PO(The number of available workers to execute async operations. If `-1` the value will be retrieved from the runtime.)PO"), ::llvm::cl::init(8)};
  ::mlir::Pass::Option<int32_t> minTaskSize{*this, "min-task-size", ::llvm::cl::desc(R"PO(The minimum task size for sharding parallel operation.)PO"), ::llvm::cl::init(1000)};
private:

  friend std::unique_ptr<::mlir::Pass> createAsyncParallelForPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createAsyncParallelForPass(AsyncParallelForPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createAsyncParallelForPass() {
  return impl::createAsyncParallelForPass();
}

std::unique_ptr<::mlir::Pass> createAsyncParallelForPass(AsyncParallelForPassOptions options) {
  return impl::createAsyncParallelForPass(std::move(options));
}
#undef GEN_PASS_DEF_ASYNCPARALLELFORPASS
#endif // GEN_PASS_DEF_ASYNCPARALLELFORPASS

//===----------------------------------------------------------------------===//
// AsyncRuntimePolicyBasedRefCountingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
std::unique_ptr<::mlir::Pass> createAsyncRuntimePolicyBasedRefCountingPass();
#undef GEN_PASS_DECL_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
#endif // GEN_PASS_DECL_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
#ifdef GEN_PASS_DEF_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncRuntimePolicyBasedRefCountingPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class AsyncRuntimePolicyBasedRefCountingPassBase : public ::mlir::OperationPass<> {
public:
  using Base = AsyncRuntimePolicyBasedRefCountingPassBase;

  AsyncRuntimePolicyBasedRefCountingPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  AsyncRuntimePolicyBasedRefCountingPassBase(const AsyncRuntimePolicyBasedRefCountingPassBase &other) : ::mlir::OperationPass<>(other) {}
  AsyncRuntimePolicyBasedRefCountingPassBase& operator=(const AsyncRuntimePolicyBasedRefCountingPassBase &) = delete;
  AsyncRuntimePolicyBasedRefCountingPassBase(AsyncRuntimePolicyBasedRefCountingPassBase &&) = delete;
  AsyncRuntimePolicyBasedRefCountingPassBase& operator=(AsyncRuntimePolicyBasedRefCountingPassBase &&) = delete;
  ~AsyncRuntimePolicyBasedRefCountingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("async-runtime-policy-based-ref-counting");
  }
  ::llvm::StringRef getArgument() const override { return "async-runtime-policy-based-ref-counting"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Policy based reference counting for Async runtime operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AsyncRuntimePolicyBasedRefCountingPass");
  }
  ::llvm::StringRef getName() const override { return "AsyncRuntimePolicyBasedRefCountingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<async::AsyncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AsyncRuntimePolicyBasedRefCountingPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createAsyncRuntimePolicyBasedRefCountingPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createAsyncRuntimePolicyBasedRefCountingPass() {
  return impl::createAsyncRuntimePolicyBasedRefCountingPass();
}
#undef GEN_PASS_DEF_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
#endif // GEN_PASS_DEF_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS

//===----------------------------------------------------------------------===//
// AsyncRuntimeRefCountingOptPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGOPTPASS
std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingOptPass();
#undef GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGOPTPASS
#endif // GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGOPTPASS
#ifdef GEN_PASS_DEF_ASYNCRUNTIMEREFCOUNTINGOPTPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingOptPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class AsyncRuntimeRefCountingOptPassBase : public ::mlir::OperationPass<> {
public:
  using Base = AsyncRuntimeRefCountingOptPassBase;

  AsyncRuntimeRefCountingOptPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  AsyncRuntimeRefCountingOptPassBase(const AsyncRuntimeRefCountingOptPassBase &other) : ::mlir::OperationPass<>(other) {}
  AsyncRuntimeRefCountingOptPassBase& operator=(const AsyncRuntimeRefCountingOptPassBase &) = delete;
  AsyncRuntimeRefCountingOptPassBase(AsyncRuntimeRefCountingOptPassBase &&) = delete;
  AsyncRuntimeRefCountingOptPassBase& operator=(AsyncRuntimeRefCountingOptPassBase &&) = delete;
  ~AsyncRuntimeRefCountingOptPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("async-runtime-ref-counting-opt");
  }
  ::llvm::StringRef getArgument() const override { return "async-runtime-ref-counting-opt"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Optimize automatic reference counting operations for theAsync runtime by removing redundant operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AsyncRuntimeRefCountingOptPass");
  }
  ::llvm::StringRef getName() const override { return "AsyncRuntimeRefCountingOptPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<async::AsyncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AsyncRuntimeRefCountingOptPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingOptPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingOptPass() {
  return impl::createAsyncRuntimeRefCountingOptPass();
}
#undef GEN_PASS_DEF_ASYNCRUNTIMEREFCOUNTINGOPTPASS
#endif // GEN_PASS_DEF_ASYNCRUNTIMEREFCOUNTINGOPTPASS

//===----------------------------------------------------------------------===//
// AsyncRuntimeRefCountingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGPASS
std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingPass();
#undef GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGPASS
#endif // GEN_PASS_DECL_ASYNCRUNTIMEREFCOUNTINGPASS
#ifdef GEN_PASS_DEF_ASYNCRUNTIMEREFCOUNTINGPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class AsyncRuntimeRefCountingPassBase : public ::mlir::OperationPass<> {
public:
  using Base = AsyncRuntimeRefCountingPassBase;

  AsyncRuntimeRefCountingPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  AsyncRuntimeRefCountingPassBase(const AsyncRuntimeRefCountingPassBase &other) : ::mlir::OperationPass<>(other) {}
  AsyncRuntimeRefCountingPassBase& operator=(const AsyncRuntimeRefCountingPassBase &) = delete;
  AsyncRuntimeRefCountingPassBase(AsyncRuntimeRefCountingPassBase &&) = delete;
  AsyncRuntimeRefCountingPassBase& operator=(AsyncRuntimeRefCountingPassBase &&) = delete;
  ~AsyncRuntimeRefCountingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("async-runtime-ref-counting");
  }
  ::llvm::StringRef getArgument() const override { return "async-runtime-ref-counting"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Automatic reference counting for Async runtime operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AsyncRuntimeRefCountingPass");
  }
  ::llvm::StringRef getName() const override { return "AsyncRuntimeRefCountingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<async::AsyncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AsyncRuntimeRefCountingPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createAsyncRuntimeRefCountingPass() {
  return impl::createAsyncRuntimeRefCountingPass();
}
#undef GEN_PASS_DEF_ASYNCRUNTIMEREFCOUNTINGPASS
#endif // GEN_PASS_DEF_ASYNCRUNTIMEREFCOUNTINGPASS

//===----------------------------------------------------------------------===//
// AsyncToAsyncRuntimePass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ASYNCTOASYNCRUNTIMEPASS
std::unique_ptr<::mlir::Pass> createAsyncToAsyncRuntimePass();
#undef GEN_PASS_DECL_ASYNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_DECL_ASYNCTOASYNCRUNTIMEPASS
#ifdef GEN_PASS_DEF_ASYNCTOASYNCRUNTIMEPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createAsyncToAsyncRuntimePass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class AsyncToAsyncRuntimePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = AsyncToAsyncRuntimePassBase;

  AsyncToAsyncRuntimePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  AsyncToAsyncRuntimePassBase(const AsyncToAsyncRuntimePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  AsyncToAsyncRuntimePassBase& operator=(const AsyncToAsyncRuntimePassBase &) = delete;
  AsyncToAsyncRuntimePassBase(AsyncToAsyncRuntimePassBase &&) = delete;
  AsyncToAsyncRuntimePassBase& operator=(AsyncToAsyncRuntimePassBase &&) = delete;
  ~AsyncToAsyncRuntimePassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("async-to-async-runtime");
  }
  ::llvm::StringRef getArgument() const override { return "async-to-async-runtime"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Lower all high level async operations (e.g. async.execute) tothe explicit async.runtime and async.coro operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AsyncToAsyncRuntimePass");
  }
  ::llvm::StringRef getName() const override { return "AsyncToAsyncRuntimePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<async::AsyncDialect>();
    registry.insert<func::FuncDialect>();
    registry.insert<cf::ControlFlowDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AsyncToAsyncRuntimePassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createAsyncToAsyncRuntimePass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createAsyncToAsyncRuntimePass() {
  return impl::createAsyncToAsyncRuntimePass();
}
#undef GEN_PASS_DEF_ASYNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_DEF_ASYNCTOASYNCRUNTIMEPASS
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_ASYNCFUNCTOASYNCRUNTIMEPASS
#define GEN_PASS_REGISTRATION_ASYNCPARALLELFORPASS
#define GEN_PASS_REGISTRATION_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
#define GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGOPTPASS
#define GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGPASS
#define GEN_PASS_REGISTRATION_ASYNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// AsyncFuncToAsyncRuntimePass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ASYNCFUNCTOASYNCRUNTIMEPASS

inline void registerAsyncFuncToAsyncRuntimePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncFuncToAsyncRuntimePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerAsyncFuncToAsyncRuntimePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncFuncToAsyncRuntimePass();
  });
}

#undef GEN_PASS_REGISTRATION_ASYNCFUNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_REGISTRATION_ASYNCFUNCTOASYNCRUNTIMEPASS

//===----------------------------------------------------------------------===//
// AsyncParallelForPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ASYNCPARALLELFORPASS

inline void registerAsyncParallelForPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncParallelForPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerAsyncParallelForPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncParallelForPass();
  });
}

#undef GEN_PASS_REGISTRATION_ASYNCPARALLELFORPASS
#endif // GEN_PASS_REGISTRATION_ASYNCPARALLELFORPASS

//===----------------------------------------------------------------------===//
// AsyncRuntimePolicyBasedRefCountingPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS

inline void registerAsyncRuntimePolicyBasedRefCountingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncRuntimePolicyBasedRefCountingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerAsyncRuntimePolicyBasedRefCountingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncRuntimePolicyBasedRefCountingPass();
  });
}

#undef GEN_PASS_REGISTRATION_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS
#endif // GEN_PASS_REGISTRATION_ASYNCRUNTIMEPOLICYBASEDREFCOUNTINGPASS

//===----------------------------------------------------------------------===//
// AsyncRuntimeRefCountingOptPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGOPTPASS

inline void registerAsyncRuntimeRefCountingOptPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncRuntimeRefCountingOptPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerAsyncRuntimeRefCountingOptPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncRuntimeRefCountingOptPass();
  });
}

#undef GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGOPTPASS
#endif // GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGOPTPASS

//===----------------------------------------------------------------------===//
// AsyncRuntimeRefCountingPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGPASS

inline void registerAsyncRuntimeRefCountingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncRuntimeRefCountingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerAsyncRuntimeRefCountingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncRuntimeRefCountingPass();
  });
}

#undef GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGPASS
#endif // GEN_PASS_REGISTRATION_ASYNCRUNTIMEREFCOUNTINGPASS

//===----------------------------------------------------------------------===//
// AsyncToAsyncRuntimePass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ASYNCTOASYNCRUNTIMEPASS

inline void registerAsyncToAsyncRuntimePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncToAsyncRuntimePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerAsyncToAsyncRuntimePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createAsyncToAsyncRuntimePass();
  });
}

#undef GEN_PASS_REGISTRATION_ASYNCTOASYNCRUNTIMEPASS
#endif // GEN_PASS_REGISTRATION_ASYNCTOASYNCRUNTIMEPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// Async Registration
//===----------------------------------------------------------------------===//

inline void registerAsyncPasses() {
  registerAsyncFuncToAsyncRuntimePass();
  registerAsyncParallelForPass();
  registerAsyncRuntimePolicyBasedRefCountingPass();
  registerAsyncRuntimeRefCountingOptPass();
  registerAsyncRuntimeRefCountingPass();
  registerAsyncToAsyncRuntimePass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
#ifdef GEN_PASS_CLASSES
#error "GEN_PASS_CLASSES is deprecated; use per-pass macros"
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
