'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');
const Element = require('./Element.cjs');

class SVGElement extends Element.Element {
  [constants.NS] = (() => constants.NamespaceURI.SVG)();
  get ownerSVGElement() {
    let root = null;
    let parent = this.parentNode;
    while (parent instanceof SVGElement) {
      root = parent;
      parent = parent.parentNode;
    }
    return root;
  }
}

exports.SVGElement = SVGElement;
