import { OWNER_DOCUMENT, NAME, PARENT, CHILD, PREV, NEXT, NamespaceURI, NodeType, HOOKS, IS_CONNECTED } from './constants.ts';
import type { Document } from './Document.ts';
import type { ParentNode } from './ParentNode.ts';
import { EventTarget } from './EventTarget.ts';
export declare class Node extends EventTarget {
    nodeType: NodeType;
    [OWNER_DOCUMENT]: Document;
    [NAME]: string;
    [PARENT]: ParentNode | null;
    [CHILD]: Node | null;
    [PREV]: Node | null;
    [NEXT]: Node | null;
    [IS_CONNECTED]: boolean;
    protected get [HOOKS](): Partial<import("./hooks.ts").Hooks>;
    get localName(): string;
    get nodeName(): string;
    get ownerDocument(): Document;
    get isConnected(): boolean;
    isDefaultNamespace(namespace: string): namespace is NamespaceURI.XHTML;
    get parentNode(): ParentNode | null;
    set parentNode(_readonly: ParentNode | null);
    get parentElement(): ParentNode | null;
    set parentElement(_readonly: ParentNode | null);
    get previousSibling(): Node | null;
    set previousSibling(_readonly: Node | null);
    get nextSibling(): Node | null;
    set nextSibling(_readonly: Node | null);
    get previousElementSibling(): Node | null;
    set previousElementSibling(_readonly: Node | null);
    get nextElementSibling(): Node | null;
    set nextElementSibling(_readonly: Node | null);
    get firstChild(): Node | null;
    set firstChild(_readonly: Node | null);
    get lastChild(): Node | null;
    set lastChild(_readonly: Node | null);
    get nodeValue(): string | null;
    set nodeValue(data: string | null | undefined);
    get textContent(): string | null;
    set textContent(data: any);
    cloneNode(deep?: boolean): Node;
    contains(node: Node | null): boolean;
}
//# sourceMappingURL=Node.d.ts.map