export interface EventTargetSignalOptions<Value = unknown, EventType = Event> {
    /**
     * The initial value of the signal.
     */
    initial?: Value;
    /**
     * The event name to listen for changes. The `detail` property of this event
     * will be used as the new value of the signal.
     * @default 'change'
     */
    event?: string;
    /**
     * An `AbortSignal` that, when aborted, will stop listening for events.
     */
    signal?: AbortSignal;
    /**
     * Controls the new value of the signal when the event is triggered.
     */
    value?(event: EventType): Value;
}
export declare function eventTargetSignal<Value = unknown, EventType = Event>(eventTarget: EventTarget, options?: EventTargetSignalOptions<Value, EventType>): EventTargetSignal<Value, EventType>;
export declare class EventTargetSignal<Value = unknown, EventType = Event> {
    #private;
    get value(): Value;
    peek(): Value;
    constructor(eventTarget: EventTarget, { initial, signal: abortSignal, event, value, }?: EventTargetSignalOptions<Value, EventType>);
}
//# sourceMappingURL=signals.d.ts.map