import { EmbeddedResource } from '@modelcontextprotocol/sdk/types.js';
import { ResourceContentType, UIActionResult } from '../types';
import { HTMLResourceRendererProps } from './HTMLResourceRenderer';
import { RemoteDOMResourceProps } from './RemoteDOMResourceRenderer';

export type UIResourceRendererProps = {
    resource: Partial<EmbeddedResource['resource']>;
    onUIAction?: (result: UIActionResult) => Promise<unknown>;
    supportedContentTypes?: ResourceContentType[];
    htmlProps?: Omit<HTMLResourceRendererProps, 'resource' | 'onUIAction'>;
    remoteDomProps?: Omit<RemoteDOMResourceProps, 'resource' | 'onUIAction'>;
};
export declare const UIResourceRenderer: {
    (props: UIResourceRendererProps): import("react/jsx-runtime").JSX.Element;
    displayName: string;
};
//# sourceMappingURL=UIResourceRenderer.d.ts.map