import { Event } from './Event.mjs';

class CustomEvent extends Event {
  /**
   * Returns any custom data event was created with. Typically used for synthetic events.
   *
   * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent/detail)
   */

  constructor(type, eventInitDict) {
    super(type, eventInitDict);
    this.detail = eventInitDict?.detail;
  }

  /**
   * Returns any custom data event was created with. Typically used for synthetic events.
   *
   * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent/detail)
   */
  initCustomEvent(type, bubbles, cancelable, detail) {
    super.initEvent(type, bubbles, cancelable);
    this.detail = detail;
  }
}

export { CustomEvent };
