'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const Document = require('./Document.cjs');
const Event = require('./Event.cjs');
const EventTarget = require('./EventTarget.cjs');
const CustomEvent = require('./CustomEvent.cjs');
const ErrorEvent = require('./ErrorEvent.cjs');
const PromiseRejectionEvent = require('./PromiseRejectionEvent.cjs');
const ToggleEvent = require('./ToggleEvent.cjs');
const FocusEvent = require('./FocusEvent.cjs');
const ClipboardEvent = require('./ClipboardEvent.cjs');
const Node = require('./Node.cjs');
const ParentNode = require('./ParentNode.cjs');
const ChildNode = require('./ChildNode.cjs');
const Element = require('./Element.cjs');
const HTMLElement = require('./HTMLElement.cjs');
const SVGElement = require('./SVGElement.cjs');
const CharacterData = require('./CharacterData.cjs');
const Text = require('./Text.cjs');
const Comment = require('./Comment.cjs');
const DocumentFragment = require('./DocumentFragment.cjs');
const HTMLTemplateElement = require('./HTMLTemplateElement.cjs');
const CustomElementRegistry = require('./CustomElementRegistry.cjs');
const MutationObserver = require('./MutationObserver.cjs');
const constants = require('./constants.cjs');

class Window extends EventTarget.EventTarget {
  [constants.HOOKS] = {};
  name = '';
  window = this;
  parent = this;
  self = this;
  top = this;
  document = (() => new Document.Document(this))();
  customElements = (() => new CustomElementRegistry.CustomElementRegistryImplementation())();
  location = (() => globalThis.location)();
  navigator = (() => globalThis.navigator)();
  Event = (() => Event.Event)();
  ErrorEvent = (() => ErrorEvent.ErrorEvent)();
  PromiseRejectionEvent = (() => PromiseRejectionEvent.PromiseRejectionEvent)();
  ToggleEvent = (() => ToggleEvent.ToggleEvent)();
  FocusEvent = (() => FocusEvent.FocusEvent)();
  ClipboardEvent = (() => ClipboardEvent.ClipboardEvent)();
  EventTarget = (() => EventTarget.EventTarget)();
  CustomEvent = (() => CustomEvent.CustomEvent)();
  Node = (() => Node.Node)();
  ParentNode = (() => ParentNode.ParentNode)();
  ChildNode = (() => ChildNode.ChildNode)();
  DocumentFragment = (() => DocumentFragment.DocumentFragment)();
  Document = (() => Document.Document)();
  CharacterData = (() => CharacterData.CharacterData)();
  Comment = (() => Comment.Comment)();
  Text = (() => Text.Text)();
  Element = (() => Element.Element)();
  HTMLElement = (() => HTMLElement.HTMLElement)();
  SVGElement = (() => SVGElement.SVGElement)();
  HTMLTemplateElement = (() => HTMLTemplateElement.HTMLTemplateElement)();
  MutationObserver = (() => MutationObserver.MutationObserver)();
  #currentOnErrorHandler = null;
  #currentOriginalOnErrorHandler = null;
  #currentOnUnhandledRejectionHandler = null;
  get onerror() {
    return this.#currentOriginalOnErrorHandler;
  }
  set onerror(handler) {
    if (this.#currentOnErrorHandler) {
      this.removeEventListener('error', this.#currentOnErrorHandler);
    }
    if (handler && typeof handler === 'function') {
      // the event listener version receives an event object
      // whereas winwow.onerror receives 5 arguments instead
      // we need to wrap the handler to convert the event object to the 5 arguments
      // and also make sure that when window.onerror is read to return the original handler
      // https://developer.mozilla.org/en-US/docs/Web/API/Window/error_event#syntax
      this.#currentOriginalOnErrorHandler = handler;
      this.#currentOnErrorHandler = event => {
        handler(event.message ?? 'Error', event.filename, event.lineno, event.colno, event.error);
      };
      this.addEventListener('error', this.#currentOnErrorHandler);
    } else {
      this.#currentOnErrorHandler = null;
      this.#currentOriginalOnErrorHandler = null;
    }
  }
  get onunhandledrejection() {
    return this.#currentOnUnhandledRejectionHandler;
  }
  set onunhandledrejection(handler) {
    if (this.#currentOnUnhandledRejectionHandler) {
      this.removeEventListener('unhandledrejection', this.#currentOnUnhandledRejectionHandler);
    }
    if (handler && typeof handler === 'function') {
      this.#currentOnUnhandledRejectionHandler = handler;
      this.addEventListener('unhandledrejection', this.#currentOnUnhandledRejectionHandler);
    } else {
      this.#currentOnUnhandledRejectionHandler = null;
    }
  }
  static setGlobal(window) {
    const properties = Object.getOwnPropertyDescriptors(window);
    delete properties.self;
    Object.defineProperties(globalThis, properties);
    if (typeof globalThis.self === 'undefined') {
      Object.defineProperty(globalThis, 'self', {
        value: window,
        configurable: true,
        writable: true,
        enumerable: true
      });
    } else {
      // There can already be a `self`, like when polyfilling the DOM
      // in a Web Worker. In those cases, just mirror all the `Window`
      // properties onto `self`, rather than wholly redefining it.
      Object.defineProperties(self, properties);
    }
  }
  static setGlobalThis(window) {
    for (const property in window) {
      if (window[property] === window) {
        window[property] = globalThis;
      }
    }
    const properties = Object.getOwnPropertyDescriptors(window);
    const eventTargetPrototypeProperties = Object.getOwnPropertyDescriptors(EventTarget.EventTarget.prototype);
    for (const descriptor of Object.values(eventTargetPrototypeProperties)) {
      if (typeof descriptor.value === 'function') {
        descriptor.value = descriptor.value.bind(window);
      }
    }
    Object.defineProperties(globalThis, properties);
    Object.defineProperties(globalThis, eventTargetPrototypeProperties);
  }
}

exports.Window = Window;
