import { MUTATION_TYPE_INSERT_CHILD, MUTATION_TYPE_REMOVE_CHILD, MUTATION_TYPE_UPDATE_TEXT, MUTATION_TYPE_UPDATE_PROPERTY } from './constants.mjs';

/**
 * A helper for creating a `RemoteConnection` object. The `RemoteConnection`
 * protocol is pretty low-level; this function provides more human-friendly
 * naming on top of the protocol.
 */
function createRemoteConnection({
  call,
  insertChild,
  removeChild,
  updateText,
  updateProperty
}) {
  const handlers = {
    [MUTATION_TYPE_INSERT_CHILD]: insertChild,
    [MUTATION_TYPE_REMOVE_CHILD]: removeChild,
    [MUTATION_TYPE_UPDATE_TEXT]: updateText,
    [MUTATION_TYPE_UPDATE_PROPERTY]: updateProperty
  };
  return {
    call,
    mutate(records) {
      for (const [type, ...args] of records) {
        handlers[type](...args);
      }
    }
  };
}

export { createRemoteConnection };
