import type { RemoteConnection, RemoteNodeSerialization } from '../types.ts';
export declare const REMOTE_CONNECTIONS: WeakMap<Node, RemoteConnection>;
/**
 * Gets the `RemoteConnection` instance that a node is connected to. If the node
 * is not connected to a remote root, this method returns `undefined`.
 */
export declare function remoteConnection(node: Node): RemoteConnection | undefined;
export declare const REMOTE_IDS: WeakMap<Node, string>;
/**
 * Gets the unique identifier representing a node. If the node does not have
 * a unique identifier, one is created and assigned when calling this method.
 */
export declare function remoteId(node: Node): string;
export declare function setRemoteId(node: Node, id: string): void;
export declare const REMOTE_PROPERTIES: WeakMap<Node, Record<string, any>>;
/**
 * Gets the remote properties of an element node. If the node is not an element
 * node, this method returns `undefined`, or if it does not have any remote properties,
 * it will return undefined.
 */
export declare function remoteProperties(node: Node): Record<string, any> | undefined;
export declare const REMOTE_ATTRIBUTES: WeakMap<Node, Record<string, string>>;
/**
 * Gets the remote attributes of an element node. If the node is not an element
 * node, this method returns `undefined`. If the element does not have any remote
 * attributes explicitly defined, this method will instead return the `attributes`
 * of the element, converted into a simple object form. This makes it easy for you
 * to represent “standard” HTML elements, such as `<div>` or `<span>`, as remote
 * elements.
 */
export declare function remoteAttributes(node: Node): Record<string, string> | undefined;
export declare const REMOTE_EVENT_LISTENERS: WeakMap<Node, Record<string, (...args: any) => void>>;
/**
 * Gets the remote event listeners of an element node. If the node is not an element
 * node, or does not have explicitly defined remote event listeners, this method returns
 * `undefined`.
 */
export declare function remoteEventListeners(node: Node): Record<string, (...args: any) => void> | undefined;
/**
 * Updates a single remote property on an element node. If the element is
 * connected to a remote root, this function will also make a `mutate()` call
 * to communicate the change to the host.
 */
export declare function updateRemoteElementProperty(node: Element, property: string, value: unknown): void;
/**
 * Updates a single remote attribute on an element node. If the element is
 * connected to a remote root, this function will also make a `mutate()` call
 * to communicate the change to the host.
 */
export declare function updateRemoteElementAttribute(node: Element, attribute: string, value?: string): void;
/**
 * Updates a single remote event listener on an element node. If the element is
 * connected to a remote root, this function will also make a `mutate()` call
 * to communicate the change to the host.
 */
export declare function updateRemoteElementEventListener(node: Element, event: string, listener?: (...args: any[]) => any): void;
/**
 * Connects a node to a `RemoteConnection` instance. Any future updates to this node
 * will be communicated to the host by way of this connection.
 */
export declare function connectRemoteNode(node: Node, connection: RemoteConnection): void;
/**
 * Disconnects a node from its `RemoteConnection` instance. Future updates to this
 * this element will not be communicated to a host, until you call `connectRemoteNode` again.
 */
export declare function disconnectRemoteNode(node: Node): void;
/**
 * Converts an HTML Node into a simple JavaScript object, in the shape that
 * `RemoteConnection.mutate()` expects to receive.
 */
export declare function serializeRemoteNode(node: Node): RemoteNodeSerialization;
/**
 * Performs a method through `RemoteConnection.call()`, using the remote ID and
 * connection for the provided node.
 */
export declare function callRemoteElementMethod(node: Element, method: string, ...args: unknown[]): unknown;
//# sourceMappingURL=internals.d.ts.map