import { renderRemoteNode } from './node.mjs';
import { useRemoteReceived } from './hooks/remote-received.mjs';
import { jsx, Fragment } from 'react/jsx-runtime';

/**
 * A component that can be used to render a list of children elements, without any
 * additional wrapping elements. This is typically used on the host to render the `remote-root`
 * element, which is a special element rendered by Remote DOM to translate between React
 * elements passed as properties and slotted elements.
 */
const RemoteFragmentRenderer = function RemoteFragmentRenderer({
  element,
  receiver,
  components
}) {
  const fragments = useRemoteReceived(element, receiver);
  if (!fragments) return null;
  const renderOptions = {
    receiver,
    components
  };
  return /*#__PURE__*/jsx(Fragment, {
    children: fragments.children.map(child => renderRemoteNode(child, renderOptions))
  });
};

export { RemoteFragmentRenderer };
