'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const receivers = require('@remote-dom/core/receivers');
const node = require('./host/node.cjs');
const component = require('./host/component.cjs');
const RemoteFragmentRenderer = require('./host/RemoteFragmentRenderer.cjs');
const RemoteTextRenderer = require('./host/RemoteTextRenderer.cjs');
const RemoteRootRenderer = require('./host/RemoteRootRenderer.cjs');
const remoteReceived = require('./host/hooks/remote-received.cjs');
const propsForElement = require('./host/hooks/props-for-element.cjs');
const constants = require('./host/constants.cjs');



Object.defineProperty(exports, "RemoteReceiver", {
  enumerable: true,
  get: () => receivers.RemoteReceiver
});
exports.renderRemoteNode = node.renderRemoteNode;
exports.createRemoteComponentRenderer = component.createRemoteComponentRenderer;
exports.RemoteFragmentRenderer = RemoteFragmentRenderer.RemoteFragmentRenderer;
exports.RemoteTextRenderer = RemoteTextRenderer.RemoteTextRenderer;
exports.RemoteRootRenderer = RemoteRootRenderer.RemoteRootRenderer;
exports.useRemoteReceived = remoteReceived.useRemoteReceived;
exports.usePropsForRemoteElement = propsForElement.usePropsForRemoteElement;
exports.REMOTE_ELEMENT_ATTACHED_PROP = constants.REMOTE_ELEMENT_ATTACHED_PROP;
exports.REMOTE_ELEMENT_PROP = constants.REMOTE_ELEMENT_PROP;
