'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const Event = require('./Event.cjs');

//https://html.spec.whatwg.org/multipage/webappapis.html#promiserejectionevent
class PromiseRejectionEvent extends Event.Event {
  constructor(type, eventInitDict) {
    super(type, eventInitDict);
    this.promise = eventInitDict.promise;
    this.reason = eventInitDict.reason;
  }
}

exports.PromiseRejectionEvent = PromiseRejectionEvent;
