/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 * 
 * Filename:      utf8converter.hpp
 * Description:   definition of the UTF8Converter class
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/
#ifndef UTF8CONVERTER_HPP
#define UTF8CONVERTER_HPP

#include <string>
#include <iconv.h>
#include <langinfo.h>

using namespace std;

class UTF8Converter 
{
 private:
    iconv_t _toutf8;
    iconv_t _fromutf8;
    string _charset;
 public:
    UTF8Converter()
    {
        // create iconv_t's according to current locale
        _charset = nl_langinfo(CODESET);
        _fromutf8 = iconv_open(_charset.c_str(), "UTF-8");
        _toutf8 = iconv_open("UTF-8", _charset.c_str());
    }
    UTF8Converter(const string& other) 
    {
        // create iconv_t's with other charset?
        _charset = other;
        _fromutf8 = iconv_open(_charset.c_str(), "UTF-8");
        _toutf8 = iconv_open("UTF-8", _charset.c_str());
    }
    ~UTF8Converter()
    {
        // delete iconv_t's
        iconv_close(_fromutf8);
        iconv_close(_toutf8);
    }
    const string& charset()
    {
        return _charset;
    }
    int fromUTF8(const string&, string&);
    int toUTF8(const string&, string&);
};

#endif
