
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/libnickTargets.cmake")
include(CMakeFindDependencyMacro)

if(APPLE)
    option(USE_LIBSECRET "Use libsecret on macOS instead of Apple keychain" OFF)
endif()

if(DEFINED ENV{VCPKG_ROOT})
    file(TO_CMAKE_PATH $ENV{VCPKG_ROOT} VCPKG_ROOT)
    if(EXISTS "${VCPKG_ROOT}/scripts/buildsystems/vcpkg.cmake")
        set(USING_VCPKG ON)
    endif()
endif()

find_dependency(Boost REQUIRED COMPONENTS json)
find_dependency(CURL REQUIRED)
find_dependency(Intl REQUIRED)
if(USING_VCPKG)
    find_dependency(unofficial-maddy REQUIRED)
endif()
if(WIN32)
    find_dependency(sqlcipher CONFIG REQUIRED)
elseif(APPLE)
    find_library(CF_LIBRARY CoreFoundation)
    find_library(CS_LIBRARY CoreServices)
    find_library(IOKIT_LIBRARY IOKit)
    find_dependency(Threads REQUIRED)
    find_dependency(OpenSSL REQUIRED)
    find_dependency(PkgConfig REQUIRED)
    pkg_check_modules(glib REQUIRED IMPORTED_TARGET glib-2.0)
    pkg_check_modules(gio REQUIRED IMPORTED_TARGET gio-2.0)
    pkg_check_modules(gmodule REQUIRED IMPORTED_TARGET gmodule-2.0)
    pkg_check_modules(gobject REQUIRED IMPORTED_TARGET gobject-2.0)
    pkg_check_modules(gthread REQUIRED IMPORTED_TARGET gthread-2.0)
    if(USE_LIBSECRET)
        pkg_check_modules(libsecret REQUIRED IMPORTED_TARGET libsecret-1)
    else()
        find_library(SECURITY_LIBRARY Security)
    endif()
else()
    find_dependency(Threads REQUIRED)
    find_dependency(OpenSSL REQUIRED)
    find_dependency(PkgConfig REQUIRED)
    pkg_check_modules(glib REQUIRED IMPORTED_TARGET glib-2.0)
    pkg_check_modules(gio REQUIRED IMPORTED_TARGET gio-2.0)
    pkg_check_modules(gmodule REQUIRED IMPORTED_TARGET gmodule-2.0)
    pkg_check_modules(gobject REQUIRED IMPORTED_TARGET gobject-2.0)
    pkg_check_modules(gthread REQUIRED IMPORTED_TARGET gthread-2.0)
    pkg_check_modules(libsecret REQUIRED IMPORTED_TARGET libsecret-1)
endif()

check_required_components(libnick)
