/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PLMAINTAINERSMARKERMODIFIER_H
#define _PLMAINTAINERSMARKERMODIFIER_H

#include "plModifier.h"

class HSPLASMA_EXPORT plMaintainersMarkerModifier : public plMultiModifier
{
    CREATABLE(plMaintainersMarkerModifier, kMaintainersMarkerModifier,
              plMultiModifier)

public:
    enum { kBroken, kRepaired, kCalibrated, kNumCalibratedLevels };

private:
    unsigned int fCalibrated;

public:
    plMaintainersMarkerModifier() : fCalibrated(kBroken) { }

    void read(hsStream* S, plResManager* mgr) HS_OVERRIDE;
    void write(hsStream* S, plResManager* mgr) HS_OVERRIDE;

protected:
    void IPrcWrite(pfPrcHelper* prc) HS_OVERRIDE;
    void IPrcParse(const pfPrcTag* tag, plResManager* mgr) HS_OVERRIDE;

public:
    unsigned int getCalibration() const { return fCalibrated; }
    void setCalibration(unsigned int cal) { fCalibrated = cal; }
};

#endif
