/*
 * Definitions for libcfile
 *
 * Copyright (C) 2008-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBCFILE_DEFINITIONS_H )
#define _LIBCFILE_DEFINITIONS_H

#include <libcfile/types.h>

#define LIBCFILE_VERSION			20220106

/* The libcfile version string
 */
#define LIBCFILE_VERSION_STRING			"20220106"

/* The file access flags
 * bit 1					set to 1 for read access
 * bit 2					set to 1 for write access
 * bit 3					set to 1 to truncate an existing file on write
 * bit 4-8					not used
 */
enum LIBCFILE_ACCESS_FLAGS
{
	LIBCFILE_ACCESS_FLAG_READ		= 0x01,
	LIBCFILE_ACCESS_FLAG_WRITE		= 0x02,
	LIBCFILE_ACCESS_FLAG_TRUNCATE		= 0x04
};

/* The file access macros
 */
#define LIBCFILE_OPEN_READ			( LIBCFILE_ACCESS_FLAG_READ )
#define LIBCFILE_OPEN_WRITE			( LIBCFILE_ACCESS_FLAG_WRITE )
#define LIBCFILE_OPEN_READ_WRITE		( LIBCFILE_ACCESS_FLAG_READ | LIBCFILE_ACCESS_FLAG_WRITE )
#define LIBCFILE_OPEN_WRITE_TRUNCATE		( LIBCFILE_ACCESS_FLAG_WRITE | LIBCFILE_ACCESS_FLAG_TRUNCATE )
#define LIBCFILE_OPEN_READ_WRITE_TRUNCATE	( LIBCFILE_ACCESS_FLAG_READ | LIBCFILE_ACCESS_FLAG_WRITE | LIBCFILE_ACCESS_FLAG_TRUNCATE )

/* The access behavior types
 */
enum LIBCFILE_ACCESS_BEHAVIOR
{
	LIBCFILE_ACCESS_BEHAVIOR_NORMAL,
	LIBCFILE_ACCESS_BEHAVIOR_RANDOM,
	LIBCFILE_ACCESS_BEHAVIOR_SEQUENTIAL
};

#endif /* !defined( _LIBCFILE_DEFINITIONS_H ) */

