/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_12_H
#define LEXBOR_UNICODE_TABLES_12_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F900 = {.cps = (lxb_codepoint_t[]) {0x8C48}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F901 = {.cps = (lxb_codepoint_t[]) {0x66F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F902 = {.cps = (lxb_codepoint_t[]) {0x8ECA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F903 = {.cps = (lxb_codepoint_t[]) {0x8CC8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F904 = {.cps = (lxb_codepoint_t[]) {0x6ED1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F905 = {.cps = (lxb_codepoint_t[]) {0x4E32}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F906 = {.cps = (lxb_codepoint_t[]) {0x53E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F907 = {.cps = (lxb_codepoint_t[]) {0x9F9C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F908 = {.cps = (lxb_codepoint_t[]) {0x9F9C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F909 = {.cps = (lxb_codepoint_t[]) {0x5951}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F90A = {.cps = (lxb_codepoint_t[]) {0x91D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F90B = {.cps = (lxb_codepoint_t[]) {0x5587}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F90C = {.cps = (lxb_codepoint_t[]) {0x5948}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F90D = {.cps = (lxb_codepoint_t[]) {0x61F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F90E = {.cps = (lxb_codepoint_t[]) {0x7669}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F90F = {.cps = (lxb_codepoint_t[]) {0x7F85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F910 = {.cps = (lxb_codepoint_t[]) {0x863F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F911 = {.cps = (lxb_codepoint_t[]) {0x87BA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F912 = {.cps = (lxb_codepoint_t[]) {0x88F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F913 = {.cps = (lxb_codepoint_t[]) {0x908F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F914 = {.cps = (lxb_codepoint_t[]) {0x6A02}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F915 = {.cps = (lxb_codepoint_t[]) {0x6D1B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F916 = {.cps = (lxb_codepoint_t[]) {0x70D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F917 = {.cps = (lxb_codepoint_t[]) {0x73DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F918 = {.cps = (lxb_codepoint_t[]) {0x843D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F919 = {.cps = (lxb_codepoint_t[]) {0x916A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F91A = {.cps = (lxb_codepoint_t[]) {0x99F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F91B = {.cps = (lxb_codepoint_t[]) {0x4E82}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F91C = {.cps = (lxb_codepoint_t[]) {0x5375}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F91D = {.cps = (lxb_codepoint_t[]) {0x6B04}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F91E = {.cps = (lxb_codepoint_t[]) {0x721B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F91F = {.cps = (lxb_codepoint_t[]) {0x862D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F920 = {.cps = (lxb_codepoint_t[]) {0x9E1E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F921 = {.cps = (lxb_codepoint_t[]) {0x5D50}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F922 = {.cps = (lxb_codepoint_t[]) {0x6FEB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F923 = {.cps = (lxb_codepoint_t[]) {0x85CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F924 = {.cps = (lxb_codepoint_t[]) {0x8964}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F925 = {.cps = (lxb_codepoint_t[]) {0x62C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F926 = {.cps = (lxb_codepoint_t[]) {0x81D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F927 = {.cps = (lxb_codepoint_t[]) {0x881F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F928 = {.cps = (lxb_codepoint_t[]) {0x5ECA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F929 = {.cps = (lxb_codepoint_t[]) {0x6717}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F92A = {.cps = (lxb_codepoint_t[]) {0x6D6A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F92B = {.cps = (lxb_codepoint_t[]) {0x72FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F92C = {.cps = (lxb_codepoint_t[]) {0x90CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F92D = {.cps = (lxb_codepoint_t[]) {0x4F86}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F92E = {.cps = (lxb_codepoint_t[]) {0x51B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F92F = {.cps = (lxb_codepoint_t[]) {0x52DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F930 = {.cps = (lxb_codepoint_t[]) {0x64C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F931 = {.cps = (lxb_codepoint_t[]) {0x6AD3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F932 = {.cps = (lxb_codepoint_t[]) {0x7210}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F933 = {.cps = (lxb_codepoint_t[]) {0x76E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F934 = {.cps = (lxb_codepoint_t[]) {0x8001}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F935 = {.cps = (lxb_codepoint_t[]) {0x8606}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F936 = {.cps = (lxb_codepoint_t[]) {0x865C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F937 = {.cps = (lxb_codepoint_t[]) {0x8DEF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F938 = {.cps = (lxb_codepoint_t[]) {0x9732}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F939 = {.cps = (lxb_codepoint_t[]) {0x9B6F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F93A = {.cps = (lxb_codepoint_t[]) {0x9DFA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F93B = {.cps = (lxb_codepoint_t[]) {0x788C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F93C = {.cps = (lxb_codepoint_t[]) {0x797F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F93D = {.cps = (lxb_codepoint_t[]) {0x7DA0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F93E = {.cps = (lxb_codepoint_t[]) {0x83C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F93F = {.cps = (lxb_codepoint_t[]) {0x9304}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F940 = {.cps = (lxb_codepoint_t[]) {0x9E7F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F941 = {.cps = (lxb_codepoint_t[]) {0x8AD6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F942 = {.cps = (lxb_codepoint_t[]) {0x58DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F943 = {.cps = (lxb_codepoint_t[]) {0x5F04}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F944 = {.cps = (lxb_codepoint_t[]) {0x7C60}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F945 = {.cps = (lxb_codepoint_t[]) {0x807E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F946 = {.cps = (lxb_codepoint_t[]) {0x7262}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F947 = {.cps = (lxb_codepoint_t[]) {0x78CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F948 = {.cps = (lxb_codepoint_t[]) {0x8CC2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F949 = {.cps = (lxb_codepoint_t[]) {0x96F7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F94A = {.cps = (lxb_codepoint_t[]) {0x58D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F94B = {.cps = (lxb_codepoint_t[]) {0x5C62}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F94C = {.cps = (lxb_codepoint_t[]) {0x6A13}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F94D = {.cps = (lxb_codepoint_t[]) {0x6DDA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F94E = {.cps = (lxb_codepoint_t[]) {0x6F0F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F94F = {.cps = (lxb_codepoint_t[]) {0x7D2F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F950 = {.cps = (lxb_codepoint_t[]) {0x7E37}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F951 = {.cps = (lxb_codepoint_t[]) {0x964B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F952 = {.cps = (lxb_codepoint_t[]) {0x52D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F953 = {.cps = (lxb_codepoint_t[]) {0x808B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F954 = {.cps = (lxb_codepoint_t[]) {0x51DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F955 = {.cps = (lxb_codepoint_t[]) {0x51CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F956 = {.cps = (lxb_codepoint_t[]) {0x7A1C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F957 = {.cps = (lxb_codepoint_t[]) {0x7DBE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F958 = {.cps = (lxb_codepoint_t[]) {0x83F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F959 = {.cps = (lxb_codepoint_t[]) {0x9675}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F95A = {.cps = (lxb_codepoint_t[]) {0x8B80}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F95B = {.cps = (lxb_codepoint_t[]) {0x62CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F95C = {.cps = (lxb_codepoint_t[]) {0x6A02}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F95D = {.cps = (lxb_codepoint_t[]) {0x8AFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F95E = {.cps = (lxb_codepoint_t[]) {0x4E39}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F95F = {.cps = (lxb_codepoint_t[]) {0x5BE7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F960 = {.cps = (lxb_codepoint_t[]) {0x6012}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F961 = {.cps = (lxb_codepoint_t[]) {0x7387}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F962 = {.cps = (lxb_codepoint_t[]) {0x7570}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F963 = {.cps = (lxb_codepoint_t[]) {0x5317}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F964 = {.cps = (lxb_codepoint_t[]) {0x78FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F965 = {.cps = (lxb_codepoint_t[]) {0x4FBF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F966 = {.cps = (lxb_codepoint_t[]) {0x5FA9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F967 = {.cps = (lxb_codepoint_t[]) {0x4E0D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F968 = {.cps = (lxb_codepoint_t[]) {0x6CCC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F969 = {.cps = (lxb_codepoint_t[]) {0x6578}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F96A = {.cps = (lxb_codepoint_t[]) {0x7D22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F96B = {.cps = (lxb_codepoint_t[]) {0x53C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F96C = {.cps = (lxb_codepoint_t[]) {0x585E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F96D = {.cps = (lxb_codepoint_t[]) {0x7701}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F96E = {.cps = (lxb_codepoint_t[]) {0x8449}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F96F = {.cps = (lxb_codepoint_t[]) {0x8AAA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F970 = {.cps = (lxb_codepoint_t[]) {0x6BBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F971 = {.cps = (lxb_codepoint_t[]) {0x8FB0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F972 = {.cps = (lxb_codepoint_t[]) {0x6C88}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F973 = {.cps = (lxb_codepoint_t[]) {0x62FE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F974 = {.cps = (lxb_codepoint_t[]) {0x82E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F975 = {.cps = (lxb_codepoint_t[]) {0x63A0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F976 = {.cps = (lxb_codepoint_t[]) {0x7565}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F977 = {.cps = (lxb_codepoint_t[]) {0x4EAE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F978 = {.cps = (lxb_codepoint_t[]) {0x5169}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F979 = {.cps = (lxb_codepoint_t[]) {0x51C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F97A = {.cps = (lxb_codepoint_t[]) {0x6881}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F97B = {.cps = (lxb_codepoint_t[]) {0x7CE7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F97C = {.cps = (lxb_codepoint_t[]) {0x826F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F97D = {.cps = (lxb_codepoint_t[]) {0x8AD2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F97E = {.cps = (lxb_codepoint_t[]) {0x91CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F97F = {.cps = (lxb_codepoint_t[]) {0x52F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F980 = {.cps = (lxb_codepoint_t[]) {0x5442}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F981 = {.cps = (lxb_codepoint_t[]) {0x5973}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F982 = {.cps = (lxb_codepoint_t[]) {0x5EEC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F983 = {.cps = (lxb_codepoint_t[]) {0x65C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F984 = {.cps = (lxb_codepoint_t[]) {0x6FFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F985 = {.cps = (lxb_codepoint_t[]) {0x792A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F986 = {.cps = (lxb_codepoint_t[]) {0x95AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F987 = {.cps = (lxb_codepoint_t[]) {0x9A6A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F988 = {.cps = (lxb_codepoint_t[]) {0x9E97}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F989 = {.cps = (lxb_codepoint_t[]) {0x9ECE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F98A = {.cps = (lxb_codepoint_t[]) {0x529B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F98B = {.cps = (lxb_codepoint_t[]) {0x66C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F98C = {.cps = (lxb_codepoint_t[]) {0x6B77}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F98D = {.cps = (lxb_codepoint_t[]) {0x8F62}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F98E = {.cps = (lxb_codepoint_t[]) {0x5E74}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F98F = {.cps = (lxb_codepoint_t[]) {0x6190}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F990 = {.cps = (lxb_codepoint_t[]) {0x6200}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F991 = {.cps = (lxb_codepoint_t[]) {0x649A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F992 = {.cps = (lxb_codepoint_t[]) {0x6F23}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F993 = {.cps = (lxb_codepoint_t[]) {0x7149}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F994 = {.cps = (lxb_codepoint_t[]) {0x7489}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F995 = {.cps = (lxb_codepoint_t[]) {0x79CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F996 = {.cps = (lxb_codepoint_t[]) {0x7DF4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F997 = {.cps = (lxb_codepoint_t[]) {0x806F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F998 = {.cps = (lxb_codepoint_t[]) {0x8F26}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F999 = {.cps = (lxb_codepoint_t[]) {0x84EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F99A = {.cps = (lxb_codepoint_t[]) {0x9023}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F99B = {.cps = (lxb_codepoint_t[]) {0x934A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F99C = {.cps = (lxb_codepoint_t[]) {0x5217}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F99D = {.cps = (lxb_codepoint_t[]) {0x52A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F99E = {.cps = (lxb_codepoint_t[]) {0x54BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F99F = {.cps = (lxb_codepoint_t[]) {0x70C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A0 = {.cps = (lxb_codepoint_t[]) {0x88C2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A1 = {.cps = (lxb_codepoint_t[]) {0x8AAA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A2 = {.cps = (lxb_codepoint_t[]) {0x5EC9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A3 = {.cps = (lxb_codepoint_t[]) {0x5FF5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A4 = {.cps = (lxb_codepoint_t[]) {0x637B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A5 = {.cps = (lxb_codepoint_t[]) {0x6BAE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A6 = {.cps = (lxb_codepoint_t[]) {0x7C3E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A7 = {.cps = (lxb_codepoint_t[]) {0x7375}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A8 = {.cps = (lxb_codepoint_t[]) {0x4EE4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9A9 = {.cps = (lxb_codepoint_t[]) {0x56F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9AA = {.cps = (lxb_codepoint_t[]) {0x5BE7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9AB = {.cps = (lxb_codepoint_t[]) {0x5DBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9AC = {.cps = (lxb_codepoint_t[]) {0x601C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9AD = {.cps = (lxb_codepoint_t[]) {0x73B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9AE = {.cps = (lxb_codepoint_t[]) {0x7469}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9AF = {.cps = (lxb_codepoint_t[]) {0x7F9A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B0 = {.cps = (lxb_codepoint_t[]) {0x8046}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B1 = {.cps = (lxb_codepoint_t[]) {0x9234}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B2 = {.cps = (lxb_codepoint_t[]) {0x96F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B3 = {.cps = (lxb_codepoint_t[]) {0x9748}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B4 = {.cps = (lxb_codepoint_t[]) {0x9818}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B5 = {.cps = (lxb_codepoint_t[]) {0x4F8B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B6 = {.cps = (lxb_codepoint_t[]) {0x79AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B7 = {.cps = (lxb_codepoint_t[]) {0x91B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B8 = {.cps = (lxb_codepoint_t[]) {0x96B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9B9 = {.cps = (lxb_codepoint_t[]) {0x60E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9BA = {.cps = (lxb_codepoint_t[]) {0x4E86}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9BB = {.cps = (lxb_codepoint_t[]) {0x50DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9BC = {.cps = (lxb_codepoint_t[]) {0x5BEE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9BD = {.cps = (lxb_codepoint_t[]) {0x5C3F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9BE = {.cps = (lxb_codepoint_t[]) {0x6599}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9BF = {.cps = (lxb_codepoint_t[]) {0x6A02}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C0 = {.cps = (lxb_codepoint_t[]) {0x71CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C1 = {.cps = (lxb_codepoint_t[]) {0x7642}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C2 = {.cps = (lxb_codepoint_t[]) {0x84FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C3 = {.cps = (lxb_codepoint_t[]) {0x907C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C4 = {.cps = (lxb_codepoint_t[]) {0x9F8D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C5 = {.cps = (lxb_codepoint_t[]) {0x6688}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C6 = {.cps = (lxb_codepoint_t[]) {0x962E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C7 = {.cps = (lxb_codepoint_t[]) {0x5289}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C8 = {.cps = (lxb_codepoint_t[]) {0x677B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9C9 = {.cps = (lxb_codepoint_t[]) {0x67F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9CA = {.cps = (lxb_codepoint_t[]) {0x6D41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9CB = {.cps = (lxb_codepoint_t[]) {0x6E9C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9CC = {.cps = (lxb_codepoint_t[]) {0x7409}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9CD = {.cps = (lxb_codepoint_t[]) {0x7559}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9CE = {.cps = (lxb_codepoint_t[]) {0x786B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9CF = {.cps = (lxb_codepoint_t[]) {0x7D10}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D0 = {.cps = (lxb_codepoint_t[]) {0x985E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D1 = {.cps = (lxb_codepoint_t[]) {0x516D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D2 = {.cps = (lxb_codepoint_t[]) {0x622E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D3 = {.cps = (lxb_codepoint_t[]) {0x9678}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D4 = {.cps = (lxb_codepoint_t[]) {0x502B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D5 = {.cps = (lxb_codepoint_t[]) {0x5D19}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D6 = {.cps = (lxb_codepoint_t[]) {0x6DEA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D7 = {.cps = (lxb_codepoint_t[]) {0x8F2A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D8 = {.cps = (lxb_codepoint_t[]) {0x5F8B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9D9 = {.cps = (lxb_codepoint_t[]) {0x6144}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9DA = {.cps = (lxb_codepoint_t[]) {0x6817}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9DB = {.cps = (lxb_codepoint_t[]) {0x7387}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9DC = {.cps = (lxb_codepoint_t[]) {0x9686}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9DD = {.cps = (lxb_codepoint_t[]) {0x5229}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9DE = {.cps = (lxb_codepoint_t[]) {0x540F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9DF = {.cps = (lxb_codepoint_t[]) {0x5C65}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E0 = {.cps = (lxb_codepoint_t[]) {0x6613}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E1 = {.cps = (lxb_codepoint_t[]) {0x674E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E2 = {.cps = (lxb_codepoint_t[]) {0x68A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E3 = {.cps = (lxb_codepoint_t[]) {0x6CE5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E4 = {.cps = (lxb_codepoint_t[]) {0x7406}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E5 = {.cps = (lxb_codepoint_t[]) {0x75E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E6 = {.cps = (lxb_codepoint_t[]) {0x7F79}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E7 = {.cps = (lxb_codepoint_t[]) {0x88CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E8 = {.cps = (lxb_codepoint_t[]) {0x88E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9E9 = {.cps = (lxb_codepoint_t[]) {0x91CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9EA = {.cps = (lxb_codepoint_t[]) {0x96E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9EB = {.cps = (lxb_codepoint_t[]) {0x533F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9EC = {.cps = (lxb_codepoint_t[]) {0x6EBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9ED = {.cps = (lxb_codepoint_t[]) {0x541D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9EE = {.cps = (lxb_codepoint_t[]) {0x71D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9EF = {.cps = (lxb_codepoint_t[]) {0x7498}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F0 = {.cps = (lxb_codepoint_t[]) {0x85FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F1 = {.cps = (lxb_codepoint_t[]) {0x96A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F2 = {.cps = (lxb_codepoint_t[]) {0x9C57}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F3 = {.cps = (lxb_codepoint_t[]) {0x9E9F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F4 = {.cps = (lxb_codepoint_t[]) {0x6797}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F5 = {.cps = (lxb_codepoint_t[]) {0x6DCB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F6 = {.cps = (lxb_codepoint_t[]) {0x81E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F7 = {.cps = (lxb_codepoint_t[]) {0x7ACB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F8 = {.cps = (lxb_codepoint_t[]) {0x7B20}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9F9 = {.cps = (lxb_codepoint_t[]) {0x7C92}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9FA = {.cps = (lxb_codepoint_t[]) {0x72C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9FB = {.cps = (lxb_codepoint_t[]) {0x7099}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9FC = {.cps = (lxb_codepoint_t[]) {0x8B58}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9FD = {.cps = (lxb_codepoint_t[]) {0x4EC0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9FE = {.cps = (lxb_codepoint_t[]) {0x8336}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_F9FF = {.cps = (lxb_codepoint_t[]) {0x523A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA00 = {.cps = (lxb_codepoint_t[]) {0x5207}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA01 = {.cps = (lxb_codepoint_t[]) {0x5EA6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA02 = {.cps = (lxb_codepoint_t[]) {0x62D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA03 = {.cps = (lxb_codepoint_t[]) {0x7CD6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA04 = {.cps = (lxb_codepoint_t[]) {0x5B85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA05 = {.cps = (lxb_codepoint_t[]) {0x6D1E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA06 = {.cps = (lxb_codepoint_t[]) {0x66B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA07 = {.cps = (lxb_codepoint_t[]) {0x8F3B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA08 = {.cps = (lxb_codepoint_t[]) {0x884C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA09 = {.cps = (lxb_codepoint_t[]) {0x964D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA0A = {.cps = (lxb_codepoint_t[]) {0x898B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA0B = {.cps = (lxb_codepoint_t[]) {0x5ED3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA0C = {.cps = (lxb_codepoint_t[]) {0x5140}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA0D = {.cps = (lxb_codepoint_t[]) {0x55C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA10 = {.cps = (lxb_codepoint_t[]) {0x585A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA12 = {.cps = (lxb_codepoint_t[]) {0x6674}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA15 = {.cps = (lxb_codepoint_t[]) {0x51DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA16 = {.cps = (lxb_codepoint_t[]) {0x732A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA17 = {.cps = (lxb_codepoint_t[]) {0x76CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA18 = {.cps = (lxb_codepoint_t[]) {0x793C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA19 = {.cps = (lxb_codepoint_t[]) {0x795E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA1A = {.cps = (lxb_codepoint_t[]) {0x7965}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA1B = {.cps = (lxb_codepoint_t[]) {0x798F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA1C = {.cps = (lxb_codepoint_t[]) {0x9756}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA1D = {.cps = (lxb_codepoint_t[]) {0x7CBE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA1E = {.cps = (lxb_codepoint_t[]) {0x7FBD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA20 = {.cps = (lxb_codepoint_t[]) {0x8612}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA22 = {.cps = (lxb_codepoint_t[]) {0x8AF8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA25 = {.cps = (lxb_codepoint_t[]) {0x9038}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA26 = {.cps = (lxb_codepoint_t[]) {0x90FD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA2A = {.cps = (lxb_codepoint_t[]) {0x98EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA2B = {.cps = (lxb_codepoint_t[]) {0x98FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA2C = {.cps = (lxb_codepoint_t[]) {0x9928}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA2D = {.cps = (lxb_codepoint_t[]) {0x9DB4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA2E = {.cps = (lxb_codepoint_t[]) {0x90DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA2F = {.cps = (lxb_codepoint_t[]) {0x96B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA30 = {.cps = (lxb_codepoint_t[]) {0x4FAE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA31 = {.cps = (lxb_codepoint_t[]) {0x50E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA32 = {.cps = (lxb_codepoint_t[]) {0x514D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA33 = {.cps = (lxb_codepoint_t[]) {0x52C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA34 = {.cps = (lxb_codepoint_t[]) {0x52E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA35 = {.cps = (lxb_codepoint_t[]) {0x5351}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA36 = {.cps = (lxb_codepoint_t[]) {0x559D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA37 = {.cps = (lxb_codepoint_t[]) {0x5606}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA38 = {.cps = (lxb_codepoint_t[]) {0x5668}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA39 = {.cps = (lxb_codepoint_t[]) {0x5840}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA3A = {.cps = (lxb_codepoint_t[]) {0x58A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA3B = {.cps = (lxb_codepoint_t[]) {0x5C64}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA3C = {.cps = (lxb_codepoint_t[]) {0x5C6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA3D = {.cps = (lxb_codepoint_t[]) {0x6094}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA3E = {.cps = (lxb_codepoint_t[]) {0x6168}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA3F = {.cps = (lxb_codepoint_t[]) {0x618E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA40 = {.cps = (lxb_codepoint_t[]) {0x61F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA41 = {.cps = (lxb_codepoint_t[]) {0x654F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA42 = {.cps = (lxb_codepoint_t[]) {0x65E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA43 = {.cps = (lxb_codepoint_t[]) {0x6691}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA44 = {.cps = (lxb_codepoint_t[]) {0x6885}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA45 = {.cps = (lxb_codepoint_t[]) {0x6D77}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA46 = {.cps = (lxb_codepoint_t[]) {0x6E1A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA47 = {.cps = (lxb_codepoint_t[]) {0x6F22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA48 = {.cps = (lxb_codepoint_t[]) {0x716E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA49 = {.cps = (lxb_codepoint_t[]) {0x722B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA4A = {.cps = (lxb_codepoint_t[]) {0x7422}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA4B = {.cps = (lxb_codepoint_t[]) {0x7891}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA4C = {.cps = (lxb_codepoint_t[]) {0x793E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA4D = {.cps = (lxb_codepoint_t[]) {0x7949}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA4E = {.cps = (lxb_codepoint_t[]) {0x7948}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA4F = {.cps = (lxb_codepoint_t[]) {0x7950}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA50 = {.cps = (lxb_codepoint_t[]) {0x7956}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA51 = {.cps = (lxb_codepoint_t[]) {0x795D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA52 = {.cps = (lxb_codepoint_t[]) {0x798D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA53 = {.cps = (lxb_codepoint_t[]) {0x798E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA54 = {.cps = (lxb_codepoint_t[]) {0x7A40}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA55 = {.cps = (lxb_codepoint_t[]) {0x7A81}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA56 = {.cps = (lxb_codepoint_t[]) {0x7BC0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA57 = {.cps = (lxb_codepoint_t[]) {0x7DF4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA58 = {.cps = (lxb_codepoint_t[]) {0x7E09}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA59 = {.cps = (lxb_codepoint_t[]) {0x7E41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA5A = {.cps = (lxb_codepoint_t[]) {0x7F72}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA5B = {.cps = (lxb_codepoint_t[]) {0x8005}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA5C = {.cps = (lxb_codepoint_t[]) {0x81ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA5D = {.cps = (lxb_codepoint_t[]) {0x8279}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA5E = {.cps = (lxb_codepoint_t[]) {0x8279}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA5F = {.cps = (lxb_codepoint_t[]) {0x8457}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA60 = {.cps = (lxb_codepoint_t[]) {0x8910}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA61 = {.cps = (lxb_codepoint_t[]) {0x8996}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA62 = {.cps = (lxb_codepoint_t[]) {0x8B01}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA63 = {.cps = (lxb_codepoint_t[]) {0x8B39}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA64 = {.cps = (lxb_codepoint_t[]) {0x8CD3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA65 = {.cps = (lxb_codepoint_t[]) {0x8D08}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA66 = {.cps = (lxb_codepoint_t[]) {0x8FB6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA67 = {.cps = (lxb_codepoint_t[]) {0x9038}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA68 = {.cps = (lxb_codepoint_t[]) {0x96E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA69 = {.cps = (lxb_codepoint_t[]) {0x97FF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA6A = {.cps = (lxb_codepoint_t[]) {0x983B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA6B = {.cps = (lxb_codepoint_t[]) {0x6075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA6C = {.cps = (lxb_codepoint_t[]) {0x242EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA6D = {.cps = (lxb_codepoint_t[]) {0x8218}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA70 = {.cps = (lxb_codepoint_t[]) {0x4E26}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA71 = {.cps = (lxb_codepoint_t[]) {0x51B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA72 = {.cps = (lxb_codepoint_t[]) {0x5168}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA73 = {.cps = (lxb_codepoint_t[]) {0x4F80}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA74 = {.cps = (lxb_codepoint_t[]) {0x5145}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA75 = {.cps = (lxb_codepoint_t[]) {0x5180}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA76 = {.cps = (lxb_codepoint_t[]) {0x52C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA77 = {.cps = (lxb_codepoint_t[]) {0x52FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA78 = {.cps = (lxb_codepoint_t[]) {0x559D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA79 = {.cps = (lxb_codepoint_t[]) {0x5555}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA7A = {.cps = (lxb_codepoint_t[]) {0x5599}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA7B = {.cps = (lxb_codepoint_t[]) {0x55E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA7C = {.cps = (lxb_codepoint_t[]) {0x585A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA7D = {.cps = (lxb_codepoint_t[]) {0x58B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA7E = {.cps = (lxb_codepoint_t[]) {0x5944}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA7F = {.cps = (lxb_codepoint_t[]) {0x5954}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA80 = {.cps = (lxb_codepoint_t[]) {0x5A62}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA81 = {.cps = (lxb_codepoint_t[]) {0x5B28}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA82 = {.cps = (lxb_codepoint_t[]) {0x5ED2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA83 = {.cps = (lxb_codepoint_t[]) {0x5ED9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA84 = {.cps = (lxb_codepoint_t[]) {0x5F69}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA85 = {.cps = (lxb_codepoint_t[]) {0x5FAD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA86 = {.cps = (lxb_codepoint_t[]) {0x60D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA87 = {.cps = (lxb_codepoint_t[]) {0x614E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA88 = {.cps = (lxb_codepoint_t[]) {0x6108}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA89 = {.cps = (lxb_codepoint_t[]) {0x618E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA8A = {.cps = (lxb_codepoint_t[]) {0x6160}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA8B = {.cps = (lxb_codepoint_t[]) {0x61F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA8C = {.cps = (lxb_codepoint_t[]) {0x6234}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA8D = {.cps = (lxb_codepoint_t[]) {0x63C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA8E = {.cps = (lxb_codepoint_t[]) {0x641C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA8F = {.cps = (lxb_codepoint_t[]) {0x6452}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA90 = {.cps = (lxb_codepoint_t[]) {0x6556}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA91 = {.cps = (lxb_codepoint_t[]) {0x6674}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA92 = {.cps = (lxb_codepoint_t[]) {0x6717}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA93 = {.cps = (lxb_codepoint_t[]) {0x671B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA94 = {.cps = (lxb_codepoint_t[]) {0x6756}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA95 = {.cps = (lxb_codepoint_t[]) {0x6B79}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA96 = {.cps = (lxb_codepoint_t[]) {0x6BBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA97 = {.cps = (lxb_codepoint_t[]) {0x6D41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA98 = {.cps = (lxb_codepoint_t[]) {0x6EDB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA99 = {.cps = (lxb_codepoint_t[]) {0x6ECB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA9A = {.cps = (lxb_codepoint_t[]) {0x6F22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA9B = {.cps = (lxb_codepoint_t[]) {0x701E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA9C = {.cps = (lxb_codepoint_t[]) {0x716E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA9D = {.cps = (lxb_codepoint_t[]) {0x77A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA9E = {.cps = (lxb_codepoint_t[]) {0x7235}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FA9F = {.cps = (lxb_codepoint_t[]) {0x72AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA0 = {.cps = (lxb_codepoint_t[]) {0x732A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA1 = {.cps = (lxb_codepoint_t[]) {0x7471}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA2 = {.cps = (lxb_codepoint_t[]) {0x7506}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA3 = {.cps = (lxb_codepoint_t[]) {0x753B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA4 = {.cps = (lxb_codepoint_t[]) {0x761D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA5 = {.cps = (lxb_codepoint_t[]) {0x761F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA6 = {.cps = (lxb_codepoint_t[]) {0x76CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA7 = {.cps = (lxb_codepoint_t[]) {0x76DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA8 = {.cps = (lxb_codepoint_t[]) {0x76F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAA9 = {.cps = (lxb_codepoint_t[]) {0x774A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAAA = {.cps = (lxb_codepoint_t[]) {0x7740}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAAB = {.cps = (lxb_codepoint_t[]) {0x78CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAAC = {.cps = (lxb_codepoint_t[]) {0x7AB1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAAD = {.cps = (lxb_codepoint_t[]) {0x7BC0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAAE = {.cps = (lxb_codepoint_t[]) {0x7C7B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAAF = {.cps = (lxb_codepoint_t[]) {0x7D5B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB0 = {.cps = (lxb_codepoint_t[]) {0x7DF4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB1 = {.cps = (lxb_codepoint_t[]) {0x7F3E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB2 = {.cps = (lxb_codepoint_t[]) {0x8005}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB3 = {.cps = (lxb_codepoint_t[]) {0x8352}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB4 = {.cps = (lxb_codepoint_t[]) {0x83EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB5 = {.cps = (lxb_codepoint_t[]) {0x8779}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB6 = {.cps = (lxb_codepoint_t[]) {0x8941}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB7 = {.cps = (lxb_codepoint_t[]) {0x8986}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB8 = {.cps = (lxb_codepoint_t[]) {0x8996}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAB9 = {.cps = (lxb_codepoint_t[]) {0x8ABF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FABA = {.cps = (lxb_codepoint_t[]) {0x8AF8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FABB = {.cps = (lxb_codepoint_t[]) {0x8ACB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FABC = {.cps = (lxb_codepoint_t[]) {0x8B01}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FABD = {.cps = (lxb_codepoint_t[]) {0x8AFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FABE = {.cps = (lxb_codepoint_t[]) {0x8AED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FABF = {.cps = (lxb_codepoint_t[]) {0x8B39}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC0 = {.cps = (lxb_codepoint_t[]) {0x8B8A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC1 = {.cps = (lxb_codepoint_t[]) {0x8D08}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC2 = {.cps = (lxb_codepoint_t[]) {0x8F38}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC3 = {.cps = (lxb_codepoint_t[]) {0x9072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC4 = {.cps = (lxb_codepoint_t[]) {0x9199}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC5 = {.cps = (lxb_codepoint_t[]) {0x9276}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC6 = {.cps = (lxb_codepoint_t[]) {0x967C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC7 = {.cps = (lxb_codepoint_t[]) {0x96E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC8 = {.cps = (lxb_codepoint_t[]) {0x9756}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAC9 = {.cps = (lxb_codepoint_t[]) {0x97DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FACA = {.cps = (lxb_codepoint_t[]) {0x97FF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FACB = {.cps = (lxb_codepoint_t[]) {0x980B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FACC = {.cps = (lxb_codepoint_t[]) {0x983B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FACD = {.cps = (lxb_codepoint_t[]) {0x9B12}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FACE = {.cps = (lxb_codepoint_t[]) {0x9F9C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FACF = {.cps = (lxb_codepoint_t[]) {0x2284A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD0 = {.cps = (lxb_codepoint_t[]) {0x22844}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD1 = {.cps = (lxb_codepoint_t[]) {0x233D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD2 = {.cps = (lxb_codepoint_t[]) {0x3B9D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD3 = {.cps = (lxb_codepoint_t[]) {0x4018}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD4 = {.cps = (lxb_codepoint_t[]) {0x4039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD5 = {.cps = (lxb_codepoint_t[]) {0x25249}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD6 = {.cps = (lxb_codepoint_t[]) {0x25CD0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD7 = {.cps = (lxb_codepoint_t[]) {0x27ED3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD8 = {.cps = (lxb_codepoint_t[]) {0x9F43}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FAD9 = {.cps = (lxb_codepoint_t[]) {0x9F8E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB00 = {.cps = (lxb_codepoint_t[]) {0x0066, 0x0066}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB01 = {.cps = (lxb_codepoint_t[]) {0x0066, 0x0069}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB02 = {.cps = (lxb_codepoint_t[]) {0x0066, 0x006C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB03 = {.cps = (lxb_codepoint_t[]) {0x0066, 0x0066, 0x0069}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB04 = {.cps = (lxb_codepoint_t[]) {0x0066, 0x0066, 0x006C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB05 = {.cps = (lxb_codepoint_t[]) {0x0073, 0x0074}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB06 = {.cps = (lxb_codepoint_t[]) {0x0073, 0x0074}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB13 = {.cps = (lxb_codepoint_t[]) {0x0574, 0x0576}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB14 = {.cps = (lxb_codepoint_t[]) {0x0574, 0x0565}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB15 = {.cps = (lxb_codepoint_t[]) {0x0574, 0x056B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB16 = {.cps = (lxb_codepoint_t[]) {0x057E, 0x0576}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB17 = {.cps = (lxb_codepoint_t[]) {0x0574, 0x056D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB1D = {.cps = (lxb_codepoint_t[]) {0x05D9, 0x05B4}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB1F = {.cps = (lxb_codepoint_t[]) {0x05F2, 0x05B7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB20 = {.cps = (lxb_codepoint_t[]) {0x05E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB21 = {.cps = (lxb_codepoint_t[]) {0x05D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB22 = {.cps = (lxb_codepoint_t[]) {0x05D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB23 = {.cps = (lxb_codepoint_t[]) {0x05D4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB24 = {.cps = (lxb_codepoint_t[]) {0x05DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB25 = {.cps = (lxb_codepoint_t[]) {0x05DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB26 = {.cps = (lxb_codepoint_t[]) {0x05DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB27 = {.cps = (lxb_codepoint_t[]) {0x05E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB28 = {.cps = (lxb_codepoint_t[]) {0x05EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB29 = {.cps = (lxb_codepoint_t[]) {0x002B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB2A = {.cps = (lxb_codepoint_t[]) {0x05E9, 0x05C1}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB2B = {.cps = (lxb_codepoint_t[]) {0x05E9, 0x05C2}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB2C = {.cps = (lxb_codepoint_t[]) {0x05E9, 0x05BC, 0x05C1}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB2D = {.cps = (lxb_codepoint_t[]) {0x05E9, 0x05BC, 0x05C2}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB2E = {.cps = (lxb_codepoint_t[]) {0x05D0, 0x05B7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB2F = {.cps = (lxb_codepoint_t[]) {0x05D0, 0x05B8}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB30 = {.cps = (lxb_codepoint_t[]) {0x05D0, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB31 = {.cps = (lxb_codepoint_t[]) {0x05D1, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB32 = {.cps = (lxb_codepoint_t[]) {0x05D2, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB33 = {.cps = (lxb_codepoint_t[]) {0x05D3, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB34 = {.cps = (lxb_codepoint_t[]) {0x05D4, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB35 = {.cps = (lxb_codepoint_t[]) {0x05D5, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB36 = {.cps = (lxb_codepoint_t[]) {0x05D6, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB38 = {.cps = (lxb_codepoint_t[]) {0x05D8, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB39 = {.cps = (lxb_codepoint_t[]) {0x05D9, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB3A = {.cps = (lxb_codepoint_t[]) {0x05DA, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB3B = {.cps = (lxb_codepoint_t[]) {0x05DB, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB3C = {.cps = (lxb_codepoint_t[]) {0x05DC, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB3E = {.cps = (lxb_codepoint_t[]) {0x05DE, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB40 = {.cps = (lxb_codepoint_t[]) {0x05E0, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB41 = {.cps = (lxb_codepoint_t[]) {0x05E1, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB43 = {.cps = (lxb_codepoint_t[]) {0x05E3, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB44 = {.cps = (lxb_codepoint_t[]) {0x05E4, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB46 = {.cps = (lxb_codepoint_t[]) {0x05E6, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB47 = {.cps = (lxb_codepoint_t[]) {0x05E7, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB48 = {.cps = (lxb_codepoint_t[]) {0x05E8, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB49 = {.cps = (lxb_codepoint_t[]) {0x05E9, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB4A = {.cps = (lxb_codepoint_t[]) {0x05EA, 0x05BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB4B = {.cps = (lxb_codepoint_t[]) {0x05D5, 0x05B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB4C = {.cps = (lxb_codepoint_t[]) {0x05D1, 0x05BF}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB4D = {.cps = (lxb_codepoint_t[]) {0x05DB, 0x05BF}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB4E = {.cps = (lxb_codepoint_t[]) {0x05E4, 0x05BF}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB4F = {.cps = (lxb_codepoint_t[]) {0x05D0, 0x05DC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB50 = {.cps = (lxb_codepoint_t[]) {0x0671}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB51 = {.cps = (lxb_codepoint_t[]) {0x0671}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB52 = {.cps = (lxb_codepoint_t[]) {0x067B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB53 = {.cps = (lxb_codepoint_t[]) {0x067B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB54 = {.cps = (lxb_codepoint_t[]) {0x067B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB55 = {.cps = (lxb_codepoint_t[]) {0x067B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB56 = {.cps = (lxb_codepoint_t[]) {0x067E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB57 = {.cps = (lxb_codepoint_t[]) {0x067E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB58 = {.cps = (lxb_codepoint_t[]) {0x067E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB59 = {.cps = (lxb_codepoint_t[]) {0x067E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB5A = {.cps = (lxb_codepoint_t[]) {0x0680}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB5B = {.cps = (lxb_codepoint_t[]) {0x0680}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB5C = {.cps = (lxb_codepoint_t[]) {0x0680}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB5D = {.cps = (lxb_codepoint_t[]) {0x0680}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB5E = {.cps = (lxb_codepoint_t[]) {0x067A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB5F = {.cps = (lxb_codepoint_t[]) {0x067A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB60 = {.cps = (lxb_codepoint_t[]) {0x067A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB61 = {.cps = (lxb_codepoint_t[]) {0x067A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB62 = {.cps = (lxb_codepoint_t[]) {0x067F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB63 = {.cps = (lxb_codepoint_t[]) {0x067F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB64 = {.cps = (lxb_codepoint_t[]) {0x067F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB65 = {.cps = (lxb_codepoint_t[]) {0x067F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB66 = {.cps = (lxb_codepoint_t[]) {0x0679}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB67 = {.cps = (lxb_codepoint_t[]) {0x0679}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB68 = {.cps = (lxb_codepoint_t[]) {0x0679}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB69 = {.cps = (lxb_codepoint_t[]) {0x0679}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB6A = {.cps = (lxb_codepoint_t[]) {0x06A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB6B = {.cps = (lxb_codepoint_t[]) {0x06A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB6C = {.cps = (lxb_codepoint_t[]) {0x06A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB6D = {.cps = (lxb_codepoint_t[]) {0x06A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB6E = {.cps = (lxb_codepoint_t[]) {0x06A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB6F = {.cps = (lxb_codepoint_t[]) {0x06A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB70 = {.cps = (lxb_codepoint_t[]) {0x06A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB71 = {.cps = (lxb_codepoint_t[]) {0x06A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB72 = {.cps = (lxb_codepoint_t[]) {0x0684}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB73 = {.cps = (lxb_codepoint_t[]) {0x0684}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB74 = {.cps = (lxb_codepoint_t[]) {0x0684}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB75 = {.cps = (lxb_codepoint_t[]) {0x0684}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB76 = {.cps = (lxb_codepoint_t[]) {0x0683}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB77 = {.cps = (lxb_codepoint_t[]) {0x0683}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB78 = {.cps = (lxb_codepoint_t[]) {0x0683}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB79 = {.cps = (lxb_codepoint_t[]) {0x0683}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB7A = {.cps = (lxb_codepoint_t[]) {0x0686}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB7B = {.cps = (lxb_codepoint_t[]) {0x0686}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB7C = {.cps = (lxb_codepoint_t[]) {0x0686}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB7D = {.cps = (lxb_codepoint_t[]) {0x0686}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB7E = {.cps = (lxb_codepoint_t[]) {0x0687}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB7F = {.cps = (lxb_codepoint_t[]) {0x0687}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB80 = {.cps = (lxb_codepoint_t[]) {0x0687}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB81 = {.cps = (lxb_codepoint_t[]) {0x0687}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB82 = {.cps = (lxb_codepoint_t[]) {0x068D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB83 = {.cps = (lxb_codepoint_t[]) {0x068D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB84 = {.cps = (lxb_codepoint_t[]) {0x068C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB85 = {.cps = (lxb_codepoint_t[]) {0x068C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB86 = {.cps = (lxb_codepoint_t[]) {0x068E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB87 = {.cps = (lxb_codepoint_t[]) {0x068E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB88 = {.cps = (lxb_codepoint_t[]) {0x0688}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB89 = {.cps = (lxb_codepoint_t[]) {0x0688}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB8A = {.cps = (lxb_codepoint_t[]) {0x0698}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB8B = {.cps = (lxb_codepoint_t[]) {0x0698}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB8C = {.cps = (lxb_codepoint_t[]) {0x0691}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB8D = {.cps = (lxb_codepoint_t[]) {0x0691}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB8E = {.cps = (lxb_codepoint_t[]) {0x06A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB8F = {.cps = (lxb_codepoint_t[]) {0x06A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB90 = {.cps = (lxb_codepoint_t[]) {0x06A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB91 = {.cps = (lxb_codepoint_t[]) {0x06A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB92 = {.cps = (lxb_codepoint_t[]) {0x06AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB93 = {.cps = (lxb_codepoint_t[]) {0x06AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB94 = {.cps = (lxb_codepoint_t[]) {0x06AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB95 = {.cps = (lxb_codepoint_t[]) {0x06AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB96 = {.cps = (lxb_codepoint_t[]) {0x06B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB97 = {.cps = (lxb_codepoint_t[]) {0x06B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB98 = {.cps = (lxb_codepoint_t[]) {0x06B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB99 = {.cps = (lxb_codepoint_t[]) {0x06B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB9A = {.cps = (lxb_codepoint_t[]) {0x06B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB9B = {.cps = (lxb_codepoint_t[]) {0x06B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB9C = {.cps = (lxb_codepoint_t[]) {0x06B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB9D = {.cps = (lxb_codepoint_t[]) {0x06B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB9E = {.cps = (lxb_codepoint_t[]) {0x06BA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FB9F = {.cps = (lxb_codepoint_t[]) {0x06BA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA0 = {.cps = (lxb_codepoint_t[]) {0x06BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA1 = {.cps = (lxb_codepoint_t[]) {0x06BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA2 = {.cps = (lxb_codepoint_t[]) {0x06BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA3 = {.cps = (lxb_codepoint_t[]) {0x06BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA4 = {.cps = (lxb_codepoint_t[]) {0x06C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA5 = {.cps = (lxb_codepoint_t[]) {0x06C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA6 = {.cps = (lxb_codepoint_t[]) {0x06C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA7 = {.cps = (lxb_codepoint_t[]) {0x06C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA8 = {.cps = (lxb_codepoint_t[]) {0x06C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBA9 = {.cps = (lxb_codepoint_t[]) {0x06C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBAA = {.cps = (lxb_codepoint_t[]) {0x06BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBAB = {.cps = (lxb_codepoint_t[]) {0x06BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBAC = {.cps = (lxb_codepoint_t[]) {0x06BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBAD = {.cps = (lxb_codepoint_t[]) {0x06BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBAE = {.cps = (lxb_codepoint_t[]) {0x06D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBAF = {.cps = (lxb_codepoint_t[]) {0x06D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBB0 = {.cps = (lxb_codepoint_t[]) {0x06D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBB1 = {.cps = (lxb_codepoint_t[]) {0x06D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD3 = {.cps = (lxb_codepoint_t[]) {0x06AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD4 = {.cps = (lxb_codepoint_t[]) {0x06AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD5 = {.cps = (lxb_codepoint_t[]) {0x06AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD6 = {.cps = (lxb_codepoint_t[]) {0x06AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD7 = {.cps = (lxb_codepoint_t[]) {0x06C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD8 = {.cps = (lxb_codepoint_t[]) {0x06C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBD9 = {.cps = (lxb_codepoint_t[]) {0x06C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBDA = {.cps = (lxb_codepoint_t[]) {0x06C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBDB = {.cps = (lxb_codepoint_t[]) {0x06C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBDC = {.cps = (lxb_codepoint_t[]) {0x06C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBDD = {.cps = (lxb_codepoint_t[]) {0x06C7, 0x0674}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBDE = {.cps = (lxb_codepoint_t[]) {0x06CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBDF = {.cps = (lxb_codepoint_t[]) {0x06CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE0 = {.cps = (lxb_codepoint_t[]) {0x06C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE1 = {.cps = (lxb_codepoint_t[]) {0x06C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE2 = {.cps = (lxb_codepoint_t[]) {0x06C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE3 = {.cps = (lxb_codepoint_t[]) {0x06C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE4 = {.cps = (lxb_codepoint_t[]) {0x06D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE5 = {.cps = (lxb_codepoint_t[]) {0x06D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE6 = {.cps = (lxb_codepoint_t[]) {0x06D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE7 = {.cps = (lxb_codepoint_t[]) {0x06D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE8 = {.cps = (lxb_codepoint_t[]) {0x0649}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBE9 = {.cps = (lxb_codepoint_t[]) {0x0649}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBEA = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBEB = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBEC = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06D5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBED = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06D5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBEE = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0648}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBEF = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0648}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF0 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06C7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF1 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06C7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF2 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06C6}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF3 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06C6}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF4 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06C8}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF5 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06C8}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF6 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06D0}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF7 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06D0}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF8 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x06D0}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBF9 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBFA = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBFB = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBFC = {.cps = (lxb_codepoint_t[]) {0x06CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBFD = {.cps = (lxb_codepoint_t[]) {0x06CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBFE = {.cps = (lxb_codepoint_t[]) {0x06CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FBFF = {.cps = (lxb_codepoint_t[]) {0x06CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC00 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC01 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC02 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC03 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC04 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC05 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC06 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC07 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC08 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC09 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC0A = {.cps = (lxb_codepoint_t[]) {0x0628, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC0B = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC0C = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC0D = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC0E = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC0F = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC10 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC11 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC12 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC13 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC14 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC15 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC16 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC17 = {.cps = (lxb_codepoint_t[]) {0x062D, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC18 = {.cps = (lxb_codepoint_t[]) {0x062D, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC19 = {.cps = (lxb_codepoint_t[]) {0x062E, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC1A = {.cps = (lxb_codepoint_t[]) {0x062E, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC1B = {.cps = (lxb_codepoint_t[]) {0x062E, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC1C = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC1D = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC1E = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC1F = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC20 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC21 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC22 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC23 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC24 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC25 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC26 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC27 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC28 = {.cps = (lxb_codepoint_t[]) {0x0638, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC29 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC2A = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC2B = {.cps = (lxb_codepoint_t[]) {0x063A, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC2C = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC2D = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC2E = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC2F = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC30 = {.cps = (lxb_codepoint_t[]) {0x0641, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC31 = {.cps = (lxb_codepoint_t[]) {0x0641, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC32 = {.cps = (lxb_codepoint_t[]) {0x0641, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC33 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC34 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC35 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC36 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC37 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC38 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC39 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC3A = {.cps = (lxb_codepoint_t[]) {0x0643, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC3B = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0644}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC3C = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC3D = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC3E = {.cps = (lxb_codepoint_t[]) {0x0643, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC3F = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC40 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC41 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC42 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC43 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC44 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC45 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC46 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC47 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC48 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC49 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC4A = {.cps = (lxb_codepoint_t[]) {0x0645, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC4B = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC4C = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC4D = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC4E = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC4F = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC50 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC51 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC52 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC53 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC54 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC55 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC56 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC57 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC58 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC59 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC5A = {.cps = (lxb_codepoint_t[]) {0x064A, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC5B = {.cps = (lxb_codepoint_t[]) {0x0630, 0x0670}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC5C = {.cps = (lxb_codepoint_t[]) {0x0631, 0x0670}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC5D = {.cps = (lxb_codepoint_t[]) {0x0649, 0x0670}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC5E = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064C, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC5F = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064D, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC60 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064E, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC61 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x064F, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC62 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0650, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC63 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0651, 0x0670}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC64 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC65 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0632}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC66 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC67 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0646}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC68 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC69 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC6A = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC6B = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0632}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC6C = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC6D = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0646}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC6E = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC6F = {.cps = (lxb_codepoint_t[]) {0x0628, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC70 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC71 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0632}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC72 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC73 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0646}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC74 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC75 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC76 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC77 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0632}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC78 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC79 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0646}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC7A = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC7B = {.cps = (lxb_codepoint_t[]) {0x062B, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC7C = {.cps = (lxb_codepoint_t[]) {0x0641, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC7D = {.cps = (lxb_codepoint_t[]) {0x0641, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC7E = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC7F = {.cps = (lxb_codepoint_t[]) {0x0642, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC80 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC81 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0644}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC82 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC83 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC84 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC85 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC86 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC87 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC88 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x0627}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC89 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC8A = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC8B = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0632}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC8C = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC8D = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0646}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC8E = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC8F = {.cps = (lxb_codepoint_t[]) {0x0646, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC90 = {.cps = (lxb_codepoint_t[]) {0x0649, 0x0670}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC91 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC92 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0632}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC93 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC94 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0646}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC95 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC96 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC97 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC98 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC99 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC9A = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC9B = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC9C = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC9D = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC9E = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FC9F = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA0 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA1 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA2 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA3 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA4 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA5 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA6 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA7 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA8 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCA9 = {.cps = (lxb_codepoint_t[]) {0x062D, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCAA = {.cps = (lxb_codepoint_t[]) {0x062D, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCAB = {.cps = (lxb_codepoint_t[]) {0x062E, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCAC = {.cps = (lxb_codepoint_t[]) {0x062E, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCAD = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCAE = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCAF = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB0 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB1 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB2 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB3 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB4 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB5 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB6 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB7 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB8 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCB9 = {.cps = (lxb_codepoint_t[]) {0x0638, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCBA = {.cps = (lxb_codepoint_t[]) {0x0639, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCBB = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCBC = {.cps = (lxb_codepoint_t[]) {0x063A, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCBD = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCBE = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCBF = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC0 = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC1 = {.cps = (lxb_codepoint_t[]) {0x0641, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC2 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC3 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC4 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC5 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC6 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC7 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0644}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC8 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCC9 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCCA = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCCB = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCCC = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCCD = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCCE = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCCF = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD0 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD1 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD2 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD3 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD4 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD5 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD6 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD7 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD8 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCD9 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x0670}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCDA = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCDB = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCDC = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCDD = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCDE = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCDF = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE0 = {.cps = (lxb_codepoint_t[]) {0x0626, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE1 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE2 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE3 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE4 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE5 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE6 = {.cps = (lxb_codepoint_t[]) {0x062B, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE7 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE8 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCE9 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCEA = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCEB = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0644}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCEC = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCED = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCEE = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCEF = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF0 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF1 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF2 = {.cps = (lxb_codepoint_t[]) {0x0640, 0x064E, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF3 = {.cps = (lxb_codepoint_t[]) {0x0640, 0x064F, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF4 = {.cps = (lxb_codepoint_t[]) {0x0640, 0x0650, 0x0651}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF5 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF6 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF7 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF8 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCF9 = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCFA = {.cps = (lxb_codepoint_t[]) {0x063A, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCFB = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCFC = {.cps = (lxb_codepoint_t[]) {0x0633, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCFD = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCFE = {.cps = (lxb_codepoint_t[]) {0x0634, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FCFF = {.cps = (lxb_codepoint_t[]) {0x062D, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD00 = {.cps = (lxb_codepoint_t[]) {0x062D, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD01 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD02 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD03 = {.cps = (lxb_codepoint_t[]) {0x062E, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD04 = {.cps = (lxb_codepoint_t[]) {0x062E, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD05 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD06 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD07 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD08 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD09 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD0A = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD0B = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD0C = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD0D = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD0E = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD0F = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD10 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD11 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD12 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD13 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD14 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD15 = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD16 = {.cps = (lxb_codepoint_t[]) {0x063A, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD17 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD18 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD19 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD1A = {.cps = (lxb_codepoint_t[]) {0x0634, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD1B = {.cps = (lxb_codepoint_t[]) {0x062D, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD1C = {.cps = (lxb_codepoint_t[]) {0x062D, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD1D = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD1E = {.cps = (lxb_codepoint_t[]) {0x062C, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD1F = {.cps = (lxb_codepoint_t[]) {0x062E, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD20 = {.cps = (lxb_codepoint_t[]) {0x062E, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD21 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD22 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD23 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x0649}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD24 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x064A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD25 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD26 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD27 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD28 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD29 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD2A = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD2B = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD2C = {.cps = (lxb_codepoint_t[]) {0x0636, 0x0631}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD2D = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD2E = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD2F = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD30 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD31 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD32 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0647}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD33 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD34 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD35 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD36 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD37 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD38 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD39 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD3A = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD3B = {.cps = (lxb_codepoint_t[]) {0x0638, 0x0645}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD3C = {.cps = (lxb_codepoint_t[]) {0x0627, 0x064B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD3D = {.cps = (lxb_codepoint_t[]) {0x0627, 0x064B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD50 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD51 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062D, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD52 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062D, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD53 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD54 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD55 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD56 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD57 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645, 0x062E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD58 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD59 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD5A = {.cps = (lxb_codepoint_t[]) {0x062D, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD5B = {.cps = (lxb_codepoint_t[]) {0x062D, 0x0645, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD5C = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062D, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD5D = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062C, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD5E = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062C, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD5F = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD60 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD61 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD62 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD63 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD64 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x062D, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD65 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x062D, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD66 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD67 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD68 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD69 = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062C, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD6A = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645, 0x062E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD6B = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645, 0x062E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD6C = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD6D = {.cps = (lxb_codepoint_t[]) {0x0634, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD6E = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062D, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD6F = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD70 = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD71 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD72 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD73 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD74 = {.cps = (lxb_codepoint_t[]) {0x0637, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD75 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD76 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD77 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD78 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0645, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD79 = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD7A = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD7B = {.cps = (lxb_codepoint_t[]) {0x063A, 0x0645, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD7C = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD7D = {.cps = (lxb_codepoint_t[]) {0x0641, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD7E = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD7F = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD80 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD81 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD82 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062D, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD83 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD84 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD85 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD86 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD87 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD88 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD89 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062D, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD8A = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD8B = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD8C = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062C, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD8D = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD8E = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062E, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD8F = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062E, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD92 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062C, 0x062E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD93 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x0645, 0x062C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD94 = {.cps = (lxb_codepoint_t[]) {0x0647, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD95 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD96 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062D, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD97 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD98 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD99 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD9A = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD9B = {.cps = (lxb_codepoint_t[]) {0x0646, 0x0645, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD9C = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD9D = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD9E = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062E, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FD9F = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062C, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA0 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062C, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA1 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062E, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA2 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x062E, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA3 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA4 = {.cps = (lxb_codepoint_t[]) {0x062A, 0x0645, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA5 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA6 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x062D, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA7 = {.cps = (lxb_codepoint_t[]) {0x062C, 0x0645, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA8 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062E, 0x0649}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDA9 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDAA = {.cps = (lxb_codepoint_t[]) {0x0634, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDAB = {.cps = (lxb_codepoint_t[]) {0x0636, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDAC = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDAD = {.cps = (lxb_codepoint_t[]) {0x0644, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDAE = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDAF = {.cps = (lxb_codepoint_t[]) {0x064A, 0x062C, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB0 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB1 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB2 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB3 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB4 = {.cps = (lxb_codepoint_t[]) {0x0642, 0x0645, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB5 = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062D, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB6 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB7 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB8 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDB9 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062E, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDBA = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDBB = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDBC = {.cps = (lxb_codepoint_t[]) {0x0644, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDBD = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C, 0x062D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDBE = {.cps = (lxb_codepoint_t[]) {0x062C, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDBF = {.cps = (lxb_codepoint_t[]) {0x062D, 0x062C, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC0 = {.cps = (lxb_codepoint_t[]) {0x0645, 0x062C, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC1 = {.cps = (lxb_codepoint_t[]) {0x0641, 0x0645, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC2 = {.cps = (lxb_codepoint_t[]) {0x0628, 0x062D, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC3 = {.cps = (lxb_codepoint_t[]) {0x0643, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC4 = {.cps = (lxb_codepoint_t[]) {0x0639, 0x062C, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC5 = {.cps = (lxb_codepoint_t[]) {0x0635, 0x0645, 0x0645}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC6 = {.cps = (lxb_codepoint_t[]) {0x0633, 0x062E, 0x064A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_FDC7 = {.cps = (lxb_codepoint_t[]) {0x0646, 0x062C, 0x064A}, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F900[1] = {0x8C48};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F900 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F900, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F900[1] = {0x8C48};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F900 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F900, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F900[1] = {0x8C48};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F900 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F900, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F900 = {.cp = 0xF900, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F900, .cde = &lxb_unicode_decomposition_c_F900, .kde = &lxb_unicode_decomposition_k_F900};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F901[1] = {0x66F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F901 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F901, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F901[1] = {0x66F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F901 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F901, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F901[1] = {0x66F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F901 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F901, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F901 = {.cp = 0xF901, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F901, .cde = &lxb_unicode_decomposition_c_F901, .kde = &lxb_unicode_decomposition_k_F901};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F902[1] = {0x8ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F902 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F902, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F902[1] = {0x8ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F902 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F902, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F902[1] = {0x8ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F902 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F902, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F902 = {.cp = 0xF902, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F902, .cde = &lxb_unicode_decomposition_c_F902, .kde = &lxb_unicode_decomposition_k_F902};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F903[1] = {0x8CC8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F903 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F903, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F903[1] = {0x8CC8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F903 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F903, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F903[1] = {0x8CC8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F903 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F903, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F903 = {.cp = 0xF903, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F903, .cde = &lxb_unicode_decomposition_c_F903, .kde = &lxb_unicode_decomposition_k_F903};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F904[1] = {0x6ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F904 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F904, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F904[1] = {0x6ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F904 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F904, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F904[1] = {0x6ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F904 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F904, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F904 = {.cp = 0xF904, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F904, .cde = &lxb_unicode_decomposition_c_F904, .kde = &lxb_unicode_decomposition_k_F904};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F905[1] = {0x4E32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F905 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F905, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F905[1] = {0x4E32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F905 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F905, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F905[1] = {0x4E32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F905 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F905, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F905 = {.cp = 0xF905, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F905, .cde = &lxb_unicode_decomposition_c_F905, .kde = &lxb_unicode_decomposition_k_F905};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F906[1] = {0x53E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F906 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F906, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F906[1] = {0x53E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F906 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F906, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F906[1] = {0x53E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F906 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F906, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F906 = {.cp = 0xF906, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F906, .cde = &lxb_unicode_decomposition_c_F906, .kde = &lxb_unicode_decomposition_k_F906};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F907[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F907 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F907, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F907[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F907 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F907, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F907[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F907 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F907, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F907 = {.cp = 0xF907, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F907, .cde = &lxb_unicode_decomposition_c_F907, .kde = &lxb_unicode_decomposition_k_F907};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F908[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F908 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F908, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F908[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F908 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F908, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F908[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F908 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F908, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F908 = {.cp = 0xF908, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F908, .cde = &lxb_unicode_decomposition_c_F908, .kde = &lxb_unicode_decomposition_k_F908};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F909[1] = {0x5951};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F909 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F909, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F909[1] = {0x5951};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F909 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F909, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F909[1] = {0x5951};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F909 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F909, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F909 = {.cp = 0xF909, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F909, .cde = &lxb_unicode_decomposition_c_F909, .kde = &lxb_unicode_decomposition_k_F909};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F90A[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F90A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F90A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F90A[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F90A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F90A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F90A[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F90A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F90A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F90A = {.cp = 0xF90A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F90A, .cde = &lxb_unicode_decomposition_c_F90A, .kde = &lxb_unicode_decomposition_k_F90A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F90B[1] = {0x5587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F90B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F90B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F90B[1] = {0x5587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F90B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F90B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F90B[1] = {0x5587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F90B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F90B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F90B = {.cp = 0xF90B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F90B, .cde = &lxb_unicode_decomposition_c_F90B, .kde = &lxb_unicode_decomposition_k_F90B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F90C[1] = {0x5948};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F90C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F90C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F90C[1] = {0x5948};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F90C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F90C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F90C[1] = {0x5948};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F90C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F90C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F90C = {.cp = 0xF90C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F90C, .cde = &lxb_unicode_decomposition_c_F90C, .kde = &lxb_unicode_decomposition_k_F90C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F90D[1] = {0x61F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F90D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F90D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F90D[1] = {0x61F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F90D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F90D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F90D[1] = {0x61F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F90D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F90D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F90D = {.cp = 0xF90D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F90D, .cde = &lxb_unicode_decomposition_c_F90D, .kde = &lxb_unicode_decomposition_k_F90D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F90E[1] = {0x7669};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F90E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F90E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F90E[1] = {0x7669};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F90E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F90E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F90E[1] = {0x7669};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F90E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F90E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F90E = {.cp = 0xF90E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F90E, .cde = &lxb_unicode_decomposition_c_F90E, .kde = &lxb_unicode_decomposition_k_F90E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F90F[1] = {0x7F85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F90F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F90F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F90F[1] = {0x7F85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F90F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F90F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F90F[1] = {0x7F85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F90F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F90F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F90F = {.cp = 0xF90F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F90F, .cde = &lxb_unicode_decomposition_c_F90F, .kde = &lxb_unicode_decomposition_k_F90F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F910[1] = {0x863F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F910 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F910, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F910[1] = {0x863F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F910 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F910, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F910[1] = {0x863F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F910 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F910, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F910 = {.cp = 0xF910, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F910, .cde = &lxb_unicode_decomposition_c_F910, .kde = &lxb_unicode_decomposition_k_F910};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F911[1] = {0x87BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F911 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F911, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F911[1] = {0x87BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F911 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F911, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F911[1] = {0x87BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F911 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F911, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F911 = {.cp = 0xF911, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F911, .cde = &lxb_unicode_decomposition_c_F911, .kde = &lxb_unicode_decomposition_k_F911};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F912[1] = {0x88F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F912 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F912, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F912[1] = {0x88F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F912 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F912, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F912[1] = {0x88F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F912 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F912, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F912 = {.cp = 0xF912, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F912, .cde = &lxb_unicode_decomposition_c_F912, .kde = &lxb_unicode_decomposition_k_F912};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F913[1] = {0x908F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F913 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F913, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F913[1] = {0x908F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F913 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F913, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F913[1] = {0x908F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F913 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F913, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F913 = {.cp = 0xF913, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F913, .cde = &lxb_unicode_decomposition_c_F913, .kde = &lxb_unicode_decomposition_k_F913};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F914[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F914 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F914, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F914[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F914 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F914, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F914[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F914 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F914, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F914 = {.cp = 0xF914, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F914, .cde = &lxb_unicode_decomposition_c_F914, .kde = &lxb_unicode_decomposition_k_F914};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F915[1] = {0x6D1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F915 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F915, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F915[1] = {0x6D1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F915 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F915, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F915[1] = {0x6D1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F915 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F915, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F915 = {.cp = 0xF915, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F915, .cde = &lxb_unicode_decomposition_c_F915, .kde = &lxb_unicode_decomposition_k_F915};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F916[1] = {0x70D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F916 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F916, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F916[1] = {0x70D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F916 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F916, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F916[1] = {0x70D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F916 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F916, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F916 = {.cp = 0xF916, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F916, .cde = &lxb_unicode_decomposition_c_F916, .kde = &lxb_unicode_decomposition_k_F916};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F917[1] = {0x73DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F917 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F917, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F917[1] = {0x73DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F917 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F917, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F917[1] = {0x73DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F917 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F917, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F917 = {.cp = 0xF917, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F917, .cde = &lxb_unicode_decomposition_c_F917, .kde = &lxb_unicode_decomposition_k_F917};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F918[1] = {0x843D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F918 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F918, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F918[1] = {0x843D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F918 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F918, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F918[1] = {0x843D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F918 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F918, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F918 = {.cp = 0xF918, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F918, .cde = &lxb_unicode_decomposition_c_F918, .kde = &lxb_unicode_decomposition_k_F918};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F919[1] = {0x916A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F919 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F919, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F919[1] = {0x916A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F919 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F919, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F919[1] = {0x916A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F919 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F919, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F919 = {.cp = 0xF919, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F919, .cde = &lxb_unicode_decomposition_c_F919, .kde = &lxb_unicode_decomposition_k_F919};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F91A[1] = {0x99F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F91A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F91A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F91A[1] = {0x99F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F91A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F91A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F91A[1] = {0x99F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F91A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F91A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F91A = {.cp = 0xF91A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F91A, .cde = &lxb_unicode_decomposition_c_F91A, .kde = &lxb_unicode_decomposition_k_F91A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F91B[1] = {0x4E82};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F91B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F91B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F91B[1] = {0x4E82};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F91B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F91B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F91B[1] = {0x4E82};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F91B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F91B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F91B = {.cp = 0xF91B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F91B, .cde = &lxb_unicode_decomposition_c_F91B, .kde = &lxb_unicode_decomposition_k_F91B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F91C[1] = {0x5375};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F91C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F91C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F91C[1] = {0x5375};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F91C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F91C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F91C[1] = {0x5375};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F91C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F91C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F91C = {.cp = 0xF91C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F91C, .cde = &lxb_unicode_decomposition_c_F91C, .kde = &lxb_unicode_decomposition_k_F91C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F91D[1] = {0x6B04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F91D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F91D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F91D[1] = {0x6B04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F91D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F91D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F91D[1] = {0x6B04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F91D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F91D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F91D = {.cp = 0xF91D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F91D, .cde = &lxb_unicode_decomposition_c_F91D, .kde = &lxb_unicode_decomposition_k_F91D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F91E[1] = {0x721B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F91E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F91E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F91E[1] = {0x721B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F91E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F91E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F91E[1] = {0x721B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F91E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F91E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F91E = {.cp = 0xF91E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F91E, .cde = &lxb_unicode_decomposition_c_F91E, .kde = &lxb_unicode_decomposition_k_F91E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F91F[1] = {0x862D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F91F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F91F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F91F[1] = {0x862D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F91F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F91F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F91F[1] = {0x862D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F91F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F91F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F91F = {.cp = 0xF91F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F91F, .cde = &lxb_unicode_decomposition_c_F91F, .kde = &lxb_unicode_decomposition_k_F91F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F920[1] = {0x9E1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F920 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F920, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F920[1] = {0x9E1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F920 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F920, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F920[1] = {0x9E1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F920 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F920, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F920 = {.cp = 0xF920, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F920, .cde = &lxb_unicode_decomposition_c_F920, .kde = &lxb_unicode_decomposition_k_F920};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F921[1] = {0x5D50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F921 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F921, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F921[1] = {0x5D50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F921 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F921, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F921[1] = {0x5D50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F921 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F921, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F921 = {.cp = 0xF921, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F921, .cde = &lxb_unicode_decomposition_c_F921, .kde = &lxb_unicode_decomposition_k_F921};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F922[1] = {0x6FEB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F922 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F922, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F922[1] = {0x6FEB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F922 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F922, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F922[1] = {0x6FEB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F922 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F922, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F922 = {.cp = 0xF922, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F922, .cde = &lxb_unicode_decomposition_c_F922, .kde = &lxb_unicode_decomposition_k_F922};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F923[1] = {0x85CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F923 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F923, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F923[1] = {0x85CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F923 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F923, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F923[1] = {0x85CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F923 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F923, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F923 = {.cp = 0xF923, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F923, .cde = &lxb_unicode_decomposition_c_F923, .kde = &lxb_unicode_decomposition_k_F923};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F924[1] = {0x8964};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F924 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F924, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F924[1] = {0x8964};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F924 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F924, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F924[1] = {0x8964};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F924 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F924, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F924 = {.cp = 0xF924, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F924, .cde = &lxb_unicode_decomposition_c_F924, .kde = &lxb_unicode_decomposition_k_F924};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F925[1] = {0x62C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F925 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F925, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F925[1] = {0x62C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F925 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F925, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F925[1] = {0x62C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F925 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F925, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F925 = {.cp = 0xF925, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F925, .cde = &lxb_unicode_decomposition_c_F925, .kde = &lxb_unicode_decomposition_k_F925};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F926[1] = {0x81D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F926 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F926, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F926[1] = {0x81D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F926 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F926, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F926[1] = {0x81D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F926 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F926, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F926 = {.cp = 0xF926, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F926, .cde = &lxb_unicode_decomposition_c_F926, .kde = &lxb_unicode_decomposition_k_F926};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F927[1] = {0x881F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F927 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F927, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F927[1] = {0x881F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F927 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F927, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F927[1] = {0x881F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F927 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F927, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F927 = {.cp = 0xF927, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F927, .cde = &lxb_unicode_decomposition_c_F927, .kde = &lxb_unicode_decomposition_k_F927};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F928[1] = {0x5ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F928 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F928, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F928[1] = {0x5ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F928 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F928, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F928[1] = {0x5ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F928 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F928, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F928 = {.cp = 0xF928, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F928, .cde = &lxb_unicode_decomposition_c_F928, .kde = &lxb_unicode_decomposition_k_F928};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F929[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F929, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F929[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F929, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F929[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F929, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F929 = {.cp = 0xF929, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F929, .cde = &lxb_unicode_decomposition_c_F929, .kde = &lxb_unicode_decomposition_k_F929};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F92A[1] = {0x6D6A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F92A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F92A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F92A[1] = {0x6D6A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F92A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F92A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F92A[1] = {0x6D6A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F92A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F92A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F92A = {.cp = 0xF92A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F92A, .cde = &lxb_unicode_decomposition_c_F92A, .kde = &lxb_unicode_decomposition_k_F92A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F92B[1] = {0x72FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F92B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F92B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F92B[1] = {0x72FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F92B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F92B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F92B[1] = {0x72FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F92B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F92B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F92B = {.cp = 0xF92B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F92B, .cde = &lxb_unicode_decomposition_c_F92B, .kde = &lxb_unicode_decomposition_k_F92B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F92C[1] = {0x90CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F92C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F92C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F92C[1] = {0x90CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F92C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F92C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F92C[1] = {0x90CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F92C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F92C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F92C = {.cp = 0xF92C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F92C, .cde = &lxb_unicode_decomposition_c_F92C, .kde = &lxb_unicode_decomposition_k_F92C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F92D[1] = {0x4F86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F92D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F92D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F92D[1] = {0x4F86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F92D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F92D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F92D[1] = {0x4F86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F92D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F92D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F92D = {.cp = 0xF92D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F92D, .cde = &lxb_unicode_decomposition_c_F92D, .kde = &lxb_unicode_decomposition_k_F92D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F92E[1] = {0x51B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F92E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F92E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F92E[1] = {0x51B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F92E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F92E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F92E[1] = {0x51B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F92E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F92E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F92E = {.cp = 0xF92E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F92E, .cde = &lxb_unicode_decomposition_c_F92E, .kde = &lxb_unicode_decomposition_k_F92E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F92F[1] = {0x52DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F92F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F92F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F92F[1] = {0x52DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F92F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F92F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F92F[1] = {0x52DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F92F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F92F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F92F = {.cp = 0xF92F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F92F, .cde = &lxb_unicode_decomposition_c_F92F, .kde = &lxb_unicode_decomposition_k_F92F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F930[1] = {0x64C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F930 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F930, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F930[1] = {0x64C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F930 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F930, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F930[1] = {0x64C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F930 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F930, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F930 = {.cp = 0xF930, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F930, .cde = &lxb_unicode_decomposition_c_F930, .kde = &lxb_unicode_decomposition_k_F930};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F931[1] = {0x6AD3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F931, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F931[1] = {0x6AD3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F931, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F931[1] = {0x6AD3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F931, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F931 = {.cp = 0xF931, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F931, .cde = &lxb_unicode_decomposition_c_F931, .kde = &lxb_unicode_decomposition_k_F931};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F932[1] = {0x7210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F932 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F932, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F932[1] = {0x7210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F932 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F932, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F932[1] = {0x7210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F932 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F932, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F932 = {.cp = 0xF932, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F932, .cde = &lxb_unicode_decomposition_c_F932, .kde = &lxb_unicode_decomposition_k_F932};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F933[1] = {0x76E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F933 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F933, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F933[1] = {0x76E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F933 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F933, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F933[1] = {0x76E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F933 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F933, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F933 = {.cp = 0xF933, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F933, .cde = &lxb_unicode_decomposition_c_F933, .kde = &lxb_unicode_decomposition_k_F933};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F934[1] = {0x8001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F934, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F934[1] = {0x8001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F934, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F934[1] = {0x8001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F934, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F934 = {.cp = 0xF934, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F934, .cde = &lxb_unicode_decomposition_c_F934, .kde = &lxb_unicode_decomposition_k_F934};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F935[1] = {0x8606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F935 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F935, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F935[1] = {0x8606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F935 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F935, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F935[1] = {0x8606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F935 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F935, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F935 = {.cp = 0xF935, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F935, .cde = &lxb_unicode_decomposition_c_F935, .kde = &lxb_unicode_decomposition_k_F935};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F936[1] = {0x865C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F936 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F936, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F936[1] = {0x865C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F936 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F936, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F936[1] = {0x865C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F936 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F936, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F936 = {.cp = 0xF936, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F936, .cde = &lxb_unicode_decomposition_c_F936, .kde = &lxb_unicode_decomposition_k_F936};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F937[1] = {0x8DEF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F937 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F937, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F937[1] = {0x8DEF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F937 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F937, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F937[1] = {0x8DEF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F937 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F937, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F937 = {.cp = 0xF937, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F937, .cde = &lxb_unicode_decomposition_c_F937, .kde = &lxb_unicode_decomposition_k_F937};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F938[1] = {0x9732};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F938 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F938, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F938[1] = {0x9732};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F938 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F938, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F938[1] = {0x9732};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F938 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F938, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F938 = {.cp = 0xF938, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F938, .cde = &lxb_unicode_decomposition_c_F938, .kde = &lxb_unicode_decomposition_k_F938};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F939[1] = {0x9B6F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F939 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F939, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F939[1] = {0x9B6F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F939 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F939, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F939[1] = {0x9B6F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F939 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F939, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F939 = {.cp = 0xF939, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F939, .cde = &lxb_unicode_decomposition_c_F939, .kde = &lxb_unicode_decomposition_k_F939};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F93A[1] = {0x9DFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F93A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F93A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F93A[1] = {0x9DFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F93A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F93A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F93A[1] = {0x9DFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F93A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F93A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F93A = {.cp = 0xF93A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F93A, .cde = &lxb_unicode_decomposition_c_F93A, .kde = &lxb_unicode_decomposition_k_F93A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F93B[1] = {0x788C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F93B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F93B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F93B[1] = {0x788C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F93B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F93B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F93B[1] = {0x788C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F93B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F93B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F93B = {.cp = 0xF93B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F93B, .cde = &lxb_unicode_decomposition_c_F93B, .kde = &lxb_unicode_decomposition_k_F93B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F93C[1] = {0x797F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F93C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F93C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F93C[1] = {0x797F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F93C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F93C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F93C[1] = {0x797F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F93C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F93C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F93C = {.cp = 0xF93C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F93C, .cde = &lxb_unicode_decomposition_c_F93C, .kde = &lxb_unicode_decomposition_k_F93C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F93D[1] = {0x7DA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F93D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F93D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F93D[1] = {0x7DA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F93D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F93D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F93D[1] = {0x7DA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F93D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F93D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F93D = {.cp = 0xF93D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F93D, .cde = &lxb_unicode_decomposition_c_F93D, .kde = &lxb_unicode_decomposition_k_F93D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F93E[1] = {0x83C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F93E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F93E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F93E[1] = {0x83C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F93E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F93E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F93E[1] = {0x83C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F93E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F93E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F93E = {.cp = 0xF93E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F93E, .cde = &lxb_unicode_decomposition_c_F93E, .kde = &lxb_unicode_decomposition_k_F93E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F93F[1] = {0x9304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F93F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F93F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F93F[1] = {0x9304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F93F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F93F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F93F[1] = {0x9304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F93F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F93F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F93F = {.cp = 0xF93F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F93F, .cde = &lxb_unicode_decomposition_c_F93F, .kde = &lxb_unicode_decomposition_k_F93F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F940[1] = {0x9E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F940 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F940, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F940[1] = {0x9E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F940 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F940, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F940[1] = {0x9E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F940 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F940, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F940 = {.cp = 0xF940, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F940, .cde = &lxb_unicode_decomposition_c_F940, .kde = &lxb_unicode_decomposition_k_F940};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F941[1] = {0x8AD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F941 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F941, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F941[1] = {0x8AD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F941 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F941, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F941[1] = {0x8AD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F941 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F941, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F941 = {.cp = 0xF941, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F941, .cde = &lxb_unicode_decomposition_c_F941, .kde = &lxb_unicode_decomposition_k_F941};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F942[1] = {0x58DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F942 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F942, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F942[1] = {0x58DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F942 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F942, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F942[1] = {0x58DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F942 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F942, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F942 = {.cp = 0xF942, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F942, .cde = &lxb_unicode_decomposition_c_F942, .kde = &lxb_unicode_decomposition_k_F942};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F943[1] = {0x5F04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F943 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F943, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F943[1] = {0x5F04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F943 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F943, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F943[1] = {0x5F04};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F943 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F943, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F943 = {.cp = 0xF943, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F943, .cde = &lxb_unicode_decomposition_c_F943, .kde = &lxb_unicode_decomposition_k_F943};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F944[1] = {0x7C60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F944 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F944, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F944[1] = {0x7C60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F944 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F944, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F944[1] = {0x7C60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F944 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F944, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F944 = {.cp = 0xF944, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F944, .cde = &lxb_unicode_decomposition_c_F944, .kde = &lxb_unicode_decomposition_k_F944};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F945[1] = {0x807E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F945 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F945, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F945[1] = {0x807E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F945 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F945, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F945[1] = {0x807E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F945 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F945, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F945 = {.cp = 0xF945, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F945, .cde = &lxb_unicode_decomposition_c_F945, .kde = &lxb_unicode_decomposition_k_F945};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F946[1] = {0x7262};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F946 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F946, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F946[1] = {0x7262};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F946 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F946, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F946[1] = {0x7262};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F946 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F946, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F946 = {.cp = 0xF946, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F946, .cde = &lxb_unicode_decomposition_c_F946, .kde = &lxb_unicode_decomposition_k_F946};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F947[1] = {0x78CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F947 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F947, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F947[1] = {0x78CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F947 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F947, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F947[1] = {0x78CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F947 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F947, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F947 = {.cp = 0xF947, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F947, .cde = &lxb_unicode_decomposition_c_F947, .kde = &lxb_unicode_decomposition_k_F947};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F948[1] = {0x8CC2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F948 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F948, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F948[1] = {0x8CC2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F948 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F948, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F948[1] = {0x8CC2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F948 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F948, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F948 = {.cp = 0xF948, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F948, .cde = &lxb_unicode_decomposition_c_F948, .kde = &lxb_unicode_decomposition_k_F948};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F949[1] = {0x96F7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F949 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F949, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F949[1] = {0x96F7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F949 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F949, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F949[1] = {0x96F7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F949 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F949, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F949 = {.cp = 0xF949, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F949, .cde = &lxb_unicode_decomposition_c_F949, .kde = &lxb_unicode_decomposition_k_F949};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F94A[1] = {0x58D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F94A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F94A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F94A[1] = {0x58D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F94A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F94A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F94A[1] = {0x58D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F94A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F94A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F94A = {.cp = 0xF94A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F94A, .cde = &lxb_unicode_decomposition_c_F94A, .kde = &lxb_unicode_decomposition_k_F94A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F94B[1] = {0x5C62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F94B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F94B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F94B[1] = {0x5C62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F94B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F94B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F94B[1] = {0x5C62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F94B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F94B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F94B = {.cp = 0xF94B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F94B, .cde = &lxb_unicode_decomposition_c_F94B, .kde = &lxb_unicode_decomposition_k_F94B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F94C[1] = {0x6A13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F94C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F94C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F94C[1] = {0x6A13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F94C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F94C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F94C[1] = {0x6A13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F94C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F94C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F94C = {.cp = 0xF94C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F94C, .cde = &lxb_unicode_decomposition_c_F94C, .kde = &lxb_unicode_decomposition_k_F94C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F94D[1] = {0x6DDA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F94D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F94D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F94D[1] = {0x6DDA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F94D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F94D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F94D[1] = {0x6DDA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F94D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F94D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F94D = {.cp = 0xF94D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F94D, .cde = &lxb_unicode_decomposition_c_F94D, .kde = &lxb_unicode_decomposition_k_F94D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F94E[1] = {0x6F0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F94E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F94E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F94E[1] = {0x6F0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F94E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F94E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F94E[1] = {0x6F0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F94E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F94E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F94E = {.cp = 0xF94E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F94E, .cde = &lxb_unicode_decomposition_c_F94E, .kde = &lxb_unicode_decomposition_k_F94E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F94F[1] = {0x7D2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F94F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F94F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F94F[1] = {0x7D2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F94F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F94F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F94F[1] = {0x7D2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F94F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F94F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F94F = {.cp = 0xF94F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F94F, .cde = &lxb_unicode_decomposition_c_F94F, .kde = &lxb_unicode_decomposition_k_F94F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F950[1] = {0x7E37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F950 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F950, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F950[1] = {0x7E37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F950 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F950, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F950[1] = {0x7E37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F950 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F950, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F950 = {.cp = 0xF950, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F950, .cde = &lxb_unicode_decomposition_c_F950, .kde = &lxb_unicode_decomposition_k_F950};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F951[1] = {0x964B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F951 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F951, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F951[1] = {0x964B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F951 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F951, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F951[1] = {0x964B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F951 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F951, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F951 = {.cp = 0xF951, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F951, .cde = &lxb_unicode_decomposition_c_F951, .kde = &lxb_unicode_decomposition_k_F951};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F952[1] = {0x52D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F952 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F952, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F952[1] = {0x52D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F952 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F952, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F952[1] = {0x52D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F952 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F952, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F952 = {.cp = 0xF952, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F952, .cde = &lxb_unicode_decomposition_c_F952, .kde = &lxb_unicode_decomposition_k_F952};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F953[1] = {0x808B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F953 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F953, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F953[1] = {0x808B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F953 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F953, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F953[1] = {0x808B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F953 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F953, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F953 = {.cp = 0xF953, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F953, .cde = &lxb_unicode_decomposition_c_F953, .kde = &lxb_unicode_decomposition_k_F953};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F954[1] = {0x51DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F954 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F954, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F954[1] = {0x51DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F954 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F954, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F954[1] = {0x51DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F954 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F954, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F954 = {.cp = 0xF954, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F954, .cde = &lxb_unicode_decomposition_c_F954, .kde = &lxb_unicode_decomposition_k_F954};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F955[1] = {0x51CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F955 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F955, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F955[1] = {0x51CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F955 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F955, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F955[1] = {0x51CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F955 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F955, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F955 = {.cp = 0xF955, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F955, .cde = &lxb_unicode_decomposition_c_F955, .kde = &lxb_unicode_decomposition_k_F955};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F956[1] = {0x7A1C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F956 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F956, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F956[1] = {0x7A1C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F956 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F956, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F956[1] = {0x7A1C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F956 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F956, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F956 = {.cp = 0xF956, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F956, .cde = &lxb_unicode_decomposition_c_F956, .kde = &lxb_unicode_decomposition_k_F956};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F957[1] = {0x7DBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F957 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F957, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F957[1] = {0x7DBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F957 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F957, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F957[1] = {0x7DBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F957 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F957, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F957 = {.cp = 0xF957, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F957, .cde = &lxb_unicode_decomposition_c_F957, .kde = &lxb_unicode_decomposition_k_F957};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F958[1] = {0x83F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F958, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F958[1] = {0x83F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F958, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F958[1] = {0x83F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F958, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F958 = {.cp = 0xF958, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F958, .cde = &lxb_unicode_decomposition_c_F958, .kde = &lxb_unicode_decomposition_k_F958};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F959[1] = {0x9675};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F959, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F959[1] = {0x9675};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F959, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F959[1] = {0x9675};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F959, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F959 = {.cp = 0xF959, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F959, .cde = &lxb_unicode_decomposition_c_F959, .kde = &lxb_unicode_decomposition_k_F959};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F95A[1] = {0x8B80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F95A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F95A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F95A[1] = {0x8B80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F95A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F95A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F95A[1] = {0x8B80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F95A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F95A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F95A = {.cp = 0xF95A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F95A, .cde = &lxb_unicode_decomposition_c_F95A, .kde = &lxb_unicode_decomposition_k_F95A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F95B[1] = {0x62CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F95B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F95B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F95B[1] = {0x62CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F95B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F95B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F95B[1] = {0x62CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F95B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F95B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F95B = {.cp = 0xF95B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F95B, .cde = &lxb_unicode_decomposition_c_F95B, .kde = &lxb_unicode_decomposition_k_F95B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F95C[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F95C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F95C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F95C[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F95C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F95C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F95C[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F95C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F95C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F95C = {.cp = 0xF95C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F95C, .cde = &lxb_unicode_decomposition_c_F95C, .kde = &lxb_unicode_decomposition_k_F95C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F95D[1] = {0x8AFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F95D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F95D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F95D[1] = {0x8AFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F95D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F95D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F95D[1] = {0x8AFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F95D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F95D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F95D = {.cp = 0xF95D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F95D, .cde = &lxb_unicode_decomposition_c_F95D, .kde = &lxb_unicode_decomposition_k_F95D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F95E[1] = {0x4E39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F95E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F95E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F95E[1] = {0x4E39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F95E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F95E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F95E[1] = {0x4E39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F95E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F95E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F95E = {.cp = 0xF95E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F95E, .cde = &lxb_unicode_decomposition_c_F95E, .kde = &lxb_unicode_decomposition_k_F95E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F95F[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F95F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F95F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F95F[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F95F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F95F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F95F[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F95F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F95F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F95F = {.cp = 0xF95F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F95F, .cde = &lxb_unicode_decomposition_c_F95F, .kde = &lxb_unicode_decomposition_k_F95F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F960[1] = {0x6012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F960 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F960, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F960[1] = {0x6012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F960 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F960, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F960[1] = {0x6012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F960 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F960, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F960 = {.cp = 0xF960, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F960, .cde = &lxb_unicode_decomposition_c_F960, .kde = &lxb_unicode_decomposition_k_F960};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F961[1] = {0x7387};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F961 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F961, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F961[1] = {0x7387};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F961 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F961, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F961[1] = {0x7387};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F961 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F961, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F961 = {.cp = 0xF961, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F961, .cde = &lxb_unicode_decomposition_c_F961, .kde = &lxb_unicode_decomposition_k_F961};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F962[1] = {0x7570};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F962 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F962, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F962[1] = {0x7570};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F962 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F962, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F962[1] = {0x7570};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F962 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F962, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F962 = {.cp = 0xF962, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F962, .cde = &lxb_unicode_decomposition_c_F962, .kde = &lxb_unicode_decomposition_k_F962};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F963[1] = {0x5317};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F963 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F963, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F963[1] = {0x5317};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F963 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F963, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F963[1] = {0x5317};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F963 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F963, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F963 = {.cp = 0xF963, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F963, .cde = &lxb_unicode_decomposition_c_F963, .kde = &lxb_unicode_decomposition_k_F963};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F964[1] = {0x78FB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F964 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F964, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F964[1] = {0x78FB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F964 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F964, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F964[1] = {0x78FB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F964 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F964, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F964 = {.cp = 0xF964, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F964, .cde = &lxb_unicode_decomposition_c_F964, .kde = &lxb_unicode_decomposition_k_F964};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F965[1] = {0x4FBF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F965 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F965, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F965[1] = {0x4FBF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F965 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F965, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F965[1] = {0x4FBF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F965 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F965, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F965 = {.cp = 0xF965, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F965, .cde = &lxb_unicode_decomposition_c_F965, .kde = &lxb_unicode_decomposition_k_F965};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F966[1] = {0x5FA9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F966 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F966, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F966[1] = {0x5FA9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F966 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F966, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F966[1] = {0x5FA9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F966 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F966, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F966 = {.cp = 0xF966, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F966, .cde = &lxb_unicode_decomposition_c_F966, .kde = &lxb_unicode_decomposition_k_F966};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F967[1] = {0x4E0D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F967 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F967, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F967[1] = {0x4E0D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F967 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F967, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F967[1] = {0x4E0D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F967 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F967, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F967 = {.cp = 0xF967, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F967, .cde = &lxb_unicode_decomposition_c_F967, .kde = &lxb_unicode_decomposition_k_F967};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F968[1] = {0x6CCC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F968 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F968, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F968[1] = {0x6CCC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F968 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F968, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F968[1] = {0x6CCC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F968 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F968, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F968 = {.cp = 0xF968, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F968, .cde = &lxb_unicode_decomposition_c_F968, .kde = &lxb_unicode_decomposition_k_F968};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F969[1] = {0x6578};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F969 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F969, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F969[1] = {0x6578};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F969 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F969, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F969[1] = {0x6578};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F969 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F969, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F969 = {.cp = 0xF969, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F969, .cde = &lxb_unicode_decomposition_c_F969, .kde = &lxb_unicode_decomposition_k_F969};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F96A[1] = {0x7D22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F96A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F96A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F96A[1] = {0x7D22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F96A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F96A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F96A[1] = {0x7D22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F96A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F96A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F96A = {.cp = 0xF96A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F96A, .cde = &lxb_unicode_decomposition_c_F96A, .kde = &lxb_unicode_decomposition_k_F96A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F96B[1] = {0x53C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F96B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F96B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F96B[1] = {0x53C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F96B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F96B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F96B[1] = {0x53C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F96B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F96B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F96B = {.cp = 0xF96B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F96B, .cde = &lxb_unicode_decomposition_c_F96B, .kde = &lxb_unicode_decomposition_k_F96B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F96C[1] = {0x585E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F96C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F96C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F96C[1] = {0x585E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F96C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F96C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F96C[1] = {0x585E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F96C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F96C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F96C = {.cp = 0xF96C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F96C, .cde = &lxb_unicode_decomposition_c_F96C, .kde = &lxb_unicode_decomposition_k_F96C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F96D[1] = {0x7701};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F96D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F96D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F96D[1] = {0x7701};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F96D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F96D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F96D[1] = {0x7701};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F96D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F96D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F96D = {.cp = 0xF96D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F96D, .cde = &lxb_unicode_decomposition_c_F96D, .kde = &lxb_unicode_decomposition_k_F96D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F96E[1] = {0x8449};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F96E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F96E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F96E[1] = {0x8449};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F96E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F96E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F96E[1] = {0x8449};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F96E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F96E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F96E = {.cp = 0xF96E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F96E, .cde = &lxb_unicode_decomposition_c_F96E, .kde = &lxb_unicode_decomposition_k_F96E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F96F[1] = {0x8AAA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F96F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F96F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F96F[1] = {0x8AAA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F96F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F96F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F96F[1] = {0x8AAA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F96F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F96F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F96F = {.cp = 0xF96F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F96F, .cde = &lxb_unicode_decomposition_c_F96F, .kde = &lxb_unicode_decomposition_k_F96F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F970[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F970 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F970, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F970[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F970 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F970, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F970[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F970 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F970, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F970 = {.cp = 0xF970, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F970, .cde = &lxb_unicode_decomposition_c_F970, .kde = &lxb_unicode_decomposition_k_F970};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F971[1] = {0x8FB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F971 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F971, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F971[1] = {0x8FB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F971 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F971, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F971[1] = {0x8FB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F971 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F971, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F971 = {.cp = 0xF971, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F971, .cde = &lxb_unicode_decomposition_c_F971, .kde = &lxb_unicode_decomposition_k_F971};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F972[1] = {0x6C88};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F972 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F972, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F972[1] = {0x6C88};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F972 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F972, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F972[1] = {0x6C88};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F972 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F972, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F972 = {.cp = 0xF972, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F972, .cde = &lxb_unicode_decomposition_c_F972, .kde = &lxb_unicode_decomposition_k_F972};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F973[1] = {0x62FE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F973 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F973, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F973[1] = {0x62FE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F973 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F973, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F973[1] = {0x62FE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F973 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F973, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F973 = {.cp = 0xF973, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F973, .cde = &lxb_unicode_decomposition_c_F973, .kde = &lxb_unicode_decomposition_k_F973};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F974[1] = {0x82E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F974 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F974, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F974[1] = {0x82E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F974 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F974, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F974[1] = {0x82E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F974 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F974, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F974 = {.cp = 0xF974, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F974, .cde = &lxb_unicode_decomposition_c_F974, .kde = &lxb_unicode_decomposition_k_F974};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F975[1] = {0x63A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F975 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F975, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F975[1] = {0x63A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F975 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F975, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F975[1] = {0x63A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F975 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F975, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F975 = {.cp = 0xF975, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F975, .cde = &lxb_unicode_decomposition_c_F975, .kde = &lxb_unicode_decomposition_k_F975};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F976[1] = {0x7565};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F976 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F976, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F976[1] = {0x7565};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F976 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F976, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F976[1] = {0x7565};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F976 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F976, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F976 = {.cp = 0xF976, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F976, .cde = &lxb_unicode_decomposition_c_F976, .kde = &lxb_unicode_decomposition_k_F976};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F977[1] = {0x4EAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F977 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F977, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F977[1] = {0x4EAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F977 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F977, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F977[1] = {0x4EAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F977 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F977, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F977 = {.cp = 0xF977, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F977, .cde = &lxb_unicode_decomposition_c_F977, .kde = &lxb_unicode_decomposition_k_F977};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F978[1] = {0x5169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F978 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F978, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F978[1] = {0x5169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F978 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F978, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F978[1] = {0x5169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F978 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F978, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F978 = {.cp = 0xF978, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F978, .cde = &lxb_unicode_decomposition_c_F978, .kde = &lxb_unicode_decomposition_k_F978};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F979[1] = {0x51C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F979 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F979, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F979[1] = {0x51C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F979 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F979, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F979[1] = {0x51C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F979 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F979, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F979 = {.cp = 0xF979, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F979, .cde = &lxb_unicode_decomposition_c_F979, .kde = &lxb_unicode_decomposition_k_F979};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F97A[1] = {0x6881};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F97A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F97A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F97A[1] = {0x6881};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F97A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F97A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F97A[1] = {0x6881};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F97A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F97A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F97A = {.cp = 0xF97A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F97A, .cde = &lxb_unicode_decomposition_c_F97A, .kde = &lxb_unicode_decomposition_k_F97A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F97B[1] = {0x7CE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F97B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F97B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F97B[1] = {0x7CE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F97B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F97B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F97B[1] = {0x7CE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F97B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F97B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F97B = {.cp = 0xF97B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F97B, .cde = &lxb_unicode_decomposition_c_F97B, .kde = &lxb_unicode_decomposition_k_F97B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F97C[1] = {0x826F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F97C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F97C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F97C[1] = {0x826F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F97C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F97C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F97C[1] = {0x826F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F97C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F97C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F97C = {.cp = 0xF97C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F97C, .cde = &lxb_unicode_decomposition_c_F97C, .kde = &lxb_unicode_decomposition_k_F97C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F97D[1] = {0x8AD2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F97D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F97D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F97D[1] = {0x8AD2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F97D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F97D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F97D[1] = {0x8AD2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F97D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F97D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F97D = {.cp = 0xF97D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F97D, .cde = &lxb_unicode_decomposition_c_F97D, .kde = &lxb_unicode_decomposition_k_F97D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F97E[1] = {0x91CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F97E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F97E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F97E[1] = {0x91CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F97E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F97E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F97E[1] = {0x91CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F97E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F97E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F97E = {.cp = 0xF97E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F97E, .cde = &lxb_unicode_decomposition_c_F97E, .kde = &lxb_unicode_decomposition_k_F97E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F97F[1] = {0x52F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F97F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F97F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F97F[1] = {0x52F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F97F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F97F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F97F[1] = {0x52F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F97F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F97F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F97F = {.cp = 0xF97F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F97F, .cde = &lxb_unicode_decomposition_c_F97F, .kde = &lxb_unicode_decomposition_k_F97F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F980[1] = {0x5442};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F980 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F980, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F980[1] = {0x5442};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F980 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F980, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F980[1] = {0x5442};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F980 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F980, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F980 = {.cp = 0xF980, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F980, .cde = &lxb_unicode_decomposition_c_F980, .kde = &lxb_unicode_decomposition_k_F980};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F981[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F981 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F981, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F981[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F981 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F981, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F981[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F981 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F981, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F981 = {.cp = 0xF981, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F981, .cde = &lxb_unicode_decomposition_c_F981, .kde = &lxb_unicode_decomposition_k_F981};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F982[1] = {0x5EEC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F982 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F982, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F982[1] = {0x5EEC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F982 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F982, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F982[1] = {0x5EEC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F982 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F982, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F982 = {.cp = 0xF982, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F982, .cde = &lxb_unicode_decomposition_c_F982, .kde = &lxb_unicode_decomposition_k_F982};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F983[1] = {0x65C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F983 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F983, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F983[1] = {0x65C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F983 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F983, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F983[1] = {0x65C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F983 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F983, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F983 = {.cp = 0xF983, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F983, .cde = &lxb_unicode_decomposition_c_F983, .kde = &lxb_unicode_decomposition_k_F983};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F984[1] = {0x6FFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F984 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F984, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F984[1] = {0x6FFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F984 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F984, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F984[1] = {0x6FFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F984 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F984, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F984 = {.cp = 0xF984, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F984, .cde = &lxb_unicode_decomposition_c_F984, .kde = &lxb_unicode_decomposition_k_F984};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F985[1] = {0x792A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F985 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F985, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F985[1] = {0x792A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F985 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F985, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F985[1] = {0x792A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F985 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F985, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F985 = {.cp = 0xF985, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F985, .cde = &lxb_unicode_decomposition_c_F985, .kde = &lxb_unicode_decomposition_k_F985};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F986[1] = {0x95AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F986 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F986, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F986[1] = {0x95AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F986 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F986, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F986[1] = {0x95AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F986 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F986, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F986 = {.cp = 0xF986, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F986, .cde = &lxb_unicode_decomposition_c_F986, .kde = &lxb_unicode_decomposition_k_F986};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F987[1] = {0x9A6A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F987 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F987, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F987[1] = {0x9A6A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F987 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F987, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F987[1] = {0x9A6A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F987 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F987, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F987 = {.cp = 0xF987, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F987, .cde = &lxb_unicode_decomposition_c_F987, .kde = &lxb_unicode_decomposition_k_F987};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F988[1] = {0x9E97};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F988 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F988, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F988[1] = {0x9E97};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F988 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F988, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F988[1] = {0x9E97};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F988 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F988, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F988 = {.cp = 0xF988, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F988, .cde = &lxb_unicode_decomposition_c_F988, .kde = &lxb_unicode_decomposition_k_F988};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F989[1] = {0x9ECE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F989 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F989, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F989[1] = {0x9ECE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F989 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F989, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F989[1] = {0x9ECE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F989 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F989, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F989 = {.cp = 0xF989, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F989, .cde = &lxb_unicode_decomposition_c_F989, .kde = &lxb_unicode_decomposition_k_F989};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F98A[1] = {0x529B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F98A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F98A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F98A[1] = {0x529B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F98A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F98A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F98A[1] = {0x529B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F98A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F98A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F98A = {.cp = 0xF98A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F98A, .cde = &lxb_unicode_decomposition_c_F98A, .kde = &lxb_unicode_decomposition_k_F98A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F98B[1] = {0x66C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F98B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F98B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F98B[1] = {0x66C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F98B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F98B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F98B[1] = {0x66C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F98B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F98B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F98B = {.cp = 0xF98B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F98B, .cde = &lxb_unicode_decomposition_c_F98B, .kde = &lxb_unicode_decomposition_k_F98B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F98C[1] = {0x6B77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F98C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F98C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F98C[1] = {0x6B77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F98C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F98C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F98C[1] = {0x6B77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F98C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F98C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F98C = {.cp = 0xF98C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F98C, .cde = &lxb_unicode_decomposition_c_F98C, .kde = &lxb_unicode_decomposition_k_F98C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F98D[1] = {0x8F62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F98D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F98D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F98D[1] = {0x8F62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F98D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F98D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F98D[1] = {0x8F62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F98D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F98D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F98D = {.cp = 0xF98D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F98D, .cde = &lxb_unicode_decomposition_c_F98D, .kde = &lxb_unicode_decomposition_k_F98D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F98E[1] = {0x5E74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F98E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F98E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F98E[1] = {0x5E74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F98E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F98E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F98E[1] = {0x5E74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F98E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F98E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F98E = {.cp = 0xF98E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F98E, .cde = &lxb_unicode_decomposition_c_F98E, .kde = &lxb_unicode_decomposition_k_F98E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F98F[1] = {0x6190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F98F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F98F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F98F[1] = {0x6190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F98F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F98F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F98F[1] = {0x6190};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F98F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F98F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F98F = {.cp = 0xF98F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F98F, .cde = &lxb_unicode_decomposition_c_F98F, .kde = &lxb_unicode_decomposition_k_F98F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F990[1] = {0x6200};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F990 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F990, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F990[1] = {0x6200};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F990 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F990, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F990[1] = {0x6200};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F990 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F990, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F990 = {.cp = 0xF990, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F990, .cde = &lxb_unicode_decomposition_c_F990, .kde = &lxb_unicode_decomposition_k_F990};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F991[1] = {0x649A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F991 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F991, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F991[1] = {0x649A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F991 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F991, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F991[1] = {0x649A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F991 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F991, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F991 = {.cp = 0xF991, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F991, .cde = &lxb_unicode_decomposition_c_F991, .kde = &lxb_unicode_decomposition_k_F991};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F992[1] = {0x6F23};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F992 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F992, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F992[1] = {0x6F23};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F992 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F992, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F992[1] = {0x6F23};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F992 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F992, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F992 = {.cp = 0xF992, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F992, .cde = &lxb_unicode_decomposition_c_F992, .kde = &lxb_unicode_decomposition_k_F992};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F993[1] = {0x7149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F993 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F993, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F993[1] = {0x7149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F993 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F993, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F993[1] = {0x7149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F993 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F993, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F993 = {.cp = 0xF993, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F993, .cde = &lxb_unicode_decomposition_c_F993, .kde = &lxb_unicode_decomposition_k_F993};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F994[1] = {0x7489};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F994 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F994, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F994[1] = {0x7489};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F994 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F994, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F994[1] = {0x7489};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F994 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F994, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F994 = {.cp = 0xF994, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F994, .cde = &lxb_unicode_decomposition_c_F994, .kde = &lxb_unicode_decomposition_k_F994};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F995[1] = {0x79CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F995 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F995, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F995[1] = {0x79CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F995 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F995, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F995[1] = {0x79CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F995 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F995, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F995 = {.cp = 0xF995, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F995, .cde = &lxb_unicode_decomposition_c_F995, .kde = &lxb_unicode_decomposition_k_F995};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F996[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F996 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F996, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F996[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F996 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F996, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F996[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F996 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F996, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F996 = {.cp = 0xF996, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F996, .cde = &lxb_unicode_decomposition_c_F996, .kde = &lxb_unicode_decomposition_k_F996};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F997[1] = {0x806F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F997 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F997, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F997[1] = {0x806F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F997 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F997, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F997[1] = {0x806F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F997 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F997, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F997 = {.cp = 0xF997, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F997, .cde = &lxb_unicode_decomposition_c_F997, .kde = &lxb_unicode_decomposition_k_F997};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F998[1] = {0x8F26};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F998 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F998, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F998[1] = {0x8F26};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F998 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F998, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F998[1] = {0x8F26};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F998 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F998, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F998 = {.cp = 0xF998, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F998, .cde = &lxb_unicode_decomposition_c_F998, .kde = &lxb_unicode_decomposition_k_F998};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F999[1] = {0x84EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F999 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F999, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F999[1] = {0x84EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F999 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F999, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F999[1] = {0x84EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F999 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F999, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F999 = {.cp = 0xF999, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F999, .cde = &lxb_unicode_decomposition_c_F999, .kde = &lxb_unicode_decomposition_k_F999};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F99A[1] = {0x9023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F99A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F99A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F99A[1] = {0x9023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F99A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F99A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F99A[1] = {0x9023};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F99A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F99A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F99A = {.cp = 0xF99A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F99A, .cde = &lxb_unicode_decomposition_c_F99A, .kde = &lxb_unicode_decomposition_k_F99A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F99B[1] = {0x934A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F99B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F99B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F99B[1] = {0x934A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F99B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F99B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F99B[1] = {0x934A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F99B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F99B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F99B = {.cp = 0xF99B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F99B, .cde = &lxb_unicode_decomposition_c_F99B, .kde = &lxb_unicode_decomposition_k_F99B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F99C[1] = {0x5217};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F99C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F99C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F99C[1] = {0x5217};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F99C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F99C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F99C[1] = {0x5217};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F99C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F99C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F99C = {.cp = 0xF99C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F99C, .cde = &lxb_unicode_decomposition_c_F99C, .kde = &lxb_unicode_decomposition_k_F99C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F99D[1] = {0x52A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F99D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F99D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F99D[1] = {0x52A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F99D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F99D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F99D[1] = {0x52A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F99D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F99D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F99D = {.cp = 0xF99D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F99D, .cde = &lxb_unicode_decomposition_c_F99D, .kde = &lxb_unicode_decomposition_k_F99D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F99E[1] = {0x54BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F99E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F99E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F99E[1] = {0x54BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F99E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F99E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F99E[1] = {0x54BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F99E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F99E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F99E = {.cp = 0xF99E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F99E, .cde = &lxb_unicode_decomposition_c_F99E, .kde = &lxb_unicode_decomposition_k_F99E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F99F[1] = {0x70C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F99F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F99F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F99F[1] = {0x70C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F99F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F99F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F99F[1] = {0x70C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F99F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F99F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F99F = {.cp = 0xF99F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F99F, .cde = &lxb_unicode_decomposition_c_F99F, .kde = &lxb_unicode_decomposition_k_F99F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A0[1] = {0x88C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A0[1] = {0x88C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A0[1] = {0x88C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A0 = {.cp = 0xF9A0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A0, .cde = &lxb_unicode_decomposition_c_F9A0, .kde = &lxb_unicode_decomposition_k_F9A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A1[1] = {0x8AAA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A1[1] = {0x8AAA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A1[1] = {0x8AAA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A1 = {.cp = 0xF9A1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A1, .cde = &lxb_unicode_decomposition_c_F9A1, .kde = &lxb_unicode_decomposition_k_F9A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A2[1] = {0x5EC9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A2[1] = {0x5EC9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A2[1] = {0x5EC9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A2 = {.cp = 0xF9A2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A2, .cde = &lxb_unicode_decomposition_c_F9A2, .kde = &lxb_unicode_decomposition_k_F9A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A3[1] = {0x5FF5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A3[1] = {0x5FF5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A3[1] = {0x5FF5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A3 = {.cp = 0xF9A3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A3, .cde = &lxb_unicode_decomposition_c_F9A3, .kde = &lxb_unicode_decomposition_k_F9A3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A4[1] = {0x637B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A4[1] = {0x637B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A4[1] = {0x637B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A4 = {.cp = 0xF9A4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A4, .cde = &lxb_unicode_decomposition_c_F9A4, .kde = &lxb_unicode_decomposition_k_F9A4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A5[1] = {0x6BAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A5[1] = {0x6BAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A5[1] = {0x6BAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A5 = {.cp = 0xF9A5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A5, .cde = &lxb_unicode_decomposition_c_F9A5, .kde = &lxb_unicode_decomposition_k_F9A5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A6[1] = {0x7C3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A6[1] = {0x7C3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A6[1] = {0x7C3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A6 = {.cp = 0xF9A6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A6, .cde = &lxb_unicode_decomposition_c_F9A6, .kde = &lxb_unicode_decomposition_k_F9A6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A7[1] = {0x7375};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A7[1] = {0x7375};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A7[1] = {0x7375};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A7 = {.cp = 0xF9A7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A7, .cde = &lxb_unicode_decomposition_c_F9A7, .kde = &lxb_unicode_decomposition_k_F9A7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A8[1] = {0x4EE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A8[1] = {0x4EE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A8[1] = {0x4EE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A8 = {.cp = 0xF9A8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A8, .cde = &lxb_unicode_decomposition_c_F9A8, .kde = &lxb_unicode_decomposition_k_F9A8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9A9[1] = {0x56F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9A9[1] = {0x56F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9A9[1] = {0x56F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9A9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9A9 = {.cp = 0xF9A9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9A9, .cde = &lxb_unicode_decomposition_c_F9A9, .kde = &lxb_unicode_decomposition_k_F9A9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9AA[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9AA[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9AA[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9AA = {.cp = 0xF9AA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9AA, .cde = &lxb_unicode_decomposition_c_F9AA, .kde = &lxb_unicode_decomposition_k_F9AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9AB[1] = {0x5DBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9AB[1] = {0x5DBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9AB[1] = {0x5DBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9AB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9AB = {.cp = 0xF9AB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9AB, .cde = &lxb_unicode_decomposition_c_F9AB, .kde = &lxb_unicode_decomposition_k_F9AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9AC[1] = {0x601C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9AC[1] = {0x601C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9AC[1] = {0x601C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9AC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9AC = {.cp = 0xF9AC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9AC, .cde = &lxb_unicode_decomposition_c_F9AC, .kde = &lxb_unicode_decomposition_k_F9AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9AD[1] = {0x73B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9AD[1] = {0x73B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9AD[1] = {0x73B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9AD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9AD = {.cp = 0xF9AD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9AD, .cde = &lxb_unicode_decomposition_c_F9AD, .kde = &lxb_unicode_decomposition_k_F9AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9AE[1] = {0x7469};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9AE[1] = {0x7469};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9AE[1] = {0x7469};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9AE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9AE = {.cp = 0xF9AE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9AE, .cde = &lxb_unicode_decomposition_c_F9AE, .kde = &lxb_unicode_decomposition_k_F9AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9AF[1] = {0x7F9A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9AF[1] = {0x7F9A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9AF[1] = {0x7F9A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9AF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9AF = {.cp = 0xF9AF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9AF, .cde = &lxb_unicode_decomposition_c_F9AF, .kde = &lxb_unicode_decomposition_k_F9AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B0[1] = {0x8046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B0[1] = {0x8046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B0[1] = {0x8046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B0 = {.cp = 0xF9B0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B0, .cde = &lxb_unicode_decomposition_c_F9B0, .kde = &lxb_unicode_decomposition_k_F9B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B1[1] = {0x9234};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B1[1] = {0x9234};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B1[1] = {0x9234};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B1 = {.cp = 0xF9B1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B1, .cde = &lxb_unicode_decomposition_c_F9B1, .kde = &lxb_unicode_decomposition_k_F9B1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B2[1] = {0x96F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B2[1] = {0x96F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B2[1] = {0x96F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B2 = {.cp = 0xF9B2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B2, .cde = &lxb_unicode_decomposition_c_F9B2, .kde = &lxb_unicode_decomposition_k_F9B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B3[1] = {0x9748};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B3[1] = {0x9748};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B3[1] = {0x9748};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B3 = {.cp = 0xF9B3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B3, .cde = &lxb_unicode_decomposition_c_F9B3, .kde = &lxb_unicode_decomposition_k_F9B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B4[1] = {0x9818};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B4[1] = {0x9818};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B4[1] = {0x9818};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B4 = {.cp = 0xF9B4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B4, .cde = &lxb_unicode_decomposition_c_F9B4, .kde = &lxb_unicode_decomposition_k_F9B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B5[1] = {0x4F8B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B5[1] = {0x4F8B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B5[1] = {0x4F8B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B5 = {.cp = 0xF9B5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B5, .cde = &lxb_unicode_decomposition_c_F9B5, .kde = &lxb_unicode_decomposition_k_F9B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B6[1] = {0x79AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B6[1] = {0x79AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B6[1] = {0x79AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B6 = {.cp = 0xF9B6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B6, .cde = &lxb_unicode_decomposition_c_F9B6, .kde = &lxb_unicode_decomposition_k_F9B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B7[1] = {0x91B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B7[1] = {0x91B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B7[1] = {0x91B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B7 = {.cp = 0xF9B7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B7, .cde = &lxb_unicode_decomposition_c_F9B7, .kde = &lxb_unicode_decomposition_k_F9B7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B8[1] = {0x96B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B8[1] = {0x96B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B8[1] = {0x96B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B8 = {.cp = 0xF9B8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B8, .cde = &lxb_unicode_decomposition_c_F9B8, .kde = &lxb_unicode_decomposition_k_F9B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9B9[1] = {0x60E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9B9[1] = {0x60E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9B9[1] = {0x60E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9B9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9B9 = {.cp = 0xF9B9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9B9, .cde = &lxb_unicode_decomposition_c_F9B9, .kde = &lxb_unicode_decomposition_k_F9B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9BA[1] = {0x4E86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9BA[1] = {0x4E86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9BA[1] = {0x4E86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9BA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9BA = {.cp = 0xF9BA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9BA, .cde = &lxb_unicode_decomposition_c_F9BA, .kde = &lxb_unicode_decomposition_k_F9BA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9BB[1] = {0x50DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9BB[1] = {0x50DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9BB[1] = {0x50DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9BB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9BB = {.cp = 0xF9BB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9BB, .cde = &lxb_unicode_decomposition_c_F9BB, .kde = &lxb_unicode_decomposition_k_F9BB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9BC[1] = {0x5BEE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9BC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9BC[1] = {0x5BEE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9BC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9BC[1] = {0x5BEE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9BC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9BC = {.cp = 0xF9BC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9BC, .cde = &lxb_unicode_decomposition_c_F9BC, .kde = &lxb_unicode_decomposition_k_F9BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9BD[1] = {0x5C3F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9BD[1] = {0x5C3F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9BD[1] = {0x5C3F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9BD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9BD = {.cp = 0xF9BD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9BD, .cde = &lxb_unicode_decomposition_c_F9BD, .kde = &lxb_unicode_decomposition_k_F9BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9BE[1] = {0x6599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9BE[1] = {0x6599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9BE[1] = {0x6599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9BE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9BE = {.cp = 0xF9BE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9BE, .cde = &lxb_unicode_decomposition_c_F9BE, .kde = &lxb_unicode_decomposition_k_F9BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9BF[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9BF[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9BF[1] = {0x6A02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9BF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9BF = {.cp = 0xF9BF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9BF, .cde = &lxb_unicode_decomposition_c_F9BF, .kde = &lxb_unicode_decomposition_k_F9BF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C0[1] = {0x71CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C0[1] = {0x71CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C0[1] = {0x71CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C0 = {.cp = 0xF9C0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C0, .cde = &lxb_unicode_decomposition_c_F9C0, .kde = &lxb_unicode_decomposition_k_F9C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C1[1] = {0x7642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C1[1] = {0x7642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C1[1] = {0x7642};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C1 = {.cp = 0xF9C1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C1, .cde = &lxb_unicode_decomposition_c_F9C1, .kde = &lxb_unicode_decomposition_k_F9C1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C2[1] = {0x84FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C2[1] = {0x84FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C2[1] = {0x84FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C2 = {.cp = 0xF9C2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C2, .cde = &lxb_unicode_decomposition_c_F9C2, .kde = &lxb_unicode_decomposition_k_F9C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C3[1] = {0x907C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C3[1] = {0x907C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C3[1] = {0x907C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C3 = {.cp = 0xF9C3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C3, .cde = &lxb_unicode_decomposition_c_F9C3, .kde = &lxb_unicode_decomposition_k_F9C3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C4[1] = {0x9F8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C4[1] = {0x9F8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C4[1] = {0x9F8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C4 = {.cp = 0xF9C4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C4, .cde = &lxb_unicode_decomposition_c_F9C4, .kde = &lxb_unicode_decomposition_k_F9C4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C5[1] = {0x6688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C5[1] = {0x6688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C5[1] = {0x6688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C5 = {.cp = 0xF9C5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C5, .cde = &lxb_unicode_decomposition_c_F9C5, .kde = &lxb_unicode_decomposition_k_F9C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C6[1] = {0x962E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C6[1] = {0x962E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C6[1] = {0x962E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C6 = {.cp = 0xF9C6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C6, .cde = &lxb_unicode_decomposition_c_F9C6, .kde = &lxb_unicode_decomposition_k_F9C6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C7[1] = {0x5289};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C7[1] = {0x5289};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C7[1] = {0x5289};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C7 = {.cp = 0xF9C7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C7, .cde = &lxb_unicode_decomposition_c_F9C7, .kde = &lxb_unicode_decomposition_k_F9C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C8[1] = {0x677B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C8[1] = {0x677B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C8[1] = {0x677B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C8 = {.cp = 0xF9C8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C8, .cde = &lxb_unicode_decomposition_c_F9C8, .kde = &lxb_unicode_decomposition_k_F9C8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9C9[1] = {0x67F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9C9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9C9[1] = {0x67F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9C9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9C9[1] = {0x67F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9C9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9C9 = {.cp = 0xF9C9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9C9, .cde = &lxb_unicode_decomposition_c_F9C9, .kde = &lxb_unicode_decomposition_k_F9C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9CA[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9CA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9CA[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9CA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9CA[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9CA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9CA = {.cp = 0xF9CA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9CA, .cde = &lxb_unicode_decomposition_c_F9CA, .kde = &lxb_unicode_decomposition_k_F9CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9CB[1] = {0x6E9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9CB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9CB[1] = {0x6E9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9CB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9CB[1] = {0x6E9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9CB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9CB = {.cp = 0xF9CB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9CB, .cde = &lxb_unicode_decomposition_c_F9CB, .kde = &lxb_unicode_decomposition_k_F9CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9CC[1] = {0x7409};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9CC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9CC[1] = {0x7409};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9CC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9CC[1] = {0x7409};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9CC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9CC = {.cp = 0xF9CC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9CC, .cde = &lxb_unicode_decomposition_c_F9CC, .kde = &lxb_unicode_decomposition_k_F9CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9CD[1] = {0x7559};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9CD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9CD[1] = {0x7559};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9CD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9CD[1] = {0x7559};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9CD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9CD = {.cp = 0xF9CD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9CD, .cde = &lxb_unicode_decomposition_c_F9CD, .kde = &lxb_unicode_decomposition_k_F9CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9CE[1] = {0x786B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9CE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9CE[1] = {0x786B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9CE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9CE[1] = {0x786B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9CE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9CE = {.cp = 0xF9CE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9CE, .cde = &lxb_unicode_decomposition_c_F9CE, .kde = &lxb_unicode_decomposition_k_F9CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9CF[1] = {0x7D10};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9CF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9CF[1] = {0x7D10};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9CF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9CF[1] = {0x7D10};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9CF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9CF = {.cp = 0xF9CF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9CF, .cde = &lxb_unicode_decomposition_c_F9CF, .kde = &lxb_unicode_decomposition_k_F9CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D0[1] = {0x985E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D0[1] = {0x985E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D0[1] = {0x985E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D0 = {.cp = 0xF9D0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D0, .cde = &lxb_unicode_decomposition_c_F9D0, .kde = &lxb_unicode_decomposition_k_F9D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D1[1] = {0x516D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D1[1] = {0x516D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D1[1] = {0x516D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D1 = {.cp = 0xF9D1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D1, .cde = &lxb_unicode_decomposition_c_F9D1, .kde = &lxb_unicode_decomposition_k_F9D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D2[1] = {0x622E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D2[1] = {0x622E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D2[1] = {0x622E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D2 = {.cp = 0xF9D2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D2, .cde = &lxb_unicode_decomposition_c_F9D2, .kde = &lxb_unicode_decomposition_k_F9D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D3[1] = {0x9678};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D3[1] = {0x9678};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D3[1] = {0x9678};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D3 = {.cp = 0xF9D3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D3, .cde = &lxb_unicode_decomposition_c_F9D3, .kde = &lxb_unicode_decomposition_k_F9D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D4[1] = {0x502B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D4[1] = {0x502B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D4[1] = {0x502B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D4 = {.cp = 0xF9D4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D4, .cde = &lxb_unicode_decomposition_c_F9D4, .kde = &lxb_unicode_decomposition_k_F9D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D5[1] = {0x5D19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D5[1] = {0x5D19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D5[1] = {0x5D19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D5 = {.cp = 0xF9D5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D5, .cde = &lxb_unicode_decomposition_c_F9D5, .kde = &lxb_unicode_decomposition_k_F9D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D6[1] = {0x6DEA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D6[1] = {0x6DEA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D6[1] = {0x6DEA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D6 = {.cp = 0xF9D6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D6, .cde = &lxb_unicode_decomposition_c_F9D6, .kde = &lxb_unicode_decomposition_k_F9D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D7[1] = {0x8F2A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D7[1] = {0x8F2A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D7[1] = {0x8F2A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D7 = {.cp = 0xF9D7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D7, .cde = &lxb_unicode_decomposition_c_F9D7, .kde = &lxb_unicode_decomposition_k_F9D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D8[1] = {0x5F8B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D8[1] = {0x5F8B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D8[1] = {0x5F8B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D8 = {.cp = 0xF9D8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D8, .cde = &lxb_unicode_decomposition_c_F9D8, .kde = &lxb_unicode_decomposition_k_F9D8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9D9[1] = {0x6144};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9D9[1] = {0x6144};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9D9[1] = {0x6144};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9D9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9D9 = {.cp = 0xF9D9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9D9, .cde = &lxb_unicode_decomposition_c_F9D9, .kde = &lxb_unicode_decomposition_k_F9D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9DA[1] = {0x6817};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9DA[1] = {0x6817};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9DA[1] = {0x6817};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9DA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9DA = {.cp = 0xF9DA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9DA, .cde = &lxb_unicode_decomposition_c_F9DA, .kde = &lxb_unicode_decomposition_k_F9DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9DB[1] = {0x7387};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9DB[1] = {0x7387};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9DB[1] = {0x7387};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9DB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9DB = {.cp = 0xF9DB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9DB, .cde = &lxb_unicode_decomposition_c_F9DB, .kde = &lxb_unicode_decomposition_k_F9DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9DC[1] = {0x9686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9DC[1] = {0x9686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9DC[1] = {0x9686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9DC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9DC = {.cp = 0xF9DC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9DC, .cde = &lxb_unicode_decomposition_c_F9DC, .kde = &lxb_unicode_decomposition_k_F9DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9DD[1] = {0x5229};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9DD[1] = {0x5229};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9DD[1] = {0x5229};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9DD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9DD = {.cp = 0xF9DD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9DD, .cde = &lxb_unicode_decomposition_c_F9DD, .kde = &lxb_unicode_decomposition_k_F9DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9DE[1] = {0x540F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9DE[1] = {0x540F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9DE[1] = {0x540F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9DE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9DE = {.cp = 0xF9DE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9DE, .cde = &lxb_unicode_decomposition_c_F9DE, .kde = &lxb_unicode_decomposition_k_F9DE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9DF[1] = {0x5C65};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9DF[1] = {0x5C65};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9DF[1] = {0x5C65};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9DF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9DF = {.cp = 0xF9DF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9DF, .cde = &lxb_unicode_decomposition_c_F9DF, .kde = &lxb_unicode_decomposition_k_F9DF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E0[1] = {0x6613};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E0[1] = {0x6613};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E0[1] = {0x6613};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E0 = {.cp = 0xF9E0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E0, .cde = &lxb_unicode_decomposition_c_F9E0, .kde = &lxb_unicode_decomposition_k_F9E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E1[1] = {0x674E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E1[1] = {0x674E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E1[1] = {0x674E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E1 = {.cp = 0xF9E1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E1, .cde = &lxb_unicode_decomposition_c_F9E1, .kde = &lxb_unicode_decomposition_k_F9E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E2[1] = {0x68A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E2[1] = {0x68A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E2[1] = {0x68A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E2 = {.cp = 0xF9E2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E2, .cde = &lxb_unicode_decomposition_c_F9E2, .kde = &lxb_unicode_decomposition_k_F9E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E3[1] = {0x6CE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E3[1] = {0x6CE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E3[1] = {0x6CE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E3 = {.cp = 0xF9E3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E3, .cde = &lxb_unicode_decomposition_c_F9E3, .kde = &lxb_unicode_decomposition_k_F9E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E4[1] = {0x7406};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E4[1] = {0x7406};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E4[1] = {0x7406};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E4 = {.cp = 0xF9E4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E4, .cde = &lxb_unicode_decomposition_c_F9E4, .kde = &lxb_unicode_decomposition_k_F9E4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E5[1] = {0x75E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E5[1] = {0x75E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E5[1] = {0x75E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E5 = {.cp = 0xF9E5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E5, .cde = &lxb_unicode_decomposition_c_F9E5, .kde = &lxb_unicode_decomposition_k_F9E5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E6[1] = {0x7F79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E6[1] = {0x7F79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E6[1] = {0x7F79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E6 = {.cp = 0xF9E6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E6, .cde = &lxb_unicode_decomposition_c_F9E6, .kde = &lxb_unicode_decomposition_k_F9E6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E7[1] = {0x88CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E7[1] = {0x88CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E7[1] = {0x88CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E7 = {.cp = 0xF9E7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E7, .cde = &lxb_unicode_decomposition_c_F9E7, .kde = &lxb_unicode_decomposition_k_F9E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E8[1] = {0x88E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E8[1] = {0x88E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E8[1] = {0x88E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E8 = {.cp = 0xF9E8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E8, .cde = &lxb_unicode_decomposition_c_F9E8, .kde = &lxb_unicode_decomposition_k_F9E8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9E9[1] = {0x91CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9E9[1] = {0x91CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9E9[1] = {0x91CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9E9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9E9 = {.cp = 0xF9E9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9E9, .cde = &lxb_unicode_decomposition_c_F9E9, .kde = &lxb_unicode_decomposition_k_F9E9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9EA[1] = {0x96E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9EA[1] = {0x96E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9EA[1] = {0x96E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9EA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9EA = {.cp = 0xF9EA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9EA, .cde = &lxb_unicode_decomposition_c_F9EA, .kde = &lxb_unicode_decomposition_k_F9EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9EB[1] = {0x533F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9EB[1] = {0x533F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9EB[1] = {0x533F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9EB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9EB = {.cp = 0xF9EB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9EB, .cde = &lxb_unicode_decomposition_c_F9EB, .kde = &lxb_unicode_decomposition_k_F9EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9EC[1] = {0x6EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9EC[1] = {0x6EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9EC[1] = {0x6EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9EC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9EC = {.cp = 0xF9EC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9EC, .cde = &lxb_unicode_decomposition_c_F9EC, .kde = &lxb_unicode_decomposition_k_F9EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9ED[1] = {0x541D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9ED[1] = {0x541D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9ED[1] = {0x541D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9ED, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9ED = {.cp = 0xF9ED, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9ED, .cde = &lxb_unicode_decomposition_c_F9ED, .kde = &lxb_unicode_decomposition_k_F9ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9EE[1] = {0x71D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9EE[1] = {0x71D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9EE[1] = {0x71D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9EE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9EE = {.cp = 0xF9EE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9EE, .cde = &lxb_unicode_decomposition_c_F9EE, .kde = &lxb_unicode_decomposition_k_F9EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9EF[1] = {0x7498};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9EF[1] = {0x7498};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9EF[1] = {0x7498};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9EF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9EF = {.cp = 0xF9EF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9EF, .cde = &lxb_unicode_decomposition_c_F9EF, .kde = &lxb_unicode_decomposition_k_F9EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F0[1] = {0x85FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F0[1] = {0x85FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F0[1] = {0x85FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F0 = {.cp = 0xF9F0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F0, .cde = &lxb_unicode_decomposition_c_F9F0, .kde = &lxb_unicode_decomposition_k_F9F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F1[1] = {0x96A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F1[1] = {0x96A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F1[1] = {0x96A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F1 = {.cp = 0xF9F1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F1, .cde = &lxb_unicode_decomposition_c_F9F1, .kde = &lxb_unicode_decomposition_k_F9F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F2[1] = {0x9C57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F2[1] = {0x9C57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F2[1] = {0x9C57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F2 = {.cp = 0xF9F2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F2, .cde = &lxb_unicode_decomposition_c_F9F2, .kde = &lxb_unicode_decomposition_k_F9F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F3[1] = {0x9E9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F3[1] = {0x9E9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F3[1] = {0x9E9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F3 = {.cp = 0xF9F3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F3, .cde = &lxb_unicode_decomposition_c_F9F3, .kde = &lxb_unicode_decomposition_k_F9F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F4[1] = {0x6797};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F4[1] = {0x6797};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F4[1] = {0x6797};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F4 = {.cp = 0xF9F4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F4, .cde = &lxb_unicode_decomposition_c_F9F4, .kde = &lxb_unicode_decomposition_k_F9F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F5[1] = {0x6DCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F5[1] = {0x6DCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F5[1] = {0x6DCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F5 = {.cp = 0xF9F5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F5, .cde = &lxb_unicode_decomposition_c_F9F5, .kde = &lxb_unicode_decomposition_k_F9F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F6[1] = {0x81E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F6[1] = {0x81E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F6[1] = {0x81E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F6 = {.cp = 0xF9F6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F6, .cde = &lxb_unicode_decomposition_c_F9F6, .kde = &lxb_unicode_decomposition_k_F9F6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F7[1] = {0x7ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F7[1] = {0x7ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F7[1] = {0x7ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F7 = {.cp = 0xF9F7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F7, .cde = &lxb_unicode_decomposition_c_F9F7, .kde = &lxb_unicode_decomposition_k_F9F7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F8[1] = {0x7B20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F8[1] = {0x7B20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F8[1] = {0x7B20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F8 = {.cp = 0xF9F8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F8, .cde = &lxb_unicode_decomposition_c_F9F8, .kde = &lxb_unicode_decomposition_k_F9F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9F9[1] = {0x7C92};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9F9[1] = {0x7C92};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9F9[1] = {0x7C92};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9F9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9F9 = {.cp = 0xF9F9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9F9, .cde = &lxb_unicode_decomposition_c_F9F9, .kde = &lxb_unicode_decomposition_k_F9F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9FA[1] = {0x72C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9FA[1] = {0x72C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9FA[1] = {0x72C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9FA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9FA = {.cp = 0xF9FA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9FA, .cde = &lxb_unicode_decomposition_c_F9FA, .kde = &lxb_unicode_decomposition_k_F9FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9FB[1] = {0x7099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9FB[1] = {0x7099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9FB[1] = {0x7099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9FB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9FB = {.cp = 0xF9FB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9FB, .cde = &lxb_unicode_decomposition_c_F9FB, .kde = &lxb_unicode_decomposition_k_F9FB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9FC[1] = {0x8B58};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9FC[1] = {0x8B58};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9FC[1] = {0x8B58};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9FC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9FC = {.cp = 0xF9FC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9FC, .cde = &lxb_unicode_decomposition_c_F9FC, .kde = &lxb_unicode_decomposition_k_F9FC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9FD[1] = {0x4EC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9FD[1] = {0x4EC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9FD[1] = {0x4EC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9FD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9FD = {.cp = 0xF9FD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9FD, .cde = &lxb_unicode_decomposition_c_F9FD, .kde = &lxb_unicode_decomposition_k_F9FD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9FE[1] = {0x8336};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9FE[1] = {0x8336};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9FE[1] = {0x8336};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9FE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9FE = {.cp = 0xF9FE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9FE, .cde = &lxb_unicode_decomposition_c_F9FE, .kde = &lxb_unicode_decomposition_k_F9FE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_F9FF[1] = {0x523A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_F9FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_F9FF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_F9FF[1] = {0x523A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_F9FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_F9FF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__F9FF[1] = {0x523A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__F9FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__F9FF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_F9FF = {.cp = 0xF9FF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__F9FF, .cde = &lxb_unicode_decomposition_c_F9FF, .kde = &lxb_unicode_decomposition_k_F9FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA00[1] = {0x5207};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA00, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA00[1] = {0x5207};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA00, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA00[1] = {0x5207};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA00, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA00 = {.cp = 0xFA00, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA00, .cde = &lxb_unicode_decomposition_c_FA00, .kde = &lxb_unicode_decomposition_k_FA00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA01[1] = {0x5EA6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA01[1] = {0x5EA6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA01[1] = {0x5EA6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA01, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA01 = {.cp = 0xFA01, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA01, .cde = &lxb_unicode_decomposition_c_FA01, .kde = &lxb_unicode_decomposition_k_FA01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA02[1] = {0x62D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA02[1] = {0x62D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA02[1] = {0x62D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA02, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA02 = {.cp = 0xFA02, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA02, .cde = &lxb_unicode_decomposition_c_FA02, .kde = &lxb_unicode_decomposition_k_FA02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA03[1] = {0x7CD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA03[1] = {0x7CD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA03[1] = {0x7CD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA03, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA03 = {.cp = 0xFA03, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA03, .cde = &lxb_unicode_decomposition_c_FA03, .kde = &lxb_unicode_decomposition_k_FA03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA04[1] = {0x5B85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA04[1] = {0x5B85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA04[1] = {0x5B85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA04, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA04 = {.cp = 0xFA04, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA04, .cde = &lxb_unicode_decomposition_c_FA04, .kde = &lxb_unicode_decomposition_k_FA04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA05[1] = {0x6D1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA05[1] = {0x6D1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA05[1] = {0x6D1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA05, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA05 = {.cp = 0xFA05, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA05, .cde = &lxb_unicode_decomposition_c_FA05, .kde = &lxb_unicode_decomposition_k_FA05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA06[1] = {0x66B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA06[1] = {0x66B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA06[1] = {0x66B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA06, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA06 = {.cp = 0xFA06, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA06, .cde = &lxb_unicode_decomposition_c_FA06, .kde = &lxb_unicode_decomposition_k_FA06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA07[1] = {0x8F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA07[1] = {0x8F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA07[1] = {0x8F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA07, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA07 = {.cp = 0xFA07, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA07, .cde = &lxb_unicode_decomposition_c_FA07, .kde = &lxb_unicode_decomposition_k_FA07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA08[1] = {0x884C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA08[1] = {0x884C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA08[1] = {0x884C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA08, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA08 = {.cp = 0xFA08, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA08, .cde = &lxb_unicode_decomposition_c_FA08, .kde = &lxb_unicode_decomposition_k_FA08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA09[1] = {0x964D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA09[1] = {0x964D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA09[1] = {0x964D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA09, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA09 = {.cp = 0xFA09, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA09, .cde = &lxb_unicode_decomposition_c_FA09, .kde = &lxb_unicode_decomposition_k_FA09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA0A[1] = {0x898B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA0A[1] = {0x898B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA0A[1] = {0x898B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA0A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA0A = {.cp = 0xFA0A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA0A, .cde = &lxb_unicode_decomposition_c_FA0A, .kde = &lxb_unicode_decomposition_k_FA0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA0B[1] = {0x5ED3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA0B[1] = {0x5ED3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA0B[1] = {0x5ED3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA0B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA0B = {.cp = 0xFA0B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA0B, .cde = &lxb_unicode_decomposition_c_FA0B, .kde = &lxb_unicode_decomposition_k_FA0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA0C[1] = {0x5140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA0C[1] = {0x5140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA0C[1] = {0x5140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA0C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA0C = {.cp = 0xFA0C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA0C, .cde = &lxb_unicode_decomposition_c_FA0C, .kde = &lxb_unicode_decomposition_k_FA0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA0D[1] = {0x55C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA0D[1] = {0x55C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA0D[1] = {0x55C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA0D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA0D = {.cp = 0xFA0D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA0D, .cde = &lxb_unicode_decomposition_c_FA0D, .kde = &lxb_unicode_decomposition_k_FA0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA10[1] = {0x585A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA10[1] = {0x585A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA10[1] = {0x585A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA10, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA10 = {.cp = 0xFA10, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA10, .cde = &lxb_unicode_decomposition_c_FA10, .kde = &lxb_unicode_decomposition_k_FA10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA12[1] = {0x6674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA12[1] = {0x6674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA12[1] = {0x6674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA12, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA12 = {.cp = 0xFA12, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA12, .cde = &lxb_unicode_decomposition_c_FA12, .kde = &lxb_unicode_decomposition_k_FA12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA15[1] = {0x51DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA15[1] = {0x51DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA15[1] = {0x51DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA15, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA15 = {.cp = 0xFA15, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA15, .cde = &lxb_unicode_decomposition_c_FA15, .kde = &lxb_unicode_decomposition_k_FA15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA16[1] = {0x732A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA16[1] = {0x732A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA16[1] = {0x732A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA16, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA16 = {.cp = 0xFA16, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA16, .cde = &lxb_unicode_decomposition_c_FA16, .kde = &lxb_unicode_decomposition_k_FA16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA17[1] = {0x76CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA17[1] = {0x76CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA17[1] = {0x76CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA17, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA17 = {.cp = 0xFA17, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA17, .cde = &lxb_unicode_decomposition_c_FA17, .kde = &lxb_unicode_decomposition_k_FA17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA18[1] = {0x793C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA18[1] = {0x793C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA18[1] = {0x793C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA18, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA18 = {.cp = 0xFA18, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA18, .cde = &lxb_unicode_decomposition_c_FA18, .kde = &lxb_unicode_decomposition_k_FA18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA19[1] = {0x795E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA19[1] = {0x795E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA19[1] = {0x795E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA19, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA19 = {.cp = 0xFA19, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA19, .cde = &lxb_unicode_decomposition_c_FA19, .kde = &lxb_unicode_decomposition_k_FA19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA1A[1] = {0x7965};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA1A[1] = {0x7965};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA1A[1] = {0x7965};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA1A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA1A = {.cp = 0xFA1A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA1A, .cde = &lxb_unicode_decomposition_c_FA1A, .kde = &lxb_unicode_decomposition_k_FA1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA1B[1] = {0x798F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA1B[1] = {0x798F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA1B[1] = {0x798F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA1B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA1B = {.cp = 0xFA1B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA1B, .cde = &lxb_unicode_decomposition_c_FA1B, .kde = &lxb_unicode_decomposition_k_FA1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA1C[1] = {0x9756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA1C[1] = {0x9756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA1C[1] = {0x9756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA1C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA1C = {.cp = 0xFA1C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA1C, .cde = &lxb_unicode_decomposition_c_FA1C, .kde = &lxb_unicode_decomposition_k_FA1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA1D[1] = {0x7CBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA1D[1] = {0x7CBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA1D[1] = {0x7CBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA1D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA1D = {.cp = 0xFA1D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA1D, .cde = &lxb_unicode_decomposition_c_FA1D, .kde = &lxb_unicode_decomposition_k_FA1D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA1E[1] = {0x7FBD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA1E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA1E[1] = {0x7FBD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA1E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA1E[1] = {0x7FBD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA1E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA1E = {.cp = 0xFA1E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA1E, .cde = &lxb_unicode_decomposition_c_FA1E, .kde = &lxb_unicode_decomposition_k_FA1E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA20[1] = {0x8612};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA20[1] = {0x8612};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA20[1] = {0x8612};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA20, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA20 = {.cp = 0xFA20, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA20, .cde = &lxb_unicode_decomposition_c_FA20, .kde = &lxb_unicode_decomposition_k_FA20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA22[1] = {0x8AF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA22[1] = {0x8AF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA22[1] = {0x8AF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA22, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA22 = {.cp = 0xFA22, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA22, .cde = &lxb_unicode_decomposition_c_FA22, .kde = &lxb_unicode_decomposition_k_FA22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA25[1] = {0x9038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA25[1] = {0x9038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA25[1] = {0x9038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA25, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA25 = {.cp = 0xFA25, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA25, .cde = &lxb_unicode_decomposition_c_FA25, .kde = &lxb_unicode_decomposition_k_FA25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA26[1] = {0x90FD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA26[1] = {0x90FD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA26[1] = {0x90FD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA26, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA26 = {.cp = 0xFA26, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA26, .cde = &lxb_unicode_decomposition_c_FA26, .kde = &lxb_unicode_decomposition_k_FA26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA2A[1] = {0x98EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA2A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA2A[1] = {0x98EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA2A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA2A[1] = {0x98EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA2A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA2A = {.cp = 0xFA2A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA2A, .cde = &lxb_unicode_decomposition_c_FA2A, .kde = &lxb_unicode_decomposition_k_FA2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA2B[1] = {0x98FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA2B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA2B[1] = {0x98FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA2B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA2B[1] = {0x98FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA2B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA2B = {.cp = 0xFA2B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA2B, .cde = &lxb_unicode_decomposition_c_FA2B, .kde = &lxb_unicode_decomposition_k_FA2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA2C[1] = {0x9928};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA2C[1] = {0x9928};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA2C[1] = {0x9928};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA2C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA2C = {.cp = 0xFA2C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA2C, .cde = &lxb_unicode_decomposition_c_FA2C, .kde = &lxb_unicode_decomposition_k_FA2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA2D[1] = {0x9DB4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA2D[1] = {0x9DB4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA2D[1] = {0x9DB4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA2D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA2D = {.cp = 0xFA2D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA2D, .cde = &lxb_unicode_decomposition_c_FA2D, .kde = &lxb_unicode_decomposition_k_FA2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA2E[1] = {0x90DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA2E[1] = {0x90DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA2E[1] = {0x90DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA2E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA2E = {.cp = 0xFA2E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA2E, .cde = &lxb_unicode_decomposition_c_FA2E, .kde = &lxb_unicode_decomposition_k_FA2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA2F[1] = {0x96B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA2F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA2F[1] = {0x96B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA2F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA2F[1] = {0x96B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA2F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA2F = {.cp = 0xFA2F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA2F, .cde = &lxb_unicode_decomposition_c_FA2F, .kde = &lxb_unicode_decomposition_k_FA2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA30[1] = {0x4FAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA30[1] = {0x4FAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA30[1] = {0x4FAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA30, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA30 = {.cp = 0xFA30, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA30, .cde = &lxb_unicode_decomposition_c_FA30, .kde = &lxb_unicode_decomposition_k_FA30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA31[1] = {0x50E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA31[1] = {0x50E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA31[1] = {0x50E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA31, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA31 = {.cp = 0xFA31, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA31, .cde = &lxb_unicode_decomposition_c_FA31, .kde = &lxb_unicode_decomposition_k_FA31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA32[1] = {0x514D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA32[1] = {0x514D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA32[1] = {0x514D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA32, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA32 = {.cp = 0xFA32, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA32, .cde = &lxb_unicode_decomposition_c_FA32, .kde = &lxb_unicode_decomposition_k_FA32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA33[1] = {0x52C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA33[1] = {0x52C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA33[1] = {0x52C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA33, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA33 = {.cp = 0xFA33, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA33, .cde = &lxb_unicode_decomposition_c_FA33, .kde = &lxb_unicode_decomposition_k_FA33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA34[1] = {0x52E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA34[1] = {0x52E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA34[1] = {0x52E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA34, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA34 = {.cp = 0xFA34, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA34, .cde = &lxb_unicode_decomposition_c_FA34, .kde = &lxb_unicode_decomposition_k_FA34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA35[1] = {0x5351};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA35[1] = {0x5351};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA35[1] = {0x5351};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA35, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA35 = {.cp = 0xFA35, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA35, .cde = &lxb_unicode_decomposition_c_FA35, .kde = &lxb_unicode_decomposition_k_FA35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA36[1] = {0x559D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA36[1] = {0x559D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA36[1] = {0x559D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA36, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA36 = {.cp = 0xFA36, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA36, .cde = &lxb_unicode_decomposition_c_FA36, .kde = &lxb_unicode_decomposition_k_FA36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA37[1] = {0x5606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA37[1] = {0x5606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA37[1] = {0x5606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA37, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA37 = {.cp = 0xFA37, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA37, .cde = &lxb_unicode_decomposition_c_FA37, .kde = &lxb_unicode_decomposition_k_FA37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA38[1] = {0x5668};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA38[1] = {0x5668};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA38[1] = {0x5668};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA38, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA38 = {.cp = 0xFA38, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA38, .cde = &lxb_unicode_decomposition_c_FA38, .kde = &lxb_unicode_decomposition_k_FA38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA39[1] = {0x5840};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA39[1] = {0x5840};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA39[1] = {0x5840};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA39, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA39 = {.cp = 0xFA39, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA39, .cde = &lxb_unicode_decomposition_c_FA39, .kde = &lxb_unicode_decomposition_k_FA39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA3A[1] = {0x58A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA3A[1] = {0x58A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA3A[1] = {0x58A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA3A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA3A = {.cp = 0xFA3A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA3A, .cde = &lxb_unicode_decomposition_c_FA3A, .kde = &lxb_unicode_decomposition_k_FA3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA3B[1] = {0x5C64};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA3B[1] = {0x5C64};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA3B[1] = {0x5C64};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA3B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA3B = {.cp = 0xFA3B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA3B, .cde = &lxb_unicode_decomposition_c_FA3B, .kde = &lxb_unicode_decomposition_k_FA3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA3C[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA3C[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA3C[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA3C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA3C = {.cp = 0xFA3C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA3C, .cde = &lxb_unicode_decomposition_c_FA3C, .kde = &lxb_unicode_decomposition_k_FA3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA3D[1] = {0x6094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA3D[1] = {0x6094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA3D[1] = {0x6094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA3D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA3D = {.cp = 0xFA3D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA3D, .cde = &lxb_unicode_decomposition_c_FA3D, .kde = &lxb_unicode_decomposition_k_FA3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA3E[1] = {0x6168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA3E[1] = {0x6168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA3E[1] = {0x6168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA3E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA3E = {.cp = 0xFA3E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA3E, .cde = &lxb_unicode_decomposition_c_FA3E, .kde = &lxb_unicode_decomposition_k_FA3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA3F[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA3F[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA3F[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA3F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA3F = {.cp = 0xFA3F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA3F, .cde = &lxb_unicode_decomposition_c_FA3F, .kde = &lxb_unicode_decomposition_k_FA3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA40[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA40[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA40[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA40, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA40 = {.cp = 0xFA40, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA40, .cde = &lxb_unicode_decomposition_c_FA40, .kde = &lxb_unicode_decomposition_k_FA40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA41[1] = {0x654F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA41[1] = {0x654F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA41[1] = {0x654F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA41, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA41 = {.cp = 0xFA41, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA41, .cde = &lxb_unicode_decomposition_c_FA41, .kde = &lxb_unicode_decomposition_k_FA41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA42[1] = {0x65E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA42[1] = {0x65E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA42[1] = {0x65E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA42, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA42 = {.cp = 0xFA42, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA42, .cde = &lxb_unicode_decomposition_c_FA42, .kde = &lxb_unicode_decomposition_k_FA42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA43[1] = {0x6691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA43[1] = {0x6691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA43[1] = {0x6691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA43, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA43 = {.cp = 0xFA43, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA43, .cde = &lxb_unicode_decomposition_c_FA43, .kde = &lxb_unicode_decomposition_k_FA43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA44[1] = {0x6885};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA44[1] = {0x6885};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA44[1] = {0x6885};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA44, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA44 = {.cp = 0xFA44, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA44, .cde = &lxb_unicode_decomposition_c_FA44, .kde = &lxb_unicode_decomposition_k_FA44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA45[1] = {0x6D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA45[1] = {0x6D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA45[1] = {0x6D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA45, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA45 = {.cp = 0xFA45, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA45, .cde = &lxb_unicode_decomposition_c_FA45, .kde = &lxb_unicode_decomposition_k_FA45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA46[1] = {0x6E1A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA46[1] = {0x6E1A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA46[1] = {0x6E1A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA46, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA46 = {.cp = 0xFA46, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA46, .cde = &lxb_unicode_decomposition_c_FA46, .kde = &lxb_unicode_decomposition_k_FA46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA47[1] = {0x6F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA47[1] = {0x6F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA47[1] = {0x6F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA47, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA47 = {.cp = 0xFA47, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA47, .cde = &lxb_unicode_decomposition_c_FA47, .kde = &lxb_unicode_decomposition_k_FA47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA48[1] = {0x716E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA48[1] = {0x716E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA48[1] = {0x716E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA48, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA48 = {.cp = 0xFA48, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA48, .cde = &lxb_unicode_decomposition_c_FA48, .kde = &lxb_unicode_decomposition_k_FA48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA49[1] = {0x722B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA49[1] = {0x722B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA49[1] = {0x722B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA49, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA49 = {.cp = 0xFA49, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA49, .cde = &lxb_unicode_decomposition_c_FA49, .kde = &lxb_unicode_decomposition_k_FA49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA4A[1] = {0x7422};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA4A[1] = {0x7422};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA4A[1] = {0x7422};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA4A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA4A = {.cp = 0xFA4A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA4A, .cde = &lxb_unicode_decomposition_c_FA4A, .kde = &lxb_unicode_decomposition_k_FA4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA4B[1] = {0x7891};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA4B[1] = {0x7891};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA4B[1] = {0x7891};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA4B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA4B = {.cp = 0xFA4B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA4B, .cde = &lxb_unicode_decomposition_c_FA4B, .kde = &lxb_unicode_decomposition_k_FA4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA4C[1] = {0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA4C[1] = {0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA4C[1] = {0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA4C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA4C = {.cp = 0xFA4C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA4C, .cde = &lxb_unicode_decomposition_c_FA4C, .kde = &lxb_unicode_decomposition_k_FA4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA4D[1] = {0x7949};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA4D[1] = {0x7949};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA4D[1] = {0x7949};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA4D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA4D = {.cp = 0xFA4D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA4D, .cde = &lxb_unicode_decomposition_c_FA4D, .kde = &lxb_unicode_decomposition_k_FA4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA4E[1] = {0x7948};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA4E[1] = {0x7948};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA4E[1] = {0x7948};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA4E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA4E = {.cp = 0xFA4E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA4E, .cde = &lxb_unicode_decomposition_c_FA4E, .kde = &lxb_unicode_decomposition_k_FA4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA4F[1] = {0x7950};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA4F[1] = {0x7950};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA4F[1] = {0x7950};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA4F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA4F = {.cp = 0xFA4F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA4F, .cde = &lxb_unicode_decomposition_c_FA4F, .kde = &lxb_unicode_decomposition_k_FA4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA50[1] = {0x7956};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA50[1] = {0x7956};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA50[1] = {0x7956};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA50, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA50 = {.cp = 0xFA50, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA50, .cde = &lxb_unicode_decomposition_c_FA50, .kde = &lxb_unicode_decomposition_k_FA50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA51[1] = {0x795D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA51[1] = {0x795D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA51[1] = {0x795D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA51, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA51 = {.cp = 0xFA51, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA51, .cde = &lxb_unicode_decomposition_c_FA51, .kde = &lxb_unicode_decomposition_k_FA51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA52[1] = {0x798D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA52[1] = {0x798D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA52[1] = {0x798D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA52, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA52 = {.cp = 0xFA52, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA52, .cde = &lxb_unicode_decomposition_c_FA52, .kde = &lxb_unicode_decomposition_k_FA52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA53[1] = {0x798E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA53[1] = {0x798E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA53[1] = {0x798E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA53, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA53 = {.cp = 0xFA53, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA53, .cde = &lxb_unicode_decomposition_c_FA53, .kde = &lxb_unicode_decomposition_k_FA53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA54[1] = {0x7A40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA54[1] = {0x7A40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA54[1] = {0x7A40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA54, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA54 = {.cp = 0xFA54, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA54, .cde = &lxb_unicode_decomposition_c_FA54, .kde = &lxb_unicode_decomposition_k_FA54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA55[1] = {0x7A81};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA55[1] = {0x7A81};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA55[1] = {0x7A81};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA55, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA55 = {.cp = 0xFA55, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA55, .cde = &lxb_unicode_decomposition_c_FA55, .kde = &lxb_unicode_decomposition_k_FA55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA56[1] = {0x7BC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA56[1] = {0x7BC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA56[1] = {0x7BC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA56, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA56 = {.cp = 0xFA56, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA56, .cde = &lxb_unicode_decomposition_c_FA56, .kde = &lxb_unicode_decomposition_k_FA56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA57[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA57[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA57[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA57, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA57 = {.cp = 0xFA57, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA57, .cde = &lxb_unicode_decomposition_c_FA57, .kde = &lxb_unicode_decomposition_k_FA57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA58[1] = {0x7E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA58[1] = {0x7E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA58[1] = {0x7E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA58, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA58 = {.cp = 0xFA58, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA58, .cde = &lxb_unicode_decomposition_c_FA58, .kde = &lxb_unicode_decomposition_k_FA58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA59[1] = {0x7E41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA59[1] = {0x7E41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA59[1] = {0x7E41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA59, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA59 = {.cp = 0xFA59, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA59, .cde = &lxb_unicode_decomposition_c_FA59, .kde = &lxb_unicode_decomposition_k_FA59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA5A[1] = {0x7F72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA5A[1] = {0x7F72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA5A[1] = {0x7F72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA5A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA5A = {.cp = 0xFA5A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA5A, .cde = &lxb_unicode_decomposition_c_FA5A, .kde = &lxb_unicode_decomposition_k_FA5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA5B[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA5B[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA5B[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA5B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA5B = {.cp = 0xFA5B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA5B, .cde = &lxb_unicode_decomposition_c_FA5B, .kde = &lxb_unicode_decomposition_k_FA5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA5C[1] = {0x81ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA5C[1] = {0x81ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA5C[1] = {0x81ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA5C = {.cp = 0xFA5C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA5C, .cde = &lxb_unicode_decomposition_c_FA5C, .kde = &lxb_unicode_decomposition_k_FA5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA5D[1] = {0x8279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA5D[1] = {0x8279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA5D[1] = {0x8279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA5D = {.cp = 0xFA5D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA5D, .cde = &lxb_unicode_decomposition_c_FA5D, .kde = &lxb_unicode_decomposition_k_FA5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA5E[1] = {0x8279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA5E[1] = {0x8279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA5E[1] = {0x8279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA5E = {.cp = 0xFA5E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA5E, .cde = &lxb_unicode_decomposition_c_FA5E, .kde = &lxb_unicode_decomposition_k_FA5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA5F[1] = {0x8457};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA5F[1] = {0x8457};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA5F[1] = {0x8457};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA5F = {.cp = 0xFA5F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA5F, .cde = &lxb_unicode_decomposition_c_FA5F, .kde = &lxb_unicode_decomposition_k_FA5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA60[1] = {0x8910};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA60[1] = {0x8910};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA60[1] = {0x8910};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA60, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA60 = {.cp = 0xFA60, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA60, .cde = &lxb_unicode_decomposition_c_FA60, .kde = &lxb_unicode_decomposition_k_FA60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA61[1] = {0x8996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA61[1] = {0x8996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA61[1] = {0x8996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA61, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA61 = {.cp = 0xFA61, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA61, .cde = &lxb_unicode_decomposition_c_FA61, .kde = &lxb_unicode_decomposition_k_FA61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA62[1] = {0x8B01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA62[1] = {0x8B01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA62[1] = {0x8B01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA62, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA62 = {.cp = 0xFA62, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA62, .cde = &lxb_unicode_decomposition_c_FA62, .kde = &lxb_unicode_decomposition_k_FA62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA63[1] = {0x8B39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA63[1] = {0x8B39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA63[1] = {0x8B39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA63, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA63 = {.cp = 0xFA63, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA63, .cde = &lxb_unicode_decomposition_c_FA63, .kde = &lxb_unicode_decomposition_k_FA63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA64[1] = {0x8CD3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA64[1] = {0x8CD3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA64[1] = {0x8CD3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA64, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA64 = {.cp = 0xFA64, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA64, .cde = &lxb_unicode_decomposition_c_FA64, .kde = &lxb_unicode_decomposition_k_FA64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA65[1] = {0x8D08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA65[1] = {0x8D08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA65[1] = {0x8D08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA65, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA65 = {.cp = 0xFA65, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA65, .cde = &lxb_unicode_decomposition_c_FA65, .kde = &lxb_unicode_decomposition_k_FA65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA66[1] = {0x8FB6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA66[1] = {0x8FB6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA66[1] = {0x8FB6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA66, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA66 = {.cp = 0xFA66, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA66, .cde = &lxb_unicode_decomposition_c_FA66, .kde = &lxb_unicode_decomposition_k_FA66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA67[1] = {0x9038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA67[1] = {0x9038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA67[1] = {0x9038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA67, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA67 = {.cp = 0xFA67, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA67, .cde = &lxb_unicode_decomposition_c_FA67, .kde = &lxb_unicode_decomposition_k_FA67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA68[1] = {0x96E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA68[1] = {0x96E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA68[1] = {0x96E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA68, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA68 = {.cp = 0xFA68, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA68, .cde = &lxb_unicode_decomposition_c_FA68, .kde = &lxb_unicode_decomposition_k_FA68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA69[1] = {0x97FF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA69[1] = {0x97FF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA69[1] = {0x97FF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA69 = {.cp = 0xFA69, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA69, .cde = &lxb_unicode_decomposition_c_FA69, .kde = &lxb_unicode_decomposition_k_FA69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA6A[1] = {0x983B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA6A[1] = {0x983B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA6A[1] = {0x983B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA6A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA6A = {.cp = 0xFA6A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA6A, .cde = &lxb_unicode_decomposition_c_FA6A, .kde = &lxb_unicode_decomposition_k_FA6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA6B[1] = {0x6075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA6B[1] = {0x6075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA6B[1] = {0x6075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA6B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA6B = {.cp = 0xFA6B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA6B, .cde = &lxb_unicode_decomposition_c_FA6B, .kde = &lxb_unicode_decomposition_k_FA6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA6C[1] = {0x242EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA6C[1] = {0x242EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA6C[1] = {0x242EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA6C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA6C = {.cp = 0xFA6C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA6C, .cde = &lxb_unicode_decomposition_c_FA6C, .kde = &lxb_unicode_decomposition_k_FA6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA6D[1] = {0x8218};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA6D[1] = {0x8218};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA6D[1] = {0x8218};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA6D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA6D = {.cp = 0xFA6D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA6D, .cde = &lxb_unicode_decomposition_c_FA6D, .kde = &lxb_unicode_decomposition_k_FA6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA70[1] = {0x4E26};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA70[1] = {0x4E26};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA70[1] = {0x4E26};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA70, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA70 = {.cp = 0xFA70, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA70, .cde = &lxb_unicode_decomposition_c_FA70, .kde = &lxb_unicode_decomposition_k_FA70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA71[1] = {0x51B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA71[1] = {0x51B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA71[1] = {0x51B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA71, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA71 = {.cp = 0xFA71, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA71, .cde = &lxb_unicode_decomposition_c_FA71, .kde = &lxb_unicode_decomposition_k_FA71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA72[1] = {0x5168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA72[1] = {0x5168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA72[1] = {0x5168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA72, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA72 = {.cp = 0xFA72, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA72, .cde = &lxb_unicode_decomposition_c_FA72, .kde = &lxb_unicode_decomposition_k_FA72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA73[1] = {0x4F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA73[1] = {0x4F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA73[1] = {0x4F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA73, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA73 = {.cp = 0xFA73, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA73, .cde = &lxb_unicode_decomposition_c_FA73, .kde = &lxb_unicode_decomposition_k_FA73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA74[1] = {0x5145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA74[1] = {0x5145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA74[1] = {0x5145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA74, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA74 = {.cp = 0xFA74, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA74, .cde = &lxb_unicode_decomposition_c_FA74, .kde = &lxb_unicode_decomposition_k_FA74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA75[1] = {0x5180};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA75[1] = {0x5180};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA75[1] = {0x5180};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA75, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA75 = {.cp = 0xFA75, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA75, .cde = &lxb_unicode_decomposition_c_FA75, .kde = &lxb_unicode_decomposition_k_FA75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA76[1] = {0x52C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA76[1] = {0x52C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA76[1] = {0x52C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA76, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA76 = {.cp = 0xFA76, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA76, .cde = &lxb_unicode_decomposition_c_FA76, .kde = &lxb_unicode_decomposition_k_FA76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA77[1] = {0x52FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA77[1] = {0x52FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA77[1] = {0x52FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA77, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA77 = {.cp = 0xFA77, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA77, .cde = &lxb_unicode_decomposition_c_FA77, .kde = &lxb_unicode_decomposition_k_FA77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA78[1] = {0x559D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA78[1] = {0x559D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA78[1] = {0x559D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA78, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA78 = {.cp = 0xFA78, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA78, .cde = &lxb_unicode_decomposition_c_FA78, .kde = &lxb_unicode_decomposition_k_FA78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA79[1] = {0x5555};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA79[1] = {0x5555};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA79[1] = {0x5555};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA79, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA79 = {.cp = 0xFA79, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA79, .cde = &lxb_unicode_decomposition_c_FA79, .kde = &lxb_unicode_decomposition_k_FA79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA7A[1] = {0x5599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA7A[1] = {0x5599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA7A[1] = {0x5599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA7A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA7A = {.cp = 0xFA7A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA7A, .cde = &lxb_unicode_decomposition_c_FA7A, .kde = &lxb_unicode_decomposition_k_FA7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA7B[1] = {0x55E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA7B[1] = {0x55E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA7B[1] = {0x55E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA7B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA7B = {.cp = 0xFA7B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA7B, .cde = &lxb_unicode_decomposition_c_FA7B, .kde = &lxb_unicode_decomposition_k_FA7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA7C[1] = {0x585A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA7C[1] = {0x585A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA7C[1] = {0x585A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA7C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA7C = {.cp = 0xFA7C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA7C, .cde = &lxb_unicode_decomposition_c_FA7C, .kde = &lxb_unicode_decomposition_k_FA7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA7D[1] = {0x58B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA7D[1] = {0x58B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA7D[1] = {0x58B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA7D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA7D = {.cp = 0xFA7D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA7D, .cde = &lxb_unicode_decomposition_c_FA7D, .kde = &lxb_unicode_decomposition_k_FA7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA7E[1] = {0x5944};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA7E[1] = {0x5944};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA7E[1] = {0x5944};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA7E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA7E = {.cp = 0xFA7E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA7E, .cde = &lxb_unicode_decomposition_c_FA7E, .kde = &lxb_unicode_decomposition_k_FA7E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA7F[1] = {0x5954};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA7F[1] = {0x5954};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA7F[1] = {0x5954};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA7F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA7F = {.cp = 0xFA7F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA7F, .cde = &lxb_unicode_decomposition_c_FA7F, .kde = &lxb_unicode_decomposition_k_FA7F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA80[1] = {0x5A62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA80[1] = {0x5A62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA80[1] = {0x5A62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA80, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA80 = {.cp = 0xFA80, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA80, .cde = &lxb_unicode_decomposition_c_FA80, .kde = &lxb_unicode_decomposition_k_FA80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA81[1] = {0x5B28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA81[1] = {0x5B28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA81[1] = {0x5B28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA81, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA81 = {.cp = 0xFA81, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA81, .cde = &lxb_unicode_decomposition_c_FA81, .kde = &lxb_unicode_decomposition_k_FA81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA82[1] = {0x5ED2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA82[1] = {0x5ED2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA82[1] = {0x5ED2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA82, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA82 = {.cp = 0xFA82, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA82, .cde = &lxb_unicode_decomposition_c_FA82, .kde = &lxb_unicode_decomposition_k_FA82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA83[1] = {0x5ED9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA83[1] = {0x5ED9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA83[1] = {0x5ED9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA83, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA83 = {.cp = 0xFA83, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA83, .cde = &lxb_unicode_decomposition_c_FA83, .kde = &lxb_unicode_decomposition_k_FA83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA84[1] = {0x5F69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA84[1] = {0x5F69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA84[1] = {0x5F69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA84, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA84 = {.cp = 0xFA84, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA84, .cde = &lxb_unicode_decomposition_c_FA84, .kde = &lxb_unicode_decomposition_k_FA84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA85[1] = {0x5FAD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA85[1] = {0x5FAD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA85[1] = {0x5FAD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA85, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA85 = {.cp = 0xFA85, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA85, .cde = &lxb_unicode_decomposition_c_FA85, .kde = &lxb_unicode_decomposition_k_FA85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA86[1] = {0x60D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA86[1] = {0x60D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA86[1] = {0x60D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA86, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA86 = {.cp = 0xFA86, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA86, .cde = &lxb_unicode_decomposition_c_FA86, .kde = &lxb_unicode_decomposition_k_FA86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA87[1] = {0x614E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA87[1] = {0x614E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA87[1] = {0x614E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA87, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA87 = {.cp = 0xFA87, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA87, .cde = &lxb_unicode_decomposition_c_FA87, .kde = &lxb_unicode_decomposition_k_FA87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA88[1] = {0x6108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA88[1] = {0x6108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA88[1] = {0x6108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA88, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA88 = {.cp = 0xFA88, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA88, .cde = &lxb_unicode_decomposition_c_FA88, .kde = &lxb_unicode_decomposition_k_FA88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA89[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA89[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA89[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA89, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA89 = {.cp = 0xFA89, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA89, .cde = &lxb_unicode_decomposition_c_FA89, .kde = &lxb_unicode_decomposition_k_FA89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA8A[1] = {0x6160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA8A[1] = {0x6160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA8A[1] = {0x6160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA8A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA8A = {.cp = 0xFA8A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA8A, .cde = &lxb_unicode_decomposition_c_FA8A, .kde = &lxb_unicode_decomposition_k_FA8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA8B[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA8B[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA8B[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA8B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA8B = {.cp = 0xFA8B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA8B, .cde = &lxb_unicode_decomposition_c_FA8B, .kde = &lxb_unicode_decomposition_k_FA8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA8C[1] = {0x6234};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA8C[1] = {0x6234};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA8C[1] = {0x6234};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA8C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA8C = {.cp = 0xFA8C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA8C, .cde = &lxb_unicode_decomposition_c_FA8C, .kde = &lxb_unicode_decomposition_k_FA8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA8D[1] = {0x63C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA8D[1] = {0x63C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA8D[1] = {0x63C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA8D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA8D = {.cp = 0xFA8D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA8D, .cde = &lxb_unicode_decomposition_c_FA8D, .kde = &lxb_unicode_decomposition_k_FA8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA8E[1] = {0x641C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA8E[1] = {0x641C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA8E[1] = {0x641C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA8E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA8E = {.cp = 0xFA8E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA8E, .cde = &lxb_unicode_decomposition_c_FA8E, .kde = &lxb_unicode_decomposition_k_FA8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA8F[1] = {0x6452};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA8F[1] = {0x6452};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA8F[1] = {0x6452};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA8F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA8F = {.cp = 0xFA8F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA8F, .cde = &lxb_unicode_decomposition_c_FA8F, .kde = &lxb_unicode_decomposition_k_FA8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA90[1] = {0x6556};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA90[1] = {0x6556};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA90[1] = {0x6556};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA90, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA90 = {.cp = 0xFA90, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA90, .cde = &lxb_unicode_decomposition_c_FA90, .kde = &lxb_unicode_decomposition_k_FA90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA91[1] = {0x6674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA91[1] = {0x6674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA91[1] = {0x6674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA91, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA91 = {.cp = 0xFA91, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA91, .cde = &lxb_unicode_decomposition_c_FA91, .kde = &lxb_unicode_decomposition_k_FA91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA92[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA92[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA92[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA92, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA92 = {.cp = 0xFA92, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA92, .cde = &lxb_unicode_decomposition_c_FA92, .kde = &lxb_unicode_decomposition_k_FA92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA93[1] = {0x671B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA93[1] = {0x671B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA93[1] = {0x671B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA93, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA93 = {.cp = 0xFA93, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA93, .cde = &lxb_unicode_decomposition_c_FA93, .kde = &lxb_unicode_decomposition_k_FA93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA94[1] = {0x6756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA94[1] = {0x6756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA94[1] = {0x6756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA94, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA94 = {.cp = 0xFA94, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA94, .cde = &lxb_unicode_decomposition_c_FA94, .kde = &lxb_unicode_decomposition_k_FA94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA95[1] = {0x6B79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA95[1] = {0x6B79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA95[1] = {0x6B79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA95, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA95 = {.cp = 0xFA95, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA95, .cde = &lxb_unicode_decomposition_c_FA95, .kde = &lxb_unicode_decomposition_k_FA95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA96[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA96[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA96[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA96, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA96 = {.cp = 0xFA96, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA96, .cde = &lxb_unicode_decomposition_c_FA96, .kde = &lxb_unicode_decomposition_k_FA96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA97[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA97[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA97[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA97, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA97 = {.cp = 0xFA97, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA97, .cde = &lxb_unicode_decomposition_c_FA97, .kde = &lxb_unicode_decomposition_k_FA97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA98[1] = {0x6EDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA98[1] = {0x6EDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA98[1] = {0x6EDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA98, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA98 = {.cp = 0xFA98, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA98, .cde = &lxb_unicode_decomposition_c_FA98, .kde = &lxb_unicode_decomposition_k_FA98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA99[1] = {0x6ECB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA99[1] = {0x6ECB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA99[1] = {0x6ECB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA99, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA99 = {.cp = 0xFA99, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA99, .cde = &lxb_unicode_decomposition_c_FA99, .kde = &lxb_unicode_decomposition_k_FA99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA9A[1] = {0x6F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA9A[1] = {0x6F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA9A[1] = {0x6F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA9A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA9A = {.cp = 0xFA9A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA9A, .cde = &lxb_unicode_decomposition_c_FA9A, .kde = &lxb_unicode_decomposition_k_FA9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA9B[1] = {0x701E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA9B[1] = {0x701E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA9B[1] = {0x701E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA9B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA9B = {.cp = 0xFA9B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA9B, .cde = &lxb_unicode_decomposition_c_FA9B, .kde = &lxb_unicode_decomposition_k_FA9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA9C[1] = {0x716E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA9C[1] = {0x716E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA9C[1] = {0x716E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA9C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA9C = {.cp = 0xFA9C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA9C, .cde = &lxb_unicode_decomposition_c_FA9C, .kde = &lxb_unicode_decomposition_k_FA9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA9D[1] = {0x77A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA9D[1] = {0x77A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA9D[1] = {0x77A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA9D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA9D = {.cp = 0xFA9D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA9D, .cde = &lxb_unicode_decomposition_c_FA9D, .kde = &lxb_unicode_decomposition_k_FA9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA9E[1] = {0x7235};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA9E[1] = {0x7235};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA9E[1] = {0x7235};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA9E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA9E = {.cp = 0xFA9E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA9E, .cde = &lxb_unicode_decomposition_c_FA9E, .kde = &lxb_unicode_decomposition_k_FA9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FA9F[1] = {0x72AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FA9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FA9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FA9F[1] = {0x72AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FA9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FA9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FA9F[1] = {0x72AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FA9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FA9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FA9F = {.cp = 0xFA9F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FA9F, .cde = &lxb_unicode_decomposition_c_FA9F, .kde = &lxb_unicode_decomposition_k_FA9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA0[1] = {0x732A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA0[1] = {0x732A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA0[1] = {0x732A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA0 = {.cp = 0xFAA0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA0, .cde = &lxb_unicode_decomposition_c_FAA0, .kde = &lxb_unicode_decomposition_k_FAA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA1[1] = {0x7471};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA1[1] = {0x7471};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA1[1] = {0x7471};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA1 = {.cp = 0xFAA1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA1, .cde = &lxb_unicode_decomposition_c_FAA1, .kde = &lxb_unicode_decomposition_k_FAA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA2[1] = {0x7506};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA2[1] = {0x7506};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA2[1] = {0x7506};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA2 = {.cp = 0xFAA2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA2, .cde = &lxb_unicode_decomposition_c_FAA2, .kde = &lxb_unicode_decomposition_k_FAA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA3[1] = {0x753B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA3[1] = {0x753B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA3[1] = {0x753B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA3 = {.cp = 0xFAA3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA3, .cde = &lxb_unicode_decomposition_c_FAA3, .kde = &lxb_unicode_decomposition_k_FAA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA4[1] = {0x761D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA4[1] = {0x761D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA4[1] = {0x761D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA4 = {.cp = 0xFAA4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA4, .cde = &lxb_unicode_decomposition_c_FAA4, .kde = &lxb_unicode_decomposition_k_FAA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA5[1] = {0x761F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA5[1] = {0x761F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA5[1] = {0x761F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA5 = {.cp = 0xFAA5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA5, .cde = &lxb_unicode_decomposition_c_FAA5, .kde = &lxb_unicode_decomposition_k_FAA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA6[1] = {0x76CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA6[1] = {0x76CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA6[1] = {0x76CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA6 = {.cp = 0xFAA6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA6, .cde = &lxb_unicode_decomposition_c_FAA6, .kde = &lxb_unicode_decomposition_k_FAA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA7[1] = {0x76DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA7[1] = {0x76DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA7[1] = {0x76DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA7 = {.cp = 0xFAA7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA7, .cde = &lxb_unicode_decomposition_c_FAA7, .kde = &lxb_unicode_decomposition_k_FAA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA8[1] = {0x76F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA8[1] = {0x76F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA8[1] = {0x76F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA8 = {.cp = 0xFAA8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA8, .cde = &lxb_unicode_decomposition_c_FAA8, .kde = &lxb_unicode_decomposition_k_FAA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAA9[1] = {0x774A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAA9[1] = {0x774A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAA9[1] = {0x774A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAA9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAA9 = {.cp = 0xFAA9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAA9, .cde = &lxb_unicode_decomposition_c_FAA9, .kde = &lxb_unicode_decomposition_k_FAA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAAA[1] = {0x7740};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAAA[1] = {0x7740};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAAA[1] = {0x7740};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAAA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAAA = {.cp = 0xFAAA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAAA, .cde = &lxb_unicode_decomposition_c_FAAA, .kde = &lxb_unicode_decomposition_k_FAAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAAB[1] = {0x78CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAAB[1] = {0x78CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAAB[1] = {0x78CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAAB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAAB = {.cp = 0xFAAB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAAB, .cde = &lxb_unicode_decomposition_c_FAAB, .kde = &lxb_unicode_decomposition_k_FAAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAAC[1] = {0x7AB1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAAC[1] = {0x7AB1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAAC[1] = {0x7AB1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAAC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAAC = {.cp = 0xFAAC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAAC, .cde = &lxb_unicode_decomposition_c_FAAC, .kde = &lxb_unicode_decomposition_k_FAAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAAD[1] = {0x7BC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAAD[1] = {0x7BC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAAD[1] = {0x7BC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAAD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAAD = {.cp = 0xFAAD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAAD, .cde = &lxb_unicode_decomposition_c_FAAD, .kde = &lxb_unicode_decomposition_k_FAAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAAE[1] = {0x7C7B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAAE[1] = {0x7C7B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAAE[1] = {0x7C7B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAAE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAAE = {.cp = 0xFAAE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAAE, .cde = &lxb_unicode_decomposition_c_FAAE, .kde = &lxb_unicode_decomposition_k_FAAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAAF[1] = {0x7D5B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAAF[1] = {0x7D5B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAAF[1] = {0x7D5B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAAF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAAF = {.cp = 0xFAAF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAAF, .cde = &lxb_unicode_decomposition_c_FAAF, .kde = &lxb_unicode_decomposition_k_FAAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB0[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB0[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB0[1] = {0x7DF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB0 = {.cp = 0xFAB0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB0, .cde = &lxb_unicode_decomposition_c_FAB0, .kde = &lxb_unicode_decomposition_k_FAB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB1[1] = {0x7F3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB1[1] = {0x7F3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB1[1] = {0x7F3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB1 = {.cp = 0xFAB1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB1, .cde = &lxb_unicode_decomposition_c_FAB1, .kde = &lxb_unicode_decomposition_k_FAB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB2[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB2[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB2[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB2 = {.cp = 0xFAB2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB2, .cde = &lxb_unicode_decomposition_c_FAB2, .kde = &lxb_unicode_decomposition_k_FAB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB3[1] = {0x8352};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB3[1] = {0x8352};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB3[1] = {0x8352};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB3 = {.cp = 0xFAB3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB3, .cde = &lxb_unicode_decomposition_c_FAB3, .kde = &lxb_unicode_decomposition_k_FAB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB4[1] = {0x83EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB4[1] = {0x83EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB4[1] = {0x83EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB4 = {.cp = 0xFAB4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB4, .cde = &lxb_unicode_decomposition_c_FAB4, .kde = &lxb_unicode_decomposition_k_FAB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB5[1] = {0x8779};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB5[1] = {0x8779};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB5[1] = {0x8779};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB5 = {.cp = 0xFAB5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB5, .cde = &lxb_unicode_decomposition_c_FAB5, .kde = &lxb_unicode_decomposition_k_FAB5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB6[1] = {0x8941};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB6[1] = {0x8941};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB6[1] = {0x8941};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB6 = {.cp = 0xFAB6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB6, .cde = &lxb_unicode_decomposition_c_FAB6, .kde = &lxb_unicode_decomposition_k_FAB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB7[1] = {0x8986};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB7[1] = {0x8986};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB7[1] = {0x8986};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB7 = {.cp = 0xFAB7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB7, .cde = &lxb_unicode_decomposition_c_FAB7, .kde = &lxb_unicode_decomposition_k_FAB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB8[1] = {0x8996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB8[1] = {0x8996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB8[1] = {0x8996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB8 = {.cp = 0xFAB8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB8, .cde = &lxb_unicode_decomposition_c_FAB8, .kde = &lxb_unicode_decomposition_k_FAB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAB9[1] = {0x8ABF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAB9[1] = {0x8ABF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAB9[1] = {0x8ABF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAB9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAB9 = {.cp = 0xFAB9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAB9, .cde = &lxb_unicode_decomposition_c_FAB9, .kde = &lxb_unicode_decomposition_k_FAB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FABA[1] = {0x8AF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FABA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FABA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FABA[1] = {0x8AF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FABA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FABA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FABA[1] = {0x8AF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FABA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FABA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FABA = {.cp = 0xFABA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FABA, .cde = &lxb_unicode_decomposition_c_FABA, .kde = &lxb_unicode_decomposition_k_FABA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FABB[1] = {0x8ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FABB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FABB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FABB[1] = {0x8ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FABB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FABB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FABB[1] = {0x8ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FABB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FABB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FABB = {.cp = 0xFABB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FABB, .cde = &lxb_unicode_decomposition_c_FABB, .kde = &lxb_unicode_decomposition_k_FABB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FABC[1] = {0x8B01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FABC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FABC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FABC[1] = {0x8B01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FABC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FABC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FABC[1] = {0x8B01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FABC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FABC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FABC = {.cp = 0xFABC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FABC, .cde = &lxb_unicode_decomposition_c_FABC, .kde = &lxb_unicode_decomposition_k_FABC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FABD[1] = {0x8AFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FABD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FABD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FABD[1] = {0x8AFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FABD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FABD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FABD[1] = {0x8AFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FABD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FABD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FABD = {.cp = 0xFABD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FABD, .cde = &lxb_unicode_decomposition_c_FABD, .kde = &lxb_unicode_decomposition_k_FABD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FABE[1] = {0x8AED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FABE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FABE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FABE[1] = {0x8AED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FABE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FABE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FABE[1] = {0x8AED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FABE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FABE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FABE = {.cp = 0xFABE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FABE, .cde = &lxb_unicode_decomposition_c_FABE, .kde = &lxb_unicode_decomposition_k_FABE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FABF[1] = {0x8B39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FABF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FABF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FABF[1] = {0x8B39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FABF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FABF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FABF[1] = {0x8B39};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FABF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FABF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FABF = {.cp = 0xFABF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FABF, .cde = &lxb_unicode_decomposition_c_FABF, .kde = &lxb_unicode_decomposition_k_FABF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC0[1] = {0x8B8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC0[1] = {0x8B8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC0[1] = {0x8B8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC0 = {.cp = 0xFAC0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC0, .cde = &lxb_unicode_decomposition_c_FAC0, .kde = &lxb_unicode_decomposition_k_FAC0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC1[1] = {0x8D08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC1[1] = {0x8D08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC1[1] = {0x8D08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC1 = {.cp = 0xFAC1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC1, .cde = &lxb_unicode_decomposition_c_FAC1, .kde = &lxb_unicode_decomposition_k_FAC1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC2[1] = {0x8F38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC2[1] = {0x8F38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC2[1] = {0x8F38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC2 = {.cp = 0xFAC2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC2, .cde = &lxb_unicode_decomposition_c_FAC2, .kde = &lxb_unicode_decomposition_k_FAC2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC3[1] = {0x9072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC3[1] = {0x9072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC3[1] = {0x9072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC3 = {.cp = 0xFAC3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC3, .cde = &lxb_unicode_decomposition_c_FAC3, .kde = &lxb_unicode_decomposition_k_FAC3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC4[1] = {0x9199};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC4[1] = {0x9199};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC4[1] = {0x9199};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC4 = {.cp = 0xFAC4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC4, .cde = &lxb_unicode_decomposition_c_FAC4, .kde = &lxb_unicode_decomposition_k_FAC4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC5[1] = {0x9276};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC5[1] = {0x9276};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC5[1] = {0x9276};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC5 = {.cp = 0xFAC5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC5, .cde = &lxb_unicode_decomposition_c_FAC5, .kde = &lxb_unicode_decomposition_k_FAC5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC6[1] = {0x967C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC6[1] = {0x967C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC6[1] = {0x967C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC6 = {.cp = 0xFAC6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC6, .cde = &lxb_unicode_decomposition_c_FAC6, .kde = &lxb_unicode_decomposition_k_FAC6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC7[1] = {0x96E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC7[1] = {0x96E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC7[1] = {0x96E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC7 = {.cp = 0xFAC7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC7, .cde = &lxb_unicode_decomposition_c_FAC7, .kde = &lxb_unicode_decomposition_k_FAC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC8[1] = {0x9756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC8[1] = {0x9756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC8[1] = {0x9756};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC8 = {.cp = 0xFAC8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC8, .cde = &lxb_unicode_decomposition_c_FAC8, .kde = &lxb_unicode_decomposition_k_FAC8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAC9[1] = {0x97DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAC9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAC9[1] = {0x97DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAC9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAC9[1] = {0x97DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAC9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAC9 = {.cp = 0xFAC9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAC9, .cde = &lxb_unicode_decomposition_c_FAC9, .kde = &lxb_unicode_decomposition_k_FAC9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FACA[1] = {0x97FF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FACA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FACA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FACA[1] = {0x97FF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FACA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FACA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FACA[1] = {0x97FF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FACA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FACA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FACA = {.cp = 0xFACA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FACA, .cde = &lxb_unicode_decomposition_c_FACA, .kde = &lxb_unicode_decomposition_k_FACA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FACB[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FACB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FACB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FACB[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FACB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FACB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FACB[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FACB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FACB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FACB = {.cp = 0xFACB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FACB, .cde = &lxb_unicode_decomposition_c_FACB, .kde = &lxb_unicode_decomposition_k_FACB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FACC[1] = {0x983B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FACC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FACC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FACC[1] = {0x983B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FACC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FACC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FACC[1] = {0x983B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FACC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FACC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FACC = {.cp = 0xFACC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FACC, .cde = &lxb_unicode_decomposition_c_FACC, .kde = &lxb_unicode_decomposition_k_FACC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FACD[1] = {0x9B12};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FACD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FACD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FACD[1] = {0x9B12};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FACD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FACD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FACD[1] = {0x9B12};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FACD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FACD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FACD = {.cp = 0xFACD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FACD, .cde = &lxb_unicode_decomposition_c_FACD, .kde = &lxb_unicode_decomposition_k_FACD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FACE[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FACE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FACE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FACE[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FACE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FACE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FACE[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FACE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FACE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FACE = {.cp = 0xFACE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FACE, .cde = &lxb_unicode_decomposition_c_FACE, .kde = &lxb_unicode_decomposition_k_FACE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FACF[1] = {0x2284A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FACF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FACF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FACF[1] = {0x2284A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FACF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FACF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FACF[1] = {0x2284A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FACF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FACF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FACF = {.cp = 0xFACF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FACF, .cde = &lxb_unicode_decomposition_c_FACF, .kde = &lxb_unicode_decomposition_k_FACF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD0[1] = {0x22844};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD0[1] = {0x22844};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD0[1] = {0x22844};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD0 = {.cp = 0xFAD0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD0, .cde = &lxb_unicode_decomposition_c_FAD0, .kde = &lxb_unicode_decomposition_k_FAD0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD1[1] = {0x233D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD1[1] = {0x233D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD1[1] = {0x233D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD1 = {.cp = 0xFAD1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD1, .cde = &lxb_unicode_decomposition_c_FAD1, .kde = &lxb_unicode_decomposition_k_FAD1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD2[1] = {0x3B9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD2[1] = {0x3B9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD2[1] = {0x3B9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD2 = {.cp = 0xFAD2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD2, .cde = &lxb_unicode_decomposition_c_FAD2, .kde = &lxb_unicode_decomposition_k_FAD2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD3[1] = {0x4018};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD3[1] = {0x4018};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD3[1] = {0x4018};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD3 = {.cp = 0xFAD3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD3, .cde = &lxb_unicode_decomposition_c_FAD3, .kde = &lxb_unicode_decomposition_k_FAD3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD4[1] = {0x4039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD4[1] = {0x4039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD4[1] = {0x4039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD4 = {.cp = 0xFAD4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD4, .cde = &lxb_unicode_decomposition_c_FAD4, .kde = &lxb_unicode_decomposition_k_FAD4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD5[1] = {0x25249};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD5[1] = {0x25249};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD5[1] = {0x25249};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD5 = {.cp = 0xFAD5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD5, .cde = &lxb_unicode_decomposition_c_FAD5, .kde = &lxb_unicode_decomposition_k_FAD5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD6[1] = {0x25CD0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD6[1] = {0x25CD0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD6[1] = {0x25CD0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD6 = {.cp = 0xFAD6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD6, .cde = &lxb_unicode_decomposition_c_FAD6, .kde = &lxb_unicode_decomposition_k_FAD6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD7[1] = {0x27ED3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD7[1] = {0x27ED3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD7[1] = {0x27ED3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD7 = {.cp = 0xFAD7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD7, .cde = &lxb_unicode_decomposition_c_FAD7, .kde = &lxb_unicode_decomposition_k_FAD7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD8[1] = {0x9F43};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD8[1] = {0x9F43};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD8[1] = {0x9F43};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD8 = {.cp = 0xFAD8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD8, .cde = &lxb_unicode_decomposition_c_FAD8, .kde = &lxb_unicode_decomposition_k_FAD8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FAD9[1] = {0x9F8E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FAD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FAD9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FAD9[1] = {0x9F8E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FAD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FAD9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FAD9[1] = {0x9F8E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FAD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FAD9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FAD9 = {.cp = 0xFAD9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FAD9, .cde = &lxb_unicode_decomposition_c_FAD9, .kde = &lxb_unicode_decomposition_k_FAD9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB00[2] = {0x0066, 0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB00, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB00[2] = {0x0066, 0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB00, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB00[2] = {0x0066, 0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB00, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB00 = {.cp = 0xFB00, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB00, .cde = &lxb_unicode_decomposition_c_FB00, .kde = &lxb_unicode_decomposition_k_FB00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB01[2] = {0x0066, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB01, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB01[2] = {0x0066, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB01, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB01[2] = {0x0066, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB01, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB01 = {.cp = 0xFB01, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB01, .cde = &lxb_unicode_decomposition_c_FB01, .kde = &lxb_unicode_decomposition_k_FB01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB02[2] = {0x0066, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB02, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB02[2] = {0x0066, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB02, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB02[2] = {0x0066, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB02, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB02 = {.cp = 0xFB02, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB02, .cde = &lxb_unicode_decomposition_c_FB02, .kde = &lxb_unicode_decomposition_k_FB02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB03[3] = {0x0066, 0x0066, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB03, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB03[3] = {0x0066, 0x0066, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB03, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB03[3] = {0x0066, 0x0066, 0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB03, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FB03 = {.cp = 0xFB03, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB03, .cde = &lxb_unicode_decomposition_c_FB03, .kde = &lxb_unicode_decomposition_k_FB03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB04[3] = {0x0066, 0x0066, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB04, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB04[3] = {0x0066, 0x0066, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB04, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB04[3] = {0x0066, 0x0066, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB04, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FB04 = {.cp = 0xFB04, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB04, .cde = &lxb_unicode_decomposition_c_FB04, .kde = &lxb_unicode_decomposition_k_FB04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB05[2] = {0x017F, 0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB05, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB05[2] = {0x0073, 0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB05, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB05[2] = {0x017F, 0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB05, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB05 = {.cp = 0xFB05, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB05, .cde = &lxb_unicode_decomposition_c_FB05, .kde = &lxb_unicode_decomposition_k_FB05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB06[2] = {0x0073, 0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB06[2] = {0x0073, 0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB06[2] = {0x0073, 0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB06, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB06 = {.cp = 0xFB06, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB06, .cde = &lxb_unicode_decomposition_c_FB06, .kde = &lxb_unicode_decomposition_k_FB06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB13[2] = {0x0574, 0x0576};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB13, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB13[2] = {0x0574, 0x0576};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB13, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB13[2] = {0x0574, 0x0576};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB13, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB13 = {.cp = 0xFB13, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB13, .cde = &lxb_unicode_decomposition_c_FB13, .kde = &lxb_unicode_decomposition_k_FB13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB14[2] = {0x0574, 0x0565};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB14, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB14[2] = {0x0574, 0x0565};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB14, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB14[2] = {0x0574, 0x0565};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB14, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB14 = {.cp = 0xFB14, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB14, .cde = &lxb_unicode_decomposition_c_FB14, .kde = &lxb_unicode_decomposition_k_FB14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB15[2] = {0x0574, 0x056B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB15, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB15[2] = {0x0574, 0x056B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB15, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB15[2] = {0x0574, 0x056B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB15, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB15 = {.cp = 0xFB15, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB15, .cde = &lxb_unicode_decomposition_c_FB15, .kde = &lxb_unicode_decomposition_k_FB15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB16[2] = {0x057E, 0x0576};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB16, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB16[2] = {0x057E, 0x0576};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB16, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB16[2] = {0x057E, 0x0576};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB16, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB16 = {.cp = 0xFB16, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB16, .cde = &lxb_unicode_decomposition_c_FB16, .kde = &lxb_unicode_decomposition_k_FB16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB17[2] = {0x0574, 0x056D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB17, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB17[2] = {0x0574, 0x056D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB17, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB17[2] = {0x0574, 0x056D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB17, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB17 = {.cp = 0xFB17, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB17, .cde = &lxb_unicode_decomposition_c_FB17, .kde = &lxb_unicode_decomposition_k_FB17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB1D[2] = {0x05D9, 0x05B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB1D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB1D[2] = {0x05D9, 0x05B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB1D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB1D[2] = {0x05D9, 0x05B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB1D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB1D = {.cp = 0xFB1D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB1D, .cde = &lxb_unicode_decomposition_c_FB1D, .kde = &lxb_unicode_decomposition_k_FB1D};

static const lxb_unicode_entry_t lxb_unicode_entry_FB1E = {.cp = 0xFB1E, .ccc = 26, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB1F[2] = {0x05F2, 0x05B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB1F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB1F[2] = {0x05F2, 0x05B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB1F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB1F[2] = {0x05F2, 0x05B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB1F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB1F = {.cp = 0xFB1F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB1F, .cde = &lxb_unicode_decomposition_c_FB1F, .kde = &lxb_unicode_decomposition_k_FB1F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB20[1] = {0x05E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB20[1] = {0x05E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB20[1] = {0x05E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB20, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB20 = {.cp = 0xFB20, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB20, .cde = &lxb_unicode_decomposition_c_FB20, .kde = &lxb_unicode_decomposition_k_FB20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB21[1] = {0x05D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB21, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB21[1] = {0x05D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB21, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB21[1] = {0x05D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB21, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB21 = {.cp = 0xFB21, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB21, .cde = &lxb_unicode_decomposition_c_FB21, .kde = &lxb_unicode_decomposition_k_FB21};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB22[1] = {0x05D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB22[1] = {0x05D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB22[1] = {0x05D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB22, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB22 = {.cp = 0xFB22, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB22, .cde = &lxb_unicode_decomposition_c_FB22, .kde = &lxb_unicode_decomposition_k_FB22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB23[1] = {0x05D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB23, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB23[1] = {0x05D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB23, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB23[1] = {0x05D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB23, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB23 = {.cp = 0xFB23, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB23, .cde = &lxb_unicode_decomposition_c_FB23, .kde = &lxb_unicode_decomposition_k_FB23};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB24[1] = {0x05DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB24, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB24[1] = {0x05DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB24, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB24[1] = {0x05DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB24, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB24 = {.cp = 0xFB24, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB24, .cde = &lxb_unicode_decomposition_c_FB24, .kde = &lxb_unicode_decomposition_k_FB24};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB25[1] = {0x05DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB25[1] = {0x05DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB25[1] = {0x05DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB25, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB25 = {.cp = 0xFB25, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB25, .cde = &lxb_unicode_decomposition_c_FB25, .kde = &lxb_unicode_decomposition_k_FB25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB26[1] = {0x05DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB26[1] = {0x05DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB26[1] = {0x05DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB26, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB26 = {.cp = 0xFB26, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB26, .cde = &lxb_unicode_decomposition_c_FB26, .kde = &lxb_unicode_decomposition_k_FB26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB27[1] = {0x05E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB27, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB27[1] = {0x05E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB27, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB27[1] = {0x05E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB27, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB27 = {.cp = 0xFB27, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB27, .cde = &lxb_unicode_decomposition_c_FB27, .kde = &lxb_unicode_decomposition_k_FB27};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB28[1] = {0x05EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB28, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB28[1] = {0x05EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB28, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB28[1] = {0x05EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB28, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB28 = {.cp = 0xFB28, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB28, .cde = &lxb_unicode_decomposition_c_FB28, .kde = &lxb_unicode_decomposition_k_FB28};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB29[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_FB29, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB29[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_FB29, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB29[1] = {0x002B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__FB29, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB29 = {.cp = 0xFB29, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB29, .cde = &lxb_unicode_decomposition_c_FB29, .kde = &lxb_unicode_decomposition_k_FB29};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB2A[2] = {0x05E9, 0x05C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB2A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB2A[2] = {0x05E9, 0x05C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB2A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB2A[2] = {0x05E9, 0x05C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB2A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB2A = {.cp = 0xFB2A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB2A, .cde = &lxb_unicode_decomposition_c_FB2A, .kde = &lxb_unicode_decomposition_k_FB2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB2B[2] = {0x05E9, 0x05C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB2B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB2B[2] = {0x05E9, 0x05C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB2B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB2B[2] = {0x05E9, 0x05C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB2B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB2B = {.cp = 0xFB2B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB2B, .cde = &lxb_unicode_decomposition_c_FB2B, .kde = &lxb_unicode_decomposition_k_FB2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB2C[3] = {0x05E9, 0x05BC, 0x05C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB2C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB2C[3] = {0x05E9, 0x05BC, 0x05C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB2C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB2C[2] = {0xFB49, 0x05C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB2C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB2C = {.cp = 0xFB2C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB2C, .cde = &lxb_unicode_decomposition_c_FB2C, .kde = &lxb_unicode_decomposition_k_FB2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB2D[3] = {0x05E9, 0x05BC, 0x05C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB2D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB2D[3] = {0x05E9, 0x05BC, 0x05C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB2D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB2D[2] = {0xFB49, 0x05C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB2D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB2D = {.cp = 0xFB2D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB2D, .cde = &lxb_unicode_decomposition_c_FB2D, .kde = &lxb_unicode_decomposition_k_FB2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB2E[2] = {0x05D0, 0x05B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB2E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB2E[2] = {0x05D0, 0x05B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB2E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB2E[2] = {0x05D0, 0x05B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB2E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB2E = {.cp = 0xFB2E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB2E, .cde = &lxb_unicode_decomposition_c_FB2E, .kde = &lxb_unicode_decomposition_k_FB2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB2F[2] = {0x05D0, 0x05B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB2F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB2F[2] = {0x05D0, 0x05B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB2F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB2F[2] = {0x05D0, 0x05B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB2F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB2F = {.cp = 0xFB2F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB2F, .cde = &lxb_unicode_decomposition_c_FB2F, .kde = &lxb_unicode_decomposition_k_FB2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB30[2] = {0x05D0, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB30[2] = {0x05D0, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB30[2] = {0x05D0, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB30, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB30 = {.cp = 0xFB30, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB30, .cde = &lxb_unicode_decomposition_c_FB30, .kde = &lxb_unicode_decomposition_k_FB30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB31[2] = {0x05D1, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB31[2] = {0x05D1, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB31[2] = {0x05D1, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB31, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB31 = {.cp = 0xFB31, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB31, .cde = &lxb_unicode_decomposition_c_FB31, .kde = &lxb_unicode_decomposition_k_FB31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB32[2] = {0x05D2, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB32, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB32[2] = {0x05D2, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB32, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB32[2] = {0x05D2, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB32, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB32 = {.cp = 0xFB32, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB32, .cde = &lxb_unicode_decomposition_c_FB32, .kde = &lxb_unicode_decomposition_k_FB32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB33[2] = {0x05D3, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB33[2] = {0x05D3, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB33[2] = {0x05D3, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB33, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB33 = {.cp = 0xFB33, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB33, .cde = &lxb_unicode_decomposition_c_FB33, .kde = &lxb_unicode_decomposition_k_FB33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB34[2] = {0x05D4, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB34, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB34[2] = {0x05D4, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB34, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB34[2] = {0x05D4, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB34, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB34 = {.cp = 0xFB34, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB34, .cde = &lxb_unicode_decomposition_c_FB34, .kde = &lxb_unicode_decomposition_k_FB34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB35[2] = {0x05D5, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB35, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB35[2] = {0x05D5, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB35, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB35[2] = {0x05D5, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB35, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB35 = {.cp = 0xFB35, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB35, .cde = &lxb_unicode_decomposition_c_FB35, .kde = &lxb_unicode_decomposition_k_FB35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB36[2] = {0x05D6, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB36[2] = {0x05D6, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB36[2] = {0x05D6, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB36, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB36 = {.cp = 0xFB36, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB36, .cde = &lxb_unicode_decomposition_c_FB36, .kde = &lxb_unicode_decomposition_k_FB36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB38[2] = {0x05D8, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB38, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB38[2] = {0x05D8, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB38, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB38[2] = {0x05D8, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB38, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB38 = {.cp = 0xFB38, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB38, .cde = &lxb_unicode_decomposition_c_FB38, .kde = &lxb_unicode_decomposition_k_FB38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB39[2] = {0x05D9, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB39, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB39[2] = {0x05D9, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB39, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB39[2] = {0x05D9, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB39, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB39 = {.cp = 0xFB39, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB39, .cde = &lxb_unicode_decomposition_c_FB39, .kde = &lxb_unicode_decomposition_k_FB39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB3A[2] = {0x05DA, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB3A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB3A[2] = {0x05DA, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB3A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB3A[2] = {0x05DA, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB3A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB3A = {.cp = 0xFB3A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB3A, .cde = &lxb_unicode_decomposition_c_FB3A, .kde = &lxb_unicode_decomposition_k_FB3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB3B[2] = {0x05DB, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB3B[2] = {0x05DB, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB3B[2] = {0x05DB, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB3B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB3B = {.cp = 0xFB3B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB3B, .cde = &lxb_unicode_decomposition_c_FB3B, .kde = &lxb_unicode_decomposition_k_FB3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB3C[2] = {0x05DC, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB3C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB3C[2] = {0x05DC, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB3C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB3C[2] = {0x05DC, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB3C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB3C = {.cp = 0xFB3C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB3C, .cde = &lxb_unicode_decomposition_c_FB3C, .kde = &lxb_unicode_decomposition_k_FB3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB3E[2] = {0x05DE, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB3E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB3E[2] = {0x05DE, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB3E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB3E[2] = {0x05DE, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB3E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB3E = {.cp = 0xFB3E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB3E, .cde = &lxb_unicode_decomposition_c_FB3E, .kde = &lxb_unicode_decomposition_k_FB3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB40[2] = {0x05E0, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB40[2] = {0x05E0, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB40[2] = {0x05E0, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB40, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB40 = {.cp = 0xFB40, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB40, .cde = &lxb_unicode_decomposition_c_FB40, .kde = &lxb_unicode_decomposition_k_FB40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB41[2] = {0x05E1, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB41[2] = {0x05E1, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB41[2] = {0x05E1, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB41, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB41 = {.cp = 0xFB41, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB41, .cde = &lxb_unicode_decomposition_c_FB41, .kde = &lxb_unicode_decomposition_k_FB41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB43[2] = {0x05E3, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB43[2] = {0x05E3, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB43[2] = {0x05E3, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB43, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB43 = {.cp = 0xFB43, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB43, .cde = &lxb_unicode_decomposition_c_FB43, .kde = &lxb_unicode_decomposition_k_FB43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB44[2] = {0x05E4, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB44, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB44[2] = {0x05E4, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB44, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB44[2] = {0x05E4, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB44, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB44 = {.cp = 0xFB44, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB44, .cde = &lxb_unicode_decomposition_c_FB44, .kde = &lxb_unicode_decomposition_k_FB44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB46[2] = {0x05E6, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB46, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB46[2] = {0x05E6, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB46, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB46[2] = {0x05E6, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB46, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB46 = {.cp = 0xFB46, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB46, .cde = &lxb_unicode_decomposition_c_FB46, .kde = &lxb_unicode_decomposition_k_FB46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB47[2] = {0x05E7, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB47, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB47[2] = {0x05E7, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB47, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB47[2] = {0x05E7, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB47, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB47 = {.cp = 0xFB47, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB47, .cde = &lxb_unicode_decomposition_c_FB47, .kde = &lxb_unicode_decomposition_k_FB47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB48[2] = {0x05E8, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB48[2] = {0x05E8, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB48[2] = {0x05E8, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB48, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB48 = {.cp = 0xFB48, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB48, .cde = &lxb_unicode_decomposition_c_FB48, .kde = &lxb_unicode_decomposition_k_FB48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB49[2] = {0x05E9, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB49[2] = {0x05E9, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB49[2] = {0x05E9, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB49, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB49 = {.cp = 0xFB49, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB49, .cde = &lxb_unicode_decomposition_c_FB49, .kde = &lxb_unicode_decomposition_k_FB49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB4A[2] = {0x05EA, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB4A[2] = {0x05EA, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB4A[2] = {0x05EA, 0x05BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB4A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB4A = {.cp = 0xFB4A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB4A, .cde = &lxb_unicode_decomposition_c_FB4A, .kde = &lxb_unicode_decomposition_k_FB4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB4B[2] = {0x05D5, 0x05B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB4B[2] = {0x05D5, 0x05B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB4B[2] = {0x05D5, 0x05B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB4B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB4B = {.cp = 0xFB4B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB4B, .cde = &lxb_unicode_decomposition_c_FB4B, .kde = &lxb_unicode_decomposition_k_FB4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB4C[2] = {0x05D1, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB4C[2] = {0x05D1, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB4C[2] = {0x05D1, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB4C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB4C = {.cp = 0xFB4C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB4C, .cde = &lxb_unicode_decomposition_c_FB4C, .kde = &lxb_unicode_decomposition_k_FB4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB4D[2] = {0x05DB, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB4D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB4D[2] = {0x05DB, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB4D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB4D[2] = {0x05DB, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB4D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB4D = {.cp = 0xFB4D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB4D, .cde = &lxb_unicode_decomposition_c_FB4D, .kde = &lxb_unicode_decomposition_k_FB4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB4E[2] = {0x05E4, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_FB4E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB4E[2] = {0x05E4, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_FB4E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB4E[2] = {0x05E4, 0x05BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__FB4E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB4E = {.cp = 0xFB4E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB4E, .cde = &lxb_unicode_decomposition_c_FB4E, .kde = &lxb_unicode_decomposition_k_FB4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB4F[2] = {0x05D0, 0x05DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_FB4F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB4F[2] = {0x05D0, 0x05DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_FB4F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB4F[2] = {0x05D0, 0x05DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__FB4F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FB4F = {.cp = 0xFB4F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB4F, .cde = &lxb_unicode_decomposition_c_FB4F, .kde = &lxb_unicode_decomposition_k_FB4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB50[1] = {0x0671};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB50[1] = {0x0671};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB50[1] = {0x0671};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB50, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB50 = {.cp = 0xFB50, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB50, .cde = &lxb_unicode_decomposition_c_FB50, .kde = &lxb_unicode_decomposition_k_FB50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB51[1] = {0x0671};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB51[1] = {0x0671};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB51[1] = {0x0671};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB51, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB51 = {.cp = 0xFB51, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB51, .cde = &lxb_unicode_decomposition_c_FB51, .kde = &lxb_unicode_decomposition_k_FB51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB52[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB52[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB52[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB52, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB52 = {.cp = 0xFB52, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB52, .cde = &lxb_unicode_decomposition_c_FB52, .kde = &lxb_unicode_decomposition_k_FB52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB53[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB53[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB53[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB53, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB53 = {.cp = 0xFB53, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB53, .cde = &lxb_unicode_decomposition_c_FB53, .kde = &lxb_unicode_decomposition_k_FB53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB54[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB54[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB54[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB54, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB54 = {.cp = 0xFB54, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB54, .cde = &lxb_unicode_decomposition_c_FB54, .kde = &lxb_unicode_decomposition_k_FB54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB55[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB55[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB55[1] = {0x067B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB55, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB55 = {.cp = 0xFB55, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB55, .cde = &lxb_unicode_decomposition_c_FB55, .kde = &lxb_unicode_decomposition_k_FB55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB56[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB56[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB56[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB56, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB56 = {.cp = 0xFB56, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB56, .cde = &lxb_unicode_decomposition_c_FB56, .kde = &lxb_unicode_decomposition_k_FB56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB57[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB57[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB57[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB57, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB57 = {.cp = 0xFB57, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB57, .cde = &lxb_unicode_decomposition_c_FB57, .kde = &lxb_unicode_decomposition_k_FB57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB58[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB58[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB58[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB58, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB58 = {.cp = 0xFB58, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB58, .cde = &lxb_unicode_decomposition_c_FB58, .kde = &lxb_unicode_decomposition_k_FB58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB59[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB59[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB59[1] = {0x067E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB59, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB59 = {.cp = 0xFB59, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB59, .cde = &lxb_unicode_decomposition_c_FB59, .kde = &lxb_unicode_decomposition_k_FB59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB5A[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB5A[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB5A[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB5A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB5A = {.cp = 0xFB5A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB5A, .cde = &lxb_unicode_decomposition_c_FB5A, .kde = &lxb_unicode_decomposition_k_FB5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB5B[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB5B[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB5B[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB5B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB5B = {.cp = 0xFB5B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB5B, .cde = &lxb_unicode_decomposition_c_FB5B, .kde = &lxb_unicode_decomposition_k_FB5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB5C[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB5C[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB5C[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB5C = {.cp = 0xFB5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB5C, .cde = &lxb_unicode_decomposition_c_FB5C, .kde = &lxb_unicode_decomposition_k_FB5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB5D[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB5D[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB5D[1] = {0x0680};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB5D = {.cp = 0xFB5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB5D, .cde = &lxb_unicode_decomposition_c_FB5D, .kde = &lxb_unicode_decomposition_k_FB5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB5E[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB5E[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB5E[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB5E = {.cp = 0xFB5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB5E, .cde = &lxb_unicode_decomposition_c_FB5E, .kde = &lxb_unicode_decomposition_k_FB5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB5F[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB5F[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB5F[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB5F = {.cp = 0xFB5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB5F, .cde = &lxb_unicode_decomposition_c_FB5F, .kde = &lxb_unicode_decomposition_k_FB5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB60[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB60[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB60[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB60, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB60 = {.cp = 0xFB60, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB60, .cde = &lxb_unicode_decomposition_c_FB60, .kde = &lxb_unicode_decomposition_k_FB60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB61[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB61[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB61[1] = {0x067A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB61, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB61 = {.cp = 0xFB61, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB61, .cde = &lxb_unicode_decomposition_c_FB61, .kde = &lxb_unicode_decomposition_k_FB61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB62[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB62[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB62[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB62, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB62 = {.cp = 0xFB62, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB62, .cde = &lxb_unicode_decomposition_c_FB62, .kde = &lxb_unicode_decomposition_k_FB62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB63[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB63[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB63[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB63, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB63 = {.cp = 0xFB63, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB63, .cde = &lxb_unicode_decomposition_c_FB63, .kde = &lxb_unicode_decomposition_k_FB63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB64[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB64[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB64[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB64, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB64 = {.cp = 0xFB64, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB64, .cde = &lxb_unicode_decomposition_c_FB64, .kde = &lxb_unicode_decomposition_k_FB64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB65[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB65[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB65[1] = {0x067F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB65, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB65 = {.cp = 0xFB65, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB65, .cde = &lxb_unicode_decomposition_c_FB65, .kde = &lxb_unicode_decomposition_k_FB65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB66[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB66[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB66[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB66, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB66 = {.cp = 0xFB66, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB66, .cde = &lxb_unicode_decomposition_c_FB66, .kde = &lxb_unicode_decomposition_k_FB66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB67[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB67[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB67[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB67, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB67 = {.cp = 0xFB67, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB67, .cde = &lxb_unicode_decomposition_c_FB67, .kde = &lxb_unicode_decomposition_k_FB67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB68[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB68[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB68[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB68, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB68 = {.cp = 0xFB68, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB68, .cde = &lxb_unicode_decomposition_c_FB68, .kde = &lxb_unicode_decomposition_k_FB68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB69[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB69[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB69[1] = {0x0679};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB69 = {.cp = 0xFB69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB69, .cde = &lxb_unicode_decomposition_c_FB69, .kde = &lxb_unicode_decomposition_k_FB69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB6A[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB6A[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB6A[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB6A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB6A = {.cp = 0xFB6A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB6A, .cde = &lxb_unicode_decomposition_c_FB6A, .kde = &lxb_unicode_decomposition_k_FB6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB6B[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB6B[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB6B[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB6B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB6B = {.cp = 0xFB6B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB6B, .cde = &lxb_unicode_decomposition_c_FB6B, .kde = &lxb_unicode_decomposition_k_FB6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB6C[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB6C[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB6C[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB6C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB6C = {.cp = 0xFB6C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB6C, .cde = &lxb_unicode_decomposition_c_FB6C, .kde = &lxb_unicode_decomposition_k_FB6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB6D[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB6D[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB6D[1] = {0x06A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB6D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB6D = {.cp = 0xFB6D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB6D, .cde = &lxb_unicode_decomposition_c_FB6D, .kde = &lxb_unicode_decomposition_k_FB6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB6E[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB6E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB6E[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB6E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB6E[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB6E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB6E = {.cp = 0xFB6E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB6E, .cde = &lxb_unicode_decomposition_c_FB6E, .kde = &lxb_unicode_decomposition_k_FB6E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB6F[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB6F[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB6F[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB6F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB6F = {.cp = 0xFB6F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB6F, .cde = &lxb_unicode_decomposition_c_FB6F, .kde = &lxb_unicode_decomposition_k_FB6F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB70[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB70[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB70[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB70, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB70 = {.cp = 0xFB70, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB70, .cde = &lxb_unicode_decomposition_c_FB70, .kde = &lxb_unicode_decomposition_k_FB70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB71[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB71[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB71[1] = {0x06A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB71, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB71 = {.cp = 0xFB71, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB71, .cde = &lxb_unicode_decomposition_c_FB71, .kde = &lxb_unicode_decomposition_k_FB71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB72[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB72[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB72[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB72, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB72 = {.cp = 0xFB72, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB72, .cde = &lxb_unicode_decomposition_c_FB72, .kde = &lxb_unicode_decomposition_k_FB72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB73[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB73[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB73[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB73, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB73 = {.cp = 0xFB73, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB73, .cde = &lxb_unicode_decomposition_c_FB73, .kde = &lxb_unicode_decomposition_k_FB73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB74[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB74[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB74[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB74, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB74 = {.cp = 0xFB74, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB74, .cde = &lxb_unicode_decomposition_c_FB74, .kde = &lxb_unicode_decomposition_k_FB74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB75[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB75[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB75[1] = {0x0684};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB75, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB75 = {.cp = 0xFB75, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB75, .cde = &lxb_unicode_decomposition_c_FB75, .kde = &lxb_unicode_decomposition_k_FB75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB76[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB76[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB76[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB76, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB76 = {.cp = 0xFB76, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB76, .cde = &lxb_unicode_decomposition_c_FB76, .kde = &lxb_unicode_decomposition_k_FB76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB77[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB77[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB77[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB77, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB77 = {.cp = 0xFB77, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB77, .cde = &lxb_unicode_decomposition_c_FB77, .kde = &lxb_unicode_decomposition_k_FB77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB78[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB78[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB78[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB78, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB78 = {.cp = 0xFB78, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB78, .cde = &lxb_unicode_decomposition_c_FB78, .kde = &lxb_unicode_decomposition_k_FB78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB79[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB79[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB79[1] = {0x0683};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB79, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB79 = {.cp = 0xFB79, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB79, .cde = &lxb_unicode_decomposition_c_FB79, .kde = &lxb_unicode_decomposition_k_FB79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB7A[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB7A[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB7A[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB7A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB7A = {.cp = 0xFB7A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB7A, .cde = &lxb_unicode_decomposition_c_FB7A, .kde = &lxb_unicode_decomposition_k_FB7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB7B[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB7B[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB7B[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB7B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB7B = {.cp = 0xFB7B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB7B, .cde = &lxb_unicode_decomposition_c_FB7B, .kde = &lxb_unicode_decomposition_k_FB7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB7C[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB7C[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB7C[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB7C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB7C = {.cp = 0xFB7C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB7C, .cde = &lxb_unicode_decomposition_c_FB7C, .kde = &lxb_unicode_decomposition_k_FB7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB7D[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB7D[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB7D[1] = {0x0686};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB7D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB7D = {.cp = 0xFB7D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB7D, .cde = &lxb_unicode_decomposition_c_FB7D, .kde = &lxb_unicode_decomposition_k_FB7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB7E[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB7E[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB7E[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB7E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB7E = {.cp = 0xFB7E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB7E, .cde = &lxb_unicode_decomposition_c_FB7E, .kde = &lxb_unicode_decomposition_k_FB7E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB7F[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB7F[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB7F[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB7F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB7F = {.cp = 0xFB7F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB7F, .cde = &lxb_unicode_decomposition_c_FB7F, .kde = &lxb_unicode_decomposition_k_FB7F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB80[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB80[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB80[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB80, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB80 = {.cp = 0xFB80, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB80, .cde = &lxb_unicode_decomposition_c_FB80, .kde = &lxb_unicode_decomposition_k_FB80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB81[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB81[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB81[1] = {0x0687};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB81, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB81 = {.cp = 0xFB81, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB81, .cde = &lxb_unicode_decomposition_c_FB81, .kde = &lxb_unicode_decomposition_k_FB81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB82[1] = {0x068D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB82[1] = {0x068D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB82[1] = {0x068D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB82, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB82 = {.cp = 0xFB82, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB82, .cde = &lxb_unicode_decomposition_c_FB82, .kde = &lxb_unicode_decomposition_k_FB82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB83[1] = {0x068D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB83[1] = {0x068D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB83[1] = {0x068D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB83, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB83 = {.cp = 0xFB83, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB83, .cde = &lxb_unicode_decomposition_c_FB83, .kde = &lxb_unicode_decomposition_k_FB83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB84[1] = {0x068C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB84[1] = {0x068C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB84[1] = {0x068C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB84, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB84 = {.cp = 0xFB84, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB84, .cde = &lxb_unicode_decomposition_c_FB84, .kde = &lxb_unicode_decomposition_k_FB84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB85[1] = {0x068C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB85[1] = {0x068C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB85[1] = {0x068C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB85, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB85 = {.cp = 0xFB85, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB85, .cde = &lxb_unicode_decomposition_c_FB85, .kde = &lxb_unicode_decomposition_k_FB85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB86[1] = {0x068E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB86[1] = {0x068E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB86[1] = {0x068E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB86, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB86 = {.cp = 0xFB86, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB86, .cde = &lxb_unicode_decomposition_c_FB86, .kde = &lxb_unicode_decomposition_k_FB86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB87[1] = {0x068E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB87[1] = {0x068E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB87[1] = {0x068E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB87, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB87 = {.cp = 0xFB87, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB87, .cde = &lxb_unicode_decomposition_c_FB87, .kde = &lxb_unicode_decomposition_k_FB87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB88[1] = {0x0688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB88[1] = {0x0688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB88[1] = {0x0688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB88, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB88 = {.cp = 0xFB88, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB88, .cde = &lxb_unicode_decomposition_c_FB88, .kde = &lxb_unicode_decomposition_k_FB88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB89[1] = {0x0688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB89[1] = {0x0688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB89[1] = {0x0688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB89, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB89 = {.cp = 0xFB89, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB89, .cde = &lxb_unicode_decomposition_c_FB89, .kde = &lxb_unicode_decomposition_k_FB89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB8A[1] = {0x0698};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB8A[1] = {0x0698};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB8A[1] = {0x0698};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB8A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB8A = {.cp = 0xFB8A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB8A, .cde = &lxb_unicode_decomposition_c_FB8A, .kde = &lxb_unicode_decomposition_k_FB8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB8B[1] = {0x0698};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB8B[1] = {0x0698};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB8B[1] = {0x0698};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB8B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB8B = {.cp = 0xFB8B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB8B, .cde = &lxb_unicode_decomposition_c_FB8B, .kde = &lxb_unicode_decomposition_k_FB8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB8C[1] = {0x0691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB8C[1] = {0x0691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB8C[1] = {0x0691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB8C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB8C = {.cp = 0xFB8C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB8C, .cde = &lxb_unicode_decomposition_c_FB8C, .kde = &lxb_unicode_decomposition_k_FB8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB8D[1] = {0x0691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB8D[1] = {0x0691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB8D[1] = {0x0691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB8D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB8D = {.cp = 0xFB8D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB8D, .cde = &lxb_unicode_decomposition_c_FB8D, .kde = &lxb_unicode_decomposition_k_FB8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB8E[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB8E[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB8E[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB8E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB8E = {.cp = 0xFB8E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB8E, .cde = &lxb_unicode_decomposition_c_FB8E, .kde = &lxb_unicode_decomposition_k_FB8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB8F[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB8F[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB8F[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB8F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB8F = {.cp = 0xFB8F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB8F, .cde = &lxb_unicode_decomposition_c_FB8F, .kde = &lxb_unicode_decomposition_k_FB8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB90[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB90[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB90[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB90, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB90 = {.cp = 0xFB90, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB90, .cde = &lxb_unicode_decomposition_c_FB90, .kde = &lxb_unicode_decomposition_k_FB90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB91[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB91[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB91[1] = {0x06A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB91, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB91 = {.cp = 0xFB91, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB91, .cde = &lxb_unicode_decomposition_c_FB91, .kde = &lxb_unicode_decomposition_k_FB91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB92[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB92[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB92[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB92, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB92 = {.cp = 0xFB92, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB92, .cde = &lxb_unicode_decomposition_c_FB92, .kde = &lxb_unicode_decomposition_k_FB92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB93[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB93[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB93[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB93, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB93 = {.cp = 0xFB93, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB93, .cde = &lxb_unicode_decomposition_c_FB93, .kde = &lxb_unicode_decomposition_k_FB93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB94[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB94[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB94[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB94, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB94 = {.cp = 0xFB94, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB94, .cde = &lxb_unicode_decomposition_c_FB94, .kde = &lxb_unicode_decomposition_k_FB94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB95[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB95[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB95[1] = {0x06AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB95, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB95 = {.cp = 0xFB95, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB95, .cde = &lxb_unicode_decomposition_c_FB95, .kde = &lxb_unicode_decomposition_k_FB95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB96[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB96[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB96[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB96, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB96 = {.cp = 0xFB96, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB96, .cde = &lxb_unicode_decomposition_c_FB96, .kde = &lxb_unicode_decomposition_k_FB96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB97[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB97[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB97[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB97, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB97 = {.cp = 0xFB97, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB97, .cde = &lxb_unicode_decomposition_c_FB97, .kde = &lxb_unicode_decomposition_k_FB97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB98[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB98[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB98[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB98, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB98 = {.cp = 0xFB98, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB98, .cde = &lxb_unicode_decomposition_c_FB98, .kde = &lxb_unicode_decomposition_k_FB98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB99[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB99[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB99[1] = {0x06B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB99, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB99 = {.cp = 0xFB99, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB99, .cde = &lxb_unicode_decomposition_c_FB99, .kde = &lxb_unicode_decomposition_k_FB99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB9A[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB9A[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB9A[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB9A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB9A = {.cp = 0xFB9A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB9A, .cde = &lxb_unicode_decomposition_c_FB9A, .kde = &lxb_unicode_decomposition_k_FB9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB9B[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB9B[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB9B[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB9B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB9B = {.cp = 0xFB9B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB9B, .cde = &lxb_unicode_decomposition_c_FB9B, .kde = &lxb_unicode_decomposition_k_FB9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB9C[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FB9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB9C[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FB9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB9C[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FB9C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB9C = {.cp = 0xFB9C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB9C, .cde = &lxb_unicode_decomposition_c_FB9C, .kde = &lxb_unicode_decomposition_k_FB9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB9D[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FB9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB9D[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FB9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB9D[1] = {0x06B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FB9D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB9D = {.cp = 0xFB9D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB9D, .cde = &lxb_unicode_decomposition_c_FB9D, .kde = &lxb_unicode_decomposition_k_FB9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB9E[1] = {0x06BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FB9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB9E[1] = {0x06BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FB9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB9E[1] = {0x06BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FB9E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB9E = {.cp = 0xFB9E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB9E, .cde = &lxb_unicode_decomposition_c_FB9E, .kde = &lxb_unicode_decomposition_k_FB9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FB9F[1] = {0x06BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FB9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FB9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FB9F[1] = {0x06BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FB9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FB9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FB9F[1] = {0x06BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FB9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FB9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FB9F = {.cp = 0xFB9F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FB9F, .cde = &lxb_unicode_decomposition_c_FB9F, .kde = &lxb_unicode_decomposition_k_FB9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA0[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA0[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA0[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBA0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA0 = {.cp = 0xFBA0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA0, .cde = &lxb_unicode_decomposition_c_FBA0, .kde = &lxb_unicode_decomposition_k_FBA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA1[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA1[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA1[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBA1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA1 = {.cp = 0xFBA1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA1, .cde = &lxb_unicode_decomposition_c_FBA1, .kde = &lxb_unicode_decomposition_k_FBA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA2[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA2[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA2[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBA2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA2 = {.cp = 0xFBA2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA2, .cde = &lxb_unicode_decomposition_c_FBA2, .kde = &lxb_unicode_decomposition_k_FBA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA3[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA3[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA3[1] = {0x06BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBA3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA3 = {.cp = 0xFBA3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA3, .cde = &lxb_unicode_decomposition_c_FBA3, .kde = &lxb_unicode_decomposition_k_FBA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA4[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBA4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA4[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBA4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA4[1] = {0x06C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBA4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA4 = {.cp = 0xFBA4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA4, .cde = &lxb_unicode_decomposition_c_FBA4, .kde = &lxb_unicode_decomposition_k_FBA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA5[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBA5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA5[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBA5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA5[1] = {0x06C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBA5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA5 = {.cp = 0xFBA5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA5, .cde = &lxb_unicode_decomposition_c_FBA5, .kde = &lxb_unicode_decomposition_k_FBA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA6[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA6[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA6[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBA6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA6 = {.cp = 0xFBA6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA6, .cde = &lxb_unicode_decomposition_c_FBA6, .kde = &lxb_unicode_decomposition_k_FBA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA7[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA7[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA7[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBA7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA7 = {.cp = 0xFBA7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA7, .cde = &lxb_unicode_decomposition_c_FBA7, .kde = &lxb_unicode_decomposition_k_FBA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA8[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA8[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA8[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBA8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA8 = {.cp = 0xFBA8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA8, .cde = &lxb_unicode_decomposition_c_FBA8, .kde = &lxb_unicode_decomposition_k_FBA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBA9[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBA9[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBA9[1] = {0x06C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBA9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBA9 = {.cp = 0xFBA9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBA9, .cde = &lxb_unicode_decomposition_c_FBA9, .kde = &lxb_unicode_decomposition_k_FBA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBAA[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBAA[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBAA[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBAA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBAA = {.cp = 0xFBAA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBAA, .cde = &lxb_unicode_decomposition_c_FBAA, .kde = &lxb_unicode_decomposition_k_FBAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBAB[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBAB[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBAB[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBAB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBAB = {.cp = 0xFBAB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBAB, .cde = &lxb_unicode_decomposition_c_FBAB, .kde = &lxb_unicode_decomposition_k_FBAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBAC[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBAC[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBAC[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBAC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBAC = {.cp = 0xFBAC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBAC, .cde = &lxb_unicode_decomposition_c_FBAC, .kde = &lxb_unicode_decomposition_k_FBAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBAD[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBAD[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBAD[1] = {0x06BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBAD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBAD = {.cp = 0xFBAD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBAD, .cde = &lxb_unicode_decomposition_c_FBAD, .kde = &lxb_unicode_decomposition_k_FBAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBAE[1] = {0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBAE[1] = {0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBAE[1] = {0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBAE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBAE = {.cp = 0xFBAE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBAE, .cde = &lxb_unicode_decomposition_c_FBAE, .kde = &lxb_unicode_decomposition_k_FBAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBAF[1] = {0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBAF[1] = {0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBAF[1] = {0x06D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBAF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBAF = {.cp = 0xFBAF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBAF, .cde = &lxb_unicode_decomposition_c_FBAF, .kde = &lxb_unicode_decomposition_k_FBAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBB0[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBB0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBB0[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBB0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBB0[1] = {0x06D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBB0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBB0 = {.cp = 0xFBB0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBB0, .cde = &lxb_unicode_decomposition_c_FBB0, .kde = &lxb_unicode_decomposition_k_FBB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBB1[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBB1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBB1[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBB1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBB1[1] = {0x06D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBB1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBB1 = {.cp = 0xFBB1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBB1, .cde = &lxb_unicode_decomposition_c_FBB1, .kde = &lxb_unicode_decomposition_k_FBB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD3[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD3[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD3[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBD3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD3 = {.cp = 0xFBD3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD3, .cde = &lxb_unicode_decomposition_c_FBD3, .kde = &lxb_unicode_decomposition_k_FBD3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD4[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD4[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD4[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBD4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD4 = {.cp = 0xFBD4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD4, .cde = &lxb_unicode_decomposition_c_FBD4, .kde = &lxb_unicode_decomposition_k_FBD4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD5[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD5[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD5[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBD5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD5 = {.cp = 0xFBD5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD5, .cde = &lxb_unicode_decomposition_c_FBD5, .kde = &lxb_unicode_decomposition_k_FBD5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD6[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBD6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD6[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBD6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD6[1] = {0x06AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBD6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD6 = {.cp = 0xFBD6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD6, .cde = &lxb_unicode_decomposition_c_FBD6, .kde = &lxb_unicode_decomposition_k_FBD6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD7[1] = {0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBD7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD7[1] = {0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBD7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD7[1] = {0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBD7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD7 = {.cp = 0xFBD7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD7, .cde = &lxb_unicode_decomposition_c_FBD7, .kde = &lxb_unicode_decomposition_k_FBD7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD8[1] = {0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBD8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD8[1] = {0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBD8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD8[1] = {0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBD8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD8 = {.cp = 0xFBD8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD8, .cde = &lxb_unicode_decomposition_c_FBD8, .kde = &lxb_unicode_decomposition_k_FBD8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBD9[1] = {0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBD9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBD9[1] = {0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBD9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBD9[1] = {0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBD9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBD9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBD9 = {.cp = 0xFBD9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBD9, .cde = &lxb_unicode_decomposition_c_FBD9, .kde = &lxb_unicode_decomposition_k_FBD9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBDA[1] = {0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBDA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBDA[1] = {0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBDA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBDA[1] = {0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBDA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBDA = {.cp = 0xFBDA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBDA, .cde = &lxb_unicode_decomposition_c_FBDA, .kde = &lxb_unicode_decomposition_k_FBDA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBDB[1] = {0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBDB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBDB[1] = {0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBDB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBDB[1] = {0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBDB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBDB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBDB = {.cp = 0xFBDB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBDB, .cde = &lxb_unicode_decomposition_c_FBDB, .kde = &lxb_unicode_decomposition_k_FBDB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBDC[1] = {0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBDC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBDC[1] = {0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBDC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBDC[1] = {0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBDC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBDC = {.cp = 0xFBDC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBDC, .cde = &lxb_unicode_decomposition_c_FBDC, .kde = &lxb_unicode_decomposition_k_FBDC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBDD[1] = {0x0677};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBDD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBDD[2] = {0x06C7, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBDD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBDD[1] = {0x0677};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBDD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBDD = {.cp = 0xFBDD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBDD, .cde = &lxb_unicode_decomposition_c_FBDD, .kde = &lxb_unicode_decomposition_k_FBDD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBDE[1] = {0x06CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBDE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBDE[1] = {0x06CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBDE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBDE[1] = {0x06CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBDE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBDE = {.cp = 0xFBDE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBDE, .cde = &lxb_unicode_decomposition_c_FBDE, .kde = &lxb_unicode_decomposition_k_FBDE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBDF[1] = {0x06CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBDF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBDF[1] = {0x06CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBDF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBDF[1] = {0x06CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBDF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBDF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBDF = {.cp = 0xFBDF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBDF, .cde = &lxb_unicode_decomposition_c_FBDF, .kde = &lxb_unicode_decomposition_k_FBDF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE0[1] = {0x06C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBE0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE0[1] = {0x06C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBE0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE0[1] = {0x06C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBE0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE0 = {.cp = 0xFBE0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE0, .cde = &lxb_unicode_decomposition_c_FBE0, .kde = &lxb_unicode_decomposition_k_FBE0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE1[1] = {0x06C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBE1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE1[1] = {0x06C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBE1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE1[1] = {0x06C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBE1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE1 = {.cp = 0xFBE1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE1, .cde = &lxb_unicode_decomposition_c_FBE1, .kde = &lxb_unicode_decomposition_k_FBE1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE2[1] = {0x06C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBE2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE2[1] = {0x06C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBE2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE2[1] = {0x06C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBE2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE2 = {.cp = 0xFBE2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE2, .cde = &lxb_unicode_decomposition_c_FBE2, .kde = &lxb_unicode_decomposition_k_FBE2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE3[1] = {0x06C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBE3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE3[1] = {0x06C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBE3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE3[1] = {0x06C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBE3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE3 = {.cp = 0xFBE3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE3, .cde = &lxb_unicode_decomposition_c_FBE3, .kde = &lxb_unicode_decomposition_k_FBE3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE4[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBE4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE4[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBE4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE4[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBE4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE4 = {.cp = 0xFBE4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE4, .cde = &lxb_unicode_decomposition_c_FBE4, .kde = &lxb_unicode_decomposition_k_FBE4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE5[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBE5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE5[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBE5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE5[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBE5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE5 = {.cp = 0xFBE5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE5, .cde = &lxb_unicode_decomposition_c_FBE5, .kde = &lxb_unicode_decomposition_k_FBE5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE6[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBE6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE6[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBE6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE6[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBE6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE6 = {.cp = 0xFBE6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE6, .cde = &lxb_unicode_decomposition_c_FBE6, .kde = &lxb_unicode_decomposition_k_FBE6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE7[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBE7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE7[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBE7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE7[1] = {0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBE7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE7 = {.cp = 0xFBE7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE7, .cde = &lxb_unicode_decomposition_c_FBE7, .kde = &lxb_unicode_decomposition_k_FBE7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE8[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBE8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE8[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBE8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE8[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBE8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE8 = {.cp = 0xFBE8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE8, .cde = &lxb_unicode_decomposition_c_FBE8, .kde = &lxb_unicode_decomposition_k_FBE8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBE9[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBE9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBE9[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBE9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBE9[1] = {0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBE9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBE9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBE9 = {.cp = 0xFBE9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBE9, .cde = &lxb_unicode_decomposition_c_FBE9, .kde = &lxb_unicode_decomposition_k_FBE9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBEA[3] = {0x064A, 0x0654, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBEA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBEA[3] = {0x064A, 0x0654, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBEA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBEA[2] = {0x0626, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBEA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBEA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBEA = {.cp = 0xFBEA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBEA, .cde = &lxb_unicode_decomposition_c_FBEA, .kde = &lxb_unicode_decomposition_k_FBEA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBEB[3] = {0x064A, 0x0654, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBEB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBEB[3] = {0x064A, 0x0654, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBEB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBEB[2] = {0x0626, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBEB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBEB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBEB = {.cp = 0xFBEB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBEB, .cde = &lxb_unicode_decomposition_c_FBEB, .kde = &lxb_unicode_decomposition_k_FBEB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBEC[3] = {0x064A, 0x0654, 0x06D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBEC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBEC[3] = {0x064A, 0x0654, 0x06D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBEC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBEC[2] = {0x0626, 0x06D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBEC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBEC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBEC = {.cp = 0xFBEC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBEC, .cde = &lxb_unicode_decomposition_c_FBEC, .kde = &lxb_unicode_decomposition_k_FBEC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBED[3] = {0x064A, 0x0654, 0x06D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBED[3] = {0x064A, 0x0654, 0x06D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBED[2] = {0x0626, 0x06D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBED, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBED = {.cp = 0xFBED, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBED, .cde = &lxb_unicode_decomposition_c_FBED, .kde = &lxb_unicode_decomposition_k_FBED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBEE[3] = {0x064A, 0x0654, 0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBEE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBEE[3] = {0x064A, 0x0654, 0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBEE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBEE[2] = {0x0626, 0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBEE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBEE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBEE = {.cp = 0xFBEE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBEE, .cde = &lxb_unicode_decomposition_c_FBEE, .kde = &lxb_unicode_decomposition_k_FBEE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBEF[3] = {0x064A, 0x0654, 0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBEF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBEF[3] = {0x064A, 0x0654, 0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBEF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBEF[2] = {0x0626, 0x0648};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBEF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBEF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBEF = {.cp = 0xFBEF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBEF, .cde = &lxb_unicode_decomposition_c_FBEF, .kde = &lxb_unicode_decomposition_k_FBEF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF0[3] = {0x064A, 0x0654, 0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBF0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF0[3] = {0x064A, 0x0654, 0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBF0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF0[2] = {0x0626, 0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBF0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF0 = {.cp = 0xFBF0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF0, .cde = &lxb_unicode_decomposition_c_FBF0, .kde = &lxb_unicode_decomposition_k_FBF0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF1[3] = {0x064A, 0x0654, 0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBF1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF1[3] = {0x064A, 0x0654, 0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBF1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF1[2] = {0x0626, 0x06C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBF1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF1 = {.cp = 0xFBF1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF1, .cde = &lxb_unicode_decomposition_c_FBF1, .kde = &lxb_unicode_decomposition_k_FBF1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF2[3] = {0x064A, 0x0654, 0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBF2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF2[3] = {0x064A, 0x0654, 0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBF2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF2[2] = {0x0626, 0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBF2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF2 = {.cp = 0xFBF2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF2, .cde = &lxb_unicode_decomposition_c_FBF2, .kde = &lxb_unicode_decomposition_k_FBF2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF3[3] = {0x064A, 0x0654, 0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBF3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF3[3] = {0x064A, 0x0654, 0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBF3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF3[2] = {0x0626, 0x06C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBF3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF3 = {.cp = 0xFBF3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF3, .cde = &lxb_unicode_decomposition_c_FBF3, .kde = &lxb_unicode_decomposition_k_FBF3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF4[3] = {0x064A, 0x0654, 0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBF4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF4[3] = {0x064A, 0x0654, 0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBF4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF4[2] = {0x0626, 0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBF4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF4 = {.cp = 0xFBF4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF4, .cde = &lxb_unicode_decomposition_c_FBF4, .kde = &lxb_unicode_decomposition_k_FBF4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF5[3] = {0x064A, 0x0654, 0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBF5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF5[3] = {0x064A, 0x0654, 0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBF5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF5[2] = {0x0626, 0x06C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBF5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF5 = {.cp = 0xFBF5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF5, .cde = &lxb_unicode_decomposition_c_FBF5, .kde = &lxb_unicode_decomposition_k_FBF5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF6[3] = {0x064A, 0x0654, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBF6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF6[3] = {0x064A, 0x0654, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBF6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF6[2] = {0x0626, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBF6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF6 = {.cp = 0xFBF6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF6, .cde = &lxb_unicode_decomposition_c_FBF6, .kde = &lxb_unicode_decomposition_k_FBF6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF7[3] = {0x064A, 0x0654, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBF7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF7[3] = {0x064A, 0x0654, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBF7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF7[2] = {0x0626, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBF7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF7 = {.cp = 0xFBF7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF7, .cde = &lxb_unicode_decomposition_c_FBF7, .kde = &lxb_unicode_decomposition_k_FBF7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF8[3] = {0x064A, 0x0654, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBF8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF8[3] = {0x064A, 0x0654, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBF8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF8[2] = {0x0626, 0x06D0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBF8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF8 = {.cp = 0xFBF8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF8, .cde = &lxb_unicode_decomposition_c_FBF8, .kde = &lxb_unicode_decomposition_k_FBF8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBF9[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBF9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBF9[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBF9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBF9[2] = {0x0626, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBF9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBF9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBF9 = {.cp = 0xFBF9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBF9, .cde = &lxb_unicode_decomposition_c_FBF9, .kde = &lxb_unicode_decomposition_k_FBF9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBFA[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBFA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBFA[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBFA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBFA[2] = {0x0626, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBFA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBFA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBFA = {.cp = 0xFBFA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBFA, .cde = &lxb_unicode_decomposition_c_FBFA, .kde = &lxb_unicode_decomposition_k_FBFA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBFB[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBFB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBFB[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBFB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBFB[2] = {0x0626, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBFB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBFB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FBFB = {.cp = 0xFBFB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBFB, .cde = &lxb_unicode_decomposition_c_FBFB, .kde = &lxb_unicode_decomposition_k_FBFB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBFC[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FBFC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBFC[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FBFC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBFC[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBFC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FBFC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBFC = {.cp = 0xFBFC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBFC, .cde = &lxb_unicode_decomposition_c_FBFC, .kde = &lxb_unicode_decomposition_k_FBFC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBFD[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBFD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FBFD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBFD[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBFD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FBFD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBFD[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBFD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FBFD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBFD = {.cp = 0xFBFD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBFD, .cde = &lxb_unicode_decomposition_c_FBFD, .kde = &lxb_unicode_decomposition_k_FBFD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBFE[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBFE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_c_FBFE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBFE[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBFE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp_k_FBFE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBFE[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBFE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_INITIAL, .mapping = lxb_unicode_decomposition_cp__FBFE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBFE = {.cp = 0xFBFE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBFE, .cde = &lxb_unicode_decomposition_c_FBFE, .kde = &lxb_unicode_decomposition_k_FBFE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FBFF[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FBFF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_c_FBFF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FBFF[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FBFF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp_k_FBFF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FBFF[1] = {0x06CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FBFF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_MEDIAL, .mapping = lxb_unicode_decomposition_cp__FBFF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_FBFF = {.cp = 0xFBFF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FBFF, .cde = &lxb_unicode_decomposition_c_FBFF, .kde = &lxb_unicode_decomposition_k_FBFF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC00[3] = {0x064A, 0x0654, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC00, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC00[3] = {0x064A, 0x0654, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC00, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC00[2] = {0x0626, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC00, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC00 = {.cp = 0xFC00, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC00, .cde = &lxb_unicode_decomposition_c_FC00, .kde = &lxb_unicode_decomposition_k_FC00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC01[3] = {0x064A, 0x0654, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC01, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC01[3] = {0x064A, 0x0654, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC01, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC01[2] = {0x0626, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC01, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC01 = {.cp = 0xFC01, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC01, .cde = &lxb_unicode_decomposition_c_FC01, .kde = &lxb_unicode_decomposition_k_FC01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC02[3] = {0x064A, 0x0654, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC02, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC02[3] = {0x064A, 0x0654, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC02, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC02[2] = {0x0626, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC02, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC02 = {.cp = 0xFC02, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC02, .cde = &lxb_unicode_decomposition_c_FC02, .kde = &lxb_unicode_decomposition_k_FC02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC03[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC03, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC03[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC03, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC03[2] = {0x0626, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC03, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC03 = {.cp = 0xFC03, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC03, .cde = &lxb_unicode_decomposition_c_FC03, .kde = &lxb_unicode_decomposition_k_FC03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC04[3] = {0x064A, 0x0654, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC04, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC04[3] = {0x064A, 0x0654, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC04, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC04[2] = {0x0626, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC04, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC04 = {.cp = 0xFC04, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC04, .cde = &lxb_unicode_decomposition_c_FC04, .kde = &lxb_unicode_decomposition_k_FC04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC05[2] = {0x0628, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC05, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC05[2] = {0x0628, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC05, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC05[2] = {0x0628, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC05, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC05 = {.cp = 0xFC05, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC05, .cde = &lxb_unicode_decomposition_c_FC05, .kde = &lxb_unicode_decomposition_k_FC05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC06[2] = {0x0628, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC06[2] = {0x0628, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC06, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC06[2] = {0x0628, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC06, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC06 = {.cp = 0xFC06, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC06, .cde = &lxb_unicode_decomposition_c_FC06, .kde = &lxb_unicode_decomposition_k_FC06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC07[2] = {0x0628, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC07, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC07[2] = {0x0628, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC07, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC07[2] = {0x0628, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC07, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC07 = {.cp = 0xFC07, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC07, .cde = &lxb_unicode_decomposition_c_FC07, .kde = &lxb_unicode_decomposition_k_FC07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC08[2] = {0x0628, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC08, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC08[2] = {0x0628, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC08, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC08[2] = {0x0628, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC08, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC08 = {.cp = 0xFC08, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC08, .cde = &lxb_unicode_decomposition_c_FC08, .kde = &lxb_unicode_decomposition_k_FC08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC09[2] = {0x0628, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC09, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC09[2] = {0x0628, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC09, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC09[2] = {0x0628, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC09, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC09 = {.cp = 0xFC09, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC09, .cde = &lxb_unicode_decomposition_c_FC09, .kde = &lxb_unicode_decomposition_k_FC09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC0A[2] = {0x0628, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC0A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC0A[2] = {0x0628, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC0A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC0A[2] = {0x0628, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC0A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC0A = {.cp = 0xFC0A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC0A, .cde = &lxb_unicode_decomposition_c_FC0A, .kde = &lxb_unicode_decomposition_k_FC0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC0B[2] = {0x062A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC0B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC0B[2] = {0x062A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC0B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC0B[2] = {0x062A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC0B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC0B = {.cp = 0xFC0B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC0B, .cde = &lxb_unicode_decomposition_c_FC0B, .kde = &lxb_unicode_decomposition_k_FC0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC0C[2] = {0x062A, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC0C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC0C[2] = {0x062A, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC0C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC0C[2] = {0x062A, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC0C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC0C = {.cp = 0xFC0C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC0C, .cde = &lxb_unicode_decomposition_c_FC0C, .kde = &lxb_unicode_decomposition_k_FC0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC0D[2] = {0x062A, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC0D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC0D[2] = {0x062A, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC0D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC0D[2] = {0x062A, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC0D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC0D = {.cp = 0xFC0D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC0D, .cde = &lxb_unicode_decomposition_c_FC0D, .kde = &lxb_unicode_decomposition_k_FC0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC0E[2] = {0x062A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC0E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC0E[2] = {0x062A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC0E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC0E[2] = {0x062A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC0E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC0E = {.cp = 0xFC0E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC0E, .cde = &lxb_unicode_decomposition_c_FC0E, .kde = &lxb_unicode_decomposition_k_FC0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC0F[2] = {0x062A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC0F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC0F[2] = {0x062A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC0F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC0F[2] = {0x062A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC0F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC0F = {.cp = 0xFC0F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC0F, .cde = &lxb_unicode_decomposition_c_FC0F, .kde = &lxb_unicode_decomposition_k_FC0F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC10[2] = {0x062A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC10, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC10[2] = {0x062A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC10, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC10[2] = {0x062A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC10, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC10 = {.cp = 0xFC10, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC10, .cde = &lxb_unicode_decomposition_c_FC10, .kde = &lxb_unicode_decomposition_k_FC10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC11[2] = {0x062B, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC11, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC11[2] = {0x062B, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC11, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC11[2] = {0x062B, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC11, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC11 = {.cp = 0xFC11, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC11, .cde = &lxb_unicode_decomposition_c_FC11, .kde = &lxb_unicode_decomposition_k_FC11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC12[2] = {0x062B, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC12, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC12[2] = {0x062B, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC12, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC12[2] = {0x062B, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC12, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC12 = {.cp = 0xFC12, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC12, .cde = &lxb_unicode_decomposition_c_FC12, .kde = &lxb_unicode_decomposition_k_FC12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC13[2] = {0x062B, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC13, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC13[2] = {0x062B, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC13, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC13[2] = {0x062B, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC13, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC13 = {.cp = 0xFC13, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC13, .cde = &lxb_unicode_decomposition_c_FC13, .kde = &lxb_unicode_decomposition_k_FC13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC14[2] = {0x062B, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC14, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC14[2] = {0x062B, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC14, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC14[2] = {0x062B, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC14, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC14 = {.cp = 0xFC14, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC14, .cde = &lxb_unicode_decomposition_c_FC14, .kde = &lxb_unicode_decomposition_k_FC14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC15[2] = {0x062C, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC15, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC15[2] = {0x062C, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC15, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC15[2] = {0x062C, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC15, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC15 = {.cp = 0xFC15, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC15, .cde = &lxb_unicode_decomposition_c_FC15, .kde = &lxb_unicode_decomposition_k_FC15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC16[2] = {0x062C, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC16, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC16[2] = {0x062C, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC16, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC16[2] = {0x062C, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC16, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC16 = {.cp = 0xFC16, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC16, .cde = &lxb_unicode_decomposition_c_FC16, .kde = &lxb_unicode_decomposition_k_FC16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC17[2] = {0x062D, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC17, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC17[2] = {0x062D, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC17, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC17[2] = {0x062D, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC17, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC17 = {.cp = 0xFC17, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC17, .cde = &lxb_unicode_decomposition_c_FC17, .kde = &lxb_unicode_decomposition_k_FC17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC18[2] = {0x062D, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC18, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC18[2] = {0x062D, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC18, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC18[2] = {0x062D, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC18, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC18 = {.cp = 0xFC18, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC18, .cde = &lxb_unicode_decomposition_c_FC18, .kde = &lxb_unicode_decomposition_k_FC18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC19[2] = {0x062E, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC19, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC19[2] = {0x062E, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC19, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC19[2] = {0x062E, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC19, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC19 = {.cp = 0xFC19, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC19, .cde = &lxb_unicode_decomposition_c_FC19, .kde = &lxb_unicode_decomposition_k_FC19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC1A[2] = {0x062E, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC1A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC1A[2] = {0x062E, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC1A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC1A[2] = {0x062E, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC1A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC1A = {.cp = 0xFC1A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC1A, .cde = &lxb_unicode_decomposition_c_FC1A, .kde = &lxb_unicode_decomposition_k_FC1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC1B[2] = {0x062E, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC1B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC1B[2] = {0x062E, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC1B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC1B[2] = {0x062E, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC1B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC1B = {.cp = 0xFC1B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC1B, .cde = &lxb_unicode_decomposition_c_FC1B, .kde = &lxb_unicode_decomposition_k_FC1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC1C[2] = {0x0633, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC1C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC1C[2] = {0x0633, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC1C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC1C[2] = {0x0633, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC1C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC1C = {.cp = 0xFC1C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC1C, .cde = &lxb_unicode_decomposition_c_FC1C, .kde = &lxb_unicode_decomposition_k_FC1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC1D[2] = {0x0633, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC1D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC1D[2] = {0x0633, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC1D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC1D[2] = {0x0633, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC1D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC1D = {.cp = 0xFC1D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC1D, .cde = &lxb_unicode_decomposition_c_FC1D, .kde = &lxb_unicode_decomposition_k_FC1D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC1E[2] = {0x0633, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC1E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC1E[2] = {0x0633, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC1E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC1E[2] = {0x0633, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC1E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC1E = {.cp = 0xFC1E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC1E, .cde = &lxb_unicode_decomposition_c_FC1E, .kde = &lxb_unicode_decomposition_k_FC1E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC1F[2] = {0x0633, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC1F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC1F[2] = {0x0633, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC1F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC1F[2] = {0x0633, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC1F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC1F = {.cp = 0xFC1F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC1F, .cde = &lxb_unicode_decomposition_c_FC1F, .kde = &lxb_unicode_decomposition_k_FC1F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC20[2] = {0x0635, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC20, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC20[2] = {0x0635, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC20, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC20[2] = {0x0635, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC20, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC20 = {.cp = 0xFC20, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC20, .cde = &lxb_unicode_decomposition_c_FC20, .kde = &lxb_unicode_decomposition_k_FC20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC21[2] = {0x0635, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC21, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC21[2] = {0x0635, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC21, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC21[2] = {0x0635, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC21, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC21 = {.cp = 0xFC21, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC21, .cde = &lxb_unicode_decomposition_c_FC21, .kde = &lxb_unicode_decomposition_k_FC21};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC22[2] = {0x0636, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC22, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC22[2] = {0x0636, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC22, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC22[2] = {0x0636, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC22, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC22 = {.cp = 0xFC22, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC22, .cde = &lxb_unicode_decomposition_c_FC22, .kde = &lxb_unicode_decomposition_k_FC22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC23[2] = {0x0636, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC23, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC23[2] = {0x0636, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC23, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC23[2] = {0x0636, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC23, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC23 = {.cp = 0xFC23, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC23, .cde = &lxb_unicode_decomposition_c_FC23, .kde = &lxb_unicode_decomposition_k_FC23};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC24[2] = {0x0636, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC24, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC24[2] = {0x0636, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC24, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC24[2] = {0x0636, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC24, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC24 = {.cp = 0xFC24, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC24, .cde = &lxb_unicode_decomposition_c_FC24, .kde = &lxb_unicode_decomposition_k_FC24};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC25[2] = {0x0636, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC25, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC25[2] = {0x0636, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC25, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC25[2] = {0x0636, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC25, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC25 = {.cp = 0xFC25, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC25, .cde = &lxb_unicode_decomposition_c_FC25, .kde = &lxb_unicode_decomposition_k_FC25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC26[2] = {0x0637, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC26, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC26[2] = {0x0637, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC26, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC26[2] = {0x0637, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC26, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC26 = {.cp = 0xFC26, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC26, .cde = &lxb_unicode_decomposition_c_FC26, .kde = &lxb_unicode_decomposition_k_FC26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC27[2] = {0x0637, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC27, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC27[2] = {0x0637, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC27, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC27[2] = {0x0637, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC27, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC27 = {.cp = 0xFC27, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC27, .cde = &lxb_unicode_decomposition_c_FC27, .kde = &lxb_unicode_decomposition_k_FC27};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC28[2] = {0x0638, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC28, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC28[2] = {0x0638, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC28, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC28[2] = {0x0638, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC28, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC28 = {.cp = 0xFC28, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC28, .cde = &lxb_unicode_decomposition_c_FC28, .kde = &lxb_unicode_decomposition_k_FC28};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC29[2] = {0x0639, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC29, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC29[2] = {0x0639, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC29, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC29[2] = {0x0639, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC29, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC29 = {.cp = 0xFC29, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC29, .cde = &lxb_unicode_decomposition_c_FC29, .kde = &lxb_unicode_decomposition_k_FC29};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC2A[2] = {0x0639, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC2A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC2A[2] = {0x0639, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC2A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC2A[2] = {0x0639, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC2A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC2A = {.cp = 0xFC2A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC2A, .cde = &lxb_unicode_decomposition_c_FC2A, .kde = &lxb_unicode_decomposition_k_FC2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC2B[2] = {0x063A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC2B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC2B[2] = {0x063A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC2B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC2B[2] = {0x063A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC2B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC2B = {.cp = 0xFC2B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC2B, .cde = &lxb_unicode_decomposition_c_FC2B, .kde = &lxb_unicode_decomposition_k_FC2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC2C[2] = {0x063A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC2C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC2C[2] = {0x063A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC2C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC2C[2] = {0x063A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC2C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC2C = {.cp = 0xFC2C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC2C, .cde = &lxb_unicode_decomposition_c_FC2C, .kde = &lxb_unicode_decomposition_k_FC2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC2D[2] = {0x0641, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC2D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC2D[2] = {0x0641, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC2D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC2D[2] = {0x0641, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC2D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC2D = {.cp = 0xFC2D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC2D, .cde = &lxb_unicode_decomposition_c_FC2D, .kde = &lxb_unicode_decomposition_k_FC2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC2E[2] = {0x0641, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC2E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC2E[2] = {0x0641, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC2E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC2E[2] = {0x0641, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC2E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC2E = {.cp = 0xFC2E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC2E, .cde = &lxb_unicode_decomposition_c_FC2E, .kde = &lxb_unicode_decomposition_k_FC2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC2F[2] = {0x0641, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC2F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC2F[2] = {0x0641, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC2F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC2F[2] = {0x0641, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC2F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC2F = {.cp = 0xFC2F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC2F, .cde = &lxb_unicode_decomposition_c_FC2F, .kde = &lxb_unicode_decomposition_k_FC2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC30[2] = {0x0641, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC30[2] = {0x0641, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC30, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC30[2] = {0x0641, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC30, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC30 = {.cp = 0xFC30, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC30, .cde = &lxb_unicode_decomposition_c_FC30, .kde = &lxb_unicode_decomposition_k_FC30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC31[2] = {0x0641, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC31[2] = {0x0641, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC31, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC31[2] = {0x0641, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC31, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC31 = {.cp = 0xFC31, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC31, .cde = &lxb_unicode_decomposition_c_FC31, .kde = &lxb_unicode_decomposition_k_FC31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC32[2] = {0x0641, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC32, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC32[2] = {0x0641, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC32, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC32[2] = {0x0641, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC32, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC32 = {.cp = 0xFC32, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC32, .cde = &lxb_unicode_decomposition_c_FC32, .kde = &lxb_unicode_decomposition_k_FC32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC33[2] = {0x0642, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC33[2] = {0x0642, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC33[2] = {0x0642, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC33, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC33 = {.cp = 0xFC33, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC33, .cde = &lxb_unicode_decomposition_c_FC33, .kde = &lxb_unicode_decomposition_k_FC33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC34[2] = {0x0642, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC34, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC34[2] = {0x0642, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC34, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC34[2] = {0x0642, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC34, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC34 = {.cp = 0xFC34, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC34, .cde = &lxb_unicode_decomposition_c_FC34, .kde = &lxb_unicode_decomposition_k_FC34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC35[2] = {0x0642, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC35, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC35[2] = {0x0642, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC35, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC35[2] = {0x0642, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC35, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC35 = {.cp = 0xFC35, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC35, .cde = &lxb_unicode_decomposition_c_FC35, .kde = &lxb_unicode_decomposition_k_FC35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC36[2] = {0x0642, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC36[2] = {0x0642, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC36[2] = {0x0642, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC36, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC36 = {.cp = 0xFC36, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC36, .cde = &lxb_unicode_decomposition_c_FC36, .kde = &lxb_unicode_decomposition_k_FC36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC37[2] = {0x0643, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC37, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC37[2] = {0x0643, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC37, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC37[2] = {0x0643, 0x0627};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC37, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC37 = {.cp = 0xFC37, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC37, .cde = &lxb_unicode_decomposition_c_FC37, .kde = &lxb_unicode_decomposition_k_FC37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC38[2] = {0x0643, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC38, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC38[2] = {0x0643, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC38, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC38[2] = {0x0643, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC38, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC38 = {.cp = 0xFC38, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC38, .cde = &lxb_unicode_decomposition_c_FC38, .kde = &lxb_unicode_decomposition_k_FC38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC39[2] = {0x0643, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC39, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC39[2] = {0x0643, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC39, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC39[2] = {0x0643, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC39, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC39 = {.cp = 0xFC39, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC39, .cde = &lxb_unicode_decomposition_c_FC39, .kde = &lxb_unicode_decomposition_k_FC39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC3A[2] = {0x0643, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC3A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC3A[2] = {0x0643, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC3A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC3A[2] = {0x0643, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC3A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC3A = {.cp = 0xFC3A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC3A, .cde = &lxb_unicode_decomposition_c_FC3A, .kde = &lxb_unicode_decomposition_k_FC3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC3B[2] = {0x0643, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC3B[2] = {0x0643, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC3B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC3B[2] = {0x0643, 0x0644};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC3B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC3B = {.cp = 0xFC3B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC3B, .cde = &lxb_unicode_decomposition_c_FC3B, .kde = &lxb_unicode_decomposition_k_FC3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC3C[2] = {0x0643, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC3C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC3C[2] = {0x0643, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC3C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC3C[2] = {0x0643, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC3C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC3C = {.cp = 0xFC3C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC3C, .cde = &lxb_unicode_decomposition_c_FC3C, .kde = &lxb_unicode_decomposition_k_FC3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC3D[2] = {0x0643, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC3D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC3D[2] = {0x0643, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC3D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC3D[2] = {0x0643, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC3D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC3D = {.cp = 0xFC3D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC3D, .cde = &lxb_unicode_decomposition_c_FC3D, .kde = &lxb_unicode_decomposition_k_FC3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC3E[2] = {0x0643, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC3E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC3E[2] = {0x0643, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC3E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC3E[2] = {0x0643, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC3E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC3E = {.cp = 0xFC3E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC3E, .cde = &lxb_unicode_decomposition_c_FC3E, .kde = &lxb_unicode_decomposition_k_FC3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC3F[2] = {0x0644, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC3F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC3F[2] = {0x0644, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC3F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC3F[2] = {0x0644, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC3F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC3F = {.cp = 0xFC3F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC3F, .cde = &lxb_unicode_decomposition_c_FC3F, .kde = &lxb_unicode_decomposition_k_FC3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC40[2] = {0x0644, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC40[2] = {0x0644, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC40, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC40[2] = {0x0644, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC40, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC40 = {.cp = 0xFC40, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC40, .cde = &lxb_unicode_decomposition_c_FC40, .kde = &lxb_unicode_decomposition_k_FC40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC41[2] = {0x0644, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC41[2] = {0x0644, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC41, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC41[2] = {0x0644, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC41, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC41 = {.cp = 0xFC41, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC41, .cde = &lxb_unicode_decomposition_c_FC41, .kde = &lxb_unicode_decomposition_k_FC41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC42[2] = {0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC42, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC42[2] = {0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC42, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC42[2] = {0x0644, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC42, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC42 = {.cp = 0xFC42, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC42, .cde = &lxb_unicode_decomposition_c_FC42, .kde = &lxb_unicode_decomposition_k_FC42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC43[2] = {0x0644, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC43[2] = {0x0644, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC43[2] = {0x0644, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC43, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC43 = {.cp = 0xFC43, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC43, .cde = &lxb_unicode_decomposition_c_FC43, .kde = &lxb_unicode_decomposition_k_FC43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC44[2] = {0x0644, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC44, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC44[2] = {0x0644, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC44, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC44[2] = {0x0644, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC44, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC44 = {.cp = 0xFC44, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC44, .cde = &lxb_unicode_decomposition_c_FC44, .kde = &lxb_unicode_decomposition_k_FC44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC45[2] = {0x0645, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC45, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC45[2] = {0x0645, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC45, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC45[2] = {0x0645, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC45, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC45 = {.cp = 0xFC45, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC45, .cde = &lxb_unicode_decomposition_c_FC45, .kde = &lxb_unicode_decomposition_k_FC45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC46[2] = {0x0645, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC46, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC46[2] = {0x0645, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC46, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC46[2] = {0x0645, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC46, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC46 = {.cp = 0xFC46, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC46, .cde = &lxb_unicode_decomposition_c_FC46, .kde = &lxb_unicode_decomposition_k_FC46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC47[2] = {0x0645, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC47, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC47[2] = {0x0645, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC47, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC47[2] = {0x0645, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC47, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC47 = {.cp = 0xFC47, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC47, .cde = &lxb_unicode_decomposition_c_FC47, .kde = &lxb_unicode_decomposition_k_FC47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC48[2] = {0x0645, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC48[2] = {0x0645, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC48[2] = {0x0645, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC48, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC48 = {.cp = 0xFC48, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC48, .cde = &lxb_unicode_decomposition_c_FC48, .kde = &lxb_unicode_decomposition_k_FC48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC49[2] = {0x0645, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC49[2] = {0x0645, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC49, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC49[2] = {0x0645, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC49, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC49 = {.cp = 0xFC49, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC49, .cde = &lxb_unicode_decomposition_c_FC49, .kde = &lxb_unicode_decomposition_k_FC49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC4A[2] = {0x0645, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC4A[2] = {0x0645, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC4A[2] = {0x0645, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC4A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC4A = {.cp = 0xFC4A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC4A, .cde = &lxb_unicode_decomposition_c_FC4A, .kde = &lxb_unicode_decomposition_k_FC4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC4B[2] = {0x0646, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC4B[2] = {0x0646, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC4B[2] = {0x0646, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC4B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC4B = {.cp = 0xFC4B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC4B, .cde = &lxb_unicode_decomposition_c_FC4B, .kde = &lxb_unicode_decomposition_k_FC4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC4C[2] = {0x0646, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC4C[2] = {0x0646, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC4C[2] = {0x0646, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC4C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC4C = {.cp = 0xFC4C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC4C, .cde = &lxb_unicode_decomposition_c_FC4C, .kde = &lxb_unicode_decomposition_k_FC4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC4D[2] = {0x0646, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC4D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC4D[2] = {0x0646, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC4D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC4D[2] = {0x0646, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC4D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC4D = {.cp = 0xFC4D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC4D, .cde = &lxb_unicode_decomposition_c_FC4D, .kde = &lxb_unicode_decomposition_k_FC4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC4E[2] = {0x0646, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC4E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC4E[2] = {0x0646, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC4E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC4E[2] = {0x0646, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC4E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC4E = {.cp = 0xFC4E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC4E, .cde = &lxb_unicode_decomposition_c_FC4E, .kde = &lxb_unicode_decomposition_k_FC4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC4F[2] = {0x0646, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC4F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC4F[2] = {0x0646, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC4F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC4F[2] = {0x0646, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC4F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC4F = {.cp = 0xFC4F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC4F, .cde = &lxb_unicode_decomposition_c_FC4F, .kde = &lxb_unicode_decomposition_k_FC4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC50[2] = {0x0646, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC50, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC50[2] = {0x0646, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC50, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC50[2] = {0x0646, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC50, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC50 = {.cp = 0xFC50, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC50, .cde = &lxb_unicode_decomposition_c_FC50, .kde = &lxb_unicode_decomposition_k_FC50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC51[2] = {0x0647, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC51, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC51[2] = {0x0647, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC51, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC51[2] = {0x0647, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC51, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC51 = {.cp = 0xFC51, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC51, .cde = &lxb_unicode_decomposition_c_FC51, .kde = &lxb_unicode_decomposition_k_FC51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC52[2] = {0x0647, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC52, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC52[2] = {0x0647, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC52, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC52[2] = {0x0647, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC52, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC52 = {.cp = 0xFC52, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC52, .cde = &lxb_unicode_decomposition_c_FC52, .kde = &lxb_unicode_decomposition_k_FC52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC53[2] = {0x0647, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC53, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC53[2] = {0x0647, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC53, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC53[2] = {0x0647, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC53, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC53 = {.cp = 0xFC53, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC53, .cde = &lxb_unicode_decomposition_c_FC53, .kde = &lxb_unicode_decomposition_k_FC53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC54[2] = {0x0647, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC54, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC54[2] = {0x0647, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC54, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC54[2] = {0x0647, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC54, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC54 = {.cp = 0xFC54, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC54, .cde = &lxb_unicode_decomposition_c_FC54, .kde = &lxb_unicode_decomposition_k_FC54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC55[2] = {0x064A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC55, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC55[2] = {0x064A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC55, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC55[2] = {0x064A, 0x062C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC55, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC55 = {.cp = 0xFC55, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC55, .cde = &lxb_unicode_decomposition_c_FC55, .kde = &lxb_unicode_decomposition_k_FC55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC56[2] = {0x064A, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC56, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC56[2] = {0x064A, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC56, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC56[2] = {0x064A, 0x062D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC56, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC56 = {.cp = 0xFC56, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC56, .cde = &lxb_unicode_decomposition_c_FC56, .kde = &lxb_unicode_decomposition_k_FC56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC57[2] = {0x064A, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC57, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC57[2] = {0x064A, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC57, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC57[2] = {0x064A, 0x062E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC57, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC57 = {.cp = 0xFC57, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC57, .cde = &lxb_unicode_decomposition_c_FC57, .kde = &lxb_unicode_decomposition_k_FC57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC58[2] = {0x064A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC58, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC58[2] = {0x064A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC58, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC58[2] = {0x064A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC58, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC58 = {.cp = 0xFC58, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC58, .cde = &lxb_unicode_decomposition_c_FC58, .kde = &lxb_unicode_decomposition_k_FC58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC59[2] = {0x064A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC59[2] = {0x064A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC59[2] = {0x064A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC59, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC59 = {.cp = 0xFC59, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC59, .cde = &lxb_unicode_decomposition_c_FC59, .kde = &lxb_unicode_decomposition_k_FC59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC5A[2] = {0x064A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC5A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC5A[2] = {0x064A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC5A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC5A[2] = {0x064A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC5A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC5A = {.cp = 0xFC5A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC5A, .cde = &lxb_unicode_decomposition_c_FC5A, .kde = &lxb_unicode_decomposition_k_FC5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC5B[2] = {0x0630, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC5B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC5B[2] = {0x0630, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC5B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC5B[2] = {0x0630, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC5B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC5B = {.cp = 0xFC5B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC5B, .cde = &lxb_unicode_decomposition_c_FC5B, .kde = &lxb_unicode_decomposition_k_FC5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC5C[2] = {0x0631, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC5C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC5C[2] = {0x0631, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC5C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC5C[2] = {0x0631, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC5C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC5C = {.cp = 0xFC5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC5C, .cde = &lxb_unicode_decomposition_c_FC5C, .kde = &lxb_unicode_decomposition_k_FC5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC5D[2] = {0x0649, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC5D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC5D[2] = {0x0649, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC5D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC5D[2] = {0x0649, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC5D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC5D = {.cp = 0xFC5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC5D, .cde = &lxb_unicode_decomposition_c_FC5D, .kde = &lxb_unicode_decomposition_k_FC5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC5E[3] = {0x0020, 0x064C, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC5E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC5E[3] = {0x0020, 0x064C, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC5E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC5E[3] = {0x0020, 0x064C, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC5E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FC5E = {.cp = 0xFC5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC5E, .cde = &lxb_unicode_decomposition_c_FC5E, .kde = &lxb_unicode_decomposition_k_FC5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC5F[3] = {0x0020, 0x064D, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC5F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC5F[3] = {0x0020, 0x064D, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC5F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC5F[3] = {0x0020, 0x064D, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC5F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FC5F = {.cp = 0xFC5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC5F, .cde = &lxb_unicode_decomposition_c_FC5F, .kde = &lxb_unicode_decomposition_k_FC5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC60[3] = {0x0020, 0x064E, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC60, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC60[3] = {0x0020, 0x064E, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC60, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC60[3] = {0x0020, 0x064E, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC60, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FC60 = {.cp = 0xFC60, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC60, .cde = &lxb_unicode_decomposition_c_FC60, .kde = &lxb_unicode_decomposition_k_FC60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC61[3] = {0x0020, 0x064F, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC61, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC61[3] = {0x0020, 0x064F, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC61, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC61[3] = {0x0020, 0x064F, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC61, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FC61 = {.cp = 0xFC61, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC61, .cde = &lxb_unicode_decomposition_c_FC61, .kde = &lxb_unicode_decomposition_k_FC61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC62[3] = {0x0020, 0x0650, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC62, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC62[3] = {0x0020, 0x0650, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC62, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC62[3] = {0x0020, 0x0650, 0x0651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC62, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FC62 = {.cp = 0xFC62, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC62, .cde = &lxb_unicode_decomposition_c_FC62, .kde = &lxb_unicode_decomposition_k_FC62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC63[3] = {0x0020, 0x0651, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_c_FC63, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC63[3] = {0x0020, 0x0651, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp_k_FC63, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC63[3] = {0x0020, 0x0651, 0x0670};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_ISOLATED, .mapping = lxb_unicode_decomposition_cp__FC63, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_FC63 = {.cp = 0xFC63, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC63, .cde = &lxb_unicode_decomposition_c_FC63, .kde = &lxb_unicode_decomposition_k_FC63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC64[3] = {0x064A, 0x0654, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC64, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC64[3] = {0x064A, 0x0654, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC64, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC64[2] = {0x0626, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC64, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC64 = {.cp = 0xFC64, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC64, .cde = &lxb_unicode_decomposition_c_FC64, .kde = &lxb_unicode_decomposition_k_FC64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC65[3] = {0x064A, 0x0654, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC65, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC65[3] = {0x064A, 0x0654, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC65, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC65[2] = {0x0626, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC65, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC65 = {.cp = 0xFC65, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC65, .cde = &lxb_unicode_decomposition_c_FC65, .kde = &lxb_unicode_decomposition_k_FC65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC66[3] = {0x064A, 0x0654, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC66, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC66[3] = {0x064A, 0x0654, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC66, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC66[2] = {0x0626, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC66, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC66 = {.cp = 0xFC66, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC66, .cde = &lxb_unicode_decomposition_c_FC66, .kde = &lxb_unicode_decomposition_k_FC66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC67[3] = {0x064A, 0x0654, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC67, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC67[3] = {0x064A, 0x0654, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC67, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC67[2] = {0x0626, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC67, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC67 = {.cp = 0xFC67, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC67, .cde = &lxb_unicode_decomposition_c_FC67, .kde = &lxb_unicode_decomposition_k_FC67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC68[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC68, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC68[3] = {0x064A, 0x0654, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC68, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC68[2] = {0x0626, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC68, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC68 = {.cp = 0xFC68, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC68, .cde = &lxb_unicode_decomposition_c_FC68, .kde = &lxb_unicode_decomposition_k_FC68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC69[3] = {0x064A, 0x0654, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC69, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC69[3] = {0x064A, 0x0654, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC69, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC69[2] = {0x0626, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC69, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC69 = {.cp = 0xFC69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC69, .cde = &lxb_unicode_decomposition_c_FC69, .kde = &lxb_unicode_decomposition_k_FC69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC6A[2] = {0x0628, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC6A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC6A[2] = {0x0628, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC6A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC6A[2] = {0x0628, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC6A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC6A = {.cp = 0xFC6A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC6A, .cde = &lxb_unicode_decomposition_c_FC6A, .kde = &lxb_unicode_decomposition_k_FC6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC6B[2] = {0x0628, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC6B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC6B[2] = {0x0628, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC6B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC6B[2] = {0x0628, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC6B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC6B = {.cp = 0xFC6B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC6B, .cde = &lxb_unicode_decomposition_c_FC6B, .kde = &lxb_unicode_decomposition_k_FC6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC6C[2] = {0x0628, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC6C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC6C[2] = {0x0628, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC6C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC6C[2] = {0x0628, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC6C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC6C = {.cp = 0xFC6C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC6C, .cde = &lxb_unicode_decomposition_c_FC6C, .kde = &lxb_unicode_decomposition_k_FC6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC6D[2] = {0x0628, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC6D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC6D[2] = {0x0628, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC6D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC6D[2] = {0x0628, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC6D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC6D = {.cp = 0xFC6D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC6D, .cde = &lxb_unicode_decomposition_c_FC6D, .kde = &lxb_unicode_decomposition_k_FC6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC6E[2] = {0x0628, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC6E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC6E[2] = {0x0628, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC6E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC6E[2] = {0x0628, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC6E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC6E = {.cp = 0xFC6E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC6E, .cde = &lxb_unicode_decomposition_c_FC6E, .kde = &lxb_unicode_decomposition_k_FC6E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC6F[2] = {0x0628, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC6F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC6F[2] = {0x0628, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC6F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC6F[2] = {0x0628, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC6F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC6F = {.cp = 0xFC6F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC6F, .cde = &lxb_unicode_decomposition_c_FC6F, .kde = &lxb_unicode_decomposition_k_FC6F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC70[2] = {0x062A, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC70[2] = {0x062A, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC70, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC70[2] = {0x062A, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC70, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC70 = {.cp = 0xFC70, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC70, .cde = &lxb_unicode_decomposition_c_FC70, .kde = &lxb_unicode_decomposition_k_FC70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC71[2] = {0x062A, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC71[2] = {0x062A, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC71, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC71[2] = {0x062A, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC71, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC71 = {.cp = 0xFC71, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC71, .cde = &lxb_unicode_decomposition_c_FC71, .kde = &lxb_unicode_decomposition_k_FC71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC72[2] = {0x062A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC72[2] = {0x062A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC72, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC72[2] = {0x062A, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC72, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC72 = {.cp = 0xFC72, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC72, .cde = &lxb_unicode_decomposition_c_FC72, .kde = &lxb_unicode_decomposition_k_FC72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC73[2] = {0x062A, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC73[2] = {0x062A, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC73[2] = {0x062A, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC73, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC73 = {.cp = 0xFC73, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC73, .cde = &lxb_unicode_decomposition_c_FC73, .kde = &lxb_unicode_decomposition_k_FC73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC74[2] = {0x062A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC74[2] = {0x062A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC74, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC74[2] = {0x062A, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC74, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC74 = {.cp = 0xFC74, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC74, .cde = &lxb_unicode_decomposition_c_FC74, .kde = &lxb_unicode_decomposition_k_FC74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC75[2] = {0x062A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC75[2] = {0x062A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC75[2] = {0x062A, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC75, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC75 = {.cp = 0xFC75, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC75, .cde = &lxb_unicode_decomposition_c_FC75, .kde = &lxb_unicode_decomposition_k_FC75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC76[2] = {0x062B, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC76[2] = {0x062B, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC76[2] = {0x062B, 0x0631};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC76, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC76 = {.cp = 0xFC76, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC76, .cde = &lxb_unicode_decomposition_c_FC76, .kde = &lxb_unicode_decomposition_k_FC76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC77[2] = {0x062B, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC77[2] = {0x062B, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC77, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC77[2] = {0x062B, 0x0632};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC77, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC77 = {.cp = 0xFC77, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC77, .cde = &lxb_unicode_decomposition_c_FC77, .kde = &lxb_unicode_decomposition_k_FC77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC78[2] = {0x062B, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC78[2] = {0x062B, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC78[2] = {0x062B, 0x0645};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC78, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC78 = {.cp = 0xFC78, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC78, .cde = &lxb_unicode_decomposition_c_FC78, .kde = &lxb_unicode_decomposition_k_FC78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC79[2] = {0x062B, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC79, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC79[2] = {0x062B, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC79, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC79[2] = {0x062B, 0x0646};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC79, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC79 = {.cp = 0xFC79, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC79, .cde = &lxb_unicode_decomposition_c_FC79, .kde = &lxb_unicode_decomposition_k_FC79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC7A[2] = {0x062B, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC7A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC7A[2] = {0x062B, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC7A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC7A[2] = {0x062B, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC7A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC7A = {.cp = 0xFC7A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC7A, .cde = &lxb_unicode_decomposition_c_FC7A, .kde = &lxb_unicode_decomposition_k_FC7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC7B[2] = {0x062B, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC7B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC7B[2] = {0x062B, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC7B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC7B[2] = {0x062B, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC7B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC7B = {.cp = 0xFC7B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC7B, .cde = &lxb_unicode_decomposition_c_FC7B, .kde = &lxb_unicode_decomposition_k_FC7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC7C[2] = {0x0641, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC7C[2] = {0x0641, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC7C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC7C[2] = {0x0641, 0x0649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__FC7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp__FC7C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_FC7C = {.cp = 0xFC7C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__FC7C, .cde = &lxb_unicode_decomposition_c_FC7C, .kde = &lxb_unicode_decomposition_k_FC7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_FC7D[2] = {0x0641, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_FC7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_c_FC7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_FC7D[2] = {0x0641, 0x064A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_FC7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FINAL, .mapping = lxb_unicode_decomposition_cp_k_FC7D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__FC7D[2] = {0x0641, 0x064A};
static const lxb_unicode_decompositi