/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.contracts;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalReturnsDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtHoldsInEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractConstantValues;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBooleanOperatorExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeContractDescriptionError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ContractsDslNames;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 O2 \u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00012\u00020\u0007:\u0001OB%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0014*\u00020\u0015H\u0002J*\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010!\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010$\u001a\u00020%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010'\u001a\u00020(2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010*\u001a\u00020+2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J0\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040-j\u0002`.2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0014\u00104\u001a\u000205*\u00020\u000b2\u0006\u00106\u001a\u000207H\u0002J*\u00108\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u00109\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010<\u001a\u00020=2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010>\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010?\u001a\u00020@2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010A\u001a\u0004\u0018\u00010B*\u00020CH\u0002J\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010E\u001a\u00020FH\u0002J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010E\u001a\u00020FH\u0002J\u001c\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020\u0018H\u0002J\u001c\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040Jj\u0002`K*\u00020CH\u0002J&\u0010L\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040-j\u0002`.*\u0004\u0018\u00010C2\u0006\u0010M\u001a\u00020NH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "", "Lorg/jetbrains/kotlin/fir/SessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "valueAndContextParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;Ljava/util/List;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "asElement", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeContractDescriptionError;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitBooleanOperatorExpression", "booleanOperatorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBooleanOperatorExpression;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitSmartCastExpression", "smartCastExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "toValueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtValueParameterReference;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "type", "index", "", "name", "", "isAccessorOf", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitThisReceiverExpression", "thisReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirThisReceiverExpression;", "visitLiteralExpression", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "parseInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "noReceiver", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "noArgument", "asContractElement", "asContractBooleanExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBooleanExpression;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBooleanExpression;", "asContractValueExpression", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nConeEffectExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEffectExtractor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,310:1\n59#2:311\n57#2:312\n57#2:313\n57#2:314\n57#2:315\n57#2:316\n57#2:317\n57#2:318\n57#2:319\n57#2:321\n1#3:320\n2792#4,3:322\n233#5:325\n*S KotlinDebug\n*F\n+ 1 ConeEffectExtractor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor\n*L\n65#1:311\n70#1:312\n88#1:313\n89#1:314\n101#1:315\n115#1:316\n124#1:317\n160#1:318\n164#1:319\n246#1:321\n251#1:322,3\n254#1:325\n*E\n"})
public final class ConeEffectExtractor
extends FirDefaultVisitor
implements SessionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirContractDescriptionOwner owner;
    @NotNull
    private final List<FirValueParameter> valueAndContextParameters;
    @NotNull
    private static final CallableId BOOLEAN_AND = ContractsDslNames.INSTANCE.id("kotlin", "Boolean", "and");
    @NotNull
    private static final CallableId BOOLEAN_OR = ContractsDslNames.INSTANCE.id("kotlin", "Boolean", "or");
    @NotNull
    private static final CallableId BOOLEAN_NOT = ContractsDslNames.INSTANCE.id("kotlin", "Boolean", "not");
    @NotNull
    private static final Name LAMBDA_ARGUMENT_NAME;
    @NotNull
    private static final Name OTHER_ARGUMENT_NAME;
    @NotNull
    private static final Name TARGET_ARGUMENT_NAME;

    public ConeEffectExtractor(@NotNull FirSession session, @NotNull FirContractDescriptionOwner owner, @NotNull List<? extends FirValueParameter> valueAndContextParameters) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(valueAndContextParameters, "valueAndContextParameters");
        this.session = session;
        this.owner = owner;
        this.valueAndContextParameters = valueAndContextParameters;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    private final KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> asElement(ConeContractDescriptionError $this$asElement) {
        return new KtErroneousContractElement<ConeKotlinType, ConeDiagnostic>($this$asElement);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitElement(@NotNull FirElement element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.asElement(new ConeContractDescriptionError.IllegalElement(element));
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data) {
        KtContractDescriptionElement ktContractDescriptionElement;
        Intrinsics.checkNotNullParameter(functionCall, "functionCall");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(functionCall);
        if (firCallableSymbol == null || (firCallableSymbol = firCallableSymbol.getCallableId()) == null) {
            return this.asElement(new ConeContractDescriptionError.UnresolvedCall(functionCall.getCalleeReference().getName()));
        }
        FirCallableSymbol<?> resolvedId = firCallableSymbol;
        FirCallableSymbol<?> firCallableSymbol2 = resolvedId;
        if (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getIMPLIES())) {
            FirExpression firExpression = functionCall.getExplicitReceiver();
            KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> ktContractDescriptionElement2 = firExpression != null ? this.asContractElement(firExpression) : null;
            KtEffectDeclaration ktEffectDeclaration = ktContractDescriptionElement2 instanceof KtEffectDeclaration ? (KtEffectDeclaration)ktContractDescriptionElement2 : null;
            if (ktEffectDeclaration == null) {
                ktEffectDeclaration = this.noReceiver((CallableId)((Object)resolvedId));
            }
            KtEffectDeclaration effect = ktEffectDeclaration;
            FirCall $this$argument$iv = functionCall;
            boolean $i$f$getArgument = false;
            KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> ktContractDescriptionElement3 = this.asContractElement(CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
            KtBooleanExpression ktBooleanExpression = ktContractDescriptionElement3 instanceof KtBooleanExpression ? (KtBooleanExpression)ktContractDescriptionElement3 : null;
            if (ktBooleanExpression == null) {
                ktBooleanExpression = this.noArgument((CallableId)((Object)resolvedId));
            }
            KtBooleanExpression condition = ktBooleanExpression;
            ktContractDescriptionElement = new KtConditionalEffectDeclaration(effect, condition);
        } else if (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getRETURNS())) {
            KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> value2;
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            FirExpression argument = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
            KtConstantReference value3 = argument == null ? ConeContractConstantValues.INSTANCE.getWILDCARD() : ((value2 = this.asContractElement(argument)) instanceof KtConstantReference ? (KtConstantReference)value2 : (KtConstantReference)new KtErroneousConstantReference(new ConeContractDescriptionError.NotAConstant(value2)));
            Intrinsics.checkNotNull(value3, "null cannot be cast to non-null type org.jetbrains.kotlin.contracts.description.KtConstantReference<org.jetbrains.kotlin.fir.types.ConeKotlinType, org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic>");
            ktContractDescriptionElement = new KtReturnsEffectDeclaration(value3);
        } else if (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL())) {
            ktContractDescriptionElement = new KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic>(ConeContractConstantValues.INSTANCE.getNOT_NULL());
        } else if (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getCALLS_IN_PLACE())) {
            KtCallsEffectDeclaration ktCallsEffectDeclaration;
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            KtValueParameterReference<ConeKotlinType, ConeDiagnostic> reference2 = this.asContractValueExpression(CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 0), LAMBDA_ARGUMENT_NAME);
            FirCall $this$arguments$iv2 = functionCall;
            boolean $i$f$getArguments2 = false;
            FirExpression argument = CollectionsKt.getOrNull($this$arguments$iv2.getArgumentList().getArguments(), 1);
            if (argument == null) {
                ktCallsEffectDeclaration = new KtCallsEffectDeclaration(reference2, EventOccurrencesRange.UNKNOWN);
            } else {
                EventOccurrencesRange kind;
                EventOccurrencesRange eventOccurrencesRange = kind = this.parseInvocationKind(argument);
                ktCallsEffectDeclaration = (eventOccurrencesRange == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventOccurrencesRange.ordinal()]) == -1 ? (KtCallsEffectDeclaration)new KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeContractDescriptionError.UnresolvedInvocationKind>(reference2, new ConeContractDescriptionError.UnresolvedInvocationKind(argument)) : new KtCallsEffectDeclaration(reference2, kind);
            }
            ktContractDescriptionElement = ktCallsEffectDeclaration;
        } else if (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getIMPLIES_BUILDER())) {
            KtEffectDeclaration ktEffectDeclaration;
            if (LanguageVersionUtilsKt.isEnabled(this, LanguageFeature.ConditionImpliesReturnsContracts)) {
                FirExpression firExpression = functionCall.getExplicitReceiver();
                KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> kind = firExpression != null ? this.asContractElement(firExpression) : null;
                KtBooleanExpression ktBooleanExpression = kind instanceof KtBooleanExpression ? (KtBooleanExpression)kind : null;
                if (ktBooleanExpression == null) {
                    ktBooleanExpression = this.noReceiver((CallableId)((Object)resolvedId));
                }
                KtBooleanExpression condition = ktBooleanExpression;
                FirCall $this$arguments$iv = functionCall;
                boolean $i$f$getArguments3 = false;
                FirExpression argument = CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 0);
                if (argument == null) {
                    ktEffectDeclaration = this.noArgument((CallableId)((Object)resolvedId));
                } else {
                    KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> $i$f$getArguments3 = this.asContractElement(argument);
                    KtEffectDeclaration ktEffectDeclaration2 = $i$f$getArguments3 instanceof KtEffectDeclaration ? (KtEffectDeclaration)$i$f$getArguments3 : null;
                    if (ktEffectDeclaration2 != null) {
                        KtEffectDeclaration it = ktEffectDeclaration2;
                        boolean bl = false;
                        ktEffectDeclaration = new KtConditionalReturnsDeclaration(condition, it);
                    } else {
                        ktEffectDeclaration = this.asElement(new ConeContractDescriptionError.IllegalElement(argument));
                    }
                }
            } else {
                ktEffectDeclaration = this.asElement(new ConeContractDescriptionError.NotContractDsl((CallableId)((Object)resolvedId)));
            }
            ktContractDescriptionElement = ktEffectDeclaration;
        } else if (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getHOLDS_IN())) {
            KtEffectDeclaration ktEffectDeclaration;
            if (LanguageVersionUtilsKt.isEnabled(this, LanguageFeature.HoldsInContracts)) {
                FirExpression firExpression = functionCall.getExplicitReceiver();
                KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> $this$arguments$iv = firExpression != null ? this.asContractElement(firExpression) : null;
                KtBooleanExpression ktBooleanExpression = $this$arguments$iv instanceof KtBooleanExpression ? (KtBooleanExpression)$this$arguments$iv : null;
                if (ktBooleanExpression == null) {
                    ktBooleanExpression = this.noReceiver((CallableId)((Object)resolvedId));
                }
                KtBooleanExpression condition = ktBooleanExpression;
                $this$arguments$iv = functionCall;
                boolean $i$f$getArguments = false;
                KtValueParameterReference<ConeKotlinType, ConeDiagnostic> reference3 = this.asContractValueExpression(CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 0), LAMBDA_ARGUMENT_NAME);
                ktEffectDeclaration = new KtHoldsInEffectDeclaration<ConeKotlinType, ConeDiagnostic>(condition, reference3);
            } else {
                ktEffectDeclaration = this.asElement(new ConeContractDescriptionError.NotContractDsl((CallableId)((Object)resolvedId)));
            }
            ktContractDescriptionElement = ktEffectDeclaration;
        } else if (Intrinsics.areEqual(firCallableSymbol2, BOOLEAN_AND) || Intrinsics.areEqual(firCallableSymbol2, BOOLEAN_OR)) {
            LogicOperationKind logicOperationKind;
            FirCallableSymbol<?> firCallableSymbol3;
            Object right;
            Object object = functionCall.getExplicitReceiver();
            if (object == null || (object = this.asContractBooleanExpression((FirExpression)object)) == null) {
                object = this.noReceiver((CallableId)((Object)resolvedId));
            }
            Object left = object;
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            Object object2 = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
            if (object2 == null || (object2 = this.asContractBooleanExpression((FirExpression)object2)) == null) {
                object2 = right = (KtBooleanExpression)this.noArgument((CallableId)((Object)resolvedId));
            }
            if (Intrinsics.areEqual(firCallableSymbol3 = resolvedId, BOOLEAN_AND)) {
                logicOperationKind = LogicOperationKind.AND;
            } else if (Intrinsics.areEqual(firCallableSymbol3, BOOLEAN_OR)) {
                logicOperationKind = LogicOperationKind.OR;
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw new KotlinNothingValueException();
            }
            LogicOperationKind kind = logicOperationKind;
            ktContractDescriptionElement = new KtBinaryLogicExpression(left, right, kind);
        } else if (Intrinsics.areEqual(firCallableSymbol2, BOOLEAN_NOT)) {
            Object object = functionCall.getExplicitReceiver();
            if (object == null || (object = this.asContractBooleanExpression((FirExpression)object)) == null) {
                object = this.noReceiver((CallableId)((Object)resolvedId));
            }
            Object arg = object;
            ktContractDescriptionElement = new KtLogicalNot(arg);
        } else {
            ktContractDescriptionElement = this.asElement(new ConeContractDescriptionError.NotContractDsl((CallableId)((Object)resolvedId)));
        }
        return ktContractDescriptionElement;
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitBooleanOperatorExpression(@NotNull FirBooleanOperatorExpression booleanOperatorExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(booleanOperatorExpression, "booleanOperatorExpression");
        KtBooleanExpression<ConeKotlinType, ConeDiagnostic> left = this.asContractBooleanExpression(booleanOperatorExpression.getLeftOperand());
        KtBooleanExpression<ConeKotlinType, ConeDiagnostic> right = this.asContractBooleanExpression(booleanOperatorExpression.getRightOperand());
        return new KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic>(left, right, booleanOperatorExpression.getKind());
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data) {
        boolean bl;
        Intrinsics.checkNotNullParameter(equalityOperatorCall, "equalityOperatorCall");
        FirOperation operation = equalityOperatorCall.getOperation();
        switch (WhenMappings.$EnumSwitchMapping$1[operation.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            default: {
                return this.asElement(new ConeContractDescriptionError.IllegalEqualityOperator(operation));
            }
        }
        boolean isNegated = bl;
        FirCall $this$arguments$iv = equalityOperatorCall;
        boolean $i$f$getArguments = false;
        FirExpression argument = CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 1);
        FirLiteralExpression firLiteralExpression = argument instanceof FirLiteralExpression ? (FirLiteralExpression)argument : null;
        if (firLiteralExpression == null) {
            return this.asElement(new ConeContractDescriptionError.NotAConstant(argument));
        }
        FirLiteralExpression firLiteralExpression2 = firLiteralExpression;
        if (!Intrinsics.areEqual(firLiteralExpression2.getKind(), ConstantValueKind.Null.INSTANCE)) {
            return this.asElement(new ConeContractDescriptionError.IllegalConst(firLiteralExpression2, true));
        }
        FirCall $this$arguments$iv2 = equalityOperatorCall;
        boolean $i$f$getArguments2 = false;
        KtValueParameterReference<ConeKotlinType, ConeDiagnostic> arg = this.asContractValueExpression(CollectionsKt.getOrNull($this$arguments$iv2.getArgumentList().getArguments(), 0), OTHER_ARGUMENT_NAME);
        return new KtIsNullPredicate<ConeKotlinType, ConeDiagnostic>(arg, isNegated);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitSmartCastExpression(@NotNull FirSmartCastExpression smartCastExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(smartCastExpression, "smartCastExpression");
        return (KtContractDescriptionElement)smartCastExpression.getOriginalExpression().accept(this, data);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (firCallableSymbol == null) {
            ConeEffectExtractor $this$visitQualifiedAccessExpression_u24lambda_u240 = this;
            boolean bl = false;
            FirReference firReference = qualifiedAccessExpression.getCalleeReference();
            Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
            if (object == null || (object = ((FirNamedReference)object).getName()) == null) {
                Name name2 = Name.special("unresolved");
                object = name2;
                Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
            }
            Object name3 = object;
            return $this$visitQualifiedAccessExpression_u24lambda_u240.asElement(new ConeContractDescriptionError.UnresolvedCall((Name)name3));
        }
        FirCallableSymbol<?> symbol = firCallableSymbol;
        Object $this$visitQualifiedAccessExpression_u24lambda_u240 = symbol.getFir();
        FirValueParameter firValueParameter = $this$visitQualifiedAccessExpression_u24lambda_u240 instanceof FirValueParameter ? (FirValueParameter)$this$visitQualifiedAccessExpression_u24lambda_u240 : null;
        if (firValueParameter == null) {
            return new KtErroneousValueParameterReference(new ConeContractDescriptionError.IllegalParameter(symbol, "" + '\'' + symbol.getName() + "' is not a value parameter"));
        }
        FirValueParameter parameter = firValueParameter;
        Integer bl = this.valueAndContextParameters.indexOf(parameter);
        int it = ((Number)bl).intValue();
        boolean bl2 = false;
        Integer n2 = !(it < 0) ? bl : null;
        if (n2 == null) {
            return new KtErroneousValueParameterReference(new ConeContractDescriptionError.IllegalParameter(symbol, "value parameter '" + symbol.getName() + "' is not found in parameters of outer function"));
        }
        int index = n2;
        ConeKotlinType type = FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        String string = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String name4 = string;
        return this.toValueParameterReference(type, index, name4);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data);
    }

    private final KtValueParameterReference<ConeKotlinType, ConeDiagnostic> toValueParameterReference(ConeKotlinType type, int index, String name2) {
        return Intrinsics.areEqual(type, this.getSession().getBuiltinTypes().getBooleanType().getConeType()) ? (KtValueParameterReference)new KtBooleanValueParameterReference(index, name2) : new KtValueParameterReference(index, name2);
    }

    private final boolean isAccessorOf(FirContractDescriptionOwner $this$isAccessorOf, FirDeclaration declaration) {
        return declaration instanceof FirProperty && (Intrinsics.areEqual(((FirProperty)declaration).getGetter(), $this$isAccessorOf) || Intrinsics.areEqual(((FirProperty)declaration).getSetter(), $this$isAccessorOf));
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitThisReceiverExpression(@NotNull FirThisReceiverExpression thisReceiverExpression, @Nullable Void data) {
        KtContractDescriptionElement ktContractDescriptionElement;
        FirCallableDeclaration callableOwner;
        Intrinsics.checkNotNullParameter(thisReceiverExpression, "thisReceiverExpression");
        FirBasedSymbol<?> firBasedSymbol = ResolveUtilsKt.getReferencedMemberSymbol(thisReceiverExpression.getCalleeReference());
        if (firBasedSymbol == null || (firBasedSymbol = firBasedSymbol.getFir()) == null) {
            return this.asElement(new ConeContractDescriptionError.UnresolvedThis(thisReceiverExpression));
        }
        FirBasedSymbol<?> declaration = firBasedSymbol;
        FirContractDescriptionOwner firContractDescriptionOwner = this.owner;
        FirCallableDeclaration firCallableDeclaration = callableOwner = firContractDescriptionOwner instanceof FirCallableDeclaration ? (FirCallableDeclaration)((Object)firContractDescriptionOwner) : null;
        boolean ownerHasReceiver = (firCallableDeclaration != null ? firCallableDeclaration.getReceiverParameter() : null) != null;
        FirCallableDeclaration firCallableDeclaration2 = callableOwner;
        boolean ownerIsMemberOfDeclaration = Intrinsics.areEqual(firCallableDeclaration2 != null ? ResolveUtilsKt.getContainingClass(firCallableDeclaration2) : null, declaration);
        if (Intrinsics.areEqual(declaration, this.owner) || this.isAccessorOf(this.owner, (FirDeclaration)((Object)declaration)) || ownerIsMemberOfDeclaration && !ownerHasReceiver) {
            ConeKotlinType type = FirTypeUtilsKt.getResolvedType(thisReceiverExpression);
            ktContractDescriptionElement = this.toValueParameterReference(type, -1, "this");
        } else {
            ktContractDescriptionElement = this.asElement(new ConeContractDescriptionError.IllegalThis(thisReceiverExpression));
        }
        return ktContractDescriptionElement;
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitLiteralExpression(@NotNull FirLiteralExpression literalExpression, @Nullable Void data) {
        KtContractDescriptionElement ktContractDescriptionElement;
        Intrinsics.checkNotNullParameter(literalExpression, "literalExpression");
        ConstantValueKind constantValueKind = literalExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Null.INSTANCE)) {
            ktContractDescriptionElement = ConeContractConstantValues.INSTANCE.getNULL();
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Boolean.INSTANCE)) {
            KtConstantReference<ConeKotlinType, ConeDiagnostic> ktConstantReference;
            Object object = literalExpression.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
            boolean bl = (Boolean)object;
            if (bl) {
                ktConstantReference = ConeContractConstantValues.INSTANCE.getTRUE();
            } else if (!bl) {
                ktConstantReference = ConeContractConstantValues.INSTANCE.getFALSE();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ktContractDescriptionElement = ktConstantReference;
        } else {
            ktContractDescriptionElement = this.asElement(new ConeContractDescriptionError.IllegalConst(literalExpression, false));
        }
        return ktContractDescriptionElement;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data) {
        ConeContractDescriptionError coneContractDescriptionError;
        Intrinsics.checkNotNullParameter(typeOperatorCall, "typeOperatorCall");
        FirCall $this$arguments$iv = typeOperatorCall;
        boolean $i$f$getArguments = false;
        KtValueParameterReference<ConeKotlinType, ConeDiagnostic> arg = this.asContractValueExpression(CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 0), TARGET_ARGUMENT_NAME);
        ConeKotlinType type = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()));
        boolean isNegated = typeOperatorCall.getOperation() == FirOperation.NOT_IS;
        FirTypeParameterSymbol firTypeParameterSymbol = ToSymbolUtilsKt.toTypeParameterSymbol(this, type);
        if (firTypeParameterSymbol != null) {
            boolean bl;
            FirTypeParameterSymbol typeParameterSymbol;
            block10: {
                typeParameterSymbol = firTypeParameterSymbol;
                boolean bl2 = false;
                FirContractDescriptionOwner firContractDescriptionOwner = this.owner;
                FirTypeParameterRefsOwner firTypeParameterRefsOwner = firContractDescriptionOwner instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)((Object)firContractDescriptionOwner) : null;
                List<FirTypeParameterRef> list = firTypeParameterRefsOwner != null ? firTypeParameterRefsOwner.getTypeParameters() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List<FirTypeParameterRef> typeParametersOfOwner = list;
                Iterable $this$none$iv = typeParametersOfOwner;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof FirTypeParameter && Intrinsics.areEqual(((FirTypeParameter)it).getSymbol(), typeParameterSymbol))) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                coneContractDescriptionError = new ConeContractDescriptionError.NotSelfTypeParameter(typeParameterSymbol);
            } else {
                ConeContractDescriptionError.NotReifiedTypeParameter notReifiedTypeParameter;
                void condition$iv;
                boolean $this$none$iv = !typeParameterSymbol.isReified() && !LanguageVersionUtilsKt.isEnabled(this, LanguageFeature.AllowCheckForErasedTypesInContracts);
                boolean $i$f$runIf = false;
                if (condition$iv != false) {
                    boolean bl4 = false;
                    notReifiedTypeParameter = new ConeContractDescriptionError.NotReifiedTypeParameter(typeParameterSymbol);
                } else {
                    notReifiedTypeParameter = null;
                }
                coneContractDescriptionError = notReifiedTypeParameter;
            }
        } else {
            coneContractDescriptionError = null;
        }
        ConeContractDescriptionError diagnostic = coneContractDescriptionError;
        return diagnostic == null ? (KtContractDescriptionElement)new KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic>(arg, type, isNegated) : (KtContractDescriptionElement)new KtErroneousIsInstancePredicate<ConeKotlinType, Object>((KtValueParameterReference<ConeKotlinType, Object>)arg, type, isNegated, diagnostic);
    }

    private final EventOccurrencesRange parseInvocationKind(FirExpression $this$parseInvocationKind) {
        if (!($this$parseInvocationKind instanceof FirQualifiedAccessExpression)) {
            return null;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol($this$parseInvocationKind, this.getSession());
        if (firCallableSymbol == null || (firCallableSymbol = firCallableSymbol.getCallableId()) == null) {
            return null;
        }
        FirCallableSymbol<?> resolvedId = firCallableSymbol;
        FirCallableSymbol<?> firCallableSymbol2 = resolvedId;
        return Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getEXACTLY_ONCE_KIND()) ? EventOccurrencesRange.EXACTLY_ONCE : (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getAT_LEAST_ONCE_KIND()) ? EventOccurrencesRange.AT_LEAST_ONCE : (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getAT_MOST_ONCE_KIND()) ? EventOccurrencesRange.AT_MOST_ONCE : (Intrinsics.areEqual(firCallableSymbol2, ContractsDslNames.INSTANCE.getUNKNOWN_KIND()) ? EventOccurrencesRange.UNKNOWN : null)));
    }

    private final KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> noReceiver(CallableId callableId) {
        return this.asElement(new ConeContractDescriptionError.NoReceiver(callableId.getCallableName()));
    }

    private final KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> noArgument(CallableId callableId) {
        return this.asElement(new ConeContractDescriptionError.NoArgument(callableId.getCallableName()));
    }

    private final KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> asContractElement(FirElement $this$asContractElement) {
        return (KtContractDescriptionElement)$this$asContractElement.accept(this, null);
    }

    private final KtBooleanExpression<ConeKotlinType, ConeDiagnostic> asContractBooleanExpression(FirExpression $this$asContractBooleanExpression) {
        KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> element = this.asContractElement($this$asContractBooleanExpression);
        return element instanceof KtBooleanExpression ? (KtBooleanExpression)element : (KtBooleanExpression)this.asElement(new ConeContractDescriptionError.NotABooleanExpression(element));
    }

    private final KtValueParameterReference<ConeKotlinType, ConeDiagnostic> asContractValueExpression(FirExpression $this$asContractValueExpression, Name argumentName) {
        KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> element;
        FirExpression firExpression = $this$asContractValueExpression;
        KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> ktContractDescriptionElement = element = firExpression != null ? this.asContractElement(firExpression) : null;
        return element instanceof KtValueParameterReference ? (KtValueParameterReference)element : (KtValueParameterReference)new KtErroneousValueParameterReference(element == null ? (ConeContractDescriptionError)new ConeContractDescriptionError.NoArgument(argumentName) : (ConeContractDescriptionError)new ConeContractDescriptionError.NotAParameterReference(element));
    }

    static {
        Name name2 = Name.identifier("lambda");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        LAMBDA_ARGUMENT_NAME = name2;
        Name name3 = Name.identifier("other");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        OTHER_ARGUMENT_NAME = name3;
        Name name4 = Name.identifier("target");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        TARGET_ARGUMENT_NAME = name4;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor$Companion;", "", "<init>", "()V", "BOOLEAN_AND", "Lorg/jetbrains/kotlin/name/CallableId;", "BOOLEAN_OR", "BOOLEAN_NOT", "LAMBDA_ARGUMENT_NAME", "Lorg/jetbrains/kotlin/name/Name;", "OTHER_ARGUMENT_NAME", "TARGET_ARGUMENT_NAME", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            $EnumSwitchMapping$0 = new int[EventOccurrencesRange.values().length];
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_EQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IDENTITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IDENTITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

