/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.overloads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCallConflictResolver;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeCallConflictResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "chooseMaximallySpecificCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidates", "discriminateAbstracts", "", "filterOutEquivalentCalls", "", "mappedArgumentsOrderRepresentation", "", "getMappedArgumentsOrderRepresentation", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)[I", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nConeEquivalentCallConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeEquivalentCallConflictResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,145:1\n1068#2:146\n1596#2:148\n1629#2,4:149\n35#3:147\n*S KotlinDebug\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeEquivalentCallConflictResolver\n*L\n38#1:146\n83#1:148\n83#1:149,4\n57#1:147\n*E\n"})
public final class ConeEquivalentCallConflictResolver
extends ConeCallConflictResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;

    public ConeEquivalentCallConflictResolver(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates, "candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates) {
        Iterable $this$sortedBy$iv = candidates;
        boolean $i$f$sortedBy = false;
        List<Candidate> fromSourceFirst = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                Candidate it = (Candidate)a2;
                boolean bl = false;
                boolean bl2 = ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source;
                it = (Candidate)b2;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source);
            }
        });
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : fromSourceFirst) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)me).getSymbol()) == null) {
                Iterator resultIterator = result2.iterator();
                while (resultIterator.hasNext()) {
                    boolean callablesAreEquivalent;
                    Candidate otherCandidate = (Candidate)resultIterator.next();
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)other).getSymbol()) != null || !(callablesAreEquivalent = Companion.areEquivalentTopLevelCallables((FirCallableDeclaration)me, (FirCallableDeclaration)other, this.session, () -> ConeEquivalentCallConflictResolver.filterOutEquivalentCalls$lambda$1(this, myCandidate, otherCandidate)))) continue;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)other;
                    boolean $i$f$isExpect = false;
                    if (!$this$isExpect$iv.getStatus().isExpect()) continue block0;
                    $this$isExpect$iv = (FirMemberDeclaration)me;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) continue block0;
                    resultIterator.remove();
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getMappedArgumentsOrderRepresentation(Candidate $this$mappedArgumentsOrderRepresentation) {
        void $this$mapIndexedTo$iv$iv;
        Object obj = $this$mappedArgumentsOrderRepresentation.getSymbol().getFir();
        FirFunction firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction function2 = firFunction;
        Iterable $this$mapIndexed$iv = function2.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void it;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it, (int)index));
        }
        Map parametersToIndices = MapsKt.toMap((List)destination$iv$iv);
        if (!$this$mappedArgumentsOrderRepresentation.getArgumentMappingInitialized()) {
            return null;
        }
        LinkedHashMap<ConeResolutionAtom, FirValueParameter> mapping = $this$mappedArgumentsOrderRepresentation.getArgumentMapping();
        int n4 = 0;
        int n5 = mapping.size() + 1;
        int[] $i$f$mapIndexedTo22 = new int[n5];
        while (n4 < n5) {
            index$iv$iv = n4++;
            $i$f$mapIndexedTo22[index$iv$iv] = function2.getValueParameters().size();
        }
        int[] result2 = $i$f$mapIndexedTo22;
        Iterator iterator2 = ((Iterable)mapping.values()).iterator();
        n5 = 0;
        while (iterator2.hasNext()) {
            int index = n5++;
            Object t2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(t2, "next(...)");
            FirValueParameter parameter = (FirValueParameter)t2;
            Integer n6 = (Integer)parametersToIndices.get(parameter);
            if (n6 == null) {
                throw new IllegalStateException("Unmapped argument in arguments mapping".toString());
            }
            result2[index + 1] = n6;
        }
        return result2;
    }

    private static final boolean filterOutEquivalentCalls$lambda$1(ConeEquivalentCallConflictResolver this$0, Candidate $myCandidate, Candidate $otherCandidate) {
        return Arrays.equals(this$0.getMappedArgumentsOrderRepresentation($myCandidate), this$0.getMappedArgumentsOrderRepresentation($otherCandidate));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeEquivalentCallConflictResolver$Companion;", "", "<init>", "()V", "areEquivalentTopLevelCallables", "", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "second", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "argumentMappingIsEqual", "Lkotlin/Function0;", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean areEquivalentTopLevelCallables(@NotNull FirCallableDeclaration first, @NotNull FirCallableDeclaration second, @NotNull FirSession session, @Nullable Function0<Boolean> argumentMappingIsEqual) {
            Intrinsics.checkNotNullParameter(first, "first");
            Intrinsics.checkNotNullParameter(second, "second");
            Intrinsics.checkNotNullParameter(session, "session");
            if (!Intrinsics.areEqual(first.getSymbol().getCallableId(), second.getSymbol().getCallableId())) {
                return false;
            }
            if (Intrinsics.areEqual(first.getModuleData(), second.getModuleData()) && first.getModuleData().getSession().getKind() == FirSession.Kind.Source) {
                return false;
            }
            if (first instanceof FirVariable != second instanceof FirVariable) {
                return false;
            }
            Function0<Boolean> function0 = argumentMappingIsEqual;
            boolean bl = function0 != null ? !function0.invoke().booleanValue() : false;
            if (bl) {
                return false;
            }
            FirStandardOverrideChecker overrideChecker = new FirStandardOverrideChecker(session);
            return first instanceof FirProperty && second instanceof FirProperty ? overrideChecker.isOverriddenProperty(first, (FirProperty)second, true) && overrideChecker.isOverriddenProperty(second, (FirProperty)first, true) : (first instanceof FirSimpleFunction && second instanceof FirSimpleFunction ? overrideChecker.isOverriddenFunction((FirSimpleFunction)first, (FirSimpleFunction)second, true) && overrideChecker.isOverriddenFunction((FirSimpleFunction)second, (FirSimpleFunction)first, true) : false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

