/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.stats;

import io.opencensus.common.Function;
import io.opencensus.internal.Utils;
import io.opencensus.metrics.data.Exemplar;
import io.opencensus.stats.AutoValue_AggregationData_CountData;
import io.opencensus.stats.AutoValue_AggregationData_DistributionData;
import io.opencensus.stats.AutoValue_AggregationData_LastValueDataDouble;
import io.opencensus.stats.AutoValue_AggregationData_LastValueDataLong;
import io.opencensus.stats.AutoValue_AggregationData_MeanData;
import io.opencensus.stats.AutoValue_AggregationData_SumDataDouble;
import io.opencensus.stats.AutoValue_AggregationData_SumDataLong;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AggregationData {
    private AggregationData() {
    }

    public abstract <T> T match(Function<? super SumDataDouble, T> var1, Function<? super SumDataLong, T> var2, Function<? super CountData, T> var3, Function<? super DistributionData, T> var4, Function<? super LastValueDataDouble, T> var5, Function<? super LastValueDataLong, T> var6, Function<? super AggregationData, T> var7);

    @Immutable
    public static abstract class LastValueDataLong
    extends AggregationData {
        LastValueDataLong() {
        }

        public static LastValueDataLong create(long lastValue) {
            return new AutoValue_AggregationData_LastValueDataLong(lastValue);
        }

        public abstract long getLastValue();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p5.apply(this);
        }
    }

    @Immutable
    public static abstract class LastValueDataDouble
    extends AggregationData {
        LastValueDataDouble() {
        }

        public static LastValueDataDouble create(double lastValue) {
            return new AutoValue_AggregationData_LastValueDataDouble(lastValue);
        }

        public abstract double getLastValue();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p4.apply(this);
        }
    }

    @Immutable
    public static abstract class DistributionData
    extends AggregationData {
        DistributionData() {
        }

        @Deprecated
        public static DistributionData create(double mean, long count, double min, double max, double sumOfSquaredDeviations, List<Long> bucketCounts, List<Exemplar> exemplars) {
            return DistributionData.create(mean, count, sumOfSquaredDeviations, bucketCounts, exemplars);
        }

        public static DistributionData create(double mean, long count, double sumOfSquaredDeviations, List<Long> bucketCounts, List<Exemplar> exemplars) {
            List<Long> bucketCountsCopy = Collections.unmodifiableList(new ArrayList(Utils.checkNotNull(bucketCounts, "bucketCounts")));
            for (Long bucketCount : bucketCountsCopy) {
                Utils.checkNotNull(bucketCount, "bucketCount");
            }
            Utils.checkNotNull(exemplars, "exemplars");
            for (Exemplar exemplar : exemplars) {
                Utils.checkNotNull(exemplar, "exemplar");
            }
            return new AutoValue_AggregationData_DistributionData(mean, count, sumOfSquaredDeviations, bucketCountsCopy, Collections.unmodifiableList(new ArrayList<Exemplar>(exemplars)));
        }

        @Deprecated
        public static DistributionData create(double mean, long count, double min, double max, double sumOfSquaredDeviations, List<Long> bucketCounts) {
            return DistributionData.create(mean, count, sumOfSquaredDeviations, bucketCounts, Collections.emptyList());
        }

        public static DistributionData create(double mean, long count, double sumOfSquaredDeviations, List<Long> bucketCounts) {
            return DistributionData.create(mean, count, sumOfSquaredDeviations, bucketCounts, Collections.emptyList());
        }

        public abstract double getMean();

        public abstract long getCount();

        @Deprecated
        public double getMin() {
            return 0.0;
        }

        @Deprecated
        public double getMax() {
            return 0.0;
        }

        public abstract double getSumOfSquaredDeviations();

        public abstract List<Long> getBucketCounts();

        public abstract List<Exemplar> getExemplars();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p3.apply(this);
        }
    }

    @Deprecated
    @Immutable
    public static abstract class MeanData
    extends AggregationData {
        MeanData() {
        }

        public static MeanData create(double mean, long count) {
            return new AutoValue_AggregationData_MeanData(mean, count);
        }

        public abstract double getMean();

        public abstract long getCount();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return defaultFunction.apply(this);
        }
    }

    @Immutable
    public static abstract class CountData
    extends AggregationData {
        CountData() {
        }

        public static CountData create(long count) {
            return new AutoValue_AggregationData_CountData(count);
        }

        public abstract long getCount();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p2.apply(this);
        }
    }

    @Immutable
    public static abstract class SumDataLong
    extends AggregationData {
        SumDataLong() {
        }

        public static SumDataLong create(long sum) {
            return new AutoValue_AggregationData_SumDataLong(sum);
        }

        public abstract long getSum();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p1.apply(this);
        }
    }

    @Immutable
    public static abstract class SumDataDouble
    extends AggregationData {
        SumDataDouble() {
        }

        public static SumDataDouble create(double sum) {
            return new AutoValue_AggregationData_SumDataDouble(sum);
        }

        public abstract double getSum();

        @Override
        public final <T> T match(Function<? super SumDataDouble, T> p0, Function<? super SumDataLong, T> p1, Function<? super CountData, T> p2, Function<? super DistributionData, T> p3, Function<? super LastValueDataDouble, T> p4, Function<? super LastValueDataLong, T> p5, Function<? super AggregationData, T> defaultFunction) {
            return p0.apply(this);
        }
    }
}

