/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.HierarchicalClassLoaderStructureSerializer;
import org.gradle.workers.internal.TransportableActionExecutionSpec;

public class TransportableActionExecutionSpecSerializer
implements Serializer<TransportableActionExecutionSpec> {
    private static final byte FLAT = 0;
    private static final byte HIERARCHICAL = 1;
    private final Serializer<HierarchicalClassLoaderStructure> hierarchicalClassLoaderStructureSerializer = new HierarchicalClassLoaderStructureSerializer();

    public void write(Encoder encoder, TransportableActionExecutionSpec spec) throws Exception {
        encoder.writeString((CharSequence)spec.getImplementationClassName());
        Set<String> additionalServices = spec.getAdditionalWhitelistedServicesClassNames();
        encoder.writeInt(additionalServices.size());
        for (String additionalServiceClassName : additionalServices) {
            encoder.writeString((CharSequence)additionalServiceClassName);
        }
        encoder.writeString((CharSequence)spec.getBaseDir().getAbsolutePath());
        encoder.writeString((CharSequence)spec.getProjectCacheDir().getAbsolutePath());
        encoder.writeBinary(spec.getSerializedParameters());
        if (spec.getClassLoaderStructure() instanceof HierarchicalClassLoaderStructure) {
            encoder.writeByte((byte)1);
            this.hierarchicalClassLoaderStructureSerializer.write(encoder, (Object)((HierarchicalClassLoaderStructure)spec.getClassLoaderStructure()));
        } else if (spec.getClassLoaderStructure() instanceof FlatClassLoaderStructure) {
            encoder.writeByte((byte)0);
        } else {
            throw new IllegalArgumentException("Unknown classloader structure type: " + spec.getClassLoaderStructure().getClass().getSimpleName());
        }
    }

    public TransportableActionExecutionSpec read(Decoder decoder) throws Exception {
        ClassLoaderStructure classLoaderStructure;
        String implementationClassName = decoder.readString();
        int additionalServicesCount = decoder.readInt();
        HashSet<String> additionalWhitelistedServicesClassNames = new HashSet<String>(additionalServicesCount);
        for (int i = 0; i < additionalServicesCount; ++i) {
            additionalWhitelistedServicesClassNames.add(decoder.readString());
        }
        String baseDirPath = decoder.readString();
        String projectCacheDir = decoder.readString();
        byte[] serializedParameters = decoder.readBinary();
        byte classLoaderStructureTag = decoder.readByte();
        switch (classLoaderStructureTag) {
            case 0: {
                classLoaderStructure = new FlatClassLoaderStructure(null);
                break;
            }
            case 1: {
                classLoaderStructure = (ClassLoaderStructure)this.hierarchicalClassLoaderStructureSerializer.read(decoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected payload type.");
            }
        }
        return new TransportableActionExecutionSpec(implementationClassName, serializedParameters, classLoaderStructure, new File(baseDirPath), new File(projectCacheDir), additionalWhitelistedServicesClassNames);
    }
}

