/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.PlannedNodeInternal;
import org.gradle.execution.plan.ToPlannedNodeConverter;
import org.gradle.execution.plan.ToPlannedNodeConverterRegistry;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.internal.taskgraph.NodeIdentity;
import org.jspecify.annotations.Nullable;

public class PlannedNodeGraph {
    private final DetailLevel detailLevel;
    private final List<PlannedNodeInternal> plannedNodes;

    public PlannedNodeGraph(DetailLevel detailLevel, List<PlannedNodeInternal> plannedNodes) {
        this.detailLevel = detailLevel;
        this.plannedNodes = ImmutableList.copyOf(plannedNodes);
    }

    public List<? extends CalculateTaskGraphBuildOperationType.PlannedNode> getNodes(DetailLevel detailLevel) {
        if (detailLevel.level >= this.detailLevel.level) {
            return this.plannedNodes;
        }
        return this.computePlan(detailLevel);
    }

    private List<PlannedNodeInternal> computePlan(DetailLevel detailLevel) {
        HashMap<NodeIdentity, List> plannedNodeDependenciesByIdentity = new HashMap<NodeIdentity, List>();
        for (PlannedNodeInternal plannedNode : this.plannedNodes) {
            plannedNodeDependenciesByIdentity.put(plannedNode.getNodeIdentity(), plannedNode.getNodeDependencies());
        }
        Predicate<NodeIdentity> inDetailLevel = id -> detailLevel.contains(id.getNodeType());
        IdentityProvider<NodeIdentity> identityProvider = id -> inDetailLevel.test((NodeIdentity)id) ? id : null;
        DependencyTraverser<NodeIdentity> traverser = id -> {
            List deps = (List)plannedNodeDependenciesByIdentity.get(id);
            if (deps == null) {
                throw new IllegalStateException("No dependencies for node: " + id);
            }
            return deps;
        };
        ArrayList<PlannedNodeInternal> newPlannedNodes = new ArrayList<PlannedNodeInternal>();
        for (PlannedNodeInternal plannedNode : this.plannedNodes) {
            NodeIdentity nodeIdentity = plannedNode.getNodeIdentity();
            if (!inDetailLevel.test(nodeIdentity)) continue;
            List nodeDependencies = plannedNode.getNodeDependencies();
            if (nodeDependencies.isEmpty() || nodeDependencies.stream().allMatch(inDetailLevel)) {
                newPlannedNodes.add(plannedNode);
                continue;
            }
            List<NodeIdentity> newNodeDependencies = PlannedNodeGraph.computeDependencies(traverser, identityProvider, nodeIdentity);
            newPlannedNodes.add(plannedNode.withNodeDependencies(newNodeDependencies));
        }
        return newPlannedNodes;
    }

    private static <T> List<NodeIdentity> computeDependencies(DependencyTraverser<T> traverser, IdentityProvider<T> identityProvider, T start) {
        ArrayList<NodeIdentity> resultDependencies = new ArrayList<NodeIdentity>();
        ArrayDeque<T> queue = new ArrayDeque<T>(traverser.getDependencies(start));
        HashSet seen = new HashSet();
        while (!queue.isEmpty()) {
            Object node = queue.remove();
            if (!seen.add(node)) continue;
            NodeIdentity identity = identityProvider.get(node);
            if (identity == null) {
                queue.addAll(traverser.getDependencies(node));
                continue;
            }
            resultDependencies.add(identity);
        }
        return resultDependencies;
    }

    private static interface DependencyTraverser<T> {
        public Collection<? extends T> getDependencies(T var1);
    }

    private static interface IdentityProvider<T> {
        public @Nullable NodeIdentity get(T var1);
    }

    public static enum DetailLevel {
        LEVEL1_TASKS(1, NodeIdentity.NodeType.TASK),
        LEVEL2_TRANSFORM_STEPS(2, NodeIdentity.NodeType.TASK, NodeIdentity.NodeType.TRANSFORM_STEP);

        private final int level;
        private final ImmutableSet<NodeIdentity.NodeType> nodeTypes;

        private DetailLevel(int level, NodeIdentity.NodeType ... nodeTypes) {
            this.level = level;
            this.nodeTypes = Sets.immutableEnumSet(Arrays.asList(nodeTypes));
        }

        public int getLevel() {
            return this.level;
        }

        public boolean contains(NodeIdentity.NodeType nodeType) {
            return this.nodeTypes.contains((Object)nodeType);
        }

        public static DetailLevel from(Set<NodeIdentity.NodeType> nodeTypes) {
            for (DetailLevel detailLevel : DetailLevel.values()) {
                if (!detailLevel.nodeTypes.equals(nodeTypes)) continue;
                return detailLevel;
            }
            throw new IllegalStateException("Unknown detail level for node types: " + nodeTypes);
        }
    }

    public static class Collector {
        private final ToPlannedNodeConverterRegistry converterRegistry;
        private final DetailLevel detailLevel;
        private final List<PlannedNodeInternal> plannedNodes = new ArrayList<PlannedNodeInternal>();
        private final IdentityHashMap<Node, NodeIdentity> nodeIdentityCache = new IdentityHashMap();

        public Collector(ToPlannedNodeConverterRegistry converterRegistry) {
            this.converterRegistry = converterRegistry;
            this.detailLevel = DetailLevel.from(converterRegistry.getConvertedNodeTypes());
        }

        public DetailLevel getDetailLevel() {
            return this.detailLevel;
        }

        public void collectNodes(Collection<Node> nodes) {
            for (Node node : nodes) {
                ToPlannedNodeConverter converter = this.converterRegistry.getConverter(node);
                if (converter == null || !converter.isInSamePlan(node)) continue;
                List<? extends NodeIdentity> nodeDependencies = this.findNodeDependencies(node);
                PlannedNodeInternal plannedNode = converter.convert(node, nodeDependencies);
                this.plannedNodes.add(plannedNode);
            }
        }

        public PlannedNodeGraph getGraph() {
            return new PlannedNodeGraph(this.detailLevel, this.plannedNodes);
        }

        private List<? extends NodeIdentity> findNodeDependencies(Node node) {
            return PlannedNodeGraph.computeDependencies(Node::getDependencySuccessors, this::getNodeIdentityOrNull, node);
        }

        private NodeIdentity getNodeIdentityOrNull(Node node) {
            ToPlannedNodeConverter converter = this.converterRegistry.getConverter(node);
            if (converter == null) {
                return null;
            }
            return this.nodeIdentityCache.computeIfAbsent(node, converter::getNodeIdentity);
        }
    }
}

