/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MethodSet
implements Iterable<Method> {
    private final Map<MethodKey, Method> methods = new LinkedHashMap<MethodKey, Method>();

    public void add(Method method) {
        MethodKey key = new MethodKey(method);
        Method current = this.methods.get(key);
        if (current == null || this.shouldReplace(current, method)) {
            this.methods.put(key, method);
        }
    }

    private boolean shouldReplace(Method current, Method method) {
        boolean newAbstract;
        boolean currentAbstract = Modifier.isAbstract(current.getModifiers());
        if (currentAbstract != (newAbstract = Modifier.isAbstract(method.getModifiers()))) {
            return currentAbstract;
        }
        return current.isBridge() && !method.isBridge();
    }

    @Override
    public Iterator<Method> iterator() {
        return this.getValues().iterator();
    }

    public Collection<Method> getValues() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    static class MethodKey {
        private final Method method;
        private final Class<?>[] parameterTypes;

        private MethodKey(Method method) {
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey that = (MethodKey)obj;
            return Objects.equals(this.method.getName(), that.method.getName()) && Objects.equals(this.method.getReturnType(), that.method.getReturnType()) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            return Objects.hash(this.method.getName(), this.parameterTypes.length);
        }
    }
}

