/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

@ServiceScope(value={Scope.Global.class})
public class DaemonHealthCheck {
    private final DaemonExpirationStrategy strategy;
    private final DaemonExpirationListener listenerBroadcast;

    public DaemonHealthCheck(DaemonExpirationStrategy strategy, ListenerManager listenerManager) {
        this.strategy = strategy;
        this.listenerBroadcast = (DaemonExpirationListener)listenerManager.getBroadcaster(DaemonExpirationListener.class);
    }

    public void executeHealthCheck() {
        DaemonExpirationResult result = this.strategy.checkExpiration();
        if (result.getStatus() != DaemonExpirationStatus.DO_NOT_EXPIRE) {
            this.listenerBroadcast.onExpirationEvent(result);
        }
    }
}

