# -*- coding: utf-8 -*- #
# Copyright 2022 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Utilities for Immersive Stream for XR commands."""


def DefaultToGlobal():
  """Returns 'global' to be used as a fallthrough hook in resources.yaml."""
  return 'global'


def ParseContentVersionTag(content_version_tag):
  """Returns the content_version_tag as a dictionary."""
  return {'content_version_tag': content_version_tag}


def SetContentUpdateMask(unused_ref, args, request):
  if args.bucket:
    request.updateMask = 'bucketName'
  elif args.uiconfig:
    request.updateMask = 'uiconfig'
  return request
