# -*- coding: utf-8 -*- #
# Copyright 2020 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Helpers for parsing common arguments."""



def ParseSortByArg(sort_by=None):
  """Parses and creates the sort by object from parsed arguments.

  Args:
    sort_by: list of strings, passed in from the --sort-by flag.

  Returns:
    A parsed sort by string ending in asc or desc, conforming to
    https://aip.dev/132#ordering
  """
  if not sort_by:
    return None

  fields = []
  for field in sort_by:
    if field.startswith('~'):
      field = field.lstrip('~') + ' desc'
    else:
      field += ' asc'
    fields.append(field)
  return ','.join(fields)
