# -*- coding: utf-8 -*- #
# Copyright 2019 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Utilities for IAM Simulator API."""


from googlecloudsdk.api_lib.util import apis

_API_NAME = 'policysimulator'


def GetSimulatorClientAndMessages(api_version):
  client = apis.GetClientInstance(_API_NAME, api_version)
  messages = apis.GetMessagesModule(_API_NAME, api_version)
  return client, messages
