# -*- coding: utf-8 -*- #
# Copyright 2021 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""This file provides the implementation of the `functions set-iam-policy` command."""


from googlecloudsdk.api_lib.functions.v1 import util
from googlecloudsdk.command_lib.iam import iam_util


def Run(args):
  """Set the IAM policy for a Google Cloud Function."""
  client = util.GetApiClientInstance()
  messages = client.MESSAGES_MODULE
  function_ref = args.CONCEPTS.name.Parse()
  policy, update_mask = iam_util.ParseYamlOrJsonPolicyFile(
      args.policy_file, messages.Policy)
  result = client.projects_locations_functions.SetIamPolicy(
      messages.CloudfunctionsProjectsLocationsFunctionsSetIamPolicyRequest(
          resource=function_ref.RelativeName(),
          setIamPolicyRequest=messages.SetIamPolicyRequest(
              policy=policy, updateMask=update_mask)))
  iam_util.LogSetIamPolicy(function_ref.Name(), 'function')
  return result
